/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.utility;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import lombok.Generated;

public final class StationaryInitialization {
    public static FastMatrix of(ISsfDynamics dynamics, int dim) {
        if (!dynamics.isTimeInvariant()) {
            return null;
        }
        FastMatrix cov = FastMatrix.square(dim);
        FastMatrix T2 = FastMatrix.square(dim);
        FastMatrix Q = FastMatrix.square(dim);
        dynamics.T(0, T2);
        dynamics.V(0, Q);
        int np = dim * (dim + 1) / 2;
        FastMatrix M = FastMatrix.square(np);
        double[] b = new double[np];
        int i = 0;
        for (int c = 0; c < dim; ++c) {
            int r = c;
            while (r < dim) {
                b[i] = Q.get(r, c);
                M.set(i, i, 1.0);
                for (int k = 0; k < dim; ++k) {
                    double zc = T2.get(c, k);
                    if (zc == 0.0) continue;
                    for (int l = 0; l < dim; ++l) {
                        double zr = T2.get(r, l);
                        double z = zr * zc;
                        if (z == 0.0) continue;
                        int p = l <= k ? StationaryInitialization.pos(k, l, dim) : StationaryInitialization.pos(l, k, dim);
                        M.add(i, p, -z);
                    }
                }
                ++r;
                ++i;
            }
        }
        LinearSystemSolver.fastSolver().solve(M, DataBlock.of(b));
        int j = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            cov.column(i2).drop(i2, 0).copyFrom(b, j);
            j += dim - i2;
        }
        SymmetricMatrix.fromLower(cov);
        return cov;
    }

    private static int pos(int r, int c, int n) {
        return r + c * (2 * n - c - 1) / 2;
    }

    @Generated
    private StationaryInitialization() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

