/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixTransformation;
import jdplus.toolkit.base.core.math.matrices.lapack.GEMM;
import jdplus.toolkit.base.core.math.matrices.lapack.GER;
import lombok.Generated;

public final class GeneralMatrix {
    public static FastMatrix transpose(FastMatrix a) {
        FastMatrix b = FastMatrix.make(a.getColumnsCount(), a.getRowsCount());
        b.copyTranspose(a);
        return b;
    }

    public static void aXYt_p_A(double alpha, DataBlock x, DataBlock y, FastMatrix A) {
        GER.apply(alpha, DataPointer.of(x), DataPointer.of(y), A);
    }

    public static void addXYt(DataBlock x, DataBlock y, FastMatrix A) {
        GER.apply(1.0, DataPointer.of(x), DataPointer.of(y), A);
    }

    public static FastMatrix XYt(DataBlock x, DataBlock y) {
        FastMatrix A = FastMatrix.make(x.length(), y.length());
        GER.apply(1.0, DataPointer.of(x), DataPointer.of(y), A);
        return A;
    }

    public static void aAB_p_bC(double alpha, FastMatrix A, FastMatrix B, double beta, FastMatrix C, MatrixTransformation at, MatrixTransformation bt) {
        GEMM.apply(alpha, A, B, beta, C, at, bt);
    }

    public static void aAB_p_bC(double alpha, FastMatrix A, FastMatrix B, double beta, FastMatrix C) {
        GEMM.apply(alpha, A, B, beta, C, MatrixTransformation.None, MatrixTransformation.None);
    }

    public static void setAB(FastMatrix A, FastMatrix B, FastMatrix AB) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, AB, MatrixTransformation.None, MatrixTransformation.None);
    }

    public static FastMatrix AB(FastMatrix A, FastMatrix B) {
        FastMatrix R = FastMatrix.make(A.getRowsCount(), B.getColumnsCount());
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, R, MatrixTransformation.None, MatrixTransformation.None);
        return R;
    }

    public static void setABt(FastMatrix A, FastMatrix B, FastMatrix ABt) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, ABt, MatrixTransformation.None, MatrixTransformation.Transpose);
    }

    public static FastMatrix ABt(FastMatrix A, FastMatrix B) {
        FastMatrix R = FastMatrix.make(A.getRowsCount(), B.getRowsCount());
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, R, MatrixTransformation.None, MatrixTransformation.Transpose);
        return R;
    }

    public static void setAtB(FastMatrix A, FastMatrix B, FastMatrix AtB) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, AtB, MatrixTransformation.Transpose, MatrixTransformation.None);
    }

    public static FastMatrix AtB(FastMatrix A, FastMatrix B) {
        FastMatrix R = FastMatrix.make(A.getColumnsCount(), B.getColumnsCount());
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, R, MatrixTransformation.Transpose, MatrixTransformation.None);
        return R;
    }

    public static void setAtBt(FastMatrix A, FastMatrix B, FastMatrix AtBt) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, AtBt, MatrixTransformation.Transpose, MatrixTransformation.Transpose);
    }

    public static FastMatrix AtBt(FastMatrix A, FastMatrix B) {
        FastMatrix R = FastMatrix.make(A.getColumnsCount(), B.getRowsCount());
        GeneralMatrix.aAB_p_bC(1.0, A, B, 0.0, R, MatrixTransformation.Transpose, MatrixTransformation.Transpose);
        return R;
    }

    public static void addAB(FastMatrix A, FastMatrix B, FastMatrix CpAB) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 1.0, CpAB, MatrixTransformation.None, MatrixTransformation.None);
    }

    public static void addABt(FastMatrix A, FastMatrix B, FastMatrix CpABt) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 1.0, CpABt, MatrixTransformation.None, MatrixTransformation.Transpose);
    }

    public static void addAtB(FastMatrix A, FastMatrix B, FastMatrix CpAtB) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 1.0, CpAtB, MatrixTransformation.Transpose, MatrixTransformation.None);
    }

    public static void addAtBt(FastMatrix A, FastMatrix B, FastMatrix CpAtBt) {
        GeneralMatrix.aAB_p_bC(1.0, A, B, 1.0, CpAtBt, MatrixTransformation.Transpose, MatrixTransformation.Transpose);
    }

    @Generated
    private GeneralMatrix() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

