/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class NumericalDerivatives
implements IFunctionDerivatives {
    private static final int NTHREADS = Runtime.getRuntime().availableProcessors();
    private double[] eps;
    private double[] fp;
    private double[] fm;
    private double[] grad;
    private FastMatrix hessian;
    private final IFunction fn;
    private final DoubleSeq x;
    private double fx;
    private static final int NSTEPS = 2;

    public NumericalDerivatives(IFunctionPoint point, boolean sym) {
        this(point, sym, false);
    }

    public NumericalDerivatives(IFunctionPoint point, boolean sym, boolean mt) {
        this.fn = point.getFunction();
        this.fx = point.getValue();
        this.x = point.getParameters();
        int n = this.x.length();
        this.fp = new double[n];
        this.eps = new double[n];
        if (!mt || n < 2) {
            if (!sym) {
                for (int i = 0; i < n; ++i) {
                    this.eps[i] = this.fn.getDomain().epsilon(this.x, i);
                    this.checkepsilon(i);
                    this.fp[i] = this.newval(i, this.eps[i]);
                }
            } else {
                this.fm = new double[n];
                for (int i = 0; i < n; ++i) {
                    this.eps[i] = this.fn.getDomain().epsilon(this.x, i);
                    this.checkepsilon(i);
                    this.fp[i] = this.newval(i, this.eps[i]);
                    this.fm[i] = this.newval(i, -this.eps[i]);
                }
            }
        } else {
            if (!sym) {
                for (i = 0; i < n; ++i) {
                    this.eps[i] = this.fn.getDomain().epsilon(this.x, i);
                    this.checkepsilon(i);
                }
            } else {
                this.fm = new double[n];
                for (i = 0; i < n; ++i) {
                    this.eps[i] = this.fn.getDomain().epsilon(this.x, i);
                    this.checkepsilon(i);
                }
            }
            List<Callable<Void>> tasks = this.createTasks(n, sym);
            ExecutorService executorService = Executors.newFixedThreadPool(NTHREADS);
            try {
                executorService.invokeAll(tasks);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            executorService.shutdown();
        }
    }

    private void calcgrad() {
        int n = this.fn.getDomain().getDim();
        this.grad = new double[n];
        for (int i = 0; i < n; ++i) {
            this.grad[i] = this.fp[i] == this.fx ? 0.0 : (this.fm == null ? (this.fp[i] - this.fx) / this.eps[i] : (this.fp[i] - this.fm[i]) / (2.0 * this.eps[i]));
        }
    }

    private void calch() {
        int i;
        int n = this.fn.getDomain().getDim();
        double[] e = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            e[i2] = Math.sqrt(Math.abs(this.eps[i2]));
        }
        this.hessian = FastMatrix.square(n);
        DataBlock diag = this.hessian.diagonal();
        for (i = 0; i < n; ++i) {
            double di = e[i];
            double num = this.newval(i, di) - 2.0 * this.fx + this.newval(i, -di);
            if (num == 0.0 || this.eps[i] == 0.0) continue;
            diag.set(i, num / (di * di));
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double di = e[i];
                double dj = e[j];
                double num = this.newval(i, j, di / 2.0, dj / 2.0) + this.newval(i, j, -di / 2.0, -dj / 2.0) - this.newval(i, j, di / 2.0, -dj / 2.0) - this.newval(i, j, -di / 2.0, dj / 2.0);
                if (num == 0.0 || di == 0.0 || dj == 0.0) continue;
                double z = num / (di * dj);
                this.hessian.set(i, j, z);
                this.hessian.set(j, i, z);
            }
        }
    }

    private void checkepsilon(int i) {
        double eps = this.eps[i];
        if (eps == 0.0) {
            return;
        }
        DataBlock pcur = DataBlock.of(this.x);
        double pi = pcur.get(i);
        pcur.add(i, eps);
        if (this.fn.getDomain().checkBoundaries((DoubleSeq)pcur)) {
            return;
        }
        int k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= 2 && !this.fn.getDomain().checkBoundaries((DoubleSeq)pcur));
        if (k <= 2) {
            this.eps[i] = eps;
            return;
        }
        eps = -this.eps[i];
        pcur.set(i, pi + eps);
        if (this.fn.getDomain().checkBoundaries((DoubleSeq)pcur)) {
            this.eps[i] = eps;
            return;
        }
        k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= 2 && !this.fn.getDomain().checkBoundaries((DoubleSeq)pcur));
        if (k <= 2) {
            this.eps[i] = eps;
            return;
        }
        this.eps[i] = 0.0;
    }

    @Override
    public IFunction getFunction() {
        return this.fn;
    }

    @Override
    public DoubleSeq gradient() {
        if (this.grad == null) {
            this.calcgrad();
        }
        return DoubleSeq.of((double[])this.grad);
    }

    @Override
    public void hessian(FastMatrix h) {
        if (this.hessian == null) {
            this.calch();
        }
        h.copy(this.hessian);
    }

    private double newval(int i, double dx) {
        try {
            DataBlock cur = DataBlock.of(this.x);
            cur.add(i, dx);
            IFunctionPoint fn = this.fn.evaluate((DoubleSeq)cur);
            return fn.getValue();
        }
        catch (Exception err) {
            return this.fx;
        }
    }

    private double newval(int i, int j, double dxi, double dxj) {
        try {
            DataBlock cur = DataBlock.of(this.x);
            cur.add(i, dxi);
            cur.add(j, dxj);
            IFunctionPoint fn = this.fn.evaluate((DoubleSeq)cur);
            return fn.getValue();
        }
        catch (Exception err) {
            return this.fx;
        }
    }

    private List<Callable<Void>> createTasks(int n, boolean sym) {
        int i;
        ArrayList<Callable<Void>> result = new ArrayList<Callable<Void>>();
        for (i = 0; i < n; ++i) {
            result.add(new NewVal(this.fp, i, this.eps[i]));
        }
        if (sym) {
            for (i = 0; i < n; ++i) {
                result.add(new NewVal(this.fm, i, -this.eps[i]));
            }
        }
        return result;
    }

    private class NewVal
    implements Callable<Void> {
        double[] rslt;
        int pos;
        double eps;

        private NewVal(double[] rslt, int pos, double eps) {
            this.rslt = rslt;
            this.pos = pos;
            this.eps = eps;
        }

        @Override
        public Void call() throws Exception {
            try {
                DataBlock cur = DataBlock.of(NumericalDerivatives.this.x);
                cur.add(this.pos, this.eps);
                IFunctionPoint fn = NumericalDerivatives.this.fn.evaluate((DoubleSeq)cur);
                this.rslt[this.pos] = fn.getValue();
            }
            catch (Exception err) {
                this.rslt[this.pos] = NumericalDerivatives.this.fx;
            }
            return null;
        }
    }
}

