/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public enum WindowFunction {
    Square,
    Welch,
    Tukey,
    Bartlett,
    Hamming,
    Parzen;


    public DoubleUnaryOperator window() {
        switch (this.ordinal()) {
            case 1: {
                return x -> 1.0 - x * x;
            }
            case 2: {
                return x -> 0.5 * (1.0 + Math.cos(Math.PI * x));
            }
            case 3: {
                return x -> x < 0.0 ? 1.0 + x : 1.0 - x;
            }
            case 4: {
                return x -> 0.54 + 0.46 * Math.cos(Math.PI * x);
            }
            case 5: {
                return x -> {
                    double x1;
                    double d = x1 = x < 0.0 ? -x : x;
                    if (x <= 0.5) {
                        double x2 = x1 * x1;
                        double x3 = x1 * x2;
                        return 1.0 - 6.0 * x2 + 6.0 * x3;
                    }
                    double y = 1.0 - x1;
                    return 2.0 * y * y * y;
                };
            }
            case 0: {
                return x -> 1.0;
            }
        }
        return null;
    }

    public double[] discreteWindow(int m) {
        double[] win = new double[m];
        double dlen = m;
        DoubleUnaryOperator fn = this.window();
        for (int i = 0; i < m; ++i) {
            win[i] = fn.applyAsDouble((double)i / dlen);
        }
        return win;
    }

    public double compute(IntToDoubleFunction fn, int N) {
        if (N % 2 == 0) {
            throw new IllegalArgumentException("Window length should be odd");
        }
        int win2 = N / 2;
        double dlen = win2;
        DoubleUnaryOperator wfn = this.window();
        double v = fn.applyAsDouble(0) * wfn.applyAsDouble(0.0);
        for (int i = 1; i < win2; ++i) {
            v += wfn.applyAsDouble((double)i / dlen) * (fn.applyAsDouble(i) + fn.applyAsDouble(-i));
        }
        return v;
    }
}

