/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.structure.iterators.BipartiteListIterator;
import choco.kernel.memory.structure.iterators.BipartiteListRemIterator;
import choco.kernel.solver.SolverException;

public final class StoredIntBipartiteList
implements IStateIntVector {
    private final int[] list;
    private final IStateInt last;
    private BipartiteListIterator _iterator;
    private BipartiteListRemIterator _remIterator;

    public StoredIntBipartiteList(IEnvironment environment, int[] values) {
        this.list = values;
        this.last = environment.makeInt(values.length - 1);
    }

    @Override
    public int size() {
        return this.last.get() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.last.get() == -1;
    }

    @Override
    public void add(int i) {
        throw new UnsupportedOperationException("adding element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    @Override
    public void remove(int i) {
        throw new UnsupportedOperationException("removing element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    @Override
    public void removeLast() {
        this.last.add(-1);
    }

    @Override
    public int get(int index) {
        return this.list[index];
    }

    @Override
    public int quickGet(int index) {
        return this.list[index];
    }

    @Override
    public boolean contain(int val) {
        int llast = this.last.get();
        for (int i = 0; i < llast; ++i) {
            if (val != this.list[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int set(int index, int val) {
        throw new SolverException("setting an element is not permitted on this structure");
    }

    @Override
    public int quickSet(int index, int val) {
        return this.set(index, val);
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new BipartiteListIterator();
        } else if (!this._iterator.reusable()) {
            assert (false);
            this._iterator = new BipartiteListIterator();
        }
        this._iterator.init(this.list, this.last);
        return this._iterator;
    }

    public DisposableIntIterator getRemIterator() {
        if (this._remIterator == null) {
            this._remIterator = new BipartiteListRemIterator();
        } else if (!this._remIterator.reusable()) {
            assert (false);
            this._remIterator = new BipartiteListRemIterator();
        }
        this._remIterator.init(this.list, this.last);
        return this._remIterator;
    }

    public String pretty() {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i <= this.last.get(); ++i) {
            s.append(this.list[i]).append(i == this.last.get() ? "" : ",");
        }
        return s.append(']').toString();
    }
}

