% Generated by roxygen2: do not edit by hand
\name{contour}
\alias{contour}
\alias{filled.contour}
\title{Draw Contour Plots}
\arguments{
  \item{x,y}{optional numeric vectors for x and y coordinates}
  \item{z}{a numeric matrix of grid values to contour}
  \item{levels}{numeric vector specifying contour levels}
  \item{drawlabels}{logical indicating whether to label contour lines}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `col`, `lwd`, and `lty`
}
}

\details{
Draw contour lines from a matrix
\code{
(mat <- rbind(c(0, 1, 0), c(1, 2, 1), c(0, 1, 0)))
contour(mat, levels = c(.5, 1.5))
filled.contour(mat, levels = c(.5, 1.5))
contour( volcano ) # more complex example
filled.contour( volcano, key.title = title(main = "Height\n(meters)") )
}

Change limits on x and y axes (defaults range from 0 to 1)
\code{
contour(mat, levels = c(.5, 1.5), x = c(-1,0,1), y = c(-2, 0, 2))
}

Draw contour plots with custom levels and styling
\code{
levs <- seq(min(volcano), max(volcano), length.out = 10) |> pretty()
contour(volcano, levels = levs, drawlabels = TRUE, col = "red", lwd = 2)
filled.contour(volcano, color.palette = function(n) hcl.colors(n, "terrain"))
}}

