/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.html;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.helpers.FileHelper;
import ec.util.spreadsheet.html.HtmlBookReader;
import ec.util.spreadsheet.html.HtmlBookWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import lombok.NonNull;

public class HtmlBookFactory
extends Book.Factory {
    private static final String HTML_TYPE = "text/html";
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();

    @NonNull
    public String getName() {
        return "Html table";
    }

    public int getRank() {
        return 127;
    }

    public boolean canLoad() {
        return true;
    }

    @NonNull
    public Book load(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.newReader().read(file);
    }

    @NonNull
    public Book load(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return this.newReader().read(stream);
    }

    @NonNull
    public Map<String, List<String>> getExtensionsByMediaType() {
        return Collections.singletonMap(HTML_TYPE, Arrays.asList(".html", ".htm"));
    }

    public boolean accept(File pathname) {
        return FileHelper.accept((File)pathname, (DirectoryStream.Filter)((Object)this));
    }

    public boolean accept(Path file) throws IOException {
        return FileHelper.hasExtension((Path)file, (String[])new String[]{".html", ".htm"}) && (!Files.exists(file, new LinkOption[0]) || Files.size(file) > 0L);
    }

    public void store(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        this.newWriter().write(book, stream);
    }

    public boolean isSupportedDataType(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return String.class.isAssignableFrom(type);
    }

    private HtmlBookReader newReader() {
        return new HtmlBookReader();
    }

    private HtmlBookWriter newWriter() {
        return new HtmlBookWriter(this.xof);
    }
}

