/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.time_series.Algorithm;
import org.dmg.pmml.time_series.DynamicRegressor;
import org.dmg.pmml.time_series.HasDynamicRegressors;
import org.dmg.pmml.time_series.InterceptVector;
import org.dmg.pmml.time_series.MeasurementMatrix;
import org.dmg.pmml.time_series.ObservationVarianceMatrix;
import org.dmg.pmml.time_series.PMMLElements;
import org.dmg.pmml.time_series.PredictedStateCovarianceMatrix;
import org.dmg.pmml.time_series.PsiVector;
import org.dmg.pmml.time_series.SelectedStateCovarianceMatrix;
import org.dmg.pmml.time_series.StateVector;
import org.dmg.pmml.time_series.TransitionMatrix;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="StateSpaceModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "stateVector", "transitionMatrix", "measurementMatrix", "interceptVector", "predictedStateCovarianceMatrix", "selectedStateCovarianceMatrix", "observationVarianceMatrix", "psiVector", "dynamicRegressors"})
@JsonRootName(value="StateSpaceModel")
@JsonPropertyOrder(value={"variance", "period", "intercept", "extensions", "stateVector", "transitionMatrix", "measurementMatrix", "interceptVector", "predictedStateCovarianceMatrix", "selectedStateCovarianceMatrix", "observationVarianceMatrix", "psiVector", "dynamicRegressors"})
@Added(value=Version.PMML_4_4)
public class StateSpaceModel
extends Algorithm
implements HasExtensions<StateSpaceModel>,
HasDynamicRegressors<StateSpaceModel> {
    @XmlAttribute(name="variance")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="variance")
    private Number variance;
    @XmlAttribute(name="period")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="period")
    private Object period;
    @XmlAttribute(name="intercept")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="intercept")
    private Number intercept;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="StateVector", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="StateVector")
    private StateVector stateVector;
    @XmlElement(name="TransitionMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TransitionMatrix")
    private TransitionMatrix transitionMatrix;
    @XmlElement(name="MeasurementMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MeasurementMatrix")
    private MeasurementMatrix measurementMatrix;
    @XmlElement(name="InterceptVector", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="InterceptVector")
    private InterceptVector interceptVector;
    @XmlElement(name="PredictedStateCovarianceMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="PredictedStateCovarianceMatrix")
    private PredictedStateCovarianceMatrix predictedStateCovarianceMatrix;
    @XmlElement(name="SelectedStateCovarianceMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SelectedStateCovarianceMatrix")
    private SelectedStateCovarianceMatrix selectedStateCovarianceMatrix;
    @XmlElement(name="ObservationVarianceMatrix", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ObservationVarianceMatrix")
    private ObservationVarianceMatrix observationVarianceMatrix;
    @XmlElement(name="PsiVector", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="PsiVector")
    private PsiVector psiVector;
    @XmlElement(name="DynamicRegressor", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="DynamicRegressor")
    @CollectionElementType(value=DynamicRegressor.class)
    private List<DynamicRegressor> dynamicRegressors;
    private static final Object DEFAULT_PERIOD = new ObjectAdapter().unmarshal("none");
    private static final Number DEFAULT_INTERCEPT = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371275L;

    public Number getVariance() {
        return this.variance;
    }

    public StateSpaceModel setVariance(@Property(value="variance") Number variance) {
        this.variance = variance;
        return this;
    }

    public Object getPeriod() {
        if (this.period == null) {
            return DEFAULT_PERIOD;
        }
        return this.period;
    }

    public StateSpaceModel setPeriod(@Property(value="period") Object period) {
        this.period = period;
        return this;
    }

    public Number getIntercept() {
        if (this.intercept == null) {
            return DEFAULT_INTERCEPT;
        }
        return this.intercept;
    }

    public StateSpaceModel setIntercept(@Property(value="intercept") Number intercept) {
        this.intercept = intercept;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public StateSpaceModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public StateVector requireStateVector() {
        if (this.stateVector == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_STATEVECTOR);
        }
        return this.stateVector;
    }

    public StateVector getStateVector() {
        return this.stateVector;
    }

    public StateSpaceModel setStateVector(@Property(value="stateVector") StateVector stateVector) {
        this.stateVector = stateVector;
        return this;
    }

    public TransitionMatrix requireTransitionMatrix() {
        if (this.transitionMatrix == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_TRANSITIONMATRIX);
        }
        return this.transitionMatrix;
    }

    public TransitionMatrix getTransitionMatrix() {
        return this.transitionMatrix;
    }

    public StateSpaceModel setTransitionMatrix(@Property(value="transitionMatrix") TransitionMatrix transitionMatrix) {
        this.transitionMatrix = transitionMatrix;
        return this;
    }

    public MeasurementMatrix requireMeasurementMatrix() {
        if (this.measurementMatrix == null) {
            throw new MissingElementException(this, PMMLElements.STATESPACEMODEL_MEASUREMENTMATRIX);
        }
        return this.measurementMatrix;
    }

    public MeasurementMatrix getMeasurementMatrix() {
        return this.measurementMatrix;
    }

    public StateSpaceModel setMeasurementMatrix(@Property(value="measurementMatrix") MeasurementMatrix measurementMatrix) {
        this.measurementMatrix = measurementMatrix;
        return this;
    }

    public InterceptVector getInterceptVector() {
        return this.interceptVector;
    }

    public StateSpaceModel setInterceptVector(@Property(value="interceptVector") InterceptVector interceptVector) {
        this.interceptVector = interceptVector;
        return this;
    }

    public PredictedStateCovarianceMatrix getPredictedStateCovarianceMatrix() {
        return this.predictedStateCovarianceMatrix;
    }

    public StateSpaceModel setPredictedStateCovarianceMatrix(@Property(value="predictedStateCovarianceMatrix") PredictedStateCovarianceMatrix predictedStateCovarianceMatrix) {
        this.predictedStateCovarianceMatrix = predictedStateCovarianceMatrix;
        return this;
    }

    public SelectedStateCovarianceMatrix getSelectedStateCovarianceMatrix() {
        return this.selectedStateCovarianceMatrix;
    }

    public StateSpaceModel setSelectedStateCovarianceMatrix(@Property(value="selectedStateCovarianceMatrix") SelectedStateCovarianceMatrix selectedStateCovarianceMatrix) {
        this.selectedStateCovarianceMatrix = selectedStateCovarianceMatrix;
        return this;
    }

    public ObservationVarianceMatrix getObservationVarianceMatrix() {
        return this.observationVarianceMatrix;
    }

    public StateSpaceModel setObservationVarianceMatrix(@Property(value="observationVarianceMatrix") ObservationVarianceMatrix observationVarianceMatrix) {
        this.observationVarianceMatrix = observationVarianceMatrix;
        return this;
    }

    public PsiVector getPsiVector() {
        return this.psiVector;
    }

    public StateSpaceModel setPsiVector(@Property(value="psiVector") PsiVector psiVector) {
        this.psiVector = psiVector;
        return this;
    }

    @Override
    public boolean hasDynamicRegressors() {
        return this.dynamicRegressors != null && !this.dynamicRegressors.isEmpty();
    }

    @Override
    public List<DynamicRegressor> getDynamicRegressors() {
        if (this.dynamicRegressors == null) {
            this.dynamicRegressors = new ArrayList<DynamicRegressor>();
        }
        return this.dynamicRegressors;
    }

    @Override
    public StateSpaceModel addDynamicRegressors(DynamicRegressor ... dynamicRegressors) {
        this.getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getStateVector(), this.getTransitionMatrix(), this.getMeasurementMatrix(), this.getInterceptVector(), this.getPredictedStateCovarianceMatrix(), this.getSelectedStateCovarianceMatrix(), this.getObservationVarianceMatrix(), this.getPsiVector());
            }
            if (status == VisitorAction.CONTINUE && this.hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, this.getDynamicRegressors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

