/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.model.IConstraintList;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.ExpressionManager;
import choco.kernel.model.constraints.ManagerFactory;
import choco.kernel.model.variables.AbstractVariable;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.VariableType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class ComponentVariable
extends AbstractVariable {
    public static final IConstraintList NO_CONSTRAINTS_DS = new NoConstraintDataStructure();
    protected final Object parameters;
    protected String variableManager;
    protected String expressionManager;
    protected Operator operator;

    protected ComponentVariable(VariableType variableType, boolean enableOption, Object parameters, IConstraintList constraints) {
        super(variableType, enableOption, constraints);
        this.parameters = parameters;
        this.operator = Operator.NONE;
    }

    protected ComponentVariable(VariableType variableType, Object parameters, ComponentVariable ... vars) {
        super(variableType, vars, false);
        this.parameters = parameters;
    }

    public ComponentVariable(VariableType variableType, Operator operator, Object parameters, ComponentVariable ... vars) {
        this(variableType, parameters, vars);
        this.operator = operator;
    }

    public ComponentVariable(VariableType variableType, String operatorManager, Object parameters, ComponentVariable ... vars) {
        this(variableType, parameters, vars);
        this.expressionManager = operatorManager;
    }

    protected final String getComponentClass() {
        return this.variableManager;
    }

    protected final String getOperatorClass() {
        if (this.expressionManager != null) {
            return this.expressionManager;
        }
        return this.variableManager;
    }

    public final Object getParameters() {
        return this.parameters;
    }

    public final Operator getOperator() {
        return this.operator;
    }

    @Override
    public void findManager(Properties propertiesFile) {
        if (this.variableManager == null && !this.type.equals((Object)VariableType.NONE)) {
            this.variableManager = propertiesFile.getProperty(this.type.property);
        }
        if (this.expressionManager == null && !this.operator.equals((Object)Operator.NONE)) {
            this.expressionManager = propertiesFile.getProperty(this.operator.property);
        }
        if (this.variableManager == null && this.expressionManager == null) {
            throw new ModelException("Can not find " + this.type.property + " or " + this.operator.property + " in application.properties");
        }
    }

    @Override
    public VariableManager<?> getVariableManager() {
        return ManagerFactory.loadVariableManager(this.getComponentClass());
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return ManagerFactory.loadExpressionManager(this.getOperatorClass());
    }

    @Override
    public ConstraintManager<?> getConstraintManager() {
        return ManagerFactory.loadConstraintManager(this.getOperatorClass());
    }

    private static final class NoConstraintDataStructure
    implements IConstraintList {
        private NoConstraintDataStructure() {
        }

        @Override
        public void _addConstraint(Constraint c) {
        }

        @Override
        public void _removeConstraint(Constraint c) {
        }

        @Override
        public boolean _contains(Constraint c) {
            return false;
        }

        @Override
        public void removeConstraints() {
        }

        @Override
        public Constraint getConstraint(int i) {
            return null;
        }

        @Override
        public Iterator<Constraint> getConstraintIterator(Model m) {
            return Collections.emptyList().iterator();
        }

        @Override
        public Constraint[] getConstraints() {
            return NO_CONSTRAINTS;
        }

        @Override
        public int getNbConstraint(Model m) {
            return 0;
        }
    }

    protected static final class ConstraintsDataStructure
    implements IConstraintList {
        List<Constraint> constraints = new ArrayList<Constraint>(10);
        Constraint[] reuseConstraints;

        @Override
        public void _addConstraint(Constraint c) {
            this.reuseConstraints = null;
            this.constraints.add(c);
        }

        @Override
        public void _removeConstraint(Constraint c) {
            if (this.constraints.remove(c)) {
                this.reuseConstraints = null;
            }
        }

        @Override
        public boolean _contains(Constraint c) {
            return this.constraints.contains(c);
        }

        @Override
        public void removeConstraints() {
            this.constraints.clear();
            this.reuseConstraints = null;
        }

        @Override
        public Constraint getConstraint(int i) {
            return this.constraints.get(i);
        }

        @Override
        public Iterator<Constraint> getConstraintIterator(final Model m) {
            return new Iterator<Constraint>(){
                Constraint c;
                Iterator<Constraint> it;
                {
                    this.it = ConstraintsDataStructure.this.constraints.iterator();
                }

                @Override
                public boolean hasNext() {
                    block2: {
                        do {
                            if (this.it == null) {
                                return false;
                            }
                            if (!this.it.hasNext()) break block2;
                            this.c = this.it.next();
                        } while (!Boolean.TRUE.equals(m.contains(this.c)));
                        return true;
                    }
                    return false;
                }

                @Override
                public Constraint next() {
                    return this.c;
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public Constraint[] getConstraints() {
            if (this.reuseConstraints == null) {
                this.reuseConstraints = this.constraints.toArray(new Constraint[this.constraints.size()]);
            }
            return this.reuseConstraints;
        }

        @Override
        public int getNbConstraint(Model m) {
            int sum = 0;
            for (int i = 0; i < this.constraints.size(); ++i) {
                if (!Boolean.TRUE.equals(m.contains(this.constraints.get(i)))) continue;
                ++sum;
            }
            return sum;
        }
    }
}

