## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## -----------------------------------------------------------------------------
# install.packages("bml")

## ----setup--------------------------------------------------------------------
# library(bml)
# data(coalgov)
# 
# # Examine the data structure
# head(coalgov[, c("gid", "pid", "pname", "n", "finance", "dur_wkb", "event_wkb")])

## -----------------------------------------------------------------------------
# mod1 <- bml(
#   Surv(dur_wkb, event_wkb) ~ 1 + majority +
#     mm(
#       id = id(pid, gid),
#       vars = vars(finance),
#       fn = fn(w ~ 1/n, c = TRUE),
#       RE = TRUE
#     ),
#   family = "Weibull",
#   data = coalgov,
#   seed = 1
# )
# 
# summary(mod1)

## -----------------------------------------------------------------------------
# mod2 <- bml(
#   Surv(dur_wkb, event_wkb) ~ 1 +
#     majority +
#     mm(
#       id = id(pid, gid),
#       vars = vars(finance),
#       fn = fn(w ~ 1 / (1 + (n - 1) * exp(-(b0 + b1 * pseat))), c = TRUE),
#       RE = TRUE
#     ),
#   family = "Weibull",
#   priors = c("b.w ~ dnorm(0,1)"), # weakly informative prior on the weight parameters
#   data = coalgov,
#   seed = 1,
#   monitor = TRUE
# )
# 
# summary(mod2)

## -----------------------------------------------------------------------------
# # Diagnostic plot for weight parameter
# monetPlot(mod2, parameter = "b.w.1[1]", label = "Seat share effect")
# 
# # MCMC diagnostics
# mcmcDiag(mod2, parameters = "b.w.1[1]")

