/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x11;

import java.util.List;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.x13.base.api.x11.X11Loader;
import jdplus.x13.base.api.x11.X11Spec;
import lombok.Generated;
import lombok.NonNull;

public final class X11 {
    private static final X11Loader.Processor PROCESSOR = new X11Loader.Processor();

    public static void setProcessor(Processor algorithm) {
        PROCESSOR.set(algorithm);
    }

    public static Processor getProcessor() {
        return PROCESSOR.get();
    }

    public static ProcResults process(@NonNull TsData timeSeries, @NonNull X11Spec spec, List<String> items) {
        if (timeSeries == null) {
            throw new NullPointerException("timeSeries is marked non-null but is null");
        }
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        return PROCESSOR.get().process(timeSeries, spec, items);
    }

    @Generated
    private X11() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(@NonNull TsData var1, @NonNull X11Spec var2, @NonNull List<String> var3);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(TsData timeSeries, X11Spec spec, List<String> items) {
            return GenericResults.notImplemented();
        }
    }
}

