/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.arima;

import jdplus.toolkit.base.api.arima.SarmaOrders;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class SarimaOrders
implements Cloneable {
    private final int period;
    private int p;
    private int d;
    private int q;
    private int bp;
    private int bd;
    private int bq;

    public void setRegular(int p, int d, int q) {
        this.p = p;
        this.d = d;
        this.q = q;
    }

    public void setSeasonal(int bp, int bd, int bq) {
        if (this.period > 1) {
            this.bp = bp;
            this.bd = bd;
            this.bq = bq;
        }
    }

    public static SarimaOrders stationary(SarimaOrders spec) {
        SarimaOrders sspec = new SarimaOrders(spec.getPeriod());
        sspec.p = spec.p;
        sspec.q = spec.q;
        sspec.bp = spec.bp;
        sspec.bq = spec.bq;
        return sspec;
    }

    public static SarimaOrders of(SarmaOrders sspec, int d, int bd) {
        SarimaOrders spec = new SarimaOrders(sspec.getPeriod());
        spec.p = sspec.getP();
        spec.d = d;
        spec.q = sspec.getQ();
        spec.bp = sspec.getBp();
        spec.bd = bd;
        spec.bq = sspec.getBq();
        return spec;
    }

    public static SarimaOrders airline(int period) {
        SarimaOrders spec = new SarimaOrders(period);
        spec.p = 0;
        spec.d = 1;
        spec.q = 1;
        spec.bp = 0;
        if (period > 1) {
            spec.bd = 1;
            spec.bq = 1;
        }
        return spec;
    }

    public static SarimaOrders m011(int period) {
        SarimaOrders spec = new SarimaOrders(period);
        spec.p = 0;
        spec.d = 1;
        spec.q = 1;
        spec.bp = 0;
        return spec;
    }

    public void setDefault(boolean seas) {
        this.p = 0;
        this.d = 1;
        this.q = 1;
        this.bp = 0;
        if (this.period > 1 && seas) {
            this.bd = 1;
            this.bq = 1;
        }
    }

    public SarimaOrders clone() {
        try {
            return (SarimaOrders)super.clone();
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public SarmaOrders doStationary() {
        SarmaOrders arma = new SarmaOrders(this.period);
        arma.setP(this.p);
        arma.setQ(this.q);
        arma.setBp(this.bp);
        arma.setBq(this.bq);
        return arma;
    }

    public int getDifferenceOrder() {
        int diff = this.d;
        if (this.period > 1 && this.bd > 0) {
            diff += this.period * this.bd;
        }
        return diff;
    }

    public int getParametersCount() {
        return this.p + this.bp + this.q + this.bq;
    }

    public boolean isAirline(boolean seas) {
        boolean ok;
        boolean bl = ok = this.p == 0 && this.q == 1 && this.d == 1;
        if (!ok || !seas) {
            return ok;
        }
        return this.bp == 0 && this.bq == 1 && this.bd == 1;
    }

    public boolean isStationary() {
        return this.d == 0 && this.bd == 0;
    }

    public boolean isSeasonal() {
        return this.bp > 0 || this.bq > 0 || this.bd == 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.p).append(',');
        builder.append(this.getD()).append(',');
        builder.append(this.q).append(')');
        if (this.period > 1) {
            builder.append('(');
            builder.append(this.getBp()).append(',');
            builder.append(this.getBd()).append(',');
            builder.append(this.getBq()).append(')');
        }
        return builder.toString();
    }

    @Generated
    public SarimaOrders(int period) {
        this.period = period;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public int getP() {
        return this.p;
    }

    @Generated
    public int getD() {
        return this.d;
    }

    @Generated
    public int getQ() {
        return this.q;
    }

    @Generated
    public int getBp() {
        return this.bp;
    }

    @Generated
    public int getBd() {
        return this.bd;
    }

    @Generated
    public int getBq() {
        return this.bq;
    }

    @Generated
    public void setP(int p) {
        this.p = p;
    }

    @Generated
    public void setD(int d) {
        this.d = d;
    }

    @Generated
    public void setQ(int q) {
        this.q = q;
    }

    @Generated
    public void setBp(int bp) {
        this.bp = bp;
    }

    @Generated
    public void setBd(int bd) {
        this.bd = bd;
    }

    @Generated
    public void setBq(int bq) {
        this.bq = bq;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SarimaOrders)) {
            return false;
        }
        SarimaOrders other = (SarimaOrders)o;
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getP() != other.getP()) {
            return false;
        }
        if (this.getD() != other.getD()) {
            return false;
        }
        if (this.getQ() != other.getQ()) {
            return false;
        }
        if (this.getBp() != other.getBp()) {
            return false;
        }
        if (this.getBd() != other.getBd()) {
            return false;
        }
        return this.getBq() == other.getBq();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeriod();
        result = result * 59 + this.getP();
        result = result * 59 + this.getD();
        result = result * 59 + this.getQ();
        result = result * 59 + this.getBp();
        result = result * 59 + this.getBd();
        result = result * 59 + this.getBq();
        return result;
    }

    public static enum Prespecified {
        WN,
        AR,
        D1,
        DS,
        D1DS,
        R110,
        R011,
        AIRLINE,
        AUTOMATIC;

    }
}

