/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.jsoup.nodes;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.w3c.dom.NodeList;
import standalone_spreadsheet.org.jsoup.helper.Validate;
import standalone_spreadsheet.org.jsoup.helper.W3CDom;
import standalone_spreadsheet.org.jsoup.nodes.Document;
import standalone_spreadsheet.org.jsoup.nodes.Element;
import standalone_spreadsheet.org.jsoup.nodes.Node;
import standalone_spreadsheet.org.jsoup.nodes.NodeIterator;
import standalone_spreadsheet.org.jsoup.parser.HtmlTreeBuilder;
import standalone_spreadsheet.org.jsoup.parser.Parser;

final class NodeUtils {
    NodeUtils() {
    }

    static Document.OutputSettings outputSettings(Node node) {
        Document owner = node.ownerDocument();
        return owner != null ? owner.outputSettings() : new Document("").outputSettings();
    }

    static Parser parser(Node node) {
        Document doc = node.ownerDocument();
        return doc != null ? doc.parser() : new Parser(new HtmlTreeBuilder());
    }

    static <T extends Node> List<T> selectXpath(String xpath, Element el, Class<T> nodeType) {
        Validate.notEmpty(xpath);
        Validate.notNull(el);
        Validate.notNull(nodeType);
        W3CDom w3c = new W3CDom().namespaceAware(false);
        org.w3c.dom.Document wDoc = w3c.fromJsoup(el);
        org.w3c.dom.Node contextNode = w3c.contextNode(wDoc);
        NodeList nodeList = w3c.selectXpath(xpath, contextNode);
        return w3c.sourceNodes(nodeList, nodeType);
    }

    static <T extends Node> Stream<T> stream(Node start, Class<T> type) {
        NodeIterator<T> iterator = new NodeIterator<T>(start, type);
        Spliterator<T> spliterator = NodeUtils.spliterator(iterator);
        return StreamSupport.stream(spliterator, false);
    }

    static <T extends Node> Spliterator<T> spliterator(Iterator<T> iterator) {
        return Spliterators.spliteratorUnknownSize(iterator, 273);
    }
}

