/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.nbbrd.io.function.IOFunction;

@FunctionalInterface
public interface IOSupplier<T> {
    public T getWithIO() throws IOException;

    @NonNull
    default public <V> IOSupplier<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return () -> after.applyWithIO((T)this.getWithIO());
    }

    @NonNull
    default public Supplier<T> asUnchecked() {
        return () -> {
            try {
                return this.getWithIO();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T> Supplier<T> unchecked(@NonNull IOSupplier<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T> IOSupplier<T> checked(@NonNull Supplier<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return () -> {
            try {
                return o.get();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        };
    }

    @NonNull
    public static <T> IOSupplier<T> of(@Nullable T t) {
        return () -> t;
    }
}

