/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx;

import ec.util.spreadsheet.Book;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import spreadsheet.xlsx.XlsxDateSystem;
import spreadsheet.xlsx.XlsxEntryParser;
import spreadsheet.xlsx.XlsxNumberingFormat;
import spreadsheet.xlsx.XlsxPackage;
import spreadsheet.xlsx.XlsxSheetBuilder;
import spreadsheet.xlsx.internal.DefaultDateSystem;
import spreadsheet.xlsx.internal.DefaultNumberingFormat;
import spreadsheet.xlsx.internal.DefaultSheetBuilder;
import spreadsheet.xlsx.internal.MultiSheetBuilder;
import spreadsheet.xlsx.internal.SaxEntryParser;
import spreadsheet.xlsx.internal.XlsxBook;
import spreadsheet.xlsx.internal.ZipPackage;
import standalone_spreadsheet.nbbrd.io.Resource;

public final class XlsxReader {
    private final XlsxPackage.Factory packager;
    private final XlsxEntryParser.Factory entryParser;
    private final XlsxNumberingFormat.Factory numberingFormat;
    private final XlsxDateSystem.Factory dateSystem;
    private final XlsxSheetBuilder.Factory sheetBuilder;
    private static final boolean MULTI_CORE = Runtime.getRuntime().availableProcessors() > 1;

    public XlsxReader() {
        this(ZipPackage.FACTORY, SaxEntryParser.FACTORY, DefaultNumberingFormat.FACTORY, DefaultDateSystem.FACTORY, MULTI_CORE ? MultiSheetBuilder::of : DefaultSheetBuilder::of);
    }

    @NonNull
    public Book read(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.createBookOrClose(this.packager.open(file));
    }

    @NonNull
    public Book read(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return this.createBookOrClose(this.packager.open(stream));
    }

    private Book createBookOrClose(XlsxPackage pkg) throws IOException {
        try {
            return XlsxBook.create(pkg, this);
        }
        catch (IOException | Error | RuntimeException ex) {
            Resource.ensureClosed(ex, pkg);
            throw ex;
        }
    }

    @Generated
    public XlsxPackage.Factory getPackager() {
        return this.packager;
    }

    @Generated
    public XlsxEntryParser.Factory getEntryParser() {
        return this.entryParser;
    }

    @Generated
    public XlsxNumberingFormat.Factory getNumberingFormat() {
        return this.numberingFormat;
    }

    @Generated
    public XlsxDateSystem.Factory getDateSystem() {
        return this.dateSystem;
    }

    @Generated
    public XlsxSheetBuilder.Factory getSheetBuilder() {
        return this.sheetBuilder;
    }

    @Generated
    private XlsxReader(XlsxPackage.Factory packager, XlsxEntryParser.Factory entryParser, XlsxNumberingFormat.Factory numberingFormat, XlsxDateSystem.Factory dateSystem, XlsxSheetBuilder.Factory sheetBuilder) {
        this.packager = packager;
        this.entryParser = entryParser;
        this.numberingFormat = numberingFormat;
        this.dateSystem = dateSystem;
        this.sheetBuilder = sheetBuilder;
    }

    @Generated
    public @org.jspecify.annotations.NonNull XlsxReader withSheetBuilder(XlsxSheetBuilder.Factory sheetBuilder) {
        return this.sheetBuilder == sheetBuilder ? this : new XlsxReader(this.packager, this.entryParser, this.numberingFormat, this.dateSystem, sheetBuilder);
    }
}

