/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.BaseTable;
import jdplus.toolkit.base.api.util.SubArray;
import jdplus.toolkit.base.api.util.SubTable;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class Table<T>
implements BaseTable {
    private final T[] m_data;
    private final int m_nrows;
    private final int m_ncols;

    public Table(int nrows, int ncols) {
        this.m_data = new Object[nrows * ncols];
        this.m_nrows = nrows;
        this.m_ncols = ncols;
    }

    public Table(Table<T> table) {
        this.m_data = (Object[])table.m_data.clone();
        this.m_nrows = table.m_nrows;
        this.m_ncols = table.m_ncols;
    }

    public SubArray<T> column(int col) {
        return new SubArray<T>(this.m_data, col * this.m_nrows, (col + 1) * this.m_nrows, 1);
    }

    public SubTable<T> extract() {
        return new SubTable<T>(this.m_data, 0, this.m_nrows, this.m_ncols, 1, this.m_nrows);
    }

    public SubTable<T> extract(int r0, int r1, int c0, int c1) {
        return new SubTable<T>(this.m_data, r0 + c0 * this.m_nrows, r1 - r0, c1 - c0, 1, this.m_nrows);
    }

    public SubTable<T> extract(int r0, int c0, int nr, int nc, int rinc, int cinc) {
        return new SubTable<T>(this.m_data, r0 + c0 * this.m_nrows, nr, nc, rinc, cinc * this.m_nrows);
    }

    public T get(int r, int c) {
        return this.m_data[r + c * this.m_nrows];
    }

    @Override
    public int getColumnsCount() {
        return this.m_ncols;
    }

    @Override
    public int getRowsCount() {
        return this.m_nrows;
    }

    @Override
    public boolean isEmpty() {
        if (this.m_data == null) {
            return true;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] == null) continue;
            return false;
        }
        return true;
    }

    public SubArray<T> row(int row) {
        return new SubArray<T>(this.m_data, row, row + this.m_ncols * this.m_nrows, this.m_nrows);
    }

    public void set(int r, int c, T value) {
        this.m_data[r + c * this.m_nrows] = value;
    }

    public boolean copyTo(T[] buffer) {
        if (buffer.length != this.m_data.length) {
            return false;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            buffer[i] = this.m_data[i];
        }
        return true;
    }

    public boolean copyFrom(T[] buffer) {
        if (buffer.length != this.m_data.length) {
            return false;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = buffer[i];
        }
        return true;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    public boolean deepEquals(Table<T> table) {
        return Arrays.deepEquals(this.m_data, table.m_data);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.m_nrows != other.m_nrows) {
            return false;
        }
        if (this.m_ncols != other.m_ncols) {
            return false;
        }
        return Arrays.deepEquals(this.m_data, other.m_data);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Table;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.m_nrows;
        result = result * 59 + this.m_ncols;
        result = result * 59 + Arrays.deepHashCode(this.m_data);
        return result;
    }
}

