## ----setup, include = FALSE, echo = FALSE, warning = FALSE--------------------
knitr::opts_chunk$set(echo = TRUE)
knitr::opts_chunk$set(warning = FALSE)
knitr::opts_chunk$set(dev = "png", dev.args = list(type = "cairo-png"))
knitr::opts_chunk$set(fig.width = 7, fig.height = 5)

## ----include=FALSE------------------------------------------------------------
library(HaDeX2)
library(ggplot2)
library(dplyr)
library(r3dmol)

states <- unique(alpha_dat[["State"]])

states_uptake_dat <- create_state_comparison_dataset(alpha_dat, time_t = 1)
woods_diff_uptake_dat <- calculate_diff_uptake(alpha_dat, states = c(states[3], states[1]))
uptake_dat <- create_state_uptake_dataset(alpha_dat, state = states[3])
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat, state_1 = states[3], state_2 = states[1])

## -----------------------------------------------------------------------------
create_state_comparison_dataset(alpha_dat, time_t = 1) %>%
  plot_state_comparison(., fractional = TRUE) + 
  labs(x = "Position in sequence",
       y = "Fractional deuterium uptake [%]",
       title = "Measurement after 1 min of exchange")

## -----------------------------------------------------------------------------
calculate_diff_uptake(alpha_dat, states = c(states[3], states[1])) %>%
  plot_differential(., fractional = TRUE, show_houde_interval = TRUE) +
  labs(x = "Position in seqence",
       y = "Fractional deuterium uptake difference [%]",
       title = "Measurement after 1 min of uptake")

## -----------------------------------------------------------------------------
create_state_uptake_dataset(alpha_dat, state = states[3]) %>%
  plot_butterfly(., fractional = FALSE)

## ----message=FALSE------------------------------------------------------------
create_diff_uptake_dataset(alpha_dat, state_1 = states[3], state_2 = states[1]) %>%
  filter(Exposure < 1440) %>%
  plot_differential_butterfly(fractional = TRUE, show_houde_interval = TRUE) 

## -----------------------------------------------------------------------------
create_state_uptake_dataset(alpha_dat, state = states[3]) %>% 
  filter(Exposure < 1440) %>%
  plot_chiclet(show_uncertainty = TRUE, fractional = FALSE)

## -----------------------------------------------------------------------------
diff_uptake_dat %>%
  filter(Exposure < 1440 & Exposure > 0.001) %>%
  plot_differential_chiclet(show_uncertainty = TRUE, fractional = TRUE)

## ----warning = FALSE----------------------------------------------------------

p_dat <- create_p_diff_uptake_dataset(alpha_dat)

plot_volcano(p_dat, show_confidence_limits = TRUE)


## ----warning = FALSE, message = FALSE-----------------------------------------

calculate_peptide_kinetics(dat = alpha_dat) %>%
plot_uptake_curve() +
  ylim(c(0, NA))

## ----warning=FALSE------------------------------------------------------------
alpha_dat %>%
  filter(Exposure > 0) %>%
  plot_uncertainty()

## -----------------------------------------------------------------------------

p_diff_dat <- create_p_diff_uptake_dataset(dat = alpha_dat, diff_uptake_dat = diff_uptake_dat,
                                           state_1 = states[3], state_2 = states[1])
plot_manhattan(p_diff_dat, show_peptide_position  = TRUE)

## -----------------------------------------------------------------------------

kin_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN")
aggregated_dat <- create_aggregated_uptake_dataset(kin_dat)
plot_aggregated_uptake(aggregated_dat)

## -----------------------------------------------------------------------------

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat, state_1 = states[3], state_2 = states[1])
averaged_diff_dat <- create_aggregated_diff_uptake_dataset(diff_uptake_dat)
plot_aggregated_differential_uptake(averaged_diff_dat, panels = FALSE)


## ----eval=FALSE---------------------------------------------------------------
#  pdb_file_path <- system.file(package = "HaDeX2", "HaDeX/data/Model_eEF1Balpha.pdb")
#  
#  plot_aggregated_uptake_structure(aggregated_dat,
#                                   differential = FALSE,
#                                   time_t = 1,
#                                   pdb_file_path = pdb_file_path)
#  

## -----------------------------------------------------------------------------
auc_dat <- calculate_auc(create_uptake_dataset(alpha_dat))
plot_coverage_heatmap(auc_dat, value = "auc")


## -----------------------------------------------------------------------------
bex_dat <- calculate_back_exchange(alpha_dat, state = "Alpha_KSCN")
plot_coverage_heatmap(bex_dat, value = "back_exchange")


## ----echo=FALSE---------------------------------------------------------------

summary_plots <- data.frame(types = c("comparison", "Woods (differential)", "butterfly", "butterfly differential", "volcano", "chiclet", "chiclet differential", "uptake curve"),
 
                            "time course" = c(FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE),
                            "length of the peptide" = c(TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE),
                            "uncertainty" = c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE),
                            "all peptides" = c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE),
                           "different states" = c(TRUE, TRUE, FALSE, TRUE, TRUE, FALSE, TRUE, TRUE), 
                           "position" = c(TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE),
                           check.names = FALSE)

knitr::kable(summary_plots)

