/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.cmd;

import java.util.ArrayList;
import java.util.List;
import usf.saav.cmd.PairingResult;
import usf.saav.cmd.ResultList;
import usf.saav.cmd.TestResults;
import usf.saav.common.TimerNanosecond;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.pairing.MergePairing;

public class MergePairingCLI {
    static ArrayList<ReebGraph> rg = null;
    static List<String> pTypes = new ArrayList<String>();
    static List<String> vTypes = new ArrayList<String>();
    static List<Float> pValues = new ArrayList<Float>();
    static List<Float> vValues = new ArrayList<Float>();
    static List<Float> pRealValues = new ArrayList<Float>();
    static List<Float> vRealValues = new ArrayList<Float>();
    static List<Integer> pGlobalIDs = new ArrayList<Integer>();
    static List<Integer> vGlobalIDs = new ArrayList<Integer>();
    static String[] finalGraph = null;
    static double elapsedTime = 0.0;

    public static String[] getFinalGraph() {
        return finalGraph;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("");
            System.out.println("   ###################################################################################");
            System.out.println("   Propagate and pair: A single-pass approach to critical point pairing in reeb graphs");
            System.out.println("   International Symposium on Visual Computing, Springer, Cham, 2019");
            System.out.println("   Junyi Tu, Mustafa Hajij, and Paul Rosen");
            System.out.println("");
            System.out.println("   Usage:");
            System.out.println("      > java -jar ReebGraphPairingMP.jar <file1> <file2> ... <fileN>");
            System.out.println("");
        } else {
            for (String string : stringArray) {
                try {
                    System.out.println(string);
                    rg = TestResults.runAlgo(string, new MergePairing(), new TimerNanosecond(), false);
                    finalGraph = TestResults.getPersistentDiagramCSV(rg);
                    ResultList resultList = TestResults.getResultList(rg);
                    pTypes = resultList.pTypes;
                    vTypes = resultList.vTypes;
                    pValues = resultList.pValues;
                    vValues = resultList.vValues;
                    pRealValues = resultList.pRealValues;
                    vRealValues = resultList.vRealValues;
                    pGlobalIDs = resultList.pGlobalIDs;
                    vGlobalIDs = resultList.vGlobalIDs;
                    System.out.println();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void mainR(int[] nArray, float[] fArray, int[] nArray2, int[] nArray3) {
        try {
            PairingResult pairingResult = TestResults.runAlgo(nArray, fArray, nArray2, nArray3, new MergePairing(), new TimerNanosecond(), false);
            rg = pairingResult.getReebGraphArrayList();
            elapsedTime = pairingResult.getElapsedTime();
            ResultList resultList = TestResults.getResultList(rg);
            pTypes = resultList.pTypes;
            vTypes = resultList.vTypes;
            pValues = resultList.pValues;
            vValues = resultList.vValues;
            pRealValues = resultList.pRealValues;
            vRealValues = resultList.vRealValues;
            pGlobalIDs = resultList.pGlobalIDs;
            vGlobalIDs = resultList.vGlobalIDs;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static float[] convertFloatListToArray(List<Float> list) {
        float[] fArray = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fArray[i] = list.get(i).floatValue();
        }
        return fArray;
    }

    private static int[] convertIntegerListToArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    private static String[] convertStringListToArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    public static String[] getPTypes() {
        return MergePairingCLI.convertStringListToArray(pTypes);
    }

    public static String[] getVTypes() {
        return MergePairingCLI.convertStringListToArray(vTypes);
    }

    public static float[] getPRealValues() {
        return MergePairingCLI.convertFloatListToArray(pRealValues);
    }

    public static float[] getVRealValues() {
        return MergePairingCLI.convertFloatListToArray(vRealValues);
    }

    public static float[] getPValues() {
        return MergePairingCLI.convertFloatListToArray(pValues);
    }

    public static float[] getVValues() {
        return MergePairingCLI.convertFloatListToArray(vValues);
    }

    public static int[] getPGlobalIDs() {
        return MergePairingCLI.convertIntegerListToArray(pGlobalIDs);
    }

    public static int[] getVGlobalIDs() {
        return MergePairingCLI.convertIntegerListToArray(vGlobalIDs);
    }

    public static double getElapsedTime() {
        return elapsedTime;
    }
}

