ui<-

fluidPage(
#  theme=bslib::bs_theme(bootswatch="spacelab"),
#  shinythemes::themeSelector(),
  shinyjs::useShinyjs(),

  titlePanel("Comprehensive Analysis of Latent Means (CALMs)"),
  sidebarLayout(
    sidebarPanel(
      width=3,
      style="height:90vh; overflow-y:auto;",
      checkboxInput("usewos", tags$a("Use Work Orientations Survey Data (2015)",href="https://search.gesis.org/research_data/ZA6770?doi=10.4232/1.12848"),value=TRUE),
      conditionalPanel(
        condition="(!input.usewos)",
        fileInput("upload", "Upload *Meta.csv and data (.dat, .csv, or .sav)",multiple=TRUE)
      ),
      conditionalPanel(
        condition="(input.anal!='psa')&(input.anal!='check')&(input.anal!='None')",
        selectInput("usepsa", "Use matched data for invariance tests",choices=FALSE),
      ),

      selectInput("anal", "Analysis", choices = c("Check Group Equivalency"='check',"Propensity Score Analysis"='psa',
                                                  "Measurement Invariance"='mi',
                                                  "Metric Invariance"='metric',
                                                  "Scalar Invariance"='scalar',"Structural Invariance"='latent')),
      conditionalPanel(
        condition="(input.anal!='None')",
        selectInput("group", "Grouping Variable", choices = NULL),
      ),
      conditionalPanel(
        condition="((input.anal=='check') | (input.anal=='psa'))",
        selectInput("checkvars", "Covariates to Check",choices=NULL, multiple = TRUE),
      ), 
      conditionalPanel(
        condition="(input.anal=='psa')",
        selectInput("psavars", "Covariates to Equate", choices=NULL,multiple = TRUE),
        numericInput("seed", "Seed for Propensity Score Analysis",value=1234),
        checkboxInput("psaarg","Use Default call to matchit",value=TRUE),
      ), 
      conditionalPanel(
        condition="((input.anal=='mi') | (input.anal=='latent')|(input.anal=='metric')| (input.anal=='scalar'))",
        selectInput("items", "Items to Analyze",choices=NULL,multiple = TRUE),
      ),       
      conditionalPanel(
        condition="((input.anal=='metric')| (input.anal=='scalar'))",
        selectInput("scales", "Scale to Analyze",choices=NULL),
        numericInput("threshold","alpha for Model Comparison Decisions",value=.05,max=1.00),
      ),
      conditionalPanel(
        condition="((input.anal=='latent')|(input.anal=='scalar'))",
        selectInput("loadings", "Loadings to Freely Estimate",choices=NULL,multiple = TRUE)
      ),
      conditionalPanel(
        condition="(input.anal=='latent')",
        selectInput("intercepts", "Intercepts to Freely Estimate", choices=NULL,multiple = TRUE),
        selectInput("means", "Means to Freely Estimate in Structural Model", choices=NULL,multiple = TRUE),
      ),
      input_task_button("analyze", "Analyze")
    ),

mainPanel(
    width=7,
    extendShinyjs(text=jsCode,functions=NULL),
    tags$head(
      tags$script(type = "text/javascript", src = "js/index.js"),
      tags$style(type='text/css',".col-sm-8 {z-index: 999} ")
    ),   
    tabsetPanel(id="tabSelected",type="tabs",
        tabPanel(HTML(paste("Read","Me",sep="<br/>")),
          div(
            style = "height: 800px; width: 100%;overflow-y: auto; padding: 10px; border: 1px solid #ccc;",
            includeHTML("www/intro2.html")
          )
        ),
        tabPanel (HTML(paste("View","Me",sep="<br/>")),value="video",
          htmlOutput("frame")
        ),
        tabPanel (HTML(paste("View","Data",sep="<br/>")),value="data",
          DTOutput("metatab"),
          DTOutput("datatab")
        ),
        tabPanel (HTML(paste("Check Group","Equivalency",sep="<br/>")),value="check",
          h4(""),
          verbatimTextOutput("chktxt"),
          tags$head(tags$style("#chktxt{overflow-y:scroll;max-height:350px;}")),
          DTOutput("chktab")
        ),
        tabPanel (HTML(paste("Propensity Score","Analysis Setup",sep="<br/>")),value="psasetup",
          h4(""),
          uiOutput("mcall"),
          h1(""),
          htmlOutput("ccall")
        ),
        tabPanel (HTML(paste("Propensity Score","Analysis Results",sep="<br/>")),value="psa",
          h4(""),
          verbatimTextOutput("psatxt"),
          tags$head(tags$style("#psatxt{overflow-y:scroll;max-height:350px;}")),
          DTOutput("psatab")
        ),
        tabPanel (HTML(paste("Measurement","Invariance",sep="<br/>")),value="mi",
          h4(""),
          DTOutput("mitab")
        ),
        tabPanel (HTML(paste("Metric","Invariance",sep="<br/>")),value="metric",
          h4(""),
          DTOutput("metrictab"),
          textOutput("metrictxt")
        ),
        tabPanel (HTML(paste("Scalar","Invariance",sep="<br/>")),value="scalar",
          h4(""),
          DTOutput("scalartab"),
          textOutput("scalartxt")
        ),
        tabPanel (HTML(paste("Structural","Invariance",sep="<br/>")),value="latent",
          h4(""),
          DTOutput("latenttab"),
          h4(""),
          DTOutput("latenttab2")
        ),
        tabPanel(HTML(paste("","Downloads",sep="<br/>")),value="down",
               h4(""),
               downloadButton("metbut","Download meta file"),
               h4(""),
               downloadButton("datbut","Download cleaned data"),
               h4(""),
               downloadButton("chkbut","Download check group equivalency table"),
               h4(""),
               downloadButton("psabut","Download post-PSA check group equivalency table"),
               h4(""),
               downloadButton("datbut2","Download post-PSA dataset"),
               h4(""),
               downloadButton("mibut","Download measurement invariance table"),
               h4(""),
               downloadButton("mimodbut","Download measurement invariance model lavaan output"),
               h4(""),
               downloadButton("metricbut","Download metric invariance table"),
               h4(""),
               downloadButton("metricmodbut","Download metric invariance model lavaan output"),
               h4(""),
               downloadButton("scalarbut","Download scalar invariance table"),
               h4(""),
               downloadButton("scalarmodbut","Download scalar invariance model lavaan output"),
               h4(""),
               downloadButton("latentbut","Download structural invariance table"),
               h4(""),
               downloadButton("latentbut2","Download latent means table"),
               h4(""),
               downloadButton("latentmodbut","Download structural invariance model lavaan output")
        )
    )
)
)
)

