/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public abstract class AbstractOsmTileSource
implements TileSource {
    protected String name;
    protected String baseUrl;
    protected String attrImgUrl;

    public AbstractOsmTileSource(String string, String string2) {
        this(string, string2, null);
    }

    public AbstractOsmTileSource(String string, String string2, String string3) {
        this.name = string;
        this.baseUrl = string2;
        this.attrImgUrl = string3;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxZoom() {
        return 18;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int n, int n2, int n3) throws IOException {
        return "/" + n + "/" + n2 + "/" + n3 + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) throws IOException {
        return this.getBaseUrl() + this.getTilePath(n, n2, n3);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTileType() {
        return "png";
    }

    @Override
    public int getTileSize() {
        return 256;
    }

    @Override
    public Image getAttributionImage() {
        if (this.attrImgUrl != null) {
            return new ImageIcon(this.attrImgUrl).getImage();
        }
        return null;
    }

    @Override
    public boolean requiresAttribution() {
        return true;
    }

    @Override
    public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
        return "\u00a9 OpenStreetMap contributors, CC-BY-SA ";
    }

    @Override
    public String getAttributionLinkURL() {
        return "http://openstreetmap.org/";
    }

    @Override
    public String getTermsOfUseURL() {
        return "http://www.openstreetmap.org/copyright";
    }

    @Override
    public double latToTileY(double d, int n) {
        double d2 = d / 180.0 * Math.PI;
        double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
        return Math.pow(2.0, n - 1) * (Math.PI - d3) / Math.PI;
    }

    @Override
    public double lonToTileX(double d, int n) {
        return Math.pow(2.0, n - 3) * (d + 180.0) / 45.0;
    }

    @Override
    public double tileYToLat(int n, int n2) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)n / Math.pow(2.0, n2 - 1))) * 180.0 / Math.PI;
    }

    @Override
    public double tileXToLon(int n, int n2) {
        return (double)n * 45.0 / Math.pow(2.0, n2 - 3) - 180.0;
    }
}

