# License for `ColombiAPI`

This package, `ColombiAPI`, is licensed under the **GNU General Public License Version 3 (GPL-3)**.

You are free to:

- Use, modify, and distribute the package, as long as any modifications or derived works also comply with the GPL-3.
- Distribute copies of this package with attribution, keeping this license intact.

## License Text

The full text of the GNU General Public License Version 3 (GPL-3) can be found [here](https://www.gnu.org/licenses/gpl-3.0.txt).

## Note on API-Colombia

The `ColombiAPI` package depends on the `API-Colombia` for accessing data about Colombia’s diversity. The API-Colombia is an open-source project, licensed under the **MIT License**.

As per the author of `API-Colombia`, no attribution is required for using or distributing the data. However, we recommend reviewing the official [API-Colombia GitHub repository](https://github.com/Mteheran/api-colombia) for further details on the project and its MIT license, and the [API-Colombia website](https://api-colombia.com/) for more information about the data and usage terms.

---

1. **REST Countries API**  
   An open-source project that offers information about countries worldwide, including demographics, geography, and regional groupings.  
   This API is also publicly accessible and does not require authentication.  
   Website: [https://restcountries.com/](https://restcountries.com/)
   
   
2. **World Bank Open Data API**

The **World Bank Open Data API** is a RESTful web service that provides access to a vast collection of international development indicators. It allows for real-time retrieval of economic, social, and environmental data, including metrics such as GDP, population, education, and poverty levels.

This API is publicly accessible, requires **no authentication**, and returns results in either **JSON** or **XML** format. It supports filtering by country, indicator code, and year. It is widely used in data science, research, and educational contexts.


- **API documentation**: [https://datahelpdesk.worldbank.org/knowledgebase/articles/889392](https://datahelpdesk.worldbank.org/knowledgebase/articles/889392)
- **License**: [Creative Commons Attribution 4.0 International (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/)   
   
   
3.- **API: Nager.Date**
- Website: [https://date.nager.at/Api](https://date.nager.at/Api)
- License: MIT License
- Notes: The API and its source code are licensed under the MIT License. No authentication is required for the public API.
Offline or commercial usage (e.g., via Docker or NuGet packages) may be subject to separate licensing, but this does not affect the MIT licensing of the open source API.


## Note

The `ColombiAPI` package, including all its data files (.rda) and code files, is licensed under the GNU General Public License, version 3 or later (GPL-3).

## Copyright Notice

© 2025 Renzo Caceres Rossi. All rights reserved under the GPL-3.
