/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regsarima.regular.IAmiController;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.tests.LjungBox;

public class ModelController
implements IAmiController {
    private final double lb;
    private StatisticalTest lbtest;
    private double rvr;
    private double rtval;

    public ModelController(double lb) {
        this.lb = lb;
    }

    public StatisticalTest getLjungBoxTest() {
        return this.lbtest;
    }

    public boolean accept(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        RegArimaEstimation estimation = context.getEstimation();
        DoubleSeq coeff = estimation.getConcentratedLikelihood().allCoefficients();
        RegArmaModel dmodel = desc.regarima().differencedModel();
        LinearModel lm = dmodel.asLinearModel();
        DataBlock res = lm.calcResiduals(coeff);
        SarimaModel arma = (SarimaModel)dmodel.getArma();
        ArmaFilter filter = ArmaFilter.ljungBox((boolean)true);
        int nres = filter.prepare((IArimaModel)arma, res.length());
        DataBlock fres = DataBlock.make((int)nres);
        filter.apply((DoubleSeq)res, fres);
        int nobs = context.getEstimation().statistics().getEffectiveObservationsCount();
        this.rvr = Math.sqrt(fres.ssq() / (double)nobs);
        fres = fres.drop(nres - nobs, 0);
        this.calcResStat(fres);
        int sp = desc.getAnnualFrequency();
        if (!this.calcLb(fres, ModelController.calcLbLength(sp, nobs), desc.getArimaSpec().freeParametersCount())) {
            return false;
        }
        return !(1.0 - this.lbtest.getPvalue() > this.lb);
    }

    private static int calcLbLength(int sp, int nobs) {
        int lbdf;
        switch (sp) {
            case 12: {
                lbdf = 24;
                break;
            }
            case 1: {
                lbdf = 8;
                break;
            }
            default: {
                lbdf = 4 * sp;
                if (nobs > 22 || sp != 4) break;
                lbdf = 6;
            }
        }
        if (lbdf >= nobs) {
            lbdf = nobs / 2;
        }
        return lbdf;
    }

    private boolean calcLb(DataBlock res, int nlb, int nhp) {
        try {
            double mu = res.sum() / (double)res.length();
            res.sub(mu);
            this.lbtest = new LjungBox((DoubleSeq)res).autoCorrelationsCount(nlb).hyperParametersCount(nhp).build();
            return true;
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    private void calcResStat(DataBlock res) {
        double rm = res.sum();
        double rv = res.ssq();
        int n = res.length();
        rv = rv / (double)n - (rm /= (double)n) * rm;
        double rstd = Math.sqrt(rv / (double)n);
        this.rtval = rm / rstd;
    }

    public double getRTval() {
        return this.rtval;
    }

    public double getRvr() {
        return this.rvr;
    }
}

