*-------------------------------------------------------------------------*
|              SAS DATA DEFINITION STATEMENTS FOR ICPSR 3447              |
|                                                                         |
|          UNIFORM CRIME REPORTING PROGRAM DATA: [UNITED STATES]          |
|                                                                         |
|              OFFENSES KNOWN AND CLEARANCES BY ARREST, 2000              |
|                                                                         |
|                                                                         |
| This SAS setup file contains the following statements:                  |
|                                                                         |
| PROC FORMAT:  Creates user-defined formats. Formats replace original    |
| value codes with value code descriptions. Formats may not be present    |
| for all variables in the data file.                                     |
|                                                                         |
| DATA:  Begins a SAS data step and names an output SAS data set.         |
|                                                                         |
| INFILE:  Specifies the input data file to be read with the input        |
| statement. Users must replace "file-specification" with a complete      |
| statement of the location of the data file.                             |
|                                                                         |
| INPUT:  Assigns the name, type, decimal specification (if any), and     |
| identifies variable beginning and ending column locations.              |
|                                                                         |
| LABEL:  Assigns descriptive labels to variables. Variable labels and    |
| variable names may be identical for certain variables.                  |
|                                                                         |
| FORMAT:  Associates the formats created by the PROC FORMAT step with    |
| the variables named in the INPUT statement. Format statements may not   |
| be present for all variables in the data file.                          |
|                                                                         |
| NOTE:  Users should modify this SAS setup file to suit their specific   |
| needs. PROC FORMAT and FORMAT sections have been marked by SAS comment  |
| statements. To include these sections in a final SAS setup, users       |
| should remove the SAS comment statements from the desired section(s).   |
*-------------------------------------------------------------------------;
                                                                           
* SAS PROC FORMAT;                                                         
                                                                           
/*                                                                         
PROC FORMAT;                                                               
   VALUE V1FT (MAX=40)                                                     
   1 = "Offenses known";                                                   
   VALUE V2FT (MAX=40)                                                     
   1 = "Alabama"                                                           
   2 = "Arizona"                                                           
   3 = "Arkansas"                                                          
   4 = "California"                                                        
   5 = "Colorado"                                                          
   6 = "Connecticut"                                                       
   7 = "Delaware"                                                          
   8 = "District of Columbia"                                              
   9 = "Florida"                                                           
   10 = "Georgia"                                                          
   11 = "Idaho"                                                            
   12 = "Illinois"                                                         
   13 = "Indiana"                                                          
   14 = "Iowa"                                                             
   15 = "Kansas"                                                           
   16 = "Kentucky"                                                         
   17 = "Louisiana"                                                        
   18 = "Maine"                                                            
   19 = "Maryland"                                                         
   20 = "Massachusetts"                                                    
   21 = "Michigan"                                                         
   22 = "Minnesota"                                                        
   23 = "Mississippi"                                                      
   24 = "Missouri"                                                         
   25 = "Montana"                                                          
   26 = "Nebraska"                                                         
   27 = "Nevada"                                                           
   28 = "New Hampshire"                                                    
   29 = "New Jersey"                                                       
   30 = "New Mexico"                                                       
   31 = "New York"                                                         
   32 = "North Carolina"                                                   
   33 = "North Dakota"                                                     
   34 = "Ohio"                                                             
   35 = "Oklahoma"                                                         
   36 = "Oregon"                                                           
   37 = "Pennsylvania"                                                     
   38 = "Rhode Island"                                                     
   39 = "South Carolina"                                                   
   40 = "South Dakota"                                                     
   41 = "Tennessee"                                                        
   42 = "Texas"                                                            
   43 = "Utah"                                                             
   44 = "Vermont"                                                          
   45 = "Virginia"                                                         
   46 = "Washington"                                                       
   47 = "West Virginia"                                                    
   48 = "Wisconsin"                                                        
   49 = "Wyoming"                                                          
   50 = "Alaska"                                                           
   51 = "Hawaii"                                                           
   52 = "Canal Zone"                                                       
   53 = "Puerto Rico"                                                      
   54 = "American Samoa"                                                   
   55 = "Guam"                                                             
   62 = "Virgin Islands";                                                  
   VALUE $V4FT                                                             
   "0" = "Possessions"                                                     
   "1" = "ALL cit 250,000 +"                                               
   "1A" = "Cit 1,000,000 +"                                                
   "1B" = "Cit 500,000-999,999"                                            
   "1C" = "Cit 250,000-499,999"                                            
   "2" = "Cit 100,000-249,999"                                             
   "3" = "Cit 50,000-99,999"                                               
   "4" = "Cit 25,000-49,999"                                               
   "5" = "Cit 10,000-24,999"                                               
   "6" = "Cit 2,500-9,999"                                                 
   "7" = "Cit < 2,500"                                                     
   "8" = "Non-MSA co."                                                     
   "8A" = "Non-MSA co. 100,000 +"                                          
   "8B" = "Non-MSA co. 25,000-99,999"                                      
   "8C" = "Non-MSA co. 10,000-24,999"                                      
   "8D" = "Non-MSA co. < 10,000"                                           
   "8E" = "Non-MSA St Police"                                              
   "9" = "MSA counties"                                                    
   "9A" = "MSA co. 100,000 +"                                              
   "9B" = "MSA co. 25,000-99,999"                                          
   "9C" = "MSA co. 10,000-24,999"                                          
   "9D" = "MSA co. < 10,000"                                               
   "9E" = "MSA St Police";                                                 
   VALUE V5FT (MAX=40)                                                     
   0 = "Possessions"                                                       
   1 = "New England States"                                                
   2 = "Middle Atlantic States"                                            
   3 = "East North Central States"                                         
   4 = "West North Central States"                                         
   5 = "South Atlantic States"                                             
   6 = "East South Central States"                                         
   7 = "West South Central States"                                         
   8 = "Mountain States"                                                   
   9 = "Pacific States";                                                   
   VALUE $V8FT                                                             
   "N" = "No, not core city of MSA"                                        
   "Y" = "Yes, core city of MSA";                                          
   VALUE V12FT (MAX=40)                                                    
   0 = "No months reported"                                                
   1 = "Jan last reported"                                                 
   2 = "Feb last reported"                                                 
   3 = "March last reported"                                               
   4 = "April last reported"                                               
   5 = "May last reported"                                                 
   6 = "June last reported"                                                
   7 = "July last reported"                                                
   8 = "August last reported"                                              
   9 = "Sep last reported"                                                 
   10 = "Oct last reported"                                                
   11 = "Nov last reported"                                                
   12 = "Dec last reported";                                               
   VALUE V13FT (MAX=40)                                                    
   0 = "US Park &  State Police"                                           
   1 = "All other agencies";                                               
   VALUE $V23FT                                                            
   "N" = "No, do not send a follow-up"                                     
   "Y" = "Yes, send a follow-up";                                          
   VALUE V24FT (MAX=40)                                                    
   0 = "Not special mail group agency"                                     
   1 = "Return sent to another agency"                                     
   2 = "Small city sent a large city form"                                 
   7 = "Agency-non-contributor, not sent form"                             
   9 = "Agency-contributor, not on mail list";                             
   VALUE $V25FT                                                            
   "N" = "Not a special mailing address"                                   
   "Y" = "Special mailing address";                                        
   VALUE V33FT (MAX=40)                                                    
   0 = "Jan not w oth month";                                              
   VALUE V34FT (MAX=40)                                                    
   0 = "Not updated";                                                      
   VALUE V35FT (MAX=40)                                                    
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V36FT (MAX=40)                                                    
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V37FT (MAX=40)                                                    
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V38FT (MAX=40)                                                    
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V39FT (MAX=40)                                                    
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V40FT                                                            
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V41FT                                                            
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V42FT                                                            
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V43FT                                                            
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V151FT (MAX=40)                                                   
   0 = "Feb not w oth month";                                              
   VALUE V152FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V153FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V154FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V155FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V156FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V157FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V158FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V159FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V160FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V161FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V269FT (MAX=40)                                                   
   0 = "Mar not w oth month";                                              
   VALUE V270FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V271FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V272FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V273FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V274FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V275FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V276FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V277FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V278FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V279FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V387FT (MAX=40)                                                   
   0 = "Apr not w oth month";                                              
   VALUE V388FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V389FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V390FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V391FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V392FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V393FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V394FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V395FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V396FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V397FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V505FT (MAX=40)                                                   
   0 = "May not w oth month";                                              
   VALUE V506FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V507FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V508FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V509FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V510FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V511FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V512FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V513FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V514FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V515FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V623FT (MAX=40)                                                   
   0 = "June not w oth month";                                             
   VALUE V624FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V625FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V626FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V627FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V628FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V629FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V630FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V631FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V632FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V633FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V741FT (MAX=40)                                                   
   0 = "July not w oth month";                                             
   VALUE V742FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V743FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V744FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V745FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V746FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V747FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V748FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V749FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V750FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V751FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V859FT (MAX=40)                                                   
   0 = "Aug not w oth month";                                              
   VALUE V860FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V861FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V862FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V863FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V864FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V865FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V866FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V867FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V868FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V869FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V977FT (MAX=40)                                                   
   0 = "Sep not w oth month";                                              
   VALUE V978FT (MAX=40)                                                   
   0 = "Not updated";                                                      
   VALUE V979FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V980FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V981FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V982FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V983FT (MAX=40)                                                   
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V984FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V985FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V986FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V987FT                                                           
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V1095FT (MAX=40)                                                  
   0 = "Oct not w oth month";                                              
   VALUE V1096FT (MAX=40)                                                  
   0 = "Not updated";                                                      
   VALUE V1097FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1098FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1099FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1100FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1101FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V1102FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1103FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1104FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1105FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V1213FT (MAX=40)                                                  
   0 = "Nov not w oth month";                                              
   VALUE V1214FT (MAX=40)                                                  
   0 = "Not updated";                                                      
   VALUE V1215FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1216FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1217FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1218FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1219FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V1220FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1221FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1222FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1223FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE V1331FT (MAX=40)                                                  
   0 = "Dec not w oth month";                                              
   VALUE V1332FT (MAX=40)                                                  
   0 = "Not updated";                                                      
   VALUE V1333FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1334FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1335FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1336FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE V1337FT (MAX=40)                                                  
   0 = "Not updated"                                                       
   2 = "Adjustment"                                                        
   4 = "Not available"                                                     
   5 = "Normal return";                                                    
   VALUE $V1338FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1339FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1340FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
   VALUE $V1341FT                                                          
   " " = "No return received"                                              
   "0" = "Missing"                                                         
   "P" = "Breakdown offenses"                                              
   "T" = "Totals only";                                                    
*/                                                                         
                                                                           
                                                                           
* SAS DATA, INFILE, INPUT STATEMENTS;                                      
                                                                           
DATA;                                                                      
INFILE "file-specification" LRECL=3760;                                    
INPUT                                                                      
   V1  1                    V2  2-3                  V3 $ 4-10             
   V4 $ 11-12               V5  13                   V6  14-17             
   V7  18-22                V8 $ 23                  V9 $ 24-30            
   V10  31-38               V11  39-42               V12  43-44            
   V13  45                  V14  46-52               V15  53-55            
   V16  56-58               V17  59-63               V18  64-66            
   V19  67-69               V20  70-74               V21  75-77            
   V22  78-80               V23 $ 81                 V24  82               
   V25 $ 83                 V26 $ 84-107             V27 $ 108-113         
   V28 $ 114-143            V29 $ 144-173            V30 $ 174-203         
   V31 $ 204-232            V32  233-237             V33  238              
   V34  239-246             V35  247                 V36  248              
   V37  249                 V38  250                 V39  251              
   V40 $ 252                V41 $ 253                V42 $ 254             
   V43 $ 255                V44  256                 V45  257              
   V46  258-259             V47  260-261             V48  262              
   V49  263-264             V50  265-266             V51  267              
   V52  268                 V53  269-270             V54  271-273          
   V55  274-275             V56  276-277             V57  278-279          
   V58  280-281             V59  282-284             V60  285-287          
   V61  288-290             V62  291-292             V63  293-295          
   V64  296-298             V65  299-301             V66  302-304          
   V67  305-306             V68  307                 V69  308-310          
   V70  311-312             V71  313                 V72  314-316          
   V73  317-319             V74  320-321             V75  322-325          
   V76  326-328             V77  329-331             V78  332-335          
   V79  336-338             V80  339-342             V81  343-345          
   V82  346-348             V83  349-352             V84  353-356          
   V85  357-360             V86  361-364             V87  365-368          
   V88  369-372             V89  373-375             V90  376-380          
   V91  381-384             V92  385-388             V93  389-391          
   V94  392-394             V95  395-399             V96  400-401          
   V97  402                 V98  403-404             V99  405-406          
   V100  407-408            V101  409-411            V102  412-414         
   V103  415-417            V104  418-420            V105  421-423         
   V106  424-427            V107  428-430            V108  431-433         
   V109  434-436            V110  437-440            V111  441-444         
   V112  445-447            V113  448-450            V114  451-453         
   V115  454-455            V116  456-459            V117  460-462         
   V118  463-465            V119  466-467            V120  468-469         
   V121  470-473            V122  474                V123  475             
   V124  476                V125  477                V126  478             
   V127  479-480            V128  481-482            V129  483             
   V130  484                V131  485-486            V132  487-489         
   V133  490-491            V134  492-493            V135  494-495         
   V136  496-497            V137  498-500            V138  501-502         
   V139  503-504            V140  505-506            V141  507             
   V142  508-510            V143  511-512            V144  513-514         
   V145  515-516            V146  517-518            V147  519-521         
   V148  522                V149  523                V150  524-526         
   V151  527                V152  528-535            V153  536             
   V154  537                V155  538                V156  539             
   V157  540                V158 $ 541               V159 $ 542            
   V160 $ 543               V161 $ 544               V162  545             
   V163  546                V164  547-548            V165  549-550         
   V166  551                V167  552-553            V168  554-555         
   V169  556                V170  557                V171  558             
   V172  559-561            V173  562-563            V174  564             
   V175  565-566            V176  567-568            V177  569-571         
   V178  572-574            V179  575-577            V180  578-580         
   V181  581-583            V182  584-586            V183  587-589         
   V184  590-592            V185  593-594            V186  595-596         
   V187  597-599            V188  600-601            V189  602             
   V190  603-605            V191  606-608            V192  609-610         
   V193  611-614            V194  615-617            V195  618-620         
   V196  621-624            V197  625-627            V198  628-631         
   V199  632-634            V200  635-637            V201  638-641         
   V202  642-645            V203  646-649            V204  650-653         
   V205  654-657            V206  658-661            V207  662-664         
   V208  665-669            V209  670-673            V210  674-677         
   V211  678-680            V212  681-683            V213  684-688         
   V214  689-690            V215  691                V216  692-693         
   V217  694-695            V218  696                V219  697-699         
   V220  700-702            V221  703-705            V222  706-708         
   V223  709-711            V224  712-715            V225  716-718         
   V226  719-721            V227  722-724            V228  725-727         
   V229  728-731            V230  732-734            V231  735-737         
   V232  738-740            V233  741-742            V234  743-746         
   V235  747-749            V236  750-752            V237  753-754         
   V238  755-756            V239  757-760            V240  761             
   V241  762                V242  763                V243  764             
   V244  765                V245  766-767            V246  768-769         
   V247  770                V248  771                V249  772-773         
   V250  774-776            V251  777-778            V252  779-780         
   V253  781-782            V254  783-784            V255  785-787         
   V256  788-789            V257  790-791            V258  792-793         
   V259  794                V260  795-797            V261  798-799         
   V262  800-801            V263  802                V264  803-804         
   V265  805-807            V266  808                V267  809             
   V268  810-812            V269  813                V270  814-821         
   V271  822                V272  823                V273  824             
   V274  825                V275  826                V276 $ 827            
   V277 $ 828               V278 $ 829               V279 $ 830            
   V280  831                V281  832                V282  833-834         
   V283  835-836            V284  837                V285  838-839         
   V286  840                V287  841                V288  842             
   V289  843                V290  844-846            V291  847-848         
   V292  849-850            V293  851-852            V294  853-854         
   V295  855-857            V296  858-860            V297  861-863         
   V298  864-866            V299  867-869            V300  870-872         
   V301  873-875            V302  876-878            V303  879-880         
   V304  881-882            V305  883-885            V306  886-887         
   V307  888                V308  889-891            V309  892-894         
   V310  895-896            V311  897-900            V312  901-903         
   V313  904-906            V314  907-909            V315  910-912         
   V316  913-916            V317  917-919            V318  920-923         
   V319  924-927            V320  928-931            V321  932-935         
   V322  936-939            V323  940-943            V324  944-947         
   V325  948-950            V326  951-955            V327  956-959         
   V328  960-963            V329  964-966            V330  967-969         
   V331  970-974            V332  975-976            V333  977             
   V334  978-979            V335  980-981            V336  982-983         
   V337  984-986            V338  987-989            V339  990-992         
   V340  993-995            V341  996-998            V342  999-1002        
   V343  1003-1005          V344  1006-1008          V345  1009-1012       
   V346  1013-1015          V347  1016-1019          V348  1020-1022       
   V349  1023-1025          V350  1026-1028          V351  1029-1030       
   V352  1031-1034          V353  1035-1037          V354  1038-1040       
   V355  1041-1042          V356  1043-1044          V357  1045-1048       
   V358  1049               V359  1050               V360  1051-1052       
   V361  1053-1054          V362  1055               V363  1056-1057       
   V364  1058-1059          V365  1060               V366  1061            
   V367  1062-1063          V368  1064-1066          V369  1067-1068       
   V370  1069-1070          V371  1071-1072          V372  1073-1074       
   V373  1075-1077          V374  1078-1079          V375  1080-1081       
   V376  1082-1083          V377  1084               V378  1085-1087       
   V379  1088-1089          V380  1090-1091          V381  1092-1093       
   V382  1094-1095          V383  1096-1098          V384  1099            
   V385  1100               V386  1101-1103          V387  1104            
   V388  1105-1112          V389  1113               V390  1114            
   V391  1115               V392  1116               V393  1117            
   V394 $ 1118              V395 $ 1119              V396 $ 1120           
   V397 $ 1121              V398  1122               V399  1123            
   V400  1124-1125          V401  1126-1127          V402  1128            
   V403  1129-1130          V404  1131-1132          V405  1133            
   V406  1134               V407  1135-1136          V408  1137-1139       
   V409  1140-1141          V410  1142-1143          V411  1144-1145       
   V412  1146-1147          V413  1148-1150          V414  1151-1153       
   V415  1154-1156          V416  1157-1159          V417  1160-1162       
   V418  1163-1165          V419  1166-1168          V420  1169-1171       
   V421  1172-1173          V422  1174-1175          V423  1176-1178       
   V424  1179-1180          V425  1181               V426  1182-1184       
   V427  1185-1187          V428  1188-1189          V429  1190-1193       
   V430  1194-1196          V431  1197-1199          V432  1200-1202       
   V433  1203-1205          V434  1206-1209          V435  1210-1212       
   V436  1213-1215          V437  1216-1219          V438  1220-1223       
   V439  1224-1227          V440  1228-1231          V441  1232-1235       
   V442  1236-1239          V443  1240-1242          V444  1243-1247       
   V445  1248-1251          V446  1252-1255          V447  1256-1258       
   V448  1259-1261          V449  1262-1266          V450  1267-1268       
   V451  1269               V452  1270-1271          V453  1272-1273       
   V454  1274-1275          V455  1276-1278          V456  1279-1281       
   V457  1282-1284          V458  1285-1287          V459  1288-1290       
   V460  1291-1294          V461  1295-1297          V462  1298-1300       
   V463  1301-1304          V464  1305-1307          V465  1308-1311       
   V466  1312-1314          V467  1315-1317          V468  1318-1320       
   V469  1321-1322          V470  1323-1326          V471  1327-1329       
   V472  1330-1332          V473  1333-1334          V474  1335-1336       
   V475  1337-1340          V476  1341               V477  1342            
   V478  1343-1344          V479  1345-1346          V480  1347            
   V481  1348-1349          V482  1350-1351          V483  1352            
   V484  1353               V485  1354-1355          V486  1356-1358       
   V487  1359-1360          V488  1361-1362          V489  1363-1364       
   V490  1365-1366          V491  1367-1369          V492  1370-1371       
   V493  1372-1373          V494  1374-1375          V495  1376-1377       
   V496  1378-1380          V497  1381-1382          V498  1383-1384       
   V499  1385-1386          V500  1387-1388          V501  1389-1391       
   V502  1392               V503  1393               V504  1394-1396       
   V505  1397               V506  1398-1405          V507  1406            
   V508  1407               V509  1408               V510  1409            
   V511  1410               V512 $ 1411              V513 $ 1412           
   V514 $ 1413              V515 $ 1414              V516  1415            
   V517  1416               V518  1417-1418          V519  1419-1420       
   V520  1421               V521  1422-1423          V522  1424-1425       
   V523  1426               V524  1427               V525  1428-1429       
   V526  1430-1432          V527  1433-1434          V528  1435-1436       
   V529  1437-1438          V530  1439-1440          V531  1441-1443       
   V532  1444-1446          V533  1447-1449          V534  1450-1452       
   V535  1453-1455          V536  1456-1458          V537  1459-1461       
   V538  1462-1464          V539  1465-1466          V540  1467-1468       
   V541  1469-1471          V542  1472-1473          V543  1474            
   V544  1475-1477          V545  1478-1480          V546  1481-1482       
   V547  1483-1486          V548  1487-1489          V549  1490-1492       
   V550  1493-1496          V551  1497-1499          V552  1500-1503       
   V553  1504-1506          V554  1507-1510          V555  1511-1514       
   V556  1515-1518          V557  1519-1522          V558  1523-1526       
   V559  1527-1530          V560  1531-1534          V561  1535-1537       
   V562  1538-1542          V563  1543-1546          V564  1547-1550       
   V565  1551-1553          V566  1554-1556          V567  1557-1561       
   V568  1562-1563          V569  1564               V570  1565-1566       
   V571  1567-1568          V572  1569-1570          V573  1571-1573       
   V574  1574-1576          V575  1577-1579          V576  1580-1582       
   V577  1583-1585          V578  1586-1589          V579  1590-1592       
   V580  1593-1595          V581  1596-1599          V582  1600-1602       
   V583  1603-1606          V584  1607-1609          V585  1610-1612       
   V586  1613-1615          V587  1616-1617          V588  1618-1621       
   V589  1622-1624          V590  1625-1627          V591  1628-1629       
   V592  1630-1631          V593  1632-1635          V594  1636            
   V595  1637               V596  1638               V597  1639            
   V598  1640               V599  1641-1642          V600  1643-1644       
   V601  1645               V602  1646               V603  1647-1648       
   V604  1649-1651          V605  1652-1653          V606  1654-1655       
   V607  1656-1657          V608  1658-1659          V609  1660-1662       
   V610  1663-1664          V611  1665-1666          V612  1667-1668       
   V613  1669               V614  1670-1672          V615  1673-1674       
   V616  1675-1676          V617  1677-1678          V618  1679-1680       
   V619  1681-1683          V620  1684               V621  1685            
   V622  1686-1688          V623  1689               V624  1690-1697       
   V625  1698               V626  1699               V627  1700            
   V628  1701               V629  1702               V630 $ 1703           
   V631 $ 1704              V632 $ 1705              V633 $ 1706           
   V634  1707               V635  1708               V636  1709-1710       
   V637  1711-1712          V638  1713               V639  1714-1715       
   V640  1716-1717          V641  1718               V642  1719            
   V643  1720-1721          V644  1722-1724          V645  1725-1726       
   V646  1727-1728          V647  1729-1730          V648  1731-1732       
   V649  1733-1735          V650  1736-1738          V651  1739-1741       
   V652  1742-1744          V653  1745-1747          V654  1748-1750       
   V655  1751-1753          V656  1754-1756          V657  1757-1758       
   V658  1759-1760          V659  1761-1763          V660  1764-1765       
   V661  1766               V662  1767-1769          V663  1770-1772       
   V664  1773-1774          V665  1775-1778          V666  1779-1781       
   V667  1782-1784          V668  1785-1788          V669  1789-1791       
   V670  1792-1795          V671  1796-1798          V672  1799-1802       
   V673  1803-1806          V674  1807-1810          V675  1811-1814       
   V676  1815-1818          V677  1819-1822          V678  1823-1826       
   V679  1827-1829          V680  1830-1834          V681  1835-1838       
   V682  1839-1842          V683  1843-1845          V684  1846-1848       
   V685  1849-1853          V686  1854-1855          V687  1856            
   V688  1857-1858          V689  1859-1860          V690  1861            
   V691  1862-1864          V692  1865-1867          V693  1868-1870       
   V694  1871-1873          V695  1874-1876          V696  1877-1880       
   V697  1881-1883          V698  1884-1886          V699  1887-1890       
   V700  1891-1893          V701  1894-1897          V702  1898-1900       
   V703  1901-1903          V704  1904-1906          V705  1907-1908       
   V706  1909-1912          V707  1913-1915          V708  1916-1918       
   V709  1919-1920          V710  1921-1922          V711  1923-1926       
   V712  1927               V713  1928               V714  1929-1930       
   V715  1931-1932          V716  1933               V717  1934-1935       
   V718  1936-1937          V719  1938               V720  1939            
   V721  1940-1941          V722  1942-1944          V723  1945-1946       
   V724  1947-1948          V725  1949-1950          V726  1951-1952       
   V727  1953-1955          V728  1956-1957          V729  1958-1959       
   V730  1960-1961          V731  1962-1963          V732  1964-1966       
   V733  1967-1968          V734  1969-1970          V735  1971-1972       
   V736  1973               V737  1974-1976          V738  1977            
   V739  1978               V740  1979-1981          V741  1982            
   V742  1983-1990          V743  1991               V744  1992            
   V745  1993               V746  1994               V747  1995            
   V748 $ 1996              V749 $ 1997              V750 $ 1998           
   V751 $ 1999              V752  2000               V753  2001            
   V754  2002-2003          V755  2004-2005          V756  2006-2007       
   V757  2008-2009          V758  2010-2011          V759  2012            
   V760  2013               V761  2014-2015          V762  2016-2018       
   V763  2019-2020          V764  2021-2022          V765  2023-2024       
   V766  2025               V767  2026-2028          V768  2029-2031       
   V769  2032-2034          V770  2035-2037          V771  2038-2040       
   V772  2041-2043          V773  2044-2046          V774  2047-2049       
   V775  2050-2051          V776  2052-2053          V777  2054-2056       
   V778  2057-2058          V779  2059               V780  2060-2062       
   V781  2063-2065          V782  2066-2067          V783  2068-2071       
   V784  2072-2074          V785  2075-2077          V786  2078-2081       
   V787  2082-2084          V788  2085-2088          V789  2089-2091       
   V790  2092-2095          V791  2096-2099          V792  2100-2103       
   V793  2104-2107          V794  2108-2111          V795  2112-2115       
   V796  2116-2119          V797  2120-2122          V798  2123-2127       
   V799  2128-2131          V800  2132-2135          V801  2136-2138       
   V802  2139-2141          V803  2142-2146          V804  2147-2148       
   V805  2149               V806  2150-2151          V807  2152-2153       
   V808  2154-2155          V809  2156-2158          V810  2159-2161       
   V811  2162-2164          V812  2165-2167          V813  2168-2170       
   V814  2171-2174          V815  2175-2177          V816  2178-2180       
   V817  2181-2184          V818  2185-2187          V819  2188-2191       
   V820  2192-2194          V821  2195-2197          V822  2198-2200       
   V823  2201-2202          V824  2203-2206          V825  2207-2209       
   V826  2210-2212          V827  2213-2214          V828  2215-2216       
   V829  2217-2220          V830  2221               V831  2222            
   V832  2223-2224          V833  2225               V834  2226            
   V835  2227-2228          V836  2229-2230          V837  2231            
   V838  2232               V839  2233-2234          V840  2235-2237       
   V841  2238-2239          V842  2240-2241          V843  2242-2243       
   V844  2244-2245          V845  2246-2248          V846  2249-2250       
   V847  2251-2252          V848  2253-2254          V849  2255            
   V850  2256-2258          V851  2259-2260          V852  2261-2262       
   V853  2263-2264          V854  2265               V855  2266-2268       
   V856  2269               V857  2270               V858  2271-2273       
   V859  2274               V860  2275-2282          V861  2283            
   V862  2284               V863  2285               V864  2286            
   V865  2287               V866 $ 2288              V867 $ 2289           
   V868 $ 2290              V869 $ 2291              V870  2292            
   V871  2293               V872  2294-2295          V873  2296-2297       
   V874  2298               V875  2299-2300          V876  2301-2302       
   V877  2303               V878  2304               V879  2305-2306       
   V880  2307-2309          V881  2310-2311          V882  2312-2313       
   V883  2314-2315          V884  2316               V885  2317-2319       
   V886  2320-2322          V887  2323-2325          V888  2326-2328       
   V889  2329-2331          V890  2332-2334          V891  2335-2337       
   V892  2338-2340          V893  2341-2342          V894  2343-2344       
   V895  2345-2347          V896  2348-2349          V897  2350            
   V898  2351-2353          V899  2354-2356          V900  2357-2358       
   V901  2359-2362          V902  2363-2365          V903  2366-2368       
   V904  2369-2372          V905  2373-2375          V906  2376-2379       
   V907  2380-2382          V908  2383-2386          V909  2387-2390       
   V910  2391-2394          V911  2395-2398          V912  2399-2402       
   V913  2403-2406          V914  2407-2410          V915  2411-2413       
   V916  2414-2418          V917  2419-2422          V918  2423-2426       
   V919  2427-2429          V920  2430-2432          V921  2433-2437       
   V922  2438-2439          V923  2440               V924  2441-2442       
   V925  2443-2444          V926  2445-2446          V927  2447-2449       
   V928  2450-2452          V929  2453-2455          V930  2456-2458       
   V931  2459-2461          V932  2462-2465          V933  2466-2468       
   V934  2469-2471          V935  2472-2475          V936  2476-2478       
   V937  2479-2482          V938  2483-2485          V939  2486-2488       
   V940  2489-2491          V941  2492-2493          V942  2494-2497       
   V943  2498-2500          V944  2501-2503          V945  2504-2505       
   V946  2506-2507          V947  2508-2511          V948  2512            
   V949  2513               V950  2514-2515          V951  2516-2517       
   V952  2518               V953  2519-2520          V954  2521-2522       
   V955  2523               V956  2524               V957  2525-2526       
   V958  2527-2529          V959  2530-2531          V960  2532-2533       
   V961  2534-2535          V962  2536-2537          V963  2538-2540       
   V964  2541-2542          V965  2543-2544          V966  2545-2546       
   V967  2547-2548          V968  2549-2551          V969  2552-2553       
   V970  2554-2555          V971  2556-2557          V972  2558-2559       
   V973  2560-2562          V974  2563               V975  2564            
   V976  2565-2567          V977  2568               V978  2569-2576       
   V979  2577               V980  2578               V981  2579            
   V982  2580               V983  2581               V984 $ 2582           
   V985 $ 2583              V986 $ 2584              V987 $ 2585           
   V988  2586               V989  2587               V990  2588-2589       
   V991  2590-2591          V992  2592               V993  2593-2594       
   V994  2595-2596          V995  2597               V996  2598            
   V997  2599-2600          V998  2601-2603          V999  2604-2605       
   V1000  2606-2607         V1001  2608-2609         V1002  2610-2611      
   V1003  2612-2614         V1004  2615-2617         V1005  2618-2620      
   V1006  2621-2623         V1007  2624-2626         V1008  2627-2629      
   V1009  2630-2632         V1010  2633-2635         V1011  2636-2637      
   V1012  2638-2639         V1013  2640-2642         V1014  2643-2644      
   V1015  2645              V1016  2646-2648         V1017  2649-2651      
   V1018  2652-2653         V1019  2654-2657         V1020  2658-2660      
   V1021  2661-2663         V1022  2664-2667         V1023  2668-2670      
   V1024  2671-2674         V1025  2675-2677         V1026  2678-2681      
   V1027  2682-2685         V1028  2686-2689         V1029  2690-2693      
   V1030  2694-2697         V1031  2698-2701         V1032  2702-2705      
   V1033  2706-2708         V1034  2709-2713         V1035  2714-2717      
   V1036  2718-2721         V1037  2722-2724         V1038  2725-2727      
   V1039  2728-2732         V1040  2733-2734         V1041  2735           
   V1042  2736-2738         V1043  2739-2741         V1044  2742-2743      
   V1045  2744-2746         V1046  2747-2749         V1047  2750-2752      
   V1048  2753-2755         V1049  2756-2758         V1050  2759-2762      
   V1051  2763-2765         V1052  2766-2768         V1053  2769-2772      
   V1054  2773-2775         V1055  2776-2779         V1056  2780-2782      
   V1057  2783-2785         V1058  2786-2788         V1059  2789-2790      
   V1060  2791-2794         V1061  2795-2797         V1062  2798-2800      
   V1063  2801-2802         V1064  2803-2804         V1065  2805-2808      
   V1066  2809              V1067  2810              V1068  2811           
   V1069  2812              V1070  2813              V1071  2814-2815      
   V1072  2816-2817         V1073  2818              V1074  2819           
   V1075  2820-2821         V1076  2822-2824         V1077  2825-2826      
   V1078  2827-2828         V1079  2829-2830         V1080  2831-2832      
   V1081  2833-2835         V1082  2836-2837         V1083  2838-2839      
   V1084  2840-2841         V1085  2842              V1086  2843-2845      
   V1087  2846-2847         V1088  2848-2849         V1089  2850-2851      
   V1090  2852-2853         V1091  2854-2856         V1092  2857           
   V1093  2858              V1094  2859-2861         V1095  2862           
   V1096  2863-2870         V1097  2871              V1098  2872           
   V1099  2873              V1100  2874              V1101  2875           
   V1102 $ 2876             V1103 $ 2877             V1104 $ 2878          
   V1105 $ 2879             V1106  2880              V1107  2881           
   V1108  2882-2883         V1109  2884-2885         V1110  2886           
   V1111  2887-2888         V1112  2889-2890         V1113  2891           
   V1114  2892              V1115  2893              V1116  2894-2896      
   V1117  2897-2898         V1118  2899-2900         V1119  2901-2902      
   V1120  2903-2904         V1121  2905-2907         V1122  2908-2910      
   V1123  2911-2913         V1124  2914-2916         V1125  2917-2919      
   V1126  2920-2922         V1127  2923-2925         V1128  2926-2928      
   V1129  2929-2930         V1130  2931-2932         V1131  2933-2935      
   V1132  2936-2937         V1133  2938              V1134  2939-2941      
   V1135  2942-2944         V1136  2945-2946         V1137  2947-2950      
   V1138  2951-2953         V1139  2954-2956         V1140  2957-2960      
   V1141  2961-2963         V1142  2964-2967         V1143  2968-2970      
   V1144  2971-2974         V1145  2975-2978         V1146  2979-2982      
   V1147  2983-2986         V1148  2987-2990         V1149  2991-2994      
   V1150  2995-2998         V1151  2999-3001         V1152  3002-3006      
   V1153  3007-3010         V1154  3011-3014         V1155  3015-3017      
   V1156  3018-3020         V1157  3021-3025         V1158  3026-3027      
   V1159  3028              V1160  3029-3030         V1161  3031-3032      
   V1162  3033-3034         V1163  3035-3037         V1164  3038-3040      
   V1165  3041-3043         V1166  3044-3046         V1167  3047-3049      
   V1168  3050-3053         V1169  3054-3056         V1170  3057-3059      
   V1171  3060-3063         V1172  3064-3066         V1173  3067-3070      
   V1174  3071-3073         V1175  3074-3076         V1176  3077-3079      
   V1177  3080-3081         V1178  3082-3085         V1179  3086-3088      
   V1180  3089-3091         V1181  3092-3093         V1182  3094-3095      
   V1183  3096-3099         V1184  3100              V1185  3101           
   V1186  3102              V1187  3103              V1188  3104           
   V1189  3105-3106         V1190  3107-3108         V1191  3109           
   V1192  3110              V1193  3111-3112         V1194  3113-3115      
   V1195  3116-3117         V1196  3118-3119         V1197  3120-3121      
   V1198  3122-3123         V1199  3124-3126         V1200  3127-3128      
   V1201  3129-3130         V1202  3131-3132         V1203  3133           
   V1204  3134-3136         V1205  3137-3138         V1206  3139-3140      
   V1207  3141-3142         V1208  3143              V1209  3144-3146      
   V1210  3147              V1211  3148              V1212  3149-3151      
   V1213  3152              V1214  3153-3160         V1215  3161           
   V1216  3162              V1217  3163              V1218  3164           
   V1219  3165              V1220 $ 3166             V1221 $ 3167          
   V1222 $ 3168             V1223 $ 3169             V1224  3170           
   V1225  3171              V1226  3172-3173         V1227  3174-3175      
   V1228  3176              V1229  3177-3178         V1230  3179-3180      
   V1231  3181              V1232  3182-3183         V1233  3184-3185      
   V1234  3186-3188         V1235  3189-3190         V1236  3191-3192      
   V1237  3193-3194         V1238  3195              V1239  3196-3198      
   V1240  3199-3201         V1241  3202-3204         V1242  3205-3206      
   V1243  3207-3209         V1244  3210-3212         V1245  3213-3215      
   V1246  3216-3218         V1247  3219-3220         V1248  3221-3222      
   V1249  3223-3225         V1250  3226-3227         V1251  3228           
   V1252  3229-3231         V1253  3232-3234         V1254  3235-3236      
   V1255  3237-3240         V1256  3241-3243         V1257  3244-3246      
   V1258  3247-3250         V1259  3251-3253         V1260  3254-3257      
   V1261  3258-3260         V1262  3261-3263         V1263  3264-3267      
   V1264  3268-3271         V1265  3272-3275         V1266  3276-3279      
   V1267  3280-3283         V1268  3284-3287         V1269  3288-3290      
   V1270  3291-3295         V1271  3296-3299         V1272  3300-3303      
   V1273  3304-3306         V1274  3307-3309         V1275  3310-3314      
   V1276  3315-3316         V1277  3317              V1278  3318-3319      
   V1279  3320-3321         V1280  3322-3323         V1281  3324-3326      
   V1282  3327-3329         V1283  3330-3332         V1284  3333-3335      
   V1285  3336-3338         V1286  3339-3342         V1287  3343-3345      
   V1288  3346-3348         V1289  3349-3351         V1290  3352-3354      
   V1291  3355-3358         V1292  3359-3361         V1293  3362-3364      
   V1294  3365-3367         V1295  3368-3369         V1296  3370-3373      
   V1297  3374-3376         V1298  3377-3379         V1299  3380-3381      
   V1300  3382-3383         V1301  3384-3387         V1302  3388           
   V1303  3389              V1304  3390-3391         V1305  3392           
   V1306  3393              V1307  3394-3395         V1308  3396-3397      
   V1309  3398              V1310  3399              V1311  3400-3401      
   V1312  3402-3404         V1313  3405-3406         V1314  3407-3408      
   V1315  3409-3410         V1316  3411-3412         V1317  3413-3415      
   V1318  3416-3417         V1319  3418-3419         V1320  3420-3421      
   V1321  3422              V1322  3423-3425         V1323  3426-3428      
   V1324  3429-3431         V1325  3432-3433         V1326  3434-3435      
   V1327  3436-3438         V1328  3439              V1329  3440           
   V1330  3441-3443         V1331  3444              V1332  3445-3452      
   V1333  3453              V1334  3454              V1335  3455           
   V1336  3456              V1337  3457              V1338 $ 3458          
   V1339 $ 3459             V1340 $ 3460             V1341 $ 3461          
   V1342  3462              V1343  3463              V1344  3464-3465      
   V1345  3466-3467         V1346  3468              V1347  3469-3470      
   V1348  3471-3472         V1349  3473              V1350  3474           
   V1351  3475-3476         V1352  3477-3479         V1353  3480-3481      
   V1354  3482-3483         V1355  3484-3485         V1356  3486           
   V1357  3487-3489         V1358  3490-3492         V1359  3493-3495      
   V1360  3496-3497         V1361  3498-3500         V1362  3501-3503      
   V1363  3504-3506         V1364  3507-3509         V1365  3510-3511      
   V1366  3512-3513         V1367  3514-3516         V1368  3517-3519      
   V1369  3520-3521         V1370  3522-3524         V1371  3525-3527      
   V1372  3528-3529         V1373  3530-3533         V1374  3534-3537      
   V1375  3538-3540         V1376  3541-3543         V1377  3544-3547      
   V1378  3548-3552         V1379  3553-3556         V1380  3557-3560      
   V1381  3561-3564         V1382  3565-3568         V1383  3569-3573      
   V1384  3574-3578         V1385  3579-3582         V1386  3583-3586      
   V1387  3587-3590         V1388  3591-3595         V1389  3596-3600      
   V1390  3601-3604         V1391  3605-3608         V1392  3609-3611      
   V1393  3612-3616         V1394  3617-3618         V1395  3619           
   V1396  3620-3622         V1397  3623-3625         V1398  3626-3627      
   V1399  3628-3630         V1400  3631-3633         V1401  3634-3636      
   V1402  3637-3639         V1403  3640-3642         V1404  3643-3647      
   V1405  3648-3650         V1406  3651-3653         V1407  3654-3656      
   V1408  3657-3659         V1409  3660-3664         V1410  3665-3668      
   V1411  3669-3671         V1412  3672-3674         V1413  3675-3676      
   V1414  3677-3680         V1415  3681-3683         V1416  3684-3686      
   V1417  3687-3689         V1418  3690-3691         V1419  3692-3696      
   V1420  3697              V1421  3698              V1422  3699-3700      
   V1423  3701-3702         V1424  3703              V1425  3704-3705      
   V1426  3706-3707         V1427  3708              V1428  3709           
   V1429  3710-3711         V1430  3712-3715         V1431  3716-3717      
   V1432  3718-3719         V1433  3720-3721         V1434  3722-3723      
   V1435  3724-3727         V1436  3728-3730         V1437  3731-3733      
   V1438  3734-3735         V1439  3736-3737         V1440  3738-3741      
   V1441  3742-3744         V1442  3745-3747         V1443  3748-3749      
   V1444  3750-3751         V1445  3752-3755         V1446  3756           
   V1447  3757              V1448  3758-3760 ;                             
                                                                           
* SAS LABEL STATEMENT;                                                     
                                                                           
LABEL                                                                      
   V1 = "ID CODE"                                                          
   V2 = "NUMERIC STATE CODE"                                               
   V3 = "ORI CODE"                                                         
   V4 = "GROUP NUMBER"                                                     
   V5 = "DIVISION"                                                         
   V6 = "YEAR"                                                             
   V7 = "CITY SEQUENCE NUMBER"                                             
   V8 = "CORE CITY INDICATION"                                             
   V9 = "COVERED BY CODE"                                                  
   V10 = "LAST UPDATE"                                                     
   V11 = "FIELD OFFICE"                                                    
   V12 = "NUMBER OF MONTHS REPORTED"                                       
   V13 = "AGENCY COUNT"                                                    
   V14 = "POPULATION 1"                                                    
   V15 = "COUNTY 1"                                                        
   V16 = "MSA 1"                                                           
   V17 = "POPULATION 2"                                                    
   V18 = "COUNTY 2"                                                        
   V19 = "MSA 2"                                                           
   V20 = "POPULATION 3"                                                    
   V21 = "COUNTY 3"                                                        
   V22 = "MSA 3"                                                           
   V23 = "FOLLOW-UP INDICATION"                                            
   V24 = "SPECIAL MAILING GROUP"                                           
   V25 = "SPECIAL MAILING ADDRESS"                                         
   V26 = "AGENCY NAME"                                                     
   V27 = "AGENCY STATE NAME"                                               
   V28 = "MAILING ADDRESS-LINE 1"                                          
   V29 = "MAILING ADDRESS-LINE 2"                                          
   V30 = "MAILING ADDRESS-LINE 3"                                          
   V31 = "MAILING ADDRESS-LINE 4"                                          
   V32 = "ZIP CODE"                                                        
   V33 = "JAN: MONTH INCLUDED IN"                                          
   V34 = "JAN: LAST UPDATE"                                                
   V35 = "JAN: CARD 0 TYPE"                                                
   V36 = "JAN: CARD 1 TYPE"                                                
   V37 = "JAN: CARD 2 TYPE"                                                
   V38 = "JAN: CARD 3 TYPE"                                                
   V39 = "JAN: CARD 4 TYPE"                                                
   V40 = "JAN: CARD 0 P/T"                                                 
   V41 = "JAN: CARD 1 P/T"                                                 
   V42 = "JAN: CARD 2 P/T"                                                 
   V43 = "JAN: CARD 3 P/T"                                                 
   V44 = "JAN: UNFOUNDED MURDER"                                           
   V45 = "JAN: UNFOUNDED MANSLGHTR"                                        
   V46 = "JAN: UNFOUNDED RAPE TOTL"                                        
   V47 = "JAN: UNFOUNDED FORC RAPE"                                        
   V48 = "JAN: UNFOUND ATMPTD RAPE"                                        
   V49 = "JAN: UNFOUND ROBBRY TOTL"                                        
   V50 = "JAN: UNFOUND GUN ROBBERY"                                        
   V51 = "JAN: UNFOUNDED KNIFE ROB"                                        
   V52 = "JAN: UNFND OTHR WEAP ROB"                                        
   V53 = "JAN: UNFND STRNG-ARM ROB"                                        
   V54 = "JAN: UNFOUND ASSLT TOTAL"                                        
   V55 = "JAN: UNFOUND GUN ASSLT"                                          
   V56 = "JAN: UNFOUND KNIFE ASSLT"                                        
   V57 = "JAN: UNFND OTH WPN ASLT"                                         
   V58 = "JAN: UNFND HND/FEET ASLT"                                        
   V59 = "JAN: UNFND SIMPL ASSAULT"                                        
   V60 = "JAN: UNFOUND BURG TOTAL"                                         
   V61 = "JAN: UNFOUND FORCE ENTRY"                                        
   V62 = "JAN: UNFND ENTRY-NO FORC"                                        
   V63 = "JAN: UNFND ATT BURGLARY"                                         
   V64 = "JAN: UNFOUND LARCNY TOTL"                                        
   V65 = "JAN: UF TOT MTR VHC THFT"                                        
   V66 = "JAN: UNFOUND AUTO THEFT"                                         
   V67 = "JAN: UF TRUCK/BUS THEFT"                                         
   V68 = "JAN: UNFND OTH VHC THEFT"                                        
   V69 = "JAN: UNFOUND ALL FIELDS"                                         
   V70 = "JAN: ACT NUM MURDER"                                             
   V71 = "JAN: ACT NUM MANSLGHTR"                                          
   V72 = "JAN: ACT NUM RAPE TOTL"                                          
   V73 = "JAN: ACT NUM FORC RAPE"                                          
   V74 = "JAN: ACT NUM ATMPTD RAPE"                                        
   V75 = "JAN: ACT NUM ROBBRY TOTL"                                        
   V76 = "JAN: ACT NUM GUN ROBBERY"                                        
   V77 = "JAN: ACT NUM KNIFE ROBRY"                                        
   V78 = "JAN: ACT NUM OTH WPN ROB"                                        
   V79 = "JAN: ACT NUM STR ARM ROB"                                        
   V80 = "JAN: ACT NUM ASSLT TOTAL"                                        
   V81 = "JAN: ACT NUM GUN ASSAULT"                                        
   V82 = "JAN: ACT NUM KNIFE ASSLT"                                        
   V83 = "JAN: ACT # OTH WPN ASSLT"                                        
   V84 = "JAN: ACT # HND/FEET ASLT"                                        
   V85 = "JAN: ACT # SIMPLE ASSLT"                                         
   V86 = "JAN: ACT # BURGLARY TOTL"                                        
   V87 = "JAN: ACT # FORCE ENTRY"                                          
   V88 = "JAN: ACT # ENTRY-NO FORC"                                        
   V89 = "JAN: ACT # ATT BURGLARY"                                         
   V90 = "JAN: ACT # LARCENY TOTAL"                                        
   V91 = "JAN: ACT # VHC THEFT TOT"                                        
   V92 = "JAN: ACT # AUTO THEFT"                                           
   V93 = "JAN: ACT # TRCK/BUS THFT"                                        
   V94 = "JAN: ACT # OTH VHC THEFT"                                        
   V95 = "JAN: ACT # ALL FIELDS"                                           
   V96 = "JAN: TOT CLR MURDER"                                             
   V97 = "JAN: TOT CLR MANSLGHTR"                                          
   V98 = "JAN: TOT CLR RAPE TOTAL"                                         
   V99 = "JAN: TOT CLR FORC RAPE"                                          
   V100 = "JAN: TOT CLR ATMPTD RAPE"                                       
   V101 = "JAN: TOT CLR TOTL ROBERY"                                       
   V102 = "JAN: TOT CLR GUN ROBBERY"                                       
   V103 = "JAN: TOT CLR KNIFE ROBRY"                                       
   V104 = "JAN: TOT CLR OTH WPN ROB"                                       
   V105 = "JAN: TOT CLR STR ARM ROB"                                       
   V106 = "JAN: TOT CLR ASSLT TOTAL"                                       
   V107 = "JAN: TOT CLR GUN ASSAULT"                                       
   V108 = "JAN: TOT CLR KNIFE ASSLT"                                       
   V109 = "JAN: TOT CLR OTH WPN ASLT"                                      
   V110 = "JAN: TOT CLR HND/FT ASLT"                                       
   V111 = "JAN: TOT CLR SIMPLE ASLT"                                       
   V112 = "JAN: TOT CLR BRGLRY TOTL"                                       
   V113 = "JAN: TOT CLR FORC ENTRY"                                        
   V114 = "JAN: TOT CLR ENTR-NO FRC"                                       
   V115 = "JAN: TOT CLR ATT BURGLRY"                                       
   V116 = "JAN: TOT CLR LARCNY TOTL"                                       
   V117 = "JAN:TOT CLR VHC THFT TOT"                                       
   V118 = "JAN: TOT CLR AUTO THEFT"                                        
   V119 = "JAN:TOT CLR TRCK/BS THFT"                                       
   V120 = "JAN:TOT CLR OTH VHC THFT"                                       
   V121 = "JAN: TOT CLR ALL FIELDS"                                        
   V122 = "JAN: CLR<18 MURDER"                                             
   V123 = "JAN: CLR<18 MANSLGHTR"                                          
   V124 = "JAN: CLR<18 RAPE TOTAL"                                         
   V125 = "JAN: CLR<18 FORCE RAPE"                                         
   V126 = "JAN: CLR<18 ATTMPTD RAPE"                                       
   V127 = "JAN: CLR<18 ROBBERY TOTL"                                       
   V128 = "JAN: CLR<18 GUN ROBBERY"                                        
   V129 = "JAN: CLR<18 KNIFE ROBBRY"                                       
   V130 = "JAN: CLR<18 OTH WPN RBRY"                                       
   V131 = "JAN: CLR<18 STR ARM ROB"                                        
   V132 = "JAN: CLR<18 ASSLT TOTAL"                                        
   V133 = "JAN: CLR<18 GUN ASSAULT"                                        
   V134 = "JAN: CLR<18 KNIFE ASSLT"                                        
   V135 = "JAN: CLR<18 OTH WPN ASLT"                                       
   V136 = "JAN: CLR<18 HND/FT ASSLT"                                       
   V137 = "JAN: CLR<18 SIMPLE ASSLT"                                       
   V138 = "JAN: CLR<18 BURGLRY TOTL"                                       
   V139 = "JAN: CLR<18 FORC ENTRY"                                         
   V140 = "JAN: CLR<18 ENTR-NO FORC"                                       
   V141 = "JAN: CLR<18 ATT BURGLARY"                                       
   V142 = "JAN: CLR<18 LARCENY TOTL"                                       
   V143 = "JAN: CLR<18 VHC THFT TOT"                                       
   V144 = "JAN: CLR<18 AUTO THEFT"                                         
   V145 = "JAN: CLR<18 TRCK/BS THFT"                                       
   V146 = "JAN: CLR<18 OTH VHC THFT"                                       
   V147 = "JAN: CLR<18 ALL FIELDS"                                         
   V148 = "JAN: OFFICRS KILL BY FEL"                                       
   V149 = "JAN: OFFICRS KILL BY ACC"                                       
   V150 = "JAN: OFFICERS ASSAULTED"                                        
   V151 = "FEB: MONTH INCLUDED IN"                                         
   V152 = "FEB: LAST UPDATE"                                               
   V153 = "FEB: CARD 0 TYPE"                                               
   V154 = "FEB: CARD 1 TYPE"                                               
   V155 = "FEB: CARD 2 TYPE"                                               
   V156 = "FEB: CARD 3 TYPE"                                               
   V157 = "FEB: CARD 4 TYPE"                                               
   V158 = "FEB: CARD 0 P/T"                                                
   V159 = "FEB: CARD 1 P/T"                                                
   V160 = "FEB: CARD 2 P/T"                                                
   V161 = "FEB: CARD 3 P/T"                                                
   V162 = "FEB: UNFOUNDED MURDER"                                          
   V163 = "FEB: UNFOUNDED MANSLGHTR"                                       
   V164 = "FEB: UNFOUNDED RAPE TOTL"                                       
   V165 = "FEB: UNFOUNDED FORC RAPE"                                       
   V166 = "FEB: UNFOUND ATMPTD RAPE"                                       
   V167 = "FEB: UNFOUND ROBBRY TOTL"                                       
   V168 = "FEB: UNFOUND GUN ROBBERY"                                       
   V169 = "FEB: UNFOUNDED KNIFE ROB"                                       
   V170 = "FEB: UNFND OTHR WEAP ROB"                                       
   V171 = "FEB: UNFND STRNG-ARM ROB"                                       
   V172 = "FEB: UNFOUND ASSLT TOTAL"                                       
   V173 = "FEB: UNFOUND GUN ASSLT"                                         
   V174 = "FEB: UNFOUND KNIFE ASSLT"                                       
   V175 = "FEB: UNFND OTH WPN ASLT"                                        
   V176 = "FEB: UNFND HND/FEET ASLT"                                       
   V177 = "FEB: UNFND SIMPL ASSAULT"                                       
   V178 = "FEB: UNFOUND BURG TOTAL"                                        
   V179 = "FEB: UNFOUND FORCE ENTRY"                                       
   V180 = "FEB: UNFND ENTRY-NO FORC"                                       
   V181 = "FEB: UNFND ATT BURGLARY"                                        
   V182 = "FEB: UNFOUND LARCNY TOTL"                                       
   V183 = "FEB: UF TOT MTR VHC THFT"                                       
   V184 = "FEB: UNFOUND AUTO THEFT"                                        
   V185 = "FEB: UF TRUCK/BUS THEFT"                                        
   V186 = "FEB: UNFND OTH VHC THEFT"                                       
   V187 = "FEB: UNFOUND ALL FIELDS"                                        
   V188 = "FEB: ACT NUM MURDER"                                            
   V189 = "FEB: ACT NUM MANSLGHTR"                                         
   V190 = "FEB: ACT NUM RAPE TOTL"                                         
   V191 = "FEB: ACT NUM FORC RAPE"                                         
   V192 = "FEB: ACT NUM ATMPTD RAPE"                                       
   V193 = "FEB: ACT NUM ROBBRY TOTL"                                       
   V194 = "FEB: ACT NUM GUN ROBBERY"                                       
   V195 = "FEB: ACT NUM KNIFE ROBRY"                                       
   V196 = "FEB: ACT NUM OTH WPN ROB"                                       
   V197 = "FEB: ACT NUM STR ARM ROB"                                       
   V198 = "FEB: ACT NUM ASSLT TOTAL"                                       
   V199 = "FEB: ACT NUM GUN ASSAULT"                                       
   V200 = "FEB: ACT NUM KNIFE ASSLT"                                       
   V201 = "FEB: ACT # OTH WPN ASSLT"                                       
   V202 = "FEB: ACT # HND/FEET ASLT"                                       
   V203 = "FEB: ACT # SIMPLE ASSLT"                                        
   V204 = "FEB: ACT # BURGLARY TOTL"                                       
   V205 = "FEB: ACT # FORCE ENTRY"                                         
   V206 = "FEB: ACT # ENTRY-NO FORC"                                       
   V207 = "FEB: ACT # ATT BURGLARY"                                        
   V208 = "FEB: ACT # LARCENY TOTAL"                                       
   V209 = "FEB: ACT # VHC THEFT TOT"                                       
   V210 = "FEB: ACT # AUTO THEFT"                                          
   V211 = "FEB: ACT # TRCK/BUS THFT"                                       
   V212 = "FEB: ACT # OTH VHC THEFT"                                       
   V213 = "FEB: ACT # ALL FIELDS"                                          
   V214 = "FEB: TOT CLR MURDER"                                            
   V215 = "FEB: TOT CLR MANSLGHTR"                                         
   V216 = "FEB: TOT CLR RAPE TOTAL"                                        
   V217 = "FEB: TOT CLR FORC RAPE"                                         
   V218 = "FEB: TOT CLR ATMPTD RAPE"                                       
   V219 = "FEB: TOT CLR TOTL ROBERY"                                       
   V220 = "FEB: TOT CLR GUN ROBBERY"                                       
   V221 = "FEB: TOT CLR KNIFE ROBRY"                                       
   V222 = "FEB: TOT CLR OTH WPN ROB"                                       
   V223 = "FEB: TOT CLR STR ARM ROB"                                       
   V224 = "FEB: TOT CLR ASSLT TOTAL"                                       
   V225 = "FEB: TOT CLR GUN ASSAULT"                                       
   V226 = "FEB: TOT CLR KNIFE ASSLT"                                       
   V227 = "FEB: TOT CLR OTH WPN ASLT"                                      
   V228 = "FEB: TOT CLR HND/FT ASLT"                                       
   V229 = "FEB: TOT CLR SIMPLE ASLT"                                       
   V230 = "FEB: TOT CLR BRGLRY TOTL"                                       
   V231 = "FEB: TOT CLR FORC ENTRY"                                        
   V232 = "FEB: TOT CLR ENTR-NO FRC"                                       
   V233 = "FEB: TOT CLR ATT BURGLRY"                                       
   V234 = "FEB: TOT CLR LARCNY TOTL"                                       
   V235 = "FEB:TOT CLR VHC THFT TOT"                                       
   V236 = "FEB: TOT CLR AUTO THEFT"                                        
   V237 = "FEB:TOT CLR TRCK/BS THFT"                                       
   V238 = "FEB:TOT CLR OTH VHC THFT"                                       
   V239 = "FEB: TOT CLR ALL FIELDS"                                        
   V240 = "FEB: CLR<18 MURDER"                                             
   V241 = "FEB: CLR<18 MANSLGHTR"                                          
   V242 = "FEB: CLR<18 RAPE TOTAL"                                         
   V243 = "FEB: CLR<18 FORCE RAPE"                                         
   V244 = "FEB: CLR<18 ATTMPTD RAPE"                                       
   V245 = "FEB: CLR<18 ROBBERY TOTL"                                       
   V246 = "FEB: CLR<18 GUN ROBBERY"                                        
   V247 = "FEB: CLR<18 KNIFE ROBBRY"                                       
   V248 = "FEB: CLR<18 OTH WPN RBRY"                                       
   V249 = "FEB: CLR<18 STR ARM ROB"                                        
   V250 = "FEB: CLR<18 ASSLT TOTAL"                                        
   V251 = "FEB: CLR<18 GUN ASSAULT"                                        
   V252 = "FEB: CLR<18 KNIFE ASSLT"                                        
   V253 = "FEB: CLR<18 OTH WPN ASLT"                                       
   V254 = "FEB: CLR<18 HND/FT ASSLT"                                       
   V255 = "FEB: CLR<18 SIMPLE ASSLT"                                       
   V256 = "FEB: CLR<18 BURGLRY TOTL"                                       
   V257 = "FEB: CLR<18 FORC ENTRY"                                         
   V258 = "FEB: CLR<18 ENTR-NO FORC"                                       
   V259 = "FEB: CLR<18 ATT BURGLARY"                                       
   V260 = "FEB: CLR<18 LARCENY TOTL"                                       
   V261 = "FEB: CLR<18 VHC THFT TOT"                                       
   V262 = "FEB: CLR<18 AUTO THEFT"                                         
   V263 = "FEB: CLR<18 TRCK/BS THFT"                                       
   V264 = "FEB: CLR<18 OTH VHC THFT"                                       
   V265 = "FEB: CLR<18 ALL FIELDS"                                         
   V266 = "FEB: OFFICRS KILL BY FEL"                                       
   V267 = "FEB: OFFICRS KILL BY ACC"                                       
   V268 = "FEB: OFFICERS ASSAULTED"                                        
   V269 = "MAR: MONTH INCLUDED IN"                                         
   V270 = "MAR: LAST UPDATE"                                               
   V271 = "MAR: CARD 0 TYPE"                                               
   V272 = "MAR: CARD 1 TYPE"                                               
   V273 = "MAR: CARD 2 TYPE"                                               
   V274 = "MAR: CARD 3 TYPE"                                               
   V275 = "MAR: CARD 4 TYPE"                                               
   V276 = "MAR: CARD 0 P/T"                                                
   V277 = "MAR: CARD 1 P/T"                                                
   V278 = "MAR: CARD 2 P/T"                                                
   V279 = "MAR: CARD 3 P/T"                                                
   V280 = "MAR: UNFOUNDED MURDER"                                          
   V281 = "MAR: UNFOUNDED MANSLGHTR"                                       
   V282 = "MAR: UNFOUNDED RAPE TOTL"                                       
   V283 = "MAR: UNFOUNDED FORC RAPE"                                       
   V284 = "MAR: UNFOUND ATMPTD RAPE"                                       
   V285 = "MAR: UNFOUND ROBBRY TOTL"                                       
   V286 = "MAR: UNFOUND GUN ROBBERY"                                       
   V287 = "MAR: UNFOUNDED KNIFE ROB"                                       
   V288 = "MAR: UNFND OTHR WEAP ROB"                                       
   V289 = "MAR: UNFND STRNG-ARM ROB"                                       
   V290 = "MAR: UNFOUND ASSLT TOTAL"                                       
   V291 = "MAR: UNFOUND GUN ASSLT"                                         
   V292 = "MAR: UNFOUND KNIFE ASSLT"                                       
   V293 = "MAR: UNFND OTH WPN ASLT"                                        
   V294 = "MAR: UNFND HND/FEET ASLT"                                       
   V295 = "MAR: UNFND SIMPL ASSAULT"                                       
   V296 = "MAR: UNFOUND BURG TOTAL"                                        
   V297 = "MAR: UNFOUND FORCE ENTRY"                                       
   V298 = "MAR: UNFND ENTRY-NO FORC"                                       
   V299 = "MAR: UNFND ATT BURGLARY"                                        
   V300 = "MAR: UNFOUND LARCNY TOTL"                                       
   V301 = "MAR: UF TOT MTR VHC THFT"                                       
   V302 = "MAR: UNFOUND AUTO THEFT"                                        
   V303 = "MAR: UF TRUCK/BUS THEFT"                                        
   V304 = "MAR: UNFND OTH VHC THEFT"                                       
   V305 = "MAR: UNFOUND ALL FIELDS"                                        
   V306 = "MAR: ACT NUM MURDER"                                            
   V307 = "MAR: ACT NUM MANSLGHTR"                                         
   V308 = "MAR: ACT NUM RAPE TOTL"                                         
   V309 = "MAR: ACT NUM FORC RAPE"                                         
   V310 = "MAR: ACT NUM ATMPTD RAPE"                                       
   V311 = "MAR: ACT NUM ROBBRY TOTL"                                       
   V312 = "MAR: ACT NUM GUN ROBBERY"                                       
   V313 = "MAR: ACT NUM KNIFE ROBRY"                                       
   V314 = "MAR: ACT NUM OTH WPN ROB"                                       
   V315 = "MAR: ACT NUM STR ARM ROB"                                       
   V316 = "MAR: ACT NUM ASSLT TOTAL"                                       
   V317 = "MAR: ACT NUM GUN ASSAULT"                                       
   V318 = "MAR: ACT NUM KNIFE ASSLT"                                       
   V319 = "MAR: ACT # OTH WPN ASSLT"                                       
   V320 = "MAR: ACT # HND/FEET ASLT"                                       
   V321 = "MAR: ACT # SIMPLE ASSLT"                                        
   V322 = "MAR: ACT # BURGLARY TOTL"                                       
   V323 = "MAR: ACT # FORCE ENTRY"                                         
   V324 = "MAR: ACT # ENTRY-NO FORC"                                       
   V325 = "MAR: ACT # ATT BURGLARY"                                        
   V326 = "MAR: ACT # LARCENY TOTAL"                                       
   V327 = "MAR: ACT # VHC THEFT TOT"                                       
   V328 = "MAR: ACT # AUTO THEFT"                                          
   V329 = "MAR: ACT # TRCK/BUS THFT"                                       
   V330 = "MAR: ACT # OTH VHC THEFT"                                       
   V331 = "MAR: ACT # ALL FIELDS"                                          
   V332 = "MAR: TOT CLR MURDER"                                            
   V333 = "MAR: TOT CLR MANSLGHTR"                                         
   V334 = "MAR: TOT CLR RAPE TOTAL"                                        
   V335 = "MAR: TOT CLR FORC RAPE"                                         
   V336 = "MAR: TOT CLR ATMPTD RAPE"                                       
   V337 = "MAR: TOT CLR TOTL ROBERY"                                       
   V338 = "MAR: TOT CLR GUN ROBBERY"                                       
   V339 = "MAR: TOT CLR KNIFE ROBRY"                                       
   V340 = "MAR: TOT CLR OTH WPN ROB"                                       
   V341 = "MAR: TOT CLR STR ARM ROB"                                       
   V342 = "MAR: TOT CLR ASSLT TOTAL"                                       
   V343 = "MAR: TOT CLR GUN ASSAULT"                                       
   V344 = "MAR: TOT CLR KNIFE ASSLT"                                       
   V345 = "MAR:TOT CLR OTH WPN ASLT"                                       
   V346 = "MAR: TOT CLR HND/FT ASLT"                                       
   V347 = "MAR: TOT CLR SIMPLE ASLT"                                       
   V348 = "MAR: TOT CLR BRGLRY TOTL"                                       
   V349 = "MAR: TOT CLR FORC ENTRY"                                        
   V350 = "MAR: TOT CLR ENTR-NO FRC"                                       
   V351 = "MAR: TOT CLR ATT BURGLRY"                                       
   V352 = "MAR: TOT CLR LARCNY TOTL"                                       
   V353 = "MAR:TOT CLR VHC THFT TOT"                                       
   V354 = "MAR: TOT CLR AUTO THEFT"                                        
   V355 = "MAR:TOT CLR TRCK/BS THFT"                                       
   V356 = "MAR:TOT CLR OTH VHC THFT"                                       
   V357 = "MAR: TOT CLR ALL FIELDS"                                        
   V358 = "MAR: CLR<18 MURDER"                                             
   V359 = "MAR: CLR<18 MANSLGHTR"                                          
   V360 = "MAR: CLR<18 RAPE TOTAL"                                         
   V361 = "MAR: CLR<18 FORCE RAPE"                                         
   V362 = "MAR: CLR<18 ATTMPTD RAPE"                                       
   V363 = "MAR: CLR<18 ROBBERY TOTL"                                       
   V364 = "MAR: CLR<18 GUN ROBBERY"                                        
   V365 = "MAR: CLR<18 KNIFE ROBBRY"                                       
   V366 = "MAR: CLR<18 OTH WPN RBRY"                                       
   V367 = "MAR: CLR<18 STR ARM ROB"                                        
   V368 = "MAR: CLR<18 ASSLT TOTAL"                                        
   V369 = "MAR: CLR<18 GUN ASSAULT"                                        
   V370 = "MAR: CLR<18 KNIFE ASSLT"                                        
   V371 = "MAR: CLR<18 OTH WPN ASLT"                                       
   V372 = "MAR: CLR<18 HND/FT ASSLT"                                       
   V373 = "MAR: CLR<18 SIMPLE ASSLT"                                       
   V374 = "MAR: CLR<18 BURGLRY TOTL"                                       
   V375 = "MAR: CLR<18 FORC ENTRY"                                         
   V376 = "MAR: CLR<18 ENTR-NO FORC"                                       
   V377 = "MAR: CLR<18 ATT BURGLARY"                                       
   V378 = "MAR: CLR<18 LARCENY TOTL"                                       
   V379 = "MAR: CLR<18 VHC THFT TOT"                                       
   V380 = "MAR: CLR<18 AUTO THEFT"                                         
   V381 = "MAR: CLR<18 TRCK/BS THFT"                                       
   V382 = "MAR: CLR<18 OTH VHC THFT"                                       
   V383 = "MAR: CLR<18 ALL FIELDS"                                         
   V384 = "MAR: OFFICRS KILL BY FEL"                                       
   V385 = "MAR: OFFICRS KILL BY ACC"                                       
   V386 = "MAR: OFFICERS ASSAULTED"                                        
   V387 = "APR: MONTH INCLUDED IN"                                         
   V388 = "APR: LAST UPDATE"                                               
   V389 = "APR: CARD 0 TYPE"                                               
   V390 = "APR: CARD 1 TYPE"                                               
   V391 = "APR: CARD 2 TYPE"                                               
   V392 = "APR: CARD 3 TYPE"                                               
   V393 = "APR: CARD 4 TYPE"                                               
   V394 = "APR: CARD 0 P/T"                                                
   V395 = "APR: CARD 1 P/T"                                                
   V396 = "APR: CARD 2 P/T"                                                
   V397 = "APR: CARD 3 P/T"                                                
   V398 = "APR: UNFOUNDED MURDER"                                          
   V399 = "APR: UNFOUNDED MANSLGHTR"                                       
   V400 = "APR: UNFOUNDED RAPE TOTL"                                       
   V401 = "APR: UNFOUNDED FORC RAPE"                                       
   V402 = "APR: UNFOUND ATMPTD RAPE"                                       
   V403 = "APR: UNFOUND ROBBRY TOTL"                                       
   V404 = "APR: UNFOUND GUN ROBBERY"                                       
   V405 = "APR: UNFOUNDED KNIFE ROB"                                       
   V406 = "APR: UNFND OTHR WEAP ROB"                                       
   V407 = "APR: UNFND STRNG-ARM ROB"                                       
   V408 = "APR: UNFOUND ASSLT TOTAL"                                       
   V409 = "APR: UNFOUND GUN ASSLT"                                         
   V410 = "APR: UNFOUND KNIFE ASSLT"                                       
   V411 = "APR: UNFND OTH WPN ASLT"                                        
   V412 = "APR: UNFND HND/FEET ASLT"                                       
   V413 = "APR: UNFND SIMPL ASSAULT"                                       
   V414 = "APR: UNFOUND BURG TOTAL"                                        
   V415 = "APR: UNFOUND FORCE ENTRY"                                       
   V416 = "APR: UNFND ENTRY-NO FORC"                                       
   V417 = "APR: UNFND ATT BURGLARY"                                        
   V418 = "APR: UNFOUND LARCNY TOTL"                                       
   V419 = "APR: UF TOT MTR VHC THFT"                                       
   V420 = "APR: UNFOUND AUTO THEFT"                                        
   V421 = "APR: UF TRUCK/BUS THEFT"                                        
   V422 = "APR: UNFND OTH VHC THEFT"                                       
   V423 = "APR: UNFOUND ALL FIELDS"                                        
   V424 = "APR: ACT NUM MURDER"                                            
   V425 = "APR: ACT NUM MANSLGHTR"                                         
   V426 = "APR: ACT NUM RAPE TOTL"                                         
   V427 = "APR: ACT NUM FORC RAPE"                                         
   V428 = "APR: ACT NUM ATMPTD RAPE"                                       
   V429 = "APR: ACT NUM ROBBRY TOTL"                                       
   V430 = "APR: ACT NUM GUN ROBBERY"                                       
   V431 = "APR: ACT NUM KNIFE ROBRY"                                       
   V432 = "APR: ACT NUM OTH WPN ROB"                                       
   V433 = "APR: ACT NUM STR ARM ROB"                                       
   V434 = "APR: ACT NUM ASSLT TOTAL"                                       
   V435 = "APR: ACT NUM GUN ASSAULT"                                       
   V436 = "APR: ACT NUM KNIFE ASSLT"                                       
   V437 = "APR: ACT # OTH WPN ASSLT"                                       
   V438 = "APR: ACT # HND/FEET ASLT"                                       
   V439 = "APR: ACT # SIMPLE ASSLT"                                        
   V440 = "APR: ACT # BURGLARY TOTL"                                       
   V441 = "APR: ACT # FORCE ENTRY"                                         
   V442 = "APR: ACT # ENTRY-NO FORC"                                       
   V443 = "APR: ACT # ATT BURGLARY"                                        
   V444 = "APR: ACT # LARCENY TOTAL"                                       
   V445 = "APR: ACT # VHC THEFT TOT"                                       
   V446 = "APR: ACT # AUTO THEFT"                                          
   V447 = "APR: ACT # TRCK/BUS THFT"                                       
   V448 = "APR: ACT # OTH VHC THEFT"                                       
   V449 = "APR: ACT # ALL FIELDS"                                          
   V450 = "APR: TOT CLR MURDER"                                            
   V451 = "APR: TOT CLR MANSLGHTR"                                         
   V452 = "APR: TOT CLR RAPE TOTAL"                                        
   V453 = "APR: TOT CLR FORC RAPE"                                         
   V454 = "APR: TOT CLR ATMPTD RAPE"                                       
   V455 = "APR: TOT CLR TOTL ROBERY"                                       
   V456 = "APR: TOT CLR GUN ROBBERY"                                       
   V457 = "APR: TOT CLR KNIFE ROBRY"                                       
   V458 = "APR: TOT CLR OTH WPN ROB"                                       
   V459 = "APR: TOT CLR STR ARM ROB"                                       
   V460 = "APR: TOT CLR ASSLT TOTAL"                                       
   V461 = "APR: TOT CLR GUN ASSAULT"                                       
   V462 = "APR: TOT CLR KNIFE ASSLT"                                       
   V463 = "APR:TOT CLR OTH WPN ASLT"                                       
   V464 = "APR: TOT CLR HND/FT ASLT"                                       
   V465 = "APR: TOT CLR SIMPLE ASLT"                                       
   V466 = "APR: TOT CLR BRGLRY TOTL"                                       
   V467 = "APR: TOT CLR FORC ENTRY"                                        
   V468 = "APR: TOT CLR ENTR-NO FRC"                                       
   V469 = "APR: TOT CLR ATT BURGLRY"                                       
   V470 = "APR: TOT CLR LARCNY TOTL"                                       
   V471 = "APR:TOT CLR VHC THFT TOT"                                       
   V472 = "APR: TOT CLR AUTO THEFT"                                        
   V473 = "APR:TOT CLR TRCK/BS THFT"                                       
   V474 = "APR:TOT CLR OTH VHC THFT"                                       
   V475 = "APR: TOT CLR ALL FIELDS"                                        
   V476 = "APR: CLR<18 MURDER"                                             
   V477 = "APR: CLR<18 MANSLGHTR"                                          
   V478 = "APR: CLR<18 RAPE TOTAL"                                         
   V479 = "APR: CLR<18 FORCE RAPE"                                         
   V480 = "APR: CLR<18 ATTMPTD RAPE"                                       
   V481 = "APR: CLR<18 ROBBERY TOTL"                                       
   V482 = "APR: CLR<18 GUN ROBBERY"                                        
   V483 = "APR: CLR<18 KNIFE ROBBRY"                                       
   V484 = "APR: CLR<18 OTH WPN RBRY"                                       
   V485 = "APR: CLR<18 STR ARM ROB"                                        
   V486 = "APR: CLR<18 ASSLT TOTAL"                                        
   V487 = "APR: CLR<18 GUN ASSAULT"                                        
   V488 = "APR: CLR<18 KNIFE ASSLT"                                        
   V489 = "APR: CLR<18 OTH WPN ASLT"                                       
   V490 = "APR: CLR<18 HND/FT ASSLT"                                       
   V491 = "APR: CLR<18 SIMPLE ASSLT"                                       
   V492 = "APR: CLR<18 BURGLRY TOTL"                                       
   V493 = "APR: CLR<18 FORC ENTRY"                                         
   V494 = "APR: CLR<18 ENTR-NO FORC"                                       
   V495 = "APR: CLR<18 ATT BURGLARY"                                       
   V496 = "APR: CLR<18 LARCENY TOTL"                                       
   V497 = "APR: CLR<18 VHC THFT TOT"                                       
   V498 = "APR: CLR<18 AUTO THEFT"                                         
   V499 = "APR: CLR<18 TRCK/BS THFT"                                       
   V500 = "APR: CLR<18 OTH VHC THFT"                                       
   V501 = "APR: CLR<18 ALL FIELDS"                                         
   V502 = "APR: OFFICRS KILL BY FEL"                                       
   V503 = "APR: OFFICRS KILL BY ACC"                                       
   V504 = "APR: OFFICERS ASSAULTED"                                        
   V505 = "MAY: MONTH INCLUDED IN"                                         
   V506 = "MAY: LAST UPDATE"                                               
   V507 = "MAY: CARD 0 TYPE"                                               
   V508 = "MAY: CARD 1 TYPE"                                               
   V509 = "MAY: CARD 2 TYPE"                                               
   V510 = "MAY: CARD 3 TYPE"                                               
   V511 = "MAY: CARD 4 TYPE"                                               
   V512 = "MAY: CARD 0 P/T"                                                
   V513 = "MAY: CARD 1 P/T"                                                
   V514 = "MAY: CARD 2 P/T"                                                
   V515 = "MAY: CARD 3 P/T"                                                
   V516 = "MAY: UNFOUNDED MURDER"                                          
   V517 = "MAY: UNFOUNDED MANSLGHTR"                                       
   V518 = "MAY: UNFOUNDED RAPE TOTL"                                       
   V519 = "MAY: UNFOUNDED FORC RAPE"                                       
   V520 = "MAY: UNFOUND ATMPTD RAPE"                                       
   V521 = "MAY: UNFOUND ROBBRY TOTL"                                       
   V522 = "MAY: UNFOUND GUN ROBBERY"                                       
   V523 = "MAY: UNFOUNDED KNIFE ROB"                                       
   V524 = "MAY: UNFND OTHR WEAP ROB"                                       
   V525 = "MAY: UNFND STRNG-ARM ROB"                                       
   V526 = "MAY: UNFOUND ASSLT TOTAL"                                       
   V527 = "MAY: UNFOUND GUN ASSLT"                                         
   V528 = "MAY: UNFOUND KNIFE ASSLT"                                       
   V529 = "MAY: UNFND OTH WPN ASLT"                                        
   V530 = "MAY: UNFND HND/FEET ASLT"                                       
   V531 = "MAY: UNFND SIMPL ASSAULT"                                       
   V532 = "MAY: UNFOUND BURG TOTAL"                                        
   V533 = "MAY: UNFOUND FORCE ENTRY"                                       
   V534 = "MAY: UNFND ENTRY-NO FORC"                                       
   V535 = "MAY: UNFND ATT BURGLARY"                                        
   V536 = "MAY: UNFOUND LARCNY TOTL"                                       
   V537 = "MAY: UF TOT MTR VHC THFT"                                       
   V538 = "MAY: UNFOUND AUTO THEFT"                                        
   V539 = "MAY: UF TRUCK/BUS THEFT"                                        
   V540 = "MAY: UNFND OTH VHC THEFT"                                       
   V541 = "MAY: UNFOUND ALL FIELDS"                                        
   V542 = "MAY: ACT NUM MURDER"                                            
   V543 = "MAY: ACT NUM MANSLGHTR"                                         
   V544 = "MAY: ACT NUM RAPE TOTL"                                         
   V545 = "MAY: ACT NUM FORC RAPE"                                         
   V546 = "MAY: ACT NUM ATMPTD RAPE"                                       
   V547 = "MAY: ACT NUM ROBBRY TOTL"                                       
   V548 = "MAY: ACT NUM GUN ROBBERY"                                       
   V549 = "MAY: ACT NUM KNIFE ROBRY"                                       
   V550 = "MAY: ACT NUM OTH WPN ROB"                                       
   V551 = "MAY: ACT NUM STR ARM ROB"                                       
   V552 = "MAY: ACT NUM ASSLT TOTAL"                                       
   V553 = "MAY: ACT NUM GUN ASSAULT"                                       
   V554 = "MAY: ACT NUM KNIFE ASSLT"                                       
   V555 = "MAY: ACT # OTH WPN ASSLT"                                       
   V556 = "MAY: ACT # HND/FEET ASLT"                                       
   V557 = "MAY: ACT # SIMPLE ASSLT"                                        
   V558 = "MAY: ACT # BURGLARY TOTL"                                       
   V559 = "MAY: ACT # FORCE ENTRY"                                         
   V560 = "MAY: ACT # ENTRY-NO FORC"                                       
   V561 = "MAY: ACT # ATT BURGLARY"                                        
   V562 = "MAY: ACT # LARCENY TOTAL"                                       
   V563 = "MAY: ACT # VHC THEFT TOT"                                       
   V564 = "MAY: ACT # AUTO THEFT"                                          
   V565 = "MAY: ACT # TRCK/BUS THFT"                                       
   V566 = "MAY: ACT # OTH VHC THEFT"                                       
   V567 = "MAY: ACT # ALL FIELDS"                                          
   V568 = "MAY: TOT CLR MURDER"                                            
   V569 = "MAY: TOT CLR MANSLGHTR"                                         
   V570 = "MAY: TOT CLR RAPE TOTAL"                                        
   V571 = "MAY: TOT CLR FORC RAPE"                                         
   V572 = "MAY: TOT CLR ATMPTD RAPE"                                       
   V573 = "MAY: TOT CLR TOTL ROBERY"                                       
   V574 = "MAY: TOT CLR GUN ROBBERY"                                       
   V575 = "MAY: TOT CLR KNIFE ROBRY"                                       
   V576 = "MAY: TOT CLR OTH WPN ROB"                                       
   V577 = "MAY: TOT CLR STR ARM ROB"                                       
   V578 = "MAY: TOT CLR ASSLT TOTAL"                                       
   V579 = "MAY: TOT CLR GUN ASSAULT"                                       
   V580 = "MAY: TOT CLR KNIFE ASSLT"                                       
   V581 = "MAY:TOT CLR OTH WPN ASLT"                                       
   V582 = "MAY: TOT CLR HND/FT ASLT"                                       
   V583 = "MAY: TOT CLR SIMPLE ASLT"                                       
   V584 = "MAY: TOT CLR BRGLRY TOTL"                                       
   V585 = "MAY: TOT CLR FORC ENTRY"                                        
   V586 = "MAY: TOT CLR ENTR-NO FRC"                                       
   V587 = "MAY: TOT CLR ATT BURGLRY"                                       
   V588 = "MAY: TOT CLR LARCNY TOTL"                                       
   V589 = "MAY:TOT CLR VHC THFT TOT"                                       
   V590 = "MAY: TOT CLR AUTO THEFT"                                        
   V591 = "MAY:TOT CLR TRCK/BS THFT"                                       
   V592 = "MAY:TOT CLR OTH VHC THFT"                                       
   V593 = "MAY: TOT CLR ALL FIELDS"                                        
   V594 = "MAY: CLR<18 MURDER"                                             
   V595 = "MAY: CLR<18 MANSLGHTR"                                          
   V596 = "MAY: CLR<18 RAPE TOTAL"                                         
   V597 = "MAY: CLR<18 FORCE RAPE"                                         
   V598 = "MAY: CLR<18 ATTMPTD RAPE"                                       
   V599 = "MAY: CLR<18 ROBBERY TOTL"                                       
   V600 = "MAY: CLR<18 GUN ROBBERY"                                        
   V601 = "MAY: CLR<18 KNIFE ROBBRY"                                       
   V602 = "MAY: CLR<18 OTH WPN RBRY"                                       
   V603 = "MAY: CLR<18 STR ARM ROB"                                        
   V604 = "MAY: CLR<18 ASSLT TOTAL"                                        
   V605 = "MAY: CLR<18 GUN ASSAULT"                                        
   V606 = "MAY: CLR<18 KNIFE ASSLT"                                        
   V607 = "MAY: CLR<18 OTH WPN ASLT"                                       
   V608 = "MAY: CLR<18 HND/FT ASSLT"                                       
   V609 = "MAY: CLR<18 SIMPLE ASSLT"                                       
   V610 = "MAY: CLR<18 BURGLRY TOTL"                                       
   V611 = "MAY: CLR<18 FORC ENTRY"                                         
   V612 = "MAY: CLR<18 ENTR-NO FORC"                                       
   V613 = "MAY: CLR<18 ATT BURGLARY"                                       
   V614 = "MAY: CLR<18 LARCENY TOTL"                                       
   V615 = "MAY: CLR<18 VHC THFT TOT"                                       
   V616 = "MAY: CLR<18 AUTO THEFT"                                         
   V617 = "MAY: CLR<18 TRCK/BS THFT"                                       
   V618 = "MAY: CLR<18 OTH VHC THFT"                                       
   V619 = "MAY: CLR<18 ALL FIELDS"                                         
   V620 = "MAY: OFFICRS KILL BY FEL"                                       
   V621 = "MAY: OFFICRS KILL BY ACC"                                       
   V622 = "MAY: OFFICERS ASSAULTED"                                        
   V623 = "JUN: MONTH INCLUDED IN"                                         
   V624 = "JUN: LAST UPDATE"                                               
   V625 = "JUN: CARD 0 TYPE"                                               
   V626 = "JUN: CARD 1 TYPE"                                               
   V627 = "JUN: CARD 2 TYPE"                                               
   V628 = "JUN: CARD 3 TYPE"                                               
   V629 = "JUN: CARD 4 TYPE"                                               
   V630 = "JUN: CARD 0 P/T"                                                
   V631 = "JUN: CARD 1 P/T"                                                
   V632 = "JUN: CARD 2 P/T"                                                
   V633 = "JUN: CARD 3 P/T"                                                
   V634 = "JUN: UNFOUNDED MURDER"                                          
   V635 = "JUN: UNFOUNDED MANSLGHTR"                                       
   V636 = "JUN: UNFOUNDED RAPE TOTL"                                       
   V637 = "JUN: UNFOUNDED FORC RAPE"                                       
   V638 = "JUN: UNFOUND ATMPTD RAPE"                                       
   V639 = "JUN: UNFOUND ROBBRY TOTL"                                       
   V640 = "JUN: UNFOUND GUN ROBBERY"                                       
   V641 = "JUN: UNFOUNDED KNIFE ROB"                                       
   V642 = "JUN: UNFND OTHR WEAP ROB"                                       
   V643 = "JUN: UNFND STRNG-ARM ROB"                                       
   V644 = "JUN: UNFOUND ASSLT TOTAL"                                       
   V645 = "JUN: UNFOUND GUN ASSLT"                                         
   V646 = "JUN: UNFOUND KNIFE ASSLT"                                       
   V647 = "JUN: UNFND OTH WPN ASLT"                                        
   V648 = "JUN: UNFND HND/FEET ASLT"                                       
   V649 = "JUN: UNFND SIMPL ASSAULT"                                       
   V650 = "JUN: UNFOUND BURG TOTAL"                                        
   V651 = "JUN: UNFOUND FORCE ENTRY"                                       
   V652 = "JUN: UNFND ENTRY-NO FORC"                                       
   V653 = "JUN: UNFND ATT BURGLARY"                                        
   V654 = "JUN: UNFOUND LARCNY TOTL"                                       
   V655 = "JUN: UF TOT MTR VHC THFT"                                       
   V656 = "JUN: UNFOUND AUTO THEFT"                                        
   V657 = "JUN: UF TRUCK/BUS THEFT"                                        
   V658 = "JUN: UNFND OTH VHC THEFT"                                       
   V659 = "JUN: UNFOUND ALL FIELDS"                                        
   V660 = "JUN: ACT NUM MURDER"                                            
   V661 = "JUN: ACT NUM MANSLGHTR"                                         
   V662 = "JUN: ACT NUM RAPE TOTL"                                         
   V663 = "JUN: ACT NUM FORC RAPE"                                         
   V664 = "JUN: ACT NUM ATMPTD RAPE"                                       
   V665 = "JUN: ACT NUM ROBBRY TOTL"                                       
   V666 = "JUN: ACT NUM GUN ROBBERY"                                       
   V667 = "JUN: ACT NUM KNIFE ROBRY"                                       
   V668 = "JUN: ACT NUM OTH WPN ROB"                                       
   V669 = "JUN: ACT NUM STR ARM ROB"                                       
   V670 = "JUN: ACT NUM ASSLT TOTAL"                                       
   V671 = "JUN: ACT NUM GUN ASSAULT"                                       
   V672 = "JUN: ACT NUM KNIFE ASSLT"                                       
   V673 = "JUN: ACT # OTH WPN ASSLT"                                       
   V674 = "JUN: ACT # HND/FEET ASLT"                                       
   V675 = "JUN: ACT # SIMPLE ASSLT"                                        
   V676 = "JUN: ACT # BURGLARY TOTL"                                       
   V677 = "JUN: ACT # FORCE ENTRY"                                         
   V678 = "JUN: ACT # ENTRY-NO FORC"                                       
   V679 = "JUN: ACT # ATT BURGLARY"                                        
   V680 = "JUN: ACT # LARCENY TOTAL"                                       
   V681 = "JUN: ACT # VHC THEFT TOT"                                       
   V682 = "JUN: ACT # AUTO THEFT"                                          
   V683 = "JUN: ACT # TRCK/BUS THFT"                                       
   V684 = "JUN: ACT # OTH VHC THEFT"                                       
   V685 = "JUN: ACT # ALL FIELDS"                                          
   V686 = "JUN: TOT CLR MURDER"                                            
   V687 = "JUN: TOT CLR MANSLGHTR"                                         
   V688 = "JUN: TOT CLR RAPE TOTAL"                                        
   V689 = "JUN: TOT CLR FORC RAPE"                                         
   V690 = "JUN: TOT CLR ATMPTD RAPE"                                       
   V691 = "JUN: TOT CLR TOTL ROBERY"                                       
   V692 = "JUN: TOT CLR GUN ROBBERY"                                       
   V693 = "JUN: TOT CLR KNIFE ROBRY"                                       
   V694 = "JUN: TOT CLR OTH WPN ROB"                                       
   V695 = "JUN: TOT CLR STR ARM ROB"                                       
   V696 = "JUN: TOT CLR ASSLT TOTAL"                                       
   V697 = "JUN: TOT CLR GUN ASSAULT"                                       
   V698 = "JUN: TOT CLR KNIFE ASSLT"                                       
   V699 = "JUN: TOT CLR OTH WPN ASLT"                                      
   V700 = "JUN: TOT CLR HND/FT ASLT"                                       
   V701 = "JUN: TOT CLR SIMPLE ASLT"                                       
   V702 = "JUN: TOT CLR BRGLRY TOTL"                                       
   V703 = "JUN: TOT CLR FORC ENTRY"                                        
   V704 = "JUN: TOT CLR ENTR-NO FRC"                                       
   V705 = "JUN: TOT CLR ATT BURGLRY"                                       
   V706 = "JUN: TOT CLR LARCNY TOTL"                                       
   V707 = "JUN: TOT CLR VHC THFT TOT"                                      
   V708 = "JUN: TOT CLR AUTO THEFT"                                        
   V709 = "JUN: TOT CLR TRCK/BS THFT"                                      
   V710 = "JUN: TOT CLR OTH VHC THFT"                                      
   V711 = "JUN: TOT CLR ALL FIELDS"                                        
   V712 = "JUN: CLR<18 MURDER"                                             
   V713 = "JUN: CLR<18 MANSLGHTR"                                          
   V714 = "JUN: CLR<18 RAPE TOTAL"                                         
   V715 = "JUN: CLR<18 FORCE RAPE"                                         
   V716 = "JUN: CLR<18 ATTMPTD RAPE"                                       
   V717 = "JUN: CLR<18 ROBBERY TOTL"                                       
   V718 = "JUN: CLR<18 GUN ROBBERY"                                        
   V719 = "JUN: CLR<18 KNIFE ROBBRY"                                       
   V720 = "JUN: CLR<18 OTH WPN RBRY"                                       
   V721 = "JUN: CLR<18 STR ARM ROB"                                        
   V722 = "JUN: CLR<18 ASSLT TOTAL"                                        
   V723 = "JUN: CLR<18 GUN ASSAULT"                                        
   V724 = "JUN: CLR<18 KNIFE ASSLT"                                        
   V725 = "JUN: CLR<18 OTH WPN ASLT"                                       
   V726 = "JUN: CLR<18 HND/FT ASSLT"                                       
   V727 = "JUN: CLR<18 SIMPLE ASSLT"                                       
   V728 = "JUN: CLR<18 BURGLRY TOTL"                                       
   V729 = "JUN: CLR<18 FORC ENTRY"                                         
   V730 = "JUN: CLR<18 ENTR-NO FORC"                                       
   V731 = "JUN: CLR<18 ATT BURGLARY"                                       
   V732 = "JUN: CLR<18 LARCENY TOTL"                                       
   V733 = "JUN: CLR<18 VHC THFT TOT"                                       
   V734 = "JUN: CLR<18 AUTO THEFT"                                         
   V735 = "JUN: CLR<18 TRCK/BS THFT"                                       
   V736 = "JUN: CLR<18 OTH VHC THFT"                                       
   V737 = "JUN: CLR<18 ALL FIELDS"                                         
   V738 = "JUN: OFFICRS KILL BY FEL"                                       
   V739 = "JUN: OFFICRS KILL BY ACC"                                       
   V740 = "JUN: OFFICERS ASSAULTED"                                        
   V741 = "JUL: MONTH INCLUDED IN"                                         
   V742 = "JUL: LAST UPDATE"                                               
   V743 = "JUL: CARD 0 TYPE"                                               
   V744 = "JUL: CARD 1 TYPE"                                               
   V745 = "JUL: CARD 2 TYPE"                                               
   V746 = "JUL: CARD 3 TYPE"                                               
   V747 = "JUL: CARD 4 TYPE"                                               
   V748 = "JUL: CARD 0 P/T"                                                
   V749 = "JUL: CARD 1 P/T"                                                
   V750 = "JUL: CARD 2 P/T"                                                
   V751 = "JUL: CARD 3 P/T"                                                
   V752 = "JUL: UNFOUNDED MURDER"                                          
   V753 = "JUL: UNFOUNDED MANSLGHTR"                                       
   V754 = "JUL: UNFOUNDED RAPE TOTL"                                       
   V755 = "JUL: UNFOUNDED FORC RAPE"                                       
   V756 = "JUL: UNFOUND ATMPTD RAPE"                                       
   V757 = "JUL: UNFOUND ROBBRY TOTL"                                       
   V758 = "JUL: UNFOUND GUN ROBBERY"                                       
   V759 = "JUL: UNFOUNDED KNIFE ROB"                                       
   V760 = "JUL: UNFND OTHR WEAP ROB"                                       
   V761 = "JUL: UNFND STRNG-ARM ROB"                                       
   V762 = "JUL: UNFOUND ASSLT TOTAL"                                       
   V763 = "JUL: UNFOUND GUN ASSLT"                                         
   V764 = "JUL: UNFOUND KNIFE ASSLT"                                       
   V765 = "JUL: UNFND OTH WPN ASLT"                                        
   V766 = "JUL: UNFND HND/FEET ASLT"                                       
   V767 = "JUL: UNFND SIMPL ASSAULT"                                       
   V768 = "JUL: UNFOUND BURG TOTAL"                                        
   V769 = "JUL: UNFOUND FORCE ENTRY"                                       
   V770 = "JUL: UNFND ENTRY-NO FORC"                                       
   V771 = "JUL: UNFND ATT BURGLARY"                                        
   V772 = "JUL: UNFOUND LARCNY TOTL"                                       
   V773 = "JUL: UF TOT MTR VHC THFT"                                       
   V774 = "JUL: UNFOUND AUTO THEFT"                                        
   V775 = "JUL: UF TRUCK/BUS THEFT"                                        
   V776 = "JUL: UNFND OTH VHC THEFT"                                       
   V777 = "JUL: UNFOUND ALL FIELDS"                                        
   V778 = "JUL: ACT NUM MURDER"                                            
   V779 = "JUL: ACT NUM MANSLGHTR"                                         
   V780 = "JUL: ACT NUM RAPE TOTL"                                         
   V781 = "JUL: ACT NUM FORC RAPE"                                         
   V782 = "JUL: ACT NUM ATMPTD RAPE"                                       
   V783 = "JUL: ACT NUM ROBBRY TOTL"                                       
   V784 = "JUL: ACT NUM GUN ROBBERY"                                       
   V785 = "JUL: ACT NUM KNIFE ROBRY"                                       
   V786 = "JUL: ACT NUM OTH WPN ROB"                                       
   V787 = "JUL: ACT NUM STR ARM ROB"                                       
   V788 = "JUL: ACT NUM ASSLT TOTAL"                                       
   V789 = "JUL: ACT NUM GUN ASSAULT"                                       
   V790 = "JUL: ACT NUM KNIFE ASSLT"                                       
   V791 = "JUL: ACT # OTH WPN ASSLT"                                       
   V792 = "JUL: ACT # HND/FEET ASLT"                                       
   V793 = "JUL: ACT # SIMPLE ASSLT"                                        
   V794 = "JUL: ACT # BURGLARY TOTL"                                       
   V795 = "JUL: ACT # FORCE ENTRY"                                         
   V796 = "JUL: ACT # ENTRY-NO FORC"                                       
   V797 = "JUL: ACT # ATT BURGLARY"                                        
   V798 = "JUL: ACT # LARCENY TOTAL"                                       
   V799 = "JUL: ACT # VHC THEFT TOT"                                       
   V800 = "JUL: ACT # AUTO THEFT"                                          
   V801 = "JUL: ACT # TRCK/BUS THFT"                                       
   V802 = "JUL: ACT # OTH VHC THEFT"                                       
   V803 = "JUL: ACT # ALL FIELDS"                                          
   V804 = "JUL: TOT CLR MURDER"                                            
   V805 = "JUL: TOT CLR MANSLGHTR"                                         
   V806 = "JUL: TOT CLR RAPE TOTAL"                                        
   V807 = "JUL: TOT CLR FORC RAPE"                                         
   V808 = "JUL: TOT CLR ATMPTD RAPE"                                       
   V809 = "JUL: TOT CLR TOTL ROBERY"                                       
   V810 = "JUL: TOT CLR GUN ROBBERY"                                       
   V811 = "JUL: TOT CLR KNIFE ROBRY"                                       
   V812 = "JUL: TOT CLR OTH WPN ROB"                                       
   V813 = "JUL: TOT CLR STR ARM ROB"                                       
   V814 = "JUL: TOT CLR ASSLT TOTAL"                                       
   V815 = "JUL: TOT CLR GUN ASSAULT"                                       
   V816 = "JUL: TOT CLR KNIFE ASSLT"                                       
   V817 = "JUL: TOT CLR OTH WPN ASLT"                                      
   V818 = "JUL: TOT CLR HND/FT ASLT"                                       
   V819 = "JUL: TOT CLR SIMPLE ASLT"                                       
   V820 = "JUL: TOT CLR BRGLRY TOTL"                                       
   V821 = "JUL: TOT CLR FORC ENTRY"                                        
   V822 = "JUL: TOT CLR ENTR-NO FRC"                                       
   V823 = "JUL: TOT CLR ATT BURGLRY"                                       
   V824 = "JUL: TOT CLR LARCNY TOTL"                                       
   V825 = "JUL: TOT CLR VHC THFT TOT"                                      
   V826 = "JUL: TOT CLR AUTO THEFT"                                        
   V827 = "JUL: TOT CLR TRCK/BS THFT"                                      
   V828 = "JUL: TOT CLR OTH VHC THFT"                                      
   V829 = "JUL: TOT CLR ALL FIELDS"                                        
   V830 = "JUL: CLR<18 MURDER"                                             
   V831 = "JUL: CLR<18 MANSLGHTR"                                          
   V832 = "JUL: CLR<18 RAPE TOTAL"                                         
   V833 = "JUL: CLR<18 FORCE RAPE"                                         
   V834 = "JUL: CLR<18 ATTMPTD RAPE"                                       
   V835 = "JUL: CLR<18 ROBBERY TOTL"                                       
   V836 = "JUL: CLR<18 GUN ROBBERY"                                        
   V837 = "JUL: CLR<18 KNIFE ROBBRY"                                       
   V838 = "JUL: CLR<18 OTH WPN RBRY"                                       
   V839 = "JUL: CLR<18 STR ARM ROB"                                        
   V840 = "JUL: CLR<18 ASSLT TOTAL"                                        
   V841 = "JUL: CLR<18 GUN ASSAULT"                                        
   V842 = "JUL: CLR<18 KNIFE ASSLT"                                        
   V843 = "JUL: CLR<18 OTH WPN ASLT"                                       
   V844 = "JUL: CLR<18 HND/FT ASSLT"                                       
   V845 = "JUL: CLR<18 SIMPLE ASSLT"                                       
   V846 = "JUL: CLR<18 BURGLRY TOTL"                                       
   V847 = "JUL: CLR<18 FORC ENTRY"                                         
   V848 = "JUL: CLR<18 ENTR-NO FORC"                                       
   V849 = "JUL: CLR<18 ATT BURGLARY"                                       
   V850 = "JUL: CLR<18 LARCENY TOTL"                                       
   V851 = "JUL: CLR<18 VHC THFT TOT"                                       
   V852 = "JUL: CLR<18 AUTO THEFT"                                         
   V853 = "JUL: CLR<18 TRCK/BS THFT"                                       
   V854 = "JUL: CLR<18 OTH VHC THFT"                                       
   V855 = "JUL: CLR<18 ALL FIELDS"                                         
   V856 = "JUL: OFFICRS KILL BY FEL"                                       
   V857 = "JUL: OFFICRS KILL BY ACC"                                       
   V858 = "JUL: OFFICERS ASSAULTED"                                        
   V859 = "AUG: MONTH INCLUDED IN"                                         
   V860 = "AUG: LAST UPDATE"                                               
   V861 = "AUG: CARD 0 TYPE"                                               
   V862 = "AUG: CARD 1 TYPE"                                               
   V863 = "AUG: CARD 2 TYPE"                                               
   V864 = "AUG: CARD 3 TYPE"                                               
   V865 = "AUG: CARD 4 TYPE"                                               
   V866 = "AUG: CARD 0 P/T"                                                
   V867 = "AUG: CARD 1 P/T"                                                
   V868 = "AUG: CARD 2 P/T"                                                
   V869 = "AUG: CARD 3 P/T"                                                
   V870 = "AUG: UNFOUNDED MURDER"                                          
   V871 = "AUG: UNFOUNDED MANSLGHTR"                                       
   V872 = "AUG: UNFOUNDED RAPE TOTL"                                       
   V873 = "AUG: UNFOUNDED FORC RAPE"                                       
   V874 = "AUG: UNFOUND ATMPTD RAPE"                                       
   V875 = "AUG: UNFOUND ROBBRY TOTL"                                       
   V876 = "AUG: UNFOUND GUN ROBBERY"                                       
   V877 = "AUG: UNFOUNDED KNIFE ROB"                                       
   V878 = "AUG: UNFND OTHR WEAP ROB"                                       
   V879 = "AUG: UNFND STRNG-ARM ROB"                                       
   V880 = "AUG: UNFOUND ASSLT TOTAL"                                       
   V881 = "AUG: UNFOUND GUN ASSLT"                                         
   V882 = "AUG: UNFOUND KNIFE ASSLT"                                       
   V883 = "AUG: UNFND OTH WPN ASLT"                                        
   V884 = "AUG: UNFND HND/FEET ASLT"                                       
   V885 = "AUG: UNFND SIMPL ASSAULT"                                       
   V886 = "AUG: UNFOUND BURG TOTAL"                                        
   V887 = "AUG: UNFOUND FORCE ENTRY"                                       
   V888 = "AUG: UNFND ENTRY-NO FORC"                                       
   V889 = "AUG: UNFND ATT BURGLARY"                                        
   V890 = "AUG: UNFOUND LARCNY TOTL"                                       
   V891 = "AUG: UF TOT MTR VHC THFT"                                       
   V892 = "AUG: UNFOUND AUTO THEFT"                                        
   V893 = "AUG: UF TRUCK/BUS THEFT"                                        
   V894 = "AUG: UNFND OTH VHC THEFT"                                       
   V895 = "AUG: UNFOUND ALL FIELDS"                                        
   V896 = "AUG: ACT NUM MURDER"                                            
   V897 = "AUG: ACT NUM MANSLGHTR"                                         
   V898 = "AUG: ACT NUM RAPE TOTL"                                         
   V899 = "AUG: ACT NUM FORC RAPE"                                         
   V900 = "AUG: ACT NUM ATMPTD RAPE"                                       
   V901 = "AUG: ACT NUM ROBBRY TOTL"                                       
   V902 = "AUG: ACT NUM GUN ROBBERY"                                       
   V903 = "AUG: ACT NUM KNIFE ROBRY"                                       
   V904 = "AUG: ACT NUM OTH WPN ROB"                                       
   V905 = "AUG: ACT NUM STR ARM ROB"                                       
   V906 = "AUG: ACT NUM ASSLT TOTAL"                                       
   V907 = "AUG: ACT NUM GUN ASSAULT"                                       
   V908 = "AUG: ACT NUM KNIFE ASSLT"                                       
   V909 = "AUG: ACT # OTH WPN ASSLT"                                       
   V910 = "AUG: ACT # HND/FEET ASLT"                                       
   V911 = "AUG: ACT # SIMPLE ASSLT"                                        
   V912 = "AUG: ACT # BURGLARY TOTL"                                       
   V913 = "AUG: ACT # FORCE ENTRY"                                         
   V914 = "AUG: ACT # ENTRY-NO FORC"                                       
   V915 = "AUG: ACT # ATT BURGLARY"                                        
   V916 = "AUG: ACT # LARCENY TOTAL"                                       
   V917 = "AUG: ACT # VHC THEFT TOT"                                       
   V918 = "AUG: ACT # AUTO THEFT"                                          
   V919 = "AUG: ACT # TRCK/BUS THFT"                                       
   V920 = "AUG: ACT # OTH VHC THEFT"                                       
   V921 = "AUG: ACT # ALL FIELDS"                                          
   V922 = "AUG: TOT CLR MURDER"                                            
   V923 = "AUG: TOT CLR MANSLGHTR"                                         
   V924 = "AUG: TOT CLR RAPE TOTAL"                                        
   V925 = "AUG: TOT CLR FORC RAPE"                                         
   V926 = "AUG: TOT CLR ATMPTD RAPE"                                       
   V927 = "AUG: TOT CLR TOTL ROBERY"                                       
   V928 = "AUG: TOT CLR GUN ROBBERY"                                       
   V929 = "AUG: TOT CLR KNIFE ROBRY"                                       
   V930 = "AUG: TOT CLR OTH WPN ROB"                                       
   V931 = "AUG: TOT CLR STR ARM ROB"                                       
   V932 = "AUG: TOT CLR ASSLT TOTAL"                                       
   V933 = "AUG: TOT CLR GUN ASSAULT"                                       
   V934 = "AUG: TOT CLR KNIFE ASSLT"                                       
   V935 = "AUG: TOT CLR OTH WPN ASLT"                                      
   V936 = "AUG: TOT CLR HND/FT ASLT"                                       
   V937 = "AUG: TOT CLR SIMPLE ASLT"                                       
   V938 = "AUG: TOT CLR BRGLRY TOTL"                                       
   V939 = "AUG: TOT CLR FORC ENTRY"                                        
   V940 = "AUG: TOT CLR ENTR-NO FRC"                                       
   V941 = "AUG: TOT CLR ATT BURGLRY"                                       
   V942 = "AUG: TOT CLR LARCNY TOTL"                                       
   V943 = "AUG: TOT CLR VHC THFT TOT"                                      
   V944 = "AUG: TOT CLR AUTO THEFT"                                        
   V945 = "AUG: TOT CLR TRCK/BS THFT"                                      
   V946 = "AUG: TOT CLR OTH VHC THFT"                                      
   V947 = "AUG: TOT CLR ALL FIELDS"                                        
   V948 = "AUG: CLR<18 MURDER"                                             
   V949 = "AUG: CLR<18 MANSLGHTR"                                          
   V950 = "AUG: CLR<18 RAPE TOTAL"                                         
   V951 = "AUG: CLR<18 FORCE RAPE"                                         
   V952 = "AUG: CLR<18 ATTMPTD RAPE"                                       
   V953 = "AUG: CLR<18 ROBBERY TOTL"                                       
   V954 = "AUG: CLR<18 GUN ROBBERY"                                        
   V955 = "AUG: CLR<18 KNIFE ROBBRY"                                       
   V956 = "AUG: CLR<18 OTH WPN RBRY"                                       
   V957 = "AUG: CLR<18 STR ARM ROB"                                        
   V958 = "AUG: CLR<18 ASSLT TOTAL"                                        
   V959 = "AUG: CLR<18 GUN ASSAULT"                                        
   V960 = "AUG: CLR<18 KNIFE ASSLT"                                        
   V961 = "AUG: CLR<18 OTH WPN ASLT"                                       
   V962 = "AUG: CLR<18 HND/FT ASSLT"                                       
   V963 = "AUG: CLR<18 SIMPLE ASSLT"                                       
   V964 = "AUG: CLR<18 BURGLRY TOTL"                                       
   V965 = "AUG: CLR<18 FORC ENTRY"                                         
   V966 = "AUG: CLR<18 ENTR-NO FORC"                                       
   V967 = "AUG: CLR<18 ATT BURGLARY"                                       
   V968 = "AUG: CLR<18 LARCENY TOTL"                                       
   V969 = "AUG: CLR<18 VHC THFT TOT"                                       
   V970 = "AUG: CLR<18 AUTO THEFT"                                         
   V971 = "AUG: CLR<18 TRCK/BS THFT"                                       
   V972 = "AUG: CLR<18 OTH VHC THFT"                                       
   V973 = "AUG: CLR<18 ALL FIELDS"                                         
   V974 = "AUG: OFFICRS KILL BY FEL"                                       
   V975 = "AUG: OFFICRS KILL BY ACC"                                       
   V976 = "AUG: OFFICERS ASSAULTED"                                        
   V977 = "SEP: MONTH INCLUDED IN"                                         
   V978 = "SEP: LAST UPDATE"                                               
   V979 = "SEP: CARD 0 TYPE"                                               
   V980 = "SEP: CARD 1 TYPE"                                               
   V981 = "SEP: CARD 2 TYPE"                                               
   V982 = "SEP: CARD 3 TYPE"                                               
   V983 = "SEP: CARD 4 TYPE"                                               
   V984 = "SEP: CARD 0 P/T"                                                
   V985 = "SEP: CARD 1 P/T"                                                
   V986 = "SEP: CARD 2 P/T"                                                
   V987 = "SEP: CARD 3 P/T"                                                
   V988 = "SEP: UNFOUNDED MURDER"                                          
   V989 = "SEP: UNFOUNDED MANSLGHTR"                                       
   V990 = "SEP: UNFOUNDED RAPE TOT"                                        
   V991 = "SEP: UNFOUNDED FORC RAP"                                        
   V992 = "SEP: UNFOUND ATMPTD RAP"                                        
   V993 = "SEP: UNFOUND ROBBRY TOT"                                        
   V994 = "SEP: UNFOUND GUN ROBBER"                                        
   V995 = "SEP: UNFOUNDED KNIFE RO"                                        
   V996 = "SEP: UNFND OTHR WEAP RO"                                        
   V997 = "SEP: UNFND STRNG-ARM RO"                                        
   V998 = "SEP: UNFOUND ASSLT TOTA"                                        
   V999 = "SEP: UNFOUND GUN ASSLT"                                         
   V1000 = "SEP: UNFOUND KNIFE ASSL"                                       
   V1001 = "SEP: UNFND OTH WPN ASLT"                                       
   V1002 = "SEP: UNFND HND/FEET ASL"                                       
   V1003 = "SEP: UNFND SIMPL ASSAUL"                                       
   V1004 = "SEP: UNFOUND BURG TOTAL"                                       
   V1005 = "SEP: UNFOUND FORCE ENTR"                                       
   V1006 = "SEP: UNFND ENTRY-NO FOR"                                       
   V1007 = "SEP: UNFND ATT BURGLARY"                                       
   V1008 = "SEP: UNFOUND LARCNY TOT"                                       
   V1009 = "SEP: UF TOT MTR VHC THF"                                       
   V1010 = "SEP: UNFOUND AUTO THEFT"                                       
   V1011 = "SEP: UF TRUCK/BUS THEFT"                                       
   V1012 = "SEP: UNFND OTH VHC THEF"                                       
   V1013 = "SEP: UNFOUND ALL FIELDS"                                       
   V1014 = "SEP: ACT NUM MURDER"                                           
   V1015 = "SEP: ACT NUM MANSLGHTR"                                        
   V1016 = "SEP: ACT NUM RAPE TOTL"                                        
   V1017 = "SEP: ACT NUM FORC RAPE"                                        
   V1018 = "SEP: ACT NUM ATMPTD RAP"                                       
   V1019 = "SEP: ACT NUM ROBBRY TOT"                                       
   V1020 = "SEP: ACT NUM GUN ROBBER"                                       
   V1021 = "SEP: ACT NUM KNIFE ROBR"                                       
   V1022 = "SEP: ACT NUM OTH WPN RO"                                       
   V1023 = "SEP: ACT NUM STR ARM RO"                                       
   V1024 = "SEP: ACT NUM ASSLT TOTA"                                       
   V1025 = "SEP: ACT NUM GUN ASSAUL"                                       
   V1026 = "SEP: ACT NUM KNIFE ASSL"                                       
   V1027 = "SEP: ACT # OTH WPN ASSL"                                       
   V1028 = "SEP: ACT # HND/FEET ASL"                                       
   V1029 = "SEP: ACT # SIMPLE ASSLT"                                       
   V1030 = "SEP: ACT # BURGLARY TOT"                                       
   V1031 = "SEP: ACT # FORCE ENTRY"                                        
   V1032 = "SEP: ACT # ENTRY-NO FOR"                                       
   V1033 = "SEP: ACT # ATT BURGLARY"                                       
   V1034 = "SEP: ACT # LARCENY TOTA"                                       
   V1035 = "SEP: ACT # VHC THEFT TO"                                       
   V1036 = "SEP: ACT # AUTO THEFT"                                         
   V1037 = "SEP: ACT # TRCK/BUS THF"                                       
   V1038 = "SEP: ACT # OTH VHC THEF"                                       
   V1039 = "SEP: ACT # ALL FIELDS"                                         
   V1040 = "SEP: TOT CLR MURDER"                                           
   V1041 = "SEP: TOT CLR MANSLGHTR"                                        
   V1042 = "SEP: TOT CLR RAPE TOTAL"                                       
   V1043 = "SEP: TOT CLR FORC RAPE"                                        
   V1044 = "SEP: TOT CLR ATMPTD RAP"                                       
   V1045 = "SEP: TOT CLR TOTL ROBER"                                       
   V1046 = "SEP: TOT CLR GUN ROBBER"                                       
   V1047 = "SEP: TOT CLR KNIFE ROBR"                                       
   V1048 = "SEP: TOT CLR OTH WPN RO"                                       
   V1049 = "SEP: TOT CLR STR ARM RO"                                       
   V1050 = "SEP: TOT CLR ASSLT TOTA"                                       
   V1051 = "SEP: TOT CLR GUN ASSAUL"                                       
   V1052 = "SEP: TOT CLR KNIFE ASSL"                                       
   V1053 = "SEP: TOT CLR OTH WPN ASL"                                      
   V1054 = "SEP: TOT CLR HND/FT ASL"                                       
   V1055 = "SEP: TOT CLR SIMPLE ASL"                                       
   V1056 = "SEP: TOT CLR BRGLRY TOT"                                       
   V1057 = "SEP: TOT CLR FORC ENTRY"                                       
   V1058 = "SEP: TOT CLR ENTR-NO FR"                                       
   V1059 = "SEP: TOT CLR ATT BURGLR"                                       
   V1060 = "SEP: TOT CLR LARCNY TOT"                                       
   V1061 = "SEP: TOT CLR VHC THFT TO"                                      
   V1062 = "SEP: TOT CLR AUTO THEFT"                                       
   V1063 = "SEP: TOT CLR TRCK/BS THF"                                      
   V1064 = "SEP: TOT CLR OTH VHC THF"                                      
   V1065 = "SEP: TOT CLR ALL FIELDS"                                       
   V1066 = "SEP: CLR<18 MURDER"                                            
   V1067 = "SEP: CLR<18 MANSLGHTR"                                         
   V1068 = "SEP: CLR<18 RAPE TOTAL"                                        
   V1069 = "SEP: CLR<18 FORCE RAPE"                                        
   V1070 = "SEP: CLR<18 ATTMPTD RAP"                                       
   V1071 = "SEP: CLR<18 ROBBERY TOT"                                       
   V1072 = "SEP: CLR<18 GUN ROBBERY"                                       
   V1073 = "SEP: CLR<18 KNIFE ROBBR"                                       
   V1074 = "SEP: CLR<18 OTH WPN RBR"                                       
   V1075 = "SEP: CLR<18 STR ARM ROB"                                       
   V1076 = "SEP: CLR<18 ASSLT TOTAL"                                       
   V1077 = "SEP: CLR<18 GUN ASSAULT"                                       
   V1078 = "SEP: CLR<18 KNIFE ASSLT"                                       
   V1079 = "SEP: CLR<18 OTH WPN ASL"                                       
   V1080 = "SEP: CLR<18 HND/FT ASSL"                                       
   V1081 = "SEP: CLR<18 SIMPLE ASSL"                                       
   V1082 = "SEP: CLR<18 BURGLRY TOT"                                       
   V1083 = "SEP: CLR<18 FORC ENTRY"                                        
   V1084 = "SEP: CLR<18 ENTR-NO FOR"                                       
   V1085 = "SEP: CLR<18 ATT BURGLAR"                                       
   V1086 = "SEP: CLR<18 LARCENY TOT"                                       
   V1087 = "SEP: CLR<18 VHC THFT TO"                                       
   V1088 = "SEP: CLR<18 AUTO THEFT"                                        
   V1089 = "SEP: CLR<18 TRCK/BS THF"                                       
   V1090 = "SEP: CLR<18 OTH VHC THF"                                       
   V1091 = "SEP: CLR<18 ALL FIELDS"                                        
   V1092 = "SEP: OFFICRS KILL BY FE"                                       
   V1093 = "SEP: OFFICRS KILL BY AC"                                       
   V1094 = "SEP: OFFICERS ASSAULTED"                                       
   V1095 = "OCT: MONTH INCLUDED IN"                                        
   V1096 = "OCT: LAST UPDATE"                                              
   V1097 = "OCT: CARD 0 TYPE"                                              
   V1098 = "OCT: CARD 1 TYPE"                                              
   V1099 = "OCT: CARD 2 TYPE"                                              
   V1100 = "OCT: CARD 3 TYPE"                                              
   V1101 = "OCT: CARD 4 TYPE"                                              
   V1102 = "OCT: CARD 0 P/T"                                               
   V1103 = "OCT: CARD 1 P/T"                                               
   V1104 = "OCT: CARD 2 P/T"                                               
   V1105 = "OCT: CARD 3 P/T"                                               
   V1106 = "OCT: UNFOUNDED MURDER"                                         
   V1107 = "OCT: UNFOUNDED MANSLGHT"                                       
   V1108 = "OCT: UNFOUNDED RAPE TOT"                                       
   V1109 = "OCT: UNFOUNDED FORC RAP"                                       
   V1110 = "OCT: UNFOUND ATMPTD RAP"                                       
   V1111 = "OCT: UNFOUND ROBBRY TOT"                                       
   V1112 = "OCT: UNFOUND GUN ROBBER"                                       
   V1113 = "OCT: UNFOUNDED KNIFE RO"                                       
   V1114 = "OCT: UNFND OTHR WEAP RO"                                       
   V1115 = "OCT: UNFND STRNG-ARM RO"                                       
   V1116 = "OCT: UNFOUND ASSLT TOTA"                                       
   V1117 = "OCT: UNFOUND GUN ASSLT"                                        
   V1118 = "OCT: UNFOUND KNIFE ASSL"                                       
   V1119 = "OCT: UNFND OTH WPN ASLT"                                       
   V1120 = "OCT: UNFND HND/FEET ASL"                                       
   V1121 = "OCT: UNFND SIMPL ASSAUL"                                       
   V1122 = "OCT: UNFOUND BURG TOTAL"                                       
   V1123 = "OCT: UNFOUND FORCE ENTR"                                       
   V1124 = "OCT: UNFND ENTRY-NO FOR"                                       
   V1125 = "OCT: UNFND ATT BURGLARY"                                       
   V1126 = "OCT: UNFOUND LARCNY TOT"                                       
   V1127 = "OCT: UF TOT MTR VHC THF"                                       
   V1128 = "OCT: UNFOUND AUTO THEFT"                                       
   V1129 = "OCT: UF TRUCK/BUS THEFT"                                       
   V1130 = "OCT: UNFND OTH VHC THEF"                                       
   V1131 = "OCT: UNFOUND ALL FIELDS"                                       
   V1132 = "OCT: ACT NUM MURDER"                                           
   V1133 = "OCT: ACT NUM MANSLGHTR"                                        
   V1134 = "OCT: ACT NUM RAPE TOTL"                                        
   V1135 = "OCT: ACT NUM FORC RAPE"                                        
   V1136 = "OCT: ACT NUM ATMPTD RAP"                                       
   V1137 = "OCT: ACT NUM ROBBRY TOT"                                       
   V1138 = "OCT: ACT NUM GUN ROBBER"                                       
   V1139 = "OCT: ACT NUM KNIFE ROBR"                                       
   V1140 = "OCT: ACT NUM OTH WPN RO"                                       
   V1141 = "OCT: ACT NUM STR ARM RO"                                       
   V1142 = "OCT: ACT NUM ASSLT TOTA"                                       
   V1143 = "OCT: ACT NUM GUN ASSAUL"                                       
   V1144 = "OCT: ACT NUM KNIFE ASSL"                                       
   V1145 = "OCT: ACT # OTH WPN ASSL"                                       
   V1146 = "OCT: ACT # HND/FEET ASL"                                       
   V1147 = "OCT: ACT # SIMPLE ASSLT"                                       
   V1148 = "OCT: ACT # BURGLARY TOT"                                       
   V1149 = "OCT: ACT # FORCE ENTRY"                                        
   V1150 = "OCT: ACT # ENTRY-NO FOR"                                       
   V1151 = "OCT: ACT # ATT BURGLARY"                                       
   V1152 = "OCT: ACT # LARCENY TOTA"                                       
   V1153 = "OCT: ACT # VHC THEFT TO"                                       
   V1154 = "OCT: ACT # AUTO THEFT"                                         
   V1155 = "OCT: ACT # TRCK/BUS THF"                                       
   V1156 = "OCT: ACT # OTH VHC THEF"                                       
   V1157 = "OCT: ACT # ALL FIELDS"                                         
   V1158 = "OCT: TOT CLR MURDER"                                           
   V1159 = "OCT: TOT CLR MANSLGHTR"                                        
   V1160 = "OCT: TOT CLR RAPE TOTAL"                                       
   V1161 = "OCT: TOT CLR FORC RAPE"                                        
   V1162 = "OCT: TOT CLR ATMPTD RAP"                                       
   V1163 = "OCT: TOT CLR TOTL ROBER"                                       
   V1164 = "OCT: TOT CLR GUN ROBBER"                                       
   V1165 = "OCT: TOT CLR KNIFE ROBR"                                       
   V1166 = "OCT: TOT CLR OTH WPN RO"                                       
   V1167 = "OCT: TOT CLR STR ARM RO"                                       
   V1168 = "OCT: TOT CLR ASSLT TOTA"                                       
   V1169 = "OCT: TOT CLR GUN ASSAUL"                                       
   V1170 = "OCT: TOT CLR KNIFE ASSL"                                       
   V1171 = "OCT: TOT CLR OTH WPN ASL"                                      
   V1172 = "OCT: TOT CLR HND/FT ASL"                                       
   V1173 = "OCT: TOT CLR SIMPLE ASL"                                       
   V1174 = "OCT: TOT CLR BRGLRY TOT"                                       
   V1175 = "OCT: TOT CLR FORC ENTRY"                                       
   V1176 = "OCT: TOT CLR ENTR-NO FR"                                       
   V1177 = "OCT: TOT CLR ATT BURGLR"                                       
   V1178 = "OCT: TOT CLR LARCNY TOT"                                       
   V1179 = "OCT: TOT CLR VHC THFT TO"                                      
   V1180 = "OCT: TOT CLR AUTO THEFT"                                       
   V1181 = "OCT: TOT CLR TRCK/BS THF"                                      
   V1182 = "OCT: TOT CLR OTH VHC THF"                                      
   V1183 = "OCT: TOT CLR ALL FIELDS"                                       
   V1184 = "OCT: CLR<18 MURDER"                                            
   V1185 = "OCT: CLR<18 MANSLGHTR"                                         
   V1186 = "OCT: CLR<18 RAPE TOTAL"                                        
   V1187 = "OCT: CLR<18 FORCE RAPE"                                        
   V1188 = "OCT: CLR<18 ATTMPTD RAP"                                       
   V1189 = "OCT: CLR<18 ROBBERY TOT"                                       
   V1190 = "OCT: CLR<18 GUN ROBBERY"                                       
   V1191 = "OCT: CLR<18 KNIFE ROBBR"                                       
   V1192 = "OCT: CLR<18 OTH WPN RBR"                                       
   V1193 = "OCT: CLR<18 STR ARM ROB"                                       
   V1194 = "OCT: CLR<18 ASSLT TOTAL"                                       
   V1195 = "OCT: CLR<18 GUN ASSAULT"                                       
   V1196 = "OCT: CLR<18 KNIFE ASSLT"                                       
   V1197 = "OCT: CLR<18 OTH WPN ASL"                                       
   V1198 = "OCT: CLR<18 HND/FT ASSL"                                       
   V1199 = "OCT: CLR<18 SIMPLE ASSL"                                       
   V1200 = "OCT: CLR<18 BURGLRY TOT"                                       
   V1201 = "OCT: CLR<18 FORC ENTRY"                                        
   V1202 = "OCT: CLR<18 ENTR-NO FOR"                                       
   V1203 = "OCT: CLR<18 ATT BURGLAR"                                       
   V1204 = "OCT: CLR<18 LARCENY TOT"                                       
   V1205 = "OCT: CLR<18 VHC THFT TO"                                       
   V1206 = "OCT: CLR<18 AUTO THEFT"                                        
   V1207 = "OCT: CLR<18 TRCK/BS THF"                                       
   V1208 = "OCT: CLR<18 OTH VHC THF"                                       
   V1209 = "OCT: CLR<18 ALL FIELDS"                                        
   V1210 = "OCT: OFFICRS KILL BY FE"                                       
   V1211 = "OCT: OFFICRS KILL BY AC"                                       
   V1212 = "OCT: OFFICERS ASSAULTED"                                       
   V1213 = "NOV: MONTH INCLUDED IN"                                        
   V1214 = "NOV: LAST UPDATE"                                              
   V1215 = "NOV: CARD 0 TYPE"                                              
   V1216 = "NOV: CARD 1 TYPE"                                              
   V1217 = "NOV: CARD 2 TYPE"                                              
   V1218 = "NOV: CARD 3 TYPE"                                              
   V1219 = "NOV: CARD 4 TYPE"                                              
   V1220 = "NOV: CARD 0 P/T"                                               
   V1221 = "NOV: CARD 1 P/T"                                               
   V1222 = "NOV: CARD 2 P/T"                                               
   V1223 = "NOV: CARD 3 P/T"                                               
   V1224 = "NOV: UNFOUNDED MURDER"                                         
   V1225 = "NOV: UNFOUNDED MANSLGHT"                                       
   V1226 = "NOV: UNFOUNDED RAPE TOT"                                       
   V1227 = "NOV: UNFOUNDED FORC RAP"                                       
   V1228 = "NOV: UNFOUND ATMPTD RAP"                                       
   V1229 = "NOV: UNFOUND ROBBRY TOT"                                       
   V1230 = "NOV: UNFOUND GUN ROBBER"                                       
   V1231 = "NOV: UNFOUNDED KNIFE RO"                                       
   V1232 = "NOV: UNFND OTHR WEAP RO"                                       
   V1233 = "NOV: UNFND STRNG-ARM RO"                                       
   V1234 = "NOV: UNFOUND ASSLT TOTA"                                       
   V1235 = "NOV: UNFOUND GUN ASSLT"                                        
   V1236 = "NOV: UNFOUND KNIFE ASSL"                                       
   V1237 = "NOV: UNFND OTH WPN ASLT"                                       
   V1238 = "NOV: UNFND HND/FEET ASL"                                       
   V1239 = "NOV: UNFND SIMPL ASSAUL"                                       
   V1240 = "NOV: UNFOUND BURG TOTAL"                                       
   V1241 = "NOV: UNFOUND FORCE ENTR"                                       
   V1242 = "NOV: UNFND ENTRY-NO FOR"                                       
   V1243 = "NOV: UNFND ATT BURGLARY"                                       
   V1244 = "NOV: UNFOUND LARCNY TOT"                                       
   V1245 = "NOV: UF TOT MTR VHC THF"                                       
   V1246 = "NOV: UNFOUND AUTO THEFT"                                       
   V1247 = "NOV: UF TRUCK/BUS THEFT"                                       
   V1248 = "NOV: UNFND OTH VHC THEF"                                       
   V1249 = "NOV: UNFOUND ALL FIELDS"                                       
   V1250 = "NOV: ACT NUM MURDER"                                           
   V1251 = "NOV: ACT NUM MANSLGHTR"                                        
   V1252 = "NOV: ACT NUM RAPE TOTL"                                        
   V1253 = "NOV: ACT NUM FORC RAPE"                                        
   V1254 = "NOV: ACT NUM ATMPTD RAP"                                       
   V1255 = "NOV: ACT NUM ROBBRY TOT"                                       
   V1256 = "NOV: ACT NUM GUN ROBBER"                                       
   V1257 = "NOV: ACT NUM KNIFE ROBR"                                       
   V1258 = "NOV: ACT NUM OTH WPN RO"                                       
   V1259 = "NOV: ACT NUM STR ARM RO"                                       
   V1260 = "NOV: ACT NUM ASSLT TOTA"                                       
   V1261 = "NOV: ACT NUM GUN ASSAUL"                                       
   V1262 = "NOV: ACT NUM KNIFE ASSL"                                       
   V1263 = "NOV: ACT # OTH WPN ASSL"                                       
   V1264 = "NOV: ACT # HND/FEET ASL"                                       
   V1265 = "NOV: ACT # SIMPLE ASSLT"                                       
   V1266 = "NOV: ACT # BURGLARY TOT"                                       
   V1267 = "NOV: ACT # FORCE ENTRY"                                        
   V1268 = "NOV: ACT # ENTRY-NO FOR"                                       
   V1269 = "NOV: ACT # ATT BURGLARY"                                       
   V1270 = "NOV: ACT # LARCENY TOTA"                                       
   V1271 = "NOV: ACT # VHC THEFT TO"                                       
   V1272 = "NOV: ACT # AUTO THEFT"                                         
   V1273 = "NOV: ACT # TRCK/BUS THF"                                       
   V1274 = "NOV: ACT # OTH VHC THEF"                                       
   V1275 = "NOV: ACT # ALL FIELDS"                                         
   V1276 = "NOV: TOT CLR MURDER"                                           
   V1277 = "NOV: TOT CLR MANSLGHTR"                                        
   V1278 = "NOV: TOT CLR RAPE TOTAL"                                       
   V1279 = "NOV: TOT CLR FORC RAPE"                                        
   V1280 = "NOV: TOT CLR ATMPTD RAP"                                       
   V1281 = "NOV: TOT CLR TOTL ROBER"                                       
   V1282 = "NOV: TOT CLR GUN ROBBER"                                       
   V1283 = "NOV: TOT CLR KNIFE ROBR"                                       
   V1284 = "NOV: TOT CLR OTH WPN RO"                                       
   V1285 = "NOV: TOT CLR STR ARM RO"                                       
   V1286 = "NOV: TOT CLR ASSLT TOTA"                                       
   V1287 = "NOV: TOT CLR GUN ASSAUL"                                       
   V1288 = "NOV: TOT CLR KNIFE ASSL"                                       
   V1289 = "NOV: TOT CLR OTH WPN ASL"                                      
   V1290 = "NOV: TOT CLR HND/FT ASL"                                       
   V1291 = "NOV: TOT CLR SIMPLE ASL"                                       
   V1292 = "NOV: TOT CLR BRGLRY TOT"                                       
   V1293 = "NOV: TOT CLR FORC ENTRY"                                       
   V1294 = "NOV: TOT CLR ENTR-NO FR"                                       
   V1295 = "NOV: TOT CLR ATT BURGLR"                                       
   V1296 = "NOV: TOT CLR LARCNY TOT"                                       
   V1297 = "NOV: TOT CLR VHC THFT TO"                                      
   V1298 = "NOV: TOT CLR AUTO THEFT"                                       
   V1299 = "NOV: TOT CLR TRCK/BS THF"                                      
   V1300 = "NOV: TOT CLR OTH VHC THF"                                      
   V1301 = "NOV: TOT CLR ALL FIELDS"                                       
   V1302 = "NOV: CLR<18 MURDER"                                            
   V1303 = "NOV: CLR<18 MANSLGHTR"                                         
   V1304 = "NOV: CLR<18 RAPE TOTAL"                                        
   V1305 = "NOV: CLR<18 FORCE RAPE"                                        
   V1306 = "NOV: CLR<18 ATTMPTD RAP"                                       
   V1307 = "NOV: CLR<18 ROBBERY TOT"                                       
   V1308 = "NOV: CLR<18 GUN ROBBERY"                                       
   V1309 = "NOV: CLR<18 KNIFE ROBBR"                                       
   V1310 = "NOV: CLR<18 OTH WPN RBR"                                       
   V1311 = "NOV: CLR<18 STR ARM ROB"                                       
   V1312 = "NOV: CLR<18 ASSLT TOTAL"                                       
   V1313 = "NOV: CLR<18 GUN ASSAULT"                                       
   V1314 = "NOV: CLR<18 KNIFE ASSLT"                                       
   V1315 = "NOV: CLR<18 OTH WPN ASL"                                       
   V1316 = "NOV: CLR<18 HND/FT ASSL"                                       
   V1317 = "NOV: CLR<18 SIMPLE ASSL"                                       
   V1318 = "NOV: CLR<18 BURGLRY TOT"                                       
   V1319 = "NOV: CLR<18 FORC ENTRY"                                        
   V1320 = "NOV: CLR<18 ENTR-NO FOR"                                       
   V1321 = "NOV: CLR<18 ATT BURGLAR"                                       
   V1322 = "NOV: CLR<18 LARCENY TOT"                                       
   V1323 = "NOV: CLR<18 VHC THFT TO"                                       
   V1324 = "NOV: CLR<18 AUTO THEFT"                                        
   V1325 = "NOV: CLR<18 TRCK/BS THF"                                       
   V1326 = "NOV: CLR<18 OTH VHC THF"                                       
   V1327 = "NOV: CLR<18 ALL FIELDS"                                        
   V1328 = "NOV: OFFICRS KILL BY FE"                                       
   V1329 = "NOV: OFFICRS KILL BY AC"                                       
   V1330 = "NOV: OFFICERS ASSAULTED"                                       
   V1331 = "DEC: MONTH INCLUDED IN"                                        
   V1332 = "DEC: LAST UPDATE"                                              
   V1333 = "DEC: CARD 0 TYPE"                                              
   V1334 = "DEC: CARD 1 TYPE"                                              
   V1335 = "DEC: CARD 2 TYPE"                                              
   V1336 = "DEC: CARD 3 TYPE"                                              
   V1337 = "DEC: CARD 4 TYPE"                                              
   V1338 = "DEC: CARD 0 P/T"                                               
   V1339 = "DEC: CARD 1 P/T"                                               
   V1340 = "DEC: CARD 2 P/T"                                               
   V1341 = "DEC: CARD 3 P/T"                                               
   V1342 = "DEC: UNFOUNDED MURDER"                                         
   V1343 = "DEC: UNFOUNDED MANSLGHT"                                       
   V1344 = "DEC: UNFOUNDED RAPE TOT"                                       
   V1345 = "DEC: UNFOUNDED FORC RAP"                                       
   V1346 = "DEC: UNFOUND ATMPTD RAP"                                       
   V1347 = "DEC: UNFOUND ROBBRY TOT"                                       
   V1348 = "DEC: UNFOUND GUN ROBBER"                                       
   V1349 = "DEC: UNFOUNDED KNIFE RO"                                       
   V1350 = "DEC: UNFND OTHR WEAP RO"                                       
   V1351 = "DEC: UNFND STRNG-ARM RO"                                       
   V1352 = "DEC: UNFOUND ASSLT TOTA"                                       
   V1353 = "DEC: UNFOUND GUN ASSLT"                                        
   V1354 = "DEC: UNFOUND KNIFE ASSL"                                       
   V1355 = "DEC: UNFND OTH WPN ASLT"                                       
   V1356 = "DEC: UNFND HND/FEET ASL"                                       
   V1357 = "DEC: UNFND SIMPL ASSAUL"                                       
   V1358 = "DEC: UNFOUND BURG TOTAL"                                       
   V1359 = "DEC: UNFOUND FORCE ENTR"                                       
   V1360 = "DEC: UNFND ENTRY-NO FOR"                                       
   V1361 = "DEC: UNFND ATT BURGLARY"                                       
   V1362 = "DEC: UNFOUND LARCNY TOT"                                       
   V1363 = "DEC: UF TOT MTR VHC THF"                                       
   V1364 = "DEC: UNFOUND AUTO THEFT"                                       
   V1365 = "DEC: UF TRUCK/BUS THEFT"                                       
   V1366 = "DEC: UNFND OTH VHC THEF"                                       
   V1367 = "DEC: UNFOUND ALL FIELDS"                                       
   V1368 = "DEC: ACT NUM MURDER"                                           
   V1369 = "DEC: ACT NUM MANSLGHTR"                                        
   V1370 = "DEC: ACT NUM RAPE TOTL"                                        
   V1371 = "DEC: ACT NUM FORC RAPE"                                        
   V1372 = "DEC: ACT NUM ATMPTD RAP"                                       
   V1373 = "DEC: ACT NUM ROBBRY TOT"                                       
   V1374 = "DEC: ACT NUM GUN ROBBER"                                       
   V1375 = "DEC: ACT NUM KNIFE ROBR"                                       
   V1376 = "DEC: ACT NUM OTH WPN RO"                                       
   V1377 = "DEC: ACT NUM STR ARM RO"                                       
   V1378 = "DEC: ACT NUM ASSLT TOTA"                                       
   V1379 = "DEC: ACT NUM GUN ASSAUL"                                       
   V1380 = "DEC: ACT NUM KNIFE ASSL"                                       
   V1381 = "DEC: ACT # OTH WPN ASSL"                                       
   V1382 = "DEC: ACT # HND/FEET ASL"                                       
   V1383 = "DEC: ACT # SIMPLE ASSLT"                                       
   V1384 = "DEC: ACT # BURGLARY TOT"                                       
   V1385 = "DEC: ACT # FORCE ENTRY"                                        
   V1386 = "DEC: ACT # ENTRY-NO FOR"                                       
   V1387 = "DEC: ACT # ATT BURGLARY"                                       
   V1388 = "DEC: ACT # LARCENY TOTA"                                       
   V1389 = "DEC: ACT # VHC THEFT TO"                                       
   V1390 = "DEC: ACT # AUTO THEFT"                                         
   V1391 = "DEC: ACT # TRCK/BUS THF"                                       
   V1392 = "DEC: ACT # OTH VHC THEF"                                       
   V1393 = "DEC: ACT # ALL FIELDS"                                         
   V1394 = "DEC: TOT CLR MURDER"                                           
   V1395 = "DEC: TOT CLR MANSLGHTR"                                        
   V1396 = "DEC: TOT CLR RAPE TOTAL"                                       
   V1397 = "DEC: TOT CLR FORC RAPE"                                        
   V1398 = "DEC: TOT CLR ATMPTD RAP"                                       
   V1399 = "DEC: TOT CLR TOTL ROBER"                                       
   V1400 = "DEC: TOT CLR GUN ROBBER"                                       
   V1401 = "DEC: TOT CLR KNIFE ROBR"                                       
   V1402 = "DEC: TOT CLR OTH WPN RO"                                       
   V1403 = "DEC: TOT CLR STR ARM RO"                                       
   V1404 = "DEC: TOT CLR ASSLT TOTA"                                       
   V1405 = "DEC: TOT CLR GUN ASSAUL"                                       
   V1406 = "DEC: TOT CLR KNIFE ASSL"                                       
   V1407 = "DEC: TOT CLR OTH WPN ASL"                                      
   V1408 = "DEC: TOT CLR HND/FT ASL"                                       
   V1409 = "DEC: TOT CLR SIMPLE ASL"                                       
   V1410 = "DEC: TOT CLR BRGLRY TOT"                                       
   V1411 = "DEC: TOT CLR FORC ENTRY"                                       
   V1412 = "DEC: TOT CLR ENTR-NO FR"                                       
   V1413 = "DEC: TOT CLR ATT BURGLR"                                       
   V1414 = "DEC: TOT CLR LARCNY TOT"                                       
   V1415 = "DEC: TOT CLR VHC THFT TO"                                      
   V1416 = "DEC: TOT CLR AUTO THEFT"                                       
   V1417 = "DEC: TOT CLR TRCK/BS THF"                                      
   V1418 = "DEC: TOT CLR OTH VHC THF"                                      
   V1419 = "DEC: TOT CLR ALL FIELDS"                                       
   V1420 = "DEC: CLR<18 MURDER"                                            
   V1421 = "DEC: CLR<18 MANSLGHTR"                                         
   V1422 = "DEC: CLR<18 RAPE TOTAL"                                        
   V1423 = "DEC: CLR<18 FORCE RAPE"                                        
   V1424 = "DEC: CLR<18 ATTMPTD RAP"                                       
   V1425 = "DEC: CLR<18 ROBBERY TOT"                                       
   V1426 = "DEC: CLR<18 GUN ROBBERY"                                       
   V1427 = "DEC: CLR<18 KNIFE ROBBR"                                       
   V1428 = "DEC: CLR<18 OTH WPN RBR"                                       
   V1429 = "DEC: CLR<18 STR ARM ROB"                                       
   V1430 = "DEC: CLR<18 ASSLT TOTAL"                                       
   V1431 = "DEC: CLR<18 GUN ASSAULT"                                       
   V1432 = "DEC: CLR<18 KNIFE ASSLT"                                       
   V1433 = "DEC: CLR<18 OTH WPN ASL"                                       
   V1434 = "DEC: CLR<18 HND/FT ASSL"                                       
   V1435 = "DEC: CLR<18 SIMPLE ASSL"                                       
   V1436 = "DEC: CLR<18 BURGLRY TOT"                                       
   V1437 = "DEC: CLR<18 FORC ENTRY"                                        
   V1438 = "DEC: CLR<18 ENTR-NO FOR"                                       
   V1439 = "DEC: CLR<18 ATT BURGLAR"                                       
   V1440 = "DEC: CLR<18 LARCENY TOT"                                       
   V1441 = "DEC: CLR<18 VHC THFT TO"                                       
   V1442 = "DEC: CLR<18 AUTO THEFT"                                        
   V1443 = "DEC: CLR<18 TRCK/BS THF"                                       
   V1444 = "DEC: CLR<18 OTH VHC THF"                                       
   V1445 = "DEC: CLR<18 ALL FIELDS"                                        
   V1446 = "DEC: OFFICRS KILL BY FE"                                       
   V1447 = "DEC: OFFICRS KILL BY AC"                                       
   V1448 = "DEC: OFFICERS ASSAULTED";                                      
                                                                           
* SAS FORMAT STATEMENT;                                                    
                                                                           
/*                                                                         
FORMAT                                                                     
   V1 V1FT.               V2 V2FT.               V4 $V4FT.                 
   V5 V5FT.               V8 $V8FT.              V12 V12FT.                
   V13 V13FT.             V23 $V23FT.            V24 V24FT.                
   V25 $V25FT.            V33 V33FT.             V34 V34FT.                
   V35 V35FT.             V36 V36FT.             V37 V37FT.                
   V38 V38FT.             V39 V39FT.             V40 $V40FT.               
   V41 $V41FT.            V42 $V42FT.            V43 $V43FT.               
   V151 V151FT.           V152 V152FT.           V153 V153FT.              
   V154 V154FT.           V155 V155FT.           V156 V156FT.              
   V157 V157FT.           V158 $V158FT.          V159 $V159FT.             
   V160 $V160FT.          V161 $V161FT.          V269 V269FT.              
   V270 V270FT.           V271 V271FT.           V272 V272FT.              
   V273 V273FT.           V274 V274FT.           V275 V275FT.              
   V276 $V276FT.          V277 $V277FT.          V278 $V278FT.             
   V279 $V279FT.          V387 V387FT.           V388 V388FT.              
   V389 V389FT.           V390 V390FT.           V391 V391FT.              
   V392 V392FT.           V393 V393FT.           V394 $V394FT.             
   V395 $V395FT.          V396 $V396FT.          V397 $V397FT.             
   V505 V505FT.           V506 V506FT.           V507 V507FT.              
   V508 V508FT.           V509 V509FT.           V510 V510FT.              
   V511 V511FT.           V512 $V512FT.          V513 $V513FT.             
   V514 $V514FT.          V515 $V515FT.          V623 V623FT.              
   V624 V624FT.           V625 V625FT.           V626 V626FT.              
   V627 V627FT.           V628 V628FT.           V629 V629FT.              
   V630 $V630FT.          V631 $V631FT.          V632 $V632FT.             
   V633 $V633FT.          V741 V741FT.           V742 V742FT.              
   V743 V743FT.           V744 V744FT.           V745 V745FT.              
   V746 V746FT.           V747 V747FT.           V748 $V748FT.             
   V749 $V749FT.          V750 $V750FT.          V751 $V751FT.             
   V859 V859FT.           V860 V860FT.           V861 V861FT.              
   V862 V862FT.           V863 V863FT.           V864 V864FT.              
   V865 V865FT.           V866 $V866FT.          V867 $V867FT.             
   V868 $V868FT.          V869 $V869FT.          V977 V977FT.              
   V978 V978FT.           V979 V979FT.           V980 V980FT.              
   V981 V981FT.           V982 V982FT.           V983 V983FT.              
   V984 $V984FT.          V985 $V985FT.          V986 $V986FT.             
   V987 $V987FT.          V1095 V1095FT.         V1096 V1096FT.            
   V1097 V1097FT.         V1098 V1098FT.         V1099 V1099FT.            
   V1100 V1100FT.         V1101 V1101FT.         V1102 $V1102FT.           
   V1103 $V1103FT.        V1104 $V1104FT.        V1105 $V1105FT.           
   V1213 V1213FT.         V1214 V1214FT.         V1215 V1215FT.            
   V1216 V1216FT.         V1217 V1217FT.         V1218 V1218FT.            
   V1219 V1219FT.         V1220 $V1220FT.        V1221 $V1221FT.           
   V1222 $V1222FT.        V1223 $V1223FT.        V1331 V1331FT.            
   V1332 V1332FT.         V1333 V1333FT.         V1334 V1334FT.            
   V1335 V1335FT.         V1336 V1336FT.         V1337 V1337FT.            
   V1338 $V1338FT.        V1339 $V1339FT.        V1340 $V1340FT.           
   V1341 $V1341FT.;                                                        
*/                                                                         
