/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core;

import java.time.LocalDateTime;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.sa.base.core.SaBenchmarkingResults;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.normalizer.AbsMeanNormalizer;
import jdplus.toolkit.base.core.ssf.benchmarking.SsfCholette;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataToolkit;
import lombok.NonNull;

public class CholetteProcessor {
    private final SaBenchmarkingSpec spec;
    public static final CholetteProcessor PROCESSOR = new CholetteProcessor(SaBenchmarkingSpec.DEFAULT_ENABLED);

    public static CholetteProcessor of(SaBenchmarkingSpec spec) {
        if (!spec.isEnabled()) {
            return null;
        }
        return new CholetteProcessor(spec);
    }

    private CholetteProcessor(SaBenchmarkingSpec spec) {
        this.spec = spec;
    }

    public SaBenchmarkingResults process(@NonNull TsData y, TsData sa, Explorable preprocessing) {
        TsData cal;
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (sa == null || sa.equals((Object)y)) {
            return new SaBenchmarkingResults(y, y, y);
        }
        TsData orig = preprocessing == null ? y : (TsData)preprocessing.getData("yc", TsData.class);
        TsData tsData = cal = preprocessing == null ? null : (TsData)preprocessing.getData("ycal", TsData.class);
        if (preprocessing != null && this.spec.isForecast()) {
            TsData origf = (TsData)preprocessing.getData("y_f", TsData.class);
            TsData calf = (TsData)preprocessing.getData("ycal_f", TsData.class);
            orig = TsData.concatenate((TsData[])new TsData[]{orig, origf});
            cal = TsData.concatenate((TsData[])new TsData[]{cal, calf});
        }
        TsData target = cal == null || this.spec.getTarget() == SaBenchmarkingSpec.Target.Original ? orig : cal;
        TsData benchSa = this.benchmark(sa, target);
        return new SaBenchmarkingResults(sa, target, benchSa);
    }

    public TsData benchmark(TsData source, TsData target) {
        TsData ytarget = target.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        TsData s = this.correctBias(source, ytarget);
        AbsMeanNormalizer normalizer = new AbsMeanNormalizer();
        DataBlock ns = DataBlock.of((DoubleSeq)s.getValues());
        double factor = normalizer.normalize(ns);
        TsData tmp = TsData.of((TsPeriod)s.getStart(), (DoubleSeq)ns);
        TsData btmp = this.cholette(tmp, ytarget.fn(z -> z * factor));
        if (btmp != null) {
            btmp = btmp.fn(z -> z / factor);
        }
        return btmp;
    }

    private TsData correctBias(TsData s, TsData ytarget) {
        SaBenchmarkingSpec.BiasCorrection bias = this.spec.getBiasCorrection();
        if (bias == SaBenchmarkingSpec.BiasCorrection.None) {
            return s;
        }
        TsData sy = s.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        if (bias == SaBenchmarkingSpec.BiasCorrection.Multiplicative) {
            return TsDataToolkit.multiply((TsData)s, (double)(ytarget.getValues().sum() / sy.getValues().sum()));
        }
        double b = ytarget.getValues().average() - sy.getValues().average();
        return TsDataToolkit.add((TsData)s, (double)b);
    }

    public static double[] expand(int length, int ratio, DoubleSeq agg, int offset) {
        double[] y = new double[length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = Double.NaN;
        }
        int pos = offset;
        int j = 0;
        int m = agg.length();
        DoubleSeqCursor cursor = agg.cursor();
        while (j++ < m) {
            y[pos] = cursor.getAndNext();
            pos += ratio;
        }
        return y;
    }

    private TsData cholette(TsData highFreqSeries, TsData aggregationConstraint) {
        int ratio = highFreqSeries.getTsUnit().ratioOf(aggregationConstraint.getTsUnit());
        if (ratio == -1 || ratio == 0) {
            throw new TsException("Incompatible frequencies");
        }
        TsData agg = highFreqSeries.aggregate(aggregationConstraint.getTsUnit(), AggregationType.Sum, true);
        TsPeriod sh = highFreqSeries.getStart();
        TsPeriod sl = TsPeriod.of((TsUnit)sh.getUnit(), (LocalDateTime)aggregationConstraint.getStart().start());
        int offset = sh.until(sl) + ratio - 1;
        aggregationConstraint = TsData.subtract((TsData)aggregationConstraint, (TsData)agg);
        double[] y = CholetteProcessor.expand(highFreqSeries.length(), ratio, aggregationConstraint.getValues(), offset);
        double[] w = null;
        if (this.spec.getLambda() != 0.0) {
            w = highFreqSeries.getValues().toArray();
            if (this.spec.getLambda() != 1.0) {
                for (i = 0; i < w.length; ++i) {
                    w[i] = Math.pow(Math.abs(w[i]), this.spec.getLambda());
                }
            } else {
                for (i = 0; i < w.length; ++i) {
                    w[i] = Math.abs(w[i]);
                }
            }
        }
        TsPeriod start = highFreqSeries.getStart();
        int head = (int)(start.getId() % (long)ratio);
        ISsf ssf = SsfCholette.builder((int)ratio).start(head).rho(this.spec.getRho()).weights(w == null ? null : DoubleSeq.of((double[])w)).build();
        DefaultSmoothingResults rslts = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)new SsfData(y), (boolean)false, (boolean)false);
        double[] b = new double[highFreqSeries.length()];
        if (w != null) {
            for (int i = 0; i < b.length; ++i) {
                b[i] = w[i] * rslts.a(i).get(1);
            }
        } else {
            rslts.getComponent(1).copyTo(b, 0);
        }
        return TsData.add((TsData)highFreqSeries, (TsData)TsData.ofInternal((TsPeriod)start, (double[])b));
    }
}

