## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "100%"
)

## -----------------------------------------------------------------------------
library(corella)

## -----------------------------------------------------------------------------
library(readr)
library(readr)
library(dplyr)
library(tidyr)
sites <- read_csv("events_sites.csv")

sites |> rmarkdown::paged_table()

## -----------------------------------------------------------------------------
obs <- read_csv("events_observations.csv")

obs |> rmarkdown::paged_table()

## -----------------------------------------------------------------------------
species <- read_csv("events_species.csv")

species

## -----------------------------------------------------------------------------
obs_id <- obs |>
  select(site_code, year, any_of(species$abbreviation)) |>
  set_events(
    eventID = composite_id(sequential_id(), site_code, year)
    ) |>
  relocate(eventID, .before = 1) # re-position

obs_id

## -----------------------------------------------------------------------------
obs_id_site <- obs_id |>
  left_join(
    select(sites, site_code, latitude, longitude),
    join_by(site_code)
    ) |>
  set_coordinates(
    decimalLatitude = latitude, 
    decimalLongitude = longitude,
    geodeticDatum = "WGS84",
    coordinateUncertaintyInMeters = 30
    ) |>
  relocate(decimalLatitude, decimalLongitude, .after = eventID) # re-position cols

obs_id_site

## -----------------------------------------------------------------------------
events <- obs_id_site |>
  select(
    any_of(event_terms())
    )

events

## -----------------------------------------------------------------------------
# events |> use_data()

## -----------------------------------------------------------------------------
obs_long <- obs_id_site |>
  select(eventID, any_of(species$abbreviation)) |>
  pivot_longer(cols = species$abbreviation,
               names_to = "abbreviation",
               values_to = "presence")

obs_long

## -----------------------------------------------------------------------------
obs_long <- obs_long |>
  left_join(species, join_by(abbreviation), keep = FALSE) |>
  relocate(presence, .after = last_col()) # re-position column

## -----------------------------------------------------------------------------
obs_long_dwc <- obs_long |>
 set_occurrences(
   occurrenceID = composite_id(eventID, sequential_id()),
   basisOfRecord = "humanObservation",
   occurrenceStatus = dplyr::case_when(presence == 1 ~ "present",
                                       .default = "absent")
   ) |>
 set_scientific_name(
   scientificName = scientific_name
   ) |>
 set_taxonomy(
   vernacularName = common_name
   )

obs_long_dwc

## -----------------------------------------------------------------------------
occurrences <- obs_long_dwc |>
  select(
    any_of(occurrence_terms())
    )

## -----------------------------------------------------------------------------
# occurrences |> use_data()

