/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.metadata.source;

import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.internal.GeoEntityUtility;
import com.google.i18n.phonenumbers.metadata.init.MetadataParser;
import com.google.i18n.phonenumbers.metadata.source.BlockingMetadataBootstrappingGuard;
import com.google.i18n.phonenumbers.metadata.source.CompositeMetadataContainer;
import com.google.i18n.phonenumbers.metadata.source.MetadataBootstrappingGuard;
import com.google.i18n.phonenumbers.metadata.source.MetadataSource;
import com.google.i18n.phonenumbers.metadata.source.PhoneMetadataFileNameProvider;

public final class MetadataSourceImpl
implements MetadataSource {
    private final PhoneMetadataFileNameProvider phoneMetadataFileNameProvider;
    private final MetadataBootstrappingGuard<CompositeMetadataContainer> bootstrappingGuard;

    public MetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataBootstrappingGuard<CompositeMetadataContainer> bootstrappingGuard) {
        this.phoneMetadataFileNameProvider = phoneMetadataFileNameProvider;
        this.bootstrappingGuard = bootstrappingGuard;
    }

    public MetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataLoader metadataLoader, MetadataParser metadataParser) {
        this(phoneMetadataFileNameProvider, new BlockingMetadataBootstrappingGuard<CompositeMetadataContainer>(metadataLoader, metadataParser, new CompositeMetadataContainer()));
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        if (GeoEntityUtility.isGeoEntity(countryCallingCode)) {
            throw new IllegalArgumentException(countryCallingCode + " calling code belongs to a geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(countryCallingCode)).getMetadataBy(countryCallingCode);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!GeoEntityUtility.isGeoEntity(regionCode)) {
            throw new IllegalArgumentException(regionCode + " region code is a non-geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(regionCode)).getMetadataBy(regionCode);
    }
}

