/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.FixedWeekDay;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class FixedWeekDayInfo
implements HolidayInfo {
    private final int year;
    private final FixedWeekDay fday;

    FixedWeekDayInfo(int year, FixedWeekDay fday) {
        this.fday = fday;
        this.year = year;
    }

    @Override
    public LocalDate getDay() {
        return this.fday.calcDate(this.year);
    }

    @Override
    public DayOfWeek getDayOfWeek() {
        return this.fday.getDayOfWeek();
    }

    @Generated
    public int getYear() {
        return this.year;
    }

    @Generated
    public FixedWeekDay getFday() {
        return this.fday;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedWeekDayInfo)) {
            return false;
        }
        FixedWeekDayInfo other = (FixedWeekDayInfo)o;
        if (this.getYear() != other.getYear()) {
            return false;
        }
        FixedWeekDay this$fday = this.getFday();
        FixedWeekDay other$fday = other.getFday();
        return !(this$fday == null ? other$fday != null : !this$fday.equals(other$fday));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYear();
        FixedWeekDay $fday = this.getFday();
        result = result * 59 + ($fday == null ? 43 : $fday.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "FixedWeekDayInfo(year=" + this.getYear() + ", fday=" + String.valueOf(this.getFday()) + ")";
    }

    static class FixedWeekDayIterable
    implements Iterable<HolidayInfo> {
        private final FixedWeekDay fday;
        private final int year;
        private final int n;

        FixedWeekDayIterable(FixedWeekDay fday, LocalDate fstart, LocalDate fend) {
            this.fday = fday;
            ValidityPeriod vp = fday.getValidityPeriod();
            if (vp.getStart().isAfter(fstart)) {
                fstart = vp.getStart();
            }
            if (vp.getEnd().isBefore(fend)) {
                fend = vp.getEnd();
            }
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            LocalDate xday = fday.calcDate(ystart);
            LocalDate yday = fday.calcDate(yend);
            if (xday.isBefore(fstart)) {
                ++ystart;
            }
            if (!yday.isBefore(fend)) {
                --yend;
            }
            this.year = ystart;
            this.n = yend - ystart + 1;
        }

        @Override
        public Iterator<HolidayInfo> iterator() {
            return new Iterator<HolidayInfo>(){
                int cur = 0;

                @Override
                public boolean hasNext() {
                    return this.cur < n;
                }

                @Override
                public HolidayInfo next() {
                    return new FixedWeekDayInfo(year + this.cur++, fday);
                }
            };
        }
    }
}

