/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.interpolation;

import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.MathException;
import jdplus.toolkit.base.core.data.DataBlock;
import lombok.Generated;

public final class CubicSplines {
    public static Spline natural(DoubleSeq X, DoubleSeq Y) {
        int i;
        if (X.length() != Y.length()) {
            throw new IllegalArgumentException();
        }
        NaturalSpline spline = new NaturalSpline(X, Y);
        int psize = spline.size() - 1;
        int sys_size = psize - 1;
        double[] xa = spline.xa;
        double[] ya = spline.ya;
        double[] g = new double[psize];
        double[] diag = new double[psize];
        double[] offdiag = new double[psize];
        for (i = 0; i < sys_size; ++i) {
            double h_i = xa[i + 1] - xa[i];
            double h_ip1 = xa[i + 2] - xa[i + 1];
            double ydiff_i = ya[i + 1] - ya[i];
            double ydiff_ip1 = ya[i + 2] - ya[i + 1];
            double g_i = h_i != 0.0 ? 1.0 / h_i : 0.0;
            double g_ip1 = h_ip1 != 0.0 ? 1.0 / h_ip1 : 0.0;
            offdiag[i] = h_ip1;
            diag[i] = 2.0 * (h_ip1 + h_i);
            g[i] = 3.0 * (ydiff_ip1 * g_ip1 - ydiff_i * g_i);
        }
        if (sys_size == 1) {
            spline.c[1] = g[0] / diag[0];
        } else {
            DoubleSeq g_vec = DoubleSeq.of((double[])g, (int)0, (int)sys_size);
            DoubleSeq diag_vec = DoubleSeq.of((double[])diag, (int)0, (int)sys_size);
            DoubleSeq offdiag_vec = DoubleSeq.of((double[])offdiag, (int)0, (int)(sys_size - 1));
            DataBlock solution_vec = DataBlock.of(spline.c, 1, sys_size + 1);
            CubicSplines.solveTriDiag(diag_vec, offdiag_vec, g_vec, solution_vec);
        }
        for (i = 0; i < psize; ++i) {
            double h_i = xa[i + 1] - xa[i];
            spline.b[i] = (ya[i + 1] - ya[i]) / h_i - h_i / 3.0 * (2.0 * spline.c[i] + spline.c[i + 1]);
            spline.d[i] = (spline.c[i + 1] - spline.c[i]) / (3.0 * h_i);
        }
        return spline;
    }

    public static Spline periodic(DoubleSeq X, DoubleSeq Y) {
        int psize;
        int n = Y.length();
        if (n != X.length() || Y.get(0) != Y.get(n - 1)) {
            throw new IllegalArgumentException();
        }
        PeriodicSpline spline = new PeriodicSpline(X, Y);
        int sys_size = psize = spline.size() - 1;
        double[] xa = spline.xa;
        double[] ya = spline.ya;
        if (sys_size == 2) {
            double h0 = xa[1] - xa[0];
            double h1 = xa[2] - xa[1];
            double A = 2.0 * (h0 + h1);
            double B = h0 + h1;
            double g0 = 3.0 * ((ya[2] - ya[1]) / h1 - (ya[1] - ya[0]) / h0);
            double g1 = 3.0 * ((ya[1] - ya[2]) / h0 - (ya[2] - ya[1]) / h1);
            double det = 3.0 * (h0 + h1) * (h0 + h1);
            spline.c[1] = (A * g0 - B * g1) / det;
            spline.c[2] = (-B * g0 + A * g1) / det;
            spline.c[0] = spline.c[2];
        } else {
            double g_ip1;
            double g_i;
            double ydiff_ip1;
            double ydiff_i;
            double h_ip1;
            double h_i;
            double[] g = new double[psize];
            double[] diag = new double[psize];
            double[] offdiag = new double[psize];
            for (int i = 0; i < sys_size - 1; ++i) {
                h_i = xa[i + 1] - xa[i];
                h_ip1 = xa[i + 2] - xa[i + 1];
                ydiff_i = ya[i + 1] - ya[i];
                ydiff_ip1 = ya[i + 2] - ya[i + 1];
                g_i = h_i != 0.0 ? 1.0 / h_i : 0.0;
                g_ip1 = h_ip1 != 0.0 ? 1.0 / h_ip1 : 0.0;
                offdiag[i] = h_ip1;
                diag[i] = 2.0 * (h_ip1 + h_i);
                g[i] = 3.0 * (ydiff_ip1 * g_ip1 - ydiff_i * g_i);
            }
            int ilast = sys_size - 1;
            h_i = xa[ilast + 1] - xa[ilast];
            h_ip1 = xa[1] - xa[0];
            ydiff_i = ya[ilast + 1] - ya[ilast];
            ydiff_ip1 = ya[1] - ya[0];
            g_i = h_i != 0.0 ? 1.0 / h_i : 0.0;
            g_ip1 = h_ip1 != 0.0 ? 1.0 / h_ip1 : 0.0;
            offdiag[ilast] = h_ip1;
            diag[ilast] = 2.0 * (h_ip1 + h_i);
            g[ilast] = 3.0 * (ydiff_ip1 * g_ip1 - ydiff_i * g_i);
            DoubleSeq g_vec = DoubleSeq.of((double[])g, (int)0, (int)sys_size);
            DoubleSeq diag_vec = DoubleSeq.of((double[])diag, (int)0, (int)sys_size);
            DoubleSeq offdiag_vec = DoubleSeq.of((double[])offdiag, (int)0, (int)sys_size);
            DataBlock solution_vec = DataBlock.of(spline.c, 1, sys_size + 1);
            CubicSplines.solveCyclicTriDiag(diag_vec, offdiag_vec, g_vec, solution_vec);
            spline.c[0] = spline.c[psize];
        }
        for (int i = 0; i < psize; ++i) {
            double h_i = xa[i + 1] - xa[i];
            spline.b[i] = (ya[i + 1] - ya[i]) / h_i - h_i / 3.0 * (2.0 * spline.c[i] + spline.c[i + 1]);
            spline.d[i] = (spline.c[i + 1] - spline.c[i]) / (3.0 * h_i);
        }
        return spline;
    }

    public static void solveTriDiag(DoubleSeq diag, DoubleSeq offdiag, DoubleSeq b, DataBlock x) {
        int i;
        int N = diag.length();
        double[] gamma = new double[N];
        double[] alpha = new double[N];
        double[] c = new double[N];
        double[] z = new double[N];
        alpha[0] = diag.get(0);
        gamma[0] = offdiag.get(0) / alpha[0];
        if (alpha[0] == 0.0) {
            throw new MathException("division by 0");
        }
        for (i = 1; i < N - 1; ++i) {
            alpha[i] = diag.get(i) - offdiag.get(i - 1) * gamma[i - 1];
            gamma[i] = offdiag.get(i) / alpha[i];
            if (alpha[i] != 0.0) continue;
            throw new MathException("division by 0");
        }
        if (N > 1) {
            alpha[N - 1] = diag.get(N - 1) - offdiag.get(N - 2) * gamma[N - 2];
        }
        z[0] = b.get(0);
        for (i = 1; i < N; ++i) {
            z[i] = b.get(i) - gamma[i - 1] * z[i - 1];
        }
        for (i = 0; i < N; ++i) {
            c[i] = z[i] / alpha[i];
        }
        x.set(N - 1, c[N - 1]);
        if (N >= 2) {
            i = N - 2;
            int j = 0;
            while (j <= N - 2) {
                x.set(i, c[i] - gamma[i] * x.get(i + 1));
                ++j;
                --i;
            }
        }
    }

    public static void solveCyclicTriDiag(DoubleSeq diag, DoubleSeq offdiag, DoubleSeq b, DataBlock x) {
        int i;
        int N = diag.length();
        double[] delta = new double[N];
        double[] gamma = new double[N];
        double[] alpha = new double[N];
        double[] c = new double[N];
        double[] z = new double[N];
        double sum = 0.0;
        if (N == 1) {
            x.set(0, b.get(0) / diag.get(0));
            return;
        }
        alpha[0] = diag.get(0);
        if (alpha[0] == 0.0) {
            throw new MathException("division by 0");
        }
        gamma[0] = offdiag.get(0) / alpha[0];
        delta[0] = offdiag.get(N - 1) / alpha[0];
        for (i = 1; i < N - 2; ++i) {
            alpha[i] = diag.get(i) - offdiag.get(i - 1) * gamma[i - 1];
            gamma[i] = offdiag.get(i) / alpha[i];
            delta[i] = -delta[i - 1] * offdiag.get(i - 1) / alpha[i];
            if (alpha[i] != 0.0) continue;
            throw new MathException("division by 0");
        }
        for (i = 0; i < N - 2; ++i) {
            sum += alpha[i] * delta[i] * delta[i];
        }
        alpha[N - 2] = diag.get(N - 2) - offdiag.get(N - 3) * gamma[N - 3];
        gamma[N - 2] = (offdiag.get(N - 2) - offdiag.get(N - 3) * delta[N - 3]) / alpha[N - 2];
        alpha[N - 1] = diag.get(N - 1) - sum - alpha[N - 2] * gamma[N - 2] * gamma[N - 2];
        z[0] = b.get(0);
        for (i = 1; i < N - 1; ++i) {
            z[i] = b.get(i) - z[i - 1] * gamma[i - 1];
        }
        sum = 0.0;
        for (i = 0; i < N - 2; ++i) {
            sum += delta[i] * z[i];
        }
        z[N - 1] = b.get(N - 1) - sum - gamma[N - 2] * z[N - 2];
        for (i = 0; i < N; ++i) {
            c[i] = z[i] / alpha[i];
        }
        x.set(N - 1, c[N - 1]);
        x.set(N - 2, c[N - 2] - gamma[N - 2] * x.get(N - 1));
        if (N >= 3) {
            i = N - 3;
            int j = 0;
            while (j <= N - 3) {
                x.set(i, c[i] - gamma[i] * x.get(i + 1) - delta[i] * x.get(N - 1));
                ++j;
                --i;
            }
        }
    }

    @Generated
    private CubicSplines() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class NaturalSpline
    extends Spline {
        @Override
        public double applyAsDouble(double x) {
            if (x < this.xa[0]) {
                return this.extrapolate0(x);
            }
            if (x > this.xa[this.xa.length - 1]) {
                return this.extrapolate1(x);
            }
            int pos = Arrays.binarySearch(this.xa, x);
            if (pos >= 0) {
                return this.ya[pos];
            }
            return this.interpolate(x, -pos - 2);
        }

        private double extrapolate0(double x) {
            double df = this.b[0];
            return this.ya[0] + (x - this.xa[0]) * df;
        }

        private double extrapolate1(double x) {
            int n = this.xa.length - 1;
            double dx = this.xa[n] - this.xa[n - 1];
            double dx2 = dx * dx;
            double df = this.b[n - 1] + 2.0 * this.c[n - 1] * dx + 3.0 * this.d[n - 1] * dx2;
            return this.ya[n] + (x - this.xa[n]) * df;
        }

        private NaturalSpline(DoubleSeq X, DoubleSeq Y) {
            super(X, Y);
        }
    }

    private static class PeriodicSpline
    extends Spline {
        private double translate(double x) {
            int n = this.size() - 1;
            if (x < this.xa[0] || x > this.xa[n]) {
                double xc = x - this.xa[0];
                double dx = this.xa[n] - this.xa[0];
                double m = Math.floor(xc / dx);
                return (xc -= m * dx) + this.xa[0];
            }
            return x;
        }

        @Override
        public double applyAsDouble(double x) {
            double xc = this.translate(x);
            int pos = Arrays.binarySearch(this.xa, xc);
            if (pos >= 0) {
                return this.ya[pos];
            }
            return this.interpolate(xc, -pos - 2);
        }

        private PeriodicSpline(DoubleSeq X, DoubleSeq Y) {
            super(X, Y);
        }
    }

    public static abstract class Spline
    implements DoubleUnaryOperator {
        final double[] b;
        final double[] c;
        final double[] d;
        final double[] xa;
        final double[] ya;

        Spline(DoubleSeq x, DoubleSeq y) {
            this.xa = x.toArray();
            this.ya = y.toArray();
            int size = this.xa.length - 1;
            this.b = new double[size];
            this.c = new double[size + 1];
            this.d = new double[size];
        }

        protected double interpolate(double x, int index) {
            double delx = x - this.xa[index];
            return this.ya[index] + delx * (this.b[index] + delx * (this.c[index] + delx * this.d[index]));
        }

        int size() {
            return this.xa.length;
        }
    }
}

