/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.visitors.DeepFieldResolver;
import org.jpmml.converter.visitors.DeepFieldResolverUtil;
import org.jpmml.converter.visitors.FieldDependencyResolver;
import org.jpmml.converter.visitors.FieldUtil;
import org.jpmml.model.visitors.FieldResolver;

public class MiningSchemaCleaner
extends DeepFieldResolver {
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            Set<Field<?>> activeFields = this.processMiningModel(miningModel);
            this.clean((Model)miningModel, activeFields);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            Set<Field<?>> activeFields = this.processModel(model);
            this.clean(model, activeFields);
        }
        return parent;
    }

    private Set<Field<?>> processMiningModel(MiningModel miningModel) {
        Set<Field<?>> activeFields = DeepFieldResolverUtil.getActiveFields((FieldResolver)this, miningModel);
        HashSet<String> activeFieldNames = new HashSet<String>();
        Segmentation segmentation = miningModel.requireSegmentation();
        List segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Model model = segment.requireModel();
            MiningSchema miningSchema = model.requireMiningSchema();
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                String fieldName = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        activeFieldNames.add(fieldName);
                        break;
                    }
                }
            }
        }
        Collection modelFields = this.getFields(new PMMLObject[]{miningModel});
        activeFields.addAll(FieldUtil.selectAll(modelFields, activeFieldNames, true));
        this.expandDerivedFields((Model)miningModel, activeFields);
        return activeFields;
    }

    private Set<Field<?>> processModel(Model model) {
        Set<Field<?>> activeFields = DeepFieldResolverUtil.getActiveFields((FieldResolver)this, model);
        this.expandDerivedFields(model, activeFields);
        return activeFields;
    }

    private void expandDerivedFields(Model model, Set<Field<?>> fields) {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        fieldDependencyResolver.expand(fields, fieldDependencyResolver.getGlobalDerivedFields());
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            fieldDependencyResolver.expand(fields, new HashSet(localTransformations.getDerivedFields()));
        }
    }

    private void clean(Model model, Set<Field<?>> activeFields) {
        MiningSchema miningSchema = model.requireMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        final Map<String, Field<?>> activeFieldMap = FieldUtil.nameMap(activeFields);
        Iterator<Object> it = miningFields.iterator();
        while (it.hasNext()) {
            MiningField miningField = (MiningField)it.next();
            String fieldName = miningField.getName();
            MiningField.UsageType usageType = miningField.getUsageType();
            switch (usageType) {
                case ACTIVE: {
                    if (activeFieldMap.containsKey(fieldName)) break;
                    it.remove();
                    break;
                }
            }
            activeFieldMap.remove(fieldName);
        }
        activeFields = new LinkedHashSet(activeFieldMap.values());
        for (Field field : activeFields) {
            MiningField miningField = new MiningField(field);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        }
        miningFields = miningSchema.getMiningFields();
        Comparator<MiningField> comparator = new Comparator<MiningField>(){

            @Override
            public int compare(MiningField left, MiningField right) {
                int order = Integer.compare(this.getGroup(left), this.getGroup(right));
                if (order != 0) {
                    return order;
                }
                order = Integer.compare(this.getFieldType(left), this.getFieldType(right));
                if (order != 0) {
                    return order;
                }
                return 0;
            }

            private int getGroup(MiningField miningField) {
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case PREDICTED: 
                    case TARGET: {
                        return -1;
                    }
                }
                return usageType.ordinal();
            }

            private int getFieldType(MiningField miningField) {
                String fieldName = miningField.getName();
                Field field = (Field)activeFieldMap.get(fieldName);
                if (field instanceof DataField) {
                    return 0;
                }
                if (field instanceof DerivedField) {
                    return 1;
                }
                if (field instanceof OutputField) {
                    return 2;
                }
                return 3;
            }
        };
        miningFields.sort(comparator);
    }
}

