## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
  library(ambiR)
  library(dplyr)
  library(tidyr)
  library(ggplot2)
  
  res <- AMBI(test_data, by=c("station"), var_rep = "replicate")

## ----transpose----------------------------------------------------------------
  df <- res$AMBI_rep
  
  df_group_freq <- df %>%
    pivot_longer(cols=c("I","II","III","IV","V"),
                 names_to = "EcoGroup",
                 values_to = "f")
  
  df_group_freq$EcoGroup <- factor(df_group_freq$EcoGroup, 
                             levels = c("V","IV","III","II","I"))

## ----plot1, fig.height=4, fig.width=7, fig.alt="Bar chart with default ggplot2 formatting"----
  p <- ggplot() +
    geom_bar(data = df_group_freq, 
         aes(x = replicate, y = f, fill = EcoGroup),
         position = "fill", stat="identity", width = 0.4) +
    geom_point(data = df, aes(x = replicate, y = (AMBI / 6))) +
    scale_y_continuous(
      limits = c(0, 1), 
      name= "Species group distribution",
      expand = c(0, 0), 
      breaks = seq(0, 1, 0.25),
      labels = scales::label_percent(),
      sec.axis = sec_axis( transform = ~.*6, name = "AMBI")) +
    facet_grid(. ~ station, switch="x", scales="free_x", space = "free")
 
  p

## ----plot2, fig.height = 4, fig.width = 7, fig.alt = "Bar chart with AMBI theme"----
  p <- ggplot() +
    geom_bar(data = df_group_freq,
             aes(x = replicate, y = f, fill = EcoGroup), 
             colour = alpha("grey20", 1), position = "fill", stat="identity", 
             width = 0.6, linewidth = 0.1, alpha=0.6) +
    geom_point(data = df, aes(x = replicate, y = (AMBI / 6))) +
    scale_fill_manual(values=c("#ff0000", "#ff8000", "#ffff00", "#00ff00", "#0000ff"),
                      name="Ecological Group") +
    facet_grid(. ~ station, switch="x", scales="free_x", space="free") +
    scale_y_continuous(
      limits = c(0, 1),
      name= "Species group distribution",
      expand = c(0, 0),
      breaks = seq(0, 1, 0.25),
      labels = scales::label_percent(),
      sec.axis = sec_axis( transform = ~.*6, name="AMBI")) +
    theme(text = element_text(size=9),
          strip.text.x.bottom = element_text(colour="grey20"),
          strip.placement = "outside",
          strip.background = element_blank(),
          panel.spacing.x = unit(0.5, units = "cm"),
          panel.border = element_blank(),
          panel.background = element_blank(),
          panel.grid.major.x = element_blank(),
          panel.grid.minor.x = element_blank(),
          panel.grid.major.y =  element_blank(),
          panel.grid.minor.y = element_blank(),
          axis.line.x = element_line(colour = "grey20", linewidth = 0.2),
          axis.line.y = element_line(colour = "grey20", linewidth = 0.2),
          axis.title.x = element_blank(),
          axis.text.x.bottom = element_text(size = 8),
          plot.background = element_blank(),
          legend.position = "bottom") +
    guides(fill = guide_legend(reverse=T))
  p

