/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.Debug;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class QuaquaToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    private static final Stroke separatorStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f);

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaToolBarSeparatorUI();
    }

    protected void installDefaults(JSeparator s) {
        super.installDefaults(s);
        s.setForeground(UIManager.getColor("ToolBarSeparator.foreground"));
    }

    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        int width = c.getWidth();
        int height = c.getHeight();
        g.setColor(c.getForeground());
        g.setStroke(separatorStroke);
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            g.drawLine(2, height / 2, width - 3, height / 2);
        } else {
            g.drawLine(width / 2, 2, width / 2, height - 3);
        }
        Debug.paint(g, c, this);
    }

    public Dimension getMinimumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            return new Dimension(1, 11);
        }
        return new Dimension(11, 1);
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            return new Dimension(1, 11);
        }
        return new Dimension(11, 1);
    }

    public Dimension getMaximumSize(JComponent c) {
        JToolBar.Separator sep = (JToolBar.Separator)c;
        if (sep.getOrientation() == 0) {
            return new Dimension(Integer.MAX_VALUE, 11);
        }
        return new Dimension(11, Integer.MAX_VALUE);
    }
}

