/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.util.function.Function;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeInterval;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalQuery;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TimeIntervalFormatter {
    private static final char INTERVAL_DESIGNATOR = '/';

    @NonNull
    public String format(@NonNull TimeInterval<?, ?> timeInterval) throws DateTimeException {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return this.format(timeInterval, null);
    }

    @NonNull
    public String format(@NonNull TimeInterval<?, ?> timeInterval, @Nullable ChronoUnit precision) throws DateTimeException {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder(32);
        this.formatTo(timeInterval, result, precision);
        return result.toString();
    }

    public void formatTo(@NonNull TimeInterval<?, ?> timeInterval, @NonNull Appendable appendable) throws DateTimeException {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        this.formatTo(timeInterval, appendable, null);
    }

    public abstract void formatTo(@NonNull TimeInterval<?, ?> var1, @NonNull Appendable var2, @Nullable ChronoUnit var3) throws DateTimeException;

    @NonNull
    public abstract <I extends TimeInterval<?, ?>> I parse(@NonNull CharSequence var1, @NonNull TimeIntervalQuery<I> var2) throws DateTimeParseException;

    private static int getIntervalDesignatorIndex(CharSequence text) throws DateTimeParseException {
        int result = TimeIntervalFormatter.indexOf(text, '/');
        if (result == -1) {
            throw new DateTimeParseException("Cannot find interval designator", text, 0);
        }
        if (result == 0) {
            throw new DateTimeParseException("Cannot find interval left part", text, 0);
        }
        if (result == text.length() - 1) {
            throw new DateTimeParseException("Cannot find interval right part", text, result);
        }
        return result;
    }

    static int indexOf(CharSequence text, char c) {
        if (text instanceof String) {
            return ((String)text).indexOf(c);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static CharSequence compact(CharSequence ref, CharSequence value) {
        int anchor = -1;
        for (int i = 0; i < ref.length(); ++i) {
            if (!Character.isDigit(ref.charAt(i))) {
                anchor = i;
            }
            if (ref.charAt(i) == value.charAt(i)) continue;
            return value.subSequence(anchor + 1, value.length());
        }
        return "";
    }

    private static CharSequence expand(CharSequence ref, CharSequence value) {
        int diff = ref.length() - value.length();
        if (diff <= 0) {
            return value;
        }
        return ref.subSequence(0, diff).toString() + String.valueOf(value);
    }

    private static void formatDurationTo(TemporalAmount duration, Appendable appendable) {
        TemporalFormatter.appendTo(duration.toString(), appendable);
    }

    public static final class Duration
    extends TimeIntervalFormatter {
        @NonNull
        private final Function<? super CharSequence, ? extends TemporalAmount> duration;

        @Override
        public void formatTo(@NonNull TimeInterval<?, ?> timeInterval, @NonNull Appendable appendable, @Nullable ChronoUnit precision) {
            if (timeInterval == null) {
                throw new NullPointerException("timeInterval is marked non-null but is null");
            }
            if (appendable == null) {
                throw new NullPointerException("appendable is marked non-null but is null");
            }
            TimeIntervalFormatter.formatDurationTo(timeInterval.getDuration(), appendable);
        }

        @Override
        @NonNull
        public <I extends TimeInterval<?, ?>> I parse(@NonNull CharSequence text, @NonNull TimeIntervalQuery<I> query) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            TimeInterval result = (TimeInterval)query.queryFrom(new DurationAccessor(text));
            if (result == null) {
                throw new DateTimeException("Unable to obtain TimeInterval from TimeIntervalQuery");
            }
            return (I)result;
        }

        @Generated
        private Duration(@NonNull Function<? super CharSequence, ? extends TemporalAmount> duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @Generated
        public static @org.jspecify.annotations.NonNull Duration of(@NonNull Function<? super CharSequence, ? extends TemporalAmount> duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            return new Duration(duration);
        }

        private final class DurationAccessor
        implements TimeIntervalAccessor {
            private final CharSequence text;

            @Override
            @NonNull
            public Temporal start() {
                throw new DateTimeException("Not supported for this TimeIntervalFormatter");
            }

            @Override
            @NonNull
            public Temporal end() {
                throw new DateTimeException("Not supported for this TimeIntervalFormatter");
            }

            @Override
            @NonNull
            public TemporalAmount getDuration() {
                return Duration.this.duration.apply(this.text);
            }

            @Generated
            public DurationAccessor(CharSequence text) {
                this.text = text;
            }
        }
    }

    public static final class DurationEnd
    extends TimeIntervalFormatter {
        @Deprecated
        public static final DurationEnd ISO_LOCAL_DATE = DurationEnd.of(Period::parse, TemporalFormatter.EXTENDED_CALENDAR, LocalDate::from);
        @Deprecated
        public static final DurationEnd BASIC_ISO_DATE = DurationEnd.of(Period::parse, TemporalFormatter.BASIC_CALENDAR, LocalDate::from);
        @Deprecated
        public static final DurationEnd ISO_ORDINAL_DATE = DurationEnd.of(Period::parse, TemporalFormatter.EXTENDED_ORDINAL, LocalDate::from);
        @Deprecated
        public static final DurationEnd ISO_WEEK_DATE = DurationEnd.of(Period::parse, TemporalFormatter.EXTENDED_WEEK, LocalDate::from);
        @Deprecated
        public static final DurationEnd ISO_LOCAL_DATE_TIME = DurationEnd.of(java.time.Duration::parse, TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from);
        @NonNull
        private final Function<? super CharSequence, TemporalAmount> duration;
        @NonNull
        private final TemporalFormatter endFormatter;
        @NonNull
        private final TemporalQuery<? extends Temporal> endQuery;

        @Override
        public void formatTo(@NonNull TimeInterval<?, ?> timeInterval, @NonNull Appendable appendable, @Nullable ChronoUnit precision) {
            if (timeInterval == null) {
                throw new NullPointerException("timeInterval is marked non-null but is null");
            }
            if (appendable == null) {
                throw new NullPointerException("appendable is marked non-null but is null");
            }
            Object left = timeInterval.getDuration();
            Temporal right = (Temporal)timeInterval.end();
            TimeIntervalFormatter.formatDurationTo(left, appendable);
            TemporalFormatter.appendTo('/', appendable);
            this.endFormatter.formatTo(right, appendable, precision);
        }

        @Override
        @NonNull
        public <I extends TimeInterval<?, ?>> I parse(@NonNull CharSequence text, @NonNull TimeIntervalQuery<I> query) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            int intervalDesignatorIdx = TimeIntervalFormatter.getIntervalDesignatorIndex(text);
            CharSequence left = text.subSequence(0, intervalDesignatorIdx);
            CharSequence right = text.subSequence(intervalDesignatorIdx + 1, text.length());
            TimeInterval result = (TimeInterval)query.queryFrom(new DurationEndAccessor(right, left));
            if (result == null) {
                throw new DateTimeException("Unable to obtain TimeInterval from TimeIntervalQuery");
            }
            return (I)result;
        }

        @Generated
        private DurationEnd(@NonNull Function<? super CharSequence, TemporalAmount> duration, @NonNull TemporalFormatter endFormatter, @NonNull TemporalQuery<? extends Temporal> endQuery) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            if (endFormatter == null) {
                throw new NullPointerException("endFormatter is marked non-null but is null");
            }
            if (endQuery == null) {
                throw new NullPointerException("endQuery is marked non-null but is null");
            }
            this.duration = duration;
            this.endFormatter = endFormatter;
            this.endQuery = endQuery;
        }

        @Generated
        public static @org.jspecify.annotations.NonNull DurationEnd of(@NonNull Function<? super CharSequence, TemporalAmount> duration, @NonNull TemporalFormatter endFormatter, @NonNull TemporalQuery<? extends Temporal> endQuery) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            if (endFormatter == null) {
                throw new NullPointerException("endFormatter is marked non-null but is null");
            }
            if (endQuery == null) {
                throw new NullPointerException("endQuery is marked non-null but is null");
            }
            return new DurationEnd(duration, endFormatter, endQuery);
        }

        private final class DurationEndAccessor
        implements TimeIntervalAccessor {
            private final CharSequence right;
            private final CharSequence left;

            @Override
            @NonNull
            public Temporal start() {
                throw new DateTimeException("Not supported for this TimeIntervalFormatter");
            }

            @Override
            @NonNull
            public Temporal end() {
                return DurationEnd.this.endFormatter.parse(this.right, DurationEnd.this.endQuery);
            }

            @Override
            @NonNull
            public TemporalAmount getDuration() {
                return DurationEnd.this.duration.apply(this.left);
            }

            @Generated
            public DurationEndAccessor(CharSequence right, CharSequence left) {
                this.right = right;
                this.left = left;
            }
        }
    }

    public static final class StartDuration
    extends TimeIntervalFormatter {
        @Deprecated
        public static final StartDuration ISO_LOCAL_DATE = StartDuration.of(TemporalFormatter.EXTENDED_CALENDAR, LocalDate::from, Period::parse);
        @Deprecated
        public static final StartDuration BASIC_ISO_DATE = StartDuration.of(TemporalFormatter.BASIC_CALENDAR, LocalDate::from, Period::parse);
        @Deprecated
        public static final StartDuration ISO_ORDINAL_DATE = StartDuration.of(TemporalFormatter.EXTENDED_ORDINAL, LocalDate::from, Period::parse);
        @Deprecated
        public static final StartDuration ISO_WEEK_DATE = StartDuration.of(TemporalFormatter.EXTENDED_WEEK, LocalDate::from, Period::parse);
        @Deprecated
        public static final StartDuration ISO_LOCAL_DATE_TIME = StartDuration.of(TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from, java.time.Duration::parse);
        @NonNull
        private final TemporalFormatter startFormatter;
        @NonNull
        private final TemporalQuery<? extends Temporal> startQuery;
        @NonNull
        private final Function<? super CharSequence, ? extends TemporalAmount> duration;

        @Override
        public void formatTo(@NonNull TimeInterval<?, ?> timeInterval, @NonNull Appendable appendable, @Nullable ChronoUnit precision) {
            if (timeInterval == null) {
                throw new NullPointerException("timeInterval is marked non-null but is null");
            }
            if (appendable == null) {
                throw new NullPointerException("appendable is marked non-null but is null");
            }
            Temporal left = (Temporal)timeInterval.start();
            Object right = timeInterval.getDuration();
            this.startFormatter.formatTo(left, appendable, precision);
            TemporalFormatter.appendTo('/', appendable);
            TimeIntervalFormatter.formatDurationTo(right, appendable);
        }

        @Override
        @NonNull
        public <I extends TimeInterval<?, ?>> I parse(@NonNull CharSequence text, @NonNull TimeIntervalQuery<I> query) {
            CharSequence right;
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            int intervalDesignatorIdx = TimeIntervalFormatter.getIntervalDesignatorIndex(text);
            CharSequence left = text.subSequence(0, intervalDesignatorIdx);
            TimeInterval result = (TimeInterval)query.queryFrom(new StartDurationAccessor(left, right = text.subSequence(intervalDesignatorIdx + 1, text.length())));
            if (result == null) {
                throw new DateTimeException("Unable to obtain TimeInterval from TimeIntervalQuery");
            }
            return (I)result;
        }

        @Generated
        private StartDuration(@NonNull TemporalFormatter startFormatter, @NonNull TemporalQuery<? extends Temporal> startQuery, @NonNull Function<? super CharSequence, ? extends TemporalAmount> duration) {
            if (startFormatter == null) {
                throw new NullPointerException("startFormatter is marked non-null but is null");
            }
            if (startQuery == null) {
                throw new NullPointerException("startQuery is marked non-null but is null");
            }
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.startFormatter = startFormatter;
            this.startQuery = startQuery;
            this.duration = duration;
        }

        @Generated
        public static @org.jspecify.annotations.NonNull StartDuration of(@NonNull TemporalFormatter startFormatter, @NonNull TemporalQuery<? extends Temporal> startQuery, @NonNull Function<? super CharSequence, ? extends TemporalAmount> duration) {
            if (startFormatter == null) {
                throw new NullPointerException("startFormatter is marked non-null but is null");
            }
            if (startQuery == null) {
                throw new NullPointerException("startQuery is marked non-null but is null");
            }
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            return new StartDuration(startFormatter, startQuery, duration);
        }

        private final class StartDurationAccessor
        implements TimeIntervalAccessor {
            private final CharSequence left;
            private final CharSequence right;

            @Override
            @NonNull
            public Temporal start() {
                return StartDuration.this.startFormatter.parse(this.left, StartDuration.this.startQuery);
            }

            @Override
            @NonNull
            public Temporal end() {
                throw new DateTimeException("Not supported for this TimeIntervalFormatter");
            }

            @Override
            @NonNull
            public TemporalAmount getDuration() {
                return StartDuration.this.duration.apply(this.right);
            }

            @Generated
            public StartDurationAccessor(CharSequence left, CharSequence right) {
                this.left = left;
                this.right = right;
            }
        }
    }

    public static final class StartEnd
    extends TimeIntervalFormatter {
        @Deprecated
        public static final StartEnd ISO_LOCAL_DATE = StartEnd.of(TemporalFormatter.EXTENDED_CALENDAR, LocalDate::from, false);
        @Deprecated
        public static final StartEnd BASIC_ISO_DATE = StartEnd.of(TemporalFormatter.BASIC_CALENDAR, LocalDate::from, false);
        @Deprecated
        public static final StartEnd ISO_ORDINAL_DATE = StartEnd.of(TemporalFormatter.EXTENDED_ORDINAL, LocalDate::from, false);
        @Deprecated
        public static final StartEnd ISO_WEEK_DATE = StartEnd.of(TemporalFormatter.EXTENDED_WEEK, LocalDate::from, false);
        @Deprecated
        public static final StartEnd ISO_LOCAL_DATE_TIME = StartEnd.of(TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from, false);
        @NonNull
        private final TemporalFormatter startEndFormatter;
        @NonNull
        private final TemporalQuery<? extends Temporal> startEndQuery;
        private boolean concise;

        @Override
        public void formatTo(@NonNull TimeInterval<?, ?> timeInterval, @NonNull Appendable appendable, @Nullable ChronoUnit precision) {
            if (timeInterval == null) {
                throw new NullPointerException("timeInterval is marked non-null but is null");
            }
            if (appendable == null) {
                throw new NullPointerException("appendable is marked non-null but is null");
            }
            String left = this.startEndFormatter.format((Temporal)timeInterval.start());
            String right = this.startEndFormatter.format((Temporal)timeInterval.end());
            TemporalFormatter.appendTo(left, appendable);
            TemporalFormatter.appendTo('/', appendable);
            TemporalFormatter.appendTo(this.concise ? TimeIntervalFormatter.compact(left, right) : right, appendable);
        }

        @Override
        @NonNull
        public <I extends TimeInterval<?, ?>> I parse(@NonNull CharSequence text, @NonNull TimeIntervalQuery<I> query) {
            CharSequence right;
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            int intervalDesignatorIdx = TimeIntervalFormatter.getIntervalDesignatorIndex(text);
            CharSequence left = text.subSequence(0, intervalDesignatorIdx);
            TimeInterval result = (TimeInterval)query.queryFrom(new StartEndAccessor(left, right = text.subSequence(intervalDesignatorIdx + 1, text.length())));
            if (result == null) {
                throw new DateTimeException("Unable to obtain TimeInterval from TimeIntervalQuery");
            }
            return (I)result;
        }

        @Generated
        private StartEnd(@NonNull TemporalFormatter startEndFormatter, @NonNull TemporalQuery<? extends Temporal> startEndQuery, boolean concise) {
            if (startEndFormatter == null) {
                throw new NullPointerException("startEndFormatter is marked non-null but is null");
            }
            if (startEndQuery == null) {
                throw new NullPointerException("startEndQuery is marked non-null but is null");
            }
            this.startEndFormatter = startEndFormatter;
            this.startEndQuery = startEndQuery;
            this.concise = concise;
        }

        @Generated
        public static @org.jspecify.annotations.NonNull StartEnd of(@NonNull TemporalFormatter startEndFormatter, @NonNull TemporalQuery<? extends Temporal> startEndQuery, boolean concise) {
            if (startEndFormatter == null) {
                throw new NullPointerException("startEndFormatter is marked non-null but is null");
            }
            if (startEndQuery == null) {
                throw new NullPointerException("startEndQuery is marked non-null but is null");
            }
            return new StartEnd(startEndFormatter, startEndQuery, concise);
        }

        @Generated
        public @org.jspecify.annotations.NonNull StartEnd withConcise(boolean concise) {
            return this.concise == concise ? this : new StartEnd(this.startEndFormatter, this.startEndQuery, concise);
        }

        private final class StartEndAccessor
        implements TimeIntervalAccessor {
            private final CharSequence left;
            private final CharSequence right;

            @Override
            @NonNull
            public Temporal start() {
                return StartEnd.this.startEndFormatter.parse(this.left, StartEnd.this.startEndQuery);
            }

            @Override
            @NonNull
            public Temporal end() {
                return StartEnd.this.startEndFormatter.parse(TimeIntervalFormatter.expand(this.left, this.right), StartEnd.this.startEndQuery);
            }

            @Override
            @NonNull
            public TemporalAmount getDuration() {
                throw new DateTimeException("Not supported for this TimeIntervalFormatter");
            }

            @Generated
            public StartEndAccessor(CharSequence left, CharSequence right) {
                this.left = left;
                this.right = right;
            }
        }
    }
}

