## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(nomiShape)

## ----setup, include=FALSE-----------------------------------------------------
library(nomiShape)
library(dplyr)

## ----ranked-barplot-example---------------------------------------------------
# Example usage of ranked_barplot
ranked_barplot(categories, "animal")

## ----ranked-barplot-example-2-------------------------------------------------
# Example usage of ranked_barplot
ranked_barplot(categories2, "animal")

## ----ranked-barplot-exampl-3--------------------------------------------------
# Example usage of ranked_barplot
ranked_barplot(categories3, "animal")

## ----ranked-dotplot-example-1-------------------------------------------------
# Example usage of ranked_dotplot
ranked_dotplot(categories, "animal", connect = TRUE)

## ----ranked-dotplot-example-2-------------------------------------------------
# Example usage of ranked_dotplot
ranked_dotplot(categories2, "animal", connect = TRUE, shade = TRUE)

## ----ranked-dotplot-example-3-------------------------------------------------
# Example usage of ranked_dotplot
ranked_dotplot(categories3, "animal", connect = FALSE, shade = TRUE)

## ----pareto-chart-example 1---------------------------------------------------
# Example usage of pareto
pareto(categories3, "animal")

## ----centered-barplot-example 1-----------------------------------------------
# Example usage of centered_barplot
centered_barplot(categories, "animal")

## ----centered-barplot-example 2-----------------------------------------------
# Example usage of centered_barplot
centered_barplot(categories2, "animal",scale = "percent")

## ----centered-barplot-example 3-----------------------------------------------
# Example usage of centered_barplot
centered_barplot(categories3, "animal")

## ----centered-dotplot-example 1-----------------------------------------------
# Example usage of centered_dotplot
centered_dotplot(categories, "animal",connect = TRUE,shade = TRUE)

## ----centered-dotplot-example 2-----------------------------------------------
# Example usage of centered_dotplot
centered_dotplot(categories2, "animal",connect = TRUE,shade = TRUE)

## ----centered-dotplot-example 3-----------------------------------------------
# Example usage of centered_dotplot
centered_dotplot(categories3, "animal",connect = TRUE,shade = TRUE)

## ----pielou-evenness-example-1------------------------------------------------
# Example usage of pielou_evenness
pielou_evenness(categories, "animal")

## ----pielou-evenness-example-2------------------------------------------------
# Example usage of pielou_evenness
pielou_evenness(categories2, "animal")

## ----pielou-evenness-example-3------------------------------------------------
# Example usage of pielou_evenness
pielou_evenness(categories3, "animal")

## ----dominance-index-example-1------------------------------------------------
# Example usage of dominance_index
dominance_index(categories, "animal")

## ----dominance-index-example-2------------------------------------------------
# Example usage of dominance_index
dominance_index(categories2, "animal")

## ----dominance-index-example-3------------------------------------------------
# Example usage of dominance_index
dominance_index(categories3, "animal")

## ----central-concentration-example-1------------------------------------------
# Example usage of central_concentration
central_concentration(categories, "animal")

## ----central-concentration-example-2------------------------------------------
# Example usage of central_concentration
central_concentration(categories2, "animal")

## ----central-concentration-example-3------------------------------------------
# Example usage of central_concentration
central_concentration(categories3, "animal")

## ----tail-index-example-1-----------------------------------------------------
# Example usage of tail_index
tail_index(categories, "animal")

## ----tail-index-example-2-----------------------------------------------------
# Example usage of tail_index
tail_index(categories2, "animal", threshold = 0.9)

## ----tail-index-example-3-----------------------------------------------------
# Example usage of tail_index
tail_index(categories3, "animal", threshold = 0.75)

## ----shape-comp-plot-example-1------------------------------------------------
# Example usage of shape_comp_plot
shape_comp_plot(categories, "animal")

## ----shape-comp-plot-example-2------------------------------------------------
# Example usage of shape_comp_plot
shape_comp_plot(categories2, "animal")

## ----shape-comp-plot-example-3------------------------------------------------
# Example usage of shape_comp_plot
shape_comp_plot(categories3, "animal")

## ----shape-comp-plot-example-4------------------------------------------------
# Example usage of shape_comp_plot
shape_comp_plot(starwars, "species")

## ----shape-aic-example-1------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories, "animal")

## ----shape-aic-example-2------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories2, "animal")

## ----shape-aic-example-3------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories3, "animal")

