(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = global || self, global.Tangram = factory());
}(this, function () { 'use strict';

// define() gets called for each chunk generated by the first Rollup pass.
// The order the chunks are called in is controlled by the imports in bundle.js:
//
// shared.js: shared dependencies between main and worker threads
// scene_worker.js: worker thread code
// index.js: main thread code

// Once all chunks have been provided, the worker thread code is assembled,
// incorporating the shared chunk code, then turned into a blob URL which
// can be used to instantiate the worker.

var shared, worker, Tangram = {};

function define(_, chunk) {
	if (!shared) {
	    shared = chunk;
	} else if (!worker) {
	    worker = chunk;
	} else {
	    var worker_bundle = 'var shared_chunk = {}; (' + shared + ')(shared_chunk); (' + worker + ')(shared_chunk);'
	    var shared_chunk = {};
	    shared(shared_chunk);
	    Tangram = chunk(shared_chunk);
	    Tangram.workerURL = window.URL.createObjectURL(new Blob([worker_bundle], { type: 'text/javascript' }));
	}
}


define(["exports"],function(e){"use strict";function t(e,t){return e(t={exports:{}},t.exports),t.exports}var r=t(function(e){var t=e.exports={version:"2.6.3"};"number"==typeof __e&&(__e=t);}),n=(r.version,t(function(e){var t=e.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=t);})),i=t(function(e){var t=n["__core-js_shared__"]||(n["__core-js_shared__"]={});(e.exports=function(e,r){return t[e]||(t[e]=void 0!==r?r:{})})("versions",[]).push({version:r.version,mode:"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"});}),o=0,s=Math.random(),a=function(e){return "Symbol(".concat(void 0===e?"":e,")_",(++o+s).toString(36))},l=t(function(e){var t=i("wks"),r=n.Symbol,o="function"==typeof r;(e.exports=function(e){return t[e]||(t[e]=o&&r[e]||(o?r:a)("Symbol."+e))}).store=t;}),u=function(e){return "object"==typeof e?null!==e:"function"==typeof e},c=function(e){if(!u(e))throw TypeError(e+" is not an object!");return e},f=function(e){try{return !!e()}catch(e){return !0}},h=!f(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}),d=n.document,_=u(d)&&u(d.createElement),p=function(e){return _?d.createElement(e):{}},m=!h&&!f(function(){return 7!=Object.defineProperty(p("div"),"a",{get:function(){return 7}}).a}),v=function(e,t){if(!u(e))return e;var r,n;if(t&&"function"==typeof(r=e.toString)&&!u(n=r.call(e)))return n;if("function"==typeof(r=e.valueOf)&&!u(n=r.call(e)))return n;if(!t&&"function"==typeof(r=e.toString)&&!u(n=r.call(e)))return n;throw TypeError("Can't convert object to primitive value")},g=Object.defineProperty,y={f:h?Object.defineProperty:function(e,t,r){if(c(e),t=v(t,!0),c(r),m)try{return g(e,t,r)}catch(e){}if("get"in r||"set"in r)throw TypeError("Accessors not supported!");return "value"in r&&(e[t]=r.value),e}},x=function(e,t){return {enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}},b=h?function(e,t,r){return y.f(e,t,x(1,r))}:function(e,t,r){return e[t]=r,e},A=l("unscopables"),T=Array.prototype;null==T[A]&&b(T,A,{});var w=function(e){T[A][e]=!0;},E=function(e,t){return {value:t,done:!!e}},R={},M={}.toString,S=function(e){return M.call(e).slice(8,-1)},z=Object("z").propertyIsEnumerable(0)?Object:function(e){return "String"==S(e)?e.split(""):Object(e)},N=function(e){if(null==e)throw TypeError("Can't call method on  "+e);return e},P=function(e){return z(N(e))},k={}.hasOwnProperty,O=function(e,t){return k.call(e,t)},L=t(function(e){var t=a("src"),i=Function.toString,o=(""+i).split("toString");r.inspectSource=function(e){return i.call(e)},(e.exports=function(e,r,i,s){var a="function"==typeof i;a&&(O(i,"name")||b(i,"name",r)),e[r]!==i&&(a&&(O(i,t)||b(i,t,e[r]?""+e[r]:o.join(String(r)))),e===n?e[r]=i:s?e[r]?e[r]=i:b(e,r,i):(delete e[r],b(e,r,i)));})(Function.prototype,"toString",function(){return "function"==typeof this&&this[t]||i.call(this)});}),I=function(e){if("function"!=typeof e)throw TypeError(e+" is not a function!");return e},F=function(e,t,r){if(I(e),void 0===t)return e;switch(r){case 1:return function(r){return e.call(t,r)};case 2:return function(r,n){return e.call(t,r,n)};case 3:return function(r,n,i){return e.call(t,r,n,i)}}return function(){return e.apply(t,arguments)}},U=function(e,t,i){var o,s,a,l,u=e&U.F,c=e&U.G,f=e&U.S,h=e&U.P,d=e&U.B,_=c?n:f?n[t]||(n[t]={}):(n[t]||{}).prototype,p=c?r:r[t]||(r[t]={}),m=p.prototype||(p.prototype={});for(o in c&&(i=t),i)a=((s=!u&&_&&void 0!==_[o])?_:i)[o],l=d&&s?F(a,n):h&&"function"==typeof a?F(Function.call,a):a,_&&L(_,o,a,e&U.U),p[o]!=a&&b(p,o,l),h&&m[o]!=a&&(m[o]=a);};n.core=r,U.F=1,U.G=2,U.S=4,U.P=8,U.B=16,U.W=32,U.U=64,U.R=128;var D=U,G=Math.ceil,C=Math.floor,j=function(e){return isNaN(e=+e)?0:(e>0?C:G)(e)},V=Math.min,B=function(e){return e>0?V(j(e),9007199254740991):0},q=Math.max,H=Math.min,X=function(e,t){return (e=j(e))<0?q(e+t,0):H(e,t)},W=function(e){return function(t,r,n){var i,o=P(t),s=B(o.length),a=X(n,s);if(e&&r!=r){for(;s>a;)if((i=o[a++])!=i)return !0}else for(;s>a;a++)if((e||a in o)&&o[a]===r)return e||a||0;return !e&&-1}},Z=i("keys"),Y=function(e){return Z[e]||(Z[e]=a(e))},$=W(!1),J=Y("IE_PROTO"),K=function(e,t){var r,n=P(e),i=0,o=[];for(r in n)r!=J&&O(n,r)&&o.push(r);for(;t.length>i;)O(n,r=t[i++])&&(~$(o,r)||o.push(r));return o},Q="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(","),ee=Object.keys||function(e){return K(e,Q)},te=h?Object.defineProperties:function(e,t){c(e);for(var r,n=ee(t),i=n.length,o=0;i>o;)y.f(e,r=n[o++],t[r]);return e},re=n.document,ne=re&&re.documentElement,ie=Y("IE_PROTO"),oe=function(){},se=function(){var e,t=p("iframe"),r=Q.length;for(t.style.display="none",ne.appendChild(t),t.src="javascript:",(e=t.contentWindow.document).open(),e.write("<script>document.F=Object<\/script>"),e.close(),se=e.F;r--;)delete se.prototype[Q[r]];return se()},ae=Object.create||function(e,t){var r;return null!==e?(oe.prototype=c(e),r=new oe,oe.prototype=null,r[ie]=e):r=se(),void 0===t?r:te(r,t)},le=y.f,ue=l("toStringTag"),ce=function(e,t,r){e&&!O(e=r?e:e.prototype,ue)&&le(e,ue,{configurable:!0,value:t});},fe={};b(fe,l("iterator"),function(){return this});var he=function(e,t,r){e.prototype=ae(fe,{next:x(1,r)}),ce(e,t+" Iterator");},de=function(e){return Object(N(e))},_e=Y("IE_PROTO"),pe=Object.prototype,me=Object.getPrototypeOf||function(e){return e=de(e),O(e,_e)?e[_e]:"function"==typeof e.constructor&&e instanceof e.constructor?e.constructor.prototype:e instanceof Object?pe:null},ve=l("iterator"),ge=!([].keys&&"next"in[].keys()),ye=function(){return this},xe=function(e,t,r,n,i,o,s){he(r,t,n);var a,l,u,c=function(e){if(!ge&&e in _)return _[e];switch(e){case"keys":case"values":return function(){return new r(this,e)}}return function(){return new r(this,e)}},f=t+" Iterator",h="values"==i,d=!1,_=e.prototype,p=_[ve]||_["@@iterator"]||i&&_[i],m=p||c(i),v=i?h?c("entries"):m:void 0,g="Array"==t&&_.entries||p;if(g&&(u=me(g.call(new e)))!==Object.prototype&&u.next&&(ce(u,f,!0),"function"!=typeof u[ve]&&b(u,ve,ye)),h&&p&&"values"!==p.name&&(d=!0,m=function(){return p.call(this)}),(ge||d||!_[ve])&&b(_,ve,m),R[t]=m,R[f]=ye,i)if(a={values:h?m:c("values"),keys:o?m:c("keys"),entries:v},s)for(l in a)l in _||L(_,l,a[l]);else D(D.P+D.F*(ge||d),t,a);return a},be=xe(Array,"Array",function(e,t){this._t=P(e),this._i=0,this._k=t;},function(){var e=this._t,t=this._k,r=this._i++;return !e||r>=e.length?(this._t=void 0,E(1)):E(0,"keys"==t?r:"values"==t?e[r]:[r,e[r]])},"values");R.Arguments=R.Array,w("keys"),w("values"),w("entries");for(var Ae=l("iterator"),Te=l("toStringTag"),we=R.Array,Ee={CSSRuleList:!0,CSSStyleDeclaration:!1,CSSValueList:!1,ClientRectList:!1,DOMRectList:!1,DOMStringList:!1,DOMTokenList:!0,DataTransferItemList:!1,FileList:!1,HTMLAllCollection:!1,HTMLCollection:!1,HTMLFormElement:!1,HTMLSelectElement:!1,MediaList:!0,MimeTypeArray:!1,NamedNodeMap:!1,NodeList:!0,PaintRequestList:!1,Plugin:!1,PluginArray:!1,SVGLengthList:!1,SVGNumberList:!1,SVGPathSegList:!1,SVGPointList:!1,SVGStringList:!1,SVGTransformList:!1,SourceBufferList:!1,StyleSheetList:!0,TextTrackCueList:!1,TextTrackList:!1,TouchList:!1},Re=ee(Ee),Me=0;Me<Re.length;Me++){var Se,ze=Re[Me],Ne=Ee[ze],Pe=n[ze],ke=Pe&&Pe.prototype;if(ke&&(ke[Ae]||b(ke,Ae,we),ke[Te]||b(ke,Te,ze),R[ze]=we,Ne))for(Se in be)ke[Se]||L(ke,Se,be[Se],!0);}var Oe={f:Object.getOwnPropertySymbols},Le={f:{}.propertyIsEnumerable},Ie=Object.assign,Fe=!Ie||f(function(){var e={},t={},r=Symbol(),n="abcdefghijklmnopqrst";return e[r]=7,n.split("").forEach(function(e){t[e]=e;}),7!=Ie({},e)[r]||Object.keys(Ie({},t)).join("")!=n})?function(e,t){for(var r=de(e),n=arguments.length,i=1,o=Oe.f,s=Le.f;n>i;)for(var a,l=z(arguments[i++]),u=o?ee(l).concat(o(l)):ee(l),c=u.length,f=0;c>f;)s.call(l,a=u[f++])&&(r[a]=l[a]);return r}:Ie;D(D.S+D.F,"Object",{assign:Fe});var Ue={};try{window instanceof Window&&window.document instanceof HTMLDocument&&(Ue.is_worker=!1,Ue.is_main=!0);}catch(e){Ue.is_worker=!0,Ue.is_main=!1,self.window={document:{}},self.document=self.window.document;}var De=function(e){return function(t,r){var n,i,o=String(N(t)),s=j(r),a=o.length;return s<0||s>=a?e?"":void 0:(n=o.charCodeAt(s))<55296||n>56319||s+1===a||(i=o.charCodeAt(s+1))<56320||i>57343?e?o.charAt(s):n:e?o.slice(s,s+2):i-56320+(n-55296<<10)+65536}},Ge=De(!0),Ce=function(e,t,r){return t+(r?Ge(e,t).length:1)},je=l("toStringTag"),Ve="Arguments"==S(function(){return arguments}()),Be=function(e){var t,r,n;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(r=function(e,t){try{return e[t]}catch(e){}}(t=Object(e),je))?r:Ve?S(t):"Object"==(n=S(t))&&"function"==typeof t.callee?"Arguments":n},qe=RegExp.prototype.exec,He=function(e,t){var r=e.exec;if("function"==typeof r){var n=r.call(e,t);if("object"!=typeof n)throw new TypeError("RegExp exec method returned something other than an Object or null");return n}if("RegExp"!==Be(e))throw new TypeError("RegExp#exec called on incompatible receiver");return qe.call(e,t)},Xe=function(){var e=c(this),t="";return e.global&&(t+="g"),e.ignoreCase&&(t+="i"),e.multiline&&(t+="m"),e.unicode&&(t+="u"),e.sticky&&(t+="y"),t},We=RegExp.prototype.exec,Ze=String.prototype.replace,Ye=We,$e=function(){var e=/a/,t=/b*/g;return We.call(e,"a"),We.call(t,"a"),0!==e.lastIndex||0!==t.lastIndex}(),Je=void 0!==/()??/.exec("")[1];($e||Je)&&(Ye=function(e){var t,r,n,i,o=this;return Je&&(r=new RegExp("^"+o.source+"$(?!\\s)",Xe.call(o))),$e&&(t=o.lastIndex),n=We.call(o,e),$e&&n&&(o.lastIndex=o.global?n.index+n[0].length:t),Je&&n&&n.length>1&&Ze.call(n[0],r,function(){for(i=1;i<arguments.length-2;i++)void 0===arguments[i]&&(n[i]=void 0);}),n});var Ke=Ye;D({target:"RegExp",proto:!0,forced:Ke!==/./.exec},{exec:Ke});var Qe=l("species"),et=!f(function(){var e=/./;return e.exec=function(){var e=[];return e.groups={a:"7"},e},"7"!=="".replace(e,"$<a>")}),tt=function(){var e=/(?:)/,t=e.exec;e.exec=function(){return t.apply(this,arguments)};var r="ab".split(e);return 2===r.length&&"a"===r[0]&&"b"===r[1]}(),rt=function(e,t,r){var n=l(e),i=!f(function(){var t={};return t[n]=function(){return 7},7!=""[e](t)}),o=i?!f(function(){var t=!1,r=/a/;return r.exec=function(){return t=!0,null},"split"===e&&(r.constructor={},r.constructor[Qe]=function(){return r}),r[n](""),!t}):void 0;if(!i||!o||"replace"===e&&!et||"split"===e&&!tt){var s=/./[n],a=r(N,n,""[e],function(e,t,r,n,o){return t.exec===Ke?i&&!o?{done:!0,value:s.call(t,r,n)}:{done:!0,value:e.call(r,t,n)}:{done:!1}}),u=a[0],c=a[1];L(String.prototype,e,u),b(RegExp.prototype,n,2==t?function(e,t){return c.call(e,this,t)}:function(e){return c.call(e,this)});}},nt=Math.max,it=Math.min,ot=Math.floor,st=/\$([$&`']|\d\d?|<[^>]*>)/g,at=/\$([$&`']|\d\d?)/g;rt("replace",2,function(e,t,r,n){return [function(n,i){var o=e(this),s=null==n?void 0:n[t];return void 0!==s?s.call(n,o,i):r.call(String(o),n,i)},function(e,t){var o=n(r,e,this,t);if(o.done)return o.value;var s=c(e),a=String(this),l="function"==typeof t;l||(t=String(t));var u=s.global;if(u){var f=s.unicode;s.lastIndex=0;}for(var h=[];;){var d=He(s,a);if(null===d)break;if(h.push(d),!u)break;""===String(d[0])&&(s.lastIndex=Ce(a,B(s.lastIndex),f));}for(var _,p="",m=0,v=0;v<h.length;v++){d=h[v];for(var g=String(d[0]),y=nt(it(j(d.index),a.length),0),x=[],b=1;b<d.length;b++)x.push(void 0===(_=d[b])?_:String(_));var A=d.groups;if(l){var T=[g].concat(x,y,a);void 0!==A&&T.push(A);var w=String(t.apply(void 0,T));}else w=i(g,a,y,x,A,t);y>=m&&(p+=a.slice(m,y)+w,m=y+g.length);}return p+a.slice(m)}];function i(e,t,n,i,o,s){var a=n+e.length,l=i.length,u=at;return void 0!==o&&(o=de(o),u=st),r.call(s,u,function(r,s){var u;switch(s.charAt(0)){case"$":return "$";case"&":return e;case"`":return t.slice(0,n);case"'":return t.slice(a);case"<":u=o[s.slice(1,-1)];break;default:var c=+s;if(0===c)return r;if(c>l){var f=ot(c/10);return 0===f?r:f<=l?void 0===i[f-1]?s.charAt(1):i[f-1]+s.charAt(1):r}u=i[c-1];}return void 0===u?"":u})}});var lt,ut,ct=[].sort,ft=[1,2,3];D(D.P+D.F*(f(function(){ft.sort(void 0);})||!f(function(){ft.sort(null);})||!((lt=ct)&&f(function(){ut?lt.call(null,function(){},1):lt.call(null);}))),"Array",{sort:function(e){return void 0===e?ct.call(de(this)):ct.call(de(this),I(e))}});var ht=t(function(e){var t=a("meta"),r=y.f,n=0,i=Object.isExtensible||function(){return !0},o=!f(function(){return i(Object.preventExtensions({}))}),s=function(e){r(e,t,{value:{i:"O"+ ++n,w:{}}});},l=e.exports={KEY:t,NEED:!1,fastKey:function(e,r){if(!u(e))return "symbol"==typeof e?e:("string"==typeof e?"S":"P")+e;if(!O(e,t)){if(!i(e))return "F";if(!r)return "E";s(e);}return e[t].i},getWeak:function(e,r){if(!O(e,t)){if(!i(e))return !0;if(!r)return !1;s(e);}return e[t].w},onFreeze:function(e){return o&&l.NEED&&i(e)&&!O(e,t)&&s(e),e}};}),dt=(ht.KEY,ht.NEED,ht.fastKey,ht.getWeak,ht.onFreeze,Array.isArray||function(e){return "Array"==S(e)}),_t=Q.concat("length","prototype"),pt={f:Object.getOwnPropertyNames||function(e){return K(e,_t)}},mt=Object.getOwnPropertyDescriptor,vt={f:h?mt:function(e,t){if(e=P(e),t=v(t,!0),m)try{return mt(e,t)}catch(e){}if(O(e,t))return x(!Le.f.call(e,t),e[t])}},gt=De(!0);xe(String,"String",function(e){this._t=String(e),this._i=0;},function(){var e,t=this._t,r=this._i;return r>=t.length?{value:void 0,done:!0}:(e=gt(t,r),this._i+=e.length,{value:e,done:!1})});var yt,xt,bt,At=function(e,t,r,n){if(!(e instanceof t)||void 0!==n&&n in e)throw TypeError(r+": incorrect invocation!");return e},Tt=function(e,t,r,n){try{return n?t(c(r)[0],r[1]):t(r)}catch(t){var i=e.return;throw void 0!==i&&c(i.call(e)),t}},wt=l("iterator"),Et=Array.prototype,Rt=function(e){return void 0!==e&&(R.Array===e||Et[wt]===e)},Mt=l("iterator"),St=r.getIteratorMethod=function(e){if(null!=e)return e[Mt]||e["@@iterator"]||R[Be(e)]},zt=t(function(e){var t={},r={},n=e.exports=function(e,n,i,o,s){var a,l,u,f,h=s?function(){return e}:St(e),d=F(i,o,n?2:1),_=0;if("function"!=typeof h)throw TypeError(e+" is not iterable!");if(Rt(h)){for(a=B(e.length);a>_;_++)if((f=n?d(c(l=e[_])[0],l[1]):d(e[_]))===t||f===r)return f}else for(u=h.call(e);!(l=u.next()).done;)if((f=Tt(u,d,l.value,n))===t||f===r)return f};n.BREAK=t,n.RETURN=r;}),Nt=l("species"),Pt=function(e,t){var r,n=c(e).constructor;return void 0===n||null==(r=c(n)[Nt])?t:I(r)},kt=n.process,Ot=n.setImmediate,Lt=n.clearImmediate,It=n.MessageChannel,Ft=n.Dispatch,Ut=0,Dt={},Gt=function(){var e=+this;if(Dt.hasOwnProperty(e)){var t=Dt[e];delete Dt[e],t();}},Ct=function(e){Gt.call(e.data);};Ot&&Lt||(Ot=function(e){for(var t=[],r=1;arguments.length>r;)t.push(arguments[r++]);return Dt[++Ut]=function(){!function(e,t,r){var n=void 0===r;switch(t.length){case 0:return n?e():e.call(r);case 1:return n?e(t[0]):e.call(r,t[0]);case 2:return n?e(t[0],t[1]):e.call(r,t[0],t[1]);case 3:return n?e(t[0],t[1],t[2]):e.call(r,t[0],t[1],t[2]);case 4:return n?e(t[0],t[1],t[2],t[3]):e.call(r,t[0],t[1],t[2],t[3])}e.apply(r,t);}("function"==typeof e?e:Function(e),t);},yt(Ut),Ut},Lt=function(e){delete Dt[e];},"process"==S(kt)?yt=function(e){kt.nextTick(F(Gt,e,1));}:Ft&&Ft.now?yt=function(e){Ft.now(F(Gt,e,1));}:It?(bt=(xt=new It).port2,xt.port1.onmessage=Ct,yt=F(bt.postMessage,bt,1)):n.addEventListener&&"function"==typeof postMessage&&!n.importScripts?(yt=function(e){n.postMessage(e+"","*");},n.addEventListener("message",Ct,!1)):yt="onreadystatechange"in p("script")?function(e){ne.appendChild(p("script")).onreadystatechange=function(){ne.removeChild(this),Gt.call(e);};}:function(e){setTimeout(F(Gt,e,1),0);});var jt={set:Ot,clear:Lt},Vt=jt.set,Bt=n.MutationObserver||n.WebKitMutationObserver,qt=n.process,Ht=n.Promise,Xt="process"==S(qt);function Wt(e){var t,r;this.promise=new e(function(e,n){if(void 0!==t||void 0!==r)throw TypeError("Bad Promise constructor");t=e,r=n;}),this.resolve=I(t),this.reject=I(r);}var Zt={f:function(e){return new Wt(e)}},Yt=function(e){try{return {e:!1,v:e()}}catch(e){return {e:!0,v:e}}},$t=n.navigator,Jt=$t&&$t.userAgent||"",Kt=function(e,t,r){for(var n in t)L(e,n,t[n],r);return e},Qt=l("species"),er=function(e){var t=n[e];h&&t&&!t[Qt]&&y.f(t,Qt,{configurable:!0,get:function(){return this}});},tr=l("iterator"),rr=!1;try{var nr=[7][tr]();nr.return=function(){rr=!0;},Array.from(nr,function(){throw 2});}catch(e){}var ir,or,sr,ar,lr=function(e,t){if(!t&&!rr)return !1;var r=!1;try{var n=[7],i=n[tr]();i.next=function(){return {done:r=!0}},n[tr]=function(){return i},e(n);}catch(e){}return r},ur=jt.set,cr=function(){var e,t,r,i=function(){var n,i;for(Xt&&(n=qt.domain)&&n.exit();e;){i=e.fn,e=e.next;try{i();}catch(n){throw e?r():t=void 0,n}}t=void 0,n&&n.enter();};if(Xt)r=function(){qt.nextTick(i);};else if(!Bt||n.navigator&&n.navigator.standalone)if(Ht&&Ht.resolve){var o=Ht.resolve(void 0);r=function(){o.then(i);};}else r=function(){Vt.call(n,i);};else{var s=!0,a=document.createTextNode("");new Bt(i).observe(a,{characterData:!0}),r=function(){a.data=s=!s;};}return function(n){var i={fn:n,next:void 0};t&&(t.next=i),e||(e=i,r()),t=i;}}(),fr=n.TypeError,hr=n.process,dr=hr&&hr.versions,_r=dr&&dr.v8||"",pr=n.Promise,mr="process"==Be(hr),vr=function(){},gr=or=Zt.f,yr=!!function(){try{var e=pr.resolve(1),t=(e.constructor={})[l("species")]=function(e){e(vr,vr);};return (mr||"function"==typeof PromiseRejectionEvent)&&e.then(vr)instanceof t&&0!==_r.indexOf("6.6")&&-1===Jt.indexOf("Chrome/66")}catch(e){}}(),xr=function(e){var t;return !(!u(e)||"function"!=typeof(t=e.then))&&t},br=function(e,t){if(!e._n){e._n=!0;var r=e._c;cr(function(){for(var n=e._v,i=1==e._s,o=0,s=function(t){var r,o,s,a=i?t.ok:t.fail,l=t.resolve,u=t.reject,c=t.domain;try{a?(i||(2==e._h&&wr(e),e._h=1),!0===a?r=n:(c&&c.enter(),r=a(n),c&&(c.exit(),s=!0)),r===t.promise?u(fr("Promise-chain cycle")):(o=xr(r))?o.call(r,l,u):l(r)):u(n);}catch(e){c&&!s&&c.exit(),u(e);}};r.length>o;)s(r[o++]);e._c=[],e._n=!1,t&&!e._h&&Ar(e);});}},Ar=function(e){ur.call(n,function(){var t,r,i,o=e._v,s=Tr(e);if(s&&(t=Yt(function(){mr?hr.emit("unhandledRejection",o,e):(r=n.onunhandledrejection)?r({promise:e,reason:o}):(i=n.console)&&i.error&&i.error("Unhandled promise rejection",o);}),e._h=mr||Tr(e)?2:1),e._a=void 0,s&&t.e)throw t.v});},Tr=function(e){return 1!==e._h&&0===(e._a||e._c).length},wr=function(e){ur.call(n,function(){var t;mr?hr.emit("rejectionHandled",e):(t=n.onrejectionhandled)&&t({promise:e,reason:e._v});});},Er=function(e){var t=this;t._d||(t._d=!0,(t=t._w||t)._v=e,t._s=2,t._a||(t._a=t._c.slice()),br(t,!0));},Rr=function(e){var t,r=this;if(!r._d){r._d=!0,r=r._w||r;try{if(r===e)throw fr("Promise can't be resolved itself");(t=xr(e))?cr(function(){var n={_w:r,_d:!1};try{t.call(e,F(Rr,n,1),F(Er,n,1));}catch(e){Er.call(n,e);}}):(r._v=e,r._s=1,br(r,!1));}catch(e){Er.call({_w:r,_d:!1},e);}}};yr||(pr=function(e){At(this,pr,"Promise","_h"),I(e),ir.call(this);try{e(F(Rr,this,1),F(Er,this,1));}catch(e){Er.call(this,e);}},(ir=function(e){this._c=[],this._a=void 0,this._s=0,this._d=!1,this._v=void 0,this._h=0,this._n=!1;}).prototype=Kt(pr.prototype,{then:function(e,t){var r=gr(Pt(this,pr));return r.ok="function"!=typeof e||e,r.fail="function"==typeof t&&t,r.domain=mr?hr.domain:void 0,this._c.push(r),this._a&&this._a.push(r),this._s&&br(this,!1),r.promise},catch:function(e){return this.then(void 0,e)}}),sr=function(){var e=new ir;this.promise=e,this.resolve=F(Rr,e,1),this.reject=F(Er,e,1);},Zt.f=gr=function(e){return e===pr||e===ar?new sr(e):or(e)}),D(D.G+D.W+D.F*!yr,{Promise:pr}),ce(pr,"Promise"),er("Promise"),ar=r.Promise,D(D.S+D.F*!yr,"Promise",{reject:function(e){var t=gr(this);return (0,t.reject)(e),t.promise}}),D(D.S+D.F*!yr,"Promise",{resolve:function(e){return function(e,t){if(c(e),u(t)&&t.constructor===e)return t;var r=Zt.f(e);return (0,r.resolve)(t),r.promise}(this,e)}}),D(D.S+D.F*!(yr&&lr(function(e){pr.all(e).catch(vr);})),"Promise",{all:function(e){var t=this,r=gr(t),n=r.resolve,i=r.reject,o=Yt(function(){var r=[],o=0,s=1;zt(e,!1,function(e){var a=o++,l=!1;r.push(void 0),s++,t.resolve(e).then(function(e){l||(l=!0,r[a]=e,--s||n(r));},i);}),--s||n(r);});return o.e&&i(o.v),r.promise},race:function(e){var t=this,r=gr(t),n=r.reject,i=Yt(function(){zt(e,!1,function(e){t.resolve(e).then(r.resolve,n);});});return i.e&&n(i.v),r.promise}});var Mr=y.f,Sr=Function.prototype,zr=/^\s*function ([^ (]*)/;"name"in Sr||h&&Mr(Sr,"name",{configurable:!0,get:function(){try{return (""+this).match(zr)[1]}catch(e){return ""}}});var Nr=function(e,t){var n=(r.Object||{})[e]||Object[e],i={};i[e]=t(n),D(D.S+D.F*f(function(){n(1);}),"Object",i);};function Pr(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n);}}function kr(e,t,r){return t&&Pr(e.prototype,t),r&&Pr(e,r),e}function Or(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e.__proto__=t;}function Lr(e){return (Lr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function Ir(e,t){return (Ir=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function Fr(e,t,r){return (Fr=function(){if("undefined"==typeof Reflect||!Reflect.construct)return !1;if(Reflect.construct.sham)return !1;if("function"==typeof Proxy)return !0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(e){return !1}}()?Reflect.construct:function(e,t,r){var n=[null];n.push.apply(n,t);var i=new(Function.bind.apply(e,n));return r&&Ir(i,r.prototype),i}).apply(null,arguments)}function Ur(e){var t="function"==typeof Map?new Map:void 0;return (Ur=function(e){if(null===e||(r=e,-1===Function.toString.call(r).indexOf("[native code]")))return e;var r;if("function"!=typeof e)throw new TypeError("Super expression must either be null or a function");if(void 0!==t){if(t.has(e))return t.get(e);t.set(e,n);}function n(){return Fr(e,arguments,Lr(this).constructor)}return n.prototype=Object.create(e.prototype,{constructor:{value:n,enumerable:!1,writable:!0,configurable:!0}}),Ir(n,e)})(e)}Nr("keys",function(){return function(e){return ee(de(e))}});var Dr,Gr="v0.20.0",Cr=l("match"),jr=function(e){var t;return u(e)&&(void 0!==(t=e[Cr])?!!t:"RegExp"==S(e))},Vr=Math.min,Br=[].push,qr=!f(function(){RegExp(4294967295,"y");});rt("split",2,function(e,t,r,n){var i;return i="c"=="abbc".split(/(b)*/)[1]||4!="test".split(/(?:)/,-1).length||2!="ab".split(/(?:ab)*/).length||4!=".".split(/(.?)(.?)/).length||".".split(/()()/).length>1||"".split(/.?/).length?function(e,t){var n=String(this);if(void 0===e&&0===t)return [];if(!jr(e))return r.call(n,e,t);for(var i,o,s,a=[],l=(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.unicode?"u":"")+(e.sticky?"y":""),u=0,c=void 0===t?4294967295:t>>>0,f=new RegExp(e.source,l+"g");(i=Ke.call(f,n))&&!((o=f.lastIndex)>u&&(a.push(n.slice(u,i.index)),i.length>1&&i.index<n.length&&Br.apply(a,i.slice(1)),s=i[0].length,u=o,a.length>=c));)f.lastIndex===i.index&&f.lastIndex++;return u===n.length?!s&&f.test("")||a.push(""):a.push(n.slice(u)),a.length>c?a.slice(0,c):a}:"0".split(void 0,0).length?function(e,t){return void 0===e&&0===t?[]:r.call(this,e,t)}:r,[function(r,n){var o=e(this),s=null==r?void 0:r[t];return void 0!==s?s.call(r,o,n):i.call(String(o),r,n)},function(e,t){var o=n(i,e,this,t,i!==r);if(o.done)return o.value;var s=c(e),a=String(this),l=Pt(s,RegExp),u=s.unicode,f=(s.ignoreCase?"i":"")+(s.multiline?"m":"")+(s.unicode?"u":"")+(qr?"y":"g"),h=new l(qr?s:"^(?:"+s.source+")",f),d=void 0===t?4294967295:t>>>0;if(0===d)return [];if(0===a.length)return null===He(h,a)?[a]:[];for(var _=0,p=0,m=[];p<a.length;){h.lastIndex=qr?p:0;var v,g=He(h,qr?a:a.slice(p));if(null===g||(v=Vr(B(h.lastIndex+(qr?0:p)),a.length))===_)p=Ce(a,p,u);else{if(m.push(a.slice(_,p)),m.length===d)return m;for(var y=1;y<=g.length-1;y++)if(m.push(g[y]),m.length===d)return m;p=_=v;}}return m.push(a.slice(_)),m}]});var Hr=Dr={},Xr=0,Wr={};function Zr(e){var t=[];"string"==typeof e&&(t=e.split("."),e=t.pop());for(var r=Dr.targets,n=0;n<t.length;n++){if(!r[t[n]])return [];r=r[t[n]];}return [e,r]}function Yr(e){Array.isArray(e)&&e.filter(function(e){return e.parent&&e.property}).forEach(function(e){return delete e.parent[e.property]});}Dr.targets={},Dr.addTarget=function(e,t){Dr.targets[e]=t;},Dr.removeTarget=function(e){e&&delete Dr.targets[e];},Dr.withTransferables=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];if(!(this instanceof Dr.withTransferables))return Fr(Dr.withTransferables,t);this.value=t,this.transferables=function e(t,r,n,i){void 0===r&&(r=null);void 0===n&&(n=null);void 0===i&&(i=[]);if(!t)return i;if(Array.isArray(t))t.forEach(function(r,n){return e(r,t,n,i)});else if("object"==typeof t)if(t instanceof ArrayBuffer)i.push({object:t,parent:r,property:n});else if(t.buffer instanceof ArrayBuffer)i.push({object:t.buffer,parent:r,property:n});else for(var o in t)e(t[o],t,o,i);return i}(this.value);},Ue.is_main&&(Dr.postMessage=function(e,t){for(var r=arguments.length,n=new Array(r>2?r-2:0),i=2;i<r;i++)n[i-2]=arguments[i];if(Array.isArray(e))return Promise.all(e.map(function(e){var r;return (r=Dr).postMessage.apply(r,[e,t].concat(n))}));var o={};"object"==typeof t&&(o=t,t=t.method);var s,a=new Promise(function(e,r){Wr[Xr]={method:t,message:n,resolve:e,reject:r};}),l=[];return n&&1===n.length&&n[0]instanceof Dr.withTransferables&&(l=n[0].transferables,n=n[0].value),s={type:"main_send",message_id:Xr,method:t,message:n},o.stringify&&(s=JSON.stringify(s)),e.postMessage(s,l.map(function(e){return e.object})),Yr(l),l.length>0&&Qr("trace","'"+t+"' transferred "+l.length+" objects to worker thread"),Xr++,a},Dr.addWorker=function(e){if(!(e instanceof Worker))throw Error("Worker broker could not add non-Worker object",e);e.addEventListener("message",function(t){var r="string"==typeof t.data?JSON.parse(t.data):t.data,n=r.message_id;if("worker_reply"===r.type)Wr[n]&&(r.error?Wr[n].reject(r.error):Wr[n].resolve(r.message),delete Wr[n]);else if("worker_send"===r.type&&null!=n){var i,o,s,a,l;try{var u=Zr(r.method);if(a=u[0],!(s=u[1]))throw Error("Worker broker could not dispatch message type "+r.method+" on target "+r.target+" because no object with that name is registered on main thread");if(!(l="function"==typeof s[a]&&s[a]))throw Error("Worker broker could not dispatch message type "+r.method+" on target "+r.target+" because object has no method with that name");i=l.apply(s,r.message);}catch(e){o=e;}var c,f=[];i instanceof Promise?i.then(function(t){t instanceof Dr.withTransferables&&(f=t.transferables,t=t.value[0]),c={type:"main_reply",message_id:n,message:t},e.postMessage(c,f.map(function(e){return e.object})),Yr(f),f.length>0&&Qr("trace","'"+a+"' transferred "+f.length+" objects to worker thread");},function(t){e.postMessage({type:"main_reply",message_id:n,error:t instanceof Error?t.message+": "+t.stack:t});}):(i instanceof Dr.withTransferables&&(f=i.transferables,i=i.value[0]),c={type:"main_reply",message_id:n,message:i,error:o instanceof Error?o.message+": "+o.stack:o},e.postMessage(c,f.map(function(e){return e.object})),Yr(f),f.length>0&&Qr("trace","'"+a+"' transferred "+f.length+" objects to worker thread"));}});},Dr.getMessages=function(){return Wr},Dr.getMessageId=function(){return Xr}),Ue.is_worker&&(Dr.postMessage=function(e){for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];var i={};"object"==typeof e&&(i=e,e=e.method);var o,s=new Promise(function(t,n){Wr[Xr]={method:e,message:r,resolve:t,reject:n};}),a=[];return r&&1===r.length&&r[0]instanceof Dr.withTransferables&&(a=r[0].transferables,r=r[0].value),o={type:"worker_send",message_id:Xr,method:e,message:r},i.stringify&&(o=JSON.stringify(o)),self.postMessage(o,a.map(function(e){return e.object})),Yr(a),a.length>0&&Qr("trace","'"+e+"' transferred "+a.length+" objects to main thread"),Xr++,s},self.addEventListener("message",function(e){var t="string"==typeof e.data?JSON.parse(e.data):e.data,r=t.message_id;if("main_reply"===t.type)Wr[r]&&(t.error?Wr[r].reject(t.error):Wr[r].resolve(t.message),delete Wr[r]);else if("main_send"===t.type&&null!=r){var n,i,o,s,a;try{var l=Zr(t.method);if(s=l[0],!(o=l[1]))throw Error("Worker broker could not dispatch message type "+t.method+" on target "+t.target+" because no object with that name is registered on main thread");if(!(a="function"==typeof o[s]&&o[s]))throw Error("Worker broker could not dispatch message type "+t.method+" because worker has no method with that name");n=a.apply(o,t.message);}catch(e){i=e;}var u,c=[];n instanceof Promise?n.then(function(e){e instanceof Dr.withTransferables&&(c=e.transferables,e=e.value[0]),u={type:"worker_reply",message_id:r,message:e},self.postMessage(u,c.map(function(e){return e.object})),Yr(c),c.length>0&&Qr("trace","'"+s+"' transferred "+c.length+" objects to main thread");},function(e){self.postMessage({type:"worker_reply",message_id:r,error:e instanceof Error?e.message+": "+e.stack:e});}):(n instanceof Dr.withTransferables&&(c=n.transferables,n=n.value[0]),u={type:"worker_reply",message_id:r,message:n,error:i instanceof Error?i.message+": "+i.stack:i},self.postMessage(u,c.map(function(e){return e.object})),Yr(c),c.length>0&&Qr("trace","'"+s+"' transferred "+c.length+" objects to main thread"));}}));var $r={silent:-1,error:0,warn:1,info:2,debug:3,trace:4},Jr={},Kr={};function Qr(e){var t="object"==typeof e?e.level:e;if($r[t]<=$r[Qr.level]){for(var r=arguments.length,n=new Array(r>1?r-1:0),i=1;i<r;i++)n[i-1]=arguments[i];if(Ue.is_worker)return Hr.postMessage.apply(Hr,[{method:"_logProxy",stringify:!0},e].concat(n));if("object"==typeof e&&!0===e.once){if(Kr[JSON.stringify(n)])return Promise.resolve(!1);Kr[JSON.stringify(n)]=!0;}var o=function(e){if(Ue.is_main)return Jr[e]=Jr[e]||(console[e]?console[e]:console.log).bind(console),Jr[e]}(t);return n.length>1?o.apply(void 0,["Tangram "+Gr+" ["+t+"]: "+n[0]].concat(n.slice(1))):o("Tangram "+Gr+" ["+t+"]: "+n[0]),Promise.resolve(!0)}return Promise.resolve(!1)}Qr.level="info",Qr.workers=null,Qr.setLevel=function(e){Qr.level=e,Ue.is_main&&Array.isArray(Qr.workers)&&Hr.postMessage(Qr.workers,"_logSetLevelProxy",e);},Ue.is_main&&(Qr.setWorkers=function(e){Qr.workers=e;},Qr.reset=function(){Kr={};}),Hr.addTarget("_logProxy",Qr),Hr.addTarget("_logSetLevelProxy",Qr.setLevel),h&&"g"!=/./g.flags&&y.f(RegExp.prototype,"flags",{configurable:!0,get:Xe});var en=/./.toString,tn=function(e){L(RegExp.prototype,"toString",e,!0);};f(function(){return "/a/b"!=en.call({source:"a",flags:"b"})})?tn(function(){var e=c(this);return "/".concat(e.source,"/","flags"in e?e.flags:!h&&e instanceof RegExp?Xe.call(e):void 0)}):"toString"!=en.name&&tn(function(){return en.call(this)});var rn,nn={};Hr.addTarget("Utils",nn),nn.isSafari=function(){return /^((?!chrome|android).)*safari/i.test(navigator.userAgent)},nn.isMicrosoft=function(){return /(Trident\/7.0|Edge[ \/](\d+[.\d]+))/i.test(navigator.userAgent)},nn._requests={},nn._proxy_requests={},nn.io=function(e,t,r,n,i,o,s){if(void 0===t&&(t=6e4),void 0===r&&(r="text"),void 0===n&&(n="GET"),void 0===i&&(i={}),void 0===o&&(o=null),void 0===s&&(s=!1),Ue.is_worker&&nn.isMicrosoft())return Qr("debug","Proxying request for URL to worker",e),o&&(nn._proxy_requests[o]=!0),Hr.postMessage("Utils.io",e,t,r,n,i,o,!0);var a=new XMLHttpRequest,l=new Promise(function(o,s){if(a.open(n,e,!0),a.timeout=t,a.responseType=r,i&&"object"==typeof i)for(var l in i)a.setRequestHeader(l,i[l]);a.onload=function(){200===a.status?["text","json"].indexOf(a.responseType)>-1?o({body:a.responseText,status:a.status}):o({body:a.response,status:a.status}):204===a.status?o({body:null,status:a.status}):s(Error("Request error with a status of "+a.statusText));},a.onerror=function(e){s(Error("There was a network error"+e.toString()));},a.ontimeout=function(e){s(Error("timeout "+e.toString()));},a.send();});return l=l.then(function(e){return o&&delete nn._requests[o],s?Hr.withTransferables(e):e}),o&&(nn._requests[o]=a),l},nn.cancelRequest=function(e){if(Ue.is_worker&&nn._proxy_requests[e])return Hr.postMessage("Utils.cancelRequest",e);nn._requests[e]?(Qr("trace","Cancelling network request key '"+e+"'"),nn._requests[e].abort(),delete nn._requests[e]):Qr("trace","Could not find network request key '"+e+"'");},nn.serializeWithFunctions=function(e){return "function"==typeof e?e.toString():JSON.stringify(e,function(e,t){return "function"==typeof t?t.toString():t})},nn.use_high_density_display=!0,nn.updateDevicePixelRatio=function(){var e=nn.device_pixel_ratio;return nn.device_pixel_ratio=nn.use_high_density_display&&window.devicePixelRatio||1,nn.device_pixel_ratio!==e},Ue.is_main&&nn.updateDevicePixelRatio(),nn.isPowerOf2=function(e){return 0==(e&e-1)},nn.interpolate=function(e,t,r){if(!Array.isArray(t)||!Array.isArray(t[0]))return t;if(t.length<1)return t;var n,i,o,s,a;if(e<=t[0][0])s=t[0][1],"function"==typeof r&&(s=r(s));else if(e>=t[t.length-1][0])s=t[t.length-1][1],"function"==typeof r&&(s=r(s));else for(var l=0;l<t.length-1;l++)if(e>=t[l][0]&&e<t[l+1][0]){if(n=t[l][0],i=t[l+1][0],Array.isArray(t[l][1])){s=[];for(var u=0;u<t[l][1].length;u++)"function"==typeof r?(a=r(t[l][1][u]),o=r(t[l+1][1][u])-a,s[u]=o*(e-n)/(i-n)+a):(o=t[l+1][1][u]-t[l][1][u],s[u]=o*(e-n)/(i-n)+t[l][1][u]);}else"function"==typeof r?(a=r(t[l][1]),s=(o=r(t[l+1][1])-a)*(e-n)/(i-n)+a):s=(o=t[l+1][1]-t[l][1])*(e-n)/(i-n)+t[l][1];break}return s},nn.toCSSColor=function(e){return 1===e[3]?"rgb("+e.slice(0,3).map(function(e){return Math.round(255*e)}).join(", ")+")":"rgba("+e.map(function(e,t){return t<3&&Math.round(255*e)||e}).join(", ")+")"};var on=rn={draw_label_collision_boxes:!1,draw_label_texture_boxes:!1,suppress_label_fade_in:!1,suppress_label_snap_animation:!1,show_hidden_labels:!1,layer_stats:!1};var sn=function(e,t){if(c(e),!u(t)&&null!==t)throw TypeError(t+": can't set as prototype!")},an={set:Object.setPrototypeOf||("__proto__"in{}?function(e,t,r){try{(r=F(Function.call,vt.f(Object.prototype,"__proto__").set,2))(e,[]),t=!(e instanceof Array);}catch(e){t=!0;}return function(e,n){return sn(e,n),t?e.__proto__=n:r(e,n),e}}({},!1):void 0),check:sn}.set,ln=function(e,t,r){var n,i=t.constructor;return i!==r&&"function"==typeof i&&(n=i.prototype)!==r.prototype&&u(n)&&an&&an(e,n),e},un=y.f,cn=pt.f,fn=n.RegExp,hn=fn,dn=fn.prototype,_n=/a/g,pn=/a/g,mn=new fn(_n)!==_n;if(h&&(!mn||f(function(){return pn[l("match")]=!1,fn(_n)!=_n||fn(pn)==pn||"/a/i"!=fn(_n,"i")}))){fn=function(e,t){var r=this instanceof fn,n=jr(e),i=void 0===t;return !r&&n&&e.constructor===fn&&i?e:ln(mn?new hn(n&&!i?e.source:e,t):hn((n=e instanceof fn)?e.source:e,n&&i?Xe.call(e):t),r?this:dn,fn)};for(var vn=function(e){e in fn||un(fn,e,{configurable:!0,get:function(){return hn[e]},set:function(t){hn[e]=t;}});},gn=cn(hn),yn=0;gn.length>yn;)vn(gn[yn++]);dn.constructor=fn,fn.prototype=dn,L(n,"RegExp",fn);}er("RegExp");var xn,bn=Object.is||function(e,t){return e===t?0!==e||1/e==1/t:e!=e&&t!=t};function An(e){if("string"==typeof e&&-1===e.search(/^(data|blob):/)){var t=e.indexOf("?");t>-1&&(e=e.substr(0,t));var r=e.indexOf("#");return r>-1&&(e=e.substr(0,r)),e.substr(0,e.lastIndexOf("/")+1)||""}return ""}function Tn(e){if("string"==typeof e)return !(e.search(/^(http|https|data|blob):/)>-1||"//"===e.substr(0,2))}function wn(e,t){e=e.replace(/[[]/,"\\[").replace(/[\]]/,"\\]");var r=new RegExp("[\\?&]"+e+"=([^&#]*)").exec(t);return null===r?"":decodeURIComponent(r[1].replace(/\+/g," "))}rt("search",1,function(e,t,r,n){return [function(r){var n=e(this),i=null==r?void 0:r[t];return void 0!==i?i.call(r,n):new RegExp(r)[t](String(n))},function(e){var t=n(r,e,this);if(t.done)return t.value;var i=c(e),o=String(this),s=i.lastIndex;bn(s,0)||(i.lastIndex=0);var a=He(i,o);return bn(i.lastIndex,s)||(i.lastIndex=s),null===a?-1:a.index}]});var En={id:0,queue:[],max_time:20,start_time:null,state:{},add:function(e){e.id=En.id++,e.max_time=e.max_time||En.max_time,e.pause_factor=e.pause_factor||1;var t=new Promise(function(t,r){e.resolve=t,e.reject=r;});return e.promise=t,e.elapsed=0,e.total_elapsed=0,e.stats={calls:0},this.queue.push(e),this.start_time=this.start_time||performance.now(),this.elapsed=performance.now()-this.start_time,(this.elapsed<En.max_time||e.immediate)&&this.process(e),e.promise},remove:function(e){var t=this.queue.indexOf(e);t>-1&&this.queue.splice(t,1);},process:function(e){if(!this.state.user_moving_view||!1!==e.user_moving_view)return e.pause?(e.pause--,!0):(e.stats.calls++,e.start_time=performance.now(),e.run(e))},processAll:function(){this.start_time=this.start_time||performance.now();for(var e=0;e<this.queue.length;e++){var t=this.queue[e];if(!0!==this.process(t)&&(t.pause||(t.pause=t.elapsed>t.max_time?t.pause_factor:0),t.total_elapsed+=t.elapsed),this.elapsed=performance.now()-this.start_time,this.elapsed>=En.max_time){this.start_time=null;break}}},finish:function(e,t){return e.elapsed=performance.now()-e.start_time,e.total_elapsed+=e.elapsed,this.remove(e),e.resolve(t),e.promise},cancel:function(e){var t;e.cancel instanceof Function&&(t=e.cancel(e)),e.resolve(t);},shouldContinue:function(e){return e.elapsed=performance.now()-e.start_time,this.elapsed=performance.now()-this.start_time,e.elapsed<e.max_time&&this.elapsed<En.max_time},removeForTile:function(e){for(var t=this.queue.length-1;t>=0;t--)this.queue[t].tile_id===e&&(this.cancel(this.queue[t]),this.queue.splice(t,1));},setState:function(e){this.state=e;}};function Rn(e){var t=[];return Object.assign(e,{subscribe:function(e){-1===t.indexOf(e)&&t.push(e);},unsubscribe:function(e){var r=t.indexOf(e);r>-1&&t.splice(r,1);},unsubscribeAll:function(){t=[];},trigger:function(e){for(var r=arguments.length,n=new Array(r>1?r-1:0),i=1;i<r;i++)n[i-1]=arguments[i];t.forEach(function(t){if("function"==typeof t[e])try{t[e].apply(t,n);}catch(t){Qr("warn","Caught exception in listener for event '"+e+"':",t);}});},hasSubscribersFor:function(e){var r=!1;return t.forEach(function(t){"function"==typeof t[e]&&(r=!0);}),r}})}function Mn(e,t){var r={};return t.forEach(function(t){return r[t]=e[t]}),r}D(D.P,"String",{repeat:function(e){var t=String(N(this)),r="",n=j(e);if(n<0||n==1/0)throw RangeError("Count can't be negative");for(;n>0;(n>>>=1)&&(t+=t))1&n&&(r+=t);return r}});for(var Sn,zn=a("typed_array"),Nn=a("view"),Pn=!(!n.ArrayBuffer||!n.DataView),kn=Pn,On=0,Ln="Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array".split(",");On<9;)(Sn=n[Ln[On++]])?(b(Sn.prototype,zn,!0),b(Sn.prototype,Nn,!0)):kn=!1;var In={ABV:Pn,CONSTR:kn,TYPED:zn,VIEW:Nn},Fn=function(e){if(void 0===e)return 0;var t=j(e),r=B(t);if(t!==r)throw RangeError("Wrong length!");return r},Un=function(e){for(var t=de(this),r=B(t.length),n=arguments.length,i=X(n>1?arguments[1]:void 0,r),o=n>2?arguments[2]:void 0,s=void 0===o?r:X(o,r);s>i;)t[i++]=e;return t},Dn=t(function(e,t){var r=pt.f,i=y.f,o="prototype",s="Wrong index!",a=n.ArrayBuffer,l=n.DataView,u=n.Math,c=n.RangeError,d=n.Infinity,_=a,p=u.abs,m=u.pow,v=u.floor,g=u.log,x=u.LN2,A=h?"_b":"buffer",T=h?"_l":"byteLength",w=h?"_o":"byteOffset";function E(e,t,r){var n,i,o,s=new Array(r),a=8*r-t-1,l=(1<<a)-1,u=l>>1,c=23===t?m(2,-24)-m(2,-77):0,f=0,h=e<0||0===e&&1/e<0?1:0;for((e=p(e))!=e||e===d?(i=e!=e?1:0,n=l):(n=v(g(e)/x),e*(o=m(2,-n))<1&&(n--,o*=2),(e+=n+u>=1?c/o:c*m(2,1-u))*o>=2&&(n++,o/=2),n+u>=l?(i=0,n=l):n+u>=1?(i=(e*o-1)*m(2,t),n+=u):(i=e*m(2,u-1)*m(2,t),n=0));t>=8;s[f++]=255&i,i/=256,t-=8);for(n=n<<t|i,a+=t;a>0;s[f++]=255&n,n/=256,a-=8);return s[--f]|=128*h,s}function R(e,t,r){var n,i=8*r-t-1,o=(1<<i)-1,s=o>>1,a=i-7,l=r-1,u=e[l--],c=127&u;for(u>>=7;a>0;c=256*c+e[l],l--,a-=8);for(n=c&(1<<-a)-1,c>>=-a,a+=t;a>0;n=256*n+e[l],l--,a-=8);if(0===c)c=1-s;else{if(c===o)return n?NaN:u?-d:d;n+=m(2,t),c-=s;}return (u?-1:1)*n*m(2,c-t)}function M(e){return e[3]<<24|e[2]<<16|e[1]<<8|e[0]}function S(e){return [255&e]}function z(e){return [255&e,e>>8&255]}function N(e){return [255&e,e>>8&255,e>>16&255,e>>24&255]}function P(e){return E(e,52,8)}function k(e){return E(e,23,4)}function O(e,t,r){i(e[o],t,{get:function(){return this[r]}});}function L(e,t,r,n){var i=Fn(+r);if(i+t>e[T])throw c(s);var o=e[A]._b,a=i+e[w],l=o.slice(a,a+t);return n?l:l.reverse()}function I(e,t,r,n,i,o){var a=Fn(+r);if(a+t>e[T])throw c(s);for(var l=e[A]._b,u=a+e[w],f=n(+i),h=0;h<t;h++)l[u+h]=f[o?h:t-h-1];}if(In.ABV){if(!f(function(){a(1);})||!f(function(){new a(-1);})||f(function(){return new a,new a(1.5),new a(NaN),"ArrayBuffer"!=a.name})){for(var F,U=(a=function(e){return At(this,a),new _(Fn(e))})[o]=_[o],D=r(_),G=0;D.length>G;)(F=D[G++])in a||b(a,F,_[F]);U.constructor=a;}var C=new l(new a(2)),V=l[o].setInt8;C.setInt8(0,2147483648),C.setInt8(1,2147483649),!C.getInt8(0)&&C.getInt8(1)||Kt(l[o],{setInt8:function(e,t){V.call(this,e,t<<24>>24);},setUint8:function(e,t){V.call(this,e,t<<24>>24);}},!0);}else a=function(e){At(this,a,"ArrayBuffer");var t=Fn(e);this._b=Un.call(new Array(t),0),this[T]=t;},l=function(e,t,r){At(this,l,"DataView"),At(e,a,"DataView");var n=e[T],i=j(t);if(i<0||i>n)throw c("Wrong offset!");if(i+(r=void 0===r?n-i:B(r))>n)throw c("Wrong length!");this[A]=e,this[w]=i,this[T]=r;},h&&(O(a,"byteLength","_l"),O(l,"buffer","_b"),O(l,"byteLength","_l"),O(l,"byteOffset","_o")),Kt(l[o],{getInt8:function(e){return L(this,1,e)[0]<<24>>24},getUint8:function(e){return L(this,1,e)[0]},getInt16:function(e){var t=L(this,2,e,arguments[1]);return (t[1]<<8|t[0])<<16>>16},getUint16:function(e){var t=L(this,2,e,arguments[1]);return t[1]<<8|t[0]},getInt32:function(e){return M(L(this,4,e,arguments[1]))},getUint32:function(e){return M(L(this,4,e,arguments[1]))>>>0},getFloat32:function(e){return R(L(this,4,e,arguments[1]),23,4)},getFloat64:function(e){return R(L(this,8,e,arguments[1]),52,8)},setInt8:function(e,t){I(this,1,e,S,t);},setUint8:function(e,t){I(this,1,e,S,t);},setInt16:function(e,t){I(this,2,e,z,t,arguments[2]);},setUint16:function(e,t){I(this,2,e,z,t,arguments[2]);},setInt32:function(e,t){I(this,4,e,N,t,arguments[2]);},setUint32:function(e,t){I(this,4,e,N,t,arguments[2]);},setFloat32:function(e,t){I(this,4,e,k,t,arguments[2]);},setFloat64:function(e,t){I(this,8,e,P,t,arguments[2]);}});ce(a,"ArrayBuffer"),ce(l,"DataView"),b(l[o],In.VIEW,!0),t.ArrayBuffer=a,t.DataView=l;}),Gn=l("species"),Cn=function(e,t){return new(function(e){var t;return dt(e)&&("function"!=typeof(t=e.constructor)||t!==Array&&!dt(t.prototype)||(t=void 0),u(t)&&null===(t=t[Gn])&&(t=void 0)),void 0===t?Array:t}(e))(t)},jn=function(e,t){var r=1==e,n=2==e,i=3==e,o=4==e,s=6==e,a=5==e||s,l=t||Cn;return function(t,u,c){for(var f,h,d=de(t),_=z(d),p=F(u,c,3),m=B(_.length),v=0,g=r?l(t,m):n?l(t,0):void 0;m>v;v++)if((a||v in _)&&(h=p(f=_[v],v,d),e))if(r)g[v]=h;else if(h)switch(e){case 3:return !0;case 5:return f;case 6:return v;case 2:g.push(f);}else if(o)return !1;return s?-1:i||o?o:g}},Vn=[].copyWithin||function(e,t){var r=de(this),n=B(r.length),i=X(e,n),o=X(t,n),s=arguments.length>2?arguments[2]:void 0,a=Math.min((void 0===s?n:X(s,n))-o,n-i),l=1;for(o<i&&i<o+a&&(l=-1,o+=a-1,i+=a-1);a-- >0;)o in r?r[i]=r[o]:delete r[i],i+=l,o+=l;return r},Bn=t(function(e){if(h){var t=n,r=f,i=D,o=In,s=Dn,c=F,d=At,_=x,p=b,m=Kt,g=j,A=B,T=Fn,w=X,E=v,M=O,S=Be,z=u,N=de,P=Rt,k=ae,L=me,I=pt.f,U=St,G=a,C=l,V=jn,q=W,H=Pt,Z=be,Y=R,$=lr,J=er,K=Un,Q=Vn,ee=y,te=vt,re=ee.f,ne=te.f,ie=t.RangeError,oe=t.TypeError,se=t.Uint8Array,le=Array.prototype,ue=s.ArrayBuffer,ce=s.DataView,fe=V(0),he=V(2),_e=V(3),pe=V(4),ve=V(5),ge=V(6),ye=q(!0),xe=q(!1),Ae=Z.values,Te=Z.keys,we=Z.entries,Ee=le.lastIndexOf,Re=le.reduce,Me=le.reduceRight,Se=le.join,ze=le.sort,Ne=le.slice,Pe=le.toString,ke=le.toLocaleString,Oe=C("iterator"),Le=C("toStringTag"),Ie=G("typed_constructor"),Fe=G("def_constructor"),Ue=o.CONSTR,De=o.TYPED,Ge=o.VIEW,Ce=V(1,function(e,t){return Xe(H(e,e[Fe]),t)}),je=r(function(){return 1===new se(new Uint16Array([1]).buffer)[0]}),Ve=!!se&&!!se.prototype.set&&r(function(){new se(1).set({});}),qe=function(e,t){var r=g(e);if(r<0||r%t)throw ie("Wrong offset!");return r},He=function(e){if(z(e)&&De in e)return e;throw oe(e+" is not a typed array!")},Xe=function(e,t){if(!(z(e)&&Ie in e))throw oe("It is not a typed array constructor!");return new e(t)},We=function(e,t){return Ze(H(e,e[Fe]),t)},Ze=function(e,t){for(var r=0,n=t.length,i=Xe(e,n);n>r;)i[r]=t[r++];return i},Ye=function(e,t,r){re(e,t,{get:function(){return this._d[r]}});},$e=function(e){var t,r,n,i,o,s,a=N(e),l=arguments.length,u=l>1?arguments[1]:void 0,f=void 0!==u,h=U(a);if(null!=h&&!P(h)){for(s=h.call(a),n=[],t=0;!(o=s.next()).done;t++)n.push(o.value);a=n;}for(f&&l>2&&(u=c(u,arguments[2],2)),t=0,r=A(a.length),i=Xe(this,r);r>t;t++)i[t]=f?u(a[t],t):a[t];return i},Je=function(){for(var e=0,t=arguments.length,r=Xe(this,t);t>e;)r[e]=arguments[e++];return r},Ke=!!se&&r(function(){ke.call(new se(1));}),Qe=function(){return ke.apply(Ke?Ne.call(He(this)):He(this),arguments)},et={copyWithin:function(e,t){return Q.call(He(this),e,t,arguments.length>2?arguments[2]:void 0)},every:function(e){return pe(He(this),e,arguments.length>1?arguments[1]:void 0)},fill:function(e){return K.apply(He(this),arguments)},filter:function(e){return We(this,he(He(this),e,arguments.length>1?arguments[1]:void 0))},find:function(e){return ve(He(this),e,arguments.length>1?arguments[1]:void 0)},findIndex:function(e){return ge(He(this),e,arguments.length>1?arguments[1]:void 0)},forEach:function(e){fe(He(this),e,arguments.length>1?arguments[1]:void 0);},indexOf:function(e){return xe(He(this),e,arguments.length>1?arguments[1]:void 0)},includes:function(e){return ye(He(this),e,arguments.length>1?arguments[1]:void 0)},join:function(e){return Se.apply(He(this),arguments)},lastIndexOf:function(e){return Ee.apply(He(this),arguments)},map:function(e){return Ce(He(this),e,arguments.length>1?arguments[1]:void 0)},reduce:function(e){return Re.apply(He(this),arguments)},reduceRight:function(e){return Me.apply(He(this),arguments)},reverse:function(){for(var e,t=He(this).length,r=Math.floor(t/2),n=0;n<r;)e=this[n],this[n++]=this[--t],this[t]=e;return this},some:function(e){return _e(He(this),e,arguments.length>1?arguments[1]:void 0)},sort:function(e){return ze.call(He(this),e)},subarray:function(e,t){var r=He(this),n=r.length,i=w(e,n);return new(H(r,r[Fe]))(r.buffer,r.byteOffset+i*r.BYTES_PER_ELEMENT,A((void 0===t?n:w(t,n))-i))}},tt=function(e,t){return We(this,Ne.call(He(this),e,t))},rt=function(e){He(this);var t=qe(arguments[1],1),r=this.length,n=N(e),i=A(n.length),o=0;if(i+t>r)throw ie("Wrong length!");for(;o<i;)this[t+o]=n[o++];},nt={entries:function(){return we.call(He(this))},keys:function(){return Te.call(He(this))},values:function(){return Ae.call(He(this))}},it=function(e,t){return z(e)&&e[De]&&"symbol"!=typeof t&&t in e&&String(+t)==String(t)},ot=function(e,t){return it(e,t=E(t,!0))?_(2,e[t]):ne(e,t)},st=function(e,t,r){return !(it(e,t=E(t,!0))&&z(r)&&M(r,"value"))||M(r,"get")||M(r,"set")||r.configurable||M(r,"writable")&&!r.writable||M(r,"enumerable")&&!r.enumerable?re(e,t,r):(e[t]=r.value,e)};Ue||(te.f=ot,ee.f=st),i(i.S+i.F*!Ue,"Object",{getOwnPropertyDescriptor:ot,defineProperty:st}),r(function(){Pe.call({});})&&(Pe=ke=function(){return Se.call(this)});var at=m({},et);m(at,nt),p(at,Oe,nt.values),m(at,{slice:tt,set:rt,constructor:function(){},toString:Pe,toLocaleString:Qe}),Ye(at,"buffer","b"),Ye(at,"byteOffset","o"),Ye(at,"byteLength","l"),Ye(at,"length","e"),re(at,Le,{get:function(){return this[De]}}),e.exports=function(e,n,s,a){var l=e+((a=!!a)?"Clamped":"")+"Array",u="get"+e,c="set"+e,f=t[l],h=f||{},_=f&&L(f),m=!f||!o.ABV,v={},g=f&&f.prototype,y=function(e,t){re(e,t,{get:function(){return function(e,t){var r=e._d;return r.v[u](t*n+r.o,je)}(this,t)},set:function(e){return function(e,t,r){var i=e._d;a&&(r=(r=Math.round(r))<0?0:r>255?255:255&r),i.v[c](t*n+i.o,r,je);}(this,t,e)},enumerable:!0});};m?(f=s(function(e,t,r,i){d(e,f,l,"_d");var o,s,a,u,c=0,h=0;if(z(t)){if(!(t instanceof ue||"ArrayBuffer"==(u=S(t))||"SharedArrayBuffer"==u))return De in t?Ze(f,t):$e.call(f,t);o=t,h=qe(r,n);var _=t.byteLength;if(void 0===i){if(_%n)throw ie("Wrong length!");if((s=_-h)<0)throw ie("Wrong length!")}else if((s=A(i)*n)+h>_)throw ie("Wrong length!");a=s/n;}else a=T(t),o=new ue(s=a*n);for(p(e,"_d",{b:o,o:h,l:s,e:a,v:new ce(o)});c<a;)y(e,c++);}),g=f.prototype=k(at),p(g,"constructor",f)):r(function(){f(1);})&&r(function(){new f(-1);})&&$(function(e){new f,new f(null),new f(1.5),new f(e);},!0)||(f=s(function(e,t,r,i){var o;return d(e,f,l),z(t)?t instanceof ue||"ArrayBuffer"==(o=S(t))||"SharedArrayBuffer"==o?void 0!==i?new h(t,qe(r,n),i):void 0!==r?new h(t,qe(r,n)):new h(t):De in t?Ze(f,t):$e.call(f,t):new h(T(t))}),fe(_!==Function.prototype?I(h).concat(I(_)):I(h),function(e){e in f||p(f,e,h[e]);}),f.prototype=g,g.constructor=f);var x=g[Oe],b=!!x&&("values"==x.name||null==x.name),w=nt.values;p(f,Ie,!0),p(g,De,l),p(g,Ge,!0),p(g,Fe,f),(a?new f(1)[Le]==l:Le in g)||re(g,Le,{get:function(){return l}}),v[l]=f,i(i.G+i.W+i.F*(f!=h),v),i(i.S,l,{BYTES_PER_ELEMENT:n}),i(i.S+i.F*r(function(){h.of.call(f,1);}),l,{from:$e,of:Je}),"BYTES_PER_ELEMENT"in g||p(g,"BYTES_PER_ELEMENT",n),i(i.P,l,et),J(l),i(i.P+i.F*Ve,l,{set:rt}),i(i.P+i.F*!b,l,nt),g.toString!=Pe&&(g.toString=Pe),i(i.P+i.F*r(function(){new f(1).slice();}),l,{slice:tt}),i(i.P+i.F*(r(function(){return [1,2].toLocaleString()!=new f([1,2]).toLocaleString()})||!r(function(){g.toLocaleString.call([1,2]);})),l,{toLocaleString:Qe}),Y[l]=b?x:w,b||p(g,Oe,w);};}else e.exports=function(){};});Bn("Uint8",1,function(e){return function(t,r,n){return e(this,t,r,n)}});var qn=function(){function e(t,r,n){void 0===n&&(n={}),n=e.sliceOptions(n),this.gl=t,this.texture=t.createTexture(),this.texture&&(this.valid=!0),this.bind(),this.name=r,this.retain_count=0,this.config_type=null,this.loading=null,this.loaded=!1,this.filtering=n.filtering,this.density=n.density||1,this.sprites=n.sprites,this.texcoords={},this.sizes={},this.css_sizes={},this.aspects={},this.setData(1,1,new Uint8Array([0,0,0,0]),{filtering:"nearest"}),this.loaded=!1,e.textures[this.name]&&(this.retain_count=e.textures[this.name].retain_count,e.textures[this.name].retain_count=0,e.textures[this.name].destroy()),e.textures[this.name]=this,e.texture_configs[this.name]=JSON.stringify(Object.assign({name:r},n)),this.load(n),Qr("trace","creating Texture "+this.name);}var t=e.prototype;return t.destroy=function(t){var r=(void 0===t?{}:t).force;this.retain_count>0&&!r?Qr("error","Texture '"+this.name+"': destroying texture with retain count of '"+this.retain_count+"'"):this.valid&&(this.gl.deleteTexture(this.texture),this.texture=null,e.textures[this.name]===this&&(delete e.textures[this.name],delete e.texture_configs[this.name]),this.valid=!1,Qr("trace","destroying Texture "+this.name));},t.retain=function(){this.retain_count++;},t.release=function(){this.retain_count<=0&&Qr("error","Texture '"+this.name+"': releasing texture with retain count of '"+this.retain_count+"'"),this.retain_count--,this.retain_count<=0&&this.destroy();},t.bind=function(t){void 0===t&&(t=0),this.valid&&(e.activeUnit!==t&&(this.gl.activeTexture(this.gl.TEXTURE0+t),e.activeUnit=t,e.boundTexture=null),e.boundTexture!==this.texture&&(this.gl.bindTexture(this.gl.TEXTURE_2D,this.texture),e.boundTexture=this.texture));},t.load=function(e){var t=this;return e?(this.loading=null,"string"==typeof e.url?(this.config_type="url",this.setUrl(e.url,e)):e.element?(this.config_type="element",this.setElement(e.element,e)):e.data&&e.width&&e.height&&(this.config_type="data",this.setData(e.width,e.height,e.data,e)),this.loading=this.loading&&this.loading.then(function(){return t.calculateSprites(),t})||Promise.resolve(this),this.loading):this.loading||Promise.resolve(this)},t.setUrl=function(t,r){var n=this;if(void 0===r&&(r={}),this.valid)return this.url=t,this.loading=new Promise(function(t){var i=new Image;i.onload=function(){try{if("data:"===n.url.slice(0,5)){var o=document.createElement("canvas"),s=o.getContext("2d");o.width=i.width,o.height=i.height,s.drawImage(i,0,0),n.setElement(o,r);}else n.setElement(i,r);}catch(t){n.loaded=!1,Qr("warn","Texture '"+n.name+"': failed to load url: '"+n.url+"'",t,r),e.trigger("warning",{message:"Failed to load texture from "+n.url,error:t,texture:r});}n.loaded=!0,t(n);},i.onerror=function(i){n.loaded=!1,Qr("warn","Texture '"+n.name+"': failed to load url: '"+n.url+"'",i,r),e.trigger("warning",{message:"Failed to load texture from "+n.url,error:i,texture:r}),t(n);},nn.isSafari()&&"data:"===n.url.slice(0,5)||(i.crossOrigin="anonymous"),i.src=n.url;}),this.loading},t.setData=function(e,t,r,n){return void 0===n&&(n={}),this.width=e,this.height=t,Array.isArray(r)&&(r=new Uint8Array(r)),this.update(r,n),this.setFiltering(n),this.loaded=!0,this.loading=Promise.resolve(this),this.loading},t.setElement=function(t,r){var n=t;if("string"==typeof t&&(t=document.querySelector(t)),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof HTMLVideoElement)this.update(t,r),this.setFiltering(r);else{this.loaded=!1;var i="the 'element' parameter (`element: "+JSON.stringify(n)+"`) must be a CSS ";i+="selector string, or a <canvas>, <image> or <video> object",Qr("warn","Texture '"+this.name+"': "+i,r),e.trigger("warning",{message:"Failed to load texture because "+i,texture:r});}return this.loaded=!0,this.loading=Promise.resolve(this),this.loading},t.update=function(t,r){void 0===r&&(r={}),this.valid&&(this.bind(),t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof HTMLImageElement&&t.complete?(this.width=t.width,this.height=t.height,this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,!1!==r.UNPACK_FLIP_Y_WEBGL),this.gl.pixelStorei(this.gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,r.UNPACK_PREMULTIPLY_ALPHA_WEBGL||!1),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,t)):(this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,null),this.gl.pixelStorei(this.gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,null),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.width,this.height,0,this.gl.RGBA,this.gl.UNSIGNED_BYTE,t)),e.trigger("update",this));},t.setFiltering=function(t){if(void 0===t&&(t={}),this.valid){t.filtering=t.filtering||"linear";var r=this.gl;this.bind(),nn.isPowerOf2(this.width)&&nn.isPowerOf2(this.height)?(this.power_of_2=!0,r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,t.TEXTURE_WRAP_S||t.repeat&&r.REPEAT||r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,t.TEXTURE_WRAP_T||t.repeat&&r.REPEAT||r.CLAMP_TO_EDGE),"mipmap"===t.filtering?(this.filtering="mipmap",r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.LINEAR_MIPMAP_LINEAR),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.LINEAR),r.generateMipmap(r.TEXTURE_2D)):"linear"===t.filtering?(this.filtering="linear",r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.LINEAR),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.LINEAR)):"nearest"===t.filtering&&(this.filtering="nearest",r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.NEAREST),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.NEAREST))):(this.power_of_2=!1,r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,r.CLAMP_TO_EDGE),"nearest"===t.filtering?(this.filtering="nearest",r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.NEAREST),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.NEAREST)):(this.filtering="linear",r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.LINEAR),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.LINEAR))),e.trigger("update",this);}},t.calculateSprites=function(){if(this.sprites)for(var t in this.sprites){var r=this.sprites[t];this.texcoords[t]=e.getTexcoordsForSprite([r[0],r[1]],[r[2],r[3]],[this.width,this.height]),this.sizes[t]=[r[2],r[3]],this.css_sizes[t]=[r[2]/this.density,r[3]/this.density],this.aspects[t]=r[2]/r[3];}},t.byteSize=function(){return Math.round(this.width*this.height*4*("mipmap"==this.filtering?1.33:1))},e}();qn.create=function(e,t,r){return new qn(e,t,r)},qn.retain=function(e){qn.textures[e]&&qn.textures[e].retain();},qn.release=function(e){qn.textures[e]&&qn.textures[e].release();},qn.destroy=function(e){Object.keys(qn.textures).forEach(function(t){var r=qn.textures[t];r.gl===e&&r.destroy({force:!0});});},qn.getSpriteInfo=function(e,t){var r=qn.textures[e];return r&&{size:r.sizes[t],css_size:r.css_sizes[t],aspect:r.aspects[t],texcoords:r.texcoords[t]}},qn.getTexcoordsForSprite=function(e,t,r){var n=r[1]-e[1]-t[1];return [e[0]/r[0],n/r[1],(t[0]+e[0])/r[0],(t[1]+n)/r[1]]},qn.createFromObject=function(e,t){var r=[];if(t)for(var n in t){var i=t[n];if(!i.skip_create&&qn.changed(n,i)){var o=qn.create(e,n,i);r.push(o.loading);}}return Promise.all(r)},qn.default="__default",qn.createDefault=function(e){return qn.create(e,qn.default)},qn.sliceOptions=function(e){return {filtering:e.filtering,sprites:e.sprites,url:e.url,element:e.element,data:e.data,width:e.width,height:e.height,density:e.density,repeat:e.repeat,TEXTURE_WRAP_S:e.TEXTURE_WRAP_S,TEXTURE_WRAP_T:e.TEXTURE_WRAP_T,UNPACK_FLIP_Y_WEBGL:e.UNPACK_FLIP_Y_WEBGL,UNPACK_PREMULTIPLY_ALPHA_WEBGL:e.UNPACK_PREMULTIPLY_ALPHA_WEBGL}},qn.changed=function(e,t){var r=qn.textures[e];if(r){if("element"===r.config_type||null!=t.element)return !0;if(t=qn.sliceOptions(t),qn.texture_configs[e]===JSON.stringify(Object.assign({name:e},t)))return !1}return !0},qn.getInfo=function(e){if(e||(e=Object.keys(qn.textures)),Array.isArray(e))return Promise.all(e.map(function(e){return qn.getInfo(e)}));var t=qn.textures[e];return t?(t.loading||Promise.resolve(t)).then(function(){return {name:t.name,width:t.width,height:t.height,density:t.density,css_size:[t.width/t.density,t.height/t.density],aspect:t.width/t.height,sprites:t.sprites,texcoords:t.texcoords,sizes:t.sizes,css_sizes:t.css_sizes,aspects:t.aspects,filtering:t.filtering,power_of_2:t.power_of_2,valid:t.valid}}):Promise.resolve(null)},qn.syncTexturesToWorker=function(e){return Hr.postMessage("Texture.getInfo",e).then(function(e){return e&&e.filter(function(e){return e}).forEach(function(e){return qn.textures[e.name]=e}),qn.textures})},qn.getMaxTextureSize=function(e){return e.getParameter(e.MAX_TEXTURE_SIZE)},qn.textures={},qn.texture_configs={},qn.boundTexture=null,qn.activeUnit=null,Hr.addTarget("Texture",qn),Rn(qn);var Hn=Le.f,Xn=function(e){return function(t){for(var r,n=P(t),i=ee(n),o=i.length,s=0,a=[];o>s;)Hn.call(n,r=i[s++])&&a.push(e?[r,n[r]]:n[r]);return a}},Wn=Xn(!0);D(D.S,"Object",{entries:function(e){return Wn(e)}}),rt("match",1,function(e,t,r,n){return [function(r){var n=e(this),i=null==r?void 0:r[t];return void 0!==i?i.call(r,n):new RegExp(r)[t](String(n))},function(e){var t=n(r,e,this);if(t.done)return t.value;var i=c(e),o=String(this);if(!i.global)return He(i,o);var s=i.unicode;i.lastIndex=0;for(var a,l=[],u=0;null!==(a=He(i,o));){var f=String(a[0]);l[u]=f,""===f&&(i.lastIndex=Ce(o,B(i.lastIndex),s)),u++;}return 0===u?null:l}]});var Zn={parseUniforms:function(e){var t=[];for(var r in e){var n,i=r,o=e[r];if("number"==typeof o)t.push({type:"float",method:"1f",name:r,value:o,key:i,uniforms:e});else if(Array.isArray(o)){if("number"==typeof o[0])o.length>=2&&o.length<=4?t.push({type:"vec"+o.length,method:o.length+"fv",name:r,value:o,key:i,uniforms:e}):o.length>4&&t.push({type:"float[]",method:"1fv",name:r+"[0]",value:o,key:i,uniforms:e});else if("string"==typeof o[0])for(n=0;n<o.length;n++)t.push({type:"sampler2D",method:"1i",name:r+"["+n+"]",value:o[n],key:n,uniforms:o});else if(Array.isArray(o[0])&&"number"==typeof o[0][0]&&o[0].length>=2&&o[0].length<=4)for(n=0;n<o.length;n++)t.push({type:"vec"+o[0].length,method:o[0].length+"fv",name:r+"["+n+"]",value:o[n],key:n,uniforms:o});}else"boolean"==typeof o?t.push({type:"bool",method:"1i",name:r,value:o,key:i,uniforms:e}):"string"==typeof o&&t.push({type:"sampler2D",method:"1i",name:r,value:o,key:i,uniforms:e});}return t},defineVariable:function(e,t){var r,n;if("number"==typeof t)r="float";else if(Array.isArray(t))"number"==typeof t[0]?t.length>=2&&t.length<=4?r="vec"+t.length:(r="float",n=t.length):"string"==typeof t[0]?(r="sampler2D",n=t.length):Array.isArray(t[0])&&"number"==typeof t[0][0]&&t[0].length>=2&&t[0].length<=4&&(r="vec"+t[0].length,n=t.length);else if("boolean"==typeof t)r="bool";else{if("string"!=typeof t)return;r="sampler2D";}var i="";return i+=r+" "+e,n&&(i+="["+n+"]"),i+=";\n"},defineUniform:function(e,t){var r=Zn.defineVariable(e,t);if(r)return "uniform "+r},expandVec3:function(e,t){var r;if(void 0===t&&(t=1),Array.isArray(e)){if(2!==e.length)return e;r=[].concat(e,[t]).map(parseFloat);}else r=[e,e,e].map(parseFloat);if(r&&r.every(function(e){return "number"==typeof e&&!isNaN(e)}))return r},expandVec4:function(e,t){var r;if(void 0===t&&(t=1),Array.isArray(e)){if(3!==e.length)return e;r=[].concat(e,[t]).map(parseFloat);}else r=[e,e,e,t].map(parseFloat);if(r&&r.every(function(e){return "number"==typeof e&&!isNaN(e)}))return r}},Yn=[];function $n(e,t){var r=Yn.filter(function(t){return t[0]===e})[0];return (r=r&&r[1])||(Yn.push([e,{}]),r=Yn[Yn.length-1][1]),r[t]||(r[t]=e.getExtension(t)),r[t]}function Jn(e){var t,r,n=0;if(0===e.length)return n;for(t=0,r=e.length;t<r;t++)n=(n<<5)-n+e.charCodeAt(t),n|=0;return n}var Kn=function(e){e=String(e);var t,r=[];for(;t=e.match(/ERROR\:([^\n]+)/);){e=e.slice(t.index+1);var n=t[1].trim(),i=n.split(":"),o=i.slice(2).join(":").trim(),s=parseInt(i[0],10),n=parseInt(i[1],10);r.push({message:o,file:s,line:n});}return r};var Qn=/^\s*#pragma.*$/gm,ei=/\\\s*\n/gm,ti=function(){function e(t,r,n,i){i=i||{},this.gl=t,this.program=null,this.compiled=!1,this.compiling=!1,this.error=null,this.defines=Object.assign({},i.defines||{}),this.blocks=Object.assign({},i.blocks||{}),this.block_scopes=Object.assign({},i.block_scopes||{}),this.extensions=i.extensions||[],this.dependent_uniforms=i.uniforms,this.uniforms={},this.attribs={},this.vertex_source=r,this.fragment_source=n,this.id=e.id++,this.name=i.name;}var t=e.prototype;return t.destroy=function(){this.gl.useProgram(null),this.gl.deleteProgram(this.program),this.program=null,this.uniforms={},this.attribs={},this.compiled=!1;},t.use=function(){this.compiled&&(e.current!==this&&this.gl.useProgram(this.program),e.current=this);},t.compile=function(){var t=this;if(this.compiling)throw new Error("ShaderProgram.compile(): skipping for "+this.id+" ("+this.name+") because already compiling");this.compiling=!0,this.compiled=!1,this.error=null,this.computed_vertex_source=this.vertex_source,this.computed_fragment_source=this.fragment_source;var r,n=this.checkExtensions(),i=this.buildDefineList(),o=this.buildShaderBlockList();for(var s in o){var a=o[s];if(a&&(!Array.isArray(a)||0!==a.length)){r=new RegExp("^\\s*#pragma\\s+tangram:\\s+"+s+"\\s*$","m");var l=this.computed_vertex_source.match(r),u=this.computed_fragment_source.match(r);if(null!=l||null!=u){var c="";a.forEach(function(e){var t=e.scope+", "+e.key+", "+e.num;c+="\n// tangram-block-start: "+t+"\n",c+=e.source,c+="\n// tangram-block-end: "+t+"\n";}),null!=l&&(this.computed_vertex_source=this.computed_vertex_source.replace(r,c)),null!=u&&(this.computed_fragment_source=this.computed_fragment_source.replace(r,c)),i["TANGRAM_BLOCK_"+s.replace(/[\s-]+/g,"_").toUpperCase()]=!0;}}}this.computed_vertex_source=this.computed_vertex_source.replace(Qn,""),this.computed_fragment_source=this.computed_fragment_source.replace(Qn,""),this.ensureUniforms(this.dependent_uniforms);var f="",h=this.gl.getShaderPrecisionFormat(this.gl.FRAGMENT_SHADER,this.gl.HIGH_FLOAT);f=h&&h.precision>0?"precision highp float;\n":"precision mediump float;\n",i.TANGRAM_VERTEX_SHADER=!0,i.TANGRAM_FRAGMENT_SHADER=!1,this.computed_vertex_source=f+e.buildDefineString(i)+this.computed_vertex_source,i.TANGRAM_VERTEX_SHADER=!1,i.TANGRAM_FRAGMENT_SHADER=!0,this.computed_fragment_source=e.buildExtensionString(n)+f+e.buildDefineString(i)+this.computed_fragment_source,this.computed_vertex_source=this.computed_vertex_source.replace(ei,""),this.computed_fragment_source=this.computed_fragment_source.replace(ei,"");try{this.program=e.updateProgram(this.gl,this.program,this.computed_vertex_source,this.computed_fragment_source),this.compiled=!0,this.compiling=!1;}catch(e){throw this.program=null,this.compiled=!1,this.compiling=!1,this.error=e,this.error.vertex_shader_source=this.computed_vertex_source,this.error.fragment_shader_source=this.computed_fragment_source,"vertex"!==e.type&&"fragment"!==e.type||(this.shader_errors=e.errors,this.shader_errors.forEach(function(r){r.type=e.type,r.block=t.block(e.type,r.line),r.line=t.block(e.type,r.line);}),this.error.shader_errors=this.shader_errors),e}this.computed_vertex_source=null,this.computed_fragment_source=null,this.use(),this.refreshUniforms(),this.refreshAttributes();},t.buildDefineList=function(){var t,r={};for(t in e.defines)r[t]=e.defines[t];for(t in this.defines)r[t]=this.defines[t];return r},t.buildShaderBlockList=function(){var t,r={};for(t in e.blocks){var n;if(r[t]=[],Array.isArray(e.blocks[t]))(n=r[t]).push.apply(n,e.blocks[t].map(function(e,r){return {key:t,source:e,num:r,scope:"ShaderProgram"}}));else r[t]=[{key:t,source:e.blocks[t],num:0,scope:"ShaderProgram"}];}for(t in this.blocks)if(r[t]=r[t]||[],Array.isArray(this.blocks[t]))for(var i=this.block_scopes&&this.block_scopes[t]||[],o=null,s=0,a=0;a<this.blocks[t].length;a++)i[a]!==o&&(o=i[a],s=0),r[t].push({key:t,source:this.blocks[t][a],num:s,scope:o||this.name}),s++;else r[t].push({key:t,source:this.blocks[t],num:0,scope:this.name});return r},t.ensureUniforms=function(e){if(e){var t=Object.entries(e).map(function(e){var t=e[0],r=e[1];return Zn.defineUniform(t,r)}).filter(function(e){return e});this.computed_vertex_source=t.join("\n")+this.computed_vertex_source,this.computed_fragment_source=t.join("\n")+this.computed_fragment_source;}},t.setUniforms=function(e,t){if(void 0===t&&(t=!0),this.compiled){t&&(this.texture_unit=0);for(var r=Zn.parseUniforms(e),n=0;n<r.length;n++){var i=r[n];"sampler2D"===i.type?this.setTextureUniform(i.name,i.value):this.uniform(i.method,i.name,i.value);}}},t.saveUniforms=function(e){var t=e||this.uniforms;for(var r in t){var n=this.uniforms[r];n&&(n.saved_value=n.value);}this.saved_texture_unit=this.texture_unit||0;},t.restoreUniforms=function(e){var t=e||this.uniforms;for(var r in t){var n=this.uniforms[r];n&&n.saved_value&&(n.value=n.saved_value,this.updateUniform(n));}this.texture_unit=this.saved_texture_unit||0;},t.setTextureUniform=function(e,t){var r=qn.textures[t];null!=r?(r.bind(this.texture_unit),this.uniform("1i",e,this.texture_unit),this.texture_unit++):Qr("warn","Cannot find texture '"+t+"'");},t.uniform=function(e,t,r){if(this.compiled){this.uniforms[t]=this.uniforms[t]||{};var n=this.uniforms[t];n.name=t,void 0===n.location&&(n.location=this.gl.getUniformLocation(this.program,t)),n.method=e,n.value=r,this.updateUniform(n);}},t.updateUniform=function(e){this.compiled&&e&&null!=e.location&&(this.use(),this.commitUniform(e));},t.commitUniform=function(e){var t=e.location,r=e.value;switch(e.method){case"1i":this.gl.uniform1i(t,r);break;case"1f":this.gl.uniform1f(t,r);break;case"2f":this.gl.uniform2f(t,r[0],r[1]);break;case"3f":this.gl.uniform3f(t,r[0],r[1],r[2]);break;case"4f":this.gl.uniform4f(t,r[0],r[1],r[2],r[3]);break;case"1iv":this.gl.uniform1iv(t,r);break;case"3iv":this.gl.uniform3iv(t,r);break;case"1fv":this.gl.uniform1fv(t,r);break;case"2fv":this.gl.uniform2fv(t,r);break;case"3fv":this.gl.uniform3fv(t,r);break;case"4fv":this.gl.uniform4fv(t,r);break;case"Matrix3fv":this.gl.uniformMatrix3fv(t,!1,r);break;case"Matrix4fv":this.gl.uniformMatrix4fv(t,!1,r);}},t.refreshUniforms=function(){if(this.compiled)for(var e in this.uniforms){var t=this.uniforms[e];t.location=this.gl.getUniformLocation(this.program,e),this.updateUniform(t);}},t.refreshAttributes=function(){this.attribs={};},t.attribute=function(e){if(this.compiled){var t=this.attribs[e]=this.attribs[e]||{};return null!=t.location?t:(t.name=e,t.location=this.gl.getAttribLocation(this.program,e),t)}},t.source=function(e){return "vertex"===e?this.computed_vertex_source:"fragment"===e?this.computed_fragment_source:void 0},t.lines=function(e){var t=this.source(e);return t?t.split("\n"):[]},t.line=function(e,t){var r=this.lines(e);if(r)return r[t]},t.block=function(e,t){for(var r,n=this.lines(e),i=0;i<t&&i<n.length;i++){var o=n[i],s=o.match(/\/\/ tangram-block-start: ([A-Za-z0-9_-]+), ([A-Za-z0-9_-]+), (\d+)/);s&&s.length>1?r={scope:s[1],name:s[2],num:s[3]}:(s=o.match(/\/\/ tangram-block-end: ([A-Za-z0-9_-]+), ([A-Za-z0-9_-]+), (\d+)/))&&s.length>1&&(r=null),r&&(r.line=null==r.line?-1:r.line+1,r.source=o);}return r},t.checkExtensions=function(){var e=this,t=[];return this.extensions.forEach(function(r){var n=$n(e.gl,r),i="TANGRAM_EXTENSION_"+r;e.defines[i]=null!=n,n?t.push(r):Qr("debug","Could not enable extension '"+r+"'");}),t},e}();ti.id=0,ti.current=null,ti.defines={},ti.blocks={},ti.reset=function(){ti.programs_by_source={},ti.shaders_by_source={};},ti.reset(),ti.buildDefineString=function(e){var t="";for(var r in e)null!=e[r]&&!1!==e[r]&&("boolean"==typeof e[r]&&!0===e[r]?t+="#define "+r+"\n":"number"==typeof e[r]&&Math.floor(e[r])===e[r]?t+="#define "+r+" "+e[r].toFixed(1)+"\n":t+="#define "+r+" "+e[r]+"\n");return t},ti.buildExtensionString=function(e){var t="";return (e=e||[]).forEach(function(e){t+="#ifdef GL_"+e+"\n#extension GL_"+e+" : enable\n#endif\n";}),t},ti.addBlock=function(e){var t;ti.blocks[e]=ti.blocks[e]||[];for(var r=arguments.length,n=new Array(r>1?r-1:0),i=1;i<r;i++)n[i-1]=arguments[i];(t=ti.blocks[e]).push.apply(t,n);},ti.removeBlock=function(e){ti.blocks[e]=[];},ti.replaceBlock=function(e){ti.removeBlock(e);for(var t=arguments.length,r=new Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];ti.addBlock.apply(ti,[e].concat(r));},ti.updateProgram=function(e,t,r,n){var i=Jn(e._tangram_id+"::"+r+"::"+n);if(ti.programs_by_source[i])return Qr("trace","Reusing identical source GL program object"),ti.programs_by_source[i];var o=ti.createShader(e,r,e.VERTEX_SHADER),s=ti.createShader(e,n,e.FRAGMENT_SHADER);if(e.useProgram(null),null!=t)for(var a=e.getAttachedShaders(t),l=0;l<a.length;l++)e.detachShader(t,a[l]);else t=e.createProgram();if(null==o||null==s)return t;if(e.attachShader(t,o),e.attachShader(t,s),e.bindAttribLocation(t,0,"a_position"),e.linkProgram(t),!e.getProgramParameter(t,e.LINK_STATUS)){var u=new Error("WebGL program error:\n            VALIDATE_STATUS: "+e.getProgramParameter(t,e.VALIDATE_STATUS)+"\n            ERROR: "+e.getError()+"\n            --- Vertex Shader ---\n            "+r+"\n            --- Fragment Shader ---\n            "+n);throw Object.assign(new Error(u),{type:"program"})}return ti.programs_by_source[i]=t,t},ti.createShader=function(e,t,r){var n=Jn(e._tangram_id+"::"+t);if(ti.shaders_by_source[n])return Qr("trace","Reusing identical source GL shader object"),ti.shaders_by_source[n];var i=e.createShader(r);if(e.shaderSource(i,t),e.compileShader(i),!e.getShaderParameter(i,e.COMPILE_STATUS)){var o=r===e.VERTEX_SHADER?"vertex":"fragment",s=e.getShaderInfoLog(i),a=Kn(s);throw Object.assign(new Error(s),{type:o,errors:a})}return ti.shaders_by_source[n]=i,i};var ri={disabled:!1,bound_vao:[],init:function(e){var t;!0!==this.disabled&&(t=$n(e,"OES_vertex_array_object")),null!=t?Qr("info","Vertex Array Object extension available"):!0!==this.disabled?Qr("warn","Vertex Array Object extension NOT available"):Qr("warn","Vertex Array Object extension force disabled");},getExtension:function(e,t){if(!0!==this.disabled)return $n(e,t)},create:function(e,t,r){var n={};n.setup=t,n.teardown=r;var i=this.getExtension(e,"OES_vertex_array_object");return null!=i&&(n._vao=i.createVertexArrayOES(),i.bindVertexArrayOES(n._vao)),n.setup(),n},getCurrentBinding:function(e){var t=this.bound_vao.filter(function(t){return t[0]===e})[0];return t&&t[1]},setCurrentBinding:function(e,t){var r=this.bound_vao,n=r.filter(function(t){return t[0]===e})[0];null==n?r.push([e,t]):n[1]=t;},bind:function(e,t){var r=this.getExtension(e,"OES_vertex_array_object");if(null!=t)null!=r&&null!=t._vao?(r.bindVertexArrayOES(t._vao),this.setCurrentBinding(e,t)):t.setup();else{var n=this.getCurrentBinding(e);null!=r?r.bindVertexArrayOES(null):null!=n&&"function"==typeof n.teardown&&n.teardown(),this.setCurrentBinding(e,null);}},destroy:function(e,t){var r=this.getExtension(e,"OES_vertex_array_object");null!=r&&null!=t&&null!=t._vao&&(r.deleteVertexArrayOES(t._vao),t._vao=null);}},ni=Xn(!1);D(D.S,"Object",{values:function(e){return ni(e)}});var ii,oi=jn(6),si="findIndex",ai=!0;function li(e){for(var t=0;t<(arguments.length<=1?0:arguments.length-1);t++){var r=t+1<1||arguments.length<=t+1?void 0:arguments[t+1];if(r)for(var n in r){var i=r[n];null===i||"object"!=typeof i||Array.isArray(i)?void 0!==i&&(e[n]=i):null===e[n]||"object"!=typeof e[n]||Array.isArray(e[n])?e[n]=li({},i):e[n]=li(e[n],i);}}return e}si in[]&&Array(1)[si](function(){ai=!1;}),D(D.P+D.F*ai,"Array",{findIndex:function(e){return oi(this,e,arguments.length>1?arguments[1]:void 0)}}),w(si);var ui=ii={};ii.default_source_max_zoom=18,ii.default_view_max_zoom=20,ii.max_style_zoom=25,ii.tile_size=256,ii.half_circumference_meters=20037508.342789244,ii.circumference_meters=2*ii.half_circumference_meters,ii.min_zoom_meters_per_pixel=ii.circumference_meters/ii.tile_size;var ci=[];ii.metersPerPixel=function(e){return ci[e]=ci[e]||ii.min_zoom_meters_per_pixel/Math.pow(2,e),ci[e]};var fi=[];ii.metersPerTile=function(e){return fi[e]=fi[e]||ii.circumference_meters/Math.pow(2,e),fi[e]},ii.tile_scale=4096,ii.units_per_pixel=ii.tile_scale/ii.tile_size,ii.height_scale=16;var hi=[];ii.unitsPerMeter=function(e){return hi[e]=hi[e]||ii.tile_scale/(ii.tile_size*ii.metersPerPixel(e)),hi[e]},ii.metersForTile=function(e){return {x:e.x*ii.circumference_meters/Math.pow(2,e.z)-ii.half_circumference_meters,y:-(e.y*ii.circumference_meters/Math.pow(2,e.z)-ii.half_circumference_meters)}},ii.tileForMeters=function(e,t){var r=e[0],n=e[1];return {x:Math.floor((r+ii.half_circumference_meters)/(ii.circumference_meters/Math.pow(2,t))),y:Math.floor((-n+ii.half_circumference_meters)/(ii.circumference_meters/Math.pow(2,t))),z:t}},ii.wrapTile=function(e,t){var r=e.x,n=e.y,i=e.z;void 0===t&&(t={x:!0,y:!1});var o=(1<<i)-1;return t.x&&(r&=o),t.y&&(n&=o),{x:r,y:n,z:i}},ii.metersToLatLng=function(e){return e[0]/=ii.half_circumference_meters,e[1]/=ii.half_circumference_meters,e[1]=(2*Math.atan(Math.exp(e[1]*Math.PI))-Math.PI/2)/Math.PI,e[0]*=180,e[1]*=180,e},ii.latLngToMeters=function(e){return e[1]=Math.log(Math.tan(e[1]*Math.PI/360+Math.PI/4))/Math.PI,e[1]*=ii.half_circumference_meters,e[0]*=ii.half_circumference_meters/180,e},ii.tileSpaceToLatlng=function(e,t,r){var n=ii.unitsPerMeter(t);return ii.transformGeometry(e,function(e){e[0]=e[0]/n+r.x,e[1]=e[1]/n+r.y,ii.metersToLatLng(e);}),e},ii.copyGeometry=function(e){if(null!=e){var t={type:e.type};return "Point"===e.type?t.coordinates=[e.coordinates[0],e.coordinates[1]]:"LineString"===e.type||"MultiPoint"===e.type?t.coordinates=e.coordinates.map(function(e){return [e[0],e[1]]}):"Polygon"===e.type||"MultiLineString"===e.type?t.coordinates=e.coordinates.map(function(e){return e.map(function(e){return [e[0],e[1]]})}):"MultiPolygon"===e.type&&(t.coordinates=e.coordinates.map(function(e){return e.map(function(e){return e.map(function(e){return [e[0],e[1]]})})})),t}},ii.transformGeometry=function(e,t){null!=e&&("Point"===e.type?t(e.coordinates):"LineString"===e.type||"MultiPoint"===e.type?e.coordinates.forEach(t):"Polygon"===e.type||"MultiLineString"===e.type?e.coordinates.forEach(function(e){return e.forEach(t)}):"MultiPolygon"===e.type&&e.coordinates.forEach(function(e){e.forEach(function(e){return e.forEach(t)});}));},ii.boxIntersect=function(e,t){return !(t.sw.x>e.ne.x||t.ne.x<e.sw.x||t.sw.y>e.ne.y||t.ne.y<e.sw.y)},ii.findBoundingBox=function(e){for(var t=1/0,r=-1/0,n=1/0,i=-1/0,o=e[0].length,s=0;s<o;s++){var a=e[0][s];a[0]<t&&(t=a[0]),a[1]<n&&(n=a[1]),a[0]>r&&(r=a[0]),a[1]>i&&(i=a[1]);}return [t,n,r,i]},ii.geometryType=function(e){return "Polygon"===e||"MultiPolygon"===e?"polygon":"LineString"===e||"MultiLineString"===e?"line":"Point"===e||"MultiPoint"===e?"point":void 0},ii.centroid=function(e,t){if(void 0===t&&(t=!0),e&&0!==e.length){var r,n=0,i=0,o=0,s=e[0],a=s.length;t&&(r=s[0],s=s.map(function(e){return [e[0]-r[0],e[1]-r[1]]}));for(var l=0,u=a-1;l<a;u=l,l++){var c=s[l],f=s[u],h=c[1]*f[0]-f[1]*c[0];n+=(c[0]+f[0])*h,i+=(c[1]+f[1])*h,o+=3*h;}if(o){var d=[n/o,i/o];return t&&(d[0]+=r[0],d[1]+=r[1]),d}}},ii.multiCentroid=function(e){for(var t=0,r=null,n=0;n<e.length;n++){var i=ii.centroid(e[n]);i&&((r=r||[0,0])[0]+=i[0],r[1]+=i[1],t++);}return t>0&&(r[0]/=t,r[1]/=t),r},ii.signedPolygonRingAreaSum=function(e){for(var t=0,r=e.length,n=0;n<r-1;n++){var i=e[n],o=e[n+1];t+=i[0]*o[1]-o[0]*i[1];}return t+=e[r-1][0]*e[0][1]-e[0][0]*e[r-1][1]},ii.polygonRingArea=function(e){return Math.abs(ii.signedPolygonRingAreaSum(e))/2},ii.polygonArea=function(e){if(e)return ii.polygonRingArea(e[0])},ii.multiPolygonArea=function(e){for(var t=0,r=0;r<e.length;r++)t+=ii.polygonArea(e[r]);return t},ii.ringWinding=function(e){var t=ii.signedPolygonRingAreaSum(e);return t>0?"CW":t<0?"CCW":void 0};var di="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff",_i="["+di+"]",pi=RegExp("^"+_i+_i+"*"),mi=RegExp(_i+_i+"*$"),vi=function(e,t,r){var n={},i=f(function(){return !!di[e]()||"​"!="​"[e]()}),o=n[e]=i?t(gi):di[e];r&&(n[r]=o),D(D.P+D.F*i,"String",n);},gi=vi.trim=function(e,t){return e=String(N(e)),1&t&&(e=e.replace(pi,"")),2&t&&(e=e.replace(mi,"")),e},yi=vi,xi=pt.f,bi=vt.f,Ai=y.f,Ti=yi.trim,wi=n.Number,Ei=wi,Ri=wi.prototype,Mi="Number"==S(ae(Ri)),Si="trim"in String.prototype,zi=function(e){var t=v(e,!1);if("string"==typeof t&&t.length>2){var r,n,i,o=(t=Si?t.trim():Ti(t,3)).charCodeAt(0);if(43===o||45===o){if(88===(r=t.charCodeAt(2))||120===r)return NaN}else if(48===o){switch(t.charCodeAt(1)){case 66:case 98:n=2,i=49;break;case 79:case 111:n=8,i=55;break;default:return +t}for(var s,a=t.slice(2),l=0,u=a.length;l<u;l++)if((s=a.charCodeAt(l))<48||s>i)return NaN;return parseInt(a,n)}}return +t};if(!wi(" 0o1")||!wi("0b1")||wi("+0x1")){wi=function(e){var t=arguments.length<1?0:e,r=this;return r instanceof wi&&(Mi?f(function(){Ri.valueOf.call(r);}):"Number"!=S(r))?ln(new Ei(zi(t)),r,wi):zi(t)};for(var Ni,Pi=h?xi(Ei):"MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger".split(","),ki=0;Pi.length>ki;ki++)O(Ei,Ni=Pi[ki])&&!O(wi,Ni)&&Ai(wi,Ni,bi(Ei,Ni));wi.prototype=Ri,Ri.constructor=wi,L(n,"Number",wi);}D(D.S,"Number",{MIN_SAFE_INTEGER:-9007199254740991});var Oi=ht.onFreeze;Nr("freeze",function(e){return function(t){return e&&u(t)?e(Oi(t)):t}});var Li={functions:{},num_functions:0,num_cached:0};function Ii(e,t){if("string"==typeof e)e=Fi(e,t);else if(null!=e&&"object"==typeof e)for(var r in e)e[r]=Ii(e[r],t);return e}function Fi(e,t){var r="string"==typeof e&&e.match(/^\s*function[^(]*\(([^)]*)\)\s*?\{([\s\S]*)\}$/m);if(r&&r.length>2)try{var n=r[2],i="function"==typeof t?t(n):n,o=Jn(i);if(void 0===Li.functions[o]){var s=r[1].length>0&&r[1].split(",").map(function(e){return e.trim()}).filter(function(e){return e});s=s.length>0?s:["context"],Li.functions[o]=new Function(s.toString(),i),Li.functions[o].source=n,Li.num_functions++;}else Li.num_cached++;return Li.functions[o]}catch(t){return e}return e}var Ui=t(function(e,t){var r={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function n(e){return (e=Math.round(e))<0?0:e>255?255:e}function i(e){return e<0?0:e>1?1:e}function o(e){return "%"===e[e.length-1]?n(parseFloat(e)/100*255):n(parseInt(e))}function s(e){return "%"===e[e.length-1]?i(parseFloat(e)/100):i(parseFloat(e))}function a(e,t,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?e+(t-e)*r*6:2*r<1?t:3*r<2?e+(t-e)*(2/3-r)*6:e}try{t.parseCSSColor=function(e){var t,i=e.replace(/ /g,"").toLowerCase();if(i in r)return r[i].slice();if("#"===i[0])return 4===i.length?(t=parseInt(i.substr(1),16))>=0&&t<=4095?[(3840&t)>>4|(3840&t)>>8,240&t|(240&t)>>4,15&t|(15&t)<<4,1]:null:7===i.length&&(t=parseInt(i.substr(1),16))>=0&&t<=16777215?[(16711680&t)>>16,(65280&t)>>8,255&t,1]:null;var l=i.indexOf("("),u=i.indexOf(")");if(-1!==l&&u+1===i.length){var c=i.substr(0,l),f=i.substr(l+1,u-(l+1)).split(","),h=1;switch(c){case"rgba":if(4!==f.length)return null;h=s(f.pop());case"rgb":return 3!==f.length?null:[o(f[0]),o(f[1]),o(f[2]),h];case"hsla":if(4!==f.length)return null;h=s(f.pop());case"hsl":if(3!==f.length)return null;var d=(parseFloat(f[0])%360+360)%360/360,_=s(f[1]),p=s(f[2]),m=p<=.5?p*(_+1):p+_-p*_,v=2*p-m;return [n(255*a(v,m,d+1/3)),n(255*a(v,m,d)),n(255*a(v,m,d-1/3)),h];default:return null}}return null};}catch(e){}}),Di=(Ui.parseCSSColor,{}),Gi=function(e){return Math.max(e,0)},Ci=function(e){return isNaN(e)?0:e},ji=function(e){return Array.isArray(e)?e.map(parseFloat).map(Ci):Ci(parseFloat(e))},Vi=function(e){return Array.isArray(e)?e.map(ji).map(Gi):Gi(ji(e))};Object.assign(Di,{clampPositive:Gi,noNaN:Ci,parseNumber:ji,parsePositiveNumber:Vi}),Di.wrapFunction=function(e){return "\n        var feature = context.feature.properties;\n        var global = context.global;\n        var $zoom = context.zoom;\n        var $layer = context.layer;\n        var $source = context.source;\n        var $geometry = context.geometry;\n        var $meters_per_pixel = context.meters_per_pixel;\n        var $id = context.id;\n\n        var val = (function(){ "+e+" }());\n\n        if (typeof val === 'number' && isNaN(val)) {\n            val = null; // convert NaNs to nulls\n        }\n\n        return val;\n    "},Di.zeroPair=Object.freeze([0,0]),Di.defaults={color:[1,1,1,1],width:1,size:1,extrude:!1,height:20,min_height:0,order:0,z:0,outline:{color:[0,0,0,0],width:0},material:{ambient:1,diffuse:1}},Di.macros={"Style.color.pseudoRandomColor":function(){return [parseInt(feature.id,16)/100%1*.7,parseInt(feature.id,16)/1e4%1*.7,parseInt(feature.id,16)/1e6%1*.7,1]},"Style.color.randomColor":function(){return [.7*Math.random(),.7*Math.random(),.7*Math.random(),1]}},Di.getFeatureParseContext=function(e,t,r){return {feature:e,id:e.id,tile:t,global:r,zoom:t.style_z,geometry:ui.geometryType(e.geometry.type),meters_per_pixel:t.meters_per_pixel,meters_per_pixel_sq:t.meters_per_pixel_sq,units_per_meter_overzoom:t.units_per_meter_overzoom}};var Bi={STATIC:0,DYNAMIC:1,ZOOM:2};Di.CACHE_TYPE=Bi,Di.createPropertyCache=function(e,t,r){if(void 0===t&&(t=null),void 0===r&&(r=null),null!=e){if(e.value)return {value:e.value,zoom:e.zoom?{}:null,type:e.type};var n={value:e,type:Bi.STATIC};return Array.isArray(n.value)&&Array.isArray(n.value[0])?(n.zoom={},n.type=Bi.ZOOM):"function"==typeof n.value&&(n.type=Bi.DYNAMIC,n.dynamic_transform="function"==typeof r?r:null),"function"==typeof t&&(n.zoom?n.value=n.value.map(function(e,r){return [e[0],t(e[1],r)]}):"function"!=typeof n.value&&(n.value=t(n.value,0))),n}},Di.createColorPropertyCache=function(e){return Di.createPropertyCache(e,function(e){return "Style.color.pseudoRandomColor"===e?Fi(Di.wrapFunction(Di.macros["Style.color.pseudoRandomColor"])):"Style.color.randomColor"===e?Di.macros["Style.color.randomColor"]:e})};var qi=function(e){return "string"==typeof e&&"%"===e[e.length-1]},Hi=function(e){return "auto"===e},Xi=function(e){return qi(e)||Hi(e)},Wi="'size' can specify either width or height as derived from aspect ratio, but not both";function Zi(e,t){return Di.createPropertyCache(e.value,function(r,n){return Array.isArray(r)?(r=r.map(function(t,r){return e.has_ratio[n][r]?t:Vi(t)}).map(function(r,i){return e.has_pct[n][i]?t.css_size[i]*r/100:r}),e.has_ratio[n][0]?r[0]=r[1]*t.aspect:e.has_ratio[n][1]&&(r[1]=r[0]/t.aspect)):(r=Vi(r),r=e.has_pct[n]?t.css_size.map(function(e){return e*r/100}):[r,r]),r})}function Yi(e,t){try{return e(t)}catch(r){Qr("warn","Property function in layer '"+t.layers[t.layers.length-1]+"' failed with\n","error "+r.stack+"\n","function '"+e.source+"'\n",t.feature,t);}}Di.createPointSizePropertyCache=function(e,t){var r=null,n=null;if(qi(e))r=[!0];else if(Array.isArray(e)){if(Array.isArray(e[0])){if(e.some(function(e){return Array.isArray(e[1])?e[1].some(function(e){return Xi(e)}):qi(e[1])})&&(r=e.map(function(e){return Array.isArray(e[1])?e[1].map(function(e){return qi(e)}):qi(e[1])}),(n=e.map(function(e){return Array.isArray(e[1])&&e[1].map(function(e){return Hi(e)})})).some(function(e){return Array.isArray(e)&&e.every(function(e){return e})})))throw Wi}else if(e.some(Xi)&&(r=[e.map(qi)],(n=[e.map(Hi)])[0].every(function(e){return e})))throw Wi}else if(Hi(e))throw"this value only allowed as half of an array, eg [16px, auto]:";if(r||n){if(!t)throw"% or 'auto' keywords can only be used to specify point size when a texture is defined";(e={value:e}).has_pct=r,e.has_ratio=n,e.sprites={};}else e=Di.createPropertyCache(e,Vi);return e},Di.evalCachedPointSizeProperty=function(e,t,r,n){return e.has_pct||e.has_ratio?t?(e.sprites[t.sprite]||(e.sprites[t.sprite]=Zi(e,t)),Di.evalCachedProperty(e.sprites[t.sprite],n)):(e.texture=e.texture||Zi(e,r),Di.evalCachedProperty(e.texture,n)):Di.evalCachedProperty(e,n)},Di.evalCachedProperty=function(e,t){return null==e?void 0:e.dynamic?Yi(e.dynamic,t):e.static?e.static:e.zoom&&e.zoom[t.zoom]?e.zoom[t.zoom]:"function"==typeof e.value?(e.dynamic_transform?e.dynamic=function(t){return e.dynamic_transform(e.value(t))}:e.dynamic=e.value,Yi(e.dynamic,t)):Array.isArray(e.value)&&Array.isArray(e.value[0])?(e.zoom=e.zoom||{},e.zoom[t.zoom]=nn.interpolate(t.zoom,e.value),e.zoom[t.zoom]):(e.static=e.value,e.static)},Di.convertUnits=function(e,t){if(null!=e.val)return "px"===e.units?e.val*ui.metersPerPixel(t.zoom):e.val;if("string"==typeof e)"px"===e.trim().slice(-2)?(e=ji(e),e*=ui.metersPerPixel(t.zoom)):e=ji(e);else if(Array.isArray(e))return Array.isArray(e[0])?e.map(function(e){return [e[0],Di.convertUnits(e[1],t)]}):e.map(function(e){return Di.convertUnits(e,t)});return e},Di.parseUnits=function(e){var t={val:ji(e)};return 0!==t.val&&"string"==typeof e&&"px"===e.trim().slice(-2)&&(t.units="px"),t},Di.evalCachedDistanceProperty=function(e,t){return null==e?void 0:e.dynamic?Yi(e.dynamic,t):e.zoom&&e.zoom[t.zoom]?e.zoom[t.zoom]:"function"==typeof e.value?(e.dynamic=e.value,Yi(e.dynamic,t)):e.zoom?(e.zoom[t.zoom]=nn.interpolate(t.zoom,e.value,function(e){return Di.convertUnits(e,t)}),e.zoom[t.zoom]):Di.convertUnits(e.value,t)},Di.string_colors={},Di.colorForString=function(e){if(Di.string_colors[e])return Di.string_colors[e];var t=Ui.parseCSSColor(e);return t&&4===t.length?(t[0]/=255,t[1]/=255,t[2]/=255):t=Di.defaults.color,Di.string_colors[e]=t,t},Di.evalCachedColorProperty=function(e,t){if(void 0===t&&(t={}),e.dynamic){var r=Yi(e.dynamic,t);return "string"==typeof r&&(r=Di.colorForString(r)),r&&null==r[3]&&(r[3]=1),r}if(e.static)return e.static;if(e.zoom&&e.zoom[t.zoom])return e.zoom[t.zoom];if("function"==typeof e.value){e.dynamic=e.value;var n=Yi(e.dynamic,t);return "string"==typeof n&&(n=Di.colorForString(n)),n&&null==n[3]&&(n[3]=1),n}if("string"==typeof e.value)return e.static=Di.colorForString(e.value),e.static;if(e.zoom){if(!e.zoom_preprocessed){for(var i=0;i<e.value.length;i++){var o=e.value[i];o&&"string"==typeof o[1]&&(o[1]=Di.colorForString(o[1]));}e.zoom_preprocessed=!0;}return e.zoom[t.zoom]=nn.interpolate(t.zoom,e.value),e.zoom[t.zoom][3]=e.zoom[t.zoom][3]||1,e.zoom[t.zoom]}return e.static=e.value.map(function(e){return e}),e.static&&null==e.static[3]&&(e.static[3]=1),e.static},Di.parseColor=function(e,t){if(void 0===t&&(t={}),"function"==typeof e&&(e=Yi(e,t)),"string"==typeof e)e=Di.colorForString(e);else if(Array.isArray(e)&&Array.isArray(e[0])){for(var r=0;r<e.length;r++){var n=e[r];"string"==typeof n[1]&&(n[1]=Di.colorForString(n[1]));}t.zoom&&(e=nn.interpolate(t.zoom,e));}return Array.isArray(e)?null==(e=e.map(function(e){return e}))[3]&&(e[3]=1):e=[0,0,0,1],e},Di.calculateOrder=function(e,t){return "function"==typeof e?e=Yi(e,t):"string"==typeof e&&(e=t.feature.properties[e]?t.feature.properties[e]:Vi(e)),e},Di.evalProperty=function(e,t){return "function"==typeof e?Yi(e,t):e},D(D.P,"Array",{fill:Un}),w("fill");var $i,Ji=function(){function e(e,t,r){this.gl=e,this.workers=t,this._lock_fn="function"==typeof r&&r,this.init();}var t=e.prototype;return t.init=function(){this.requests={},this.feature=null,this.read_delay=0,this.read_delay_timer=null,this.pixels=null,this.fbo=this.gl.createFramebuffer(),this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,this.fbo),this.fbo_size={width:256,height:256};var e=qn.create(this.gl,"__selection_fbo",{filtering:"nearest"});e.setData(this.fbo_size.width,this.fbo_size.height,null,{filtering:"nearest"}),this.gl.framebufferTexture2D(this.gl.FRAMEBUFFER,this.gl.COLOR_ATTACHMENT0,this.gl.TEXTURE_2D,e.texture,0);var t=this.gl.createRenderbuffer();this.gl.bindRenderbuffer(this.gl.RENDERBUFFER,t),this.gl.renderbufferStorage(this.gl.RENDERBUFFER,this.gl.DEPTH_COMPONENT16,this.fbo_size.width,this.fbo_size.height),this.gl.framebufferRenderbuffer(this.gl.FRAMEBUFFER,this.gl.DEPTH_ATTACHMENT,this.gl.RENDERBUFFER,t),this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,null);},t.destroy=function(){this.gl&&this.fbo&&(this.gl.deleteFramebuffer(this.fbo),this.fbo=null,this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,null));},t.bind=function(){var t;this.gl.bindFramebuffer(this.gl.FRAMEBUFFER,this.fbo),this.gl.viewport(0,0,this.fbo_size.width,this.fbo_size.height),(t=this.gl).clearColor.apply(t,e.defaultColor);},t.getFeatureAt=function(e,t){var r=this,n=t.radius;return !e||e.x<0||e.y<0||e.x>1||e.y>1?Promise.resolve({feature:null,changed:!1}):new Promise(function(t,i){r.selection_request_id=r.selection_request_id+1||0,r.requests[r.selection_request_id]={id:r.selection_request_id,point:e,radius:n,resolve:t,reject:i};})},t.pendingRequests=function(){return Object.keys(this.requests).length?this.requests:null},t.hasPendingRequests=function(){return null!=this.pendingRequests()},t.clearPendingRequests=function(){for(var e in this.requests){var t=this.requests[e];t.sent||(t.reject({request:t}),delete this.requests[e]);}},t.read=function(){var e=this;null!=this.read_delay_timer&&clearTimeout(this.read_delay_timer),this.read_delay_timer=setTimeout(function(){if(!e.locked){var t=e.gl;for(var r in t.bindFramebuffer(t.FRAMEBUFFER,e.fbo),e.requests){var n=e.requests[r];if(!n.sent){var i=void 0,o=255,s=n.point,a=n.radius,l=void 0;if(a){var u=Math.min(e.fbo_size.width,e.fbo_size.height);l={x:Math.min(Math.ceil(2*a.x*e.fbo_size.width),u),y:Math.min(Math.ceil(2*a.y*e.fbo_size.height),u)};}else a={x:0,y:0},l={x:1,y:1};if((null==e.pixels||e.pixels.byteLength<l.x*l.y*4)&&(e.pixels=new Uint8Array(l.x*l.y*4)),e.pixels.fill instanceof Function)e.pixels.fill(0);else for(var c=0;c<e.pixels.length;c++)e.pixels[c]=0;t.readPixels(Math.round((s.x-a.x)*e.fbo_size.width),Math.round((1-s.y-a.y)*e.fbo_size.height),l.x,l.y,t.RGBA,t.UNSIGNED_BYTE,e.pixels);var f=4*(Math.round(l.y/2)*l.x+Math.round(l.x/2)),h=e.pixels[f]+(e.pixels[f+1]<<8)+(e.pixels[f+2]<<16);if(h>0)i=h+(e.pixels[f+3]<<24)>>>0,o=e.pixels[f+3];else{var d=-1>>>0;f=0;for(var _=0;_<l.y;_++)for(var p=0;p<l.x;p++,f+=4)if((h=e.pixels[f]+(e.pixels[f+1]<<8)+(e.pixels[f+2]<<16))>0){var m=(p-l.x/2)*(p-l.x/2)+(_-l.y/2)*(_-l.y/2);m<=d&&(i=h+(e.pixels[f+3]<<24)>>>0,o=e.pixels[f+3],d=m);}}255!==o?null!=e.workers[o]&&Hr.postMessage(e.workers[o],"self.getFeatureSelection",{id:n.id,key:i}).then(function(t){e.finishRead(t);}):e.finishRead({id:n.id}),n.sent=!0;}}t.bindFramebuffer(t.FRAMEBUFFER,null);}},this.read_delay);},t.finishRead=function(e){var t=this.requests[e.id];if(t){var r=e.feature,n=!1;(null!=r&&null==this.feature||null==r&&null!=this.feature||null!=r&&null!=this.feature&&JSON.stringify(r)!==JSON.stringify(this.feature))&&(n=!0),this.feature=r,t.resolve({feature:r,changed:n,request:t}),delete this.requests[e.id];}else Qr("error","FeatureSelection.finishRead(): could not find message",e);},e.makeEntry=function(e){this.map_entry++;var t=255&this.map_entry,r=this.map_entry>>8&255,n=this.map_entry>>16&255,i=this.map_prefix,o=t/255,s=r/255,a=n/255,l=i/255,u=t+(r<<8)+(n<<16)+(i<<24)>>>0;return this.map[u]={color:[o,s,a,l]},this.map_size++,this.tiles[e.key]||(this.tiles[e.key]={entries:[],tile:{key:e.key,coords:e.coords,style_z:e.style_z,source:e.source,generation:e.generation}}),this.tiles[e.key].entries.push(u),this.map[u]},e.makeColor=function(e,t,r){var n=this.makeEntry(t);return n.feature={id:e.id,properties:e.properties,source_name:r.source,source_layer:r.layer,layers:r.layers,tile:this.tiles[t.key].tile},n.color},e.reset=function(e){var t=this;Array.isArray(e)?e.forEach(function(e){return t.clearSource(e)}):(this.tiles={},this.map={},this.map_size=0,this.map_entry=0);},e.clearSource=function(e){for(var t in this.tiles)this.tiles[t].tile.source===e&&this.clearTile(t);},e.clearTile=function(e){var t=this;this.tiles[e]&&(this.tiles[e].entries.forEach(function(e){return delete t.map[e]}),this.map_size-=this.tiles[e].entries.length,delete this.tiles[e]);},e.getMapSize=function(){return this.map_size},e.setPrefix=function(e){this.map_prefix=e;},kr(e,[{key:"locked",get:function(){return this._lock_fn&&this._lock_fn()||!1}}]),e}();Ji.map={},Ji.tiles={},Ji.map_size=0,Ji.map_entry=0,Ji.map_prefix=0,Ji.defaultColor=[0,0,0,1];var Ki=$i={};$i.BYTE=5120,$i.UNSIGNED_BYTE=5121,$i.SHORT=5122,$i.UNSIGNED_SHORT=5123,$i.INT=5124,$i.UNSIGNED_INT=5125,$i.FLOAT=5126,Bn("Uint16",2,function(e){return function(t,r,n){return e(this,t,r,n)}});var Qi,eo=function(){function e(e,t,r,n,i){i=i||{},this.gl=e,this.vertex_data=t,this.element_data=r,this.vertex_layout=n,this.vertex_buffer=this.gl.createBuffer(),this.buffer_size=this.vertex_data.byteLength,this.draw_mode=i.draw_mode||this.gl.TRIANGLES,this.data_usage=i.data_usage||this.gl.STATIC_DRAW,this.vertices_per_geometry=3,this.uniforms=i.uniforms,this.textures=i.textures,this.retain=i.retain||!1,this.created_at=+new Date,this.fade_in_time=i.fade_in_time||0,this.vertex_count=this.vertex_data.byteLength/this.vertex_layout.stride,this.element_count=0,this.vaos={},this.toggle_element_array=!1,this.element_data?(this.toggle_element_array=!0,this.element_count=this.element_data.length,this.geometry_count=this.element_count/this.vertices_per_geometry,this.element_type=this.element_data.constructor===Uint16Array?this.gl.UNSIGNED_SHORT:this.gl.UNSIGNED_INT,this.element_buffer=this.gl.createBuffer(),this.buffer_size+=this.element_data.byteLength,this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,this.element_buffer),this.gl.bufferData(this.gl.ELEMENT_ARRAY_BUFFER,this.element_data,this.data_usage)):this.geometry_count=this.vertex_count/this.vertices_per_geometry,this.upload(),this.retain||(delete this.vertex_data,delete this.element_data),this.valid=!0;}var t=e.prototype;return t.render=function(e){if(void 0===e&&(e={}),!this.valid)return !1;var t=e.program||ti.current;t.use(),this.uniforms&&(t.saveUniforms(this.uniforms),t.setUniforms(this.uniforms,!1));var r=(+new Date-this.created_at)/1e3;return t.uniform("1f","u_visible_time",r),this.bind(t),this.toggle_element_array?this.gl.drawElements(this.draw_mode,this.element_count,this.element_type,0):this.gl.drawArrays(this.draw_mode,0,this.vertex_count),ri.bind(this.gl,null),this.uniforms&&t.restoreUniforms(this.uniforms),r<this.fade_in_time},t.bind=function(e){var t=this,r=this.vaos[e.id];r?ri.bind(this.gl,r):this.vaos[e.id]=ri.create(this.gl,function(){t.gl.bindBuffer(t.gl.ARRAY_BUFFER,t.vertex_buffer),t.toggle_element_array&&t.gl.bindBuffer(t.gl.ELEMENT_ARRAY_BUFFER,t.element_buffer),t.vertex_layout.enableDynamicAttributes(t.gl,e);}),this.vertex_layout.enableStaticAttributes(this.gl,e);},t.upload=function(){this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.vertex_buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.vertex_data,this.data_usage);},t.destroy=function(){if(!this.valid)return !1;for(var e in this.valid=!1,this.vaos)ri.destroy(this.gl,this.vaos[e]);return this.gl.deleteBuffer(this.vertex_buffer),this.vertex_buffer=null,this.element_buffer&&(this.gl.deleteBuffer(this.element_buffer),this.element_buffer=null),delete this.vertex_data,delete this.element_data,this.textures&&this.textures.forEach(function(e){return qn.release(e)}),!0},e}(),to=["emission","ambient","diffuse","specular"],ro=function(){function e(e){var t=this;e=e||{},to.forEach(function(r){var n=e[r];null!=n&&(n.texture?t[r]={texture:n.texture,mapping:n.mapping||"spheremap",scale:Zn.expandVec3(null!=n.scale?n.scale:1),amount:Zn.expandVec4(null!=n.amount?n.amount:1)}:"number"==typeof n||Array.isArray(n)?t[r]={amount:Zn.expandVec4(n)}:t[r]="string"==typeof n?{amount:Di.parseColor(n)}:n);}),this.specular&&(this.specular.shininess=e.shininess?parseFloat(e.shininess):.2),null!=e.normal&&(this.normal={texture:e.normal.texture,mapping:e.normal.mapping||"triplanar",scale:Zn.expandVec3(null!=e.normal.scale?e.normal.scale:1),amount:null!=e.normal.amount?e.normal.amount:1});}e.isValid=function(e){return null!=e&&(null!=e.emission||null!=e.ambient||null!=e.diffuse||null!=e.specular)};var t=e.prototype;return t.inject=function(t){var r=this;to.forEach(function(e){var n="TANGRAM_MATERIAL_"+e.toUpperCase(),i=n+"_TEXTURE";t.defines[n]=null!=r[e],r[e]&&r[e].texture&&(t.defines[i]=!0,t.defines[i+"_"+r[e].mapping.toUpperCase()]=!0,t.defines["TANGRAM_MATERIAL_TEXTURE_"+r[e].mapping.toUpperCase()]=!0,t.texcoords=t.texcoords||"uv"===r[e].mapping);}),this.normal&&this.normal.texture&&(t.defines.TANGRAM_MATERIAL_NORMAL_TEXTURE=!0,t.defines["TANGRAM_MATERIAL_NORMAL_TEXTURE_"+this.normal.mapping.toUpperCase()]=!0,t.defines["TANGRAM_MATERIAL_TEXTURE_"+this.normal.mapping.toUpperCase()]=!0,t.texcoords=t.texcoords||"uv"===this.normal.mapping),t.replaceShaderBlock(e.block,"/*\n\nDefines globals:\nmaterial\nlight_accumulator_*\n\n*/\n\n\n// MATERIALS\n//\nstruct Material {\n    #ifdef TANGRAM_MATERIAL_EMISSION\n        vec4 emission;\n        #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE\n            vec3 emissionScale;\n        #endif\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_AMBIENT\n        vec4 ambient;\n        #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE\n            vec3 ambientScale;\n        #endif\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_DIFFUSE\n        vec4 diffuse;\n        #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE\n            vec3 diffuseScale;\n        #endif\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_SPECULAR\n        vec4 specular;\n        float shininess;\n        #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE\n            vec3 specularScale;\n        #endif\n    #endif\n\n\n    #ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE\n        vec3 normalScale;\n        float normalAmount;\n    #endif\n};\n\n// Note: uniform is copied to a global instance to allow modification\nuniform Material u_material;\nMaterial material;\n\n#ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE\nuniform sampler2D u_material_emission_texture;\n#endif\n\n#ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE\nuniform sampler2D u_material_ambient_texture;\n#endif\n\n#ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE\nuniform sampler2D u_material_diffuse_texture;\n#endif\n\n#ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE\nuniform sampler2D u_material_specular_texture;\n#endif\n\n#ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE\nuniform sampler2D u_material_normal_texture;\n#endif\n\n// Global light accumulators for each property\nvec4 light_accumulator_ambient = vec4(vec3(0.0), 1.);\nvec4 light_accumulator_diffuse = vec4(vec3(0.0), 1.);\n#ifdef TANGRAM_MATERIAL_SPECULAR\n    vec4 light_accumulator_specular = vec4(vec3(0.0), 1.);\n#endif\n\n\n#ifdef TANGRAM_MATERIAL_TEXTURE_SPHEREMAP\nvec4 getSphereMap (in sampler2D _tex, in vec3 _eyeToPoint, in vec3 _normal, in vec2 _skew) {\n    // Normalized vector from camera to surface\n    vec3 eye = normalize(_eyeToPoint);\n\n    // Adjust for camera skew\n    eye.xy -= _skew;\n    eye = normalize(eye);\n\n    // Reflection of eye off of surface normal\n    vec3 r = reflect(eye, _normal);\n\n    // Map reflected vector onto the surface of a sphere\n    r.z += 1.0;\n    float m = 2. * length(r);\n\n    // Adjust xy to account for spherical shape, and center in middle of texture\n    vec2 uv = r.xy / m + .5;\n\n    // Sample the environment map\n    return texture2D(_tex, uv);\n}\n#endif\n\n\n#ifdef TANGRAM_MATERIAL_TEXTURE_TRIPLANAR\nvec3 getTriPlanarBlend (in vec3 _normal) {\n    vec3 blending = abs(_normal);\n    blending = normalize(max(blending, 0.00001));\n    float b = (blending.x + blending.y + blending.z);\n    return blending / b;\n}\n\nvec4 getTriPlanar (in sampler2D _tex, in vec3 _pos, in vec3 _normal, in vec3 _scale) {\n    vec3 blending = getTriPlanarBlend(_normal);\n    vec4 xaxis = texture2D(_tex, fract(_pos.yz * _scale.x));\n    vec4 yaxis = texture2D(_tex, fract(_pos.xz * _scale.y));\n    vec4 zaxis = texture2D(_tex, fract(_pos.xy * _scale.z));\n    return  xaxis * blending.x + yaxis * blending.y + zaxis * blending.z;\n}\n#endif\n\n\n#ifdef TANGRAM_MATERIAL_TEXTURE_PLANAR\nvec4 getPlanar (in sampler2D _tex, in vec3 _pos, in vec2 _scale) {\n    return texture2D( _tex, fract(_pos.xy * _scale.x) );\n}\n#endif\n\n\n#ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE\nvoid calculateNormal (inout vec3 _normal) {\n    // Get NORMALMAP\n    //------------------------------------------------\n    #ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE_UV\n    _normal += texture2D(u_material_normal_texture, fract(v_texcoord*material.normalScale.xy)).rgb*2.0-1.0;\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE_PLANAR\n    vec3 normalTex = getPlanar(u_material_normal_texture, v_world_position.xyz, material.normalScale.xy).rgb*2.0-1.0;\n    _normal += normalTex;\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_NORMAL_TEXTURE_TRIPLANAR\n    vec3 normalTex = getTriPlanar(u_material_normal_texture, v_world_position.xyz, _normal, material.normalScale).rgb*2.0-1.0;\n    _normal += normalTex;\n    #endif\n\n    _normal = normalize(_normal);\n}\n#endif\n\nvoid calculateMaterial (in vec3 _eyeToPoint, inout vec3 _normal) {\n    // get EMISSION TEXTUREMAP\n    //------------------------------------------------\n    #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE\n        #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE_UV\n        material.emission *= texture2D(u_material_emission_texture,v_texcoord);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE_PLANAR\n        material.emission *= getPlanar(u_material_emission_texture, v_world_position.xyz, material.emissionScale.xy);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE_TRIPLANAR\n        material.emission *= getTriPlanar(u_material_emission_texture, v_world_position.xyz, _normal, material.emissionScale);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_EMISSION_TEXTURE_SPHEREMAP\n        material.emission *= getSphereMap(u_material_emission_texture, _eyeToPoint, _normal, u_vanishing_point);\n        #endif\n    #endif\n\n    // get AMBIENT TEXTUREMAP\n    //------------------------------------------------\n    #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE\n        #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE_UV\n        material.ambient *= texture2D(u_material_ambient_texture,v_texcoord);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE_PLANAR\n        material.ambient *= getPlanar(u_material_ambient_texture, v_world_position.xyz, material.ambientScale.xy);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE_TRIPLANAR\n        material.ambient *= getTriPlanar(u_material_ambient_texture, v_world_position.xyz, _normal, material.ambientScale);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_AMBIENT_TEXTURE_SPHEREMAP\n        material.ambient *= getSphereMap(u_material_ambient_texture, _eyeToPoint, _normal, u_vanishing_point);\n        #endif\n    #endif\n\n    // get DIFFUSE TEXTUREMAP\n    //------------------------------------------------\n    #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE\n        #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE_UV\n        material.diffuse *= texture2D(u_material_diffuse_texture,v_texcoord);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE_PLANAR\n        material.diffuse *= getPlanar(u_material_diffuse_texture, v_world_position.xyz, material.diffuseScale.xy);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE_TRIPLANAR\n        material.diffuse *= getTriPlanar(u_material_diffuse_texture, v_world_position.xyz, _normal, material.diffuseScale);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_DIFFUSE_TEXTURE_SPHEREMAP\n        material.diffuse *= getSphereMap(u_material_diffuse_texture, _eyeToPoint, _normal, u_vanishing_point);\n        #endif\n    #endif\n\n    // get SPECULAR TEXTUREMAP\n    //------------------------------------------------\n    #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE\n        #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE_UV\n        material.specular *= texture2D(u_material_specular_texture,v_texcoord);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE_PLANAR\n        material.specular *= getPlanar(u_material_specular_texture, v_world_position.xyz, material.specularScale.xy);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE_TRIPLANAR\n        material.specular *= getTriPlanar(u_material_specular_texture, v_world_position.xyz, _normal, material.specularScale);\n        #endif\n\n        #ifdef TANGRAM_MATERIAL_SPECULAR_TEXTURE_SPHEREMAP\n        material.specular *= getSphereMap(u_material_specular_texture, _eyeToPoint, _normal, u_vanishing_point);\n        #endif\n    #endif\n}\n","Material"),t.addShaderBlock("setup","\nmaterial = u_material;\n","Material");},t.setupProgram=function(e){var t=this;to.forEach(function(r){t[r]&&(t[r].texture?(e.setTextureUniform("u_material_"+r+"_texture",t[r].texture),e.uniform("3fv","u_material."+r+"Scale",t[r].scale),e.uniform("4fv","u_material."+r,t[r].amount)):t[r].amount&&e.uniform("4fv","u_material."+r,t[r].amount));}),this.specular&&e.uniform("1f","u_material.shininess",this.specular.shininess),this.normal&&this.normal.texture&&(e.setTextureUniform("u_material_normal_texture",this.normal.texture),e.uniform("3fv","u_material.normalScale",this.normal.scale),e.uniform("1f","u_material.normalAmount",this.normal.amount));},e}();ro.block="material";var no=Qi={};Qi.copy=function(e){for(var t=[],r=e.length,n=0;n<r;n++)t[n]=e[n];return t},Qi.neg=function(e){for(var t=[],r=e.length,n=0;n<r;n++)t[n]=-e[n];return t},Qi.add=function(e,t){for(var r=[],n=Math.min(e.length,t.length),i=0;i<n;i++)r[i]=e[i]+t[i];return r},Qi.sub=function(e,t){for(var r=[],n=Math.min(e.length,t.length),i=0;i<n;i++)r[i]=e[i]-t[i];return r},Qi.signed_area=function(e,t,r){return (t[0]-e[0])*(r[1]-e[1])-(r[0]-e[0])*(t[1]-e[1])},Qi.mult=function(e,t){var r,n=[],i=e.length;if("number"==typeof t)for(r=0;r<i;r++)n[r]=e[r]*t;else for(i=Math.min(e.length,t.length),r=0;r<i;r++)n[r]=e[r]*t[r];return n},Qi.div=function(e,t){var r,n=[];if("number"==typeof t)for(r=0;r<e.length;r++)n[r]=e[r]/t;else{var i=Math.min(e.length,t.length);for(r=0;r<i;r++)n[r]=e[r]/t[r];}return n},Qi.perp=function(e,t){return [t[1]-e[1],e[0]-t[0]]},Qi.rot=function(e,t){var r=Math.cos(t),n=Math.sin(t);return [e[0]*r-e[1]*n,e[0]*n+e[1]*r]},Qi.angle=function(e){var t=e[0],r=e[1];return Math.atan2(r,t)},Qi.angleBetween=function(e,t){var r=Qi.dot(Qi.normalize(Qi.copy(e)),Qi.normalize(Qi.copy(t)));return r>1&&(r=1),Math.acos(r)},Qi.isEqual=function(e,t){for(var r=e.length,n=0;n<r;n++)if(e[n]!==t[n])return !1;return !0},Qi.lengthSq=function(e){return 2===e.length?e[0]*e[0]+e[1]*e[1]:e.length>=3?e[0]*e[0]+e[1]*e[1]+e[2]*e[2]:0},Qi.length=function(e){return Math.sqrt(Qi.lengthSq(e))},Qi.normalize=function(e){var t;if(2===e.length){if(1===(t=e[0]*e[0]+e[1]*e[1]))return e;0!==(t=Math.sqrt(t))?(e[0]/=t,e[1]/=t):(e[0]=0,e[1]=0);}else if(e.length>=3){if(1===(t=e[0]*e[0]+e[1]*e[1]+e[2]*e[2]))return e;0!==(t=Math.sqrt(t))?(e[0]/=t,e[1]/=t,e[2]/=t):(e[0]=0,e[1]=0,e[2]=0);}return e},Qi.cross=function(e,t){return 2===e.length?e[0]*t[1]-e[1]*t[0]:3===e.length?[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]:void 0},Qi.dot=function(e,t){for(var r=0,n=Math.min(e.length,t.length),i=0;i<n;i++)r+=e[i]*t[i];return r};var io=function(){function e(e,t){this.name=t.name,this.view=e,null==t.ambient||"number"==typeof t.ambient?this.ambient=Zn.expandVec3(t.ambient||0):this.ambient=Di.parseColor(t.ambient).slice(0,3),null==t.diffuse||"number"==typeof t.diffuse?this.diffuse=Zn.expandVec3(null!=t.diffuse?t.diffuse:1):this.diffuse=Di.parseColor(t.diffuse).slice(0,3),null==t.specular||"number"==typeof t.specular?this.specular=Zn.expandVec3(t.specular||0):this.specular=Di.parseColor(t.specular).slice(0,3);}e.create=function(t,r){if(e.types[r.type])return new e.types[r.type](t,r)},e.setMode=function(t,r){!0===t&&(t="fragment"),t=e.enabled&&(null!=t?t:"fragment"),r.defines.TANGRAM_LIGHTING_FRAGMENT="fragment"===t,r.defines.TANGRAM_LIGHTING_VERTEX="vertex"===t;},e.inject=function(t){if(ti.removeBlock(e.block),e.enabled){var r="";if(t&&Object.keys(t).length>0){var n={};for(var i in t)n[t[i].type]=!0;for(var o in n)e.types[o].inject();for(var s in t)t[s].inject(),r+="calculateLight("+s+", _eyeToPoint, _normal);\n";}var a="\n            vec4 calculateLighting(in vec3 _eyeToPoint, in vec3 _normal, in vec4 _color) {\n\n                // Do initial material calculations over normal, emission, ambient, diffuse and specular values\n                calculateMaterial(_eyeToPoint,_normal);\n\n                // Un roll the loop of individual ligths to calculate\n                "+r+"\n\n                //  Final light intensity calculation\n                vec4 color = vec4(vec3(0.), _color.a); // start with vertex color alpha\n\n                #ifdef TANGRAM_MATERIAL_EMISSION\n                    color.rgb = material.emission.rgb;\n                    color.a *= material.emission.a;\n                #endif\n\n                #ifdef TANGRAM_MATERIAL_AMBIENT\n                    color.rgb += light_accumulator_ambient.rgb * _color.rgb * material.ambient.rgb;\n                    color.a *= material.ambient.a;\n                #else\n                    #ifdef TANGRAM_MATERIAL_DIFFUSE\n                        color.rgb += light_accumulator_ambient.rgb * _color.rgb * material.diffuse.rgb;\n                    #endif\n                #endif\n\n                #ifdef TANGRAM_MATERIAL_DIFFUSE\n                    color.rgb += light_accumulator_diffuse.rgb * _color.rgb * material.diffuse.rgb;\n                    color.a *= material.diffuse.a;\n                #endif\n\n                #ifdef TANGRAM_MATERIAL_SPECULAR\n                    color.rgb += light_accumulator_specular.rgb * material.specular.rgb;\n                    color.a *= material.specular.a;\n                #endif\n\n                // Clamp final color\n                color = clamp(color, 0.0, 1.0);\n\n                return color;\n            }";ti.addBlock(e.block,a);}};var t=e.prototype;return t.inject=function(){var t="\n            uniform "+this.struct_name+" u_"+this.name+";\n            "+this.struct_name+" "+this.name+";\n            ",r="\n            "+this.name+" = u_"+this.name+";\n\n        ";ti.addBlock(e.block,t),ti.addBlock("setup",r);},t.update=function(){},t.setupProgram=function(e){e.uniform("3fv","u_"+this.name+".ambient",this.ambient),e.uniform("3fv","u_"+this.name+".diffuse",this.diffuse),e.uniform("3fv","u_"+this.name+".specular",this.specular);},e}();io.types={},io.block="lighting",io.enabled=!0;var oo=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).type="ambient",n.struct_name="AmbientLight",n}return Or(t,e),t.inject=function(){ti.addBlock(io.block,"/*\n\nExpected globals:\nlight_accumulator_*\n\n*/\n\nstruct AmbientLight {\n    vec3 ambient;\n};\n\nvoid calculateLight(in AmbientLight _light, in vec3 _eyeToPoint, in vec3 _normal) {\n    light_accumulator_ambient.rgb += _light.ambient;\n}\n");},t.prototype.setupProgram=function(e){e.uniform("3fv","u_"+this.name+".ambient",this.ambient);},t}(io);io.types.ambient=oo;var so=function(e){function t(t,r){var n;if((n=e.call(this,t,r)||this).type="directional",n.struct_name="DirectionalLight",r.direction)n._direction=r.direction;else{var i=Math.sin(60*Math.PI/180);n._direction=[Math.cos(135*Math.PI/180)*i,Math.sin(135*Math.PI/180)*i,-.5],null==r.ambient&&(n.ambient=Zn.expandVec3(.5));}return n.direction=n._direction.map(parseFloat),n}return Or(t,e),t.inject=function(){ti.addBlock(io.block,"/*\n\nExpected globals:\nmaterial\nlight_accumulator_*\n\n*/\n\nstruct DirectionalLight {\n    vec3 ambient;\n    vec3 diffuse;\n    vec3 specular;\n    vec3 direction;\n};\n\nvoid calculateLight(in DirectionalLight _light, in vec3 _eyeToPoint, in vec3 _normal) {\n\n    light_accumulator_ambient.rgb += _light.ambient;\n\n    float nDotVP = clamp(dot(_normal, -_light.direction), 0.0, 1.0);\n\n    #ifdef TANGRAM_MATERIAL_DIFFUSE\n        light_accumulator_diffuse.rgb += _light.diffuse * nDotVP;\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_SPECULAR\n        float pf = 0.0;\n        if (nDotVP > 0.0) {\n            vec3 reflectVector = reflect(_light.direction, _normal);\n            float eyeDotR = max(dot(normalize(_eyeToPoint), reflectVector), 0.0);\n            pf = pow(eyeDotR, material.shininess);\n        }\n        light_accumulator_specular.rgb += _light.specular * pf;\n    #endif\n}\n");},t.prototype.setupProgram=function(t){e.prototype.setupProgram.call(this,t),t.uniform("3fv","u_"+this.name+".direction",this.direction);},kr(t,[{key:"direction",get:function(){return this._direction},set:function(e){this._direction=no.normalize(no.copy(e));}}]),t}(io);io.types.directional=so;var ao=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).type="point",n.struct_name="PointLight",n.position=r.position||[0,0,"100px"],n.position_eye=[],n.origin=r.origin||"ground",n.attenuation=isNaN(parseFloat(r.attenuation))?0:parseFloat(r.attenuation),r.radius?Array.isArray(r.radius)&&2===r.radius.length?n.radius=r.radius:n.radius=[null,r.radius]:n.radius=null,n}Or(t,e),t.inject=function(){ti.addBlock(io.block,"/*\n\nExpected globals:\nmaterial\nlight_accumulator_*\n\n*/\n\nstruct PointLight {\n    vec3 ambient;\n    vec3 diffuse;\n    vec3 specular;\n    vec4 position;\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT\n    float attenuationExponent;\n#endif\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n    float innerRadius;\n#endif\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n    float outerRadius;\n#endif\n};\n\nvoid calculateLight(in PointLight _light, in vec3 _eyeToPoint, in vec3 _normal) {\n\n    float dist = length(_light.position.xyz - _eyeToPoint);\n\n    // Compute vector from surface to light position\n    vec3 VP = (_light.position.xyz - _eyeToPoint) / dist;\n\n    // Normalize the vector from surface to light position\n    float nDotVP = clamp(dot(VP, _normal), 0.0, 1.0);\n\n    // Attenuation defaults\n    float attenuation = 1.0;\n    #ifdef TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT\n        float Rin = 1.0;\n        float e = _light.attenuationExponent;\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n            Rin = _light.innerRadius;\n        #endif\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n            float Rdiff = _light.outerRadius-Rin;\n            float d = clamp(max(0.0,dist-Rin)/Rdiff, 0.0, 1.0);\n            attenuation = 1.0-(pow(d,e));\n        #else\n            // If no outer is provide behaves like:\n            // https://imdoingitwrong.wordpress.com/2011/01/31/light-attenuation/\n            float d = max(0.0,dist-Rin)/Rin+1.0;\n            attenuation = clamp(1.0/(pow(d,e)), 0.0, 1.0);\n        #endif\n    #else\n        float Rin = 0.0;\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n            Rin = _light.innerRadius;\n            #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n                float Rdiff = _light.outerRadius-Rin;\n                float d = clamp(max(0.0,dist-Rin)/Rdiff, 0.0, 1.0);\n                attenuation = 1.0-d*d;\n            #else\n                // If no outer is provide behaves like:\n                // https://imdoingitwrong.wordpress.com/2011/01/31/light-attenuation/\n                float d = max(0.0,dist-Rin)/Rin+1.0;\n                attenuation = clamp(1.0/d, 0.0, 1.0);\n            #endif\n        #else\n            #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n                float d = clamp(dist/_light.outerRadius, 0.0, 1.0);\n                attenuation = 1.0-d*d;\n            #else\n                attenuation = 1.0;\n            #endif\n        #endif\n    #endif\n\n    // Computer accumulators\n    light_accumulator_ambient.rgb += _light.ambient * attenuation;\n\n    #ifdef TANGRAM_MATERIAL_DIFFUSE\n        light_accumulator_diffuse.rgb += _light.diffuse * nDotVP * attenuation;\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_SPECULAR\n        float pf = 0.0; // power factor for shiny speculars\n        if (nDotVP > 0.0) {\n            vec3 reflectVector = reflect(-VP, _normal);\n            float eyeDotR = max(0.0, dot(-normalize(_eyeToPoint), reflectVector));\n            pf = pow(eyeDotR, material.shininess);\n        }\n\n        light_accumulator_specular.rgb += _light.specular * pf * attenuation;\n    #endif\n}\n");};var r=t.prototype;return r.inject=function(){e.prototype.inject.call(this),ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT=0!==this.attenuation,ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS=null!=this.radius&&null!=this.radius[0],ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS=null!=this.radius;},r.update=function(){this.updateEyePosition();},r.updateEyePosition=function(){if("world"===this.origin){var e=ui.latLngToMeters([].concat(this.position));this.position_eye[0]=e[0]-this.view.camera.position_meters[0],this.position_eye[1]=e[1]-this.view.camera.position_meters[1],this.position_eye[2]=Di.convertUnits(this.position[2],{zoom:this.view.zoom,meters_per_pixel:ui.metersPerPixel(this.view.zoom)}),this.position_eye[2]=this.position_eye[2]-this.view.camera.position_meters[2];}else"ground"!==this.origin&&"camera"!==this.origin||(this.position_eye=Di.convertUnits(this.position,{zoom:this.view.zoom,meters_per_pixel:ui.metersPerPixel(this.view.zoom)}),"ground"===this.origin&&(this.position_eye[2]=this.position_eye[2]-this.view.camera.position_meters[2]));this.position_eye[3]=1;},r.setupProgram=function(t){e.prototype.setupProgram.call(this,t),t.uniform("4fv","u_"+this.name+".position",this.position_eye),ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT&&t.uniform("1f","u_"+this.name+".attenuationExponent",this.attenuation),ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS&&t.uniform("1f","u_"+this.name+".innerRadius",Di.convertUnits(this.radius[0],{zoom:this.view.zoom,meters_per_pixel:ui.metersPerPixel(this.view.zoom)})),ti.defines.TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS&&t.uniform("1f","u_"+this.name+".outerRadius",Di.convertUnits(this.radius[1],{zoom:this.view.zoom,meters_per_pixel:ui.metersPerPixel(this.view.zoom)}));},t}(io);io.types.point=ao;var lo=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).type="spotlight",n.struct_name="SpotLight",n.direction=n._direction=(r.direction||[0,0,-1]).map(parseFloat),n.exponent=r.exponent?parseFloat(r.exponent):.2,n.angle=r.angle?parseFloat(r.angle):20,n}return Or(t,e),t.inject=function(){ti.addBlock(io.block,"/*\n\nExpected globals:\nmaterial\nlight_accumulator_*\n\n*/\n\nstruct SpotLight {\n    vec3 ambient;\n    vec3 diffuse;\n    vec3 specular;\n    vec4 position;\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT\n    float attenuationExponent;\n#endif\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n    float innerRadius;\n#endif\n\n#ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n    float outerRadius;\n#endif\n\n    vec3 direction;\n    float spotCosCutoff;\n    float spotExponent;\n};\n\nvoid calculateLight(in SpotLight _light, in vec3 _eyeToPoint, in vec3 _normal) {\n\n    float dist = length(_light.position.xyz - _eyeToPoint);\n\n    // Compute vector from surface to light position\n    vec3 VP = (_light.position.xyz - _eyeToPoint) / dist;\n\n    // normal . light direction\n    float nDotVP = clamp(dot(_normal, VP), 0.0, 1.0);\n\n    // Attenuation defaults\n    float attenuation = 1.0;\n    #ifdef TANGRAM_POINTLIGHT_ATTENUATION_EXPONENT\n        float Rin = 1.0;\n        float e = _light.attenuationExponent;\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n            Rin = _light.innerRadius;\n        #endif\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n            float Rdiff = _light.outerRadius-Rin;\n            float d = clamp(max(0.0,dist-Rin)/Rdiff, 0.0, 1.0);\n            attenuation = 1.0-(pow(d,e));\n        #else\n            // If no outer is provide behaves like:\n            // https://imdoingitwrong.wordpress.com/2011/01/31/light-attenuation/\n            float d = max(0.0,dist-Rin)/Rin+1.0;\n            attenuation = clamp(1.0/(pow(d,e)), 0.0, 1.0);\n        #endif\n    #else\n        float Rin = 0.0;\n\n        #ifdef TANGRAM_POINTLIGHT_ATTENUATION_INNER_RADIUS\n            Rin = _light.innerRadius;\n            #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n                float Rdiff = _light.outerRadius-Rin;\n                float d = clamp(max(0.0,dist-Rin)/Rdiff, 0.0, 1.0);\n                attenuation = 1.0-d*d;\n            #else\n                // If no outer is provide behaves like:\n                // https://imdoingitwrong.wordpress.com/2011/01/31/light-attenuation/\n                float d = max(0.0,dist-Rin)/Rin+1.0;\n                attenuation = clamp(1.0/d, 0.0, 1.0);\n            #endif\n        #else\n            #ifdef TANGRAM_POINTLIGHT_ATTENUATION_OUTER_RADIUS\n                float d = clamp(dist/_light.outerRadius, 0.0, 1.0);\n                attenuation = 1.0-d*d;\n            #else\n                attenuation = 1.0;\n            #endif\n        #endif\n    #endif\n\n    // spotlight attenuation factor\n    float spotAttenuation = 0.0;\n\n    // See if point on surface is inside cone of illumination\n    float spotDot = clamp(dot(-VP, _light.direction), 0.0, 1.0);\n\n    if (spotDot >= _light.spotCosCutoff) {\n        spotAttenuation = pow(spotDot, _light.spotExponent);\n    }\n\n    light_accumulator_ambient.rgb += _light.ambient * attenuation * spotAttenuation;\n\n    #ifdef TANGRAM_MATERIAL_DIFFUSE\n        light_accumulator_diffuse.rgb += _light.diffuse * nDotVP * attenuation * spotAttenuation;\n    #endif\n\n    #ifdef TANGRAM_MATERIAL_SPECULAR\n        // Power factor for shiny speculars\n        float pf = 0.0;\n        if (nDotVP > 0.0) {\n            vec3 reflectVector = reflect(-VP, _normal);\n            float eyeDotR = max(dot(-normalize(_eyeToPoint), reflectVector), 0.0);\n            pf = pow(eyeDotR, material.shininess);\n        }\n        light_accumulator_specular.rgb += _light.specular * pf * attenuation * spotAttenuation;\n    #endif\n}\n");},t.prototype.setupProgram=function(t){e.prototype.setupProgram.call(this,t),t.uniform("3fv","u_"+this.name+".direction",this.direction),t.uniform("1f","u_"+this.name+".spotCosCutoff",Math.cos(3.14159*this.angle/180)),t.uniform("1f","u_"+this.name+".spotExponent",this.exponent);},kr(t,[{key:"direction",get:function(){return this._direction},set:function(e){this._direction=no.normalize(no.copy(e));}}]),t}(ao);io.types.spotlight=lo,D(D.S,"Math",{log2:function(e){return Math.log(e)/Math.LN2}});var uo=function(e){function t(t){var r;return (r=e.call(this)||this).name="MethodNotImplemented",r.message="Method "+t+" must be implemented in subclass",r}return Or(t,e),t}(Ur(Error)),co=function(){function e(e,t){var r=this;(this.validate(e),this.config=e,this.sources=t,this.id=e.id,this.name=e.name,this.pad_scale=e.pad_scale||1e-5,this.default_winding=null,this.rasters=[],Array.isArray(e.rasters)&&e.rasters.forEach(function(e){-1===r.rasters.indexOf(e)&&r.rasters.push(e);}),this.preprocess=e.preprocess,"function"==typeof this.preprocess&&this.preprocess.bind(this),this.transform=e.transform,"function"==typeof this.transform&&this.transform.bind(this),this.extra_data=e.extra_data,this.scripts=e.scripts,this.setZooms(e),this.zoom_offset=null!=e.zoom_offset?e.zoom_offset:0,this.zoom_offset<0)&&(Qr({level:"warn",once:!0},"Data source '"+this.name+"' zoom_offset must not be negative – setting to 0."),this.zoom_offset=0);this.setTileSize(e.tile_size),this.min_display_zoom=Math.max(e.min_display_zoom||0,this.zooms[0]),this.max_display_zoom=null!=e.max_display_zoom?e.max_display_zoom:null;}e.register=function(t,r){t&&r&&(e.types[t]=r);},e.create=function(t,r){if("function"==typeof e.types[t.type]){var n=e.types[t.type](t);if(n)return new n(t,r)}},e.tileLayoutChanged=function(e,t){if(!e||!t)return !0;var r=["max_zoom","zooms","min_display_zoom","max_display_zoom","bounds","tile_size","zoom_offset"],n=Mn(e.config,r),i=Mn(t.config,r);return JSON.stringify(n)!==JSON.stringify(i)},e.projectData=function(e){var t=+new Date;for(var r in e.layers)for(var n=e.layers[r].features.length,i=0;i<n;i++){var o=e.layers[r].features[i];ui.transformGeometry(o.geometry,this.projectCoord);}void 0!==e.debug&&(e.debug.projection=+new Date-t);},e.projectCoord=function(e){ui.latLngToMeters(e);},e.scaleData=function(e,t){var r=t.coords.z,n=t.min,i=ui.unitsPerMeter(r);for(var o in e.layers)for(var s=e.layers[o].features.length,a=0;a<s;a++){var l=e.layers[o].features[a];ui.transformGeometry(l.geometry,function(e){e[0]=(e[0]-n.x)*i,e[1]=(e[1]-n.y)*i*-1;});}};var t=e.prototype;return t.load=function(e){var t=this;return e.source_data={},e.source_data.layers={},e.pad_scale=this.pad_scale,e.rasters=[].concat(this.rasters),this._load(e).then(function(e){for(var r in e.source_data.layers){var n=e.source_data.layers[r];n&&n.features&&n.features.forEach(function(e){ui.transformGeometry(e.geometry,function(e){e[1]=-e[1],t.pad_scale&&(e[0]=Math.round(e[0]*(1+t.pad_scale)-ui.tile_scale*t.pad_scale/2),e[1]=Math.round(e[1]*(1+t.pad_scale)-ui.tile_scale*t.pad_scale/2));}),t.updateDefaultWinding(e.geometry);});}return e.default_winding=t.default_winding||"CCW",e})},t._load=function(){throw new uo("_load")},t.copyTileData=function(e,t){return Qr("trace","Copy tile data from "+e.key+" to "+t.key),t.source_data={layers:e.source_data.layers},t.rasters=[].concat(e.rasters),t.pad_scale=e.pad_scale,t.default_winding=e.default_winding,t},t.setZooms=function(e){var t=e.max_zoom,r=e.zooms;if(this.max_zoom=null!=t?t:ui.default_source_max_zoom,Array.isArray(r))this.zooms=r,this.max_zoom=this.zooms[this.zooms.length-1];else{this.zooms=[];for(var n=0;n<=this.max_zoom;n++)this.zooms[n]=n;}},t.setTileSize=function(e){this.tile_size=e||256,("number"!=typeof this.tile_size||this.tile_size<256||!nn.isPowerOf2(this.tile_size))&&(Qr({level:"warn",once:!0},"Data source '"+this.name+"': 'tile_size' parameter must be a number that is a power of 2 greater than or equal to 256, but was '"+e+"'"),this.tile_size=256),this.zoom_bias=Math.log2(this.tile_size)-8+this.zoom_offset;},t.updateDefaultWinding=function(e){return null==this.default_winding&&("Polygon"===e.type?this.default_winding=ui.ringWinding(e.coordinates[0]):"MultiPolygon"===e.type&&(this.default_winding=ui.ringWinding(e.coordinates[0][0]))),this.default_winding},t.includesTile=function(e,t){if(e.z<this.min_display_zoom||null!=this.max_display_zoom&&t>this.max_display_zoom)return !1;for(var r=0;r<this.rasters.length;r++){var n=this.rasters[r];if(this.sources[n]&&this.sources[n]!==this&&!this.sources[n].includesTile(e,e.z))return !1}return !0},t.validate=function(){},e}();co.types={};var fo=0,ho=function(e){function t(t,r){var n;(n=e.call(this,t,r)||this).response_type="";var i=function(e,t){if(!t||0===Object.keys(t).length)return [e,[]];var r=e.indexOf("?"),n=e.indexOf("#"),i="";n>-1&&(i=e.slice(n),e=e.slice(0,n)),-1===r&&(r=e.length,e+="?"),r++;var o="",s=[];for(var a in t)""===wn(a,e)?o+=a+"="+t[a]+"&":s.push([a,t[a]]);return [e=e.slice(0,r)+o+e.slice(r)+i,s]}(t.url,t.url_params),o=i[0],s=i[1];return n.url=o,s.forEach(function(e){var r=e[0],i=e[1];Qr({level:"warn",once:!0},"Data source '"+n.name+"': parameter '"+r+"' already present in URL '"+t.url+"', skipping value '"+r+"="+i+"' specified in 'url_params'");}),t.request_headers&&"object"==typeof t.request_headers&&(n.request_headers=t.request_headers),n}Or(t,e);var r=t.prototype;return r._load=function(e){var t=this,r=this.formatURL(this.url,e),n=e.source_data;return n.url=r,e.debug=e.debug||{},e.debug.network=+new Date,new Promise(function(i){var o=fo+++"-"+r,s=nn.io(r,6e4,t.response_type,"GET",t.request_headers,o);n.request_id=o,n.error=null,s.then(function(r){var o=r.body;e.debug.response_size=o&&(o.length||o.byteLength),e.debug.network=+new Date-e.debug.network,e.debug.parsing=+new Date,null!=o&&"function"==typeof t.preprocess&&(o=t.preprocess(o)),(o=o instanceof Promise?o:Promise.resolve(o)).then(function(r){null!=r?t.parseSourceData(e,n,r):n.layers={},e.debug.parsing=+new Date-e.debug.parsing,i(e);});}).catch(function(t){n.error=t.stack,i(e);});})},r.validate=function(e){if("string"!=typeof e.url)throw Error("Network data source must provide a string `url` property")},r.formatURL=function(){throw new uo("formatURL")},r.parseSourceData=function(){throw new uo("parseSourceData")},t}(co),_o=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).tiled=!0,n.bounds=n.parseBounds(t),n.builds_geometry_tiles=!1,n.tms=!0===t.tms,n.url&&n.url.search("{s}")>-1&&(Array.isArray(t.url_subdomains)&&t.url_subdomains.length>0?(n.url_subdomains=t.url_subdomains,n.next_url_subdomain=0):Qr({level:"warn",once:!0},"Data source '"+n.name+"': source URL includes '{s}' subdomain marker ('"+n.url+"'), but no subdomains were specified in 'url_subdomains' parameter")),n.url&&n.url.search("{r}")>-1&&(Array.isArray(t.url_density_scales)&&t.url_density_scales.length>0?n.url_density_scales=t.url_density_scales:n.url_density_scales=[1,2]),n}Or(t,e);var r=t.prototype;return r.parseBounds=function(e){if(Array.isArray(e.bounds)&&4===e.bounds.length){var t=e.bounds,r=t[0],n=t[1],i=t[2],o=t[3];return {latlng:[].concat(e.bounds),meters:{min:ui.latLngToMeters([r,o]),max:ui.latLngToMeters([i,n])},tiles:{min:{},max:{}}}}},r.checkBounds=function(e,t){if(t){e=ui.wrapTile(e);var r=t.tiles.min[e.z];r||(r=t.tiles.min[e.z]=ui.tileForMeters(t.meters.min,e.z));var n=t.tiles.max[e.z];if(n||(n=t.tiles.max[e.z]=ui.tileForMeters(t.meters.max,e.z)),e.y<r.y||e.y>n.y)return !1;if(r.x<=n.x){if(e.x<r.x||e.x>n.x)return !1}else if(e.x>n.x&&e.x<r.x)return !1}return !0},r.includesTile=function(t,r){return !!e.prototype.includesTile.call(this,t,r)&&!!this.checkBounds(t,this.bounds)},r.formatURL=function(e,t){var r=ui.wrapTile(t.coords,{x:!0});this.tms&&(r.y=Math.pow(2,r.z)-1-r.y);var n=e.replace("{x}",r.x).replace("{y}",r.y).replace("{z}",r.z).replace("{r}",this.getDensityModifier()).replace("{q}",this.toQuadKey(r));return null!=this.url_subdomains&&(n=n.replace("{s}",this.url_subdomains[this.next_url_subdomain]),this.next_url_subdomain=(this.next_url_subdomain+1)%this.url_subdomains.length),n},r.getDensityModifier=function(){if(this.url_density_scales){var e=nn.device_pixel_ratio,t=this.url_density_scales.filter(function(t){return e>=t}).reverse()[0];if((t=null!=t?t:this.url_density_scales[0])>1)return "@"+t+"x"}return ""},r.toQuadKey=function(e){for(var t=e.x,r=e.y,n="",i=e.z;i>0;i--){var o=0,s=1<<i-1;0!=(t&s)&&o++,0!=(r&s)&&(o+=2),n+=o.toString();}return n},t.urlHasTilePattern=function(e){return e&&(e.search("{x}")>-1&&e.search("{y}")>-1&&e.search("{z}")>-1||e.search("{q}")>-1)},t}(ho),po={coord:function(e){return {x:e.x,y:e.y,z:e.z,key:this.coordKey(e)}},coordKey:function(e){return e.x+"/"+e.y+"/"+e.z},key:function(e,t,r){if(!(e.y<0||e.y>=1<<e.z||e.z<0))return [t.name,e.x,e.y,e.z,r].join("/")},normalizedKey:function(e,t,r){return this.key(this.normalizedCoord(e,t),t,r)},normalizedCoord:function(e,t){return t.zoom_bias&&(e=this.coordAtZoom(e,Math.max(e.z-t.zoom_bias,t.zooms[0]))),this.coordForTileZooms(e,t.zooms)},coordAtZoom:function(e,t){var r=e.x,n=e.y,i=e.z;if(i!==(t=Math.max(0,t))){var o=Math.pow(2,i-t);r=Math.floor(r/o),n=Math.floor(n/o),i=t;}return this.coord({x:r,y:n,z:i})},coordForTileZooms:function(e,t){var r=e.x,n=e.y,i=e.z,o=this.findZoomInRange(i,t);return o!==i?this.coordAtZoom({x:r,y:n,z:i},o):this.coord({x:r,y:n,z:i})},findZoomInRange:function(e,t){return t.filter(function(t){return e>=t}).reverse()[0]||t[0]},isDescendant:function(e,t){if(t.z>e.z){var r=this.coordAtZoom(t,e.z),n=r.x,i=r.y;return e.x===n&&e.y===i}return !1},parent:function(e){var t=e.coords,r=e.source,n=e.style_z;if(n>0){n--;var i=Math.max(n-r.zoom_bias,r.zooms[0]),o=this.coordForTileZooms(this.coordAtZoom(t,i),r.zooms);return o.z>n?null:{key:this.key(o,r,n),coords:o,style_z:n,source:r}}},children:function(e,t){var r=e.coords,n=e.source,i=e.style_z;void 0===t&&(t={}),i++;var o=this.coordForTileZooms(this.coordAtZoom(r,i-n.zoom_bias),n.zooms);if(o.z===r.z)return [{key:this.key(o,n,i),coords:o,style_z:i,source:n}];var s=this.key(o,n,i);if(t[n.id]=t[n.id]||{},null==t[n.id][s]){for(var a=Math.pow(2,o.z-r.z),l=r.x*a,u=r.y*a,c=[],f=l;f<l+a;f++)for(var h=u;h<u+a;h++){var d=this.coord({x:f,y:h,z:o.z});c.push({key:this.key(d,n,i),coords:d,style_z:i,source:n});}t[n.id][s]=c;}return t[n.id][s]}},mo=function(e){function t(t,r){var n;return -1===(n=e.call(this,t,r)||this).rasters.indexOf(n.name)&&n.rasters.unshift(n.name),n.filtering=t.filtering,n.textures={},n}Or(t,e);var r=t.prototype;return r.load=function(e){return new Promise(function(t,r){e.source_data={},e.source_data.layers={},e.pad_scale=this.pad_scale,e.rasters=[].concat(this.rasters);var n=ui.tile_scale;return e.source_data.layers={_default:{type:"FeatureCollection",features:[{geometry:{type:"Polygon",coordinates:[[[0,0],[n,0],[n,-n],[0,-n],[0,0]]]},properties:{}}]}},e.default_winding="CW",t(e)}.bind(this))},r.tileTexture=function(e){return new Promise(function(t,r){var n=this.adjustRasterTileZoom(e),i=n.key;if(!this.textures[i]){var o=this.formatURL(this.url,{coords:n});this.textures[i]={name:o,url:o,filtering:this.filtering,coords:n};}return t(this.textures[i])}.bind(this))},r.adjustRasterTileZoom=function(e){var t=e.coords,r=this.sources[e.source];if(r!==this){var n=this.zoom_bias-r.zoom_bias;n>0?t=po.normalizedCoord(e.coords,{zoom_bias:n,zooms:this.zooms}):(n<0&&Qr({level:"warn",once:!0},"Raster source '"+this.name+"' supports higher zoom detail than source '"+r.name+"' it's attached to. Downsampling this source "+-n+" extra zoom levels to match."),t=po.coordForTileZooms(t,this.zooms));}return t},t}(_o),vo=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).load_image={},n.alpha=null!=t.alpha?Math.max(Math.min(t.alpha,1),0):null,n.mask_alpha=!0,n.preserve_tiles_within_zoom=0,n.max_display_density=t.max_display_density,Array.isArray(t.composite)?n.images=t.composite.map(function(e){return {url:e.url,bounds:n.parseBounds(e),alpha:null!=e.alpha?Math.max(Math.min(e.alpha,1),0):null}}):n.images=[{url:n.url,bounds:n.bounds,alpha:n.alpha}],n}Or(t,e);var r=t.prototype;return r.tileTexture=function(e,t){return new Promise(function(r,n){var i,o,s,a,l,u,c,f,h,d;return i=this,o=t.blend,s=t.generation,a=this.adjustRasterTileZoom(e),l="opaque"!==o,u="raster-"+this.name+"-"+a.key+"-"+(l?"alpha":"opaque")+"-"+s,qn.textures[u]?r({name:u,coords:a,skip_create:!0}):(c=nn.device_pixel_ratio,this.max_display_density&&(c=Math.min(c,this.max_display_density)),c*=2,f=document.createElement("canvas"),h=f.getContext("2d"),f.width=this.tile_size*c,f.height=this.tile_size*c,h.imageSmoothingEnabled="nearest"!==this.filtering,d=this.images.filter(function(t){return i.checkBounds(e.coords,t.bounds)}),Promise.resolve(Promise.all(d.map(function(t){var r=l?null!=t.alpha?t.alpha:i.alpha:1;return i.drawImage(t.url,t.bounds,r,e,c,h)}))).then(function(e){try{return r({name:u,element:f,filtering:this.filtering,coords:a})}catch(e){return n(e)}}.bind(this),n))}.bind(this))},r.drawImage=function(e,t,r,n,i,o){return new Promise(function(s,a){var l,u,c,f,h,d,_;return l=Jn(e),this.load_image[l]=this.load_image[l]||this.loadImage(e),Promise.resolve(this.load_image[l]).then(function(e){try{return u=e,c=ui.metersPerPixel(n.coords.z)/i/(this.tile_size/ui.tile_size),f=(t.meters.min[0]-n.min.x)/c,h=-(t.meters.min[1]-n.min.y)/c,d=(t.meters.max[0]-t.meters.min[0])/c,_=-(t.meters.max[1]-t.meters.min[1])/c,o.globalAlpha=null!=r?r:1,o.drawImage(u,f,h,d,_),s()}catch(e){return a(e)}}.bind(this),a)}.bind(this))},r.loadImage=function(e){var t=this;return new Promise(function(r){var n=new Image;n.onload=function(){return r(n)},n.onerror=function(n){Qr("warn","Raster source '"+t.name+"': failed to load url: '"+e+"'",n),r(null);},nn.isSafari()&&"data:"===e.slice(0,5)||(n.crossOrigin="anonymous"),n.src=e;})},r.includesTile=function(e,t){var r=this;return !!co.prototype.includesTile.call(this,e,t)&&this.images.some(function(t){return r.checkBounds(e,t.bounds)})},r.validate=function(e){var t="Raster data source must provide a string `url` parameter, or an array of `composite` raster ";t+="image objects that each have a `url` parameter";var r="Raster data source must provide a `bounds` parameter, or an array of `composite` raster ";r+="image objects that each have a `bounds` parameter";if("parameters, or an array of `composite` raster image objects, each with `url` and `bounds`.",Array.isArray(e.composite)){if(e.composite.some(function(e){return "string"!=typeof e.url}))throw Error(t);if(e.composite.some(function(e){return !(Array.isArray(e.bounds)&&4===e.bounds.length)}))throw Error(r);if(null!=e.url||null!=e.bounds)throw Error("Raster data source must have *either* a single image specified as `url` and `bounds `parameters, or an array of `composite` raster image objects, each with `url` and `bounds`.")}else{if("string"!=typeof e.url)throw Error(t);if(!Array.isArray(e.bounds)||4!==e.bounds.length)throw Error(r)}},t}(mo);co.register("Raster",function(e){return mo.urlHasTilePattern(e.url)?mo:vo});var go={init:function(e){var t=void 0===e?{}:e,r=t.generation,n=t.styles,i=t.sources,o=void 0===i?{}:i,s=t.introspection;this.setGeneration(r),this.styles=n,this.sources=o,this.defines=this.hasOwnProperty("defines")&&this.defines||{},this.shaders=this.hasOwnProperty("shaders")&&this.shaders||{},this.introspection=s||!1,this.selection=this.selection||this.introspection||!1,this.compile_setup=!1,this.program=null,this.selection_program=null,this.feature_style={},this.vertex_template=[],this.tile_data={},this.stencil_proxy_tiles=!0,this.variants={},this.vertex_layouts={},this.defines.TANGRAM_WORLD_POSITION_WRAP=1e5,this.blend=this.blend||"opaque","opaque"!==this.blend?null==this.blend_order&&(this.blend_order=this.default_blend_orders[this.blend]):this.blend_order=this.default_blend_orders[this.blend],this.defines["TANGRAM_BLEND_"+this.blend.toUpperCase()]=!0,this.removeShaderBlock("setup"),this.material instanceof ro||(ro.isValid(this.material)||(this.material=Di.defaults.material),this.material=new ro(this.material)),this.material.inject(this),io.setMode(this.lighting,this),this.setupRasters(),this.setupCustomAttributes(),this.initialized=!0;},destroy:function(){this.program&&(this.program.destroy(),this.program=null),this.selection_program&&(this.selection_program.destroy(),this.selection_program=null),Hr.removeTarget(this.main_thread_target),this.gl=null,this.initialized=!1;},reset:function(){},baseStyle:function(){return this.base||this.name},setGeneration:function(e){this.generation=e,this.main_thread_target=["Style",this.name,this.generation].join("_"),Ue.is_main&&Hr.addTarget(this.main_thread_target,this);},startData:function(e){this.tile_data[e.id]=this.tile_data[e.id]||{meshes:{},uniforms:{},textures:[]};},endData:function(e){return new Promise(function(t,r){var n=this.tile_data[e.id];if(this.tile_data[e.id]=null,n&&Object.keys(n.meshes).length>0){for(var i in n.meshes){var o=n.meshes[i];0!==o.vertex_data.vertex_count?(o.vertex_data.end(),o.vertex_elements=o.vertex_data.element_buffer,o.vertex_data=o.vertex_data.vertex_buffer):delete n.meshes[i];}return t(this.buildRasterTextures(e,n))}return t(null)}.bind(this))},hasDataForTile:function(e){return null!=this.tile_data[e.id]},getTileMesh:function(e,t){var r=this.tile_data[e.id].meshes;if(null==r[t.key]){var n=this.vertexLayoutForMeshVariant(t);r[t.key]={variant:t,vertex_data:n.createVertexData()};}return r[t.key]},vertexLayoutForMeshVariant:function(){},meshVariantTypeForDraw:function(){},addFeature:function(e,t,r){var n=r.tile;if(n.generation===this.generation){this.tile_data[n.id]||this.startData(n);var i=this.parseFeature(e,t,r);i&&this.buildGeometry(e.geometry,i,r)>0&&(e.generation=this.generation);}},buildGeometry:function(e,t,r){var n,i=this;if("Polygon"===e.type?n=this.buildPolygons([e.coordinates],t,r):"MultiPolygon"===e.type?n=this.buildPolygons(e.coordinates,t,r):"LineString"===e.type?n=this.buildLines([e.coordinates],t,r):"MultiLineString"===e.type?n=this.buildLines(e.coordinates,t,r):"Point"===e.type?n=this.buildPoints([e.coordinates],t,r):"MultiPoint"===e.type&&(n=this.buildPoints(e.coordinates,t,r)),n>0&&on.layer_stats){var o=r.tile;o.debug.layers=o.debug.layers||{list:{},tree:{}};var s=o.debug.layers.list,a=o.debug.layers.tree,l={};r.layers.forEach(function(e){var t,r;yo(s,e,1,n,((t={})[i.name]=n,t),((r={})[i.baseStyle()]=n,r));for(var o=a,u=l,c=e.split(":"),f=0;f<c.length;f++){var h,d,_=c[f];if(o[_]=o[_]||{features:0,geoms:0,styles:{},base:{}},null==u[_])u[_]={},yo(o,_,1,n,((h={})[i.name]=n,h),((d={})[i.baseStyle()]=n,d));f<c.length-1&&(o[_].layers=o[_].layers||{}),o=o[_].layers,u=u[_];}});}return n},parseFeature:function(e,t,r){try{var n=this.feature_style;if(n.order=this.parseOrder(t.order,r),null==n.order&&"overlay"!==this.blend){var i="Layer '"+t.layers.join(", ")+"', draw group '"+t.group+"': ";return i+="'order' parameter is required unless blend mode is 'overlay'",null!=t.order&&(i+="; 'order' was set to a dynamic value (e.g. string tied to feature property, ",i+="or JS function), but evaluated to null for one or more features"),void Qr({level:"warn",once:!0},i)}if(!(n=this._parseFeature(e,t,r)))return;if(this.shaders.attributes)for(var o in n.attributes=n.attributes||{},this.shaders.attributes)n.attributes[o]=Di.evalCachedProperty(t.attributes&&t.attributes[o],r),"number"!=typeof n.attributes[o]&&(n.attributes[o]=0);return this.selection?n.interactive=Di.evalProperty(t.interactive,r):n.interactive=!1,!0===n.interactive?n.selection_color=Ji.makeColor(e,r.tile,r):n.selection_color=Ji.defaultColor,n=this._parseFeature(e,t,r)}catch(t){Qr("error","Style.parseFeature: style parsing error",e,n,t.stack);}},_parseFeature:function(){return this.feature_style},preprocess:function(e){if(!e.preprocessed){if(this.draw)for(var t in this.draw){var r=this.draw[t];"object"!=typeof r||Array.isArray(r)?null==e[t]&&(e[t]=r):e[t]=li({},r,e[t]);}if(this.selection?this.introspection&&(e.interactive=!0):e.interactive=!1,!(e=this._preprocess(e)))return;if(this.shaders.attributes)for(var n in e.attributes=e.attributes||{},this.shaders.attributes)e.attributes[n]=Di.createPropertyCache(null!=e.attributes[n]?e.attributes[n]:0);e.preprocessed=!0;}return e},_preprocess:function(e){return e},parseOrder:function(e,t){return "number"!=typeof e?Di.calculateOrder(e,t):e},scaleOrder:function(e){return 2*e},parseColor:function(e,t){return e?Di.evalCachedColorProperty(e,t):this.shaders.blocks.color||this.shaders.blocks.filter?Di.defaults.color:void 0},buildPolygons:function(){return 0},buildLines:function(){return 0},buildPoints:function(){return 0},setGL:function(e){this.gl=e,this.max_texture_size=qn.getMaxTextureSize(this.gl);},makeMesh:function(e,t,r){void 0===r&&(r={});var n=this.vertexLayoutForMeshVariant(r.variant);return new eo(this.gl,e,t,n,r)},render:function(e){return e.render()},getProgram:function(e){void 0===e&&(e="program"),this.compileSetup();var t=this[e];if(t&&!t.error){if(!t.compiled){Qr("debug","Compiling style '"+this.name+"', program key '"+e+"'");try{t.compile();}catch(t){throw Qr("error","Style: error compiling program for style '"+this.name+"' (program key '"+e+"')",this,t.stack,t.type,t.shader_errors),t}}return t}},compileSetup:function(){if(!this.compile_setup){if(!this.gl)throw new Error("style.compile(): skipping for "+this.name+" because no GL context");var e=this.buildDefineList();if(this.selection){var t=Object.assign({},e);t.TANGRAM_FEATURE_SELECTION=!0;}var r=this.shaders&&this.shaders.blocks,n=this.shaders&&this.shaders.block_scopes,i=Object.assign({},this.shaders&&this.shaders.uniforms);for(var o in i)null==i[o]&&Qr({level:"warn",once:!0},"Style '"+this.name+"' has invalid uniform '"+o+"': uniform values must be non-null");var s=this.shaders&&this.shaders.extensions;"string"==typeof s&&(s=[s]),this.program=new ti(this.gl,this.vertex_shader_src,this.fragment_shader_src,{name:this.name,defines:e,uniforms:i,blocks:r,block_scopes:n,extensions:s}),this.selection?this.selection_program=new ti(this.gl,this.vertex_shader_src,"// Fragment shader for feature selection passes\n// Renders in silhouette according to selection (picking) color, or black if none defined\n\n#ifdef TANGRAM_FEATURE_SELECTION\n    varying vec4 v_selection_color;\n#endif\n\nvoid main (void) {\n    #ifdef TANGRAM_FEATURE_SELECTION\n        gl_FragColor = v_selection_color;\n    #else\n        gl_FragColor = vec4(0., 0., 0., 1.);\n    #endif\n}\n",{name:this.name+" (selection)",defines:t,uniforms:i,blocks:r,block_scopes:n,extensions:s}):this.selection_program=null,this.compile_setup=!0;}},addShaderBlock:function(e,t,r){void 0===r&&(r=null),this.shaders.blocks=this.shaders.blocks||{},this.shaders.blocks[e]=this.shaders.blocks[e]||[],this.shaders.blocks[e].push(t),this.shaders.block_scopes=this.shaders.block_scopes||{},this.shaders.block_scopes[e]=this.shaders.block_scopes[e]||[],this.shaders.block_scopes[e].push(r);},removeShaderBlock:function(e){this.shaders.blocks&&(this.shaders.blocks[e]=null),this.shaders.block_scopes&&(this.shaders.block_scopes[e]=null);},replaceShaderBlock:function(e,t,r){void 0===r&&(r=null),this.removeShaderBlock(e),this.addShaderBlock(e,t,r);},buildDefineList:function(){var e={};if(null!=this.defines)for(var t in this.defines)e[t]=this.defines[t];if(null!=this.shaders&&null!=this.shaders.defines)for(t in this.shaders.defines)e[t]=this.shaders.defines[t];return e},hasRasters:function(){return ["color","normal","custom"].indexOf(this.raster)>-1},setupRasters:function(){var e=this;if(this.hasRasters()){"color"===this.raster?this.defines.TANGRAM_RASTER_TEXTURE_COLOR=!0:"normal"===this.raster&&(this.defines.TANGRAM_RASTER_TEXTURE_NORMAL=!0);var t=Object.keys(this.sources).filter(function(t){return e.sources[t]instanceof mo}).length;if(this.defines.TANGRAM_NUM_RASTER_SOURCES=""+t,t>0){var r=Object.keys(this.sources).filter(function(t){return e.sources[t].mask_alpha}).length;this.defines.TANGRAM_HAS_MASKED_RASTERS=r>0,this.defines.TANGRAM_ALL_MASKED_RASTERS=r===t,this.defines.TANGRAM_MODEL_POSITION_BASE_ZOOM_VARYING=!0,this.replaceShaderBlock("raster","// Uniforms defining raster textures and macros for accessing them\n\n#ifdef TANGRAM_FRAGMENT_SHADER\nuniform sampler2D u_rasters[TANGRAM_NUM_RASTER_SOURCES];    // raster tile texture samplers\nuniform vec2 u_raster_sizes[TANGRAM_NUM_RASTER_SOURCES];    // raster tile texture sizes (width/height in pixels)\nuniform vec3 u_raster_offsets[TANGRAM_NUM_RASTER_SOURCES];  // raster tile texture UV starting offset for tile\n\n// Raster sources can optionally mask by the alpha channel (render with only full or no alpha, based on a threshold),\n// which is used for handling transparency outside the raster image when rendering with opaque blending\n#if defined(TANGRAM_HAS_MASKED_RASTERS) && !defined(TANGRAM_ALL_MASKED_RASTERS) // only add uniform if we need it\nuniform bool u_raster_mask_alpha;\n#endif\n\n// Note: the raster accessors below are #defines rather than functions to\n// avoid issues with constant integer expressions for array indices\n\n// Adjusts UVs in model space to account for raster tile texture overzooming\n// (applies scale and offset adjustments)\n#define adjustRasterUV(raster_index, uv) \\\n    ((uv) * u_raster_offsets[raster_index].z + u_raster_offsets[raster_index].xy)\n\n// Returns the UVs of the current model position for a raster sampler\n#define currentRasterUV(raster_index) \\\n    (adjustRasterUV(raster_index, v_modelpos_base_zoom.xy))\n\n// Returns pixel location in raster tile texture at current model position\n#define currentRasterPixel(raster_index) \\\n    (currentRasterUV(raster_index) * rasterPixelSize(raster_index))\n\n// Samples a raster tile texture for the current model position\n#define sampleRaster(raster_index) \\\n    (texture2D(u_rasters[raster_index], currentRasterUV(raster_index)))\n\n// Samples a raster tile texture for a given pixel\n#define sampleRasterAtPixel(raster_index, pixel) \\\n    (texture2D(u_rasters[raster_index], (pixel) / rasterPixelSize(raster_index)))\n\n// Returns size of raster sampler in pixels\n#define rasterPixelSize(raster_index) \\\n    (u_raster_sizes[raster_index])\n\n#endif\n","Raster");}}},buildRasterTextures:function(e,t){return new Promise(function(r,n){var i,o,s,a;if(!this.hasRasters())return r(t);if(0===e.rasters.length)return r(t);var l=function(){try{return !i||i.length<1?r(t):i.some(function(e){return !e.loaded})?r(null):(t.uniforms.u_raster_mask_alpha=!0===this.sources[e.rasters[0]].mask_alpha,o=t.uniforms.u_rasters=[],s=t.uniforms.u_raster_sizes=[],a=t.uniforms.u_raster_offsets=[],i.forEach(function(r){var n=r.index;if(o[n]=r.name,t.textures.push(r.name),s[n]=[r.width,r.height],e.coords.z>r.coords.z){var i=e.coords.z-r.coords.z,l=Math.pow(2,i);a[n]=[(e.coords.x%l+l)%l/l,(l-1-e.coords.y%l)/l,1/l];}else a[n]=[0,0,1];}),r(t))}catch(e){return n(e)}}.bind(this),u=function(e){try{return r(t)}catch(e){return n(e)}};try{return Promise.resolve(Hr.postMessage(this.main_thread_target+".loadTextures",{coords:e.coords,source:e.source,rasters:e.rasters,min:e.min,max:e.max})).then(function(e){try{return i=e,l()}catch(e){return u()}},u)}catch(e){u();}}.bind(this))},loadTextures:function(e){return new Promise(function(t,r){var n,i,o,s,a;return n=this,i={},o={},s=[],e.rasters.map(function(e){return n.sources[e]}).filter(function(e){return e}).forEach(function(t,r){t instanceof mo&&s.push(t.tileTexture(e,n).then(function(e){i[e.name]=e,o[e.name]=r;}));}),Promise.resolve(Promise.all(s)).then(function(e){try{return Promise.resolve(qn.createFromObject(this.gl,i)).then(function(e){try{return Promise.resolve(Promise.all(Object.keys(i).map(function(e){return qn.textures[e]&&qn.textures[e].load()}).filter(function(e){return e}))).then(function(e){try{return (a=e).forEach(function(e){return e.retain()}),t(a.map(function(e){return {name:e.name,width:e.width,height:e.height,loaded:e.loaded,index:o[e.name],coords:i[e.name].coords}}))}catch(e){return r(e)}},r)}catch(e){return r(e)}},r)}catch(e){return r(e)}}.bind(this),r)}.bind(this))},setupCustomAttributes:function(){if(this.shaders.attributes)for(var e=Object.entries(this.shaders.attributes),t=0;t<e.length;t++){var r=e[t],n=r[0],i=r[1];"float"===i.type&&(!1!==i.varying?(this.addShaderBlock("attributes","\n                            #ifdef TANGRAM_VERTEX_SHADER\n                                attribute float a_"+n+";\n                                varying float v_"+n+";\n                                #define "+n+" a_"+n+"\n                            #else\n                                varying float v_"+n+";\n                                #define "+n+" v_"+n+"\n                            #endif\n                        "),this.addShaderBlock("setup","#ifdef TANGRAM_VERTEX_SHADER\nv_"+n+" = a_"+n+";\n#endif")):this.addShaderBlock("attributes","\n                            #ifdef TANGRAM_VERTEX_SHADER\n                                attribute float a_"+n+";\n                                #define "+n+" a_"+n+"\n                            #endif\n                        "));}},addCustomAttributesToAttributeList:function(e){if(this.shaders.attributes)for(var t=Object.entries(this.shaders.attributes),r=0;r<t.length;r++){var n=t[r],i=n[0];"float"===n[1].type&&e.push({name:"a_"+i,size:1,type:Ki.FLOAT,normalized:!1});}return e},addCustomAttributesToVertexTemplate:function(e,t){if(this.shaders.attributes)for(var r in this.shaders.attributes)this.vertex_template[t++]=null!=e.attributes[r]?e.attributes[r]:0;},setup:function(){this.setUniforms(),this.material.setupProgram(ti.current);},setUniforms:function(){var e=ti.current;e&&e.setUniforms(this.shaders&&this.shaders.uniforms,!0);},render_states:{opaque:{depth_test:!0,depth_write:!0},translucent:{depth_test:!0,depth_write:!0},add:{depth_test:!0,depth_write:!1},multiply:{depth_test:!0,depth_write:!1},inlay:{depth_test:!0,depth_write:!1},overlay:{depth_test:!1,depth_write:!1}},default_blend_orders:{opaque:Number.MIN_SAFE_INTEGER,add:1,multiply:2,inlay:3,translucent:4,overlay:5},getBlendOrderForDraw:function(e){return "opaque"!==this.blend&&null!=e.blend_order?e.blend_order:this.blend_order}};function yo(e,t,r,n,i,o){for(var s in e[t]=e[t]||{features:0,geoms:0,styles:{},base:{}},e[t].features+=r,e[t].geoms+=n,i)e[t].styles[s]=e[t].styles[s]||0,e[t].styles[s]+=i[s];for(var a in o)e[t].base[a]=e[t].base[a]||0,e[t].base[a]+=o[a];}Bn("Int16",2,function(e){return function(t,r,n){return e(this,t,r,n)}}),Bn("Uint32",4,function(e){return function(t,r,n){return e(this,t,r,n)}}),Bn("Int32",4,function(e){return function(t,r,n){return e(this,t,r,n)}}),Bn("Int8",1,function(e){return function(t,r,n){return e(this,t,r,n)}}),Bn("Float32",4,function(e){return function(t,r,n){return e(this,t,r,n)}});var xo,bo=Math.pow(2,16)-1,Ao=!1,To=function(){function e(){this.array=[],this.has_overflown=!1;}var t=e.prototype;return t.push=function(e){this.has_overflown&&!Ao||e>bo&&(this.has_overflown=!0,!Ao)||this.array.push(e);},t.end=function(){if(this.array.length){var e=(t=this.array,new(this.has_overflown&&Ao?Uint32Array:Uint16Array)(t));return this.array=[],this.has_overflown=!1,e}return !1;var t;},e}();To.setElementIndexUint=function(e){Ao=e;};var wo=((xo={})[Ki.FLOAT]=Float32Array,xo[Ki.BYTE]=Int8Array,xo[Ki.UNSIGNED_BYTE]=Uint8Array,xo[Ki.INT]=Int32Array,xo[Ki.UNSIGNED_INT]=Uint32Array,xo[Ki.SHORT]=Int16Array,xo[Ki.UNSIGNED_SHORT]=Uint16Array,xo),Eo=function(){function e(t,r){var n=(void 0===r?{}:r).prealloc,i=void 0===n?500:n;this.vertex_layout=t,this.vertex_elements=new To,this.stride=this.vertex_layout.stride,e.array_pool.length>0?(this.vertex_buffer=e.array_pool.pop(),this.byte_length=this.vertex_buffer.byteLength,this.size=Math.floor(this.byte_length/this.stride),Qr("trace","VertexData: reused buffer of bytes "+this.byte_length+", "+this.size+" vertices")):(this.size=i,this.byte_length=this.stride*this.size,this.vertex_buffer=new Uint8Array(this.byte_length)),this.offset=0,this.vertex_count=0,this.realloc_count=0,this.setBufferViews(),this.setAddVertexFunction();}var t=e.prototype;return t.setBufferViews=function(){var e=this;this.views={},this.views[Ki.UNSIGNED_BYTE]=this.vertex_buffer,this.vertex_layout.dynamic_attribs.forEach(function(t){if(null==e.views[t.type]){var r=wo[t.type];e.views[t.type]=new r(e.vertex_buffer.buffer);}});},t.checkBufferSize=function(){if(this.offset+this.stride>this.byte_length){this.size=Math.floor(1.5*this.size),this.size-=this.size%4,this.byte_length=this.stride*this.size;var t=new Uint8Array(this.byte_length);t.set(this.vertex_buffer),e.array_pool.push(this.vertex_buffer),this.vertex_buffer=t,this.setBufferViews(),this.realloc_count++;}},t.setAddVertexFunction=function(){this.vertexLayoutAddVertex=this.vertex_layout.getAddVertexFunction();},t.addVertex=function(e){this.checkBufferSize(),this.vertexLayoutAddVertex(e,this.views,this.offset),this.offset+=this.stride,this.vertex_count++;},t.end=function(){return this.vertex_buffer=this.vertex_buffer.subarray(0,this.offset),this.element_buffer=this.vertex_elements.end(),Qr("trace","VertexData: "+this.size+" vertices total, realloc count "+this.realloc_count),this},e}();Eo.array_pool=[];var Ro=function(){function e(e){this.attribs=e,this.dynamic_attribs=this.attribs.filter(function(e){return null==e.static}),this.static_attribs=this.attribs.filter(function(e){return null!=e.static}),this.components=[],this.index={},this.offset={},this.stride=0;for(var t=0,r=0,n=0;n<this.attribs.length;n++){var i=this.attribs[n];if(null==i.static){i.offset=this.stride,i.byte_size=i.size;var o=0;switch(i.type){case Ki.FLOAT:case Ki.INT:case Ki.UNSIGNED_INT:i.byte_size*=4,o=2;break;case Ki.SHORT:case Ki.UNSIGNED_SHORT:i.byte_size*=2,o=1;}3&i.byte_size&&(i.byte_size+=4-(3&i.byte_size)),this.stride+=i.byte_size;for(var s=i.offset>>o,a=0;a<i.size;a++)this.components.push({type:i.type,shift:o,offset:s++,index:r++});this.index[i.name]=t,t+=i.size,this.offset[i.name]=i.offset;}else i.static=Array.isArray(i.static)?i.static:[i.static],i.method="vertexAttrib"+i.static.length+"fv";}}var t=e.prototype;return t.enableDynamicAttributes=function(t,r){var n=this;for(var i in e.enabled_attribs)t.disableVertexAttribArray(i);e.enabled_attribs={},this.dynamic_attribs.forEach(function(i){var o=r.attribute(i.name).location;-1!==o&&(t.enableVertexAttribArray(o),t.vertexAttribPointer(o,i.size,i.type,i.normalized,n.stride,i.offset),e.enabled_attribs[o]=r);});},t.enableStaticAttributes=function(e,t){this.static_attribs.forEach(function(r){var n=t.attribute(r.name).location;-1!==n&&e[r.method]instanceof Function&&(e.enableVertexAttribArray(n),e[r.method](n,r.static),e.disableVertexAttribArray(n));});},t.createVertexData=function(){return new Eo(this)},t.getAddVertexFunction=function(){return null==this.addVertex&&this.createAddVertexFunction(),this.addVertex},t.createAddVertexFunction=function(){var t=Jn(JSON.stringify(this.attribs));if(null==e.add_vertex_funcs[t]){var r,n=["var t, o;"],i=[].concat(this.components);i.sort(function(e,t){return e.type!==t.type?e.type-t.type:e.index-t.index});for(var o=0;o<i.length;o++){var s=i[o];r!==s.type&&(n.push("t = vs["+s.type+"];"),n.push("o = off"+(s.shift?" >> "+s.shift:"")+";"),r=s.type),n.push("t[o + "+s.offset+"] = v["+s.index+"];");}n=n.join("\n");var a=new Function("v","vs","off",n);e.add_vertex_funcs[t]=a;}this.addVertex=e.add_vertex_funcs[t];},e}();Ro.enabled_attribs={},Ro.add_vertex_funcs={};var Mo=[{x:0,y:0},{x:ui.tile_scale,y:-ui.tile_scale}],So=[0,0,1,1];function zo(e,t,r){var n=Mo[0],i=Mo[1];return e[0]<=n.x+r&&t[0]<=n.x+r||e[0]>=i.x-r&&t[0]>=i.x-r||e[1]>=n.y-r&&t[1]>=n.y-r||e[1]<=i.y+r&&t[1]<=i.y+r}function No(e,t){t=t||0;var r=Mo[0],n=Mo[1];return e[0]<=r.x+t||e[0]>=n.x-t||e[1]>=r.y-t||e[1]<=n.y+t}var Po=ko;function ko(e,t,r){r=r||2;var n,i,o,s,a,l,u,c=t&&t.length,f=c?t[0]*r:e.length,h=Oo(e,0,f,r,!0),d=[];if(!h)return d;if(c&&(h=function(e,t,r,n){var i,o,s,a,l,u=[];for(i=0,o=t.length;i<o;i++)s=t[i]*n,a=i<o-1?t[i+1]*n:e.length,(l=Oo(e,s,a,n,!1))===l.next&&(l.steiner=!0),u.push(Bo(l));for(u.sort(Co),i=0;i<u.length;i++)jo(u[i],r),r=Lo(r,r.next);return r}(e,t,h,r)),e.length>80*r){n=o=e[0],i=s=e[1];for(var _=r;_<f;_+=r)(a=e[_])<n&&(n=a),(l=e[_+1])<i&&(i=l),a>o&&(o=a),l>s&&(s=l);u=Math.max(o-n,s-i);}return Io(h,d,r,n,i,u),d}function Oo(e,t,r,n,i){var o,s;if(i===es(e,t,r,n)>0)for(o=t;o<r;o+=n)s=Jo(o,e[o],e[o+1],s);else for(o=r-n;o>=t;o-=n)s=Jo(o,e[o],e[o+1],s);return s&&Wo(s,s.next)&&(Ko(s),s=s.next),s}function Lo(e,t){if(!e)return e;t||(t=e);var r,n=e;do{if(r=!1,n.steiner||!Wo(n,n.next)&&0!==Xo(n.prev,n,n.next))n=n.next;else{if(Ko(n),(n=t=n.prev)===n.next)return null;r=!0;}}while(r||n!==t);return t}function Io(e,t,r,n,i,o,s){if(e){!s&&o&&function(e,t,r,n){var i=e;do{null===i.z&&(i.z=Vo(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,function(e){var t,r,n,i,o,s,a,l,u=1;do{for(r=e,e=null,o=null,s=0;r;){for(s++,n=r,a=0,t=0;t<u&&(a++,n=n.nextZ);t++);for(l=u;a>0||l>0&&n;)0===a?(i=n,n=n.nextZ,l--):0!==l&&n?r.z<=n.z?(i=r,r=r.nextZ,a--):(i=n,n=n.nextZ,l--):(i=r,r=r.nextZ,a--),o?o.nextZ=i:e=i,i.prevZ=o,o=i;r=n;}o.nextZ=null,u*=2;}while(s>1)}(i);}(e,n,i,o);for(var a,l,u=e;e.prev!==e.next;)if(a=e.prev,l=e.next,o?Uo(e,n,i,o):Fo(e))t.push(a.i/r),t.push(e.i/r),t.push(l.i/r),Ko(e),e=l.next,u=l.next;else if((e=l)===u){s?1===s?Io(e=Do(e,t,r),t,r,n,i,o,2):2===s&&Go(e,t,r,n,i,o):Io(Lo(e),t,r,n,i,o,1);break}}}function Fo(e){var t=e.prev,r=e,n=e.next;if(Xo(t,r,n)>=0)return !1;for(var i=e.next.next;i!==e.prev;){if(qo(t.x,t.y,r.x,r.y,n.x,n.y,i.x,i.y)&&Xo(i.prev,i,i.next)>=0)return !1;i=i.next;}return !0}function Uo(e,t,r,n){var i=e.prev,o=e,s=e.next;if(Xo(i,o,s)>=0)return !1;for(var a=i.x<o.x?i.x<s.x?i.x:s.x:o.x<s.x?o.x:s.x,l=i.y<o.y?i.y<s.y?i.y:s.y:o.y<s.y?o.y:s.y,u=i.x>o.x?i.x>s.x?i.x:s.x:o.x>s.x?o.x:s.x,c=i.y>o.y?i.y>s.y?i.y:s.y:o.y>s.y?o.y:s.y,f=Vo(a,l,t,r,n),h=Vo(u,c,t,r,n),d=e.nextZ;d&&d.z<=h;){if(d!==e.prev&&d!==e.next&&qo(i.x,i.y,o.x,o.y,s.x,s.y,d.x,d.y)&&Xo(d.prev,d,d.next)>=0)return !1;d=d.nextZ;}for(d=e.prevZ;d&&d.z>=f;){if(d!==e.prev&&d!==e.next&&qo(i.x,i.y,o.x,o.y,s.x,s.y,d.x,d.y)&&Xo(d.prev,d,d.next)>=0)return !1;d=d.prevZ;}return !0}function Do(e,t,r){var n=e;do{var i=n.prev,o=n.next.next;!Wo(i,o)&&Zo(i,n,n.next,o)&&Yo(i,o)&&Yo(o,i)&&(t.push(i.i/r),t.push(n.i/r),t.push(o.i/r),Ko(n),Ko(n.next),n=e=o),n=n.next;}while(n!==e);return n}function Go(e,t,r,n,i,o){var s=e;do{for(var a=s.next.next;a!==s.prev;){if(s.i!==a.i&&Ho(s,a)){var l=$o(s,a);return s=Lo(s,s.next),l=Lo(l,l.next),Io(s,t,r,n,i,o),void Io(l,t,r,n,i,o)}a=a.next;}s=s.next;}while(s!==e)}function Co(e,t){return e.x-t.x}function jo(e,t){if(t=function(e,t){var r,n=t,i=e.x,o=e.y,s=-1/0;do{if(o<=n.y&&o>=n.next.y){var a=n.x+(o-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(a<=i&&a>s){if(s=a,a===i){if(o===n.y)return n;if(o===n.next.y)return n.next}r=n.x<n.next.x?n:n.next;}}n=n.next;}while(n!==t);if(!r)return null;if(i===s)return r.prev;var l,u=r,c=r.x,f=r.y,h=1/0;n=r.next;for(;n!==u;)i>=n.x&&n.x>=c&&qo(o<f?i:s,o,c,f,o<f?s:i,o,n.x,n.y)&&((l=Math.abs(o-n.y)/(i-n.x))<h||l===h&&n.x>r.x)&&Yo(n,e)&&(r=n,h=l),n=n.next;return r}(e,t)){var r=$o(t,e);Lo(r,r.next);}}function Vo(e,t,r,n,i){return (e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-r)/i)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-n)/i)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function Bo(e){var t=e,r=e;do{t.x<r.x&&(r=t),t=t.next;}while(t!==e);return r}function qo(e,t,r,n,i,o,s,a){return (i-s)*(t-a)-(e-s)*(o-a)>=0&&(e-s)*(n-a)-(r-s)*(t-a)>=0&&(r-s)*(o-a)-(i-s)*(n-a)>=0}function Ho(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){var r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&Zo(r,r.next,e,t))return !0;r=r.next;}while(r!==e);return !1}(e,t)&&Yo(e,t)&&Yo(t,e)&&function(e,t){var r=e,n=!1,i=(e.x+t.x)/2,o=(e.y+t.y)/2;do{r.y>o!=r.next.y>o&&i<(r.next.x-r.x)*(o-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==e);return n}(e,t)}function Xo(e,t,r){return (t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function Wo(e,t){return e.x===t.x&&e.y===t.y}function Zo(e,t,r,n){return !!(Wo(e,t)&&Wo(r,n)||Wo(e,n)&&Wo(r,t))||Xo(e,t,r)>0!=Xo(e,t,n)>0&&Xo(r,n,e)>0!=Xo(r,n,t)>0}function Yo(e,t){return Xo(e.prev,e,e.next)<0?Xo(e,t,e.next)>=0&&Xo(e,e.prev,t)>=0:Xo(e,t,e.prev)<0||Xo(e,e.next,t)<0}function $o(e,t){var r=new Qo(e.i,e.x,e.y),n=new Qo(t.i,t.x,t.y),i=e.next,o=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,o.next=n,n.prev=o,n}function Jo(e,t,r,n){var i=new Qo(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function Ko(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ);}function Qo(e,t,r){this.i=e,this.x=t,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function es(e,t,r,n){for(var i=0,o=t,s=r-n;o<r;o+=n)i+=(e[s]-e[o])*(e[o+1]+e[s+1]),s=o;return i}ko.deviation=function(e,t,r,n){var i=t&&t.length,o=i?t[0]*r:e.length,s=Math.abs(es(e,0,o,r));if(i)for(var a=0,l=t.length;a<l;a++){var u=t[a]*r,c=a<l-1?t[a+1]*r:e.length;s-=Math.abs(es(e,u,c,r));}var f=0;for(a=0;a<n.length;a+=3){var h=n[a]*r,d=n[a+1]*r,_=n[a+2]*r;f+=Math.abs((e[h]-e[_])*(e[d+1]-e[h+1])-(e[h]-e[d])*(e[_+1]-e[h+1]));}return 0===s&&0===f?0:Math.abs((f-s)/s)},ko.flatten=function(e){for(var t=e[0][0].length,r={vertices:[],holes:[],dimensions:t},n=0,i=0;i<e.length;i++){for(var o=0;o<e[i].length;o++)for(var s=0;s<t;s++)r.vertices.push(e[i][o][s]);i>0&&(n+=e[i-1].length,r.holes.push(n));}return r};var ts=[0,0,1];function rs(e,t,r,n){var i,o,s,a,l,u,c,f,h,d=n.texcoord_index,_=n.texcoord_scale,p=n.texcoord_normalize,m=t.vertex_elements,v=e.length,g=0;if(d){p=p||1;var y=_||So;i=y[0],o=y[1],s=y[2],a=y[3];}for(var x=0;x<v;x++){var b=e[x],A=t.vertex_count,T=(h=Po.flatten(b),Po(h.vertices,h.holes,h.dimensions)),w=T.length;if(w){var E;if(d)l=(E=ui.findBoundingBox(b))[0],u=E[1],c=(s-i)/(E[2]-l),f=(a-o)/(E[3]-u);for(var R=0;R<b.length;R++)for(var M=b[R],S=0;S<M.length;S++){var z=M[S];r[0]=z[0],r[1]=z[1],d&&(r[d+0]=((z[0]-l)*c+i)*p,r[d+1]=((z[1]-u)*f+o)*p),t.addVertex(r);}for(var N=0;N<w;N++)m.push(A+T[N]);g+=w/3;}}return g}var ns='uniform vec2 u_resolution;\nuniform float u_time;\nuniform vec3 u_map_position;\nuniform vec4 u_tile_origin;\nuniform float u_tile_proxy_order_offset;\nuniform float u_meters_per_pixel;\nuniform float u_device_pixel_ratio;\n\nuniform mat4 u_model;\nuniform mat4 u_modelView;\nuniform mat3 u_normalMatrix;\nuniform mat3 u_inverseNormalMatrix;\n\nattribute vec4 a_position;\nattribute vec4 a_color;\n\n// Optional normal attribute, otherwise default to up\n#ifdef TANGRAM_NORMAL_ATTRIBUTE\n    attribute vec3 a_normal;\n    #define TANGRAM_NORMAL a_normal\n#else\n    #define TANGRAM_NORMAL vec3(0., 0., 1.)\n#endif\n\n// Optional dynamic line extrusion\n#ifdef TANGRAM_EXTRUDE_LINES\n    attribute vec2 a_extrude; // extrusion direction in xy plane\n    attribute vec2 a_offset;  // offset direction in xy plane\n\n    // Polygon and line styles have slightly different VBO layouts, saving memory by optimizing vertex packing.\n    // All lines have a width scaling factor, but only some have a height (position.z) or offset.\n    // The vertex height is stored in different attributes to account for this.\n    attribute vec2 a_z_and_offset_scale; // stores vertex height in x, and offset scaling factor in y\n    #define TANGRAM_POSITION_Z a_z_and_offset_scale.x // vertex height is stored in separate line-specific attrib\n    #define TANGRAM_OFFSET_SCALING a_z_and_offset_scale.y // zoom scaling factor for line offset\n    #define TANGRAM_WIDTH_SCALING a_position.z // zoom scaling factor for line width (stored in position attrib)\n\n    uniform float u_v_scale_adjust; // scales texture UVs for line dash patterns w/fractional pixel width\n#else\n    #define TANGRAM_POSITION_Z a_position.z // vertex height\n#endif\n\nvarying vec4 v_position;\nvarying vec3 v_normal;\nvarying vec4 v_color;\nvarying vec4 v_world_position;\n\n// Optional texture UVs\n#if defined(TANGRAM_TEXTURE_COORDS) || defined(TANGRAM_EXTRUDE_LINES)\n    attribute vec2 a_texcoord;\n    varying vec2 v_texcoord;\n#endif\n\n// Optional model position varying for tile coordinate zoom\n#ifdef TANGRAM_MODEL_POSITION_BASE_ZOOM_VARYING\n    varying vec4 v_modelpos_base_zoom;\n#endif\n\n#if defined(TANGRAM_LIGHTING_VERTEX)\n    varying vec4 v_lighting;\n#endif\n\n#define TANGRAM_UNPACK_SCALING(x) (x / 1024.)\n\n#pragma tangram: attributes\n#pragma tangram: camera\n#pragma tangram: material\n#pragma tangram: lighting\n#pragma tangram: raster\n#pragma tangram: global\n\nvoid main() {\n    // Initialize globals\n    #pragma tangram: setup\n\n    // Texture UVs\n    #ifdef TANGRAM_TEXTURE_COORDS\n        v_texcoord = a_texcoord;\n        #ifdef TANGRAM_EXTRUDE_LINES\n            v_texcoord.y *= u_v_scale_adjust;\n        #endif\n    #endif\n\n    // Pass model position to fragment shader\n    #ifdef TANGRAM_MODEL_POSITION_BASE_ZOOM_VARYING\n        v_modelpos_base_zoom = modelPositionBaseZoom();\n    #endif\n\n    // Position\n    vec4 position = vec4(a_position.xy, TANGRAM_POSITION_Z / TANGRAM_HEIGHT_SCALE, 1.); // convert height back to meters\n\n    #ifdef TANGRAM_EXTRUDE_LINES\n        vec2 _extrude = a_extrude.xy;\n        vec2 _offset = a_offset.xy;\n\n        // Adjust line width based on zoom level, to prevent proxied lines\n        // from being either too small or too big.\n        // "Flattens" the zoom between 1-2 to peg it to 1 (keeps lines from\n        // prematurely shrinking), then interpolate and clamp to 4 (keeps lines\n        // from becoming too small when far away).\n        float _dz = clamp(u_map_position.z - u_tile_origin.z, 0., 4.);\n        _dz += step(1., _dz) * (1. - _dz) + mix(0., 2., clamp((_dz - 2.) / 2., 0., 1.));\n\n        // Interpolate line width between zooms\n        float _mdz = (_dz - 0.5) * 2.; // zoom from mid-point\n        _extrude -= _extrude * TANGRAM_UNPACK_SCALING(TANGRAM_WIDTH_SCALING) * _mdz;\n\n        // Interpolate line offset between zooms\n        // Scales from the larger value to the smaller one\n        float _dwdz = TANGRAM_UNPACK_SCALING(TANGRAM_OFFSET_SCALING);\n        float _sdwdz = sign(step(0., _dwdz) - 0.5); // sign indicates "direction" of scaling\n        _offset -= _offset * abs(_dwdz) * ((1.-step(0., _sdwdz)) - (_dz * -_sdwdz)); // scale "up" or "down"\n\n        // Scale line width and offset to be consistent in screen space\n        float _ssz = exp2(-_dz - (u_tile_origin.z - u_tile_origin.w));\n        _extrude *= _ssz;\n        _offset *= _ssz;\n\n        // Modify line width before extrusion\n        #ifdef TANGRAM_BLOCK_WIDTH\n            float width = 1.;\n            #pragma tangram: width\n            _extrude *= width;\n        #endif\n\n        position.xy += _extrude + _offset;\n    #endif\n\n    // World coordinates for 3d procedural textures\n    v_world_position = wrapWorldPosition(u_model * position);\n\n    // Adjust for tile and view position\n    position = u_modelView * position;\n\n    // Modify position before camera projection\n    #pragma tangram: position\n\n    // Setup varyings\n    v_position = position;\n    v_normal = normalize(u_normalMatrix * TANGRAM_NORMAL);\n    v_color = a_color;\n\n    #if defined(TANGRAM_LIGHTING_VERTEX)\n        // Vertex lighting\n        vec3 normal = v_normal;\n\n        // Modify normal before lighting\n        #pragma tangram: normal\n\n        // Pass lighting intensity to fragment shader\n        v_lighting = calculateLighting(position.xyz - u_eye, normal, vec4(1.));\n    #endif\n\n    // Camera\n    cameraProjection(position);\n\n    // +1 is to keep all layers including proxies > 0\n    applyLayerOrder(a_position.w + u_tile_proxy_order_offset + 1., position);\n\n    gl_Position = position;\n}\n',is="uniform vec2 u_resolution;\nuniform float u_time;\nuniform vec3 u_map_position;\nuniform vec4 u_tile_origin;\nuniform float u_meters_per_pixel;\nuniform float u_device_pixel_ratio;\n\nuniform mat3 u_normalMatrix;\nuniform mat3 u_inverseNormalMatrix;\n\nvarying vec4 v_position;\nvarying vec3 v_normal;\nvarying vec4 v_color;\nvarying vec4 v_world_position;\n\n#ifdef TANGRAM_EXTRUDE_LINES\n    uniform bool u_has_line_texture;\n    uniform sampler2D u_texture;\n    uniform float u_texture_ratio;\n    uniform vec4 u_dash_background_color;\n#endif\n\n#define TANGRAM_NORMAL v_normal\n\n#if defined(TANGRAM_TEXTURE_COORDS) || defined(TANGRAM_EXTRUDE_LINES)\n    varying vec2 v_texcoord;\n#endif\n\n#ifdef TANGRAM_MODEL_POSITION_BASE_ZOOM_VARYING\n    varying vec4 v_modelpos_base_zoom;\n#endif\n\n#if defined(TANGRAM_LIGHTING_VERTEX)\n    varying vec4 v_lighting;\n#endif\n\n#pragma tangram: attributes\n#pragma tangram: camera\n#pragma tangram: material\n#pragma tangram: lighting\n#pragma tangram: raster\n#pragma tangram: global\n\nvoid main (void) {\n    // Initialize globals\n    #pragma tangram: setup\n\n    vec4 color = v_color;\n    vec3 normal = TANGRAM_NORMAL;\n\n    // Apply raster to vertex color\n    #ifdef TANGRAM_RASTER_TEXTURE_COLOR\n        vec4 _raster_color = sampleRaster(0);\n\n        #if defined(TANGRAM_BLEND_OPAQUE) || defined(TANGRAM_BLEND_TRANSLUCENT) || defined(TANGRAM_BLEND_MULTIPLY)\n            // Raster sources can optionally mask by the alpha channel, which will render with only full or no alpha.\n            // This is used for handling transparency outside the raster image in some blend modes,\n            // which either don't support alpha, or would cause transparent pixels to write to the depth buffer,\n            // obscuring geometry underneath.\n            #ifdef TANGRAM_HAS_MASKED_RASTERS   // skip masking logic if no masked raster sources\n            #ifndef TANGRAM_ALL_MASKED_RASTERS  // skip conditional if *only* masked raster sources (always true)\n            if (u_raster_mask_alpha) {\n            #else\n            {\n            #endif\n                #if defined(TANGRAM_BLEND_TRANSLUCENT) || defined(TANGRAM_BLEND_MULTIPLY)\n                if (_raster_color.a < TANGRAM_EPSILON) {\n                    discard;\n                }\n                #else // TANGRAM_BLEND_OPAQUE\n                if (_raster_color.a < 1. - TANGRAM_EPSILON) {\n                    discard;\n                }\n                // only allow full alpha in opaque blend mode (avoids artifacts blending w/canvas tile background)\n                _raster_color.a = 1.;\n                #endif\n            }\n            #endif\n        #endif\n\n        color *= _raster_color; // multiplied to tint texture color\n    #endif\n\n    // Apply line texture\n    #ifdef TANGRAM_EXTRUDE_LINES\n    { // enclose in scope to avoid leakage of internal variables\n        if (u_has_line_texture) {\n            vec2 _line_st = vec2(v_texcoord.x, fract(v_texcoord.y / u_texture_ratio));\n            vec4 _line_color = texture2D(u_texture, _line_st);\n\n            if (_line_color.a < TANGRAM_ALPHA_TEST) {\n                #if defined(TANGRAM_BLEND_OPAQUE)\n                    // use discard when alpha blending is unavailable\n                    if (u_dash_background_color.a < 1. - TANGRAM_EPSILON) {\n                        discard;\n                    }\n                    color = vec4(u_dash_background_color.rgb, 1.); // only allow full alpha in opaque blend mode\n                #else\n                    // use alpha channel when blending is available\n                    color = vec4(u_dash_background_color.rgb, color.a * step(TANGRAM_EPSILON, u_dash_background_color.a));\n                #endif\n            }\n            else {\n                color *= _line_color;\n            }\n        }\n    }\n    #endif\n\n    // First, get normal from raster tile (if applicable)\n    #ifdef TANGRAM_RASTER_TEXTURE_NORMAL\n        normal = normalize(sampleRaster(0).rgb * 2. - 1.);\n    #endif\n\n    // Second, alter normal with normal map texture (if applicable)\n    #if defined(TANGRAM_LIGHTING_FRAGMENT) && defined(TANGRAM_MATERIAL_NORMAL_TEXTURE)\n        calculateNormal(normal);\n    #endif\n\n    // Normal modification applied here for fragment lighting or no lighting,\n    // and in vertex shader for vertex lighting\n    #if !defined(TANGRAM_LIGHTING_VERTEX)\n        #pragma tangram: normal\n    #endif\n\n    // Color modification before lighting is applied\n    #pragma tangram: color\n\n    #if defined(TANGRAM_LIGHTING_FRAGMENT)\n        // Calculate per-fragment lighting\n        color = calculateLighting(v_position.xyz - u_eye, normal, color);\n    #elif defined(TANGRAM_LIGHTING_VERTEX)\n        // Apply lighting intensity interpolated from vertex shader\n        color *= v_lighting;\n    #endif\n\n    // Post-processing effects (modify color after lighting)\n    #pragma tangram: filter\n\n    gl_FragColor = color;\n}\n",os=Object.create(go);Object.assign(os,{name:"polygons",built_in:!0,vertex_shader_src:ns,fragment_shader_src:is,selection:!0,init:function(){go.init.apply(this,arguments),this.defines.TANGRAM_NORMAL_ATTRIBUTE=!0,this.defines.TANGRAM_TEXTURE_COORDS=this.texcoords;},_parseFeature:function(e,t,r){var n=this.feature_style;return n.color=this.parseColor(t.color,r),n.color?(n.alpha=Di.evalCachedProperty(t.alpha,r),n.variant=t.variant,n.z=Di.evalCachedDistanceProperty(t.z,r)||Di.defaults.z,n.z*=ui.height_scale,n.extrude=Di.evalProperty(t.extrude,r),n.extrude&&(!0===n.extrude?(n.height=e.properties.height||Di.defaults.height,n.min_height=e.properties.min_height||Di.defaults.min_height):"number"==typeof n.extrude?(n.height=n.extrude,n.min_height=0):Array.isArray(n.extrude)&&(n.min_height=n.extrude[0],n.height=n.extrude[1]),n.height*=ui.height_scale,n.min_height*=ui.height_scale),n.tile_edges=t.tile_edges,n):null},_preprocess:function(e){return e.color=Di.createColorPropertyCache(e.color),e.alpha=Di.createPropertyCache(e.alpha),e.z=Di.createPropertyCache(e.z,Di.parseUnits),this.computeVariant(e),e},computeVariant:function(e){var t=e.interactive?1:0,r=null!=e.extrude?1:0,n=this.texcoords?1:0,i=this.getBlendOrderForDraw(e),o=[t,r,n,i].join("/");e.variant=o,null==this.variants[o]&&(this.variants[o]={key:o,blend_order:i,mesh_order:0,selection:t,normal:r,texcoords:n});},vertexLayoutForMeshVariant:function(e){if(null==this.vertex_layouts[e.key]){var t=[{name:"a_position",size:4,type:Ki.SHORT,normalized:!1},{name:"a_normal",size:3,type:Ki.BYTE,normalized:!0,static:e.normal?null:[0,0,1]},{name:"a_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0},{name:"a_selection_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0,static:e.selection?null:[0,0,0,0]},{name:"a_texcoord",size:2,type:Ki.UNSIGNED_SHORT,normalized:!0,static:e.texcoords?null:[0,0]}];this.addCustomAttributesToAttributeList(t),this.vertex_layouts[e.key]=new Ro(t);}return this.vertex_layouts[e.key]},meshVariantTypeForDraw:function(e){return this.variants[e.variant]},makeVertexTemplate:function(e,t){var r=0;return this.vertex_template[r++]=0,this.vertex_template[r++]=0,this.vertex_template[r++]=e.z||0,this.vertex_template[r++]=this.scaleOrder(e.order),t.variant.normal&&(this.vertex_template[r++]=0,this.vertex_template[r++]=0,this.vertex_template[r++]=127),this.vertex_template[r++]=255*e.color[0],this.vertex_template[r++]=255*e.color[1],this.vertex_template[r++]=255*e.color[2],this.vertex_template[r++]=255*(null!=e.alpha?e.alpha:e.color[3]),t.variant.selection&&(this.vertex_template[r++]=255*e.selection_color[0],this.vertex_template[r++]=255*e.selection_color[1],this.vertex_template[r++]=255*e.selection_color[2],this.vertex_template[r++]=255*e.selection_color[3]),t.variant.texcoords&&(this.vertex_template[r++]=0,this.vertex_template[r++]=0),this.addCustomAttributesToVertexTemplate(e,r),this.vertex_template},buildPolygons:function(e,t,r){var n=this.getTileMesh(r.tile,this.meshVariantTypeForDraw(t)),i=n.vertex_data,o=i.vertex_layout,s=this.makeVertexTemplate(t,n),a={texcoord_index:o.index.a_texcoord,texcoord_normalize:65535,remove_tile_edges:!t.tile_edges,tile_edge_tolerance:ui.tile_scale*r.tile.pad_scale*4,winding:r.winding};return t.extrude&&t.height?function(e,t,r,n,i,o,s,a,l){var u=l.remove_tile_edges,c=l.tile_edge_tolerance,f=l.texcoord_index,h=l.texcoord_scale,d=l.texcoord_normalize,_=l.winding,p=t+(n||0),m=t+r;o[2]=m;var v=rs(e,i,o,{texcoord_index:f,texcoord_scale:h,texcoord_normalize:d}),g=i.vertex_elements,y=i.vertex_count;if(f){d=d||1;var x=h||So,b=x[0],A=x[1],T=x[2],w=x[3],E=[[b,w],[b,A],[T,A],[T,w]];}for(var R=e.length,M=0;M<R;M++)for(var S=e[M],z=0;z<S.length;z++)for(var N=S[z],P=0;P<N.length-1;P++)if(!u||!zo(N[P],N[P+1],c)){var k=void 0,O=void 0;"CCW"===_?(k=P,O=P+1):(k=P+1,O=P);var L=[[N[O][0],N[O][1],m],[N[O][0],N[O][1],p],[N[k][0],N[k][1],p],[N[k][0],N[k][1],m]],I=no.normalize([N[O][0]-N[k][0],N[O][1]-N[k][1],0]),F=no.cross(ts,I);o[s+0]=F[0]*a,o[s+1]=F[1]*a,o[s+2]=F[2]*a;for(var U=0;U<L.length;U++)o[0]=L[U][0],o[1]=L[U][1],o[2]=L[U][2],f&&(o[f+0]=E[U][0]*d,o[f+1]=E[U][1]*d),i.addVertex(o);g.push(y+0),g.push(y+1),g.push(y+2),g.push(y+2),g.push(y+3),g.push(y+0),y+=4,v+=2;}return v}(e,t.z,t.height,t.min_height,i,s,o.index.a_normal,127,a):rs(e,i,s,a)}});var ss=/"/g,as=function(e,t,r,n){var i=String(N(e)),o="<"+t;return ""!==r&&(o+=" "+r+'="'+String(n).replace(ss,"&quot;")+'"'),o+">"+i+"</"+t+">"},ls=function(e,t){var r={};r[e]=t(as),D(D.P+D.F*f(function(){var t=""[e]('"');return t!==t.toLowerCase()||t.split('"').length>3}),"String",r);};ls("sub",function(e){return function(){return e(this,"sub","","")}});var us=[0,0],cs={butt:0,square:1,round:2},fs={miter:0,bevel:1,round:2},hs=3,ds=5,_s=65535,ps=ui.tile_scale,ms=[0,0],vs=[1,0],gs=[.5,0];function ys(e,t){if(!(e.length<2)){var r,n,i,o,s=t.join_type,a=t.cap_type,l=t.closed_polygon,u=t.remove_tile_edges,c=t.tile_edge_tolerance,f=t.v_scale,h=t.miter_len_sq,d=null!=t.texcoord_index,_=0;if(l&&s===fs.miter){var p=function(e){if(No(e[0]))return 0;for(var t=0;t<e.length;t++){var r=e[e.length-1-t];if(No(r))return e.length-1-t}return 0}(e);if(0!==p){var m=function(e,t){for(var r=[],n=0;n<e.length;n++){var i=(n+t)%e.length;0!==i&&r.push(e[i]);}return r.push(r[0]),r}(e,p);return t.extra_lines=t.extra_lines||[],void t.extra_lines.push(m)}}var v=0,g=e.length-1,y=0;for(r=e[v],n=e[v+1];no.isEqual(r,n);)if(r=n,n=e[++v+1],y++,v===e.length-1)return;for(;no.isEqual(e[g],e[g-1]);)if(y++,0===--g)return;if(!(e.length<2+y))if(o=no.normalize(no.perp(r,n)),u&&zo(r,n,c)){var x=xs(e,v,c);x&&(t.extra_lines=t.extra_lines||[],t.extra_lines.push(x));}else{l?function(e,t,r,n,i){if(void 0===n||No(e))Es(e,r,r,1,0,i,1),Es(e,r,r,0,0,i,-1);else{n===fs.miter?As(0,e,t,r,i.miter_len_sq,!0,i):Ts(n,0,e,t,r,!0,i);}}(r,i=no.normalize(no.perp(e[g-1],r)),o,s,t):(No(r)||(Ss(r,_,o,a,!0,t),d&&a!==cs.butt&&(_+=.5*f*t.texcoord_width)),Es(r,o,o,1,_,t,1),Es(r,o,o,0,_,t,-1)),d&&(_+=f*no.length(no.sub(n,r)));for(var b=v+1;b<g;b++){var A=b,T=b+1;if(r=e[A],n=e[T],!no.isEqual(r,n)){if(u&&zo(r,n,c)){Es(r,o,o,1,_,t,1),Es(r,o,o,0,_,t,-1),ws(1,t);var w=xs(e,A+1,c);return void(w&&(t.extra_lines=t.extra_lines||[],t.extra_lines.push(w)))}i=o,o=no.normalize(no.perp(r,n)),s===fs.miter?As(_,r,i,o,h,!1,t):Ts(s,_,r,i,o,!1,t),d&&(_+=f*no.length(no.sub(n,r)));}}r=n,i=o,l?function(e,t,r,n,i,o){if(No(e))Es(e,t,t,1,i,o,1),Es(e,t,t,0,i,o,-1),ws(1,o);else{var s=bs(t,r);n===fs.miter&&no.lengthSq(s)>o.miter_len_sq&&(n=fs.bevel),n===fs.miter?(Es(e,s,t,1,i,o,1),Es(e,s,t,0,i,o,-1),ws(1,o)):(Es(e,t,t,1,i,o,1),Es(e,t,t,0,i,o,-1),ws(1,o));}}(r,i,o=no.normalize(no.perp(r,e[1])),s,_,t):(Es(r,i,o,1,_,t,1),Es(r,i,o,0,_,t,-1),ws(1,t),No(r)||Ss(r,_,i,a,!1,t));}}}function xs(e,t,r){for(var n=t;e[n+1]&&zo(e[n],e[n+1],r);)n++;return e.length-n>=2&&e.slice(n)}function bs(e,t){var r=no.normalize(no.add(e,t)),n=2/(1+Math.abs(no.dot(e,r)));return no.mult(r,n*n)}function As(e,t,r,n,i,o,s){var a=bs(r,n);no.lengthSq(a)>i?Ts(fs.bevel,e,t,r,n,o,s):(Es(t,a,a,1,e,s,1),Es(t,a,a,0,e,s,-1),o||ws(1,s));}function Ts(e,t,r,n,i,o,s){var a=bs(n,i),l=i[0]*n[1]-i[1]*n[0]>0;null!=s.texcoord_index&&(ms[1]=t,vs[1]=t),l?(Es(r,a,a,1,t,s,1),Es(r,n,a,0,t,s,-1),o||ws(1,s),Ms(r,no.neg(n),a,no.neg(i),a,ms,vs,ms,!1,e===fs.bevel,s),Es(r,a,a,1,t,s,1),Es(r,i,a,0,t,s,-1)):(Es(r,n,a,1,t,s,1),Es(r,a,a,0,t,s,-1),o||ws(1,s),Ms(r,n,no.neg(a),i,a,vs,ms,vs,!1,e===fs.bevel,s),Es(r,i,a,1,t,s,1),Es(r,a,a,0,t,s,-1));}function ws(e,t){for(var r=t.vertex_data.vertex_elements,n=t.vertex_data.vertex_count-2*e-2,i=0;i<e;i++)r.push(n+2*i+2),r.push(n+2*i+1),r.push(n+2*i+0),r.push(n+2*i+2),r.push(n+2*i+3),r.push(n+2*i+1),t.geom_count+=2;}function Es(e,t,r,n,i,o,s){var a=o.vertex_template,l=o.vertex_data;a[0]=e[0],a[1]=e[1];var u=o.half_width*s;a[o.extrude_index+0]=t[0]*u,a[o.extrude_index+1]=t[1]*u,o.offset&&(a[o.offset_index+0]=r[0]*o.offset,a[o.offset_index+1]=r[1]*o.offset),null!=o.texcoord_index&&(a[o.texcoord_index+0]=n*_s,a[o.texcoord_index+1]=i*_s),l.addVertex(a);}var Rs=[0,0];function Ms(e,t,r,n,i,o,s,a,l,u,c){for(var f=t[0]*n[1]-t[1]*n[0],h=no.dot(t,n),d=Math.atan2(f,h);d>=Math.PI;)d-=2*Math.PI;if(u)_=1;else{var _=function(e,t){e<0&&(e=-e);var r=t>2*ds?Math.log2(t/ds):1;return Math.ceil(e/Math.PI*r)}(d,c.half_width);if(_<1)return}var p=c.vertex_data.vertex_count,m=c.vertex_data.vertex_elements;Es(e,r,i,s[0],s[1],c,1),Es(e,t,i,o[0],o[1],c,1);var v=t,g=null!=c.texcoord_index;if(g)if(l)var y=no.sub(o,s);else{Rs=no.copy(o);var x=no.div(no.sub(a,o),_);}var b,A,T=d/_,w=d<0?-1:1;f>0?(b=2,A=1):(b=1,A=2);for(var E=0;E<_;E++)0===E&&d<0&&(v=no.neg(v)),v=no.rot(v,T),g&&(l?(y=no.rot(y,T),Rs[0]=y[0]+s[0],Rs[1]=y[1]*c.texcoord_width*c.v_scale+s[1]):Rs=no.add(Rs,x)),Es(e,v,i,Rs[0],Rs[1],c,w),m.push(p+E+b),m.push(p),m.push(p+E+A);}function Ss(e,t,r,n,i,o){var s=no.neg(r),a=null!=o.texcoord_index;switch(n){case cs.square:var l;i?(l=[r[1],-r[0]],Es(e,no.add(r,l),r,1,t,o,1),Es(e,no.add(s,l),r,0,t,o,1),a&&(t+=.5*o.texcoord_width*o.v_scale),Es(e,r,r,1,t,o,1),Es(e,s,r,0,t,o,1)):(l=[-r[1],r[0]],Es(e,r,r,1,t,o,1),Es(e,s,r,0,t,o,1),a&&(t+=.5*o.texcoord_width*o.v_scale),Es(e,no.add(r,l),r,1,t,o,1),Es(e,no.add(s,l),r,0,t,o,1)),ws(1,o);break;case cs.round:var u,c,f=ms,h=vs,d=gs;i?(u=r,c=s,a&&(t+=.5*o.texcoord_width*o.v_scale,f=vs,h=ms,d=gs)):(u=s,c=r),a&&(ms[1]=t,vs[1]=t,gs[1]=t),Ms(e,u,us,c,r,f,d,h,!0,!1,o);break;case cs.butt:return}}var zs=[255,255,255,255],Ns=[0,0,0,0];var Ps=Object.create(go);Object.assign(Ps,{name:"lines",built_in:!0,vertex_shader_src:ns,fragment_shader_src:is,selection:!0,init:function(){go.init.apply(this,arguments),this.defines.TANGRAM_EXTRUDE_LINES=!0,this.defines.TANGRAM_TEXTURE_COORDS=!0,this.outline_feature_style={},this.inline_feature_style=this.feature_style,this.dash_textures={};},calcDistance:function(e,t){return Di.evalCachedDistanceProperty(e,t)||0},calcDistanceNextZoom:function(e,t){t.zoom++;var r=this.calcDistance(e,t);return t.zoom--,r},calcWidth:function(e,t,r){var n=this.calcDistance(e.width,r);if(!(n<0)){var i;if(i=e.next_width?this.calcDistanceNextZoom(e.next_width,r):n/2,0===n&&0===i||i<0)return !1;if(t.width_unscaled=n,t.next_width_unscaled=i,e.next_width){var o=.5*(n+(i*=2));t.width=o*r.units_per_meter_overzoom,t.width_scale=1-i/o;}else t.width=n*r.units_per_meter_overzoom,t.width_scale=0;return e.texcoords&&(e.inline_texcoord_width?t.texcoord_width=e.inline_texcoord_width:t.texcoord_width=(t.width_unscaled||t.next_width_unscaled)*r.units_per_meter_overzoom/r.tile.overzoom2),!0}},calcOffset:function(e,t,r){if(e.offset_precalc)t.offset=e.offset_precalc,t.offset_scale=e.offset_scale_precalc;else if(e.offset){var n=this.calcDistance(e.offset,r);if(e.next_offset){var i=2*this.calcDistanceNextZoom(e.next_offset,r);Math.abs(n)>=Math.abs(i)?(t.offset=n*r.units_per_meter_overzoom,t.offset_scale=0!==n?1-i/n:0):(t.offset=i*r.units_per_meter_overzoom,t.offset_scale=0!==i?-1*(1-n/i):0);}else t.offset=n*r.units_per_meter_overzoom,t.offset_scale=0;}else t.offset=0,t.offset_scale=0;},_parseFeature:function(e,t,r){var n=this.feature_style;if(!1!==this.calcWidth(t,n,r)&&(this.calcOffset(t,n,r),n.color=this.parseColor(t.color,r),n.color)){if(n.alpha=Di.evalCachedProperty(t.alpha,r),n.variant=t.variant,n.z=Di.evalCachedDistanceProperty(t.z,r)||Di.defaults.z,n.height=e.properties.height||Di.defaults.height,n.extrude=Di.evalProperty(t.extrude,r),n.extrude&&("number"==typeof n.extrude?n.height=n.extrude:Array.isArray(n.extrude)&&(n.height=n.extrude[1])),n.extrude&&n.height&&(n.z+=n.height),n.z*=ui.height_scale,n.cap=t.cap,n.join=t.join,n.miter_limit=t.miter_limit,n.tile_edges=t.tile_edges,n.outline=n.outline||{width:{},next_width:{},preprocessed:!0},t.outline&&!1!==t.outline.visible&&t.outline.color&&t.outline.width){var i=2*this.calcDistance(t.outline.width,r),o=2*this.calcDistanceNextZoom(t.outline.next_width,r);0===i&&0===o||i<0||o<0?(n.outline.width.value=null,n.outline.next_width.value=null,n.outline.color=null,n.outline.inline_texcoord_width=null,n.outline.texcoords=!1):(n.outline.width.value=i+n.width_unscaled,n.outline.next_width.value=o+n.next_width_unscaled,n.outline.inline_texcoord_width=n.texcoord_width,n.outline.offset_precalc=n.offset,n.outline.offset_scale_precalc=n.offset_scale,n.outline.color=t.outline.color,n.outline.alpha=t.outline.alpha,n.outline.interactive=t.outline.interactive,n.outline.cap=t.outline.cap,n.outline.join=t.outline.join,n.outline.miter_limit=t.outline.miter_limit,n.outline.texcoords=t.outline.texcoords,n.outline.style=t.outline.style,n.outline.variant=t.outline.variant,t.outline.order?n.outline.order=this.parseOrder(t.outline.order,r):n.outline.order=n.order,n.outline.order>n.order&&(n.outline.order=n.order),n.outline.order-=.5);}else n.outline.width.value=null,n.outline.next_width.value=null,n.outline.color=null,n.outline.inline_texcoord_width=null;return n}},_preprocess:function(e){if(e.color=Di.createColorPropertyCache(e.color),e.alpha=Di.createPropertyCache(e.alpha),e.width=Di.createPropertyCache(e.width,Di.parseUnits),e.width&&e.width.type!==Di.CACHE_TYPE.STATIC&&(e.next_width=Di.createPropertyCache(e.width,Di.parseUnits)),e.offset=e.offset&&Di.createPropertyCache(e.offset,Di.parseUnits),e.offset&&e.offset.type!==Di.CACHE_TYPE.STATIC&&(e.next_offset=Di.createPropertyCache(e.offset,Di.parseUnits)),e.z=Di.createPropertyCache(e.z,Di.parseUnits),e.dash=void 0!==e.dash?e.dash:this.dash,e.dash_key=e.dash&&this.dashTextureKey(e.dash),e.dash_background_color=void 0!==e.dash_background_color?e.dash_background_color:this.dash_background_color,e.dash_background_color=e.dash_background_color&&Di.parseColor(e.dash_background_color),e.texture_merged=e.dash_key||(void 0!==e.texture?e.texture:this.texture),e.texcoords=this.texcoords||e.texture_merged?1:0,this.computeVariant(e),e.outline){e.outline.is_outline=!0,e.outline.style=e.outline.style||this.name,e.outline.color=Di.createColorPropertyCache(e.outline.color),e.outline.alpha=Di.createPropertyCache(e.outline.alpha),e.outline.width=Di.createPropertyCache(e.outline.width,Di.parseUnits),e.outline.next_width=Di.createPropertyCache(e.outline.width,Di.parseUnits),e.outline.interactive=null!=e.outline.interactive?e.outline.interactive:e.interactive,e.outline.cap=e.outline.cap||e.cap,e.outline.join=e.outline.join||e.join,e.outline.miter_limit=null!=e.outline.miter_limit?e.outline.miter_limit:e.miter_limit,e.outline.offset=e.offset;var t=this.styles[e.outline.style];t?(e.outline.dash=void 0!==e.outline.dash?e.outline.dash:t.dash,e.outline.texture=void 0!==e.outline.texture?e.outline.texture:t.texture,null!=e.outline.dash?(e.outline.dash_key=e.outline.dash&&this.dashTextureKey(e.outline.dash),e.outline.texture_merged=e.outline.dash_key):null===e.outline.dash?(e.outline.dash_key=null,e.outline.texture_merged=e.outline.texture):null!=e.outline.texture?(e.outline.dash_key=null,e.outline.texture_merged=e.outline.texture):(e.outline.dash=e.dash,e.outline.dash_key=e.outline.dash&&this.dashTextureKey(e.outline.dash),e.outline.texture_merged=e.outline.dash_key),e.outline.dash_background_color=void 0!==e.outline.dash_background_color?e.outline.dash_background_color:t.dash_background_color,e.outline.dash_background_color=void 0!==e.outline.dash_background_color?e.outline.dash_background_color:e.dash_background_color,e.outline.dash_background_color=e.outline.dash_background_color&&Di.parseColor(e.outline.dash_background_color),e.outline.texcoords=t.texcoords||e.outline.texture_merged?1:0,void 0===e.outline.blend_order&&null!=e.blend_order&&(e.outline.blend_order=e.blend_order),t.computeVariant(e.outline)):(Qr({level:"warn",once:!0},"Layer group '"+e.layers.join(", ")+"': line 'outline' specifies non-existent draw style '"+e.outline.style+"' (or maybe the style is defined but is missing a 'base' or has another error), skipping outlines for features matching this layer group"),e.outline=null);}return e},dashTextureKey:function(e){return "__dash_"+JSON.stringify(e)},getDashTexture:function(e){var t=this.dashTextureKey(e);if(null==this.dash_textures[t]){this.dash_textures[t]=!0;var r=function(e,t){void 0===t&&(t={});var r=t.dash_color||zs,n=t.background_color||Ns,i=e,o=t.scale||1;i.length%2==1&&Array.prototype.push.apply(i,i);for(var s=!0,a=[],l=0;l<i.length;l++){for(var u=Math.floor(i[l]*o),c=0;c<u;c++)Array.prototype.push.apply(a,s?r:n);s=!s;}return a.reverse(),{pixels:a=new Uint8Array(a),length:a.length/4}}(e,{scale:20});qn.create(this.gl,t,{data:r.pixels,height:r.length,width:1,filtering:"nearest"});}},endData:function(e){return new Promise(function(t,r){var n,i,o,s;return n=this,Promise.resolve(go.endData.call(this,e)).then(function(e){try{if(i=e){i.uniforms.u_has_line_texture=!1,i.uniforms.u_texture=qn.default,i.uniforms.u_v_scale_adjust=ui.tile_scale,o=[],s=function(e){return new Promise(function(t,r){var s,a,l;if((s=i.meshes[e].variant).texture){if((a=i.meshes[e].uniforms=i.meshes[e].uniforms||{}).u_has_line_texture=!0,a.u_texture=s.texture,a.u_texture_ratio=1,s.dash&&(a.u_v_scale_adjust=20*ui.tile_scale,a.u_dash_background_color=s.dash_background_color||[0,0,0,0]),s.dash_key&&null==n.dash_textures[s.dash_key]){n.dash_textures[s.dash_key]=!0;var u=function(){try{return f.call(this)}catch(e){return r(e)}}.bind(this),c=function(e){try{return Qr("trace",n.name+": line dash texture create failed because style no longer on main thread"),u()}catch(e){return r(e)}};try{return Promise.resolve(Hr.postMessage(n.main_thread_target+".getDashTexture",s.dash)).then(function(e){try{return u()}catch(e){return c()}},c)}catch(e){c();}}function f(){return null==qn.textures[s.texture]?o.push(qn.syncTexturesToWorker([s.texture]).then(function(e){var t=e[s.texture];t&&(a.u_texture_ratio=t.height/t.width);})):(l=qn.textures[s.texture],a.u_texture_ratio=l.height/l.width),h.call(this)}return f.call(this)}function h(){return t()}return h.call(this)})};var a,l,u,c=[];for(a in i.meshes)c.push(a);function f(){return c.length?(l=c.shift(),Promise.resolve(s(l)).then(function(e){try{return f}catch(e){return r(e)}},r)):[1]}return (u=function(e){for(;e;){if(e.then)return void e.then(u,r);try{if(e.pop){if(e.length)return e.pop()?h.call(this):e;e=f;}else e=e.call(this);}catch(e){return r(e)}}}.bind(this))(f);function h(){return Promise.resolve(Promise.all(o)).then(function(e){try{return d.call(this)}catch(e){return r(e)}}.bind(this),r)}}function d(){return t(i)}return d.call(this)}catch(e){return r(e)}}.bind(this),r)}.bind(this))},computeVariant:function(e){var t=e.offset?1:0;t+="/"+e.texcoords,t+="/"+(e.interactive?1:0),t+="/"+(e.extrude||e.z?1:0),t+="/"+e.is_outline,e.dash_key&&(t+=e.dash_key,e.dash_background_color&&(t+=e.dash_background_color)),e.texture_merged&&(t+=e.texture_merged);var r=this.getBlendOrderForDraw(e);t=Jn(t+="/"+r),e.variant=t,null==this.variants[t]&&(this.variants[t]={key:t,blend_order:r,mesh_order:e.is_outline?0:1,selection:e.interactive?1:0,offset:e.offset?1:0,z_or_offset:e.offset||e.extrude||e.z?1:0,texcoords:e.texcoords,texture:e.texture_merged,dash:e.dash,dash_key:e.dash_key,dash_background_color:e.dash_background_color});},vertexLayoutForMeshVariant:function(e){if(null==this.vertex_layouts[e.key]){var t=[{name:"a_position",size:4,type:Ki.SHORT,normalized:!1},{name:"a_extrude",size:2,type:Ki.SHORT,normalized:!1},{name:"a_offset",size:2,type:Ki.SHORT,normalized:!1,static:e.offset?null:[0,0]},{name:"a_z_and_offset_scale",size:2,type:Ki.SHORT,normalized:!1,static:e.z_or_offset?null:[0,0]},{name:"a_texcoord",size:2,type:Ki.UNSIGNED_SHORT,normalized:!0,static:e.texcoords?null:[0,0]},{name:"a_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0},{name:"a_selection_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0,static:e.selection?null:[0,0,0,0]}];this.addCustomAttributesToAttributeList(t),this.vertex_layouts[e.key]=new Ro(t);}return this.vertex_layouts[e.key]},meshVariantTypeForDraw:function(e){return this.variants[e.variant]},makeVertexTemplate:function(e,t){var r=0;return this.vertex_template[r++]=0,this.vertex_template[r++]=0,this.vertex_template[r++]=1024*e.width_scale,this.vertex_template[r++]=this.scaleOrder(e.order),this.vertex_template[r++]=0,this.vertex_template[r++]=0,t.variant.offset&&(this.vertex_template[r++]=0,this.vertex_template[r++]=0),t.variant.z_or_offset&&(this.vertex_template[r++]=e.z||0,this.vertex_template[r++]=1024*e.offset_scale),t.variant.texcoords&&(this.vertex_template[r++]=0,this.vertex_template[r++]=0),this.vertex_template[r++]=255*e.color[0],this.vertex_template[r++]=255*e.color[1],this.vertex_template[r++]=255*e.color[2],this.vertex_template[r++]=255*(null!=e.alpha?e.alpha:e.color[3]),t.variant.selection&&(this.vertex_template[r++]=255*e.selection_color[0],this.vertex_template[r++]=255*e.selection_color[1],this.vertex_template[r++]=255*e.selection_color[2],this.vertex_template[r++]=255*e.selection_color[3]),this.addCustomAttributesToVertexTemplate(e,r),this.vertex_template},buildLines:function(e,t,r,n){if(this.feature_style=this.outline_feature_style,t.outline&&null!=t.outline.color&&null!=t.outline.width.value){var i=this.styles[t.outline.style];i&&i.addFeature(r.feature,t.outline,r);}this.feature_style=this.inline_feature_style;var o=this.getTileMesh(r.tile,this.meshVariantTypeForDraw(t)),s=o.vertex_data,a=s.vertex_layout;return function(e,t,r,n,i,o,s,a){var l,u=t.cap?cs[t.cap]:cs.butt,c=t.join?fs[t.join]:fs.miter;if(c===fs.miter)var f=t.miter_limit||hs,h=f*f;i.a_texcoord&&(l=1/(t.texcoord_width*ps));for(var d={closed_polygon:o,remove_tile_edges:s,tile_edge_tolerance:a,miter_len_sq:h,join_type:c,cap_type:u,vertex_data:r,vertex_template:n,half_width:t.width/2,extrude_index:i.a_extrude,offset_index:i.a_offset,v_scale:l,texcoord_index:i.a_texcoord,texcoord_width:t.texcoord_width,offset:t.offset,geom_count:0},_=0;_<e.length;_++)ys(e[_],d);if(d.extra_lines)for(var p=0;p<d.extra_lines.length;p++)ys(d.extra_lines[p],d);return d.geom_count}(e,t,s,this.makeVertexTemplate(t,o),a.index,n&&n.closed_polygon,!t.tile_edges&&n&&n.remove_tile_edges,ui.tile_scale*r.tile.pad_scale*2)},buildPolygons:function(e,t,r){for(var n=0,i=0;i<e.length;i++)n+=this.buildLines(e[i],t,r,{closed_polygon:!0,remove_tile_edges:!0});return n}}),D(D.P+D.F*f(function(){return null!==new Date(NaN).toJSON()||1!==Date.prototype.toJSON.call({toISOString:function(){return 1}})}),"Date",{toJSON:function(e){var t=de(this),r=v(t);return "number"!=typeof r||isFinite(r)?t.toISOString():null}}),ls("anchor",function(e){return function(t){return e(this,"a","name",t)}});var ks=128/Math.PI,Os=16384/Math.PI,Ls=64,Is=65535,Fs=128,Us=[0,2,2,0],Ds=[1,1,3,3],Gs=new Array(4);var Cs=["left","top-left","bottom-left"],js=["right","top-right","bottom-right"],Vs=["top","top-left","top-right"],Bs=["bottom","bottom-left","bottom-right"],qs={computeOffset:function(e,t,r,n){if(void 0===n&&(n=null),!r||"center"===r)return e;var i=[e[0],e[1]];return n=n||this.default_buffer,this.isLeftAnchor(r)?(i[0]-=t[0]/2,"left"===r&&(i[0]-=n[0])):this.isRightAnchor(r)&&(i[0]+=t[0]/2,"right"===r&&(i[0]+=n[1])),this.isTopAnchor(r)?(i[1]-=t[1]/2,"top"===r&&(i[1]-=n[2])):this.isBottomAnchor(r)&&(i[1]+=t[1]/2,"bottom"===r&&(i[1]+=n[3])),i},alignForAnchor:function(e){if(e&&"center"!==e){if(this.isLeftAnchor(e))return "right";if(this.isRightAnchor(e))return "left"}return "center"},isLeftAnchor:function(e){return Cs.indexOf(e)>-1},isRightAnchor:function(e){return js.indexOf(e)>-1},isTopAnchor:function(e){return Vs.indexOf(e)>-1},isBottomAnchor:function(e){return Bs.indexOf(e)>-1},default_buffer:[2.5,2.5,1.5,.75],zero_buffer:[0,0,0,0]};function Hs(e,t){return !(e[2]<t[0]||e[0]>t[2]||e[3]<t[1]||e[1]>t[3])}var Xs,Ws,Zs,Ys,$s=[[1,0],[0,1]],Js=[],Ks=[],Qs=function(){function e(e,t,r,n,i){this.dimension=[n/2,i/2],this.angle=r,this.centroid=[e,t],this.quad=null,this.axis_0=null,this.axis_1=null,this.update();}var t=e.prototype;return t.toJSON=function(){return {x:this.centroid[0],y:this.centroid[1],a:this.angle,w:this.dimension[0],h:this.dimension[1]}},t.getExtent=function(){return 0===this.angle?[this.quad[0],this.quad[1],this.quad[4],this.quad[5]]:[Math.min(this.quad[0],this.quad[2],this.quad[4],this.quad[6]),Math.min(this.quad[1],this.quad[3],this.quad[5],this.quad[7]),Math.max(this.quad[0],this.quad[2],this.quad[4],this.quad[6]),Math.max(this.quad[1],this.quad[3],this.quad[5],this.quad[7])]},t.updateAxes=function(){this.axis_0=no.normalize([this.quad[4]-this.quad[6],this.quad[5]-this.quad[7]]),this.axis_1=no.normalize([this.quad[4]-this.quad[2],this.quad[5]-this.quad[3]]);},t.update=function(){var e=this.centroid,t=this.dimension[0],r=this.dimension[1];if(0===this.angle)this.quad=[e[0]-t,e[1]-r,e[0]+t,e[1]-r,e[0]+t,e[1]+r,e[0]-t,e[1]+r],this.axis_0=$s[0],this.axis_1=$s[1];else{var n=Math.cos(this.angle)*t,i=Math.sin(this.angle)*t,o=-Math.sin(this.angle)*r,s=Math.cos(this.angle)*r;this.quad=[e[0]-n-o,e[1]-i-s,e[0]+n-o,e[1]+i-s,e[0]+n+o,e[1]+i+s,e[0]-n+o,e[1]-i+s],this.updateAxes();}},e.projectToAxis=function(e,t,r){var n=e.quad;return Xs=n[0]*t[0]+n[1]*t[1],Ws=n[2]*t[0]+n[3]*t[1],Zs=n[4]*t[0]+n[5]*t[1],Ys=n[6]*t[0]+n[7]*t[1],r[0]=Math.min(Xs,Ws,Zs,Ys),r[1]=Math.max(Xs,Ws,Zs,Ys),r},e.axisCollide=function(t,r,n,i){return e.projectToAxis(t,n,Js),e.projectToAxis(r,n,Ks),!(Ks[0]>Js[1]||Ks[1]<Js[0])&&(e.projectToAxis(t,i,Js),e.projectToAxis(r,i,Ks),!(Ks[0]>Js[1]||Ks[1]<Js[0]))},e.intersect=function(t,r){return e.axisCollide(t,r,t.axis_0,t.axis_1)&&e.axisCollide(t,r,r.axis_0,r.axis_1)},e}(),ea=function(){function e(t,r){void 0===r&&(r={}),this.id=e.nextLabelId(),this.type="",this.size=t,this.layout=r,this.position=null,this.angle=0,this.anchor=Array.isArray(this.layout.anchor)?this.layout.anchor[0]:this.layout.anchor,this.placed=null,this.offset=r.offset,this.unit_scale=this.layout.units_per_pixel,this.aabb=null,this.obb=null,this.align="center",this.throw_away=!1;}var t=e.prototype;return t.toJSON=function(){return {id:this.id,type:this.type,obb:this.obb.toJSON(),position:this.position,angle:this.angle,size:this.size,offset:this.offset,breach:this.breach,may_repeat_across_tiles:this.may_repeat_across_tiles,layout:ta(this.layout)}},t.update=function(){this.align=this.layout.align||qs.alignForAnchor(this.anchor);},t.occluded=function(e,t){var r=this;void 0===t&&(t=null);var n=!1,i=e.aabb,o=e.obb;return i.length>0&&function(e,t,r){for(var n=0;n<t.length&&(!Hs(e,t[n])||null==r(n));n++);}(this.aabb,i,function(e){if(!t||i[e]!==t.aabb)return 0===r.obb.angle&&0===o[e].angle?(n=!0,!0):Qs.intersect(r.obb,o[e])?(n=!0,!0):void 0}),n},t.inTileBounds=function(){return this.aabb[0]>=0&&this.aabb[1]>-ui.tile_scale&&this.aabb[0]<ui.tile_scale&&this.aabb[1]<=0||this.aabb[2]>=0&&this.aabb[3]>-ui.tile_scale&&this.aabb[2]<ui.tile_scale&&this.aabb[3]<=0},t.mayRepeatAcrossTiles=function(){if(this.layout.collide)return !0;var e=this.layout.repeat_distance;return 0!==e&&(Math.abs(this.position[0])<e||Math.abs(this.position[0]-ui.tile_scale)<e||Math.abs(this.position[1])<e||Math.abs(-(this.position[1]-ui.tile_scale))<e)},t.discard=function(e,t){return void 0===t&&(t=null),!!this.throw_away||this.occluded(e,t)},e}();function ta(e){return {priority:e.priority,collide:e.collide,repeat_distance:e.repeat_distance,repeat_group:e.repeat_group,buffer:e.buffer,italic:e.italic}}ea.add=function(e,t){if(e.placed=!0,e.aabb&&(t.aabb.push(e.aabb),t.obb.push(e.obb)),e.aabbs)for(var r=0;r<e.aabbs.length;r++)t.aabb.push(e.aabbs[r]),t.obb.push(e.obbs[r]);},ea.id=0,ea.id_prefix=0,ea.id_multiplier=0,ea.nextLabelId=function(){return ea.id_prefix+ea.id++*ea.id_multiplier},ea.epsilon=.9999;var ra=function(){function e(e,t){this.key=e,this.repeat_dist=t,this.repeat_dist_sq=this.repeat_dist*this.repeat_dist,this.positions=[];}var t=e.prototype;return t.check=function(e){for(var t=e.position,r=0;r<this.positions.length;r++){var n=this.positions[r],i=t[0]-n[0],o=t[1]-n[1];if(i*i+o*o<this.repeat_dist_sq)return !0}},t.add=function(e){e&&e.position&&this.positions.push(e.position);},e.clear=function(e){this.groups[e]={};},e.check=function(e,t,r){if(t.repeat_distance&&t.repeat_group&&this.groups[r][t.repeat_group])return this.groups[r][t.repeat_group].check(e)},e.add=function(t,r,n){r.repeat_distance&&r.repeat_group&&(null==this.groups[n][r.repeat_group]&&(this.groups[n][r.repeat_group]=new e(r.repeat_group,r.repeat_distance*r.repeat_scale)),this.groups[n][r.repeat_group].add(t));},e}();ra.groups={};var na=function(){function e(e,t){this.anchor=e,this.span=t,this.cells={};}var t=e.prototype;return t.addLabel=function(e){var t=this;e.aabb&&this.addLabelBboxes(e,e.aabb),e.aabbs&&e.aabbs.forEach(function(r){return t.addLabelBboxes(e,r)});},t.addLabelBboxes=function(e,t){var r=[Math.max(Math.floor((t[0]-this.anchor.x)/this.span),0),Math.max(Math.floor(-(t[1]-this.anchor.y)/this.span),0),Math.max(Math.floor((t[2]-this.anchor.x)/this.span),0),Math.max(Math.floor(-(t[3]-this.anchor.y)/this.span),0)];e.cells=[];for(var n=r[1];n<=r[3];n++){this.cells[n]=this.cells[n]||{};for(var i=r[0];i<=r[2];i++)this.cells[n][i]=this.cells[n][i]||{aabb:[],obb:[]},e.cells.push(this.cells[n][i]);}},e}(),ia={tiles:{},grid:null,initGrid:function(e){this.grid=null==e?null:new na(e.anchor,e.span);},startTile:function(e,t){var r=void 0===t?{}:t,n=r.apply_repeat_groups,i=void 0===n||n,o=r.return_hidden,s=void 0!==o&&o,a=this.tiles[e]={bboxes:{aabb:[],obb:[]},objects:{},labels:{},styles:{},repeat:i,return_hidden:s};null==a.complete&&(a.complete=new Promise(function(e,t){a.resolve=e,a.reject=t;}));},resetTile:function(e){delete this.tiles[e];},abortTile:function(e){this.tiles[e]&&this.tiles[e].resolve&&this.tiles[e].resolve([]),this.resetTile(e);},addStyle:function(e,t){this.tiles[t].styles[e]=!0;},collide:function(e,t,r){var n=this.tiles[r];if(!n)return Qr("trace","Collision.collide() called with null tile",r,this.tiles,t,e),Promise.resolve([]);for(var i=n.objects,o=0;o<e.length;o++){var s=e[o],a=s.label.layout.priority;i[a]=i[a]||{},i[a][t]=i[a][t]||[],i[a][t].push(s);}return delete n.styles[t],0===Object.keys(n.styles).length&&this.endTile(r),n.complete.then(function(){return n.resolve=null,n.labels[t]||[]})},endTile:function(e){var t=this.tiles[e],r=t.labels;this.grid&&this.addLabelsToGrid(e),t.repeat&&ra.clear(e);for(var n=Object.keys(t.objects).sort(function(e,t){return e-t}),i=0;i<n.length;i++){var o=t.objects[n[i]];if(o)for(var s in o){var a=o[s];r[s]=r[s]||[];for(var l=0;l<a.length;l++){var u=a[l];this.canBePlaced(u,e,u.linked,t)?u.linked?this.canBePlaced(u.linked,e,u,t)?(u.show=!0,(u.label.breach||u.linked.label.breach)&&(u.label.breach=!0,u.linked.label.breach=!0),(u.label.may_repeat_across_tiles||u.linked.label.may_repeat_across_tiles)&&(u.label.may_repeat_across_tiles=!0,u.linked.label.may_repeat_across_tiles=!0),r[s].push(u),this.place(u,e,t),this.place(u.linked,e,t)):t.return_hidden&&(u.show=!1,r[s].push(u)):(u.show=!0,r[s].push(u),this.place(u,e,t)):t.return_hidden&&(u.show=!1,r[s].push(u));}}}delete this.tiles[e],t.resolve();},addLabelsToGrid:function(e){var t=this,r=this.tiles[e];for(var n in r.objects){var i=r.objects[n];if(i)for(var o in i){i[o].forEach(function(e){return t.grid.addLabel(e.label)});}}},canBePlaced:function(e,t,r,n){void 0===r&&(r=null);var i=(void 0===n?{}:n).repeat,o=void 0===i||i,s=e.label,a=e.label.layout;if(null!=s.placed)return s.placed;var l=!a.collide;if(l||(l=this.grid&&s.cells?s.cells.reduce(function(e,t){return e&&s.discard(t,r&&r.label)&&(e=!1),e},!0):!s.discard(this.tiles[t].bboxes,r&&r.label)),l){if(!o||!ra.check(s,a,t))return !0;s.placed=!1;}else a.collide&&(s.placed=!1);return s.placed},place:function(e,t,r){var n=e.label,i=r.repeat,o=void 0===i||i;null==n.placed&&(o&&ra.add(n,n.layout,t),this.grid&&n.cells?n.cells.forEach(function(e){return ea.add(n,e)}):ea.add(n,this.tiles[t].bboxes));}},oa=function(e){function t(t,r,n,i){var o;return void 0===i&&(i=0),(o=e.call(this,r,n)||this).type="point",o.position=[t[0],t[1]],o.angle=i,o.parent=o.layout.parent,o.update(),o.start_anchor_index=1,o.degenerate=!(o.size[0]||o.size[1]||o.layout.buffer[0]||o.layout.buffer[1]),o.throw_away=!1,o}Or(t,e);var r=t.prototype;return r.update=function(){e.prototype.update.call(this),this.computeOffset(),this.updateBBoxes();},r.computeOffset=function(){if(this.offset=[this.layout.offset[0],this.layout.offset[1]],this.parent){var e=this.parent;this.offset=qs.computeOffset(this.offset,e.size,e.anchor,qs.zero_buffer),this.offset=qs.computeOffset(this.offset,e.size,this.anchor,qs.zero_buffer),e.offset!==Di.zeroPair&&(this.offset===Di.zeroPair?this.offset=e.offset:(this.offset[0]+=e.offset[0],this.offset[1]+=e.offset[1]));}this.offset=qs.computeOffset(this.offset,this.size,this.anchor);},r.updateBBoxes=function(){var e=(this.size[0]+2*this.layout.buffer[0])*this.unit_scale*ea.epsilon,t=(this.size[1]+2*this.layout.buffer[1])*this.unit_scale*ea.epsilon;this.layout.italic&&(e+=5*this.unit_scale),this.obb=new Qs(this.position[0]+this.offset[0]*this.unit_scale,this.position[1]-this.offset[1]*this.unit_scale,-this.angle,e,t),this.aabb=this.obb.getExtent(),this.inTileBounds&&(this.breach=!this.inTileBounds()),this.mayRepeatAcrossTiles&&(this.may_repeat_across_tiles=this.mayRepeatAcrossTiles());},r.discard=function(t,r){if(void 0===r&&(r=null),this.degenerate)return !1;if(e.prototype.discard.call(this,t,r)){if(Array.isArray(this.layout.anchor))for(var n=this.start_anchor_index;n<this.layout.anchor.length;n++)if(this.anchor=this.layout.anchor[n],this.update(),!e.prototype.discard.call(this,t,r))return !1;return !0}return !1},t}(ea);oa.PLACEMENT={VERTEX:0,MIDPOINT:1,SPACED:2,CENTROID:3};var sa=oa.PLACEMENT,aa=80;function la(e,t,r){var n=[],i=r.placement,o=Math.max(t[0],t[1])*r.placement_min_length_ratio*r.units_per_pixel;if(i===sa.SPACED){var s=function(e,t,r){var n=r.units_per_pixel,i=(r.placement_spacing||aa)*n,o=function(e){for(var t=0,r=0;r<e.length-1;r++)t+=ca(e[r],e[r+1]);return t}(e);if(o<=t)return !1;for(var s=Math.max(Math.floor(o/i),1),a=[],l=[],u=.5*(o-(s-1)*i),c=0;c<s;c++){var f=fa(e,u,t,r),h=f.position,d=f.angle;null!=h&&null!=d&&(a.push(h),l.push(d)),u+=i;}return {positions:a,angles:l}}(e,o,r);if(!s)return [];for(var a=s.positions,l=s.angles,u=0;u<a.length;u++){var c=a[u],f=l[u];!0!==r.tile_edges&&No(c)||n.push(new oa(c,t,r,f));}}else if(i===sa.VERTEX){for(var h,d,_=0;_<e.length-1;_++)if(h=e[_],d=e[_+1],!0===r.tile_edges||!No(h)){var p=ua(h,d,r.angle);n.push(new oa(h,t,r,p));}var m=ua(h,d,r.angle);n.push(new oa(d,t,r,m));}else if(i===sa.MIDPOINT)for(var v=0;v<e.length-1;v++){var g=e[v],y=e[v+1],x=[.5*(g[0]+y[0]),.5*(g[1]+y[1])];if((!0===r.tile_edges||!No(x))&&(!o||ca(g,y)>o)){var b=ua(g,y,r.angle);n.push(new oa(x,t,r,b));}}return n}function ua(e,t,r){return void 0===r&&(r=0),"auto"===r?Math.atan2(t[0]-e[0],t[1]-e[1]):r}function ca(e,t){return Math.sqrt(Math.pow(e[0]-t[0],2)+Math.pow(e[1]-t[1],2))}function fa(e,t,r,n){for(var i,o,s=0,a=0;a<e.length-1;a++){var l=e[a],u=e[a+1],c=ca(l,u);if(!(c<=r)&&(s+=c)>t){i=ha(l,u,s-t),o=ua(l,u,n.angle);break}}return {position:i,angle:o}}function ha(e,t,r){var n=r/ca(e,t);return [n*e[0]+(1-n)*t[0],n*e[1]+(1-n)*t[1]]}var da={key:function(e){return [e.style,e.weight,e.family,e.px_size,e.fill,e.stroke,e.stroke_width,e.transform,e.text_wrap,e.max_lines,e.supersample,nn.device_pixel_ratio].join("/")},defaults:{style:"normal",weight:null,size:"12px",px_size:12,family:"Helvetica",fill:"white",fill_array:[1,1,1,1],text_wrap:15,max_lines:5,align:"center"},compute:function(e,t,r){var n={};t.font=t.font||this.defaults,n.can_articulate=t.can_articulate,n.fill=t.font.fill&&Di.evalCachedColorProperty(t.font.fill,r);var i=Di.evalCachedProperty(t.font.alpha,r);if(null!=i&&(n.fill=[].concat(n.fill?n.fill:this.defaults.fill_array),n.fill[3]=i),n.fill=n.fill&&nn.toCSSColor(n.fill)||this.defaults.fill,n.style=t.font.style||this.defaults.style,n.weight=t.font.weight||this.defaults.weight,t.font.family?(n.family=t.font.family,n.family!==this.defaults.family&&(n.family+=", "+this.defaults.family)):n.family=this.defaults.family,n.transform=t.font.transform,n.supersample=t.supersample_text?1.5:1,n.px_size=Di.evalCachedProperty(t.font.px_size,r)*n.supersample,t.font.stroke&&t.font.stroke.color){if(n.stroke=Di.evalCachedColorProperty(t.font.stroke.color,r),n.stroke){var o=Di.evalCachedProperty(t.font.stroke.alpha,r);null!=o&&(n.stroke=[].concat(n.stroke),n.stroke[3]=o),n.stroke=nn.toCSSColor(n.stroke);}n.stroke_width=Di.evalCachedProperty(t.font.stroke.width,r);}n.font_css=this.fontCSS(n);var s=t.text_wrap;return null==s&&"line"!==ui.geometryType(e.geometry.type)&&(s=!0),!0===s&&(s=this.defaults.text_wrap),n.text_wrap=s,n.max_lines=t.max_lines||this.defaults.max_lines,n},fontCSS:function(e){return [e.style,e.weight,e.px_size+"px",e.family].filter(function(e){return e}).join(" ")}},_a=t(function(e){!function(){function t(e,t){document.addEventListener?e.addEventListener("scroll",t,!1):e.attachEvent("scroll",t);}function r(e){this.a=document.createElement("div"),this.a.setAttribute("aria-hidden","true"),this.a.appendChild(document.createTextNode(e)),this.b=document.createElement("span"),this.c=document.createElement("span"),this.h=document.createElement("span"),this.f=document.createElement("span"),this.g=-1,this.b.style.cssText="max-width:none;display:inline-block;position:absolute;height:100%;width:100%;overflow:scroll;font-size:16px;",this.c.style.cssText="max-width:none;display:inline-block;position:absolute;height:100%;width:100%;overflow:scroll;font-size:16px;",this.f.style.cssText="max-width:none;display:inline-block;position:absolute;height:100%;width:100%;overflow:scroll;font-size:16px;",this.h.style.cssText="display:inline-block;width:200%;height:200%;font-size:16px;max-width:none;",this.b.appendChild(this.h),this.c.appendChild(this.f),this.a.appendChild(this.b),this.a.appendChild(this.c);}function n(e,t){e.a.style.cssText="max-width:none;min-width:20px;min-height:20px;display:inline-block;overflow:hidden;position:absolute;width:auto;margin:0;padding:0;top:-999px;left:-999px;white-space:nowrap;font:"+t+";";}function i(e){var t=e.a.offsetWidth,r=t+100;return e.f.style.width=r+"px",e.c.scrollLeft=r,e.b.scrollLeft=e.b.scrollWidth+100,e.g!==t&&(e.g=t,!0)}function o(e,r){function n(){var e=o;i(e)&&e.a.parentNode&&r(e.g);}var o=e;t(e.b,n),t(e.c,n),i(e);}function s(e,t){var r=t||{};this.family=e,this.style=r.style||"normal",this.weight=r.weight||"normal",this.stretch=r.stretch||"normal";}var a=null,l=null,u=null,c=null;function f(){if(null===u){var e=document.createElement("div");try{e.style.font="condensed 100px sans-serif";}catch(e){}u=""!==e.style.font;}return u}function h(e,t){return [e.style,e.weight,f()?e.stretch:"","100px",t].join(" ")}s.prototype.load=function(e,t){var i=this,s=e||"BESbswy",u=0,f=t||3e3,d=(new Date).getTime();return new Promise(function(e,t){var _;if(null===c&&(c=!!document.fonts),(_=c)&&(null===l&&(l=/OS X.*Version\/10\..*Safari/.test(navigator.userAgent)&&/Apple/.test(navigator.vendor)),_=!l),_){_=new Promise(function(e,t){!function r(){(new Date).getTime()-d>=f?t():document.fonts.load(h(i,'"'+i.family+'"'),s).then(function(t){1<=t.length?e():setTimeout(r,25);},function(){t();});}();});var p=new Promise(function(e,t){u=setTimeout(t,f);});Promise.race([p,_]).then(function(){clearTimeout(u),e(i);},function(){t(i);});}else!function(e){document.body?e():document.addEventListener?document.addEventListener("DOMContentLoaded",function t(){document.removeEventListener("DOMContentLoaded",t),e();}):document.attachEvent("onreadystatechange",function t(){"interactive"!=document.readyState&&"complete"!=document.readyState||(document.detachEvent("onreadystatechange",t),e());});}(function(){function l(){var t;(t=-1!=m&&-1!=v||-1!=m&&-1!=g||-1!=v&&-1!=g)&&((t=m!=v&&m!=g&&v!=g)||(null===a&&(t=/AppleWebKit\/([0-9]+)(?:\.([0-9]+))/.exec(window.navigator.userAgent),a=!!t&&(536>parseInt(t[1],10)||536===parseInt(t[1],10)&&11>=parseInt(t[2],10))),t=a&&(m==y&&v==y&&g==y||m==x&&v==x&&g==x||m==b&&v==b&&g==b)),t=!t),t&&(A.parentNode&&A.parentNode.removeChild(A),clearTimeout(u),e(i));}var c=new r(s),_=new r(s),p=new r(s),m=-1,v=-1,g=-1,y=-1,x=-1,b=-1,A=document.createElement("div");A.dir="ltr",n(c,h(i,"sans-serif")),n(_,h(i,"serif")),n(p,h(i,"monospace")),A.appendChild(c.a),A.appendChild(_.a),A.appendChild(p.a),document.body.appendChild(A),y=c.a.offsetWidth,x=_.a.offsetWidth,b=p.a.offsetWidth,function e(){if((new Date).getTime()-d>=f)A.parentNode&&A.parentNode.removeChild(A),t(i);else{var r=document.hidden;!0!==r&&void 0!==r||(m=c.a.offsetWidth,v=_.a.offsetWidth,g=p.a.offsetWidth,l()),u=setTimeout(e,50);}}(),o(c,function(e){m=e,l();}),n(c,h(i,'"'+i.family+'",sans-serif')),o(_,function(e){v=e,l();}),n(_,h(i,'"'+i.family+'",serif')),o(p,function(e){g=e,l();}),n(p,h(i,'"'+i.family+'",monospace'));});})},e.exports=s;}();}),pa={fonts_loaded:Promise.resolve(),last_loaded:null,loadFonts:function(e){var t=this,r=JSON.stringify(e)===this.last_loaded;return e&&!r&&function(){var r=[],n=function(n){Array.isArray(e[n])?e[n].forEach(function(e){return r.push(t.loadFontFace(n,e))}):r.push(t.loadFontFace(n,e[n]));};for(var i in e)n(i);t.last_loaded=JSON.stringify(e),t.fonts_loaded=Promise.all(r.filter(function(e){return e}));}(),this.fonts_loaded},loadFontFace:function(e,t){return new Promise(function(r,n){var i,o;if(null==t||"object"!=typeof t&&"external"!==t)return r();if(i={family:e},"object"==typeof t){if(Object.assign(i,t),"string"==typeof t.url)return Promise.resolve(this.injectFontFace(i)).then(function(e){try{return s.call(this)}catch(e){return n(e)}}.bind(this),n);function s(){return a.call(this)}return s.call(this)}function a(){var t=function(){try{return r()}catch(e){return n(e)}},s=function(r){try{return Qr("debug","Font face '"+e+"' is NOT available",i),t()}catch(e){return n(e)}};try{return o=new _a(e,i),Promise.resolve(o.load()).then(function(r){try{return Qr("debug","Font face '"+e+"' is available",i),t()}catch(e){return s()}},s)}catch(e){s();}}return a.call(this)}.bind(this))},injectFontFace:function(e){return new Promise(function(t,r){var n,i,o,s,a,l,u,c,f,h,d;if(n=e.family,i=e.url,o=e.weight,s=e.style,void 0===this.supports_native_font_loading&&(this.supports_native_font_loading=void 0!==window.FontFace),a=i,"blob:"===i.slice(0,5))return Promise.resolve(nn.io(i,6e4,"arraybuffer")).then(function(e){try{if(a=e.body,l=new Uint8Array(a),this.supports_native_font_loading)a=l;else{for(u="",c=0;c<l.length;c++)u+=String.fromCharCode(l[c]);a="data:font/opentype;base64,"+btoa(u);}return _.call(this)}catch(e){return r(e)}}.bind(this),r);function _(){return this.supports_native_font_loading?("string"==typeof a?f=new FontFace(n,"url("+encodeURI(a)+")",{weight:o,style:s}):a instanceof Uint8Array&&(f=new FontFace(n,a,{weight:o,style:s})),document.fonts.add(f),Qr("trace","Adding FontFace to document.fonts:",f)):(h="\n                @font-face {\n                    font-family: '"+n+"';\n                    font-weight: "+(o||"normal")+";\n                    font-style: "+(s||"normal")+";\n                    src: url("+encodeURI(a)+");\n                }",(d=document.createElement("style")).appendChild(document.createTextNode("")),document.head.appendChild(d),d.sheet.insertRule(h,0),Qr("trace","Injecting CSS font face:",h)),t()}return _.call(this)}.bind(this))}},ma=new RegExp("[֑-߿‏‫‮יִ-﷽ﹰ-ﻼ]");function va(e){return ma.test(e)}var ga="\0-/:-@[-`{-¿×÷ʹ-˿ -⯿‐-\u2029‬ -⯿",ya=new RegExp("["+ga+"]+");function xa(e){return ya.test(e)}var ba=new RegExp("^["+ga+"؀-ۿ]+"),Aa=new RegExp("["+ga+"آ-إاد-زوٱ-ٷڈ-ڙۄ-ۋۏےۓۮۯ]"),Ta=new RegExp("^[ؐ-ًؚ-ٰٟۖ-ۜ۟-۪ۤۧۨ-ۭ]+"),wa="[̀-֑ͯ-ׇֽֿׁׂׅׄަ-ްऀ-ःऺ-ौॎॏ॑-ॗॢॣঁ-ঃ়া-ৌৗৢৣਁ-ਃ਼-ੌੑઁ-ઃ઼ા-ૌૢૣଁ-ଃ଼ା-ୌୖୗୢୣஂா-்ௗఀ-ఃా-ౌౕౖౢౣಁ-ಃ಼ಾ-ೌೕೖೢೣഁ-ഃാ-ൌൎൗൢൣංඃ්-ෟෲෳัิ-ฺ็-๎ັິ-ຼ່-ໍ༹༘༙༵༷༾༿ཱ-ྃ྆྇ྍ-ྼ࿆ါ-း်-ှၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏႚ-ႝ឴-៑៓ᩕ-ᩞᩡ-᩼᷀-᷿⃐-⃿]",Ea=new RegExp("^.(?:"+wa+"+)?([्্੍્୍్್്྄္្᩠᩿]\\W(?:"+wa+"+)?)*"),Ra={Mongolian:"᠀-᢯"},Ma=Object.keys(Ra).map(function(e){return Ra[e]}).join(""),Sa=new RegExp("["+Ma+"]");var za=2;function Na(e,t,r){var n=t?1:za;if(e.length<n)return [e];var i=e;if(r.segment[i])return r.stats.segment_hits++,r.segment[i];var o=[];if(ba.exec(e)){o=e.split(Aa);for(var s=-1,a=0;a<o.length-1;a++){if(a>0){var l=Ta.exec(o[a]);l&&(o[a]=o[a].substring(l[0].length),o[a-1]+=l[0],s+=l[0].length);}s+=1+o[a].length,o[a]+=e.slice(s,s+1);}e="";}for(;e.length;){for(var u="",c=e,f=0;f<n&&c.length;f++){var h=(Ea.exec(c)||c)[0];u+=h,c=c.substring(h.length);}o.push(u),e=e.substring(u.length);}return t&&o.reverse(),r.stats.segment_misses++,r.segment[i]=o,o}var Pa=function(){function e(e,t,r){void 0===t&&(t=1/0),void 0===r&&(r=1/0),this.width=0,this.height=0,this.lines=[],this.max_lines=t,this.text_wrap=r,this.context=e;}var t=e.prototype;return t.createLine=function(e){return this.lines.length<this.max_lines&&new ka(e,this.text_wrap)},t.push=function(e){if(this.lines.length<this.max_lines){var t=this.context.measureText(e.text).width;return e.width=t,t>this.width&&(this.width=Math.ceil(t)),this.lines.push(e),this.height+=e.height,!0}return this.addEllipsis(),!1},t.advance=function(e,t){return !!this.push(e)&&this.createLine(t)},t.addEllipsis=function(){var t=this.lines[this.lines.length-1],r=Math.ceil(this.context.measureText(e.ellipsis).width);t.append(e.ellipsis),t.width+=r,t.width>this.width&&(this.width=t.width);},t.finish=function(e){e?this.push(e):this.addEllipsis();},e.parse=function(t,r,n,i,o){var s;s="number"==typeof r?t.split(" "):[t];for(var a=new e(o,n,r),l=a.createLine(i),u=0;u<s.length;u++){for(var c=s[u].split("\n"),f=0===u,h=0;h<c.length&&l;h++){var d=c[h];va(d)&&xa(d[d.length-1])&&(d+="‏");var _=f?d:" "+d;if(r&&u>0&&l.exceedsTextwrap(_)){if(!(l=a.advance(l,i)))break;l.append(d),f=!0;}else l.append(_);h<c.length-1&&(l=a.advance(l,i),f=!0);}u===s.length-1&&a.finish(l);}return a},e}();Pa.ellipsis="...";var ka=function(){function e(e,t){void 0===e&&(e=0),void 0===t&&(t=0),this.chars=0,this.text="",this.height=Math.ceil(e),this.text_wrap=t;}var t=e.prototype;return t.append=function(e){this.chars+=e.length,this.text+=e;},t.exceedsTextwrap=function(e){return e.length+this.chars>this.text_wrap},e}(),Oa=function(){function e(){this.createCanvas(),this.vertical_text_buffer=8,this.horizontal_text_buffer=4;}var t=e.prototype;return t.createCanvas=function(){this.canvas=document.createElement("canvas"),this.canvas.style.backgroundColor="transparent",this.context=this.canvas.getContext("2d");},t.resize=function(e,t){this.canvas.width=e,this.canvas.height=t,this.context.clearRect(0,0,e,t);},t.setFont=function(e){var t=e.font_css,r=e.fill,n=e.stroke,i=e.stroke_width,o=e.px_size,s=e.supersample;this.px_size=o;var a=this.context,l=nn.device_pixel_ratio*s;n&&i>0&&(a.strokeStyle=n,a.lineWidth=i*l),a.fillStyle=r,a.font=t,a.miterLimit=2;},t.textSizes=function(e,t){return new Promise(function(r,n){return Promise.resolve(pa.loadFonts()).then(function(i){try{return r(En.add({type:"textSizes",run:this.processTextSizesTask.bind(this),texts:t,tile_id:e,cursor:{styles:Object.keys(t),texts:null,style_idx:null,text_idx:null}}))}catch(e){return n(e)}}.bind(this),n)}.bind(this))},t.processTextSizesTask=function(t){var r,n=t.cursor,i=t.texts;for(n.style_idx=n.style_idx||0;n.style_idx<n.styles.length;){var o=n.styles[n.style_idx];null==n.text_idx&&(n.text_idx=0,n.texts=Object.keys(i[o]));for(var s=i[o],a=!0;n.text_idx<n.texts.length;){var l=n.texts[n.text_idx],u=s[l],c=u.text_settings;if(a&&(this.setFont(c),a=!1),u.size=this.textSize(o,l,c).size,c.can_articulate){var f=!1,h=!1;if(va(l)&&(xa(l)?f=!0:h=!0),u.isRTL=f,u.no_curving=h||(r=l,Sa.test(r)),u.vertical_buffer=this.vertical_text_buffer,u.segment_sizes=[],!u.no_curving){var d=Na(l,f,e.cache);u.segments=d;for(var _=0;_<d.length;_++)u.segment_sizes.push(this.textSize(o,d[_],c).size);}}if(n.text_idx++,!En.shouldContinue(t))return !1}n.text_idx=null,n.style_idx++;}return En.finish(t,i),!0},t.textSize=function(t,r,n){var i=n.transform,o=n.text_wrap,s=n.max_lines,a=n.stroke_width,l=void 0===a?0:a,u=n.supersample;if(e.cache.text[t]=e.cache.text[t]||{},e.cache.text[t][r])return e.cache.stats.text_hits++,e.cache.text[t][r];e.cache.stats.text_misses++,e.cache.text_count++;var c=nn.device_pixel_ratio*u,f=this.applyTextTransform(r,i),h=this.context,d=this.vertical_text_buffer*c,_=c*(l+this.horizontal_text_buffer),p=2*c,m=this.px_size+p,v=Pa.parse(f,o,s,m,h),g=v.height,y=v.width,x=v.lines,b=[y/c,g/c],A=[y+2*_,g+2*d],T=[A[0]/c,A[1]/c];return e.cache.text[t][r]={lines:x,size:{collision_size:b,texture_size:A,logical_size:T,line_height:m}},e.cache.text[t][r]},t.drawTextMultiLine=function(e,t,r,n,i){for(var o=t[0],s=t[1],a=n.stroke,l=n.stroke_width,u=void 0===l?0:l,c=n.transform,f=n.align,h=n.supersample,d=r.line_height,_=s,p=0;p<e.length;p++){var m=e[p];this.drawTextLine(m,[o,_],r,{stroke:a,stroke_width:u,transform:c,align:f,supersample:h},i),_+=d;}if(on.draw_label_collision_boxes){this.context.save();var v=nn.device_pixel_ratio*h,g=v*(this.horizontal_text_buffer+u),y=v*this.vertical_text_buffer,x=r.collision_size;this.context.strokeStyle="blue",this.context.lineWidth=2,this.context.strokeRect(o+g,s+y,v*x[0],v*x[1]),"curved"===i&&this.context.strokeRect(o+r.texture_size[0]+g,s+y,v*x[0],v*x[1]),this.context.restore();}if(on.draw_label_texture_boxes){this.context.save();var b=r.texture_size;this.context.strokeStyle="green",this.context.lineWidth=2,this.context.strokeRect(o+2,s+2,b[0]-4,b[1]-4),"curved"===i&&this.context.strokeRect(o+2+r.texture_size[0],s+2,b[0]-4,b[1]-4),this.context.restore();}},t.drawTextLine=function(e,t,r,n,i){var o=t[0],s=t[1],a=n.stroke,l=n.stroke_width,u=void 0===l?0:l,c=n.transform,f=n.align,h=n.supersample,d=nn.device_pixel_ratio*h;f=f||"center";var _,p=this.vertical_text_buffer*d,m=r.texture_size,v=r.line_height,g=d*(u+this.horizontal_text_buffer),y=this.applyTextTransform(e.text,c);"left"===f?_=o+g:"center"===f?_=o+m[0]/2-e.width/2:"right"===f&&(_=o+m[0]-e.width-g);var x=s+.75*p+v;if(a&&u>0){var b="curved"===i?m[0]:0;this.context.strokeText(y,_+b,x);}this.context.fillText(y,_,x);},t.rasterize=function(e,t,r,n,i){return En.add({type:"rasterizeLabels",run:this.processRasterizeTask.bind(this),cancel:this.cancelRasterizeTask.bind(this),pause_factor:2,user_moving_view:!1,texts:e,textures:t,texture_prefix:n,gl:i,tile_id:r,cursor:{styles:Object.keys(e),texts:null,style_idx:0,text_idx:null,texture_idx:0,texture_resize:!0,texture_names:[]}})},t.processRasterizeTask=function(e){for(var t,r=e.cursor,n=e.texts,i=e.textures;r.texture_idx<e.textures.length;){for(t=i[r.texture_idx],r.texture_resize&&(r.texture_resize=!1,this.resize.apply(this,t.texture_size));r.style_idx<r.styles.length;){var o=r.styles[r.style_idx];null==r.text_idx&&(r.text_idx=0,r.texts=Object.keys(n[o]));for(var s=n[o],a=!0;r.text_idx<r.texts.length;){var l=r.texts[r.text_idx],u=s[l],c=u.text_settings;if(a&&(this.setFont(c),a=!1),c.can_articulate){u.texcoords=u.texcoords||{};for(var f=0;f<u.type.length;f++){var h=u.type[f];if("straight"===h){if(u.textures[f]!==r.texture_idx)continue;var d=u.isRTL?l.split().reverse().join():l,_=t.texcoord_cache[o][d],p=void 0;if(_.texcoord)p=_.texcoord;else{var m=_.texture_position,v=this.textSize(o,d,c),g=v.size,y=v.lines;this.drawTextMultiLine(y,m,g,c,h),p=qn.getTexcoordsForSprite(m,g.texture_size,t.texture_size),_.texcoord=p;}u.texcoords[h]={texcoord:p,texture_id:_.texture_id};}else if("curved"===h){var x=u.segments;u.texcoords.curved=u.texcoords.curved||[],u.texcoords_stroke=u.texcoords_stroke||[];for(var b=0;b<x.length;b++)if(u.textures[f][b]===r.texture_idx){var A=x[b],T=t.texcoord_cache[o][A],w=void 0,E=void 0;if(T.texcoord)w=T.texcoord,E=T.texcoord_stroke,u.texcoords_stroke.push(E);else{var R=T.texture_position,M=this.textSize(o,A,c),S=M.size,z=M.lines;this.drawTextMultiLine(z,R,S,c,h),w=qn.getTexcoordsForSprite(R,S.texture_size,t.texture_size);var N=[R[0]+S.texture_size[0],R[1]];E=qn.getTexcoordsForSprite(N,S.texture_size,t.texture_size),T.texcoord=w,T.texcoord_stroke=E,u.texcoords_stroke.push(E);}u.texcoords.curved.push({texcoord:w,texture_id:T.texture_id});}}}}else{var P=this.textSize(o,l,c).lines;for(var k in u.align)u.align[k].texture_id===r.texture_idx&&(this.drawTextMultiLine(P,u.align[k].texture_position,u.size,{stroke:c.stroke,stroke_width:c.stroke_width,transform:c.transform,supersample:c.supersample,align:k}),u.align[k].texcoords=qn.getTexcoordsForSprite(u.align[k].texture_position,u.size.texture_size,t.texture_size));}if(r.text_idx++,!En.shouldContinue(e))return !1}r.text_idx=null,r.style_idx++;}var O=e.texture_prefix+r.texture_idx;qn.create(e.gl,O,{element:this.canvas,filtering:"linear",UNPACK_PREMULTIPLY_ALPHA_WEBGL:!0}),qn.retain(O),r.texture_names.push(O),r.texture_idx++,r.texture_resize=!0,r.style_idx=0;}return En.finish(e,r.texture_names),!0},t.cancelRasterizeTask=function(e){Qr("trace","RasterizeTask: release textures ["+e.cursor.texture_names.join(", ")+"]"),e.cursor.texture_names.forEach(function(e){return qn.release(e)});},t.setTextureTextPositions=function(e,t){var r={cx:0,cy:0,width:0,height:0,column_width:0,texture_id:0,texcoord_cache:{}},n=[];for(var i in e){var o=e[i];for(var s in o){var a=o[s],l=void 0;if(a.text_settings.can_articulate){a.textures=[],r.texcoord_cache[i]=r.texcoord_cache[i]||{};for(var u=0;u<a.type.length;u++){var c=a.type[u];if("straight"===c){var f=a.isRTL?s.split().reverse().join():s;if(!r.texcoord_cache[i][f]){var h=a.size.texture_size;l=this.placeText(h[0],h[1],i,r,n,t),r.texcoord_cache[i][f]={texture_id:r.texture_id,texture_position:l};}a.textures[u]=r.texture_id;}else if("curved"===c){a.textures[u]=[];for(var d=0;d<a.segment_sizes.length;d++){var _=a.segments[d];if(!r.texcoord_cache[i][_]){var p=a.segment_sizes[d].texture_size,m=2*p[0];l=this.placeText(m,p[1],i,r,n,t),r.texcoord_cache[i][_]={texture_id:r.texture_id,texture_position:l};}a.textures[u].push(r.texture_id);}}}}else{var v=a.size.texture_size;for(var g in a.align)l=this.placeText(v[0],v[1],i,r,n,t),a.align[g].texture_id=r.texture_id,a.align[g].texture_position=l;}}}return r.column_width>0&&r.height>0&&(n[r.texture_id]={texture_size:[r.width,r.height],texcoord_cache:r.texcoord_cache}),n},t.placeText=function(e,t,r,n,i,o){var s;return n.cy+t>o?(n.cx+=n.column_width,n.cy=0,n.column_width=e):n.column_width=Math.max(n.column_width,e),n.cx+n.column_width<=o?(s=[n.cx,n.cy],n.cy+=t,n.height=Math.max(n.height,n.cy),n.width=Math.max(n.width,n.cx+n.column_width)):(i[n.texture_id]={texture_size:[n.width,n.height],texcoord_cache:n.texcoord_cache},n.texcoord_cache={},n.texcoord_cache[r]={},n.texture_id++,n.cx=0,n.cy=t,n.column_width=e,n.width=e,n.height=t,s=[0,0]),s},t.applyTextTransform=function(e,t){return "capitalize"===t?e.replace(/\w\S*/g,function(e){return e.charAt(0).toUpperCase()+e.substr(1)}):"uppercase"===t?e.toUpperCase():"lowercase"===t?e.toLowerCase():e},e.fontPixelSize=function(t){if(null!=t){var r=(t="string"==typeof t?t:String(t)).match(e.font_size_re)||[],n=r[1],i=r[2];return "em"===(i=i||"px")?n*=16:"pt"===i?n/=.75:"%"===i&&(n/=6.25),n=Di.parsePositiveNumber(n),n*=nn.device_pixel_ratio}},e.pruneTextCache=function(){e.cache.text_count>e.cache.text_count_max&&(e.cache.text={},e.cache.text_count=0,Qr("debug","TextCanvas: pruning text cache")),Object.keys(e.cache.segment).length>e.cache.segment_count_max&&(e.cache.segment={},Qr("debug","TextCanvas: pruning segment cache"));},e}();Oa.font_size_re=/((?:[0-9]*\.)?[0-9]+)\s*(px|pt|em|%)?/,Oa.cache={text:{},text_count:0,text_count_max:2e3,segment:{},segment_count_max:2e3,stats:{text_hits:0,text_misses:0,segment_hits:0,segment_misses:0}};var La=0,Ia={resetText:function(){Ue.is_main?this.canvas=new Oa:Ue.is_worker&&(this.texts={});},freeText:function(e){delete this.texts[e.id];},parseTextFeature:function(e,t,r,n){var i=this.parseTextSource(e,t,r);if(null!=i&&""!==i){var o=da.compute(e,t,r),s=da.key(o);this.texts[n.id]=this.texts[n.id]||{};var a=this.texts[n.id][s]=this.texts[n.id][s]||{};if(i instanceof Object){var l=[],u=i.left+"-"+i.right;for(var c in i){var f=i[c];if(f){var h=this.computeTextLayout({},e,t,r,n,f,o,u,c);a[f]||(a[f]={text_settings:o,ref:0}),l.push({draw:t,text:f,text_settings_key:s,layout:h});}}return l.length>0&&l}var d=this.computeTextLayout({},e,t,r,n,i,o);return a[i]||(a[i]={text_settings:o,ref:0}),{draw:t,text:i,text_settings_key:s,layout:d}}},parseTextSource:function(e,t,r){var n,i=t.text_source||"name";if(null==i||Array.isArray(i)||"object"!=typeof i)n=this.parseTextSourceValue(i,e,r);else for(var o in n={},i)n[o]=this.parseTextSourceValue(i[o],e,r);return n},parseTextSourceValue:function(e,t,r){var n;if(Array.isArray(e)){for(var i=0;i<e.length;i++)if("string"==typeof e[i]?n=t.properties[e[i]]:"function"==typeof e[i]&&(n=e[i](r)),n)return n}else"string"==typeof e?n=t.properties[e]:e instanceof Function&&(n=e(r));return n},prepareTextLabels:function(e,t){return new Promise(function(r,n){var i;if(0===Object.keys(this.texts[e.id]||{}).length)return r([]);var o=function(t){try{return ia.abortTile(e.id),r([])}catch(e){return n(e)}};try{return Promise.resolve(Hr.postMessage(this.main_thread_target+".calcTextSizes",e.id,this.texts[e.id])).then(function(n){try{return i=n,e.canceled?(Qr("trace","Style "+this.name+": stop tile build because tile was canceled: "+e.key+", post-calcTextSizes()"),r([])):(this.texts[e.id]=i||[],i?r(this.buildTextLabels(e,t)):(ia.abortTile(e.id),r([])))}catch(e){return o()}}.bind(this),o)}catch(e){o();}}.bind(this))},collideAndRenderTextLabels:function(e,t,r){return new Promise(function(n,i){var o,s,a;return Promise.resolve(this.prepareTextLabels(e,r)).then(function(r){try{return 0===(o=r).length?(ia.collide([],t,e.id),n({})):Promise.resolve(ia.collide(o,t,e.id)).then(function(t){try{if(o=t,e.canceled)return Qr("trace","stop tile build because tile was canceled: "+e.key+", post-collide()"),n({});if(null==(s=this.texts[e.id])||0===o.length)return n({});this.cullTextStyles(s,o),o.forEach(function(e){var t=e.text_settings_key,r=s[t]&&s[t][e.text];r.text_settings.can_articulate?(r.type||(r.type=[]),-1===r.type.indexOf(e.label.type)&&r.type.push(e.label.type)):(r.align=r.align||{},r.align[e.label.align]={});});var r=function(e){try{return n({})}catch(e){return i(e)}};try{return Promise.resolve(Hr.postMessage(this.main_thread_target+".rasterizeTexts",e.id,e.key,s)).then(function(t){try{return a=t,e.canceled?(Qr("trace","stop tile build because tile was canceled: "+e.key+", post-rasterizeTexts()"),n({})):n(Object.assign({labels:o},a))}catch(e){return r()}},r)}catch(e){r();}}catch(e){return i(e)}}.bind(this),i)}catch(e){return i(e)}}.bind(this),i)}.bind(this))},cullTextStyles:function(e,t){for(var r=0;r<t.length;r++){var n=t[r];e[n.text_settings_key][n.text].ref++;}for(var i in e)for(var o in e[i])e[i][o].ref<1&&delete e[i][o];for(var s in e)0===Object.keys(e[s]).length&&delete e[s];},calcTextSizes:function(e,t){return this.canvas.textSizes(e,t)},rasterizeTexts:function(e,t,r){return new Promise(function(n,i){var o,s,a,l;return o=new Oa,s=Math.min(this.max_texture_size,2048),a=o.setTextureTextPositions(r,s),l=["labels",this.name,t,e,La,""].join("-"),La++,Promise.resolve(o.rasterize(r,a,e,l,this.gl)).then(function(e){try{return n((a=e)?{texts:r,textures:a}:{})}catch(e){return i(e)}},i)}.bind(this))},preprocessText:function(e){if(e&&e.font&&"object"==typeof e.font)return e.font.fill=Di.createPropertyCache(e.font.fill),e.font.alpha=Di.createPropertyCache(e.font.alpha),e.font.stroke&&(e.font.stroke.color=Di.createPropertyCache(e.font.stroke.color),e.font.stroke.alpha=Di.createPropertyCache(e.font.stroke.alpha)),e.font.px_size=Di.createPropertyCache(e.font.size||da.defaults.size,Oa.fontPixelSize,Oa.fontPixelSize),e.font.stroke&&null!=e.font.stroke.width&&(e.font.stroke.width=Di.createPropertyCache(e.font.stroke.width,Di.parsePositiveNumber)),e.offset=Di.createPropertyCache(e.offset,function(e){return Array.isArray(e)&&e.map(Di.parseNumber)}),e.buffer=Di.createPropertyCache(e.buffer,function(e){return (Array.isArray(e)?e:[e,e]).map(Di.parsePositiveNumber)}),e.repeat_distance=Di.createPropertyCache(e.repeat_distance,Di.parsePositiveNumber),e},computeTextLayout:function(e,t,r,n,i,o,s,a,l){var u=e||{};return u=this.computeLayout(u,t,r,n,i),null==r.repeat_distance&&(u.repeat_distance="point"===n.geometry?0:ui.tile_size,u.repeat_distance&&(u.repeat_distance*=u.units_per_pixel,u.repeat_scale=1,"function"==typeof r.repeat_group?u.repeat_group=r.repeat_group(n):u.repeat_group=r.repeat_group)),u.repeat_distance&&(a&&(u.repeat_group+="/"+a),u.repeat_group+="/"+o),u.subdiv=i.overzoom2,u.align=r.align,u.italic="normal"!==s.style,"right"===l?u.orientation=1:"left"===l&&(u.orientation=-1),u}};Bn("Float64",8,function(e){return function(t,r,n){return e(this,t,r,n)}});var Fa=function(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e};var Ua=function(e,t,r){var n=new Float64Array(3);return n[0]=e,n[1]=t,n[2]=r,n},Da={normalFromMat4:function(e,t){var r=t[0],n=t[1],i=t[2],o=t[3],s=t[4],a=t[5],l=t[6],u=t[7],c=t[8],f=t[9],h=t[10],d=t[11],_=t[12],p=t[13],m=t[14],v=t[15],g=r*a-n*s,y=r*l-i*s,x=r*u-o*s,b=n*l-i*a,A=n*u-o*a,T=i*u-o*l,w=c*p-f*_,E=c*m-h*_,R=c*v-d*_,M=f*m-h*p,S=f*v-d*p,z=h*v-d*m,N=g*z-y*S+x*M+b*R-A*E+T*w;return N?(N=1/N,e[0]=(a*z-l*S+u*M)*N,e[1]=(l*R-s*z-u*E)*N,e[2]=(s*S-a*R+u*w)*N,e[3]=(i*S-n*z-o*M)*N,e[4]=(r*z-i*R+o*E)*N,e[5]=(n*R-r*S-o*w)*N,e[6]=(p*T-m*A+v*b)*N,e[7]=(m*x-_*T-v*y)*N,e[8]=(_*A-p*x+v*g)*N,e):null},invert:function(e,t){var r=t[0],n=t[1],i=t[2],o=t[3],s=t[4],a=t[5],l=t[6],u=t[7],c=t[8],f=c*s-a*u,h=-c*o+a*l,d=u*o-s*l,_=r*f+n*h+i*d;return _?(_=1/_,e[0]=f*_,e[1]=(-c*n+i*u)*_,e[2]=(a*n-i*s)*_,e[3]=h*_,e[4]=(c*r-i*l)*_,e[5]=(-a*r+i*o)*_,e[6]=d*_,e[7]=(-u*r+n*l)*_,e[8]=(s*r-n*o)*_,e):null}},Ga={multiply:function(e,t,r){var n=t[0],i=t[1],o=t[2],s=t[3],a=t[4],l=t[5],u=t[6],c=t[7],f=t[8],h=t[9],d=t[10],_=t[11],p=t[12],m=t[13],v=t[14],g=t[15],y=r[0],x=r[1],b=r[2],A=r[3];return e[0]=y*n+x*a+b*f+A*p,e[1]=y*i+x*l+b*h+A*m,e[2]=y*o+x*u+b*d+A*v,e[3]=y*s+x*c+b*_+A*g,y=r[4],x=r[5],b=r[6],A=r[7],e[4]=y*n+x*a+b*f+A*p,e[5]=y*i+x*l+b*h+A*m,e[6]=y*o+x*u+b*d+A*v,e[7]=y*s+x*c+b*_+A*g,y=r[8],x=r[9],b=r[10],A=r[11],e[8]=y*n+x*a+b*f+A*p,e[9]=y*i+x*l+b*h+A*m,e[10]=y*o+x*u+b*d+A*v,e[11]=y*s+x*c+b*_+A*g,y=r[12],x=r[13],b=r[14],A=r[15],e[12]=y*n+x*a+b*f+A*p,e[13]=y*i+x*l+b*h+A*m,e[14]=y*o+x*u+b*d+A*v,e[15]=y*s+x*c+b*_+A*g,e},translate:function(e,t,r){var n,i,o,s,a,l,u,c,f,h,d,_,p=r[0],m=r[1],v=r[2];t===e?(e[12]=t[0]*p+t[4]*m+t[8]*v+t[12],e[13]=t[1]*p+t[5]*m+t[9]*v+t[13],e[14]=t[2]*p+t[6]*m+t[10]*v+t[14],e[15]=t[3]*p+t[7]*m+t[11]*v+t[15]):(n=t[0],i=t[1],o=t[2],s=t[3],a=t[4],l=t[5],u=t[6],c=t[7],f=t[8],h=t[9],d=t[10],_=t[11],e[0]=n,e[1]=i,e[2]=o,e[3]=s,e[4]=a,e[5]=l,e[6]=u,e[7]=c,e[8]=f,e[9]=h,e[10]=d,e[11]=_,e[12]=n*p+a*m+f*v+t[12],e[13]=i*p+l*m+h*v+t[13],e[14]=o*p+u*m+d*v+t[14],e[15]=s*p+c*m+_*v+t[15]);return e},scale:function(e,t,r){var n=r[0],i=r[1],o=r[2];return e[0]=t[0]*n,e[1]=t[1]*n,e[2]=t[2]*n,e[3]=t[3]*n,e[4]=t[4]*i,e[5]=t[5]*i,e[6]=t[6]*i,e[7]=t[7]*i,e[8]=t[8]*o,e[9]=t[9]*o,e[10]=t[10]*o,e[11]=t[11]*o,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},perspective:function(e,t,r,n,i){var o=1/Math.tan(t/2),s=1/(n-i);return e[0]=o/r,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=o,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=(i+n)*s,e[11]=-1,e[12]=0,e[13]=0,e[14]=2*i*n*s,e[15]=0,e},lookAt:function(e,t,r,n){var i,o,s,a,l,u,c,f,h,d,_=t[0],p=t[1],m=t[2],v=n[0],g=n[1],y=n[2],x=r[0],b=r[1],A=r[2];if(Math.abs(_-x)<1e-6&&Math.abs(p-b)<1e-6&&Math.abs(m-A)<1e-6)return Fa(e);c=_-x,f=p-b,h=m-A,d=1/Math.sqrt(c*c+f*f+h*h),i=g*(h*=d)-y*(f*=d),o=y*(c*=d)-v*h,s=v*f-g*c,(d=Math.sqrt(i*i+o*o+s*s))?(i*=d=1/d,o*=d,s*=d):(i=0,o=0,s=0);a=f*s-h*o,l=h*i-c*s,u=c*o-f*i,(d=Math.sqrt(a*a+l*l+u*u))?(a*=d=1/d,l*=d,u*=d):(a=0,l=0,u=0);return e[0]=i,e[1]=a,e[2]=c,e[3]=0,e[4]=o,e[5]=l,e[6]=f,e[7]=0,e[8]=s,e[9]=u,e[10]=h,e[11]=0,e[12]=-(i*_+o*p+s*m),e[13]=-(a*_+l*p+u*m),e[14]=-(c*_+f*p+h*m),e[15]=1,e},identity:Fa,copy:function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}},Ca=function(){function e(e,t,r){void 0===r&&(r={}),this.view=t,this.position=r.position,this.zoom=r.zoom;}e.create=function(e,t,r){switch(r.type){case"isometric":return new Va(e,t,r);case"flat":return new Ba(e,t,r);case"perspective":default:return new ja(e,t,r)}};var t=e.prototype;return t.update=function(){},t.setupProgram=function(){},t.updateView=function(){if(this.position||this.zoom){var e={};this.position&&(e={lng:this.position[0],lat:this.position[1],zoom:this.position[2]}),this.zoom&&(e.zoom=this.zoom),this.view.setView(e);}},t.setupMatrices=function(e,t){Ga.multiply(e.model_view32,this.view_matrix,e.model),t.uniform("Matrix4fv","u_modelView",e.model_view32),Da.normalFromMat4(e.normal32,e.model_view32),Da.invert(e.inverse_normal32,e.normal32),t.uniform("Matrix3fv","u_normalMatrix",e.normal32),t.uniform("Matrix3fv","u_inverseNormalMatrix",e.inverse_normal32);},e}(),ja=function(e){function t(t,r,n){var i;return void 0===n&&(n={}),(i=e.call(this,t,r,n)||this).type="perspective",i.focal_length=n.focal_length,i.fov=n.fov,i.focal_length||i.fov||(i.focal_length=[[16,2],[17,2.5],[18,3],[19,4],[20,6]]),i.vanishing_point=n.vanishing_point||[0,0],i.vanishing_point=i.vanishing_point.map(parseFloat),i.vanishing_point_skew=[],i.position_meters=null,i.view_matrix=new Float64Array(16),i.projection_matrix=new Float32Array(16),ti.replaceBlock("camera","\n            uniform mat4 u_projection;\n            uniform vec3 u_eye;\n            uniform vec2 u_vanishing_point;\n\n            void cameraProjection (inout vec4 position) {\n                position = u_projection * position;\n            }"),i}Or(t,e);var r=t.prototype;return r.constrainCamera=function(e){var t=e.view_height,r=e.height,n=e.focal_length,i=e.fov;return r?(n=2*r/t,i=2*Math.atan(1/n)):(n?i=2*Math.atan(1/n):i&&(i=i*Math.PI/180,n=1/Math.tan(i/2)),r=t/2*n),{view_height:t,height:r,focal_length:n,fov:i}},r.updateMatrices=function(){var e=this.view.size.css.height*this.view.meters_per_pixel,t=this.constrainCamera({view_height:e,focal_length:nn.interpolate(this.view.zoom,this.focal_length),fov:nn.interpolate(this.view.zoom,this.fov)}),r=t.height,n=t.fov,i=[this.view.center.meters.x,this.view.center.meters.y,r];this.position_meters=i,Ga.lookAt(this.view_matrix,Ua(i[0],i[1],0),Ua(i[0],i[1],-1),Ua(0,1,0)),Ga.perspective(this.projection_matrix,n,this.view.aspect,1,2*r),this.vanishing_point_skew[0]=this.vanishing_point[0]/this.view.size.css.width,this.vanishing_point_skew[1]=this.vanishing_point[1]/this.view.size.css.height,this.projection_matrix[8]=2*-this.vanishing_point_skew[0],this.projection_matrix[9]=2*-this.vanishing_point_skew[1],Ga.translate(this.projection_matrix,this.projection_matrix,Ua(e/2*this.view.aspect*(2*-this.vanishing_point_skew[0]),e/2*(2*-this.vanishing_point_skew[1]),0)),Ga.translate(this.projection_matrix,this.projection_matrix,Ua(0,0,-r));},r.update=function(){e.prototype.update.call(this),this.updateMatrices();},r.setupProgram=function(e){e.uniform("Matrix4fv","u_projection",this.projection_matrix),e.uniform("3f","u_eye",[0,0,this.position_meters[2]]),e.uniform("2fv","u_vanishing_point",this.vanishing_point_skew);},t}(Ca),Va=function(e){function t(t,r,n){var i;return void 0===n&&(n={}),(i=e.call(this,t,r,n)||this).type="isometric",i.axis=n.axis||{x:0,y:1},2===i.axis.length&&(i.axis={x:i.axis[0],y:i.axis[1]}),i.position_meters=null,i.viewport_height=null,i.view_matrix=new Float64Array(16),i.projection_matrix=new Float32Array(16),ti.replaceBlock("camera","\n            uniform mat4 u_projection;\n            uniform vec3 u_eye;\n            uniform vec2 u_vanishing_point;\n\n            void cameraProjection (inout vec4 position) {\n                position = u_projection * position;\n                // position.xy += position.z * u_isometric_axis;\n\n                // Reverse z for depth buffer so up is negative,\n                // and scale down values so objects higher than one screen height will not get clipped\n                // pull forward slightly to avoid going past far clipping plane\n                position.z = -position.z / 100. + 1. - 0.001;\n            }"),i}Or(t,e);var r=t.prototype;return r.update=function(){e.prototype.update.call(this),this.viewport_height=this.view.size.css.height*this.view.meters_per_pixel;var t=[this.view.center.meters.x,this.view.center.meters.y,this.viewport_height];this.position_meters=t,Ga.identity(this.view_matrix),Ga.translate(this.view_matrix,this.view_matrix,Ua(-t[0],-t[1],0)),Ga.identity(this.projection_matrix),this.projection_matrix[8]=this.axis.x/this.view.aspect,this.projection_matrix[9]=this.axis.y,Ga.scale(this.projection_matrix,this.projection_matrix,Ua(2/this.view.size.meters.x,2/this.view.size.meters.y,2/this.view.size.meters.y));},r.setupProgram=function(e){e.uniform("Matrix4fv","u_projection",this.projection_matrix),e.uniform("3fv","u_eye",[0,0,this.viewport_height]),e.uniform("2fv","u_vanishing_point",[0,0]);},t}(Ca),Ba=function(e){function t(t,r,n){var i;return void 0===n&&(n={}),(i=e.call(this,t,r,n)||this).type="flat",i}return Or(t,e),t.prototype.update=function(){this.axis.x=0,this.axis.y=0,e.prototype.update.call(this);},t}(Va),qa=function(){function e(e,t){Rn(this),this.scene=e,this.createMatrices(),this.zoom=null,this.center=null,this.bounds=null,this.meters_per_pixel=null,this.panning=!1,this.panning_stop_at=0,this.pan_snap_timer=0,this.zoom_direction=0,this.user_input_at=0,this.user_input_timeout=50,this.user_input_active=!1,this.size={css:{},device:{},meters:{}},this.aspect=null,this.buffer=0,this.continuous_zoom="boolean"!=typeof t.continuousZoom||t.continuousZoom,this.wrap=!1!==t.wrapView,this.preserve_tiles_within_zoom=1,this.reset();}var t=e.prototype;return t.reset=function(){this.createCamera();},t.createCamera=function(){var e=this.getActiveCamera();e&&(this.camera=Ca.create(e,this,this.scene.config.cameras[e]),this.camera.updateView());},t.getActiveCamera=function(){if(this.scene.config&&this.scene.config.cameras){for(var e in this.scene.config.cameras)if(this.scene.config.cameras[e].active)return e;var t=Object.keys(this.scene.config.cameras);return t.length&&t[0]}},t.setActiveCamera=function(e){var t=this.getActiveCamera();return t===e?e:(this.scene.config.cameras[e]&&(this.scene.config.cameras[e].active=!0,t&&this.scene.config.cameras[t]&&delete this.scene.config.cameras[t].active),this.scene.updateConfig({rebuild:!1,normalize:!1}),this.getActiveCamera())},t.update=function(){null!=this.camera&&this.ready()&&this.camera.update(),this.pan_snap_timer=(+new Date-this.panning_stop_at)/1e3,this.user_input_active=+new Date-this.user_input_at<this.user_input_timeout;},t.setViewportSize=function(e,t){this.size.css={width:e,height:t},this.size.device={width:Math.round(this.size.css.width*nn.device_pixel_ratio),height:Math.round(this.size.css.height*nn.device_pixel_ratio)},this.aspect=this.size.css.width/this.size.css.height,this.updateBounds();},t.setView=function(e){var t=void 0===e?{}:e,r=t.lng,n=t.lat,i=t.zoom,o=!1;return "number"==typeof r&&"number"==typeof n&&(this.center&&r===this.center.lng&&n===this.center.lat||(o=!0,this.center={lng:r,lat:n})),"number"==typeof i&&i!==this.zoom&&(o=!0,this.setZoom(i)),o&&this.updateBounds(),o},t.setZoom=function(e){var t=this.tile_zoom,r=this.baseZoom(e);this.continuous_zoom||(e=r),r!==t&&(this.zoom_direction=r>t?1:-1),this.zoom=e,this.tile_zoom=r,this.updateBounds(),this.scene.requestRedraw();},t.baseZoom=function(e){return Math.floor(e)},t.setPanning=function(e){this.panning=e,this.panning||(this.panning_stop_at=+new Date);},t.markUserInput=function(){this.user_input_at=+new Date;},t.ready=function(){return "number"==typeof this.size.css.width&&"number"==typeof this.size.css.height&&null!=this.center&&"number"==typeof this.zoom},t.updateBounds=function(){if(this.ready()){this.meters_per_pixel=ui.metersPerPixel(this.zoom),this.size.meters={x:this.size.css.width*this.meters_per_pixel,y:this.size.css.height*this.meters_per_pixel};var e=ui.latLngToMeters([this.center.lng,this.center.lat]);this.center.meters={x:e[0],y:e[1]},this.center.tile=ui.tileForMeters([this.center.meters.x,this.center.meters.y],this.tile_zoom),this.bounds={sw:{x:this.center.meters.x-this.size.meters.x/2,y:this.center.meters.y-this.size.meters.y/2},ne:{x:this.center.meters.x+this.size.meters.x/2,y:this.center.meters.y+this.size.meters.y/2}},this.scene.tile_manager.updateTilesForView(),this.trigger("move"),this.scene.requestRedraw();}},t.findVisibleTileCoordinates=function(){if(!this.bounds)return [];var e=this.tile_zoom,t=ui.tileForMeters([this.bounds.sw.x,this.bounds.sw.y],e),r=ui.tileForMeters([this.bounds.ne.x,this.bounds.ne.y],e),n=[t.x-this.buffer,r.x+this.buffer,r.y-this.buffer,t.y+this.buffer];if(!1===this.wrap){var i=(1<<e)-1;n=n.map(function(e){return Math.min(Math.max(0,e),i)});}for(var o=[],s=n[0];s<=n[1];s++)for(var a=n[2];a<=n[3];a++)o.push(po.coord({x:s,y:a,z:e}));return o},t.pruneTilesForView=function(){var e=this;this.ready()&&this.scene.tile_manager.removeTiles(function(t){if(t.visible||t.isProxy())return !1;if(t.loading&&t.style_z!==e.tile_zoom)return !0;if(Math.abs(t.style_z-e.tile_zoom)>(null!=t.preserve_tiles_within_zoom?t.preserve_tiles_within_zoom:e.preserve_tiles_within_zoom))return !0;var r=e.meters_per_pixel*ui.tile_size,n=po.coordAtZoom(ui.tileForMeters([e.center.meters.x-e.size.meters.x/2-r,e.center.meters.y+e.size.meters.y/2+r],e.tile_zoom),t.coords.z),i=po.coordAtZoom(ui.tileForMeters([e.center.meters.x+e.size.meters.x/2+r,e.center.meters.y-e.size.meters.y/2-r],e.tile_zoom),t.coords.z);return (t.coords.x<n.x||t.coords.x>i.x||t.coords.y<n.y||t.coords.y>i.y)&&(Qr("trace","View: remove tile "+t.key+" (as "+t.coords.key+") for being too far out of visible area ("+n.key+", "+i.key+")"),!0)});},t.createMatrices=function(){this.matrices={},this.matrices.model=new Float64Array(16),this.matrices.model32=new Float32Array(16),this.matrices.model_view=new Float64Array(16),this.matrices.model_view32=new Float32Array(16),this.matrices.normal=new Float64Array(9),this.matrices.normal32=new Float32Array(9),this.matrices.inverse_normal32=new Float32Array(9);},t.setupTile=function(e,t){e.setupProgram(this.matrices,t),this.camera.setupMatrices(this.matrices,t);},t.setupProgram=function(e){e.uniform("2fv","u_resolution",[this.size.device.width,this.size.device.height]),e.uniform("3fv","u_map_position",[this.center.meters.x,this.center.meters.y,this.zoom]),e.uniform("1f","u_meters_per_pixel",this.meters_per_pixel),e.uniform("1f","u_device_pixel_ratio",nn.device_pixel_ratio),e.uniform("1f","u_view_pan_snap_timer",this.pan_snap_timer),e.uniform("1i","u_view_panning",this.panning),this.camera.setupProgram(e);},t.isAnimating=function(){return this.pan_snap_timer<=.5},e}(),Ha=oa.PLACEMENT,Xa=Object.create(go);Object.assign(Xa,Ia),Object.assign(Xa,{name:"points",built_in:!0,vertex_shader_src:"uniform vec2 u_resolution;\nuniform float u_time;\nuniform vec3 u_map_position;\nuniform vec4 u_tile_origin;\nuniform float u_tile_proxy_order_offset;\nuniform bool u_tile_fade_in;\nuniform float u_meters_per_pixel;\nuniform float u_device_pixel_ratio;\nuniform float u_visible_time;\nuniform bool u_view_panning;\nuniform float u_view_pan_snap_timer;\n\nuniform mat4 u_model;\nuniform mat4 u_modelView;\nuniform mat3 u_normalMatrix;\nuniform mat3 u_inverseNormalMatrix;\n\nattribute vec4 a_position;\nattribute vec4 a_shape;\nattribute vec4 a_color;\nattribute vec2 a_texcoord;\nattribute vec2 a_offset;\n\nuniform float u_point_type;\n\n#ifdef TANGRAM_CURVED_LABEL\n    attribute vec4 a_offsets;\n    attribute vec4 a_pre_angles;\n    attribute vec4 a_angles;\n#endif\n\nvarying vec4 v_color;\nvarying vec2 v_texcoord;\nvarying vec4 v_world_position;\nvarying float v_alpha_factor;\n\n#ifdef TANGRAM_HAS_SHADER_POINTS\n    attribute float a_outline_edge;\n    attribute vec4 a_outline_color;\n\n    varying float v_outline_edge;\n    varying vec4 v_outline_color;\n    varying float v_aa_offset;\n#endif\n\n#ifdef TANGRAM_SHOW_HIDDEN_LABELS\n    varying float v_label_hidden;\n#endif\n\n#define TANGRAM_PI 3.14159265359\n#define TANGRAM_NORMAL vec3(0., 0., 1.)\n\n#pragma tangram: attributes\n#pragma tangram: camera\n#pragma tangram: material\n#pragma tangram: lighting\n#pragma tangram: raster\n#pragma tangram: global\n\nvec2 rotate2D(vec2 _st, float _angle) {\n    return mat2(cos(_angle),-sin(_angle),\n                sin(_angle),cos(_angle)) * _st;\n}\n\n#ifdef TANGRAM_CURVED_LABEL\n    // Assumes stops are [0, 0.33, 0.66, 0.99];\n    float mix4linear(vec4 v, float x) {\n        x = clamp(x, 0., 1.);\n        return mix(mix(v[0], v[1], 3. * x),\n                   mix(v[1],\n                       mix(v[2], v[3], 3. * (max(x, .66) - .66)),\n                       3. * (clamp(x, .33, .66) - .33)),\n                   step(0.33, x)\n                );\n    }\n#endif\n\nvoid main() {\n    // Initialize globals\n    #pragma tangram: setup\n\n    // discard hidden labels by collapsing into degenerate triangle\n    #ifndef TANGRAM_SHOW_HIDDEN_LABELS\n        if (a_shape.w == 0.) {\n            gl_Position = vec4(0., 0., 0., 1.);\n            return;\n        }\n    #else\n        // highlight hidden label in fragment shader for debugging\n        if (a_shape.w == 0.) {\n            v_label_hidden = 1.; // label debug testing\n        }\n        else {\n            v_label_hidden = 0.;\n        }\n    #endif\n\n    v_alpha_factor = 1.0;\n    v_color = a_color;\n    v_texcoord = a_texcoord; // UV from vertex attribute\n\n    #ifdef TANGRAM_HAS_SHADER_POINTS\n        v_outline_color = a_outline_color;\n        v_outline_edge = a_outline_edge;\n\n        if (u_point_type == TANGRAM_POINT_TYPE_SHADER) { // shader point\n            // use point dimensions for UVs instead (ignore attribute), add antialiasing info for fragment shader\n            float _size = abs(a_shape.x / 128.); // radius in pixels\n            v_texcoord = sign(a_shape.xy) * (_size + 1.) / _size;\n            _size += 2.;\n            v_aa_offset = 2. / _size;\n        }\n    #endif\n\n    // Position\n    vec4 position = u_modelView * vec4(a_position.xyz, 1.);\n\n    // Apply positioning and scaling in screen space\n    vec2 _shape = a_shape.xy / 256.;                 // values have an 8-bit fraction\n    vec2 _offset = vec2(a_offset.x, -a_offset.y);    // flip y to make it point down\n    float _theta = a_shape.z / 4096.;\n\n    #ifdef TANGRAM_CURVED_LABEL\n        //TODO: potential bug? null is passed in for non-curved labels, otherwise the first offset will be 0\n        if (a_offsets[0] != 0.){\n            vec4 _angles_scaled = (TANGRAM_PI / 16384.) * a_angles;\n            vec4 _pre_angles_scaled = (TANGRAM_PI / 128.) * a_pre_angles;\n            vec4 _offsets_scaled = (1. / 64.) * a_offsets;\n\n            float _zoom = clamp(u_map_position.z - u_tile_origin.z, 0., 1.); //fract(u_map_position.z);\n            float _pre_angle = mix4linear(_pre_angles_scaled, _zoom);\n            float _angle = mix4linear(_angles_scaled, _zoom);\n            float _offset_curve = mix4linear(_offsets_scaled, _zoom);\n\n            _shape = rotate2D(_shape, _pre_angle); // rotate in place\n            _shape.x += _offset_curve;            // offset for curved label segment\n            _shape = rotate2D(_shape, _angle);     // rotate relative to curved label anchor\n            _shape += rotate2D(_offset, _theta);   // offset if specified in the scene file\n        }\n        else {\n            _shape = rotate2D(_shape + _offset, _theta);\n        }\n    #else\n        _shape = rotate2D(_shape + _offset, _theta);\n    #endif\n\n    // Fade in (if requested) based on time mesh has been visible.\n    // Value passed to fragment shader in the v_alpha_factor varying\n    #ifdef TANGRAM_FADE_IN_RATE\n        if (u_tile_fade_in) {\n            v_alpha_factor *= clamp(u_visible_time * TANGRAM_FADE_IN_RATE, 0., 1.);\n        }\n    #endif\n\n    // World coordinates for 3d procedural textures\n    v_world_position = u_model * position;\n    v_world_position.xy += _shape * u_meters_per_pixel;\n    v_world_position = wrapWorldPosition(v_world_position);\n\n    // Modify position before camera projection\n    #pragma tangram: position\n\n    cameraProjection(position);\n\n    #ifdef TANGRAM_LAYER_ORDER\n        // +1 is to keep all layers including proxies > 0\n        applyLayerOrder(a_position.w + u_tile_proxy_order_offset + 1., position);\n    #endif\n\n    // Apply pixel offset in screen-space\n    // Multiply by 2 is because screen is 2 units wide Normalized Device Coords (and u_resolution device pixels wide)\n    // Device pixel ratio adjustment is because shape is in logical pixels\n    position.xy += _shape * position.w * 2. * u_device_pixel_ratio / u_resolution;\n    #ifdef TANGRAM_HAS_SHADER_POINTS\n        if (u_point_type == TANGRAM_POINT_TYPE_SHADER) { // shader point\n            // enlarge by 1px to catch missed MSAA fragments\n            position.xy += sign(_shape) * position.w * u_device_pixel_ratio / u_resolution;\n        }\n    #endif\n\n    // Snap to pixel grid\n    // Only applied to fully upright sprites/labels (not shader-drawn points), while panning is not active\n    #ifdef TANGRAM_HAS_SHADER_POINTS\n    if (!u_view_panning && (abs(_theta) < TANGRAM_EPSILON) && u_point_type != TANGRAM_POINT_TYPE_SHADER) {\n    #else\n    if (!u_view_panning && (abs(_theta) < TANGRAM_EPSILON)) {\n    #endif\n        vec2 _position_fract = fract((((position.xy / position.w) + 1.) * .5) * u_resolution);\n        vec2 _position_snap = position.xy + ((step(0.5, _position_fract) - _position_fract) * position.w * 2. / u_resolution);\n\n        // Animate the snapping to smooth the transition and make it less noticeable\n        #ifdef TANGRAM_VIEW_PAN_SNAP_RATE\n            position.xy = mix(position.xy, _position_snap, clamp(u_view_pan_snap_timer * TANGRAM_VIEW_PAN_SNAP_RATE, 0., 1.));\n        #else\n            position.xy = _position_snap;\n        #endif\n    }\n\n    gl_Position = position;\n}\n",fragment_shader_src:"uniform vec2 u_resolution;\nuniform float u_time;\nuniform vec3 u_map_position;\nuniform vec4 u_tile_origin;\nuniform float u_meters_per_pixel;\nuniform float u_device_pixel_ratio;\nuniform float u_visible_time;\n\nuniform mat3 u_normalMatrix;\nuniform mat3 u_inverseNormalMatrix;\n\nuniform sampler2D u_texture;\nuniform float u_point_type;\nuniform bool u_apply_color_blocks;\n\nvarying vec4 v_color;\nvarying vec2 v_texcoord;\nvarying vec4 v_world_position;\nvarying float v_alpha_factor;\n\n#ifdef TANGRAM_HAS_SHADER_POINTS\n    varying vec4 v_outline_color;\n    varying float v_outline_edge;\n    varying float v_aa_offset;\n#endif\n\n#ifdef TANGRAM_SHOW_HIDDEN_LABELS\n    varying float v_label_hidden;\n#endif\n\n#define TANGRAM_NORMAL vec3(0., 0., 1.)\n\n#pragma tangram: attributes\n#pragma tangram: camera\n#pragma tangram: material\n#pragma tangram: lighting\n#pragma tangram: raster\n#pragma tangram: global\n\n#ifdef TANGRAM_HAS_SHADER_POINTS\n    //l is the distance from the center to the fragment, R is the radius of the drawn point\n    float _tangram_antialias(float l, float R){\n        float low  = R - v_aa_offset;\n        float high = R + v_aa_offset;\n        return 1. - smoothstep(low, high, l);\n    }\n#endif\n\nvoid main (void) {\n    // Initialize globals\n    #pragma tangram: setup\n\n    vec4 color = v_color;\n\n    #ifdef TANGRAM_HAS_SHADER_POINTS\n        // Only apply shader blocks to point, not to attached text (N.B.: for compatibility with ES)\n        if (u_point_type == TANGRAM_POINT_TYPE_TEXTURE) { // sprite texture\n            color *= texture2D(u_texture, v_texcoord);\n        }\n        else if (u_point_type == TANGRAM_POINT_TYPE_LABEL) { // label texture\n            color = texture2D(u_texture, v_texcoord);\n            color.rgb /= max(color.a, 0.001); // un-multiply canvas texture\n        }\n        else if (u_point_type == TANGRAM_POINT_TYPE_SHADER) { // shader point\n            // Mask of outermost circle, either outline or point boundary\n            float _d = length(v_texcoord); // distance to this fragment from the point center\n            float _outer_alpha = _tangram_antialias(_d, 1.);\n            float _fill_alpha = _tangram_antialias(_d, 1. - (v_outline_edge * 0.5)) * color.a;\n            float _stroke_alpha = (_outer_alpha - _tangram_antialias(_d, 1. - v_outline_edge)) * v_outline_color.a;\n\n            // Apply alpha compositing with stroke 'over' fill.\n            #ifdef TANGRAM_BLEND_ADD\n                color.a = _stroke_alpha + _fill_alpha;\n                color.rgb = color.rgb * _fill_alpha + v_outline_color.rgb * _stroke_alpha;\n            #else // TANGRAM_BLEND_OVERLAY (and fallback for not implemented blending modes)\n                color.a = _stroke_alpha + _fill_alpha * (1. - _stroke_alpha);\n                color.rgb = mix(color.rgb * _fill_alpha, v_outline_color.rgb, _stroke_alpha) / max(color.a, 0.001); // avoid divide by zero\n            #endif\n        }\n    #else\n        // If shader points not supported, assume label texture\n        color = texture2D(u_texture, v_texcoord);\n        color.rgb /= max(color.a, 0.001); // un-multiply canvas texture\n    #endif\n\n    // Shader blocks for color/filter are only applied for sprites, shader points, and standalone text,\n    // NOT for text attached to a point (N.B.: for compatibility with ES)\n    if (u_apply_color_blocks) {\n        #pragma tangram: color\n        #pragma tangram: filter\n    }\n\n    color.a *= v_alpha_factor;\n\n    // highlight hidden label in fragment shader for debugging\n    #ifdef TANGRAM_SHOW_HIDDEN_LABELS\n        if (v_label_hidden > 0.) {\n            color.a *= 0.5;\n            color.rgb = vec3(1., 0., 0.);\n        }\n    #endif\n\n    // Use alpha test as a lower-quality substitute\n    // For opaque and translucent: avoid transparent pixels writing to depth buffer, obscuring geometry underneath\n    // For multiply: avoid transparent pixels multiplying geometry underneath to zero/full black\n    #if defined(TANGRAM_BLEND_OPAQUE) || defined(TANGRAM_BLEND_TRANSLUCENT) || defined(TANGRAM_BLEND_MULTIPLY)\n        if (color.a < TANGRAM_ALPHA_TEST) {\n            discard;\n        }\n    #endif\n\n    gl_FragColor = color;\n}\n",selection:!0,collision:!0,blend:"overlay",init:function(e){void 0===e&&(e={}),go.init.call(this,e),this.setupDefines(),this.defines.TANGRAM_HAS_SHADER_POINTS=!0,this.defines.TANGRAM_POINT_TYPE_TEXTURE=1,this.defines.TANGRAM_POINT_TYPE_LABEL=2,this.defines.TANGRAM_POINT_TYPE_SHADER=3,this.collision_group_points=this.name+"-points",this.collision_group_text=this.name+"-text",this.stencil_proxy_tiles=!1,this.reset();},setupDefines:function(){"overlay"!==this.blend&&(this.defines.TANGRAM_LAYER_ORDER=!0),!0===on.suppress_label_fade_in?(this.fade_in_time=0,this.defines.TANGRAM_FADE_IN_RATE=null):(this.fade_in_time=.15,this.defines.TANGRAM_FADE_IN_RATE=1/this.fade_in_time),!0!==on.suppress_label_snap_animation&&(this.defines.TANGRAM_VIEW_PAN_SNAP_RATE=2),!0===on.show_hidden_labels&&(this.defines.TANGRAM_SHOW_HIDDEN_LABELS=!0);},reset:function(){this.queues={},this.resetText(),this.texture_missing_sprites={};},addFeature:function(e,t,r){var n=r.tile;if(n.generation===this.generation){var i={};if(i.color=this.parseColor(t.color,r),i.texture=t.texture,i.label_texture=null,i.blend_order=t.blend_order,i.color||i.texture){var o;if(i.alpha=Di.evalCachedProperty(t.alpha,r),this.hasSprites(i)){if(!(o=this.parseSprite(i,t,r)))return void Qr({level:"debug",once:!0},"Layer group '"+t.layers.join(", ")+"' uses a texture '"+i.texture+"', but doesn't specify which sprite to draw. Features that match this layer group won't be drawn without specifying the sprite with the 'sprite' or 'sprite_default' properties. The merged draw parameters for this layer group are:",t).then(function(r){r&&Qr("debug","Example feature for layer group '"+t.layers.join(", ")+"'",e);});i.texcoords=o.texcoords;}else if(t.sprite)return void Qr({level:"warn",once:!0},"Layer group '"+t.layers.join(", ")+"' specifies sprite '"+t.sprite+"', but the texture '"+t.texture+"' doesn't define any sprites. Features that match this layer group won't be drawn. The merged draw parameters for this layer group are:",t);if(this.calcSize(t,i,o,r),t.outline&&(i.outline_width=Di.evalCachedProperty(t.outline.width,r)||Di.defaults.outline.width,i.outline_color=this.parseColor(t.outline.color,r)),i.outline_edge_pct=0,i.outline_width&&i.outline_color){var s=i.outline_width;i.size[0]+=s,i.size[1]+=s,i.outline_edge_pct=s/Math.min(i.size[0],i.size[1])*2,i.outline_alpha=Di.evalCachedProperty(t.outline.alpha,r);}i.size[0]=Math.min(i.size[0],256),i.size[1]=Math.min(i.size[1],256),i.placement=t.placement,i.placement_min_length_ratio=Di.evalCachedProperty(t.placement_min_length_ratio,r),i.placement===Ha.SPACED&&t.placement_spacing&&(i.placement_spacing=Di.evalCachedProperty(t.placement_spacing,r)),i.angle=Di.evalProperty(t.angle,r)||0,i.z=Di.evalCachedDistanceProperty(t.z,r)||Di.defaults.z,i.tile_edges=t.tile_edges,this.computeLayout(i,e,t,r,n);var a=t.text&&!1!==t.text.visible&&this.parseTextFeature(e,t.text,r,n);Array.isArray(a)&&(a=null,Qr({level:"warn",once:!0},"Layer group '"+t.layers.join(", ")+"': cannot use boundary labels (e.g. 'text_source: { left: ..., right: ... }') for 'text' labels attached to 'points'; provided 'text_source' value was "+JSON.stringify(t.text.text_source))),a&&(a.layout.parent=i,a.layout.priority=t.text.priority?Math.max(a.layout.priority,i.priority+.5):i.priority+.5,ia.addStyle(this.collision_group_text,n.id)),this.queueFeature({feature:e,draw:t,context:r,style:i,text_feature:a},n),ia.addStyle(this.collision_group_points,n.id);}}},calcSize:function(e,t,r,n){if(t.size=e.size,t.size){if(t.size=Di.evalCachedPointSizeProperty(e.size,r,qn.textures[t.texture],n),null==t.size)return void Qr({level:"warn",once:!0},"Layer group '"+e.layers.join(", ")+"': 'size' ("+JSON.stringify(e.size.value)+") couldn't be interpreted, features that match this layer group won't be drawn");"number"==typeof t.size&&(t.size=[t.size,t.size]);}else t.size=r&&r.css_size||[16,16];},hasSprites:function(e){return e.texture&&qn.textures[e.texture]&&qn.textures[e.texture].sprites},getSpriteInfo:function(e,t){var r=qn.textures[e.texture].sprites[t]&&qn.getSpriteInfo(e.texture,t);return t&&!r?(this.texture_missing_sprites[e.texture]=this.texture_missing_sprites[e.texture]||{},this.texture_missing_sprites[e.texture][t]||(Qr("debug","Style: in style '"+this.name+"', could not find sprite '"+t+"' for texture '"+e.texture+"'"),this.texture_missing_sprites[e.texture][t]=!0)):r&&(r.sprite=t),r},parseSprite:function(e,t,r){var n=Di.evalProperty(t.sprite,r);return this.getSpriteInfo(e,n)||this.getSpriteInfo(e,t.sprite_default)},queueFeature:function(e,t){this.tile_data[t.id]&&this.queues[t.id]||this.startData(t),this.queues[t.id]=this.queues[t.id]||[],this.queues[t.id].push(e);},endData:function(e){return new Promise(function(t,r){var n,i,o,s,a,l,u,c,f,h;return n=this,e.canceled?(Qr("trace","Style "+this.name+": stop tile build because tile was canceled: "+e.key),t(null)):(i=this.queues[e.id],delete this.queues[e.id],o=[],s=[],i.forEach(function(e){for(var t=e.style,r=e.feature,i=r.geometry,a=n.buildLabels(t.size,i,t),l=0;l<a.length;l++){var u=a[l],c={feature:r,draw:e.draw,context:e.context,style:t,label:u};if(s.push(c),e.text_feature){var f={feature:r,draw:e.text_feature.draw,context:e.context,text:e.text_feature.text,text_settings_key:e.text_feature.text_settings_key,layout:e.text_feature.layout,point_label:u,linked:c};o.push(f),e.draw.text.optional||(c.linked=f);}}}),Promise.resolve(Promise.all([ia.collide(s,this.collision_group_points,e.id).then(function(e){e.forEach(function(e){n.feature_style=e.style,n.feature_style.label=e.label,n.feature_style.linked=e.linked,go.addFeature.call(n,e.feature,e.draw,e.context);});}),this.collideAndRenderTextLabels(e,this.collision_group_text,o)])).then(function(i){try{return a=i[1],l=a.labels,u=a.texts,c=a.textures,l&&u&&l.forEach(function(e){var t=e.text_settings_key,r=u[t]&&u[t][e.text],i=n.feature_style;i.label=e.label,i.linked=e.linked,i.size=r.size.logical_size,i.texcoords=r.align[e.label.align].texcoords,i.label_texture=c[r.align[e.label.align].texture_id],i.blend_order=e.draw.blend_order,go.addFeature.call(n,e.feature,e.draw,e.context);}),this.freeText(e),Promise.resolve(go.endData.call(this,e)).then(function(e){try{return (f=e)&&c&&c.length&&(f.textures=f.textures||[],(h=f.textures).push.apply(h,c)),t(f)}catch(e){return r(e)}},r)}catch(e){return r(e)}}.bind(this),r))}.bind(this))},_preprocess:function(e){e.color=Di.createColorPropertyCache(e.color),e.alpha=Di.createPropertyCache(e.alpha),e.texture=void 0!==e.texture?e.texture:this.texture,e.blend_order=this.getBlendOrderForDraw(e),e.outline&&(e.outline.color=Di.createColorPropertyCache(e.outline.color),e.outline.alpha=Di.createPropertyCache(e.outline.alpha),e.outline.width=Di.createPropertyCache(e.outline.width,Di.parsePositiveNumber)),e.z=Di.createPropertyCache(e.z,Di.parseUnits);try{e.size=Di.createPointSizePropertyCache(e.size,e.texture);}catch(t){return Qr({level:"warn",once:!0},"Layer group '"+e.layers.join(", ")+"': "+t+" ("+JSON.stringify(e.size)+"), features that match this layer group won't be drawn."),null}if(e.offset=Di.createPropertyCache(e.offset,function(e){return Array.isArray(e)&&e.map(Di.parseNumber)}),e.buffer=Di.createPropertyCache(e.buffer,function(e){return (Array.isArray(e)?e:[e,e]).map(Di.parsePositiveNumber)}),e.repeat_distance=Di.createPropertyCache(e.repeat_distance,Di.parseNumber),e.placement=Ha[e.placement&&e.placement.toUpperCase()],null==e.placement&&(e.placement=Ha.VERTEX),e.placement_spacing=null!=e.placement_spacing?e.placement_spacing:80,e.placement_spacing=Di.createPropertyCache(e.placement_spacing,Di.parsePositiveNumber),e.placement_min_length_ratio=null!=e.placement_min_length_ratio?e.placement_min_length_ratio:1,e.placement_min_length_ratio=Di.createPropertyCache(e.placement_min_length_ratio,Di.parsePositiveNumber),"number"==typeof e.angle)e.angle=e.angle*Math.PI/180;else if("function"==typeof e.angle){var t=e.angle;e.angle=function(e){return t(e)*Math.PI/180};}else e.angle=e.angle||0;return e.text=this.preprocessText(e.text),e.text&&(e.text.key=e.key,e.text.group=e.group,e.text.layers=e.layers,e.text.order=e.order,e.text.blend_order=e.blend_order,e.text.repeat_group=null!=e.text.repeat_group?e.text.repeat_group:e.repeat_group,e.text.anchor=e.text.anchor||this.default_anchor,e.text.optional="boolean"==typeof e.text.optional&&e.text.optional,e.text.interactive=e.text.interactive||e.interactive),e},default_anchor:["bottom","top","right","left"],computeLayout:function(e,t,r,n,i){var o=e||{};o.id=t,o.units_per_pixel=i.units_per_pixel||1,o.collide=!1!==r.collide,o.anchor=r.anchor,o.offset=Di.evalCachedProperty(r.offset,n)||Di.zeroPair,o.buffer=Di.evalCachedProperty(r.buffer,n)||Di.zeroPair,o.repeat_distance=Di.evalCachedProperty(r.repeat_distance,n),o.repeat_distance&&(o.repeat_distance*=o.units_per_pixel,o.repeat_scale=1,"function"==typeof r.repeat_group?o.repeat_group=r.repeat_group(n):o.repeat_group=r.repeat_group||n.layer);var s=r.priority;return null!=s?"function"==typeof s&&(s=s(n)):s=-1>>>0,o.priority=s,o},buildTextLabels:function(e,t){for(var r=[],n=0;n<t.length;n++){var i=t[n],o=this.texts[e.id][i.text_settings_key][i.text].size.collision_size;i.label=new oa(i.point_label.position,o,i.layout),r.push(i);}return r},buildLabels:function(e,t,r){var n=[];if("Point"===t.type)n.push(new oa(t.coordinates,e,r,r.angle));else if("MultiPoint"===t.type)for(var i=t.coordinates,o=0;o<i.length;++o){var s=i[o];n.push(new oa(s,e,r,r.angle));}else if("LineString"===t.type)for(var a=la(t.coordinates,e,r),l=0;l<a.length;++l)n.push(a[l]);else if("MultiLineString"===t.type)for(var u=t.coordinates,c=0;c<u.length;c++)for(var f=la(u[c],e,r),h=0;h<f.length;++h)n.push(f[h]);else if("Polygon"===t.type)if(r.placement===Ha.CENTROID){var d=ui.centroid(t.coordinates);d&&n.push(new oa(d,e,r,r.angle));}else for(var _=t.coordinates,p=0;p<_.length;p++)for(var m=la(_[p],e,r),v=0;v<m.length;++v)n.push(m[v]);else if("MultiPolygon"===t.type)if(r.placement===Ha.CENTROID){var g=ui.multiCentroid(t.coordinates);g&&n.push(new oa(g,e,r,r.angle));}else for(var y=t.coordinates,x=0;x<y.length;x++)for(var b=y[x],A=0;A<b.length;A++)for(var T=la(b[A],e,r),w=0;w<T.length;++w)n.push(T[w]);return n},makeVertexTemplate:function(e,t,r){void 0===r&&(r=!0);var n=0;this.vertex_template[n++]=0,this.vertex_template[n++]=0,this.vertex_template[n++]=e.z||0,this.vertex_template[n++]=this.scaleOrder(e.order),this.vertex_template[n++]=0,this.vertex_template[n++]=0,this.vertex_template[n++]=0,this.vertex_template[n++]=e.label.layout.collide?0:1,t.variant.shader_point||(this.vertex_template[n++]=0,this.vertex_template[n++]=0),this.vertex_template[n++]=0,this.vertex_template[n++]=0;var i=e.color||Di.defaults.color;if(this.vertex_template[n++]=255*i[0],this.vertex_template[n++]=255*i[1],this.vertex_template[n++]=255*i[2],this.vertex_template[n++]=255*(null!=e.alpha?e.alpha:i[3]),t.variant.selection&&(this.vertex_template[n++]=255*e.selection_color[0],this.vertex_template[n++]=255*e.selection_color[1],this.vertex_template[n++]=255*e.selection_color[2],this.vertex_template[n++]=255*e.selection_color[3]),t.variant.shader_point){var o=e.outline_color||Di.defaults.outline.color;this.vertex_template[n++]=255*o[0],this.vertex_template[n++]=255*o[1],this.vertex_template[n++]=255*o[2],this.vertex_template[n++]=255*(null!=e.outline_alpha?e.outline_alpha:o[3]),this.vertex_template[n++]=e.outline_edge_pct||Di.defaults.outline.width;}return r&&this.addCustomAttributesToVertexTemplate(e,n),this.vertex_template},buildQuad:function(e,t,r,n,i,o,s,a,l,u,c){return t[0]<=0||t[1]<=0?0:function(e,t,r,n,i,o,s,a,l,u,c,f){var h=i[0]*Fs,d=i[1]*Fs;Gs[0]=-h,Gs[1]=-d,Gs[2]=h,Gs[3]=d;for(var _=c||So,p=t.vertex_elements,m=t.vertex_count,v=0;v<4;v++)r[n.a_position+0]=e[0],r[n.a_position+1]=e[1],r[n.a_shape+0]=Gs[Us[v]],r[n.a_shape+1]=Gs[Ds[v]],r[n.a_shape+2]=l,r[n.a_offset+0]=o[0],r[n.a_offset+1]=o[1],n.a_texcoord&&(r[n.a_texcoord+0]=_[Us[v]]*Is,r[n.a_texcoord+1]=_[Ds[v]]*Is),f&&(r[n.a_pre_angles+0]=ks*a[0],r[n.a_pre_angles+1]=ks*a[1],r[n.a_pre_angles+2]=ks*a[2],r[n.a_pre_angles+3]=ks*a[3],r[n.a_angles+0]=Os*u[0],r[n.a_angles+1]=Os*u[1],r[n.a_angles+2]=Os*u[2],r[n.a_angles+3]=Os*u[3],r[n.a_offsets+0]=Ls*s[0],r[n.a_offsets+1]=Ls*s[1],r[n.a_offsets+2]=Ls*s[2],r[n.a_offsets+3]=Ls*s[3]),t.addVertex(r);return p.push(m+0),p.push(m+1),p.push(m+2),p.push(m+2),p.push(m+3),p.push(m+0),2}(e,u,c,u.vertex_layout.index,t,o,s,i,4096*r,n,a,l)},build:function(e,t){var r=e.label;return "curved"===r.type?this.buildCurvedLabel(r,e,t):this.buildStraightLabel(r,e,t)},buildStraightLabel:function(e,t,r){var n,i,o=this.getTileMesh(r.tile,this.meshVariantTypeForDraw(t)),s=this.makeVertexTemplate(t,o);"point"!==e.type?(n=t.size[e.type],i=t.texcoords[e.type].texcoord):(n=t.size,i=t.texcoords),o.uniforms=o.uniforms||{},t.label_texture?(o.uniforms.u_texture=t.label_texture,o.uniforms.u_point_type=2,o.uniforms.u_apply_color_blocks=!1):t.texture?(o.uniforms.u_texture=t.texture,o.uniforms.u_point_type=1,o.uniforms.u_apply_color_blocks=!0):(o.uniforms.u_texture=qn.default,o.uniforms.u_point_type=3,o.uniforms.u_apply_color_blocks=!0);var a=e.offset,l=this.buildQuad(e.position,n,e.angle,null,null,a,null,i,!1,o.vertex_data,s),u=t.linked&&t.linked.label.id;return this.trackLabel(e,u,o,l,r),l},buildCurvedLabel:function(e,t,r){for(var n,i,o=0,s=0;s<e.num_segments;s++){var a=t.size[e.type][s],l=t.texcoords_stroke[s];t.label_texture=t.label_textures[s],n=this.getTileMesh(r.tile,this.meshVariantTypeForDraw(t)),i=this.makeVertexTemplate(t,n),n.uniforms=n.uniforms||{},n.uniforms.u_texture=t.label_texture,n.uniforms.u_point_type=2,n.uniforms.u_apply_color_blocks=!1;var u=e.offset||[0,0],c=e.position,f=e.angles[s],h=e.offsets[s],d=e.pre_angles[s],_=this.buildQuad(c,a,e.angle,f,d,u,h,l,!0,n.vertex_data,i);o+=_;var p=t.linked&&t.linked.label.id;this.trackLabel(e,p,n,_,r);}for(var m=0;m<e.num_segments;m++){var v=t.size[e.type][m],g=t.texcoords[e.type][m].texcoord;t.label_texture=t.label_textures[m],n=this.getTileMesh(r.tile,this.meshVariantTypeForDraw(t)),i=this.makeVertexTemplate(t,n),n.uniforms=n.uniforms||{},n.uniforms.u_texture=t.label_texture,n.uniforms.u_point_type=2,n.uniforms.u_apply_color_blocks=!1;var y=e.offset||[0,0],x=e.position,b=e.angles[m],A=e.offsets[m],T=e.pre_angles[m],w=this.buildQuad(x,v,e.angle,b,T,y,A,g,!0,n.vertex_data,i);o+=w;var E=t.linked&&t.linked.label.id;this.trackLabel(e,E,n,w,r);}return o},trackLabel:function(e,t,r,n){if(e.layout.collide||e.may_repeat_across_tiles){r.labels=r.labels||{},r.labels[e.id]=r.labels[e.id]||{container:{label:e.toJSON(),linked:t},ranges:[]};var i=2*n,o=r.vertex_data.offset-r.vertex_data.stride*i;r.labels[e.id].ranges.push([o,i]);}},buildLines:function(e,t,r){return this.build(t,r)},buildPoints:function(e,t,r){return this.build(t,r)},buildPolygons:function(e,t,r){return this.build(t,r)},vertexLayoutForMeshVariant:function(e){if(null==this.vertex_layouts[e.shader_point]){var t=[{name:"a_position",size:4,type:Ki.SHORT,normalized:!1},{name:"a_shape",size:4,type:Ki.SHORT,normalized:!1},{name:"a_texcoord",size:2,type:Ki.UNSIGNED_SHORT,normalized:!0,static:e.shader_point?[0,0]:null},{name:"a_offset",size:2,type:Ki.SHORT,normalized:!1},{name:"a_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0},{name:"a_selection_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0,static:e.selection?null:[0,0,0,0]},{name:"a_outline_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0,static:e.shader_point?null:[0,0,0,0]},{name:"a_outline_edge",size:1,type:Ki.FLOAT,normalized:!1,static:e.shader_point?null:0}];this.addCustomAttributesToAttributeList(t),this.vertex_layouts[e.shader_point]=new Ro(t);}return this.vertex_layouts[e.shader_point]},meshVariantTypeForDraw:function(e){var t=e.label_texture||e.texture||"__shader_point",r=t+"/"+e.blend_order;return null==this.variants[r]&&(this.variants[r]={key:r,selection:1,shader_point:"__shader_point"===t,blend_order:e.blend_order,mesh_order:e.label_texture?1:0}),this.variants[r]},makeMesh:function(e,t,r){return void 0===r&&(r={}),r=Object.assign({},r,{fade_in_time:this.fade_in_time}),go.makeMesh.call(this,e,t,r)}});var Wa=Math.abs;D(D.S,"Math",{hypot:function(e,t){for(var r,n,i=0,o=0,s=arguments.length,a=0;o<s;)a<(r=Wa(arguments[o++]))?(i=i*(n=a/r)*n+1,a=r):i+=r>0?(n=r/a)*n:r;return a===1/0?1/0:a*Math.sqrt(i)}});var Za=[0,.33,.66,.99],Ya=function(e,t,r,n){for(var i=[{type:"straight",tolerance:n.no_curving?1.8:1.5},{type:"curved"},{type:"straight",tolerance:2.3}],o=0;o<i.length;o++){var s=i[o],a=void 0;if("straight"===s.type?a=new Ja(t,r,n,s.tolerance):"curved"===s.type&&!n.no_curving&&r.length>2&&(a=new Ka(e,r,n)),a&&!a.throw_away)return a}return !1},$a=function(){function e(e){this.id=ea.nextLabelId(),this.layout=e,this.position=[],this.angle=0,this.offset=e.offset.slice(),this.unit_scale=this.layout.units_per_pixel,this.obbs=[],this.aabbs=[],this.type="",this.throw_away=!1;}var t=e.prototype;return t.toJSON=function(){return {id:this.id,type:this.type,position:this.position,size:this.size,offset:this.offset,angle:this.angle,breach:this.breach,may_repeat_across_tiles:this.may_repeat_across_tiles,layout:ta(this.layout)}},e.splitLineByOrientation=function(e){for(var t=[e[0]],r=0,n=0,i=0,o=t,s=!1,a=1;a<e.length;a++){var l=e[a],u=e[a-1],c=no.length(no.sub(l,u));l[0]>u[0]?1===i?(t.push(l),(r+=c)>n&&(o=t,n=r,s=!1)):(t=[u,l],(r=c)>n&&(o=t,n=r,s=!1),i=1):l[0]<u[0]?-1===i?(t.unshift(l),(r+=c)>n&&(o=t,n=r,s=!0)):(t=[l,u],(r=c)>n&&(o=t,n=r,s=!0),i=-1):(-1===i?t.unshift(l):(t.push(l),i=1),(r+=c)>n&&(o=t,n=r,s=-1===i));}return [o,s]},t.discard=function(e,t){if(void 0===t&&(t=null),this.throw_away)return !0;for(var r=0;r<this.obbs.length;r++){var n={aabb:this.aabbs[r],obb:this.obbs[r]};if(ea.prototype.occluded.call(n,e,t))return !0}return !1},t.inTileBounds=function(){for(var e=0;e<this.aabbs.length;e++){var t={aabb:this.aabbs[e]};if(!ea.prototype.inTileBounds.call(t))return !1}return !0},e.createOBB=function(e,t,r,n,i,o,s){var a=e[0],l=e[1];return !o||0===o[0]&&0===o[1]||(a+=(o=no.rot(o,i))[0]*s,l-=o[1]*s),new Qs(a,l,-n,t,r)},e}(),Ja=function(e){function t(t,r,n,i){var o;return (o=e.call(this,n)||this).type="straight",o.size=t,o.throw_away=!o.fit(t,r,n,i),o}Or(t,e);var r=t.prototype;return r.fit=function(e,t,r,n){var i,o=this.unit_scale,s=$a.splitLineByOrientation(t);t=s[0],i=s[1],"number"==typeof r.orientation&&(this.offset[1]+=1.2*(e[1]-r.vertical_buffer),i&&(this.offset[1]*=-1),-1===r.orientation&&(this.offset[1]*=-1));for(var a=tl(t),l=e[0]*o,u=0;u<t.length-1;u++)for(var c=t[u],f=0,h=0,d=u+1,_=void 0;d<t.length;){var p=t[d-1],m=t[d],v=el(p,m);if(d!==u+1&&(f+=rl(v,_)),Math.abs(f)>.1)break;if(Qa(h+=a[d-1],l)<n){var g=no.mult(no.add(c,m),.5);return this.angle=-v,Math.abs(this.angle-Math.PI/2)<.01&&(this.angle=-Math.PI/2,"number"==typeof r.orientation&&(this.offset[1]*=-1)),this.position=g,this.updateBBoxes(this.position,e,this.angle,this.angle,this.offset),!0}_=v,d++;}return !1},r.updateBBoxes=function(e,t,r,n,i){var o=this.unit_scale;this.obbs=[],this.aabbs=[];var s=(t[0]+2*this.layout.buffer[0])*o*ea.epsilon,a=(t[1]+2*this.layout.buffer[1])*o*ea.epsilon,l=$a.createOBB(e,s,a,r,n,i,o),u=l.getExtent();this.obbs.push(l),this.aabbs.push(u),this.inTileBounds&&(this.breach=!this.inTileBounds()),this.mayRepeatAcrossTiles&&(this.may_repeat_across_tiles=this.mayRepeatAcrossTiles());},t}($a),Ka=function(e){function t(t,r,n){var i;return (i=e.call(this,n)||this).type="curved",i.angles=[],i.pre_angles=[],i.offsets=[],i.num_segments=t.length,i.sizes=t,i.throw_away=!i.fit(i.sizes,r,n),i}Or(t,e);var r=t.prototype;return r.toJSON=function(){return {id:this.id,type:this.type,obbs:this.obbs.map(function(e){return e.toJSON()}),position:this.position,breach:this.breach,may_repeat_across_tiles:this.may_repeat_across_tiles,layout:ta(this.layout)}},r.fit=function(e,r,n){var i,o=this.unit_scale,s=Math.max.apply(Math,e.map(function(e){return e[1]})),a=s*o,l=$a.splitLineByOrientation(r);r=l[0],i=l[1],"number"==typeof n.orientation&&(this.offset[1]+=1.2*(s-n.vertical_buffer),i&&(this.offset[1]*=-1),-1===n.orientation&&(this.offset[1]*=-1));var u=tl(r),c=e.map(function(e){return e[0]*o}),f=u.reduce(function(e,t){return e+t},0),h=c.reduce(function(e,t){return e+t},0);if(h>f)return !1;var d=r.length-1;if(d-0<2)return !1;var _=t.curvaturePlacement(r,f,u,h,0,d),p=r[_];if(-1===_||d-_<2)return !1;this.position=p;for(var m=0;m<c.length;m++){this.offsets[m]=[],this.angles[m]=[],this.pre_angles[m]=[];for(var v=0;v<Za.length;v++){var g=Za[v],y=t.scaleLine(g,r),x=y[0],b=y[1];p=x[_];var A=t.placeAtIndex(_,x,b,c),T=A.positions,w=A.offsets,E=A.angles,R=A.pre_angles,M=w.map(function(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])/o});if(0===g){this.angle=1/E.length*E.reduce(function(e,t){return e+t});for(var S=0;S<T.length;S++){var z=T[S],N=R[S],P=c[S],k=N+E[S],O=this.angle,L=$a.createOBB(z,P,a,k,O,this.offset,o),I=L.getExtent();this.obbs.push(L),this.aabbs.push(I);}}this.offsets[m].push(M[m]),this.angles[m].push(E[m]),this.pre_angles[m].push(R[m]);}}return !0},t.curvaturePlacement=function(e,t,r,n,i,o){i=i||0,o=o||e.length-1;for(var s=[],a=i+1;a<o;a++){var l=e[a-1],u=e[a],c=e[a+1],f=no.perp(u,l),h=no.perp(c,u),d=no.angleBetween(f,h);d>1&&(d=1/0),s.push(d);}s.push(1/0);for(var _=[],p=[],m=i,v=0,g=0;g<i;g++)v+=r[g];for(;v+n<t;){for(var y=v+n,x=v,b=m,A=0;b<o&&x+r[b]<y&&(A+=s[b])!==1/0;)x+=r[b],b++;if(0===A)return m;var T=A/(b-m);_.push(A),p.push(T),v+=r[m],m++;}if(0===_.length)return -1;var w=Math.min.apply(null,_),E=p[_.indexOf(w)];return w<1.3&&E<.4?_.indexOf(w):-1},t.scaleLine=function(e,t){var r=[t[0]],n=[];return t.forEach(function(i,o){if(o!==t.length-1){var s=no.sub(t[o+1],t[o]),a=no.mult(s,1+e);r.push(no.add(r[o],a)),n.push(no.length(a));}}),[r,n]},t.placeAtIndex=function(e,r,n,i){var o=r[e],s=t.getIndicesAndOffsets(e,n,i),a=s[0],l=s[1],u=t.getPositionsFromIndicesAndOffsets(r,a,l),c=t.getAnglesFromIndicesAndOffsets(o,a,r,u);return {positions:u,offsets:c[0],angles:c[1],pre_angles:c[2]}},t.getIndicesAndOffsets=function(e,t,r){for(var n=r.length,i=[],o=[],s=0,a=0,l=0;s<n;){for(var u=r[s];s<n&&a+.5*u<=l+t[e];){var c=a-l+.5*u;o.push(c),i.push(e),a+=u,u=r[++s];}l+=t[e],e++;}return [i,o]},t.getPositionsFromIndicesAndOffsets=function(e,t,r){for(var n=[],i=0;i<t.length;i++){var o=t[i],s=r[i],a=el(e[o],e[o+1]),l=no.rot([s,0],a),u=no.add(e[o],l);n.push(u);}return n},t.getAnglesFromIndicesAndOffsets=function(e,t,r,n){for(var i,o,s=[],a=[],l=[],u=0;u<n.length;u++){var c=n[u],f=t[u],h=no.sub(c,e),d=-no.angle(h),_=(i=r[f],o=r[f+1],-el(i,o))-d;if(u>0){var p=s[u-1],m=a[u-1];Math.abs(d-p)>Math.PI&&(d+=d>p?-2*Math.PI:2*Math.PI),Math.abs(m-_)>Math.PI&&(_+=_>m?-2*Math.PI:2*Math.PI);}s.push(d),a.push(_),l.push(h);}return [l,s,a]},t}($a);function Qa(e,t){return t/e}function el(e,t){var r=no.sub(t,e);return no.angle(r)}function tl(e){for(var t=[],r=0;r<e.length-1;r++){var n=e[r],i=e[r+1],o=Math.hypot(n[0]-i[0],n[1]-i[1]);t.push(o);}return t}function rl(e,t){var r,n;for(e>t?(r=t,n=e):(r=e,n=t);n-r>Math.PI;)r+=2*Math.PI;return Math.abs(n-r)}var nl=Object.create(Xa);Object.assign(nl,{name:"text",super:Xa,built_in:!0,init:function(e){void 0===e&&(e={}),go.init.call(this,e),this.setupDefines(),this.defines.TANGRAM_HAS_SHADER_POINTS=!1,this.defines.TANGRAM_CURVED_LABEL=!0,this.reset();},makeVertexTemplate:function(e,t){this.super.makeVertexTemplate.call(this,e,t,!1);for(var r=t.vertex_data.vertex_layout.index.a_pre_angles,n=0;n<12;n++)this.vertex_template[r++]=0;return this.addCustomAttributesToVertexTemplate(e,r),this.vertex_template},reset:function(){this.queues={},this.resetText();},addFeature:function(e,t,r){var n=this,i=r.tile;if(i.generation===this.generation){var o=e.geometry.type;t.can_articulate="LineString"===o||"MultiLineString"===o,t.supersample_text="LineString"===o||"MultiLineString"===o;var s=this.parseTextFeature(e,t,r,i);s&&(s instanceof Array?s.forEach(function(t){t.feature=e,t.context=r,t.layout.vertex=!1,n.queueFeature(t,i);}):(s.feature=e,s.context=r,s.layout.vertex=!1,this.queueFeature(s,i)),ia.addStyle(this.name,i.id));}},endData:function(e){return new Promise(function(t,r){var n,i,o,s,a,l,u,c;return n=this,i=this.queues[e.id],delete this.queues[e.id],Promise.resolve(this.collideAndRenderTextLabels(e,this.name,i)).then(function(i){try{return s=(o=i).labels,a=o.texts,l=o.textures,s&&a&&(this.texts[e.id]=a,s.forEach(function(t){var r=t.text_settings_key,i=n.texts[e.id][r]&&n.texts[e.id][r][t.text],o=n.feature_style;o.label=t.label,i.text_settings.can_articulate?(o.size={},o.texcoords={},"straight"===t.label.type?(o.size.straight=i.size.logical_size,o.texcoords.straight=i.texcoords.straight,o.label_texture=l[i.texcoords.straight.texture_id]):(o.size.curved=i.segment_sizes.map(function(e){return e.logical_size}),o.texcoords_stroke=i.texcoords_stroke,o.texcoords.curved=i.texcoords.curved,o.label_textures=i.texcoords.curved.map(function(e){return l[e.texture_id]}))):(o.size=i.size.logical_size,o.texcoords=i.align[t.label.align].texcoords,o.label_texture=l[i.align[t.label.align].texture_id]),o.blend_order=t.draw.blend_order,go.addFeature.call(n,t.feature,t.draw,t.context);})),this.freeText(e),Promise.resolve(go.endData.call(this,e)).then(function(e){try{if(u=e)for(var n in l&&l.length&&(c=u.textures).push.apply(c,l),u.meshes)u.meshes[n].uniforms.u_apply_color_blocks=!0;return t(u)}catch(e){return r(e)}},r)}catch(e){return r(e)}}.bind(this),r)}.bind(this))},_preprocess:function(e){return e.blend_order=this.getBlendOrderForDraw(e),this.preprocessText(e)},buildTextLabels:function(e,t){for(var r=[],n=0;n<t.length;n++){var i=t[n],o=this.texts[e.id][i.text_settings_key][i.text],s=void 0;if(i.layout.vertical_buffer=o.vertical_buffer,o.text_settings.can_articulate){var a=o.segment_sizes.map(function(e){return e.collision_size});i.layout.no_curving=o.no_curving,s=this.buildLabels(a,i.feature.geometry,i.layout,o.size.collision_size);}else s=this.buildLabels(o.size.collision_size,i.feature.geometry,i.layout);for(var l=0;l<s.length;l++){var u=Object.create(i);u.label=s[l],r.push(u);}}return r},buildLabels:function(e,t,r,n){var i=[];if("LineString"===t.type)Array.prototype.push.apply(i,this.buildLineLabels(t.coordinates,e,r,n));else if("MultiLineString"===t.type)for(var o=t.coordinates,s=0;s<o.length;++s)Array.prototype.push.apply(i,this.buildLineLabels(o[s],e,r,n));else if("Point"===t.type)i.push(new oa(t.coordinates,e,r));else if("MultiPoint"===t.type)for(var a=t.coordinates,l=0;l<a.length;++l)i.push(new oa(a[l],e,r));else if("Polygon"===t.type){var u=ui.centroid(t.coordinates);u&&i.push(new oa(u,e,r));}else if("MultiPolygon"===t.type){var c=ui.multiCentroid(t.coordinates);c&&i.push(new oa(c,e,r));}return i},buildLineLabels:function(e,t,r,n){var i=[],o=Math.min(r.subdiv,e.length-1);if(o>1)for(var s=(e.length-1)/o,a=0;a<o;a++){var l=Math.floor(a*s),u=Math.floor((a+1)*s)+1,c=e.slice(l,u),f=Ya(t,n,c,r);f&&i.push(f);}if(i.length<o){var h=Ya(t,n,e,r);h&&i.push(h);}return i},vertexLayoutForMeshVariant:function(e){if(null==this.vertex_layouts[e.shader_point]){var t=[{name:"a_position",size:4,type:Ki.SHORT,normalized:!1},{name:"a_shape",size:4,type:Ki.SHORT,normalized:!1},{name:"a_texcoord",size:2,type:Ki.UNSIGNED_SHORT,normalized:!0},{name:"a_offset",size:2,type:Ki.SHORT,normalized:!1},{name:"a_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0},{name:"a_selection_color",size:4,type:Ki.UNSIGNED_BYTE,normalized:!0,static:e.selection?null:[0,0,0,0]},{name:"a_pre_angles",size:4,type:Ki.BYTE,normalized:!1},{name:"a_angles",size:4,type:Ki.SHORT,normalized:!1},{name:"a_offsets",size:4,type:Ki.UNSIGNED_SHORT,normalized:!1}];this.addCustomAttributesToAttributeList(t),this.vertex_layouts[e.shader_point]=new Ro(t);}return this.vertex_layouts[e.shader_point]}}),nl.texture_id=0;var il=Object.create(os);Object.assign(il,{name:"raster",super:os,built_in:!0,init:function(){this.raster=this.raster||"color",this.super.init.apply(this,arguments),this.selection=!1;},_preprocess:function(e){return e.color=e.color||Di.defaults.color,this.super._preprocess.apply(this,arguments)}});var ol=function(){function e(){this.styles={},this.base_styles={},this.active_styles=[],this.active_blend_orders=[],this.register(Object.create(os)),this.register(Object.create(Ps)),this.register(Object.create(Xa)),this.register(Object.create(nl)),this.register(Object.create(il));}var t=e.prototype;return t.init=function(){ti.removeBlock("global"),ti.removeBlock("setup"),ti.addBlock("global","#ifdef TANGRAM_VERTEX_SHADER\n\n// Apply layer ordering to avoid z-fighting\nvoid applyLayerOrder (float layer, inout vec4 position) {\n    position.z -= layer * TANGRAM_LAYER_DELTA * position.w;\n}\n\n// Vertex position in model space: [0, 1] range over the local tile\n// Note positions can be outside that range due to unclipped geometry, geometry higher than a unit cube, etc.\nvec4 modelPosition() {\n    return\n        vec4(\n            a_position.xyz / TANGRAM_TILE_SCALE         // scale coords to ~0-1 range\n            * exp2(u_tile_origin.z - u_tile_origin.w),  // adjust for tile overzooming\n        1.)\n        + vec4(0., 1., 0., 0.);\n        // NB: additional offset to account for unusual Tangram JS y coords,\n        // should be refactored to remove\n}\n\n// Position in model space as above, but according to tile coordinate (as opposed to style) zoom\n// e.g. unadjusted for tile overzooming\nvec4 modelPositionBaseZoom() {\n    return\n        vec4(\n            a_position.xyz / TANGRAM_TILE_SCALE,    // scale coords to ~0-1 range\n        1.)\n        + vec4(0., 1., 0., 0.); // see note on offset above\n}\n\n#endif\n\n// Vertex position in world coordinates, useful for 3d procedural textures, etc.\nvec4 worldPosition() {\n    return v_world_position;\n}\n\n// Optionally wrap world coordinates (allows more precision at higher zooms)\n// e.g. at wrap 1000, the world space will wrap every 1000 meters\n#ifdef TANGRAM_VERTEX_SHADER\n\nvec4 wrapWorldPosition(vec4 world_position) {\n    #if defined(TANGRAM_WORLD_POSITION_WRAP)\n    vec2 anchor = u_tile_origin.xy - mod(u_tile_origin.xy, TANGRAM_WORLD_POSITION_WRAP);\n        world_position.xy -= anchor;\n    #endif\n    return world_position;\n}\n\n#endif\n\n// Normal in world space\n#if defined(TANGRAM_VERTEX_SHADER)\n\nvec3 worldNormal() {\n    return TANGRAM_NORMAL;\n}\n\n#elif defined(TANGRAM_FRAGMENT_SHADER)\n\nvec3 worldNormal() {\n    return u_inverseNormalMatrix * TANGRAM_NORMAL;\n}\n\n#endif\n"),ti.addBlock("global","// Vertex attribute + varying for feature selection\n#if defined(TANGRAM_FEATURE_SELECTION) && defined(TANGRAM_VERTEX_SHADER)\n    attribute vec4 a_selection_color;\n    varying vec4 v_selection_color;\n#endif\n"),ti.replaceBlock("setup","// Selection pass-specific rendering\n#if defined(TANGRAM_FEATURE_SELECTION) && defined(TANGRAM_VERTEX_SHADER)\n    if (a_selection_color.rgb == vec3(0.)) {\n        // Discard by forcing invalid triangle if we're in the feature\n        // selection pass but have no selection info\n        // TODO: in some cases we may actually want non-selectable features to occlude selectable ones?\n        gl_Position = vec4(0., 0., 0., 1.);\n        return;\n    }\n    v_selection_color = a_selection_color;\n#endif\n"),ti.defines.TANGRAM_EPSILON=1e-5,ti.defines.TANGRAM_LAYER_DELTA=1/16384,ti.defines.TANGRAM_TILE_SCALE="vec3("+ui.tile_scale+"., "+ui.tile_scale+"., u_meters_per_pixel * "+ui.tile_size+".)",ti.defines.TANGRAM_HEIGHT_SCALE=ui.height_scale,ti.defines.TANGRAM_ALPHA_TEST=.5;},t.destroy=function(e){var t=this;Object.keys(this.styles).forEach(function(r){var n=t.styles[r];n.gl===e&&(Qr("trace","StyleManager.destroy: destroying render style "+n.name),n.base&&t.remove(n.name),n.destroy());});},t.register=function(e){this.styles[e.name]=e,this.base_styles[e.name]=e;},t.remove=function(e){delete this.styles[e];},t.getActiveStyles=function(){return this.active_styles},t.updateActiveStyles=function(e){return this.active_styles=Object.keys(e.reduce(function(e,t){return Object.keys(t.meshes).forEach(function(t){return e[t]=!0}),e},{})),this.active_styles},t.getActiveBlendOrders=function(){return this.active_blend_orders},t.updateActiveBlendOrders=function(e){var t=[];e.forEach(function(e){Object.entries(e.meshes).forEach(function(e){var r=e[0];e[1].forEach(function(e){var n=e.variant.blend_order,i=t.findIndex(function(e){return e.blend_order===n});i=i>-1?i:t.push({blend_order:n,styles:[]})-1,-1===t[i].styles.indexOf(r)&&t[i].styles.push(r);});});}),this.active_blend_orders=t.sort(function(e,t){return e.blend_order-t.blend_order});},t.mix=function(e,t){if(e.mixed)return e;e.mixed={};var r=[];if(e.mix){var n;if(Array.isArray(e.mix))(n=r).push.apply(n,e.mix);else r.push(e.mix);(r=r.map(function(e){return t[e]}).filter(function(t){return t&&t!==e})).forEach(function(t){return e.mixed[t.name]=!0});}r.push(e),e.animated=r.some(function(e){return e&&e.animated}),e.texcoords=r.some(function(e){return e&&e.texcoords}),e.base=r.map(function(e){return e.base}).filter(function(e){return e}).pop(),e.lighting=r.map(function(e){return e.lighting}).filter(function(e){return null!=e}).pop(),e.texture=r.map(function(e){return e.texture}).filter(function(e){return e}).pop(),e.raster=r.map(function(e){return e.raster}).filter(function(e){return null!=e}).pop(),e.dash=r.map(function(e){return e.dash}).filter(function(e){return null!=e}).pop(),e.dash_background_color=r.map(function(e){return e.dash_background_color}).filter(function(e){return null!=e}).pop(),r.some(function(e){return e.hasOwnProperty("blend")&&e.blend})&&(e.blend=r.map(function(e){return e.hasOwnProperty("blend")&&e.blend}).filter(function(e){return e}).pop()),e.blend_order=r.map(function(e){return e.blend_order}).filter(function(e){return null!=e}).pop(),e.defines=Object.assign.apply(Object,[{}].concat(r.map(function(e){return e.defines}).filter(function(e){return e}))),e.material=Object.assign.apply(Object,[{}].concat(r.map(function(e){return e.material}).filter(function(e){return e})));var i=r.map(function(e){return e.draw}).filter(function(e){return e});return i.length>0&&(e.draw=li.apply(void 0,[{}].concat(i))),this.mixShaders(e,t,r),e},t.mixShaders=function(e,t,r){var n={},i=r.map(function(e){return e.shaders}).filter(function(e){return e});if(n.defines=Object.assign.apply(Object,[{}].concat(i.map(function(e){return e.defines}).filter(function(e){return e}))),n.attributes=Object.assign.apply(Object,[{}].concat(i.map(function(e){return e.attributes}).filter(function(e){return e}))),n.uniforms={},n._uniforms=e.shaders&&e.shaders.uniforms||{},n._uniform_scopes={},r.filter(function(e){return e.shaders&&e.shaders.uniforms}).forEach(function(e){var r=function(r){n._uniform_scopes[r]=e.name,Object.defineProperty(n.uniforms,r,{enumerable:!0,configurable:!0,get:function(){return void 0!==n._uniforms[r]?n._uniforms[r]:t[n._uniform_scopes[r]].shaders.uniforms!==n.uniforms?t[n._uniform_scopes[r]].shaders.uniforms[r]:void 0},set:function(e){n._uniforms[r]=e;}});};for(var i in e.shaders.uniforms)r(i);}),n.extensions=Object.keys(i.map(function(e){return e.extensions}).filter(function(e){return e}).reduce(function(e,t){return "string"==typeof t?e[t]=!0:t.forEach(function(t){return e[t]=!0}),e},{})||{}),e.shaders&&e.shaders.blocks)for(var o in e.shaders.block_scopes=e.shaders.block_scopes||{},e.shaders.blocks){var s,a=e.shaders.blocks[o];if(e.shaders.block_scopes[o]=e.shaders.block_scopes[o]||[],Array.isArray(a))(s=e.shaders.block_scopes[o]).push.apply(s,a.map(function(){return e.name}));else e.shaders.block_scopes[o].push(e.name);}var l={};return i.forEach(function(e){if(e.blocks){n.blocks=n.blocks||{},n.block_scopes=n.block_scopes||{};var t={};for(var r in e.blocks){var i=e.blocks[r],o=e.block_scopes[r];n.blocks[r]=n.blocks[r]||[],n.block_scopes[r]=n.block_scopes[r]||[],i=Array.isArray(i)?i:[i],o=Array.isArray(o)?o:[o];for(var s=0;s<i.length;s++)l[o[s]]||(t[o[s]]=!0,n.blocks[r].push(i[s]),n.block_scopes[r].push(o[s]));}Object.assign(l,t);}}),Object.assign(e.mixed,l),e.shaders=n,e},t.create=function(e,t,r){void 0===r&&(r={});var n=li({},t);return n.name=e,(n=this.mix(n,r)).base&&this.base_styles[n.base]?this.styles[e]=n=Object.assign(Object.create(this.base_styles[n.base]),n):n.base=null,n},t.build=function(e){var t=this,r=Object.assign({},e);this.styles&&Object.values(this.styles).forEach(function(e){return Hr.removeTarget(e.main_thread_target)});for(var n=["opaque","add","multiply","overlay","inlay","translucent"],i=["polygons","lines","points","text","raster"],o=0;o<n.length;o++)for(var s=n[o],a=0;a<i.length;a++){var l=i[a],u=s+"_"+l;null==r[u]&&(r[u]={base:l,blend:s});}var c=Object.keys(r).sort(function(e,n){return t.inheritanceDepth(e,r)-t.inheritanceDepth(n,r)});for(var f in this.styles)this.base_styles[f]?this.styles[f].reset():delete this.styles[f];var h={};return c.forEach(function(e){h[e]=t.create(e,r[e],h);}),this.styles},t.initStyles=function(e){for(var t in void 0===e&&(e={}),this.styles)this.styles[t].init(e);},t.inheritanceDepth=function(e,t){for(var r=this,n=0;;){var i=t[e];if(!i)break;if(!i.mix)break;if(n++,Array.isArray(i.mix)){n+=Math.max.apply(Math,i.mix.map(function(n){if(e!==n)return r.inheritanceDepth(n,t)}));break}if(e===i.mix)break;e=i.mix;}return n},e}();function sl(e){return null!=e}function al(e){return "("+e+")"}function ll(e){return "string"==typeof e?'"'+e+'"':e}function ul(e){return "$"===e[0]?"context['"+e.substring(1)+"']":e.indexOf(".")>-1?-1===e.indexOf("\\.")?"context.feature.properties"+e.split(".").map(function(e){return "['"+e+"']"}).join(""):"context.feature.properties"+e.replace(/\\\./g,"__TANGRAM_DELIMITER__").split(".").map(function(e){return e.replace(/__TANGRAM_DELIMITER__/g,".")}).map(function(e){return "['"+e+"']"}).join(""):"context.feature.properties['"+e+"']"}function cl(e,t){return al(ll(t)+" === "+ul(e))}function fl(e,t){return al("["+t.map(ll).join(",")+"]"+".indexOf("+ul(e)+") > -1")}function hl(e,t){return al(e.filter(sl).map(function(e){return al(e.join(" && "))}).join(" "+t+" "))}function dl(e,t,r){return t&&t.length>0?hl(t.map(function(e){return xl(e,r)}),"||"):"true"}function _l(e,t,r){return t&&t.length>0?hl(t.map(function(e){return xl(e,r)}),"&&"):"true"}function pl(e,t,r){return "!"+al(xl(t,r).join(" && "))}function ml(e,t,r){return "!"+al(dl(0,t,r))}function vl(e,t){return al(ul(e)+(t?" != ":" == ")+"null")}function gl(e,t,r){var n=[],i=r&&"function"==typeof r.rangeTransform&&r.rangeTransform;if(t.max){var o=i?i(t.max):t.max;n.push(ul(e)+" < "+o);}if(t.min){var s=i?s=i(t.min):t.min;n.push(ul(e)+" >= "+s);}return al(n.join(" && "))}function yl(e,t){var r=[];if(t.includes_any){var n="["+(Array.isArray(t.includes_any)?t.includes_any:[t.includes_any]).map(ll).join(",")+"]";r.push(ul(e)+" != null && "+n+".some(function(v) { return "+ul(e)+".indexOf(v) > -1 })");}if(t.includes_all){var i="["+(Array.isArray(t.includes_all)?t.includes_all:[t.includes_all]).map(ll).join(",")+"]";r.push(ul(e)+" != null && "+i+".every(function(v) { return "+ul(e)+".indexOf(v) > -1 })");}return al(r.join(" && "))}function xl(e,t){var r=[];if("function"==typeof e)return [al(e.toString()+"(context)")];if(Array.isArray(e))return [dl(0,e,t)];if(null==e)return ["true"];for(var n=Object.keys(e),i=0;i<n.length;i++){var o=n[i],s=e[o],a=typeof s;if("string"===a||"number"===a)r.push(cl(o,s));else if("boolean"===a)r.push(vl(o,s));else if("not"===o)r.push(pl(0,s,t));else if("any"===o)r.push(dl(0,s,t));else if("all"===o)r.push(_l(0,s,t));else if("none"===o)r.push(ml(0,s,t));else if(Array.isArray(s))r.push(fl(o,s));else if("object"===a&&null!=s)s.max||s.min?r.push(gl(o,s,t)):(s.includes_any||s.includes_all)&&r.push(yl(o,s));else{if(null!=s)throw new Error("Unknown Query syntax: "+s);r.push(" true ");}}return 0===n.length?["true"]:r}function bl(e,t){return null==e?function(){return !0}:new Function("context","return "+al(xl(e,t).join(" && "))+";")}D(D.S,"Number",{MAX_SAFE_INTEGER:9007199254740991});var Al=["filter","draw","visible","enabled","data","exclusive","priority"],Tl={};function wl(e,t){for(var r,n=0,i=0;i<e.length;i++)e[i].length>n&&(n=e[i].length);if(0===n)return null;for(var o={visible:!0},s=function(n){if(r=[],e.forEach(function(e){e[n]&&e[n][t]&&-1===r.indexOf(e[n][t])&&r.push(e[n][t]);}),0===r.length)return "continue";li.apply(void 0,[o].concat(r));},a=0;a<n;a++)s(a);return !1===o.visible?null:o}var El=["any","all","not","none"],Rl=function(){function e(t){var r=t.layer,n=t.name,i=t.parent,o=t.draw,s=t.visible,a=t.enabled,l=t.filter,u=t.exclusive,c=t.priority,f=t.styles;if(this.id=e.id++,this.config_data=r.data,this.parent=i,this.name=n,this.full_name=this.parent?this.parent.full_name+":"+this.name:this.name,this.draw=o,this.filter=l,this.exclusive=!0===u,this.priority=null!=c?c:Number.MAX_SAFE_INTEGER,this.styles=f,this.is_built=!1,a=void 0===a?s:a,this.enabled=!1!==a,this.draw)for(var h in this.draw)if(this.draw[h]=null==this.draw[h]?{}:this.draw[h],"object"!=typeof this.draw[h]){var d="Draw group '"+h+"' for layer "+this.full_name+" is invalid, must be an object, ";Qr("warn",d+="but was set to `"+h+": "+this.draw[h]+"` instead"),delete this.draw[h];}}var t=e.prototype;return t.build=function(){Qr("trace","Building layer '"+this.full_name+"'"),this.buildFilter(),this.buildDraw(),this.is_built=!0;},t.buildDraw=function(){this.draw=Ii(this.draw,Di.wrapFunction),this.calculatedDraw=function(e){var t=[];if(e.parent){var r=e.parent.calculatedDraw||[];t.push.apply(t,r);}return t.push(e.draw),t}(this);},t.buildFilter=function(){this.filter_original=this.filter,this.filter=Ii(this.filter,Di.wrapFunction);var e=typeof this.filter;if(null==this.filter||"object"===e||"function"===e)try{this.buildZooms(),this.buildPropMatches(),null!=this.filter&&("function"==typeof this.filter||Object.keys(this.filter).length>0)?this.filter=bl(this.filter,zl):this.filter=null;}catch(e){var t="Filter for layer "+this.full_name+" is invalid, `filter: "+JSON.stringify(this.filter)+"` ";Qr("warn",t+="failed with error '"+e.message+"', stack trace: "+e.stack);}else{var r="Filter for layer "+this.full_name+" is invalid, filter value must be an object or function, ";Qr("warn",r+="but was set to `filter: "+this.filter+"` instead");}},t.buildZooms=function(){var e=this.filter&&this.filter.$zoom,t=typeof e;if(null!=e){if(this.zooms={},"number"===t)this.zooms[e]=!0;else if(Array.isArray(e))for(var r=0;r<e.length;r++)this.zooms[e[r]]=!0;else if("object"===t&&(null!=e.min||null!=e.max))for(var n=e.min||0,i=e.max||ui.max_style_zoom,o=n;o<i;o++)this.zooms[o]=!0;delete this.filter.$zoom;}},t.buildPropMatches=function(){var e=this;this.filter&&!Array.isArray(this.filter)&&"function"!=typeof this.filter&&Object.keys(this.filter).forEach(function(t){if(-1===El.indexOf(t)){var r=e.filter[t],n=typeof r,i=Array.isArray(r);if(!i&&"string"!==n&&"number"!==n)return;"$"===t[0]?(e.context_prop_matches=e.context_prop_matches||[],e.context_prop_matches.push([t.substring(1),i?r:[r]]),delete e.filter[t]):-1===t.indexOf(".")&&(e.feature_prop_matches=e.feature_prop_matches||[],e.feature_prop_matches.push([t,i?r:[r]]),delete e.filter[t]);}});},t.doPropMatches=function(e){if(this.feature_prop_matches)for(var t=0;t<this.feature_prop_matches.length;t++){var r=this.feature_prop_matches[t],n=e.feature.properties[r[0]];if(null==n||-1===r[1].indexOf(n))return !1}if(this.context_prop_matches)for(var i=0;i<this.context_prop_matches.length;i++){var o=this.context_prop_matches[i],s=e[o[0]];if(null==s||-1===o[1].indexOf(s))return !1}return !0},t.doesMatch=function(e){if(!this.enabled)return !1;if(this.is_built||this.build(),null!=this.zooms&&!this.zooms[e.zoom])return !1;if(!this.doPropMatches(e))return !1;var t;if(this.filter instanceof Function)try{t=this.filter(e);}catch(t){var r="Filter for this "+this.full_name+": `filter: "+this.filter_original+"` ";Qr("error",r+="failed with error '"+t.message+"', stack trace: "+t.stack,e.feature);}else t=null==this.filter;return !!t&&(this.children_to_parse&&(!function(e,t,r){for(var n in t){var i=t[n];if("object"!=typeof i||Array.isArray(i)){var o="Layer value must be an object: cannot create layer '"+n+": "+JSON.stringify(i)+"'";o+=", under parent layer '"+e.full_name+"'.",r[e.name]&&(o+=" The parent name '"+e.name+"' is also the name of a style, did you mean to create a 'draw' group",e.parent&&(o+=" under '"+e.parent.name+"'"),o+=" instead?"),Qr("warn",o);}else Pl(n,i,e,r);}e.layers.sort(function(e,t){if(e.exclusive<t.exclusive)return 1;if(e.exclusive>t.exclusive)return -1;var r=e.exclusive?1:-1;return e.priority>t.priority?r:e.priority<t.priority?-r:e.full_name<t.full_name?r:e.full_name>t.full_name?-r:void 0});}(this,this.children_to_parse,this.styles),delete this.children_to_parse),!0)},e}();Rl.id=0;var Ml=function(e){function t(t){var r;return (r=e.call(this,t)||this).is_leaf=!0,r}return Or(t,e),t}(Rl),Sl=function(e){function t(t){var r;return (r=e.call(this,t)||this).is_tree=!0,r.layers=t.layers||[],r}Or(t,e);var r=t.prototype;return r.addLayer=function(e){this.layers.push(e);},r.buildDrawGroups=function(e){var t=[],r=[];if(function e(t,r,n,i){var o=!1;if(0===r.length)return;for(var s=0;s<r.length;s++){var a=r[s];if(a.is_leaf){if(a.doesMatch(t)&&(o=!0,n.push(a),i.push(a.id),a.exclusive))break}else if(a.is_tree&&a.doesMatch(t)&&(o=!0,e(t,a.layers,n,i)||(n.push(a),i.push(a.id)),a.exclusive))break}return o}(e,[this],t,r),t.length>0){var n=function(e){if(e.length>1){for(var t=e[0],r=1;r<e.length;r++)t+="/"+e[r];return t}return e[0]}(r);if(void 0===Tl[n]){for(var i=t.map(function(e){return e&&!1!==e.visible&&e.calculatedDraw}),o={},s=0;s<i.length;s++){var a=i[s];if(a)for(var l=0;l<a.length;l++){var u=a[l];for(var c in u)o[c]=!0;}}for(var f in o)Tl[n]=Tl[n]||{},Tl[n][f]=wl(i,f),Tl[n][f]?(Tl[n][f].key=n+"/"+f,Tl[n][f].layers=t.map(function(e){return e&&e.full_name}),Tl[n][f].group=f):delete Tl[n][f];Tl[n]&&0===Object.keys(Tl[n]).length&&(Tl[n]=null);}return Tl[n]}},t}(Rl),zl={rangeTransform:function(e){return "string"==typeof e&&"px2"===e.trim().slice(-3)?parseFloat(e)+" * context.meters_per_pixel_sq":e}};function Nl(e){return Al.indexOf(e)>-1}function Pl(e,t,r,n){var i,o={name:e,layer:t=null==t?{}:t,parent:r,styles:n},s=function(e){var t={},r={};for(var n in e)Nl(n)?t[n]=e[n]:r[n]=e[n];return [t,r]}(t),a=s[0],l=s[1],u=(i=l,0===Object.keys(i).length),c=new(u&&null!=r?Ml:Sl)(Object.assign(o,a));return c.enabled&&(r&&r.addLayer(c),c.children_to_parse=u?null:l),c}var kl=0,Ol=0,Ll=function(){function e(e){var t=e.coords,r=e.style_z,n=e.source,i=e.workers,o=e.view;this.id=kl++,this.view=o,this.source=n,this.generation=null,this.valid=!0,this.visible=!1,this.proxy_for=null,this.proxied_as=null,this.proxy_level=0,this.proxy_order_offset=0,this.fade_in=!0,this.loading=!1,this.loaded=!1,this.built=!1,this.labeled=!1,this.error=null,this.debug={},this.style_z=r,this.coords=po.normalizedCoord(t,this.source),this.key=po.key(this.coords,this.source,this.style_z),this.overzoom=Math.max(this.style_z-this.coords.z,0),this.overzoom2=Math.pow(2,this.overzoom),this.min=ui.metersForTile(this.coords),this.max=ui.metersForTile({x:this.coords.x+1,y:this.coords.y+1,z:this.coords.z}),this.span={x:this.max.x-this.min.x,y:-(this.max.y-this.min.y)},this.bounds={sw:{x:this.min.x,y:this.max.y},ne:{x:this.max.x,y:this.min.y}},this.meters_per_pixel=ui.metersPerPixel(this.style_z),this.meters_per_pixel_sq=this.meters_per_pixel*this.meters_per_pixel,this.units_per_pixel=ui.units_per_pixel/this.overzoom2,this.units_per_meter_overzoom=ui.unitsPerMeter(this.coords.z)*this.overzoom2,this.preserve_tiles_within_zoom=this.source.preserve_tiles_within_zoom,this.meshes={},this.new_mesh_styles=[],this.pending_label_meshes=null,this.setWorker(i);}var t=e.prototype;return t.freeResources=function(){for(var e in this.meshes)this.meshes[e].forEach(function(e){return e.destroy()});if(this.meshes={},this.pending_label_meshes)for(var t in this.pending_label_meshes)this.pending_label_meshes[t].forEach(function(e){return e.destroy()});this.pending_label_meshes=null;},t.destroy=function(){En.removeForTile(this.id),this.workerMessage("self.removeTile",this.key),this.freeResources(),this.worker=null,this.valid=!1;},t.buildAsMessage=function(){return {id:this.id,key:this.key,source:this.source.name,coords:this.coords,min:this.min,max:this.max,units_per_pixel:this.units_per_pixel,meters_per_pixel:this.meters_per_pixel,meters_per_pixel_sq:this.meters_per_pixel_sq,units_per_meter_overzoom:this.units_per_meter_overzoom,style_z:this.style_z,overzoom:this.overzoom,overzoom2:this.overzoom2,generation:this.generation,debug:this.debug}},t.setWorker=function(e){this.source.tiled?this.worker_id=Math.abs(this.coords.x+this.coords.y+this.coords.z)%e.length:this.worker_id=this.source.id%e.length,this.worker=e[this.worker_id];},t.workerMessage=function(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return Hr.postMessage.apply(Hr,[this.worker].concat(t))},t.build=function(e,t){var r=(void 0===t?{}:t).fade_in,n=void 0===r||r;return this.generation=e,this.fade_in=n,this.loaded||(this.loading=!0,this.built=!1,this.labeled=!1),this.workerMessage("self.buildTile",{tile:this.buildAsMessage()}).catch(function(e){throw e})},e.cancel=function(t){t&&(t.canceled=!0,t.source_data&&t.source_data.request_id&&(nn.cancelRequest(t.source_data.request_id),t.source_data.request_id=null),e.abortBuild(t));},e.buildGeometry=function(t,r){var n=r.scene_id,i=r.layers,o=r.styles,s=r.global,a=t.source_data;for(var l in t.debug.building=+new Date,t.debug.feature_count=0,t.debug.layers=null,ia.startTile(t.id,{apply_repeat_groups:!0}),i){var u=i[l];if(u&&u.config_data){if(u.config_data.source===t.source)for(var c=e.getDataForSource(a,u.config_data,l),f=0;f<c.length;f++){var h=c[f],d=h.geom;if(d)for(var _=0;_<d.features.length;_++){var p=d.features[_];if(null!=p.geometry){var m=Di.getFeatureParseContext(p,t,s);m.winding=t.default_winding,m.source=t.source,m.layer=h.layer;var v=u.buildDrawGroups(m,!0);if(v){for(var g in v){var y=v[g],x=y.style||g,b=o[x];b?null!=(y=b.preprocess(y))&&!1!==y.visible&&(m.layers=y.layers,b.addFeature(p,y,m)):Qr("warn","Style '"+x+"' not found, skipping layer '"+l+"':",y,p);}t.debug.feature_count++;}}}}}else Qr("warn","Layer "+l+" was defined without a geometry data source and will not be rendered.");}t.debug.building=+new Date-t.debug.building;var A=this.stylesForTile(t,o).map(function(e){return o[e]});e.buildStyleGroups(t,A,n,function(e){return e.collision?"collision":"non-collision"});},e.stylesForTile=function(e,t){var r=[];for(var n in t)t[n].hasDataForTile(e)&&r.push(n);return r},e.buildStyleGroups=function(t,r,n,i){var o=r.reduce(function(e,t){var r=i(t);return e[r]=e[r]||[],e[r].push(t),e},{});if(0===Object.keys(o).length)return Hr.postMessage("TileManager_"+n+".buildTileStylesCompleted",Hr.withTransferables({tile:e.slice(t),progress:{start:!0,done:!0}})),void ia.resetTile(t.id);var s={};for(var a in o)e.buildStyleGroup({group_name:a,groups:o,tile:t,progress:s,scene_id:n});},e.buildStyleGroup=function(t){return new Promise(function(r,n){var i,o,s,a,l,u,c;i=t.group_name,o=t.groups,s=t.tile,a=t.progress,l=t.scene_id,u=o[i],c={};var f=function(){try{return r()}catch(e){return n(e)}},h=function(e){try{return Qr("error","Error for style group '"+i+"' for tile "+s.key,e&&e.stack||e),f()}catch(e){return n(e)}};try{return Promise.resolve(Promise.all(u.map(function(e){return new Promise(function(t,r){var n;return Promise.resolve(e.endData(s)).then(function(i){try{return (n=i)&&(c[e.name]=n),t()}catch(e){return r(e)}},r)})}))).then(function(t){try{return Qr("trace","Finished style group '"+i+"' for tile "+s.key),o[i]=null,Object.keys(o).every(function(e){return null==o[e]})&&(a.done=!0),Hr.postMessage("TileManager_"+l+".buildTileStylesCompleted",Hr.withTransferables({tile:Object.assign({},e.slice(s),{mesh_data:c}),progress:a})),a.done&&ia.resetTile(s.id),f()}catch(e){return h(e)}},h)}catch(e){h(e);}})},e.getDataForSource=function(e,t,r){var n=[];if(null!=t&&null!=e&&null!=e.layers)if(!0===t.all_layers){if(null!=t.layer)Qr({level:"warn",once:!0},"Layer "+r+" includes both 'all_layers: true' and an explicit 'layer' keyword in its 'data' block. 'all_layers: true' takes precedence, 'layer' will be ignored.");for(var i in e.layers)e.layers[i].features&&n.push({layer:i,geom:e.layers[i]});}else!t.layer&&e.layers._default?n.push({geom:e.layers._default}):!t.layer&&r?n.push({layer:r,geom:e.layers[r]}):"string"==typeof t.layer?n.push({layer:t.layer,geom:e.layers[t.layer]}):Array.isArray(t.layer)&&t.layer.forEach(function(t){e.layers[t]&&e.layers[t].features&&n.push({layer:t,geom:e.layers[t]});});return n},t.buildMeshes=function(e,t){if(!this.error){this.build_id=Ol++,t.start&&(this.debug.geometry_count=0,this.debug.buffer_size=0);var r={},n=this.mesh_data;if(n)for(var i in n){for(var o in n[i].meshes){var s=n[i].meshes[o];if(s.vertex_data){if(!e[i]){Qr("warn","Could not create mesh because style '"+i+"' not found, for tile "+this.key+", aborting tile");break}var a=Object.assign({},n[i]);a.uniforms=Object.assign({},a.uniforms,s.uniforms),a.variant=s.variant,s.labels&&(a.retain=!0);var l=e[i].makeMesh(s.vertex_data,s.vertex_elements,a);l.variant=a.variant,l.labels=s.labels,r[i]=r[i]||[],r[i].push(l),null==l.variant.mesh_order&&(l.variant.mesh_order=r[i].length-1),this.debug.buffer_size+=l.buffer_size,this.debug.geometry_count+=l.geometry_count;}}r[i]&&r[i].sort(function(e,t){var r=e.variant.mesh_order,n=t.variant.mesh_order;return null==r?1:null==n?-1:r<n?-1:1});}for(var u in delete this.mesh_data,r)e[u].collision?(this.pending_label_meshes=this.pending_label_meshes||{},this.pending_label_meshes[u]=r[u]):(this.meshes[u]&&this.meshes[u].forEach(function(e){return e.destroy()}),this.meshes[u]=r[u],this.new_mesh_styles.push(u));if(t.done){for(var c in this.meshes)-1!==this.new_mesh_styles.indexOf(c)||this.pending_label_meshes&&null!=this.pending_label_meshes[c]||(this.meshes[c].forEach(function(e){return e.destroy()}),delete this.meshes[c]);this.new_mesh_styles=[],this.debug.geometry_ratio=(this.debug.geometry_count/this.debug.feature_count).toFixed(1);}this.printDebug(t);}},t.pendingLabelStyleCount=function(){return this.pending_label_meshes?Object.keys(this.pending_label_meshes).length:0},t.swapPendingLabels=function(){if(this.labeled=!0,this.pending_label_meshes){for(var e in this.pending_label_meshes)this.meshes[e]&&this.meshes[e].forEach(function(e){return e.destroy()}),this.meshes[e]=this.pending_label_meshes[e];this.pending_label_meshes=null;}},e.abortBuild=function(e){if(En.removeForTile(e.id),ia.abortTile(e.id),e.mesh_data)for(var t in e.mesh_data){var r=e.mesh_data[t].textures;r&&r.forEach(function(t){var r=qn.textures[t];r&&(Qr("trace","releasing texture "+t+" for tile "+e.key),r.release());});}},t.setProxyFor=function(e){e?(this.visible=!0,this.proxy_for=this.proxy_for||[],this.proxy_for.push(e),this.proxy_order_offset=1,e.proxied_as=e.style_z>this.style_z?"child":"parent",this.proxy_level=Math.abs(e.style_z-this.style_z)):(this.proxy_for=null,this.proxy_order_offset=0,this.proxy_level=0);},t.isProxy=function(){return null!=this.proxy_for},t.shouldProxyForStyle=function(e){return !this.proxy_for||this.proxy_for.some(function(t){return null==t.meshes[e]})},t.setupProgram=function(e,t){var r=e.model,n=e.model32;t.uniform("4fv","u_tile_origin",[this.min.x,this.min.y,this.style_z,this.coords.z]),t.uniform("1f","u_tile_proxy_order_offset",this.proxy_order_offset),Ga.identity(r),Ga.translate(r,r,Ua(this.min.x,this.min.y,0)),Ga.scale(r,r,Ua(this.span.x/ui.tile_scale,this.span.y/ui.tile_scale,1)),Ga.copy(n,r),t.uniform("Matrix4fv","u_model",n),t.uniform("1i","u_tile_fade_in",this.fade_in&&"child"!==this.proxied_as);},e.slice=function(e,t){var r=["id","key","loading","loaded","generation","error","debug"];Array.isArray(t)&&r.push.apply(r,t);for(var n={},i=0;i<r.length;i++){var o=r[i];n[o]=e[o];}return n},t.merge=function(e){return this.loading=e.loading,this.loaded=e.loaded,this.generation=e.generation,this.error=e.error,this.mesh_data=e.mesh_data,this.debug=li(this.debug,e.debug),this},t.printDebug=function(e){var t=["layers"],r={};for(var n in this.debug)-1===t.indexOf(n)&&(r[n]=this.debug[n]);Qr("debug","Tile "+(e.done?"(done)":"")+": debug for "+this.key+": [  "+JSON.stringify(r)+" ]");},e}();Ll.coord_children={};var Il=function(e,t,r,n,i){var o,s,a=8*i-n-1,l=(1<<a)-1,u=l>>1,c=-7,f=r?i-1:0,h=r?-1:1,d=e[t+f];for(f+=h,o=d&(1<<-c)-1,d>>=-c,c+=a;c>0;o=256*o+e[t+f],f+=h,c-=8);for(s=o&(1<<-c)-1,o>>=-c,c+=n;c>0;s=256*s+e[t+f],f+=h,c-=8);if(0===o)o=1-u;else{if(o===l)return s?NaN:1/0*(d?-1:1);s+=Math.pow(2,n),o-=u;}return (d?-1:1)*s*Math.pow(2,o-n)},Fl=function(e,t,r,n,i,o){var s,a,l,u=8*o-i-1,c=(1<<u)-1,f=c>>1,h=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:o-1,_=n?1:-1,p=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(a=isNaN(t)?1:0,s=c):(s=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-s))<1&&(s--,l*=2),(t+=s+f>=1?h/l:h*Math.pow(2,1-f))*l>=2&&(s++,l/=2),s+f>=c?(a=0,s=c):s+f>=1?(a=(t*l-1)*Math.pow(2,i),s+=f):(a=t*Math.pow(2,f-1)*Math.pow(2,i),s=0));i>=8;e[r+d]=255&a,d+=_,a/=256,i-=8);for(s=s<<i|a,u+=i;u>0;e[r+d]=255&s,d+=_,s/=256,u-=8);e[r+d-_]|=128*p;},Ul=Dl;function Dl(e){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(e)?e:new Uint8Array(e||0),this.pos=0,this.type=0,this.length=this.buf.length;}Dl.Varint=0,Dl.Fixed64=1,Dl.Bytes=2,Dl.Fixed32=5;function Gl(e){return e.type===Dl.Bytes?e.readVarint()+e.pos:e.pos+1}function Cl(e,t,r){return r?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function jl(e,t,r){var n=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.ceil(Math.log(t)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=e;i--)r.buf[i+n]=r.buf[i];}function Vl(e,t){for(var r=0;r<e.length;r++)t.writeVarint(e[r]);}function Bl(e,t){for(var r=0;r<e.length;r++)t.writeSVarint(e[r]);}function ql(e,t){for(var r=0;r<e.length;r++)t.writeFloat(e[r]);}function Hl(e,t){for(var r=0;r<e.length;r++)t.writeDouble(e[r]);}function Xl(e,t){for(var r=0;r<e.length;r++)t.writeBoolean(e[r]);}function Wl(e,t){for(var r=0;r<e.length;r++)t.writeFixed32(e[r]);}function Zl(e,t){for(var r=0;r<e.length;r++)t.writeSFixed32(e[r]);}function Yl(e,t){for(var r=0;r<e.length;r++)t.writeFixed64(e[r]);}function $l(e,t){for(var r=0;r<e.length;r++)t.writeSFixed64(e[r]);}function Jl(e,t){return (e[t]|e[t+1]<<8|e[t+2]<<16)+16777216*e[t+3]}function Kl(e,t,r){e[r]=t,e[r+1]=t>>>8,e[r+2]=t>>>16,e[r+3]=t>>>24;}function Ql(e,t){return (e[t]|e[t+1]<<8|e[t+2]<<16)+(e[t+3]<<24)}Dl.prototype={destroy:function(){this.buf=null;},readFields:function(e,t,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,o=this.pos;this.type=7&n,e(i,t,this),this.pos===o&&this.skip(n);}return t},readMessage:function(e,t){return this.readFields(e,t,this.readVarint()+this.pos)},readFixed32:function(){var e=Jl(this.buf,this.pos);return this.pos+=4,e},readSFixed32:function(){var e=Ql(this.buf,this.pos);return this.pos+=4,e},readFixed64:function(){var e=Jl(this.buf,this.pos)+4294967296*Jl(this.buf,this.pos+4);return this.pos+=8,e},readSFixed64:function(){var e=Jl(this.buf,this.pos)+4294967296*Ql(this.buf,this.pos+4);return this.pos+=8,e},readFloat:function(){var e=Il(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=Il(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(e){var t,r,n=this.buf;return t=127&(r=n[this.pos++]),r<128?t:(t|=(127&(r=n[this.pos++]))<<7,r<128?t:(t|=(127&(r=n[this.pos++]))<<14,r<128?t:(t|=(127&(r=n[this.pos++]))<<21,r<128?t:function(e,t,r){var n,i,o=r.buf;if(i=o[r.pos++],n=(112&i)>>4,i<128)return Cl(e,n,t);if(i=o[r.pos++],n|=(127&i)<<3,i<128)return Cl(e,n,t);if(i=o[r.pos++],n|=(127&i)<<10,i<128)return Cl(e,n,t);if(i=o[r.pos++],n|=(127&i)<<17,i<128)return Cl(e,n,t);if(i=o[r.pos++],n|=(127&i)<<24,i<128)return Cl(e,n,t);if(i=o[r.pos++],n|=(1&i)<<31,i<128)return Cl(e,n,t);throw new Error("Expected varint not more than 10 bytes")}(t|=(15&(r=n[this.pos]))<<28,e,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var e=this.readVarint();return e%2==1?(e+1)/-2:e/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var e=this.readVarint()+this.pos,t=function(e,t,r){var n="",i=t;for(;i<r;){var o,s,a,l=e[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(o=e[i+1]))&&(u=(31&l)<<6|63&o)<=127&&(u=null):3===c?(o=e[i+1],s=e[i+2],128==(192&o)&&128==(192&s)&&((u=(15&l)<<12|(63&o)<<6|63&s)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(o=e[i+1],s=e[i+2],a=e[i+3],128==(192&o)&&128==(192&s)&&128==(192&a)&&((u=(15&l)<<18|(63&o)<<12|(63&s)<<6|63&a)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,this.pos,e);return this.pos=e,t},readBytes:function(){var e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t},readPackedVarint:function(e,t){var r=Gl(this);for(e=e||[];this.pos<r;)e.push(this.readVarint(t));return e},readPackedSVarint:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readSVarint());return e},readPackedBoolean:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readBoolean());return e},readPackedFloat:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readFloat());return e},readPackedDouble:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readDouble());return e},readPackedFixed32:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readFixed32());return e},readPackedSFixed32:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed32());return e},readPackedFixed64:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readFixed64());return e},readPackedSFixed64:function(e){var t=Gl(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed64());return e},skip:function(e){var t=7&e;if(t===Dl.Varint)for(;this.buf[this.pos++]>127;);else if(t===Dl.Bytes)this.pos=this.readVarint()+this.pos;else if(t===Dl.Fixed32)this.pos+=4;else{if(t!==Dl.Fixed64)throw new Error("Unimplemented type: "+t);this.pos+=8;}},writeTag:function(e,t){this.writeVarint(e<<3|t);},realloc:function(e){for(var t=this.length||16;t<this.pos+e;)t*=2;if(t!==this.length){var r=new Uint8Array(t);r.set(this.buf),this.buf=r,this.length=t;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(e){this.realloc(4),Kl(this.buf,e,this.pos),this.pos+=4;},writeSFixed32:function(e){this.realloc(4),Kl(this.buf,e,this.pos),this.pos+=4;},writeFixed64:function(e){this.realloc(8),Kl(this.buf,-1&e,this.pos),Kl(this.buf,Math.floor(e*(1/4294967296)),this.pos+4),this.pos+=8;},writeSFixed64:function(e){this.realloc(8),Kl(this.buf,-1&e,this.pos),Kl(this.buf,Math.floor(e*(1/4294967296)),this.pos+4),this.pos+=8;},writeVarint:function(e){(e=+e||0)>268435455||e<0?function(e,t){var r,n;e>=0?(r=e%4294967296|0,n=e/4294967296|0):(n=~(-e/4294967296),4294967295^(r=~(-e%4294967296))?r=r+1|0:(r=0,n=n+1|0));if(e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,r){r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos]=127&e;}(r,0,t),function(e,t){var r=(7&e)<<4;if(t.buf[t.pos++]|=r|((e>>>=3)?128:0),!e)return;if(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),!e)return;if(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),!e)return;if(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),!e)return;if(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),!e)return;t.buf[t.pos++]=127&e;}(n,t);}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))));},writeSVarint:function(e){this.writeVarint(e<0?2*-e-1:2*e);},writeBoolean:function(e){this.writeVarint(Boolean(e));},writeString:function(e){e=String(e),this.realloc(4*e.length),this.pos++;var t=this.pos;this.pos=function(e,t,r){for(var n,i,o=0;o<t.length;o++){if((n=t.charCodeAt(o))>55295&&n<57344){if(!i){n>56319||o+1===t.length?(e[r++]=239,e[r++]=191,e[r++]=189):i=n;continue}if(n<56320){e[r++]=239,e[r++]=191,e[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(e[r++]=239,e[r++]=191,e[r++]=189,i=null);n<128?e[r++]=n:(n<2048?e[r++]=n>>6|192:(n<65536?e[r++]=n>>12|224:(e[r++]=n>>18|240,e[r++]=n>>12&63|128),e[r++]=n>>6&63|128),e[r++]=63&n|128);}return r}(this.buf,e,this.pos);var r=this.pos-t;r>=128&&jl(t,r,this),this.pos=t-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(e){this.realloc(4),Fl(this.buf,e,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(e){this.realloc(8),Fl(this.buf,e,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(e){var t=e.length;this.writeVarint(t),this.realloc(t);for(var r=0;r<t;r++)this.buf[this.pos++]=e[r];},writeRawMessage:function(e,t){this.pos++;var r=this.pos;e(t,this);var n=this.pos-r;n>=128&&jl(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(e,t,r){this.writeTag(e,Dl.Bytes),this.writeRawMessage(t,r);},writePackedVarint:function(e,t){this.writeMessage(e,Vl,t);},writePackedSVarint:function(e,t){this.writeMessage(e,Bl,t);},writePackedBoolean:function(e,t){this.writeMessage(e,Xl,t);},writePackedFloat:function(e,t){this.writeMessage(e,ql,t);},writePackedDouble:function(e,t){this.writeMessage(e,Hl,t);},writePackedFixed32:function(e,t){this.writeMessage(e,Wl,t);},writePackedSFixed32:function(e,t){this.writeMessage(e,Zl,t);},writePackedFixed64:function(e,t){this.writeMessage(e,Yl,t);},writePackedSFixed64:function(e,t){this.writeMessage(e,$l,t);},writeBytesField:function(e,t){this.writeTag(e,Dl.Bytes),this.writeBytes(t);},writeFixed32Field:function(e,t){this.writeTag(e,Dl.Fixed32),this.writeFixed32(t);},writeSFixed32Field:function(e,t){this.writeTag(e,Dl.Fixed32),this.writeSFixed32(t);},writeFixed64Field:function(e,t){this.writeTag(e,Dl.Fixed64),this.writeFixed64(t);},writeSFixed64Field:function(e,t){this.writeTag(e,Dl.Fixed64),this.writeSFixed64(t);},writeVarintField:function(e,t){this.writeTag(e,Dl.Varint),this.writeVarint(t);},writeSVarintField:function(e,t){this.writeTag(e,Dl.Varint),this.writeSVarint(t);},writeStringField:function(e,t){this.writeTag(e,Dl.Bytes),this.writeString(t);},writeFloatField:function(e,t){this.writeTag(e,Dl.Fixed32),this.writeFloat(t);},writeDoubleField:function(e,t){this.writeTag(e,Dl.Fixed64),this.writeDouble(t);},writeBooleanField:function(e,t){this.writeVarintField(e,Boolean(t));}};var eu=tu;function tu(e,t){this.x=e,this.y=t;}tu.prototype={clone:function(){return new tu(this.x,this.y)},add:function(e){return this.clone()._add(e)},sub:function(e){return this.clone()._sub(e)},multByPoint:function(e){return this.clone()._multByPoint(e)},divByPoint:function(e){return this.clone()._divByPoint(e)},mult:function(e){return this.clone()._mult(e)},div:function(e){return this.clone()._div(e)},rotate:function(e){return this.clone()._rotate(e)},rotateAround:function(e,t){return this.clone()._rotateAround(e,t)},matMult:function(e){return this.clone()._matMult(e)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(e){return this.x===e.x&&this.y===e.y},dist:function(e){return Math.sqrt(this.distSqr(e))},distSqr:function(e){var t=e.x-this.x,r=e.y-this.y;return t*t+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith:function(e){return this.angleWithSep(e.x,e.y)},angleWithSep:function(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult:function(e){var t=e[0]*this.x+e[1]*this.y,r=e[2]*this.x+e[3]*this.y;return this.x=t,this.y=r,this},_add:function(e){return this.x+=e.x,this.y+=e.y,this},_sub:function(e){return this.x-=e.x,this.y-=e.y,this},_mult:function(e){return this.x*=e,this.y*=e,this},_div:function(e){return this.x/=e,this.y/=e,this},_multByPoint:function(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint:function(e){return this.x/=e.x,this.y/=e.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var e=this.y;return this.y=this.x,this.x=-e,this},_rotate:function(e){var t=Math.cos(e),r=Math.sin(e),n=t*this.x-r*this.y,i=r*this.x+t*this.y;return this.x=n,this.y=i,this},_rotateAround:function(e,t){var r=Math.cos(e),n=Math.sin(e),i=t.x+r*(this.x-t.x)-n*(this.y-t.y),o=t.y+n*(this.x-t.x)+r*(this.y-t.y);return this.x=i,this.y=o,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},tu.convert=function(e){return e instanceof tu?e:Array.isArray(e)?new tu(e[0],e[1]):e};var ru=nu;function nu(e,t,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=e,this._geometry=-1,this._keys=n,this._values=i,e.readFields(iu,this,t);}function iu(e,t,r){1==e?t.id=r.readVarint():2==e?function(e,t){var r=e.readVarint()+e.pos;for(;e.pos<r;){var n=t._keys[e.readVarint()],i=t._values[e.readVarint()];t.properties[n]=i;}}(r,t):3==e?t.type=r.readVarint():4==e&&(t._geometry=r.pos);}function ou(e){for(var t,r,n=0,i=0,o=e.length,s=o-1;i<o;s=i++)t=e[i],n+=((r=e[s]).x-t.x)*(t.y+r.y);return n}nu.types=["Unknown","Point","LineString","Polygon"],nu.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var t,r=e.readVarint()+e.pos,n=1,i=0,o=0,s=0,a=[];e.pos<r;){if(!i){var l=e.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)o+=e.readSVarint(),s+=e.readSVarint(),1===n&&(t&&a.push(t),t=[]),t.push(new eu(o,s));else{if(7!==n)throw new Error("unknown command "+n);t&&t.push(t[0].clone());}}return t&&a.push(t),a},nu.prototype.bbox=function(){var e=this._pbf;e.pos=this._geometry;for(var t=e.readVarint()+e.pos,r=1,n=0,i=0,o=0,s=1/0,a=-1/0,l=1/0,u=-1/0;e.pos<t;){if(!n){var c=e.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=e.readSVarint())<s&&(s=i),i>a&&(a=i),(o+=e.readSVarint())<l&&(l=o),o>u&&(u=o);else if(7!==r)throw new Error("unknown command "+r)}return [s,l,a,u]},nu.prototype.toGeoJSON=function(e,t,r){var n,i,o=this.extent*Math.pow(2,r),s=this.extent*e,a=this.extent*t,l=this.loadGeometry(),u=nu.types[this.type];function c(e){for(var t=0;t<e.length;t++){var r=e[t],n=180-360*(r.y+a)/o;e[t]=[360*(r.x+s)/o-180,360/Math.PI*Math.atan(Math.exp(n*Math.PI/180))-90];}}switch(this.type){case 1:var f=[];for(n=0;n<l.length;n++)f[n]=l[n][0];c(l=f);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(e){var t=e.length;if(t<=1)return [e];for(var r,n,i=[],o=0;o<t;o++){var s=ou(e[o]);0!==s&&(void 0===n&&(n=s<0),n===s<0?(r&&i.push(r),r=[e[o]]):r.push(e[o]));}r&&i.push(r);return i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var h={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(h.id=this.id),h};var su=au;function au(e,t){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(lu,this,t),this.length=this._features.length;}function lu(e,t,r){15===e?t.version=r.readVarint():1===e?t.name=r.readString():5===e?t.extent=r.readVarint():2===e?t._features.push(r.pos):3===e?t._keys.push(r.readString()):4===e&&t._values.push(function(e){var t=null,r=e.readVarint()+e.pos;for(;e.pos<r;){var n=e.readVarint()>>3;t=1===n?e.readString():2===n?e.readFloat():3===n?e.readDouble():4===n?e.readVarint64():5===n?e.readVarint():6===n?e.readSVarint():7===n?e.readBoolean():null;}return t}(r));}function uu(e,t,r){if(3===e){var n=new su(r,r.readVarint()+r.pos);n.length&&(t[n.name]=n);}}au.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var t=this._pbf.readVarint()+this._pbf.pos;return new ru(this._pbf,t,this.extent,this._keys,this._values)};var cu=function(e,t){this.layers=e.readFields(uu,{},t);},fu=ru,hu={NONE:0,ALL:1,SOME:2},du=["{","["],_u=function(e){function t(t,r){var n;if((n=e.call(this,t,r)||this).response_type="arraybuffer",!0===t.parse_json)n.parse_json_type=hu.ALL;else if(Array.isArray(t.parse_json))n.parse_json_type=hu.SOME,n.parse_json_prop_list=t.parse_json;else{if(null!=t.parse_json)Qr({level:"warn",once:!0},"Data source '"+n.name+"': 'parse_json' parameter should be 'true', or an array of property names (was '"+JSON.stringify(t.parse_json)+"')");n.parse_json_type=hu.NONE;}return n}Or(t,e);var r=t.prototype;return r.parseSourceData=function(e,t,r){var n=new Uint8Array(r),i=new Ul(n);if(t.data=new cu(i),t.layers=this.toGeoJSON(t.data),"function"==typeof this.transform){var o={min:Object.assign({},e.min),max:Object.assign({},e.max),coords:Object.assign({},e.coords)};t.layers=this.transform(t.layers,this.extra_data,o);}delete t.data;},r.toGeoJSON=function(e){var t={};for(var r in e.layers){for(var n=e.layers[r],i=ui.tile_scale/n.extent,o={type:"FeatureCollection",features:[]},s=0;s<n.length;s++){var a=n.feature(s),l={type:"Feature",geometry:{},id:a.id,properties:a.properties};this.parseJSONProperties(l);for(var u=l.geometry,c=a.loadGeometry(),f=0;f<c.length;f++)for(var h=c[f],d=0;d<h.length;d++)h[d]=[h[d].x*i,h[d].y*i];u.coordinates=c,"Point"===fu.types[a.type]?(u.type="Point",u.coordinates=u.coordinates[0][0]):"LineString"===fu.types[a.type]?1===c.length?(u.type="LineString",u.coordinates=u.coordinates[0]):u.type="MultiLineString":"Polygon"===fu.types[a.type]&&(u=pu(u)),o.features.push(l);}t[r]=o;}return t},r.parseJSONProperties=function(e){if(this.parse_json_type!==hu.NONE){var t=e.properties;if(this.parse_json_type===hu.SOME)this.parse_json_prop_list.forEach(function(e){try{t[e]=JSON.parse(t[e]);}catch(e){}});else for(var r in t)if(du.indexOf(t[r][0])>-1)try{t[r]=JSON.parse(t[r]);}catch(e){}}},t}(_o);function pu(e){for(var t,r=[],n=[],i=0;i<e.coordinates.length;i++){var o=e.coordinates[i],s=ui.ringWinding(o);null!=s&&(s===(t=t||s)&&n.length>0&&(r.push(n),n=[]),n.push(o));}return n.length>0&&r.push(n),1===r.length?(e.type="Polygon",e.coordinates=r[0]):r.length>1?(e.type="MultiPolygon",e.coordinates=r):e=null,e}co.register("MVT",function(){return _u});var mu=function(e,t){var r,n,i,o,s=t*t,a=e.length,l=0,u=a-1,c=[];e[l][2]=1,e[u][2]=1;for(;u;){for(n=0,r=l+1;r<u;r++)(i=vu(e[r],e[l],e[u]))>n&&(o=r,n=i);n>s?(e[o][2]=n,c.push(l),c.push(o),l=o):(u=c.pop(),l=c.pop());}};function vu(e,t,r){var n=t[0],i=t[1],o=r[0],s=r[1],a=e[0],l=e[1],u=o-n,c=s-i;if(0!==u||0!==c){var f=((a-n)*u+(l-i)*c)/(u*u+c*c);f>1?(n=o,i=s):f>0&&(n+=u*f,i+=c*f);}return (u=a-n)*u+(c=l-i)*c}var gu=function(e,t,r,n){var i={id:n||null,type:t,geometry:r,tags:e||null,min:[1/0,1/0],max:[-1/0,-1/0]};return function(e){var t=e.geometry,r=e.min,n=e.max;if(1===e.type)yu(r,n,t);else for(var i=0;i<t.length;i++)yu(r,n,t[i]);}(i),i};function yu(e,t,r){for(var n,i=0;i<r.length;i++)n=r[i],e[0]=Math.min(n[0],e[0]),t[0]=Math.max(n[0],t[0]),e[1]=Math.min(n[1],e[1]),t[1]=Math.max(n[1],t[1]);}var xu=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var n=0;n<e.features.length;n++)bu(r,e.features[n],t);else"Feature"===e.type?bu(r,e,t):bu(r,{geometry:e},t);return r};function bu(e,t,r){if(null!==t.geometry){var n,i,o,s,a=t.geometry,l=a.type,u=a.coordinates,c=t.properties,f=t.id;if("Point"===l)e.push(gu(c,1,[Tu(u)],f));else if("MultiPoint"===l)e.push(gu(c,1,Au(u),f));else if("LineString"===l)e.push(gu(c,2,[Au(u,r)],f));else if("MultiLineString"===l||"Polygon"===l){for(o=[],n=0;n<u.length;n++)s=Au(u[n],r),"Polygon"===l&&(s.outer=0===n),o.push(s);e.push(gu(c,"Polygon"===l?3:2,o,f));}else if("MultiPolygon"===l){for(o=[],n=0;n<u.length;n++)for(i=0;i<u[n].length;i++)(s=Au(u[n][i],r)).outer=0===i,o.push(s);e.push(gu(c,3,o,f));}else{if("GeometryCollection"!==l)throw new Error("Input data is not a valid GeoJSON object.");for(n=0;n<a.geometries.length;n++)bu(e,{geometry:a.geometries[n],properties:c},r);}}}function Au(e,t){for(var r=[],n=0;n<e.length;n++)r.push(Tu(e[n]));return t&&(mu(r,t),function(e){for(var t,r,n=0,i=0,o=0;o<e.length-1;o++)t=r||e[o],r=e[o+1],n+=t[0]*r[1]-r[0]*t[1],i+=Math.abs(r[0]-t[0])+Math.abs(r[1]-t[1]);e.area=Math.abs(n/2),e.dist=i;}(r)),r}function Tu(e){var t=Math.sin(e[1]*Math.PI/180),r=e[0]/360+.5,n=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return [r,n=n<0?0:n>1?1:n,0]}function wu(e,t,r,n,i){return [Math.round(t*(e[0]*r-n)),Math.round(t*(e[1]*r-i))]}var Eu={tile:function(e,t){if(e.transformed)return e;var r,n,i,o=e.z2,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,c=l.type;if(1===c)for(n=0;n<u.length;n++)u[n]=wu(u[n],t,o,s,a);else for(n=0;n<u.length;n++){var f=u[n];for(i=0;i<f.length;i++)f[i]=wu(f[i],t,o,s,a);}}return e.transformed=!0,e},point:wu},Ru=function(e,t,r,n,i,o,s,a){if(n/=t,s>=(r/=t)&&a<=n)return e;if(s>n||a<r)return null;for(var l=[],u=0;u<e.length;u++){var c,f,h=e[u],d=h.geometry,_=h.type;if(c=h.min[i],f=h.max[i],c>=r&&f<=n)l.push(h);else if(!(c>n||f<r)){var p=1===_?Mu(d,r,n,i):Su(d,r,n,i,o,3===_);p.length&&l.push(gu(h.tags,_,p,h.id));}}return l.length?l:null};function Mu(e,t,r,n){for(var i=[],o=0;o<e.length;o++){var s=e[o],a=s[n];a>=t&&a<=r&&i.push(s);}return i}function Su(e,t,r,n,i,o){for(var s=[],a=0;a<e.length;a++){var l,u,c,f=0,h=0,d=null,_=e[a],p=_.area,m=_.dist,v=_.outer,g=_.length,y=[];for(u=0;u<g-1;u++)l=d||_[u],d=_[u+1],f=h||l[n],h=d[n],f<t?h>r?(y.push(i(l,d,t),i(l,d,r)),o||(y=zu(s,y,p,m,v))):h>=t&&y.push(i(l,d,t)):f>r?h<t?(y.push(i(l,d,r),i(l,d,t)),o||(y=zu(s,y,p,m,v))):h<=r&&y.push(i(l,d,r)):(y.push(l),h<t?(y.push(i(l,d,t)),o||(y=zu(s,y,p,m,v))):h>r&&(y.push(i(l,d,r)),o||(y=zu(s,y,p,m,v))));(f=(l=_[g-1])[n])>=t&&f<=r&&y.push(l),c=y[y.length-1],o&&c&&(y[0][0]!==c[0]||y[0][1]!==c[1])&&y.push(y[0]),zu(s,y,p,m,v);}return s}function zu(e,t,r,n,i){return t.length&&(t.area=r,t.dist=n,void 0!==i&&(t.outer=i),e.push(t)),[]}var Nu=function(e,t,r){var n=e,i=Ru(e,1,-1-t,t,0,r,-1,2),o=Ru(e,1,1-t,2+t,0,r,-1,2);(i||o)&&(n=Ru(e,1,-t,1+t,0,r,-1,2)||[],i&&(n=Pu(i,1).concat(n)),o&&(n=n.concat(Pu(o,-1))));return n};function Pu(e,t){for(var r=[],n=0;n<e.length;n++){var i,o=e[n],s=o.type;if(1===s)i=ku(o.geometry,t);else{i=[];for(var a=0;a<o.geometry.length;a++)i.push(ku(o.geometry[a],t));}r.push(gu(o.tags,s,i,o.id));}return r}function ku(e,t){var r=[];r.area=e.area,r.dist=e.dist;for(var n=0;n<e.length;n++)r.push([e[n][0]+t,e[n][1],e[n][2]]);return r}var Ou=function(e,t,r,n,i,o){for(var s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:n,z2:t,transformed:!1,min:[2,1],max:[-1,0]},a=0;a<e.length;a++){s.numFeatures++,Lu(s,e[a],i,o);var l=e[a].min,u=e[a].max;l[0]<s.min[0]&&(s.min[0]=l[0]),l[1]<s.min[1]&&(s.min[1]=l[1]),u[0]>s.max[0]&&(s.max[0]=u[0]),u[1]>s.max[1]&&(s.max[1]=u[1]);}return s};function Lu(e,t,r,n){var i,o,s,a,l=t.geometry,u=t.type,c=[],f=r*r;if(1===u)for(i=0;i<l.length;i++)c.push(l[i]),e.numPoints++,e.numSimplified++;else for(i=0;i<l.length;i++)if(s=l[i],n||!(2===u&&s.dist<r||3===u&&s.area<f)){var h=[];for(o=0;o<s.length;o++)a=s[o],(n||a[2]>f)&&(h.push(a),e.numSimplified++),e.numPoints++;3===u&&Iu(h,s.outer),c.push(h);}else e.numPoints+=s.length;if(c.length){var d={geometry:c,type:u,tags:t.tags||null};null!==t.id&&(d.id=t.id),e.features.push(d);}}function Iu(e,t){(function(e){for(var t,r,n=0,i=0,o=e.length,s=o-1;i<o;s=i++)t=e[i],r=e[s],n+=(r[0]-t[0])*(t[1]+r[1]);return n})(e)<0===t&&e.reverse();}var Fu=function(e,t){return new Uu(e,t)};function Uu(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;r&&console.time("preprocess data");var n=1<<t.maxZoom,i=xu(e,t.tolerance/(n*t.extent));this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(i=Nu(i,t.buffer/t.extent,Gu)).length&&this.splitTile(i,0,0,0),r&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function Du(e,t,r){return 32*((1<<e)*r+t)+e}function Gu(e,t,r){return [r,(r-e[0])*(t[1]-e[1])/(t[0]-e[0])+e[1],1]}function Cu(e,t,r){return [(r-e[1])*(t[0]-e[0])/(t[1]-e[1])+e[0],r,1]}function ju(e,t,r){var n=e.source;if(1!==n.length)return !1;var i=n[0];if(3!==i.type||i.geometry.length>1)return !1;var o=i.geometry[0].length;if(5!==o)return !1;for(var s=0;s<o;s++){var a=Eu.point(i.geometry[0][s],t,e.z2,e.x,e.y);if(a[0]!==-r&&a[0]!==t+r||a[1]!==-r&&a[1]!==t+r)return !1}return !0}Uu.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,solidChildren:!1,tolerance:3,extent:4096,buffer:64,debug:0},Uu.prototype.splitTile=function(e,t,r,n,i,o,s){for(var a=[e,t,r,n],l=this.options,u=l.debug,c=null;a.length;){n=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var f=1<<t,h=Du(t,r,n),d=this.tiles[h],_=t===l.maxZoom?0:l.tolerance/(f*l.extent);if(!d&&(u>1&&console.time("creation"),d=this.tiles[h]=Ou(e,f,r,n,_,t===l.maxZoom),this.tileCoords.push({z:t,x:r,y:n}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,n,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(d.source=e,i){if(t===l.maxZoom||t===i)continue;var m=1<<i-t;if(r!==Math.floor(o/m)||n!==Math.floor(s/m))continue}else if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue;if(l.solidChildren||!ju(d,l.extent,l.buffer)){d.source=null,u>1&&console.time("clipping");var v,g,y,x,b,A,T=.5*l.buffer/l.extent,w=.5-T,E=.5+T,R=1+T;v=g=y=x=null,b=Ru(e,f,r-T,r+E,0,Gu,d.min[0],d.max[0]),A=Ru(e,f,r+w,r+R,0,Gu,d.min[0],d.max[0]),b&&(v=Ru(b,f,n-T,n+E,1,Cu,d.min[1],d.max[1]),g=Ru(b,f,n+w,n+R,1,Cu,d.min[1],d.max[1])),A&&(y=Ru(A,f,n-T,n+E,1,Cu,d.min[1],d.max[1]),x=Ru(A,f,n+w,n+R,1,Cu,d.min[1],d.max[1])),u>1&&console.timeEnd("clipping"),e.length&&(a.push(v||[],t+1,2*r,2*n),a.push(g||[],t+1,2*r,2*n+1),a.push(y||[],t+1,2*r+1,2*n),a.push(x||[],t+1,2*r+1,2*n+1));}else i&&(c=t);}return c},Uu.prototype.getTile=function(e,t,r){var n=this.options,i=n.extent,o=n.debug,s=1<<e,a=Du(e,t=(t%s+s)%s,r);if(this.tiles[a])return Eu.tile(this.tiles[a],i);o>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,c=t,f=r;!l&&u>0;)u--,c=Math.floor(c/2),f=Math.floor(f/2),l=this.tiles[Du(u,c,f)];if(!l||!l.source)return null;if(o>1&&console.log("found parent tile z%d-%d-%d",u,c,f),ju(l,i,n.buffer))return Eu.tile(l,i);o>1&&console.time("drilling down");var h=this.splitTile(l.source,u,c,f,e,t,r);if(o>1&&console.timeEnd("drilling down"),null!==h){var d=1<<e-h;a=Du(h,Math.floor(t/d),Math.floor(r/d));}return this.tiles[a]?Eu.tile(this.tiles[a],i):null};var Vu=function(e){function t(t,r){var n;return (n=e.call(this,t,r)||this).load_data=null,n.tile_indexes={},n.setTileSize(512),n.pad_scale=0,n}Or(t,e);var r=t.prototype;return r._load=function(t){var r=this;return this.load_data||(this.load_data=e.prototype._load.call(this,{source_data:{layers:{}}}).then(function(e){e.source_data.error&&Qr("warn","data source load error(s) for source '"+r.name+"', URL '"+r.url+"': "+e.source_data.error);var t=e.source_data.layers;for(var n in t)r.tile_indexes[n]=Fu(t[n],{maxZoom:r.max_zoom,tolerance:1.5,extent:ui.tile_scale,buffer:1e-4});return r.loaded=!0,e})),this.load_data.then(function(){for(var e in r.tile_indexes)t.source_data.layers[e]=r.getTileFeatures(t,e);return t})},r.getTileFeatures=function(e,t){var r,n=ui.wrapTile(e.coords,{x:!0}),i=this.tile_indexes[t].getTile(n.z,n.x,n.y);if(i&&i.features){r={type:"FeatureCollection",features:[]};for(var o=0;o<i.features.length;o++){var s=i.features[o],a={type:"Feature",geometry:{},id:s.id,properties:s.tags};if(1===s.type)a.geometry.coordinates=s.geometry.map(function(e){return [e[0],e[1]]}),a.geometry.type="MultiPoint";else{if(2!==s.type&&3!==s.type)continue;if(a.geometry.coordinates=s.geometry.map(function(e){return e.map(function(e){return [e[0],e[1]]})}),2===s.type)a.geometry.type="MultiLineString";else if(a.geometry=pu(a.geometry),null==a.geometry)continue}r.features.push(a);}}return r},r.formatURL=function(){return this.url},r.parseSourceData=function(e,t,r){var n="string"==typeof r?JSON.parse(r):r,i=this.getLayers(n);t.layers=this.preprocessLayers(i,e);},r.preprocessLayers=function(e,t){for(var r in e){var n=e[r];n.features=this.preprocessFeatures(n.features);}if("function"==typeof this.transform){var i={min:Object.assign({},t.min),max:Object.assign({},t.max),coords:Object.assign({},t.coords)};1===Object.keys(e).length&&e._default?e._default=this.transform(e._default,this.extra_data,i):e=this.transform(e,this.extra_data,i);}return e},r.preprocessFeatures=function(e){if(e=e.filter(function(e){return null!=e.geometry}),this.config.generate_label_centroids){var t=[],r={label_placement:!0};e.forEach(function(e){var n,i;if("Polygon"===e.geometry.type)i=qu(n=e.geometry.coordinates,e.id,e.properties,r),t.push(i);else if("MultiPolygon"===e.geometry.type){n=e.geometry.coordinates;for(var o=-1/0,s=0,a=0;a<n.length;a++){var l=ui.polygonArea(n[a]);l>o&&(o=l,s=a);}i=qu(n[s],e.id,e.properties,r),t.push(i);}}),t=t.filter(function(e){return e}),Array.prototype.push.apply(e,t);}return e},r.getLayers=function(e){return "Feature"===e.type?{_default:{type:"FeatureCollection",features:[e]}}:"FeatureCollection"===e.type?{_default:e}:e},t}(ho),Bu=function(e){function t(t,r){return e.call(this,t,r)||this}Or(t,e);var r=t.prototype;return r.parseSourceData=function(e,t,r){var n="string"==typeof r?JSON.parse(r):r;this.prepareGeoJSON(n,e,t);},r.prepareGeoJSON=function(e,t,r){if("function"==typeof this.transform){var n={min:Object.assign({},t.min),max:Object.assign({},t.max),coords:Object.assign({},t.coords)};e=this.transform(e,this.extra_data,n);}r.layers=Vu.prototype.getLayers(e);var i={coords:t.coords,min:ui.metersForTile(ui.wrapTile(t.coords,{x:!0}))};co.projectData(r),co.scaleData(r,i);},t}(_o);function qu(e,t,r,n){var i=ui.centroid(e);if(i){var o={};return Object.assign(o,r,n),{type:"Feature",id:t,properties:o,geometry:{type:"Point",coordinates:i}}}}function Hu(e){return e}function Xu(e,t){var r=t.id,n=t.bbox,i=null==t.properties?{}:t.properties,o=function(e,t){var r=function(e){if(null==(t=e.transform))return Hu;var t,r,n,i=t.scale[0],o=t.scale[1],s=t.translate[0],a=t.translate[1];return function(e,t){return t||(r=n=0),e[0]=(r+=e[0])*i+s,e[1]=(n+=e[1])*o+a,e}}(e),n=e.arcs;function i(e,t){t.length&&t.pop();for(var i=n[e<0?~e:e],o=0,s=i.length;o<s;++o)t.push(r(i[o].slice(),o));e<0&&function(e,t){for(var r,n=e.length,i=n-t;i<--n;)r=e[i],e[i++]=e[n],e[n]=r;}(t,s);}function o(e){return r(e.slice())}function s(e){for(var t=[],r=0,n=e.length;r<n;++r)i(e[r],t);return t.length<2&&t.push(t[0].slice()),t}function a(e){for(var t=s(e);t.length<4;)t.push(t[0].slice());return t}function l(e){return e.map(a)}return function e(t){var r,n=t.type;switch(n){case"GeometryCollection":return {type:n,geometries:t.geometries.map(e)};case"Point":r=o(t.coordinates);break;case"MultiPoint":r=t.coordinates.map(o);break;case"LineString":r=s(t.arcs);break;case"MultiLineString":r=t.arcs.map(s);break;case"Polygon":r=l(t.arcs);break;case"MultiPolygon":r=t.arcs.map(l);break;default:return null}return {type:n,coordinates:r}}(t)}(e,t);return null==r&&null==n?{type:"Feature",properties:i,geometry:o}:null==n?{type:"Feature",id:r,properties:i,geometry:o}:{type:"Feature",id:r,bbox:n,properties:i,geometry:o}}co.register("GeoJSON",function(e){return Bu.urlHasTilePattern(e.url)?Bu:Vu});var Wu=function(e){function t(){return e.apply(this,arguments)||this}Or(t,e);var r=t.prototype;return r.parseSourceData=function(t,r,n){var i="string"==typeof n?JSON.parse(n):n;i=this.toGeoJSON(i);var o=this.getLayers(i);e.prototype.preprocessLayers.call(this,o,t),r.layers=o;},r.toGeoJSON=function(e){if(e.objects&&1===Object.keys(e.objects).length){var t=Object.keys(e.objects)[0];e=Zu(e,e.objects[t]);}else{var r={};for(var n in e.objects)r[n]=Zu(e,e.objects[n]);e=r;}return e},t}(Vu);function Zu(e,t){var r=function(e,t){return "GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map(function(t){return Xu(e,t)})}:Xu(e,t)}(e,t);return "Feature"===r.type&&(r={type:"FeatureCollection",features:[r]}),r}var Yu=function(e){function t(t,r){return e.call(this,t,r)||this}return Or(t,e),t.prototype.parseSourceData=function(e,t,r){var n="string"==typeof r?JSON.parse(r):r;n=Wu.prototype.toGeoJSON(n),this.prepareGeoJSON(n,e,t);},t}(Bu);co.register("TopoJSON",function(e){return Yu.urlHasTilePattern(e.url)?Yu:Wu}),e.$export=D,e.Collision=ia,e.DataSource=co,e.FeatureSelection=Ji,e.FilterOptions=zl,e.FontManager=pa,e.GLSL=Zn,e.Geo=ui,e.Label=ea,e.LabelLineStraight=Ja,e.LabelPoint=oa,e.Light=io,e.Material=ro,e.OBB=Qs,e.ShaderProgram=ti,e.Style=go,e.StyleManager=ol,e.StyleParser=Di,e.Task=En,e.TextCanvas=Oa,e.Texture=qn,e.Thread=Ue,e.Tile=Ll,e.TileID=po,e.Utils=nn,e.Vector=no,e.VertexArrayObject=ri,e.VertexData=Eo,e.VertexElements=To,e.View=qa,e.WorkerBroker=Hr,e._createClass=kr,e._inheritsLoose=Or,e.addBaseURL=function(e,t){if(!e||!Tn(e))return e;var r,n="/"!==e[0];if(t?(r=document.createElement("a")).href=t:r=window.location,n)e=An(r.href)+e;else{var i=r.origin;i||(i=r.protocol+"//"+r.host),e=i+e;}return e},e.anObject=c,e.buildFilter=bl,e.cache=Li,e.clearFunctionStringCache=function(){Li.functions={},Li.num_functions=0,Li.num_cached=0;},e.commonjsRequire=function(){throw new Error("Dynamic requires are not currently supported by rollup-plugin-commonjs")},e.compileFunctionStrings=Ii,e.core=r,e.createCommonjsModule=t,e.createObjectURL=function(e){return void 0===xn&&"function"!=typeof(xn=window.URL&&window.URL.createObjectURL||window.webkitURL&&window.webkitURL.createObjectURL)&&(xn=null,Qr("warn","window.URL.createObjectURL (or vendor prefix) not found, unable to create local blob URLs")),xn?xn(e):e},e.debugSettings=on,e.debugSumLayerStats=function(e){var t={},r={};return e.filter(function(e){return e.debug.layers}).forEach(function(e){Object.keys(e.debug.layers.list).forEach(function(r){var n=e.debug.layers.list[r];yo(t,r,n.features,n.geoms,n.styles,n.base);}),function e(t,r){for(var n in t){var i=t[n];yo(r,n,i.features,i.geoms,i.styles,i.base),i.layers&&(r[n].layers=r[n].layers||{},e(i.layers,r[n].layers));}}(e.debug.layers.tree,r);}),{list:t,tree:r}},e.extensionForURL=function(e){var t=(e=e.split("/").pop()).lastIndexOf(".");if(t>-1)return e.substring(t+1)},e.flattenRelativeURL=function(e){for(var t=(e||"").split("/"),r=1;r<t.length;r++)"."===t[r]?(t.splice(r,1),r--):".."===t[r]&&(r+=0,t.splice(r-1,2),r--);return t.join("/")},e.getKeys=ee,e.global=n,e.has=O,e.isArray=dt,e.isLocalURL=function(e){if("string"==typeof e)return e.search(/^(data|blob):/)>-1},e.isObject=u,e.isRelativeURL=Tn,e.isReserved=Nl,e.layerCache=function(){return Tl},e.log=Qr,e.mergeDebugSettings=function(e){Object.assign(rn,e);},e.mergeObjects=li,e.parseLayers=function(e,t){Tl={};var r={};for(var n in e){var i=e[n];i&&(r[n]=Pl(n,i,null,t));}return r},e.pathForURL=An,e.require$$0=Le,e.require$$0$1=pt,e.require$$0$2=ht,e.require$$0$3=f,e.require$$0$4=Bn,e.require$$1=!1,e.require$$1$1=vt,e.require$$10=b,e.require$$2=y,e.require$$26=a,e.require$$27=l,e.require$$3=Oe,e.require$$4=ae,e.require$$5=h,e.require$$6=L,e.require$$9=x,e.setToStringTag=ce,e.shared=i,e.sliceObject=Mn,e.subscribeMixin=Rn,e.toIObject=P,e.toPrimitive=v,e.version=Gr;});

define(["./shared"],function(e){"use strict";var t=Object.assign(self,{FeatureSelection:e.FeatureSelection,sources:{},styles:{},layers:{},tiles:{},init:function(t,r,i,o,s,n,a){return this.scene_id=t,this._worker_id=r,this.num_workers=i,e.log.setLevel(o),e.Utils.device_pixel_ratio=s,e.VertexElements.setElementIndexUint(n),e.FeatureSelection.setPrefix(this._worker_id),this.style_manager=new e.StyleManager,this.importExternalScripts(a),e.Label.id_prefix=r,e.Label.id_multiplier=i,r},importExternalScripts:function(t){var r=this;if(0!==t.length){e.log("debug","loading custom data source scripts in worker:",t);var i=Object.getOwnPropertyNames(window);importScripts.apply(void 0,t),Object.getOwnPropertyNames(window).forEach(function(e){-1===i.indexOf(e)&&(r[e]=window[e]);});}},updateConfig:function(t,r){var i=t.config,o=t.generation,s=t.introspection;return i=JSON.parse(i),e.mergeDebugSettings(r),this.generation=o,this.introspection=s,this.global=e.compileFunctionStrings(i.global),this.createDataSources(i),i.styles=e.compileFunctionStrings(i.styles,e.StyleParser.wrapFunction),this.styles=this.style_manager.build(i.styles),this.style_manager.initStyles({generation:this.generation,styles:this.styles,sources:this.sources,introspection:this.introspection}),this.layers=e.parseLayers(i.layers,this.style_manager.styles),this.syncing_textures=this.syncTextures(i.textures),this.configuring=this.syncing_textures.then(function(){e.log("debug","updated config");}),this.configuring},createDataSources:function(t){var r=this;this.last_config_sources=this.config_sources||{},this.config_sources=t.sources;var i=this.sources,o=[];for(var s in this.sources={},t.sources)if(JSON.stringify(this.last_config_sources[s])!==JSON.stringify(t.sources[s])){t.sources[s]=e.compileFunctionStrings(t.sources[s]);var n=void 0;try{n=e.DataSource.create(Object.assign({},t.sources[s],{name:s}),this.sources);}catch(e){continue}n&&(this.sources[s]=n,o.push(s));}else this.sources[s]=i[s];o.forEach(function(e){for(var t in r.tiles)r.tiles[t].source===e&&delete r.tiles[t];});},awaitConfiguration:function(){return this.configuring},buildTile:function(t){var r=this,i=t.tile;if(null==this.getTile(i.key)||!0!==this.getTile(i.key).loading)return i=this.tiles[i.key]=Object.assign(this.getTile(i.key)||{},i),this.awaitConfiguration().then(function(){if(!0!==i.loaded)i.loading=!0,i.loaded=!1,i.error=null,r.loadTileSourceData(i).then(function(){r.getTile(i.key)?(i.source_data.error&&e.log("warn","tile load error(s) for "+i.key+": "+i.source_data.error),i.loading=!1,i.loaded=!0,e.Tile.buildGeometry(i,r)):e.log("trace","stop tile build after data source load because tile was removed: "+i.key);}).catch(function(t){i.loading=!1,i.loaded=!1,i.error=t.stack,e.log("error","tile load error for "+i.key+": "+i.error),e.WorkerBroker.postMessage("TileManager_"+r.scene_id+".buildTileError",e.Tile.slice(i));});else{e.log("trace","used worker cache for tile "+i.key);try{e.Tile.buildGeometry(i,r);}catch(t){i.error=t.toString(),e.WorkerBroker.postMessage("TileManager_"+r.scene_id+".buildTileError",e.Tile.slice(i));}}})},loadTileSourceData:function(e){var t=this.sources[e.source];if(t){for(var r in this.tiles){var i=this.tiles[r];if(i.source===e.source&&i.coords.key===e.coords.key&&i.loaded)return Promise.resolve(t.copyTileData(i,e))}return t.load(e)}return e.source_data={},Promise.resolve(e)},getTile:function(e){return this.tiles[e]},removeTile:function(t){var r=this.tiles[t];null!=r&&(!0===r.loading&&(e.log("trace","cancel tile load for "+t),r.loading=!1,e.Tile.cancel(r)),e.FeatureSelection.clearTile(t),delete this.tiles[t],e.log("trace","remove tile from cache for "+t));},queryFeatures:function(t){var r=this,i=t.filter,o=t.visible,s=t.geometry,n=t.tile_keys,a=[],l=n.map(function(e){return r.tiles[e]}).filter(function(e){return e&&e.loaded});return null!=i&&(i=["{","["].indexOf(i[0])>-1?JSON.parse(i):i,i=e.compileFunctionStrings(i,e.StyleParser.wrapFunction)),i=e.buildFilter(i,e.FilterOptions),l.forEach(function(t){var n=function(n){var l=t.source_data.layers[n];if(null==l)return {v:void 0};l.features.forEach(function(l){var c=l.generation===r.generation;if(!(!0===o&&!c||!1===o&&c)){var u=e.StyleParser.getFeatureParseContext(l,t,r.global);if(u.source=t.source,u.layer=n,u.id=l.id,i(u)){var g={type:l.type,id:l.id,properties:Object.assign({},l.properties,{$source:u.source,$layer:u.layer,$geometry:u.geometry,$visible:c})};!0===s&&(g.geometry=e.Geo.copyGeometry(l.geometry),e.Geo.tileSpaceToLatlng(g.geometry,t.coords.z,t.min)),a.push(g);}}});};for(var l in t.source_data.layers){var c=n(l);if("object"==typeof c)return c.v}}),a},getFeatureSelection:function(t){var r=void 0===t?{}:t,i=r.id,o=r.key,s=e.FeatureSelection.map[o];return {id:i,feature:s&&s.feature}},resetFeatureSelection:function(t){void 0===t&&(t=null),e.FeatureSelection.reset(t);},getFeatureSelectionMapSize:function(){return e.FeatureSelection.getMapSize()},syncTextures:function(t){var r=[];return t&&r.push.apply(r,Object.keys(t)),e.log("trace","sync textures to worker:",r),r.length>0?e.Texture.syncTexturesToWorker(r):Promise.resolve()},updateDevicePixelRatio:function(t){e.Utils.device_pixel_ratio=t;},clearFunctionStringCache:function(){e.clearFunctionStringCache();},profile:function(e){console.profile("worker "+this._worker_id+": "+e);},profileEnd:function(e){console.profileEnd("worker "+this._worker_id+": "+e);},debug:{debugSettings:e.debugSettings,layerCache:e.layerCache,functionStringCache:e.cache}});e.WorkerBroker.addTarget("self",t);});

define(["./shared"],function(e){"use strict";var t={f:e.require$$27},r=e.require$$2.f,n=function(n){var i=e.core.Symbol||(e.core.Symbol=e.global.Symbol||{});"_"==n.charAt(0)||n in i||r(i,n,{value:t.f(n)});};n("asyncIterator");var i,o=e.require$$0$1.f,s={}.toString,a="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],l={f:function(t){return a&&"[object Window]"==s.call(t)?function(e){try{return o(e)}catch(e){return a.slice()}}(t):o(e.toIObject(t))}},u=e.require$$0$2.KEY,h=e.require$$1$1.f,c=e.require$$2.f,f=l.f,d=e.global.Symbol,p=e.global.JSON,g=p&&p.stringify,m=e.require$$27("_hidden"),v=e.require$$27("toPrimitive"),y={}.propertyIsEnumerable,_=e.shared("symbol-registry"),b=e.shared("symbols"),w=e.shared("op-symbols"),k=Object.prototype,S="function"==typeof d,x=e.global.QObject,C=!x||!x.prototype||!x.prototype.findChild,E=e.require$$5&&e.require$$0$3(function(){return 7!=e.require$$4(c({},"a",{get:function(){return c(this,"a",{value:7}).a}})).a})?function(e,t,r){var n=h(k,t);n&&delete k[t],c(e,t,r),n&&e!==k&&c(k,t,n);}:c,A=function(t){var r=b[t]=e.require$$4(d.prototype);return r._k=t,r},T=S&&"symbol"==typeof d.iterator?function(e){return "symbol"==typeof e}:function(e){return e instanceof d},z=function(t,r,n){return t===k&&z(w,r,n),e.anObject(t),r=e.toPrimitive(r,!0),e.anObject(n),e.has(b,r)?(n.enumerable?(e.has(t,m)&&t[m][r]&&(t[m][r]=!1),n=e.require$$4(n,{enumerable:e.require$$9(0,!1)})):(e.has(t,m)||c(t,m,e.require$$9(1,{})),t[m][r]=!0),E(t,r,n)):c(t,r,n)},O=function(t,r){e.anObject(t);for(var n,i=function(t){var r=e.getKeys(t),n=e.require$$3.f;if(n)for(var i,o=n(t),s=e.require$$0.f,a=0;o.length>a;)s.call(t,i=o[a++])&&r.push(i);return r}(r=e.toIObject(r)),o=0,s=i.length;s>o;)z(t,n=i[o++],r[n]);return t},R=function(t){var r=y.call(this,t=e.toPrimitive(t,!0));return !(this===k&&e.has(b,t)&&!e.has(w,t))&&(!(r||!e.has(this,t)||!e.has(b,t)||e.has(this,m)&&this[m][t])||r)},L=function(t,r){if(t=e.toIObject(t),r=e.toPrimitive(r,!0),t!==k||!e.has(b,r)||e.has(w,r)){var n=h(t,r);return !n||!e.has(b,r)||e.has(t,m)&&t[m][r]||(n.enumerable=!0),n}},I=function(t){for(var r,n=f(e.toIObject(t)),i=[],o=0;n.length>o;)e.has(b,r=n[o++])||r==m||r==u||i.push(r);return i},B=function(t){for(var r,n=t===k,i=f(n?w:e.toIObject(t)),o=[],s=0;i.length>s;)!e.has(b,r=i[s++])||n&&!e.has(k,r)||o.push(b[r]);return o};S||(d=function(){if(this instanceof d)throw TypeError("Symbol is not a constructor!");var t=e.require$$26(arguments.length>0?arguments[0]:void 0),r=function(n){this===k&&r.call(w,n),e.has(this,m)&&e.has(this[m],t)&&(this[m][t]=!1),E(this,t,e.require$$9(1,n));};return e.require$$5&&C&&E(k,t,{configurable:!0,set:r}),A(t)},e.require$$6(d.prototype,"toString",function(){return this._k}),e.require$$1$1.f=L,e.require$$2.f=z,e.require$$0$1.f=l.f=I,e.require$$0.f=R,e.require$$3.f=B,e.require$$5&&!e.require$$1&&e.require$$6(k,"propertyIsEnumerable",R,!0),t.f=function(t){return A(e.require$$27(t))}),e.$export(e.$export.G+e.$export.W+e.$export.F*!S,{Symbol:d});for(var F="hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","),P=0;F.length>P;)e.require$$27(F[P++]);for(var M=e.getKeys(e.require$$27.store),j=0;M.length>j;)n(M[j++]);e.$export(e.$export.S+e.$export.F*!S,"Symbol",{for:function(t){return e.has(_,t+="")?_[t]:_[t]=d(t)},keyFor:function(e){if(!T(e))throw TypeError(e+" is not a symbol!");for(var t in _)if(_[t]===e)return t},useSetter:function(){C=!0;},useSimple:function(){C=!1;}}),e.$export(e.$export.S+e.$export.F*!S,"Object",{create:function(t,r){return void 0===r?e.require$$4(t):O(e.require$$4(t),r)},defineProperty:z,defineProperties:O,getOwnPropertyDescriptor:L,getOwnPropertyNames:I,getOwnPropertySymbols:B}),p&&e.$export(e.$export.S+e.$export.F*(!S||e.require$$0$3(function(){var e=d();return "[null]"!=g([e])||"{}"!=g({a:e})||"{}"!=g(Object(e))})),"JSON",{stringify:function(t){for(var r,n,i=[t],o=1;arguments.length>o;)i.push(arguments[o++]);if(n=r=i[1],(e.isObject(r)||void 0!==t)&&!T(t))return e.isArray(r)||(r=function(e,t){if("function"==typeof n&&(t=n.call(this,e,t)),!T(t))return t}),i[1]=r,g.apply(p,i)}}),d.prototype[v]||e.require$$10(d.prototype,v,d.prototype.valueOf),e.setToStringTag(d,"Symbol"),e.setToStringTag(Math,"Math",!0),e.setToStringTag(e.global.JSON,"JSON",!0);var U=i={},D=0;i.getContext=function(e,t){var r=!1;null==e&&((e=document.createElement("canvas")).style.position="absolute",e.style.top=0,e.style.left=0,e.style.zIndex=-1,document.body.appendChild(e),r=!0),e.addEventListener("webglcontextlost",function(){}),e.addEventListener("webglcontextrestored",function(){});var n=e.getContext("webgl",t)||e.getContext("experimental-webgl",t);if(!n)throw new Error("Couldn't create WebGL context.");return n._tangram_id=D++,r?(i.resize(n,window.innerWidth,window.innerHeight,t.device_pixel_ratio),window.addEventListener("resize",function(){i.resize(n,window.innerWidth,window.innerHeight,t.device_pixel_ratio);})):i.resize(n,parseFloat(e.style.width),parseFloat(e.style.height),t.device_pixel_ratio),n},i.resize=function(e,t,r,n){n=n||window.devicePixelRatio||1,e.canvas.style.width=t+"px",e.canvas.style.height=r+"px",e.canvas.width=Math.round(t*n),e.canvas.height=Math.round(r*n),e.bindFramebuffer(e.FRAMEBUFFER,null),e.viewport(0,0,e.canvas.width,e.canvas.height);};var N="undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},Z=[],W=[],q="undefined"!=typeof Uint8Array?Uint8Array:Array,$=!1;function Y(){$=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,r=e.length;t<r;++t)Z[t]=e[t],W[e.charCodeAt(t)]=t;W["-".charCodeAt(0)]=62,W["_".charCodeAt(0)]=63;}function V(e,t,r){for(var n,i,o=[],s=t;s<r;s+=3)n=(e[s]<<16)+(e[s+1]<<8)+e[s+2],o.push(Z[(i=n)>>18&63]+Z[i>>12&63]+Z[i>>6&63]+Z[63&i]);return o.join("")}function H(e){var t;$||Y();for(var r=e.length,n=r%3,i="",o=[],s=0,a=r-n;s<a;s+=16383)o.push(V(e,s,s+16383>a?a:s+16383));return 1===n?(t=e[r-1],i+=Z[t>>2],i+=Z[t<<4&63],i+="=="):2===n&&(t=(e[r-2]<<8)+e[r-1],i+=Z[t>>10],i+=Z[t>>4&63],i+=Z[t<<2&63],i+="="),o.push(i),o.join("")}function G(e,t,r,n,i){var o,s,a=8*i-n-1,l=(1<<a)-1,u=l>>1,h=-7,c=r?i-1:0,f=r?-1:1,d=e[t+c];for(c+=f,o=d&(1<<-h)-1,d>>=-h,h+=a;h>0;o=256*o+e[t+c],c+=f,h-=8);for(s=o&(1<<-h)-1,o>>=-h,h+=n;h>0;s=256*s+e[t+c],c+=f,h-=8);if(0===o)o=1-u;else{if(o===l)return s?NaN:1/0*(d?-1:1);s+=Math.pow(2,n),o-=u;}return (d?-1:1)*s*Math.pow(2,o-n)}function K(e,t,r,n,i,o){var s,a,l,u=8*o-i-1,h=(1<<u)-1,c=h>>1,f=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,d=n?0:o-1,p=n?1:-1,g=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(a=isNaN(t)?1:0,s=h):(s=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-s))<1&&(s--,l*=2),(t+=s+c>=1?f/l:f*Math.pow(2,1-c))*l>=2&&(s++,l/=2),s+c>=h?(a=0,s=h):s+c>=1?(a=(t*l-1)*Math.pow(2,i),s+=c):(a=t*Math.pow(2,c-1)*Math.pow(2,i),s=0));i>=8;e[r+d]=255&a,d+=p,a/=256,i-=8);for(s=s<<i|a,u+=i;u>0;e[r+d]=255&s,d+=p,s/=256,u-=8);e[r+d-p]|=128*g;}var J={}.toString,X=Array.isArray||function(e){return "[object Array]"==J.call(e)};re.TYPED_ARRAY_SUPPORT=void 0===N.TYPED_ARRAY_SUPPORT||N.TYPED_ARRAY_SUPPORT;var Q=ee();function ee(){return re.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function te(e,t){if(ee()<t)throw new RangeError("Invalid typed array length");return re.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t)).__proto__=re.prototype:(null===e&&(e=new re(t)),e.length=t),e}function re(e,t,r){if(!(re.TYPED_ARRAY_SUPPORT||this instanceof re))return new re(e,t,r);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return oe(this,e)}return ne(this,e,t,r)}function ne(e,t,r,n){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return "undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?function(e,t,r,n){if(t.byteLength,r<0||t.byteLength<r)throw new RangeError("'offset' is out of bounds");if(t.byteLength<r+(n||0))throw new RangeError("'length' is out of bounds");t=void 0===r&&void 0===n?new Uint8Array(t):void 0===n?new Uint8Array(t,r):new Uint8Array(t,r,n);re.TYPED_ARRAY_SUPPORT?(e=t).__proto__=re.prototype:e=se(e,t);return e}(e,t,r,n):"string"==typeof t?function(e,t,r){"string"==typeof r&&""!==r||(r="utf8");if(!re.isEncoding(r))throw new TypeError('"encoding" must be a valid string encoding');var n=0|ue(t,r),i=(e=te(e,n)).write(t,r);i!==n&&(e=e.slice(0,i));return e}(e,t,r):function(e,t){if(le(t)){var r=0|ae(t.length);return 0===(e=te(e,r)).length?e:(t.copy(e,0,0,r),e)}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return "number"!=typeof t.length||(n=t.length)!=n?te(e,0):se(e,t);if("Buffer"===t.type&&X(t.data))return se(e,t.data)}var n;throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}(e,t)}function ie(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function oe(e,t){if(ie(t),e=te(e,t<0?0:0|ae(t)),!re.TYPED_ARRAY_SUPPORT)for(var r=0;r<t;++r)e[r]=0;return e}function se(e,t){var r=t.length<0?0:0|ae(t.length);e=te(e,r);for(var n=0;n<r;n+=1)e[n]=255&t[n];return e}function ae(e){if(e>=ee())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+ee().toString(16)+" bytes");return 0|e}function le(e){return !(null==e||!e._isBuffer)}function ue(e,t){if(le(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var r=e.length;if(0===r)return 0;for(var n=!1;;)switch(t){case"ascii":case"latin1":case"binary":return r;case"utf8":case"utf-8":case void 0:return Fe(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*r;case"hex":return r>>>1;case"base64":return Pe(e).length;default:if(n)return Fe(e).length;t=(""+t).toLowerCase(),n=!0;}}function he(e,t,r){var n=e[t];e[t]=e[r],e[r]=n;}function ce(e,t,r,n,i){if(0===e.length)return -1;if("string"==typeof r?(n=r,r=0):r>2147483647?r=2147483647:r<-2147483648&&(r=-2147483648),r=+r,isNaN(r)&&(r=i?0:e.length-1),r<0&&(r=e.length+r),r>=e.length){if(i)return -1;r=e.length-1;}else if(r<0){if(!i)return -1;r=0;}if("string"==typeof t&&(t=re.from(t,n)),le(t))return 0===t.length?-1:fe(e,t,r,n,i);if("number"==typeof t)return t&=255,re.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(e,t,r):Uint8Array.prototype.lastIndexOf.call(e,t,r):fe(e,[t],r,n,i);throw new TypeError("val must be string, number or Buffer")}function fe(e,t,r,n,i){var o,s=1,a=e.length,l=t.length;if(void 0!==n&&("ucs2"===(n=String(n).toLowerCase())||"ucs-2"===n||"utf16le"===n||"utf-16le"===n)){if(e.length<2||t.length<2)return -1;s=2,a/=2,l/=2,r/=2;}function u(e,t){return 1===s?e[t]:e.readUInt16BE(t*s)}if(i){var h=-1;for(o=r;o<a;o++)if(u(e,o)===u(t,-1===h?0:o-h)){if(-1===h&&(h=o),o-h+1===l)return h*s}else-1!==h&&(o-=o-h),h=-1;}else for(r+l>a&&(r=a-l),o=r;o>=0;o--){for(var c=!0,f=0;f<l;f++)if(u(e,o+f)!==u(t,f)){c=!1;break}if(c)return o}return -1}function de(e,t,r,n){r=Number(r)||0;var i=e.length-r;n?(n=Number(n))>i&&(n=i):n=i;var o=t.length;if(o%2!=0)throw new TypeError("Invalid hex string");n>o/2&&(n=o/2);for(var s=0;s<n;++s){var a=parseInt(t.substr(2*s,2),16);if(isNaN(a))return s;e[r+s]=a;}return s}function pe(e,t,r,n){return Me(Fe(t,e.length-r),e,r,n)}function ge(e,t,r,n){return Me(function(e){for(var t=[],r=0;r<e.length;++r)t.push(255&e.charCodeAt(r));return t}(t),e,r,n)}function me(e,t,r,n){return ge(e,t,r,n)}function ve(e,t,r,n){return Me(Pe(t),e,r,n)}function ye(e,t,r,n){return Me(function(e,t){for(var r,n,i,o=[],s=0;s<e.length&&!((t-=2)<0);++s)r=e.charCodeAt(s),n=r>>8,i=r%256,o.push(i),o.push(n);return o}(t,e.length-r),e,r,n)}function _e(e,t,r){return 0===t&&r===e.length?H(e):H(e.slice(t,r))}function be(e,t,r){r=Math.min(e.length,r);for(var n=[],i=t;i<r;){var o,s,a,l,u=e[i],h=null,c=u>239?4:u>223?3:u>191?2:1;if(i+c<=r)switch(c){case 1:u<128&&(h=u);break;case 2:128==(192&(o=e[i+1]))&&(l=(31&u)<<6|63&o)>127&&(h=l);break;case 3:o=e[i+1],s=e[i+2],128==(192&o)&&128==(192&s)&&(l=(15&u)<<12|(63&o)<<6|63&s)>2047&&(l<55296||l>57343)&&(h=l);break;case 4:o=e[i+1],s=e[i+2],a=e[i+3],128==(192&o)&&128==(192&s)&&128==(192&a)&&(l=(15&u)<<18|(63&o)<<12|(63&s)<<6|63&a)>65535&&l<1114112&&(h=l);}null===h?(h=65533,c=1):h>65535&&(h-=65536,n.push(h>>>10&1023|55296),h=56320|1023&h),n.push(h),i+=c;}return function(e){var t=e.length;if(t<=we)return String.fromCharCode.apply(String,e);var r="",n=0;for(;n<t;)r+=String.fromCharCode.apply(String,e.slice(n,n+=we));return r}(n)}re.poolSize=8192,re._augment=function(e){return e.__proto__=re.prototype,e},re.from=function(e,t,r){return ne(null,e,t,r)},re.TYPED_ARRAY_SUPPORT&&(re.prototype.__proto__=Uint8Array.prototype,re.__proto__=Uint8Array),re.alloc=function(e,t,r){return function(e,t,r,n){return ie(t),t<=0?te(e,t):void 0!==r?"string"==typeof n?te(e,t).fill(r,n):te(e,t).fill(r):te(e,t)}(null,e,t,r)},re.allocUnsafe=function(e){return oe(null,e)},re.allocUnsafeSlow=function(e){return oe(null,e)},re.isBuffer=je,re.compare=function(e,t){if(!le(e)||!le(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var r=e.length,n=t.length,i=0,o=Math.min(r,n);i<o;++i)if(e[i]!==t[i]){r=e[i],n=t[i];break}return r<n?-1:n<r?1:0},re.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return !0;default:return !1}},re.concat=function(e,t){if(!X(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return re.alloc(0);var r;if(void 0===t)for(t=0,r=0;r<e.length;++r)t+=e[r].length;var n=re.allocUnsafe(t),i=0;for(r=0;r<e.length;++r){var o=e[r];if(!le(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(n,i),i+=o.length;}return n},re.byteLength=ue,re.prototype._isBuffer=!0,re.prototype.swap16=function(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)he(this,t,t+1);return this},re.prototype.swap32=function(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;t<e;t+=4)he(this,t,t+3),he(this,t+1,t+2);return this},re.prototype.swap64=function(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)he(this,t,t+7),he(this,t+1,t+6),he(this,t+2,t+5),he(this,t+3,t+4);return this},re.prototype.toString=function(){var e=0|this.length;return 0===e?"":0===arguments.length?be(this,0,e):function(e,t,r){var n=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return "";if((void 0===r||r>this.length)&&(r=this.length),r<=0)return "";if((r>>>=0)<=(t>>>=0))return "";for(e||(e="utf8");;)switch(e){case"hex":return xe(this,t,r);case"utf8":case"utf-8":return be(this,t,r);case"ascii":return ke(this,t,r);case"latin1":case"binary":return Se(this,t,r);case"base64":return _e(this,t,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return Ce(this,t,r);default:if(n)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),n=!0;}}.apply(this,arguments)},re.prototype.equals=function(e){if(!le(e))throw new TypeError("Argument must be a Buffer");return this===e||0===re.compare(this,e)},re.prototype.inspect=function(){var e="";return this.length>0&&(e=this.toString("hex",0,50).match(/.{2}/g).join(" "),this.length>50&&(e+=" ... ")),"<Buffer "+e+">"},re.prototype.compare=function(e,t,r,n,i){if(!le(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===r&&(r=e?e.length:0),void 0===n&&(n=0),void 0===i&&(i=this.length),t<0||r>e.length||n<0||i>this.length)throw new RangeError("out of range index");if(n>=i&&t>=r)return 0;if(n>=i)return -1;if(t>=r)return 1;if(this===e)return 0;for(var o=(i>>>=0)-(n>>>=0),s=(r>>>=0)-(t>>>=0),a=Math.min(o,s),l=this.slice(n,i),u=e.slice(t,r),h=0;h<a;++h)if(l[h]!==u[h]){o=l[h],s=u[h];break}return o<s?-1:s<o?1:0},re.prototype.includes=function(e,t,r){return -1!==this.indexOf(e,t,r)},re.prototype.indexOf=function(e,t,r){return ce(this,e,t,r,!0)},re.prototype.lastIndexOf=function(e,t,r){return ce(this,e,t,r,!1)},re.prototype.write=function(e,t,r,n){if(void 0===t)n="utf8",r=this.length,t=0;else if(void 0===r&&"string"==typeof t)n=t,r=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(r)?(r|=0,void 0===n&&(n="utf8")):(n=r,r=void 0);}var i=this.length-t;if((void 0===r||r>i)&&(r=i),e.length>0&&(r<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");n||(n="utf8");for(var o=!1;;)switch(n){case"hex":return de(this,e,t,r);case"utf8":case"utf-8":return pe(this,e,t,r);case"ascii":return ge(this,e,t,r);case"latin1":case"binary":return me(this,e,t,r);case"base64":return ve(this,e,t,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return ye(this,e,t,r);default:if(o)throw new TypeError("Unknown encoding: "+n);n=(""+n).toLowerCase(),o=!0;}},re.prototype.toJSON=function(){return {type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var we=4096;function ke(e,t,r){var n="";r=Math.min(e.length,r);for(var i=t;i<r;++i)n+=String.fromCharCode(127&e[i]);return n}function Se(e,t,r){var n="";r=Math.min(e.length,r);for(var i=t;i<r;++i)n+=String.fromCharCode(e[i]);return n}function xe(e,t,r){var n=e.length;(!t||t<0)&&(t=0),(!r||r<0||r>n)&&(r=n);for(var i="",o=t;o<r;++o)i+=Be(e[o]);return i}function Ce(e,t,r){for(var n=e.slice(t,r),i="",o=0;o<n.length;o+=2)i+=String.fromCharCode(n[o]+256*n[o+1]);return i}function Ee(e,t,r){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>r)throw new RangeError("Trying to access beyond buffer length")}function Ae(e,t,r,n,i,o){if(!le(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>i||t<o)throw new RangeError('"value" argument is out of bounds');if(r+n>e.length)throw new RangeError("Index out of range")}function Te(e,t,r,n){t<0&&(t=65535+t+1);for(var i=0,o=Math.min(e.length-r,2);i<o;++i)e[r+i]=(t&255<<8*(n?i:1-i))>>>8*(n?i:1-i);}function ze(e,t,r,n){t<0&&(t=4294967295+t+1);for(var i=0,o=Math.min(e.length-r,4);i<o;++i)e[r+i]=t>>>8*(n?i:3-i)&255;}function Oe(e,t,r,n,i,o){if(r+n>e.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("Index out of range")}function Re(e,t,r,n,i){return i||Oe(e,0,r,4),K(e,t,r,n,23,4),r+4}function Le(e,t,r,n,i){return i||Oe(e,0,r,8),K(e,t,r,n,52,8),r+8}re.prototype.slice=function(e,t){var r,n=this.length;if((e=~~e)<0?(e+=n)<0&&(e=0):e>n&&(e=n),(t=void 0===t?n:~~t)<0?(t+=n)<0&&(t=0):t>n&&(t=n),t<e&&(t=e),re.TYPED_ARRAY_SUPPORT)(r=this.subarray(e,t)).__proto__=re.prototype;else{var i=t-e;r=new re(i,void 0);for(var o=0;o<i;++o)r[o]=this[o+e];}return r},re.prototype.readUIntLE=function(e,t,r){e|=0,t|=0,r||Ee(e,t,this.length);for(var n=this[e],i=1,o=0;++o<t&&(i*=256);)n+=this[e+o]*i;return n},re.prototype.readUIntBE=function(e,t,r){e|=0,t|=0,r||Ee(e,t,this.length);for(var n=this[e+--t],i=1;t>0&&(i*=256);)n+=this[e+--t]*i;return n},re.prototype.readUInt8=function(e,t){return t||Ee(e,1,this.length),this[e]},re.prototype.readUInt16LE=function(e,t){return t||Ee(e,2,this.length),this[e]|this[e+1]<<8},re.prototype.readUInt16BE=function(e,t){return t||Ee(e,2,this.length),this[e]<<8|this[e+1]},re.prototype.readUInt32LE=function(e,t){return t||Ee(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},re.prototype.readUInt32BE=function(e,t){return t||Ee(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},re.prototype.readIntLE=function(e,t,r){e|=0,t|=0,r||Ee(e,t,this.length);for(var n=this[e],i=1,o=0;++o<t&&(i*=256);)n+=this[e+o]*i;return n>=(i*=128)&&(n-=Math.pow(2,8*t)),n},re.prototype.readIntBE=function(e,t,r){e|=0,t|=0,r||Ee(e,t,this.length);for(var n=t,i=1,o=this[e+--n];n>0&&(i*=256);)o+=this[e+--n]*i;return o>=(i*=128)&&(o-=Math.pow(2,8*t)),o},re.prototype.readInt8=function(e,t){return t||Ee(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},re.prototype.readInt16LE=function(e,t){t||Ee(e,2,this.length);var r=this[e]|this[e+1]<<8;return 32768&r?4294901760|r:r},re.prototype.readInt16BE=function(e,t){t||Ee(e,2,this.length);var r=this[e+1]|this[e]<<8;return 32768&r?4294901760|r:r},re.prototype.readInt32LE=function(e,t){return t||Ee(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},re.prototype.readInt32BE=function(e,t){return t||Ee(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},re.prototype.readFloatLE=function(e,t){return t||Ee(e,4,this.length),G(this,e,!0,23,4)},re.prototype.readFloatBE=function(e,t){return t||Ee(e,4,this.length),G(this,e,!1,23,4)},re.prototype.readDoubleLE=function(e,t){return t||Ee(e,8,this.length),G(this,e,!0,52,8)},re.prototype.readDoubleBE=function(e,t){return t||Ee(e,8,this.length),G(this,e,!1,52,8)},re.prototype.writeUIntLE=function(e,t,r,n){(e=+e,t|=0,r|=0,n)||Ae(this,e,t,r,Math.pow(2,8*r)-1,0);var i=1,o=0;for(this[t]=255&e;++o<r&&(i*=256);)this[t+o]=e/i&255;return t+r},re.prototype.writeUIntBE=function(e,t,r,n){(e=+e,t|=0,r|=0,n)||Ae(this,e,t,r,Math.pow(2,8*r)-1,0);var i=r-1,o=1;for(this[t+i]=255&e;--i>=0&&(o*=256);)this[t+i]=e/o&255;return t+r},re.prototype.writeUInt8=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,1,255,0),re.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},re.prototype.writeUInt16LE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,2,65535,0),re.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):Te(this,e,t,!0),t+2},re.prototype.writeUInt16BE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,2,65535,0),re.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):Te(this,e,t,!1),t+2},re.prototype.writeUInt32LE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,4,4294967295,0),re.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):ze(this,e,t,!0),t+4},re.prototype.writeUInt32BE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,4,4294967295,0),re.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):ze(this,e,t,!1),t+4},re.prototype.writeIntLE=function(e,t,r,n){if(e=+e,t|=0,!n){var i=Math.pow(2,8*r-1);Ae(this,e,t,r,i-1,-i);}var o=0,s=1,a=0;for(this[t]=255&e;++o<r&&(s*=256);)e<0&&0===a&&0!==this[t+o-1]&&(a=1),this[t+o]=(e/s>>0)-a&255;return t+r},re.prototype.writeIntBE=function(e,t,r,n){if(e=+e,t|=0,!n){var i=Math.pow(2,8*r-1);Ae(this,e,t,r,i-1,-i);}var o=r-1,s=1,a=0;for(this[t+o]=255&e;--o>=0&&(s*=256);)e<0&&0===a&&0!==this[t+o+1]&&(a=1),this[t+o]=(e/s>>0)-a&255;return t+r},re.prototype.writeInt8=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,1,127,-128),re.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),e<0&&(e=255+e+1),this[t]=255&e,t+1},re.prototype.writeInt16LE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,2,32767,-32768),re.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):Te(this,e,t,!0),t+2},re.prototype.writeInt16BE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,2,32767,-32768),re.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):Te(this,e,t,!1),t+2},re.prototype.writeInt32LE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,4,2147483647,-2147483648),re.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):ze(this,e,t,!0),t+4},re.prototype.writeInt32BE=function(e,t,r){return e=+e,t|=0,r||Ae(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),re.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):ze(this,e,t,!1),t+4},re.prototype.writeFloatLE=function(e,t,r){return Re(this,e,t,!0,r)},re.prototype.writeFloatBE=function(e,t,r){return Re(this,e,t,!1,r)},re.prototype.writeDoubleLE=function(e,t,r){return Le(this,e,t,!0,r)},re.prototype.writeDoubleBE=function(e,t,r){return Le(this,e,t,!1,r)},re.prototype.copy=function(e,t,r,n){if(r||(r=0),n||0===n||(n=this.length),t>=e.length&&(t=e.length),t||(t=0),n>0&&n<r&&(n=r),n===r)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("sourceStart out of bounds");if(n<0)throw new RangeError("sourceEnd out of bounds");n>this.length&&(n=this.length),e.length-t<n-r&&(n=e.length-t+r);var i,o=n-r;if(this===e&&r<t&&t<n)for(i=o-1;i>=0;--i)e[i+t]=this[i+r];else if(o<1e3||!re.TYPED_ARRAY_SUPPORT)for(i=0;i<o;++i)e[i+t]=this[i+r];else Uint8Array.prototype.set.call(e,this.subarray(r,r+o),t);return o},re.prototype.fill=function(e,t,r,n){if("string"==typeof e){if("string"==typeof t?(n=t,t=0,r=this.length):"string"==typeof r&&(n=r,r=this.length),1===e.length){var i=e.charCodeAt(0);i<256&&(e=i);}if(void 0!==n&&"string"!=typeof n)throw new TypeError("encoding must be a string");if("string"==typeof n&&!re.isEncoding(n))throw new TypeError("Unknown encoding: "+n)}else"number"==typeof e&&(e&=255);if(t<0||this.length<t||this.length<r)throw new RangeError("Out of range index");if(r<=t)return this;var o;if(t>>>=0,r=void 0===r?this.length:r>>>0,e||(e=0),"number"==typeof e)for(o=t;o<r;++o)this[o]=e;else{var s=le(e)?e:Fe(new re(e,n).toString()),a=s.length;for(o=0;o<r-t;++o)this[o+t]=s[o%a];}return this};var Ie=/[^+\/0-9A-Za-z-_]/g;function Be(e){return e<16?"0"+e.toString(16):e.toString(16)}function Fe(e,t){var r;t=t||1/0;for(var n=e.length,i=null,o=[],s=0;s<n;++s){if((r=e.charCodeAt(s))>55295&&r<57344){if(!i){if(r>56319){(t-=3)>-1&&o.push(239,191,189);continue}if(s+1===n){(t-=3)>-1&&o.push(239,191,189);continue}i=r;continue}if(r<56320){(t-=3)>-1&&o.push(239,191,189),i=r;continue}r=65536+(i-55296<<10|r-56320);}else i&&(t-=3)>-1&&o.push(239,191,189);if(i=null,r<128){if((t-=1)<0)break;o.push(r);}else if(r<2048){if((t-=2)<0)break;o.push(r>>6|192,63&r|128);}else if(r<65536){if((t-=3)<0)break;o.push(r>>12|224,r>>6&63|128,63&r|128);}else{if(!(r<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;o.push(r>>18|240,r>>12&63|128,r>>6&63|128,63&r|128);}}return o}function Pe(e){return function(e){var t,r,n,i,o,s;$||Y();var a=e.length;if(a%4>0)throw new Error("Invalid string. Length must be a multiple of 4");o="="===e[a-2]?2:"="===e[a-1]?1:0,s=new q(3*a/4-o),n=o>0?a-4:a;var l=0;for(t=0,r=0;t<n;t+=4,r+=3)i=W[e.charCodeAt(t)]<<18|W[e.charCodeAt(t+1)]<<12|W[e.charCodeAt(t+2)]<<6|W[e.charCodeAt(t+3)],s[l++]=i>>16&255,s[l++]=i>>8&255,s[l++]=255&i;return 2===o?(i=W[e.charCodeAt(t)]<<2|W[e.charCodeAt(t+1)]>>4,s[l++]=255&i):1===o&&(i=W[e.charCodeAt(t)]<<10|W[e.charCodeAt(t+1)]<<4|W[e.charCodeAt(t+2)]>>2,s[l++]=i>>8&255,s[l++]=255&i),s}(function(e){if((e=function(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}(e).replace(Ie,"")).length<2)return "";for(;e.length%4!=0;)e+="=";return e}(e))}function Me(e,t,r,n){for(var i=0;i<n&&!(i+r>=t.length||i>=e.length);++i)t[i+r]=e[i];return i}function je(e){return null!=e&&(!!e._isBuffer||Ue(e)||function(e){return "function"==typeof e.readFloatLE&&"function"==typeof e.slice&&Ue(e.slice(0,0))}(e))}function Ue(e){return !!e.constructor&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e)}var De=Object.freeze({INSPECT_MAX_BYTES:50,kMaxLength:Q,Buffer:re,SlowBuffer:function(e){return +e!=e&&(e=0),re.alloc(+e)},isBuffer:je});function Ne(){}function Ze(){Ze.init.call(this);}function We(e){return void 0===e._maxListeners?Ze.defaultMaxListeners:e._maxListeners}function qe(e,t,r,n){var i,o,s,a;if("function"!=typeof r)throw new TypeError('"listener" argument must be a function');if((o=e._events)?(o.newListener&&(e.emit("newListener",t,r.listener?r.listener:r),o=e._events),s=o[t]):(o=e._events=new Ne,e._eventsCount=0),s){if("function"==typeof s?s=o[t]=n?[r,s]:[s,r]:n?s.unshift(r):s.push(r),!s.warned&&(i=We(e))&&i>0&&s.length>i){s.warned=!0;var l=new Error("Possible EventEmitter memory leak detected. "+s.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");l.name="MaxListenersExceededWarning",l.emitter=e,l.type=t,l.count=s.length,a=l,"function"==typeof console.warn?console.warn(a):console.log(a);}}else s=o[t]=r,++e._eventsCount;return e}function $e(e,t,r){var n=!1;function i(){e.removeListener(t,i),n||(n=!0,r.apply(e,arguments));}return i.listener=r,i}function Ye(e){var t=this._events;if(t){var r=t[e];if("function"==typeof r)return 1;if(r)return r.length}return 0}function Ve(e,t){for(var r=new Array(t);t--;)r[t]=e[t];return r}function He(){throw new Error("setTimeout has not been defined")}function Ge(){throw new Error("clearTimeout has not been defined")}Ne.prototype=Object.create(null),Ze.EventEmitter=Ze,Ze.usingDomains=!1,Ze.prototype.domain=void 0,Ze.prototype._events=void 0,Ze.prototype._maxListeners=void 0,Ze.defaultMaxListeners=10,Ze.init=function(){this.domain=null,Ze.usingDomains&&(void 0).active&&(void 0).Domain,this._events&&this._events!==Object.getPrototypeOf(this)._events||(this._events=new Ne,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0;},Ze.prototype.setMaxListeners=function(e){if("number"!=typeof e||e<0||isNaN(e))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=e,this},Ze.prototype.getMaxListeners=function(){return We(this)},Ze.prototype.emit=function(e){var t,r,n,i,o,s,a,l="error"===e;if(s=this._events)l=l&&null==s.error;else if(!l)return !1;if(a=this.domain,l){if(t=arguments[1],!a){if(t instanceof Error)throw t;var u=new Error('Uncaught, unspecified "error" event. ('+t+")");throw u.context=t,u}return t||(t=new Error('Uncaught, unspecified "error" event')),t.domainEmitter=this,t.domain=a,t.domainThrown=!1,a.emit("error",t),!1}if(!(r=s[e]))return !1;var h="function"==typeof r;switch(n=arguments.length){case 1:!function(e,t,r){if(t)e.call(r);else for(var n=e.length,i=Ve(e,n),o=0;o<n;++o)i[o].call(r);}(r,h,this);break;case 2:!function(e,t,r,n){if(t)e.call(r,n);else for(var i=e.length,o=Ve(e,i),s=0;s<i;++s)o[s].call(r,n);}(r,h,this,arguments[1]);break;case 3:!function(e,t,r,n,i){if(t)e.call(r,n,i);else for(var o=e.length,s=Ve(e,o),a=0;a<o;++a)s[a].call(r,n,i);}(r,h,this,arguments[1],arguments[2]);break;case 4:!function(e,t,r,n,i,o){if(t)e.call(r,n,i,o);else for(var s=e.length,a=Ve(e,s),l=0;l<s;++l)a[l].call(r,n,i,o);}(r,h,this,arguments[1],arguments[2],arguments[3]);break;default:for(i=new Array(n-1),o=1;o<n;o++)i[o-1]=arguments[o];!function(e,t,r,n){if(t)e.apply(r,n);else for(var i=e.length,o=Ve(e,i),s=0;s<i;++s)o[s].apply(r,n);}(r,h,this,i);}return !0},Ze.prototype.addListener=function(e,t){return qe(this,e,t,!1)},Ze.prototype.on=Ze.prototype.addListener,Ze.prototype.prependListener=function(e,t){return qe(this,e,t,!0)},Ze.prototype.once=function(e,t){if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');return this.on(e,$e(this,e,t)),this},Ze.prototype.prependOnceListener=function(e,t){if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');return this.prependListener(e,$e(this,e,t)),this},Ze.prototype.removeListener=function(e,t){var r,n,i,o,s;if("function"!=typeof t)throw new TypeError('"listener" argument must be a function');if(!(n=this._events))return this;if(!(r=n[e]))return this;if(r===t||r.listener&&r.listener===t)0==--this._eventsCount?this._events=new Ne:(delete n[e],n.removeListener&&this.emit("removeListener",e,r.listener||t));else if("function"!=typeof r){for(i=-1,o=r.length;o-- >0;)if(r[o]===t||r[o].listener&&r[o].listener===t){s=r[o].listener,i=o;break}if(i<0)return this;if(1===r.length){if(r[0]=void 0,0==--this._eventsCount)return this._events=new Ne,this;delete n[e];}else!function(e,t){for(var r=t,n=r+1,i=e.length;n<i;r+=1,n+=1)e[r]=e[n];e.pop();}(r,i);n.removeListener&&this.emit("removeListener",e,s||t);}return this},Ze.prototype.removeAllListeners=function(e){var t,r;if(!(r=this._events))return this;if(!r.removeListener)return 0===arguments.length?(this._events=new Ne,this._eventsCount=0):r[e]&&(0==--this._eventsCount?this._events=new Ne:delete r[e]),this;if(0===arguments.length){for(var n,i=Object.keys(r),o=0;o<i.length;++o)"removeListener"!==(n=i[o])&&this.removeAllListeners(n);return this.removeAllListeners("removeListener"),this._events=new Ne,this._eventsCount=0,this}if("function"==typeof(t=r[e]))this.removeListener(e,t);else if(t)do{this.removeListener(e,t[t.length-1]);}while(t[0]);return this},Ze.prototype.listeners=function(e){var t,r=this._events;return r&&(t=r[e])?"function"==typeof t?[t.listener||t]:function(e){for(var t=new Array(e.length),r=0;r<t.length;++r)t[r]=e[r].listener||e[r];return t}(t):[]},Ze.listenerCount=function(e,t){return "function"==typeof e.listenerCount?e.listenerCount(t):Ye.call(e,t)},Ze.prototype.listenerCount=Ye,Ze.prototype.eventNames=function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]};var Ke=He,Je=Ge;function Xe(e){if(Ke===setTimeout)return setTimeout(e,0);if((Ke===He||!Ke)&&setTimeout)return Ke=setTimeout,setTimeout(e,0);try{return Ke(e,0)}catch(t){try{return Ke.call(null,e,0)}catch(t){return Ke.call(this,e,0)}}}"function"==typeof N.setTimeout&&(Ke=setTimeout),"function"==typeof N.clearTimeout&&(Je=clearTimeout);var Qe,et=[],tt=!1,rt=-1;function nt(){tt&&Qe&&(tt=!1,Qe.length?et=Qe.concat(et):rt=-1,et.length&&it());}function it(){if(!tt){var e=Xe(nt);tt=!0;for(var t=et.length;t;){for(Qe=et,et=[];++rt<t;)Qe&&Qe[rt].run();rt=-1,t=et.length;}Qe=null,tt=!1,function(e){if(Je===clearTimeout)return clearTimeout(e);if((Je===Ge||!Je)&&clearTimeout)return Je=clearTimeout,clearTimeout(e);try{Je(e);}catch(t){try{return Je.call(null,e)}catch(t){return Je.call(this,e)}}}(e);}}function ot(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var r=1;r<arguments.length;r++)t[r-1]=arguments[r];et.push(new st(e,t)),1!==et.length||tt||Xe(it);}function st(e,t){this.fun=e,this.array=t;}st.prototype.run=function(){this.fun.apply(null,this.array);};function at(){}var lt=at,ut=at,ht=at,ct=at,ft=at,dt=at,pt=at;var gt=N.performance||{},mt=gt.now||gt.mozNow||gt.msNow||gt.oNow||gt.webkitNow||function(){return (new Date).getTime()};var vt=new Date;var yt={nextTick:ot,title:"browser",browser:!0,env:{},argv:[],version:"",versions:{},on:lt,addListener:ut,once:ht,off:ct,removeListener:ft,removeAllListeners:dt,emit:pt,binding:function(e){throw new Error("process.binding is not supported")},cwd:function(){return "/"},chdir:function(e){throw new Error("process.chdir is not supported")},umask:function(){return 0},hrtime:function(e){var t=.001*mt.call(gt),r=Math.floor(t),n=Math.floor(t%1*1e9);return e&&(r-=e[0],(n-=e[1])<0&&(r--,n+=1e9)),[r,n]},platform:"browser",release:{},config:{},uptime:function(){return (new Date-vt)/1e3}},_t=function(e){return e&&"object"==typeof e&&"function"==typeof e.copy&&"function"==typeof e.fill&&"function"==typeof e.readUInt8},bt=e.createCommonjsModule(function(e){"function"==typeof Object.create?e.exports=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}});}:e.exports=function(e,t){e.super_=t;var r=function(){};r.prototype=t.prototype,e.prototype=new r,e.prototype.constructor=e;};}),wt=e.createCommonjsModule(function(e,t){var r=/%[sdj%]/g;t.format=function(e){if(!g(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(o(arguments[n]));return t.join(" ")}n=1;for(var i=arguments,s=i.length,a=String(e).replace(r,function(e){if("%%"===e)return "%";if(n>=s)return e;switch(e){case"%s":return String(i[n++]);case"%d":return Number(i[n++]);case"%j":try{return JSON.stringify(i[n++])}catch(e){return "[Circular]"}default:return e}}),l=i[n];n<s;l=i[++n])d(l)||!y(l)?a+=" "+l:a+=" "+o(l);return a},t.deprecate=function(e,r){if(m(N.process))return function(){return t.deprecate(e,r).apply(this,arguments)};var n=!1;return function(){return n||(console.error(r),n=!0),e.apply(this,arguments)}};var n,i={};function o(e,r){var n={seen:[],stylize:a};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),f(r)?n.showHidden=r:r&&t._extend(n,r),m(n.showHidden)&&(n.showHidden=!1),m(n.depth)&&(n.depth=2),m(n.colors)&&(n.colors=!1),m(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=s),l(n,e,n.depth)}function s(e,t){var r=o.styles[t];return r?"["+o.colors[r][0]+"m"+e+"["+o.colors[r][1]+"m":e}function a(e,t){return e}function l(e,r,n){if(e.customInspect&&r&&w(r.inspect)&&r.inspect!==t.inspect&&(!r.constructor||r.constructor.prototype!==r)){var i=r.inspect(n,e);return g(i)||(i=l(e,i,n)),i}var o=function(e,t){if(m(t))return e.stylize("undefined","undefined");if(g(t)){var r="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(r,"string")}if(p(t))return e.stylize(""+t,"number");if(f(t))return e.stylize(""+t,"boolean");if(d(t))return e.stylize("null","null")}(e,r);if(o)return o;var s=Object.keys(r),a=function(e){var t={};return e.forEach(function(e,r){t[e]=!0;}),t}(s);if(e.showHidden&&(s=Object.getOwnPropertyNames(r)),b(r)&&(s.indexOf("message")>=0||s.indexOf("description")>=0))return u(r);if(0===s.length){if(w(r)){var y=r.name?": "+r.name:"";return e.stylize("[Function"+y+"]","special")}if(v(r))return e.stylize(RegExp.prototype.toString.call(r),"regexp");if(_(r))return e.stylize(Date.prototype.toString.call(r),"date");if(b(r))return u(r)}var k,S="",x=!1,E=["{","}"];(c(r)&&(x=!0,E=["[","]"]),w(r))&&(S=" [Function"+(r.name?": "+r.name:"")+"]");return v(r)&&(S=" "+RegExp.prototype.toString.call(r)),_(r)&&(S=" "+Date.prototype.toUTCString.call(r)),b(r)&&(S=" "+u(r)),0!==s.length||x&&0!=r.length?n<0?v(r)?e.stylize(RegExp.prototype.toString.call(r),"regexp"):e.stylize("[Object]","special"):(e.seen.push(r),k=x?function(e,t,r,n,i){for(var o=[],s=0,a=t.length;s<a;++s)C(t,String(s))?o.push(h(e,t,r,n,String(s),!0)):o.push("");return i.forEach(function(i){i.match(/^\d+$/)||o.push(h(e,t,r,n,i,!0));}),o}(e,r,n,a,s):s.map(function(t){return h(e,r,n,a,t,x)}),e.seen.pop(),function(e,t,r){if(e.reduce(function(e,t){return t.indexOf("\n"),e+t.replace(/\u001b\[\d\d?m/g,"").length+1},0)>60)return r[0]+(""===t?"":t+"\n ")+" "+e.join(",\n  ")+" "+r[1];return r[0]+t+" "+e.join(", ")+" "+r[1]}(k,S,E)):E[0]+S+E[1]}function u(e){return "["+Error.prototype.toString.call(e)+"]"}function h(e,t,r,n,i,o){var s,a,u;if((u=Object.getOwnPropertyDescriptor(t,i)||{value:t[i]}).get?a=u.set?e.stylize("[Getter/Setter]","special"):e.stylize("[Getter]","special"):u.set&&(a=e.stylize("[Setter]","special")),C(n,i)||(s="["+i+"]"),a||(e.seen.indexOf(u.value)<0?(a=d(r)?l(e,u.value,null):l(e,u.value,r-1)).indexOf("\n")>-1&&(a=o?a.split("\n").map(function(e){return "  "+e}).join("\n").substr(2):"\n"+a.split("\n").map(function(e){return "   "+e}).join("\n")):a=e.stylize("[Circular]","special")),m(s)){if(o&&i.match(/^\d+$/))return a;(s=JSON.stringify(""+i)).match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(s=s.substr(1,s.length-2),s=e.stylize(s,"name")):(s=s.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),s=e.stylize(s,"string"));}return s+": "+a}function c(e){return Array.isArray(e)}function f(e){return "boolean"==typeof e}function d(e){return null===e}function p(e){return "number"==typeof e}function g(e){return "string"==typeof e}function m(e){return void 0===e}function v(e){return y(e)&&"[object RegExp]"===k(e)}function y(e){return "object"==typeof e&&null!==e}function _(e){return y(e)&&"[object Date]"===k(e)}function b(e){return y(e)&&("[object Error]"===k(e)||e instanceof Error)}function w(e){return "function"==typeof e}function k(e){return Object.prototype.toString.call(e)}function S(e){return e<10?"0"+e.toString(10):e.toString(10)}t.debuglog=function(e){if(m(n)&&(n=""),e=e.toUpperCase(),!i[e])if(new RegExp("\\b"+e+"\\b","i").test(n)){var r=yt.pid;i[e]=function(){var n=t.format.apply(t,arguments);console.error("%s %d: %s",e,r,n);};}else i[e]=function(){};return i[e]},t.inspect=o,o.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]},o.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"},t.isArray=c,t.isBoolean=f,t.isNull=d,t.isNullOrUndefined=function(e){return null==e},t.isNumber=p,t.isString=g,t.isSymbol=function(e){return "symbol"==typeof e},t.isUndefined=m,t.isRegExp=v,t.isObject=y,t.isDate=_,t.isError=b,t.isFunction=w,t.isPrimitive=function(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||"symbol"==typeof e||void 0===e},t.isBuffer=_t;var x=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];function C(e,t){return Object.prototype.hasOwnProperty.call(e,t)}t.log=function(){var e,r;console.log("%s - %s",(e=new Date,r=[S(e.getHours()),S(e.getMinutes()),S(e.getSeconds())].join(":"),[e.getDate(),x[e.getMonth()],r].join(" ")),t.format.apply(t,arguments));},t.inherits=bt,t._extend=function(e,t){if(!t||!y(t))return e;for(var r=Object.keys(t),n=r.length;n--;)e[r[n]]=t[r[n]];return e};}),kt=(wt.format,wt.deprecate),St=wt.debuglog,xt=(wt.inspect,wt.isArray,wt.isBoolean,wt.isNull,wt.isNullOrUndefined,wt.isNumber,wt.isString,wt.isSymbol,wt.isUndefined,wt.isRegExp,wt.isObject,wt.isDate,wt.isError,wt.isFunction,wt.isPrimitive,wt.isBuffer,wt.log,wt.inherits);wt._extend;function Ct(){this.head=null,this.tail=null,this.length=0;}Ct.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length;},Ct.prototype.unshift=function(e){var t={data:e,next:this.head};0===this.length&&(this.tail=t),this.head=t,++this.length;},Ct.prototype.shift=function(){if(0!==this.length){var e=this.head.data;return 1===this.length?this.head=this.tail=null:this.head=this.head.next,--this.length,e}},Ct.prototype.clear=function(){this.head=this.tail=null,this.length=0;},Ct.prototype.join=function(e){if(0===this.length)return "";for(var t=this.head,r=""+t.data;t=t.next;)r+=e+t.data;return r},Ct.prototype.concat=function(e){if(0===this.length)return re.alloc(0);if(1===this.length)return this.head.data;for(var t=re.allocUnsafe(e>>>0),r=this.head,n=0;r;)r.data.copy(t,n),n+=r.data.length,r=r.next;return t};var Et=e.createCommonjsModule(function(e,t){var r=De.Buffer;function n(e,t){for(var r in e)t[r]=e[r];}function i(e,t,n){return r(e,t,n)}r.from&&r.alloc&&r.allocUnsafe&&r.allocUnsafeSlow?e.exports=De:(n(De,t),t.Buffer=i),n(r,i),i.from=function(e,t,n){if("number"==typeof e)throw new TypeError("Argument must not be a number");return r(e,t,n)},i.alloc=function(e,t,n){if("number"!=typeof e)throw new TypeError("Argument must be a number");var i=r(e);return void 0!==t?"string"==typeof n?i.fill(t,n):i.fill(t):i.fill(0),i},i.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return r(e)},i.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return De.SlowBuffer(e)};}),At=(Et.Buffer,Et.Buffer),Tt=At.isEncoding||function(e){switch((e=""+e)&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return !0;default:return !1}};var zt=Ot;function Ot(e){var t;switch(this.encoding=function(e){var t=function(e){if(!e)return "utf8";for(var t;;)switch(e){case"utf8":case"utf-8":return "utf8";case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return "utf16le";case"latin1":case"binary":return "latin1";case"base64":case"ascii":case"hex":return e;default:if(t)return;e=(""+e).toLowerCase(),t=!0;}}(e);if("string"!=typeof t&&(At.isEncoding===Tt||!Tt(e)))throw new Error("Unknown encoding: "+e);return t||e}(e),this.encoding){case"utf16le":this.text=It,this.end=Bt,t=4;break;case"utf8":this.fillLast=Lt,t=4;break;case"base64":this.text=Ft,this.end=Pt,t=3;break;default:return this.write=Mt,void(this.end=jt)}this.lastNeed=0,this.lastTotal=0,this.lastChar=At.allocUnsafe(t);}function Rt(e){return e<=127?0:e>>5==6?2:e>>4==14?3:e>>3==30?4:-1}function Lt(e){var t=this.lastTotal-this.lastNeed,r=function(e,t,r){if(128!=(192&t[0]))return e.lastNeed=0,"�".repeat(r);if(e.lastNeed>1&&t.length>1){if(128!=(192&t[1]))return e.lastNeed=1,"�".repeat(r+1);if(e.lastNeed>2&&t.length>2&&128!=(192&t[2]))return e.lastNeed=2,"�".repeat(r+2)}}(this,e,t);return void 0!==r?r:this.lastNeed<=e.length?(e.copy(this.lastChar,t,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,t,0,e.length),void(this.lastNeed-=e.length))}function It(e,t){if((e.length-t)%2==0){var r=e.toString("utf16le",t);if(r){var n=r.charCodeAt(r.length-1);if(n>=55296&&n<=56319)return this.lastNeed=2,this.lastTotal=4,this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1],r.slice(0,-1)}return r}return this.lastNeed=1,this.lastTotal=2,this.lastChar[0]=e[e.length-1],e.toString("utf16le",t,e.length-1)}function Bt(e){var t=e&&e.length?this.write(e):"";if(this.lastNeed){var r=this.lastTotal-this.lastNeed;return t+this.lastChar.toString("utf16le",0,r)}return t}function Ft(e,t){var r=(e.length-t)%3;return 0===r?e.toString("base64",t):(this.lastNeed=3-r,this.lastTotal=3,1===r?this.lastChar[0]=e[e.length-1]:(this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1]),e.toString("base64",t,e.length-r))}function Pt(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+this.lastChar.toString("base64",0,3-this.lastNeed):t}function Mt(e){return e.toString(this.encoding)}function jt(e){return e&&e.length?this.write(e):""}Ot.prototype.write=function(e){if(0===e.length)return "";var t,r;if(this.lastNeed){if(void 0===(t=this.fillLast(e)))return "";r=this.lastNeed,this.lastNeed=0;}else r=0;return r<e.length?t?t+this.text(e,r):this.text(e,r):t||""},Ot.prototype.end=function(e){var t=e&&e.length?this.write(e):"";return this.lastNeed?t+"�".repeat(this.lastTotal-this.lastNeed):t},Ot.prototype.text=function(e,t){var r=function(e,t,r){var n=t.length-1;if(n<r)return 0;var i=Rt(t[n]);if(i>=0)return i>0&&(e.lastNeed=i-1),i;if(--n<r)return 0;if((i=Rt(t[n]))>=0)return i>0&&(e.lastNeed=i-2),i;if(--n<r)return 0;if((i=Rt(t[n]))>=0)return i>0&&(2===i?i=0:e.lastNeed=i-3),i;return 0}(this,e,t);if(!this.lastNeed)return e.toString("utf8",t);this.lastTotal=r;var n=e.length-(r-this.lastNeed);return e.copy(this.lastChar,0,n),e.toString("utf8",t,n)},Ot.prototype.fillLast=function(e){if(this.lastNeed<=e.length)return e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal);e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,e.length),this.lastNeed-=e.length;},Nt.ReadableState=Dt;var Ut=St("stream");function Dt(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof gr&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var r=e.highWaterMark,n=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:n,this.highWaterMark=~~this.highWaterMark,this.buffer=new Ct,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new zt(e.encoding),this.encoding=e.encoding);}function Nt(e){if(!(this instanceof Nt))return new Nt(e);this._readableState=new Dt(e,this),this.readable=!0,e&&"function"==typeof e.read&&(this._read=e.read),Ze.call(this);}function Zt(e,t,r,n,i){var o=function(e,t){var r=null;je(t)||"string"==typeof t||null==t||e.objectMode||(r=new TypeError("Invalid non-string/buffer chunk"));return r}(t,r);if(o)e.emit("error",o);else if(null===r)t.reading=!1,function(e,t){if(t.ended)return;if(t.decoder){var r=t.decoder.end();r&&r.length&&(t.buffer.push(r),t.length+=t.objectMode?1:r.length);}t.ended=!0,$t(e);}(e,t);else if(t.objectMode||r&&r.length>0)if(t.ended&&!i){var s=new Error("stream.push() after EOF");e.emit("error",s);}else if(t.endEmitted&&i){var a=new Error("stream.unshift() after end event");e.emit("error",a);}else{var l;!t.decoder||i||n||(r=t.decoder.write(r),l=!t.objectMode&&0===r.length),i||(t.reading=!1),l||(t.flowing&&0===t.length&&!t.sync?(e.emit("data",r),e.read(0)):(t.length+=t.objectMode?1:r.length,i?t.buffer.unshift(r):t.buffer.push(r),t.needReadable&&$t(e))),function(e,t){t.readingMore||(t.readingMore=!0,ot(Vt,e,t));}(e,t);}else i||(t.reading=!1);return function(e){return !e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(t)}xt(Nt,Ze),Nt.prototype.push=function(e,t){var r=this._readableState;return r.objectMode||"string"!=typeof e||(t=t||r.defaultEncoding)!==r.encoding&&(e=re.from(e,t),t=""),Zt(this,r,e,t,!1)},Nt.prototype.unshift=function(e){return Zt(this,this._readableState,e,"",!0)},Nt.prototype.isPaused=function(){return !1===this._readableState.flowing},Nt.prototype.setEncoding=function(e){return this._readableState.decoder=new zt(e),this._readableState.encoding=e,this};var Wt=8388608;function qt(e,t){return e<=0||0===t.length&&t.ended?0:t.objectMode?1:e!=e?t.flowing&&t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=function(e){return e>=Wt?e=Wt:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function $t(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(Ut("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?ot(Yt,e):Yt(e));}function Yt(e){Ut("emit readable"),e.emit("readable"),Kt(e);}function Vt(e,t){for(var r=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(Ut("maybeReadMore read 0"),e.read(0),r!==t.length);)r=t.length;t.readingMore=!1;}function Ht(e){Ut("readable nexttick read 0"),e.read(0);}function Gt(e,t){t.reading||(Ut("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),Kt(e),t.flowing&&!t.reading&&e.read(0);}function Kt(e){var t=e._readableState;for(Ut("flow",t.flowing);t.flowing&&null!==e.read(););}function Jt(e,t){return 0===t.length?null:(t.objectMode?r=t.buffer.shift():!e||e>=t.length?(r=t.decoder?t.buffer.join(""):1===t.buffer.length?t.buffer.head.data:t.buffer.concat(t.length),t.buffer.clear()):r=function(e,t,r){var n;e<t.head.data.length?(n=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):n=e===t.head.data.length?t.shift():r?function(e,t){var r=t.head,n=1,i=r.data;e-=i.length;for(;r=r.next;){var o=r.data,s=e>o.length?o.length:e;if(s===o.length?i+=o:i+=o.slice(0,e),0===(e-=s)){s===o.length?(++n,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=o.slice(s));break}++n;}return t.length-=n,i}(e,t):function(e,t){var r=re.allocUnsafe(e),n=t.head,i=1;n.data.copy(r),e-=n.data.length;for(;n=n.next;){var o=n.data,s=e>o.length?o.length:e;if(o.copy(r,r.length-e,0,s),0===(e-=s)){s===o.length?(++i,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(s));break}++i;}return t.length-=i,r}(e,t);return n}(e,t.buffer,t.decoder),r);var r;}function Xt(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,ot(Qt,t,e));}function Qt(e,t){e.endEmitted||0!==e.length||(e.endEmitted=!0,t.readable=!1,t.emit("end"));}function er(e,t){for(var r=0,n=e.length;r<n;r++)if(e[r]===t)return r;return -1}function tr(){}function rr(e,t,r){this.chunk=e,this.encoding=t,this.callback=r,this.next=null;}function nr(e,t){Object.defineProperty(this,"buffer",{get:kt(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof gr&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var r=e.highWaterMark,n=this.objectMode?16:16384;this.highWaterMark=r||0===r?r:n,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var i=!1===e.decodeStrings;this.decodeStrings=!i,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,t){var r=e._writableState,n=r.sync,i=r.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0;}(r),t)!function(e,t,r,n,i){--t.pendingcb,r?ot(i,n):i(n);e._writableState.errorEmitted=!0,e.emit("error",n);}(e,r,n,t,i);else{var o=lr(r);o||r.corked||r.bufferProcessing||!r.bufferedRequest||ar(e,r),n?ot(sr,e,r,o,i):sr(e,r,o,i);}}(t,e);},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new cr(this);}function ir(e){if(!(this instanceof ir||this instanceof gr))return new ir(e);this._writableState=new nr(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev)),Ze.call(this);}function or(e,t,r,n,i,o,s){t.writelen=n,t.writecb=s,t.writing=!0,t.sync=!0,r?e._writev(i,t.onwrite):e._write(i,o,t.onwrite),t.sync=!1;}function sr(e,t,r,n){r||function(e,t){0===t.length&&t.needDrain&&(t.needDrain=!1,e.emit("drain"));}(e,t),t.pendingcb--,n(),hr(e,t);}function ar(e,t){t.bufferProcessing=!0;var r=t.bufferedRequest;if(e._writev&&r&&r.next){var n=t.bufferedRequestCount,i=new Array(n),o=t.corkedRequestsFree;o.entry=r;for(var s=0;r;)i[s]=r,r=r.next,s+=1;or(e,t,!0,t.length,i,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=o.next,o.next=null):t.corkedRequestsFree=new cr(t);}else{for(;r;){var a=r.chunk,l=r.encoding,u=r.callback;if(or(e,t,!1,t.objectMode?1:a.length,a,l,u),r=r.next,t.writing)break}null===r&&(t.lastBufferedRequest=null);}t.bufferedRequestCount=0,t.bufferedRequest=r,t.bufferProcessing=!1;}function lr(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function ur(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"));}function hr(e,t){var r=lr(t);return r&&(0===t.pendingcb?(ur(e,t),t.finished=!0,e.emit("finish")):ur(e,t)),r}function cr(e){var t=this;this.next=null,this.entry=null,this.finish=function(r){var n=t.entry;for(t.entry=null;n;){var i=n.callback;e.pendingcb--,i(r),n=n.next;}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t;};}Nt.prototype.read=function(e){Ut("read",e),e=parseInt(e,10);var t=this._readableState,r=e;if(0!==e&&(t.emittedReadable=!1),0===e&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return Ut("read: emitReadable",t.length,t.ended),0===t.length&&t.ended?Xt(this):$t(this),null;if(0===(e=qt(e,t))&&t.ended)return 0===t.length&&Xt(this),null;var n,i=t.needReadable;return Ut("need readable",i),(0===t.length||t.length-e<t.highWaterMark)&&Ut("length less than watermark",i=!0),t.ended||t.reading?Ut("reading or ended",i=!1):i&&(Ut("do read"),t.reading=!0,t.sync=!0,0===t.length&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=qt(r,t))),null===(n=e>0?Jt(e,t):null)?(t.needReadable=!0,e=0):t.length-=e,0===t.length&&(t.ended||(t.needReadable=!0),r!==e&&t.ended&&Xt(this)),null!==n&&this.emit("data",n),n},Nt.prototype._read=function(e){this.emit("error",new Error("not implemented"));},Nt.prototype.pipe=function(e,t){var r=this,n=this._readableState;switch(n.pipesCount){case 0:n.pipes=e;break;case 1:n.pipes=[n.pipes,e];break;default:n.pipes.push(e);}n.pipesCount+=1,Ut("pipe count=%d opts=%j",n.pipesCount,t);var i=!t||!1!==t.end?s:u;function o(e){Ut("onunpipe"),e===r&&u();}function s(){Ut("onend"),e.end();}n.endEmitted?ot(i):r.once("end",i),e.on("unpipe",o);var a=function(e){return function(){var t=e._readableState;Ut("pipeOnDrain",t.awaitDrain),t.awaitDrain&&t.awaitDrain--,0===t.awaitDrain&&e.listeners("data").length&&(t.flowing=!0,Kt(e));}}(r);e.on("drain",a);var l=!1;function u(){Ut("cleanup"),e.removeListener("close",d),e.removeListener("finish",p),e.removeListener("drain",a),e.removeListener("error",f),e.removeListener("unpipe",o),r.removeListener("end",s),r.removeListener("end",u),r.removeListener("data",c),l=!0,!n.awaitDrain||e._writableState&&!e._writableState.needDrain||a();}var h=!1;function c(t){Ut("ondata"),h=!1,!1!==e.write(t)||h||((1===n.pipesCount&&n.pipes===e||n.pipesCount>1&&-1!==er(n.pipes,e))&&!l&&(Ut("false write response, pause",r._readableState.awaitDrain),r._readableState.awaitDrain++,h=!0),r.pause());}function f(t){var r;Ut("onerror",t),g(),e.removeListener("error",f),0===(r="error",e.listeners(r).length)&&e.emit("error",t);}function d(){e.removeListener("finish",p),g();}function p(){Ut("onfinish"),e.removeListener("close",d),g();}function g(){Ut("unpipe"),r.unpipe(e);}return r.on("data",c),function(e,t,r){if("function"==typeof e.prependListener)return e.prependListener(t,r);e._events&&e._events[t]?Array.isArray(e._events[t])?e._events[t].unshift(r):e._events[t]=[r,e._events[t]]:e.on(t,r);}(e,"error",f),e.once("close",d),e.once("finish",p),e.emit("pipe",r),n.flowing||(Ut("pipe resume"),r.resume()),e},Nt.prototype.unpipe=function(e){var t=this._readableState;if(0===t.pipesCount)return this;if(1===t.pipesCount)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var r=t.pipes,n=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var i=0;i<n;i++)r[i].emit("unpipe",this);return this}var o=er(t.pipes,e);return -1===o?this:(t.pipes.splice(o,1),t.pipesCount-=1,1===t.pipesCount&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)},Nt.prototype.on=function(e,t){var r=Ze.prototype.on.call(this,e,t);if("data"===e)!1!==this._readableState.flowing&&this.resume();else if("readable"===e){var n=this._readableState;n.endEmitted||n.readableListening||(n.readableListening=n.needReadable=!0,n.emittedReadable=!1,n.reading?n.length&&$t(this):ot(Ht,this));}return r},Nt.prototype.addListener=Nt.prototype.on,Nt.prototype.resume=function(){var e=this._readableState;return e.flowing||(Ut("resume"),e.flowing=!0,function(e,t){t.resumeScheduled||(t.resumeScheduled=!0,ot(Gt,e,t));}(this,e)),this},Nt.prototype.pause=function(){return Ut("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(Ut("pause"),this._readableState.flowing=!1,this.emit("pause")),this},Nt.prototype.wrap=function(e){var t=this._readableState,r=!1,n=this;for(var i in e.on("end",function(){if(Ut("wrapped end"),t.decoder&&!t.ended){var e=t.decoder.end();e&&e.length&&n.push(e);}n.push(null);}),e.on("data",function(i){(Ut("wrapped data"),t.decoder&&(i=t.decoder.write(i)),t.objectMode&&null==i)||(t.objectMode||i&&i.length)&&(n.push(i)||(r=!0,e.pause()));}),e)void 0===this[i]&&"function"==typeof e[i]&&(this[i]=function(t){return function(){return e[t].apply(e,arguments)}}(i));return function(e,t){for(var r=0,n=e.length;r<n;r++)t(e[r],r);}(["error","close","destroy","pause","resume"],function(t){e.on(t,n.emit.bind(n,t));}),n._read=function(t){Ut("wrapped _read",t),r&&(r=!1,e.resume());},n},Nt._fromList=Jt,ir.WritableState=nr,xt(ir,Ze),nr.prototype.getBuffer=function(){for(var e=this.bufferedRequest,t=[];e;)t.push(e),e=e.next;return t},ir.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"));},ir.prototype.write=function(e,t,r){var n=this._writableState,i=!1;return "function"==typeof t&&(r=t,t=null),re.isBuffer(e)?t="buffer":t||(t=n.defaultEncoding),"function"!=typeof r&&(r=tr),n.ended?function(e,t){var r=new Error("write after end");e.emit("error",r),ot(t,r);}(this,r):function(e,t,r,n){var i=!0,o=!1;return null===r?o=new TypeError("May not write null values to stream"):re.isBuffer(r)||"string"==typeof r||void 0===r||t.objectMode||(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),ot(n,o),i=!1),i}(this,n,e,r)&&(n.pendingcb++,i=function(e,t,r,n,i){r=function(e,t,r){return e.objectMode||!1===e.decodeStrings||"string"!=typeof t||(t=re.from(t,r)),t}(t,r,n),re.isBuffer(r)&&(n="buffer");var o=t.objectMode?1:r.length;t.length+=o;var s=t.length<t.highWaterMark;s||(t.needDrain=!0);if(t.writing||t.corked){var a=t.lastBufferedRequest;t.lastBufferedRequest=new rr(r,n,i),a?a.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=1;}else or(e,t,!1,o,r,n,i);return s}(this,n,e,t,r)),i},ir.prototype.cork=function(){this._writableState.corked++;},ir.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.finished||e.bufferProcessing||!e.bufferedRequest||ar(this,e));},ir.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);return this._writableState.defaultEncoding=e,this},ir.prototype._write=function(e,t,r){r(new Error("not implemented"));},ir.prototype._writev=null,ir.prototype.end=function(e,t,r){var n=this._writableState;"function"==typeof e?(r=e,e=null,t=null):"function"==typeof t&&(r=t,t=null),null!=e&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),n.ending||n.finished||function(e,t,r){t.ending=!0,hr(e,t),r&&(t.finished?ot(r):e.once("finish",r));t.ended=!0,e.writable=!1;}(this,n,r);},xt(gr,Nt);for(var fr=Object.keys(ir.prototype),dr=0;dr<fr.length;dr++){var pr=fr[dr];gr.prototype[pr]||(gr.prototype[pr]=ir.prototype[pr]);}function gr(e){if(!(this instanceof gr))return new gr(e);Nt.call(this,e),ir.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",mr);}function mr(){this.allowHalfOpen||this._writableState.ended||ot(vr,this);}function vr(e){e.end();}function yr(e){this.afterTransform=function(t,r){return function(e,t,r){var n=e._transformState;n.transforming=!1;var i=n.writecb;if(!i)return e.emit("error",new Error("no writecb in Transform class"));n.writechunk=null,n.writecb=null,null!=r&&e.push(r);i(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark);}(e,t,r)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null;}function _r(e){if(!(this instanceof _r))return new _r(e);gr.call(this,e),this._transformState=new yr(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.once("prefinish",function(){"function"==typeof this._flush?this._flush(function(e){br(t,e);}):br(t);});}function br(e,t){if(t)return e.emit("error",t);var r=e._writableState,n=e._transformState;if(r.length)throw new Error("Calling transform done when ws.length != 0");if(n.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}function wr(e){if(!(this instanceof wr))return new wr(e);_r.call(this,e);}function kr(){Ze.call(this);}xt(_r,gr),_r.prototype.push=function(e,t){return this._transformState.needTransform=!1,gr.prototype.push.call(this,e,t)},_r.prototype._transform=function(e,t,r){throw new Error("Not implemented")},_r.prototype._write=function(e,t,r){var n=this._transformState;if(n.writecb=r,n.writechunk=e,n.writeencoding=t,!n.transforming){var i=this._readableState;(n.needTransform||i.needReadable||i.length<i.highWaterMark)&&this._read(i.highWaterMark);}},_r.prototype._read=function(e){var t=this._transformState;null!==t.writechunk&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0;},xt(wr,_r),wr.prototype._transform=function(e,t,r){r(null,e);},xt(kr,Ze),kr.Readable=Nt,kr.Writable=ir,kr.Duplex=gr,kr.Transform=_r,kr.PassThrough=wr,kr.Stream=kr,kr.prototype.pipe=function(e,t){var r=this;function n(t){e.writable&&!1===e.write(t)&&r.pause&&r.pause();}function i(){r.readable&&r.resume&&r.resume();}r.on("data",n),e.on("drain",i),e._isStdio||t&&!1===t.end||(r.on("end",s),r.on("close",a));var o=!1;function s(){o||(o=!0,e.end());}function a(){o||(o=!0,"function"==typeof e.destroy&&e.destroy());}function l(e){if(u(),0===Ze.listenerCount(this,"error"))throw e}function u(){r.removeListener("data",n),e.removeListener("drain",i),r.removeListener("end",s),r.removeListener("close",a),r.removeListener("error",l),e.removeListener("error",l),r.removeListener("end",u),r.removeListener("close",u),e.removeListener("close",u);}return r.on("error",l),e.on("error",l),r.on("end",u),r.on("close",u),e.on("close",u),e.emit("pipe",r),e};var Sr=kr,xr=e.createCommonjsModule(function(e,t){if(t.base64=!0,t.array=!0,t.string=!0,t.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,t.nodebuffer=!0,t.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)t.blob=!1;else{var r=new ArrayBuffer(0);try{t.blob=0===new Blob([r],{type:"application/zip"}).size;}catch(e){try{var n=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);n.append(r),t.blob=0===n.getBlob("application/zip").size;}catch(e){t.blob=!1;}}}try{t.nodestream=!!Sr.Readable;}catch(e){t.nodestream=!1;}}),Cr=(xr.base64,xr.array,xr.string,xr.arraybuffer,xr.nodebuffer,xr.uint8array,xr.blob,xr.nodestream,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="),Er={encode:function(e){for(var t,r,n,i,o,s,a,l=[],u=0,h=e.length,c=h,f="string"!==Bn.getTypeOf(e);u<e.length;)c=h-u,f?(t=e[u++],r=u<h?e[u++]:0,n=u<h?e[u++]:0):(t=e.charCodeAt(u++),r=u<h?e.charCodeAt(u++):0,n=u<h?e.charCodeAt(u++):0),i=t>>2,o=(3&t)<<4|r>>4,s=c>1?(15&r)<<2|n>>6:64,a=c>2?63&n:64,l.push(Cr.charAt(i)+Cr.charAt(o)+Cr.charAt(s)+Cr.charAt(a));return l.join("")},decode:function(e){var t,r,n,i,o,s,a=0,l=0;if("data:"===e.substr(0,"data:".length))throw new Error("Invalid base64 input, it looks like a data url.");var u,h=3*(e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"")).length/4;if(e.charAt(e.length-1)===Cr.charAt(64)&&h--,e.charAt(e.length-2)===Cr.charAt(64)&&h--,h%1!=0)throw new Error("Invalid base64 input, bad content length.");for(u=xr.uint8array?new Uint8Array(0|h):new Array(0|h);a<e.length;)t=Cr.indexOf(e.charAt(a++))<<2|(i=Cr.indexOf(e.charAt(a++)))>>4,r=(15&i)<<4|(o=Cr.indexOf(e.charAt(a++)))>>2,n=(3&o)<<6|(s=Cr.indexOf(e.charAt(a++))),u[l++]=t,64!==o&&(u[l++]=r),64!==s&&(u[l++]=n);return u}},Ar=!0,Tr=function(e,t){return new re(e,t)},zr=function(e){return re.alloc?re.alloc(e):new re(e)},Or=function(e){return je(e)},Rr=function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume},Lr=e.createCommonjsModule(function(e){var t=e.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=t);}),Ir=e.createCommonjsModule(function(e){var t=e.exports={version:"2.3.0"};"number"==typeof __e&&(__e=t);}),Br=(Ir.version,function(e,t,r){if(function(e){if("function"!=typeof e)throw TypeError(e+" is not a function!")}(e),void 0===t)return e;switch(r){case 1:return function(r){return e.call(t,r)};case 2:return function(r,n){return e.call(t,r,n)};case 3:return function(r,n,i){return e.call(t,r,n,i)}}return function(){return e.apply(t,arguments)}}),Fr=function(e){return "object"==typeof e?null!==e:"function"==typeof e},Pr=function(e){if(!Fr(e))throw TypeError(e+" is not an object!");return e},Mr=function(e){try{return !!e()}catch(e){return !0}},jr=!Mr(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}),Ur=Lr.document,Dr=Fr(Ur)&&Fr(Ur.createElement),Nr=function(e){return Dr?Ur.createElement(e):{}},Zr=!jr&&!Mr(function(){return 7!=Object.defineProperty(Nr("div"),"a",{get:function(){return 7}}).a}),Wr=Object.defineProperty,qr={f:jr?Object.defineProperty:function(e,t,r){if(Pr(e),t=function(e,t){if(!Fr(e))return e;var r,n;if(t&&"function"==typeof(r=e.toString)&&!Fr(n=r.call(e)))return n;if("function"==typeof(r=e.valueOf)&&!Fr(n=r.call(e)))return n;if(!t&&"function"==typeof(r=e.toString)&&!Fr(n=r.call(e)))return n;throw TypeError("Can't convert object to primitive value")}(t,!0),Pr(r),Zr)try{return Wr(e,t,r)}catch(e){}if("get"in r||"set"in r)throw TypeError("Accessors not supported!");return "value"in r&&(e[t]=r.value),e}},$r=jr?function(e,t,r){return qr.f(e,t,function(e,t){return {enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}(1,r))}:function(e,t,r){return e[t]=r,e},Yr=function(e,t,r){var n,i,o,s=e&Yr.F,a=e&Yr.G,l=e&Yr.S,u=e&Yr.P,h=e&Yr.B,c=e&Yr.W,f=a?Ir:Ir[t]||(Ir[t]={}),d=f.prototype,p=a?Lr:l?Lr[t]:(Lr[t]||{}).prototype;for(n in a&&(r=t),r)(i=!s&&p&&void 0!==p[n])&&n in f||(o=i?p[n]:r[n],f[n]=a&&"function"!=typeof p[n]?r[n]:h&&i?Br(o,Lr):c&&p[n]==o?function(e){var t=function(t,r,n){if(this instanceof e){switch(arguments.length){case 0:return new e;case 1:return new e(t);case 2:return new e(t,r)}return new e(t,r,n)}return e.apply(this,arguments)};return t.prototype=e.prototype,t}(o):u&&"function"==typeof o?Br(Function.call,o):o,u&&((f.virtual||(f.virtual={}))[n]=o,e&Yr.R&&d&&!d[n]&&$r(d,n,o)));};Yr.F=1,Yr.G=2,Yr.S=4,Yr.P=8,Yr.B=16,Yr.W=32,Yr.U=64,Yr.R=128;var Vr,Hr,Gr,Kr,Jr=Yr,Xr=Lr.document&&document.documentElement,Qr={}.toString,en=Lr.process,tn=Lr.setImmediate,rn=Lr.clearImmediate,nn=Lr.MessageChannel,on=0,sn={},an=function(){var e=+this;if(sn.hasOwnProperty(e)){var t=sn[e];delete sn[e],t();}},ln=function(e){an.call(e.data);};tn&&rn||(tn=function(e){for(var t=[],r=1;arguments.length>r;)t.push(arguments[r++]);return sn[++on]=function(){!function(e,t,r){var n=void 0===r;switch(t.length){case 0:return n?e():e.call(r);case 1:return n?e(t[0]):e.call(r,t[0]);case 2:return n?e(t[0],t[1]):e.call(r,t[0],t[1]);case 3:return n?e(t[0],t[1],t[2]):e.call(r,t[0],t[1],t[2]);case 4:return n?e(t[0],t[1],t[2],t[3]):e.call(r,t[0],t[1],t[2],t[3])}e.apply(r,t);}("function"==typeof e?e:Function(e),t);},Vr(on),on},rn=function(e){delete sn[e];},"process"==(Kr=en,Qr.call(Kr).slice(8,-1))?Vr=function(e){en.nextTick(Br(an,e,1));}:nn?(Gr=(Hr=new nn).port2,Hr.port1.onmessage=ln,Vr=Br(Gr.postMessage,Gr,1)):Lr.addEventListener&&"function"==typeof postMessage&&!Lr.importScripts?(Vr=function(e){Lr.postMessage(e+"","*");},Lr.addEventListener("message",ln,!1)):Vr="onreadystatechange"in Nr("script")?function(e){Xr.appendChild(Nr("script")).onreadystatechange=function(){Xr.removeChild(this),an.call(e);};}:function(e){setTimeout(Br(an,e,1),0);});var un={set:tn,clear:rn};Jr(Jr.G+Jr.B,{setImmediate:un.set,clearImmediate:un.clear});var hn,cn,fn=Ir.setImmediate,dn=N.MutationObserver||N.WebKitMutationObserver;if(dn){var pn=0,gn=new dn(_n),mn=N.document.createTextNode("");gn.observe(mn,{characterData:!0}),hn=function(){mn.data=pn=++pn%2;};}else if(N.setImmediate||void 0===N.MessageChannel)hn="document"in N&&"onreadystatechange"in N.document.createElement("script")?function(){var e=N.document.createElement("script");e.onreadystatechange=function(){_n(),e.onreadystatechange=null,e.parentNode.removeChild(e),e=null;},N.document.documentElement.appendChild(e);}:function(){setTimeout(_n,0);};else{var vn=new N.MessageChannel;vn.port1.onmessage=_n,hn=function(){vn.port2.postMessage(0);};}var yn=[];function _n(){var e,t;cn=!0;for(var r=yn.length;r;){for(t=yn,yn=[],e=-1;++e<r;)t[e]();r=yn.length;}cn=!1;}var bn=function(e){1!==yn.push(e)||cn||hn();};function wn(){}var kn={},Sn=["REJECTED"],xn=["FULFILLED"],Cn=["PENDING"],En=An;function An(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=Cn,this.queue=[],this.outcome=void 0,e!==wn&&Rn(this,e);}function Tn(e,t,r){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected);}function zn(e,t,r){bn(function(){var n;try{n=t(r);}catch(t){return kn.reject(e,t)}n===e?kn.reject(e,new TypeError("Cannot resolve promise with itself")):kn.resolve(e,n);});}function On(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments);}}function Rn(e,t){var r=!1;function n(t){r||(r=!0,kn.reject(e,t));}function i(t){r||(r=!0,kn.resolve(e,t));}var o=Ln(function(){t(i,n);});"error"===o.status&&n(o.value);}function Ln(e,t){var r={};try{r.value=e(t),r.status="success";}catch(e){r.status="error",r.value=e;}return r}An.prototype.catch=function(e){return this.then(null,e)},An.prototype.then=function(e,t){if("function"!=typeof e&&this.state===xn||"function"!=typeof t&&this.state===Sn)return this;var r=new this.constructor(wn);this.state!==Cn?zn(r,this.state===xn?e:t,this.outcome):this.queue.push(new Tn(r,e,t));return r},Tn.prototype.callFulfilled=function(e){kn.resolve(this.promise,e);},Tn.prototype.otherCallFulfilled=function(e){zn(this.promise,this.onFulfilled,e);},Tn.prototype.callRejected=function(e){kn.reject(this.promise,e);},Tn.prototype.otherCallRejected=function(e){zn(this.promise,this.onRejected,e);},kn.resolve=function(e,t){var r=Ln(On,t);if("error"===r.status)return kn.reject(e,r.value);var n=r.value;if(n)Rn(e,n);else{e.state=xn,e.outcome=t;for(var i=-1,o=e.queue.length;++i<o;)e.queue[i].callFulfilled(t);}return e},kn.reject=function(e,t){e.state=Sn,e.outcome=t;for(var r=-1,n=e.queue.length;++r<n;)e.queue[r].callRejected(t);return e},An.resolve=function(e){if(e instanceof this)return e;return kn.resolve(new this(wn),e)},An.reject=function(e){var t=new this(wn);return kn.reject(t,e)},An.all=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);var i=new Array(r),o=0,s=-1,a=new this(wn);for(;++s<r;)l(e[s],s);return a;function l(e,s){t.resolve(e).then(function(e){i[s]=e,++o!==r||n||(n=!0,kn.resolve(a,i));},function(e){n||(n=!0,kn.reject(a,e));});}},An.race=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);var i=-1,o=new this(wn);for(;++i<r;)s=e[i],t.resolve(s).then(function(e){n||(n=!0,kn.resolve(o,e));},function(e){n||(n=!0,kn.reject(o,e));});var s;return o};var In={Promise:"undefined"!=typeof Promise?Promise:En},Bn=e.createCommonjsModule(function(e,t){function r(e){return e}function n(e,t){for(var r=0;r<e.length;++r)t[r]=255&e.charCodeAt(r);return t}t.newBlob=function(e,r){t.checkSupport("blob");try{return new Blob([e],{type:r})}catch(t){try{var n=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return n.append(e),n.getBlob(r)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var i={stringifyByChunk:function(e,t,r){var n=[],i=0,o=e.length;if(o<=r)return String.fromCharCode.apply(null,e);for(;i<o;)"array"===t||"nodebuffer"===t?n.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+r,o)))):n.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+r,o)))),i+=r;return n.join("")},stringifyByChar:function(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return t},applyCanBeUsed:{uint8array:function(){try{return xr.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return !1}}(),nodebuffer:function(){try{return xr.nodebuffer&&1===String.fromCharCode.apply(null,zr(1)).length}catch(e){return !1}}()}};function o(e){var r=65536,n=t.getTypeOf(e),o=!0;if("uint8array"===n?o=i.applyCanBeUsed.uint8array:"nodebuffer"===n&&(o=i.applyCanBeUsed.nodebuffer),o)for(;r>1;)try{return i.stringifyByChunk(e,n,r)}catch(e){r=Math.floor(r/2);}return i.stringifyByChar(e)}function s(e,t){for(var r=0;r<e.length;r++)t[r]=e[r];return t}t.applyFromCharCode=o;var a={};a.string={string:r,array:function(e){return n(e,new Array(e.length))},arraybuffer:function(e){return a.string.uint8array(e).buffer},uint8array:function(e){return n(e,new Uint8Array(e.length))},nodebuffer:function(e){return n(e,zr(e.length))}},a.array={string:o,array:r,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return Tr(e)}},a.arraybuffer={string:function(e){return o(new Uint8Array(e))},array:function(e){return s(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:r,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return Tr(new Uint8Array(e))}},a.uint8array={string:o,array:function(e){return s(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:r,nodebuffer:function(e){return Tr(e)}},a.nodebuffer={string:o,array:function(e){return s(e,new Array(e.length))},arraybuffer:function(e){return a.nodebuffer.uint8array(e).buffer},uint8array:function(e){return s(e,new Uint8Array(e.length))},nodebuffer:r},t.transformTo=function(e,r){if(r||(r=""),!e)return r;t.checkSupport(e);var n=t.getTypeOf(r);return a[n][e](r)},t.getTypeOf=function(e){return "string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":xr.nodebuffer&&Or(e)?"nodebuffer":xr.uint8array&&e instanceof Uint8Array?"uint8array":xr.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},t.checkSupport=function(e){if(!xr[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},t.MAX_VALUE_16BITS=65535,t.MAX_VALUE_32BITS=-1,t.pretty=function(e){var t,r,n="";for(r=0;r<(e||"").length;r++)n+="\\x"+((t=e.charCodeAt(r))<16?"0":"")+t.toString(16).toUpperCase();return n},t.delay=function(e,t,r){fn(function(){e.apply(r||null,t||[]);});},t.inherits=function(e,t){var r=function(){};r.prototype=t.prototype,e.prototype=new r;},t.extend=function(){var e,t,r={};for(e=0;e<arguments.length;e++)for(t in arguments[e])arguments[e].hasOwnProperty(t)&&void 0===r[t]&&(r[t]=arguments[e][t]);return r},t.prepareContent=function(e,r,i,o,s){return In.Promise.resolve(r).then(function(e){return xr.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new In.Promise(function(t,r){var n=new FileReader;n.onload=function(e){t(e.target.result);},n.onerror=function(e){r(e.target.error);},n.readAsArrayBuffer(e);}):e}).then(function(r){var a,l=t.getTypeOf(r);return l?("arraybuffer"===l?r=t.transformTo("uint8array",r):"string"===l&&(s?r=Er.decode(r):i&&!0!==o&&(r=n(a=r,xr.uint8array?new Uint8Array(a.length):new Array(a.length)))),r):In.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))})};});Bn.newBlob,Bn.applyFromCharCode,Bn.transformTo,Bn.getTypeOf,Bn.checkSupport,Bn.MAX_VALUE_16BITS,Bn.MAX_VALUE_32BITS,Bn.pretty,Bn.delay,Bn.inherits,Bn.extend,Bn.prepareContent;function Fn(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null;}Fn.prototype={push:function(e){this.emit("data",e);},end:function(){if(this.isFinished)return !1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0;}catch(e){this.emit("error",e);}return !0},error:function(e){return !this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[];},emit:function(e,t){if(this._listeners[e])for(var r=0;r<this._listeners[e].length;r++)this._listeners[e][r].call(this,t);},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",function(e){t.processChunk(e);}),e.on("end",function(){t.end();}),e.on("error",function(e){t.error(e);}),this},pause:function(){return !this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return !1;this.isPaused=!1;var e=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e);},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(e)&&(this.streamInfo[e]=this.extraStreamInfo[e]);},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock();},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}};var Pn=Fn,Mn=e.createCommonjsModule(function(e,t){for(var r=new Array(256),n=0;n<256;n++)r[n]=n>=252?6:n>=248?5:n>=240?4:n>=224?3:n>=192?2:1;r[254]=r[254]=1;function i(){Pn.call(this,"utf-8 decode"),this.leftOver=null;}function o(){Pn.call(this,"utf-8 encode");}t.utf8encode=function(e){return xr.nodebuffer?Tr(e,"utf-8"):function(e){var t,r,n,i,o,s=e.length,a=0;for(i=0;i<s;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<s&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),a+=r<128?1:r<2048?2:r<65536?3:4;for(t=xr.uint8array?new Uint8Array(a):new Array(a),o=0,i=0;o<a;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<s&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),r<128?t[o++]=r:r<2048?(t[o++]=192|r>>>6,t[o++]=128|63&r):r<65536?(t[o++]=224|r>>>12,t[o++]=128|r>>>6&63,t[o++]=128|63&r):(t[o++]=240|r>>>18,t[o++]=128|r>>>12&63,t[o++]=128|r>>>6&63,t[o++]=128|63&r);return t}(e)},t.utf8decode=function(e){return xr.nodebuffer?Bn.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,n,i,o,s=e.length,a=new Array(2*s);for(n=0,t=0;t<s;)if((i=e[t++])<128)a[n++]=i;else if((o=r[i])>4)a[n++]=65533,t+=o-1;else{for(i&=2===o?31:3===o?15:7;o>1&&t<s;)i=i<<6|63&e[t++],o--;o>1?a[n++]=65533:i<65536?a[n++]=i:(i-=65536,a[n++]=55296|i>>10&1023,a[n++]=56320|1023&i);}return a.length!==n&&(a.subarray?a=a.subarray(0,n):a.length=n),Bn.applyFromCharCode(a)}(e=Bn.transformTo(xr.uint8array?"uint8array":"array",e))},Bn.inherits(i,Pn),i.prototype.processChunk=function(e){var n=Bn.transformTo(xr.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(xr.uint8array){var i=n;(n=new Uint8Array(i.length+this.leftOver.length)).set(this.leftOver,0),n.set(i,this.leftOver.length);}else n=this.leftOver.concat(n);this.leftOver=null;}var o=function(e,t){var n;for((t=t||e.length)>e.length&&(t=e.length),n=t-1;n>=0&&128==(192&e[n]);)n--;return n<0?t:0===n?t:n+r[e[n]]>t?n:t}(n),s=n;o!==n.length&&(xr.uint8array?(s=n.subarray(0,o),this.leftOver=n.subarray(o,n.length)):(s=n.slice(0,o),this.leftOver=n.slice(o,n.length))),this.push({data:t.utf8decode(s),meta:e.meta});},i.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:t.utf8decode(this.leftOver),meta:{}}),this.leftOver=null);},t.Utf8DecodeWorker=i,Bn.inherits(o,Pn),o.prototype.processChunk=function(e){this.push({data:t.utf8encode(e.data),meta:e.meta});},t.Utf8EncodeWorker=o;});Mn.utf8encode,Mn.utf8decode,Mn.Utf8DecodeWorker,Mn.Utf8EncodeWorker;function jn(e){Pn.call(this,"ConvertWorker to "+e),this.destType=e;}Bn.inherits(jn,Pn),jn.prototype.processChunk=function(e){this.push({data:Bn.transformTo(this.destType,e.data),meta:e.meta});};var Un=jn,Dn=Sr.Readable;function Nn(e,t,r){Dn.call(this,t),this._helper=e;var n=this;e.on("data",function(e,t){n.push(e)||n._helper.pause(),r&&r(t);}).on("error",function(e){n.emit("error",e);}).on("end",function(){n.push(null);});}Bn.inherits(Nn,Dn),Nn.prototype._read=function(){this._helper.resume();};var Zn=Nn,Wn=null;if(xr.nodestream)try{Wn=Zn;}catch(e){}function qn(e,t){return new In.Promise(function(r,n){var i=[],o=e._internalType,s=e._outputType,a=e._mimeType;e.on("data",function(e,r){i.push(e),t&&t(r);}).on("error",function(e){i=[],n(e);}).on("end",function(){try{var e=function(e,t,r){switch(e){case"blob":return Bn.newBlob(Bn.transformTo("arraybuffer",t),r);case"base64":return Er.encode(t);default:return Bn.transformTo(e,t)}}(s,function(e,t){var r,n=0,i=null,o=0;for(r=0;r<t.length;r++)o+=t[r].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(i=new Uint8Array(o),r=0;r<t.length;r++)i.set(t[r],n),n+=t[r].length;return i;case"nodebuffer":return re.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(o,i),a);r(e);}catch(e){n(e);}i=[];}).resume();})}function $n(e,t,r){var n=t;switch(t){case"blob":case"arraybuffer":n="uint8array";break;case"base64":n="string";}try{this._internalType=n,this._outputType=t,this._mimeType=r,Bn.checkSupport(n),this._worker=e.pipe(new Un(n)),e.lock();}catch(e){this._worker=new Pn("error"),this._worker.error(e);}}$n.prototype={accumulate:function(e){return qn(this,e)},on:function(e,t){var r=this;return "data"===e?this._worker.on(e,function(e){t.call(r,e.data,e.meta);}):this._worker.on(e,function(){Bn.delay(t,arguments,r);}),this},resume:function(){return Bn.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(Bn.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new Wn(this,{objectMode:"nodebuffer"!==this._outputType},e)}};var Yn=$n,Vn={base64:!1,binary:!1,dir:!1,createFolders:!0,date:null,compression:null,compressionOptions:null,comment:null,unixPermissions:null,dosPermissions:null};function Hn(e){Pn.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then(function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=Bn.getTypeOf(e),t.isPaused||t._tickAndRepeat();},function(e){t.error(e);});}Bn.inherits(Hn,Pn),Hn.prototype.cleanUp=function(){Pn.prototype.cleanUp.call(this),this.data=null;},Hn.prototype.resume=function(){return !!Pn.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,Bn.delay(this._tickAndRepeat,[],this)),!0)},Hn.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(Bn.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0));},Hn.prototype._tick=function(){if(this.isPaused||this.isFinished)return !1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t);}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})};var Gn=Hn;function Kn(e){Pn.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0);}Bn.inherits(Kn,Pn),Kn.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length;}Pn.prototype.processChunk.call(this,e);};var Jn=Kn;var Xn=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e;}return t}();var Qn=function(e,t){return void 0!==e&&e.length?"string"!==Bn.getTypeOf(e)?function(e,t,r,n){var i=Xn,o=n+r;e^=-1;for(var s=n;s<o;s++)e=e>>>8^i[255&(e^t[s])];return -1^e}(0|t,e,e.length,0):function(e,t,r,n){var i=Xn,o=n+r;e^=-1;for(var s=n;s<o;s++)e=e>>>8^i[255&(e^t.charCodeAt(s))];return -1^e}(0|t,e,e.length,0):0};function ei(){Pn.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0);}Bn.inherits(ei,Pn),ei.prototype.processChunk=function(e){this.streamInfo.crc32=Qn(e.data,this.streamInfo.crc32||0),this.push(e);};var ti=ei;function ri(e,t,r,n,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=r,this.compression=n,this.compressedContent=i;}ri.prototype={getContentWorker:function(){var e=new Gn(In.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new Jn("data_length")),t=this;return e.on("end",function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")}),e},getCompressedWorker:function(){return new Gn(In.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},ri.createWorkerFrom=function(e,t,r){return e.pipe(new ti).pipe(new Jn("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new Jn("compressedSize")).withStreamInfo("compression",t)};var ni=ri,ii=function(e,t,r){this.name=e,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=t,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions};};ii.prototype={internalStream:function(e){var t=null,r="string";try{if(!e)throw new Error("No output type specified.");var n="string"===(r=e.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),t=this._decompressWorker();var i=!this._dataBinary;i&&!n&&(t=t.pipe(new Mn.Utf8EncodeWorker)),!i&&n&&(t=t.pipe(new Mn.Utf8DecodeWorker));}catch(e){(t=new Pn("error")).error(e);}return new Yn(t,r,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof ni&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new Mn.Utf8EncodeWorker)),ni.createWorkerFrom(r,e,t)},_decompressWorker:function(){return this._data instanceof ni?this._data.getContentWorker():this._data instanceof Pn?this._data:new Gn(this._data)}};for(var oi=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],si=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},ai=0;ai<oi.length;ai++)ii.prototype[oi[ai]]=si;var li=ii,ui=e.createCommonjsModule(function(e,t){var r="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;function n(e,t){return Object.prototype.hasOwnProperty.call(e,t)}t.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var r=t.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var i in r)n(r,i)&&(e[i]=r[i]);}}return e},t.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var i={arraySet:function(e,t,r,n,i){if(t.subarray&&e.subarray)e.set(t.subarray(r,r+n),i);else for(var o=0;o<n;o++)e[i+o]=t[r+o];},flattenChunks:function(e){var t,r,n,i,o,s;for(n=0,t=0,r=e.length;t<r;t++)n+=e[t].length;for(s=new Uint8Array(n),i=0,t=0,r=e.length;t<r;t++)o=e[t],s.set(o,i),i+=o.length;return s}},o={arraySet:function(e,t,r,n,i){for(var o=0;o<n;o++)e[i+o]=t[r+o];},flattenChunks:function(e){return [].concat.apply([],e)}};t.setTyped=function(e){e?(t.Buf8=Uint8Array,t.Buf16=Uint16Array,t.Buf32=Int32Array,t.assign(t,i)):(t.Buf8=Array,t.Buf16=Array,t.Buf32=Array,t.assign(t,o));},t.setTyped(r);}),hi=(ui.assign,ui.shrinkBuf,ui.setTyped,ui.Buf8,ui.Buf16,ui.Buf32,4),ci=0,fi=1,di=2;function pi(e){for(var t=e.length;--t>=0;)e[t]=0;}var gi=0,mi=1,vi=2,yi=29,_i=256,bi=_i+1+yi,wi=30,ki=19,Si=2*bi+1,xi=15,Ci=16,Ei=7,Ai=256,Ti=16,zi=17,Oi=18,Ri=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],Li=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],Ii=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],Bi=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],Fi=new Array(2*(bi+2));pi(Fi);var Pi=new Array(2*wi);pi(Pi);var Mi=new Array(512);pi(Mi);var ji=new Array(256);pi(ji);var Ui=new Array(yi);pi(Ui);var Di,Ni,Zi,Wi=new Array(wi);function qi(e,t,r,n,i){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=e&&e.length;}function $i(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t;}function Yi(e){return e<256?Mi[e]:Mi[256+(e>>>7)]}function Vi(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255;}function Hi(e,t,r){e.bi_valid>Ci-r?(e.bi_buf|=t<<e.bi_valid&65535,Vi(e,e.bi_buf),e.bi_buf=t>>Ci-e.bi_valid,e.bi_valid+=r-Ci):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r);}function Gi(e,t,r){Hi(e,r[2*t],r[2*t+1]);}function Ki(e,t){var r=0;do{r|=1&e,e>>>=1,r<<=1;}while(--t>0);return r>>>1}function Ji(e,t,r){var n,i,o=new Array(xi+1),s=0;for(n=1;n<=xi;n++)o[n]=s=s+r[n-1]<<1;for(i=0;i<=t;i++){var a=e[2*i+1];0!==a&&(e[2*i]=Ki(o[a]++,a));}}function Xi(e){var t;for(t=0;t<bi;t++)e.dyn_ltree[2*t]=0;for(t=0;t<wi;t++)e.dyn_dtree[2*t]=0;for(t=0;t<ki;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*Ai]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0;}function Qi(e){e.bi_valid>8?Vi(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0;}function eo(e,t,r,n){var i=2*t,o=2*r;return e[i]<e[o]||e[i]===e[o]&&n[t]<=n[r]}function to(e,t,r){for(var n=e.heap[r],i=r<<1;i<=e.heap_len&&(i<e.heap_len&&eo(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!eo(t,n,e.heap[i],e.depth));)e.heap[r]=e.heap[i],r=i,i<<=1;e.heap[r]=n;}function ro(e,t,r){var n,i,o,s,a=0;if(0!==e.last_lit)do{n=e.pending_buf[e.d_buf+2*a]<<8|e.pending_buf[e.d_buf+2*a+1],i=e.pending_buf[e.l_buf+a],a++,0===n?Gi(e,i,t):(Gi(e,(o=ji[i])+_i+1,t),0!==(s=Ri[o])&&Hi(e,i-=Ui[o],s),Gi(e,o=Yi(--n),r),0!==(s=Li[o])&&Hi(e,n-=Wi[o],s));}while(a<e.last_lit);Gi(e,Ai,t);}function no(e,t){var r,n,i,o=t.dyn_tree,s=t.stat_desc.static_tree,a=t.stat_desc.has_stree,l=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=Si,r=0;r<l;r++)0!==o[2*r]?(e.heap[++e.heap_len]=u=r,e.depth[r]=0):o[2*r+1]=0;for(;e.heap_len<2;)o[2*(i=e.heap[++e.heap_len]=u<2?++u:0)]=1,e.depth[i]=0,e.opt_len--,a&&(e.static_len-=s[2*i+1]);for(t.max_code=u,r=e.heap_len>>1;r>=1;r--)to(e,o,r);i=l;do{r=e.heap[1],e.heap[1]=e.heap[e.heap_len--],to(e,o,1),n=e.heap[1],e.heap[--e.heap_max]=r,e.heap[--e.heap_max]=n,o[2*i]=o[2*r]+o[2*n],e.depth[i]=(e.depth[r]>=e.depth[n]?e.depth[r]:e.depth[n])+1,o[2*r+1]=o[2*n+1]=i,e.heap[1]=i++,to(e,o,1);}while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],function(e,t){var r,n,i,o,s,a,l=t.dyn_tree,u=t.max_code,h=t.stat_desc.static_tree,c=t.stat_desc.has_stree,f=t.stat_desc.extra_bits,d=t.stat_desc.extra_base,p=t.stat_desc.max_length,g=0;for(o=0;o<=xi;o++)e.bl_count[o]=0;for(l[2*e.heap[e.heap_max]+1]=0,r=e.heap_max+1;r<Si;r++)(o=l[2*l[2*(n=e.heap[r])+1]+1]+1)>p&&(o=p,g++),l[2*n+1]=o,n>u||(e.bl_count[o]++,s=0,n>=d&&(s=f[n-d]),a=l[2*n],e.opt_len+=a*(o+s),c&&(e.static_len+=a*(h[2*n+1]+s)));if(0!==g){do{for(o=p-1;0===e.bl_count[o];)o--;e.bl_count[o]--,e.bl_count[o+1]+=2,e.bl_count[p]--,g-=2;}while(g>0);for(o=p;0!==o;o--)for(n=e.bl_count[o];0!==n;)(i=e.heap[--r])>u||(l[2*i+1]!==o&&(e.opt_len+=(o-l[2*i+1])*l[2*i],l[2*i+1]=o),n--);}}(e,t),Ji(o,u,e.bl_count);}function io(e,t,r){var n,i,o=-1,s=t[1],a=0,l=7,u=4;for(0===s&&(l=138,u=3),t[2*(r+1)+1]=65535,n=0;n<=r;n++)i=s,s=t[2*(n+1)+1],++a<l&&i===s||(a<u?e.bl_tree[2*i]+=a:0!==i?(i!==o&&e.bl_tree[2*i]++,e.bl_tree[2*Ti]++):a<=10?e.bl_tree[2*zi]++:e.bl_tree[2*Oi]++,a=0,o=i,0===s?(l=138,u=3):i===s?(l=6,u=3):(l=7,u=4));}function oo(e,t,r){var n,i,o=-1,s=t[1],a=0,l=7,u=4;for(0===s&&(l=138,u=3),n=0;n<=r;n++)if(i=s,s=t[2*(n+1)+1],!(++a<l&&i===s)){if(a<u)do{Gi(e,i,e.bl_tree);}while(0!=--a);else 0!==i?(i!==o&&(Gi(e,i,e.bl_tree),a--),Gi(e,Ti,e.bl_tree),Hi(e,a-3,2)):a<=10?(Gi(e,zi,e.bl_tree),Hi(e,a-3,3)):(Gi(e,Oi,e.bl_tree),Hi(e,a-11,7));a=0,o=i,0===s?(l=138,u=3):i===s?(l=6,u=3):(l=7,u=4);}}pi(Wi);var so=!1;function ao(e,t,r,n){Hi(e,(gi<<1)+(n?1:0),3),function(e,t,r,n){Qi(e),n&&(Vi(e,r),Vi(e,~r)),ui.arraySet(e.pending_buf,e.window,t,r,e.pending),e.pending+=r;}(e,t,r,!0);}var lo={_tr_init:function(e){so||(function(){var e,t,r,n,i,o=new Array(xi+1);for(r=0,n=0;n<yi-1;n++)for(Ui[n]=r,e=0;e<1<<Ri[n];e++)ji[r++]=n;for(ji[r-1]=n,i=0,n=0;n<16;n++)for(Wi[n]=i,e=0;e<1<<Li[n];e++)Mi[i++]=n;for(i>>=7;n<wi;n++)for(Wi[n]=i<<7,e=0;e<1<<Li[n]-7;e++)Mi[256+i++]=n;for(t=0;t<=xi;t++)o[t]=0;for(e=0;e<=143;)Fi[2*e+1]=8,e++,o[8]++;for(;e<=255;)Fi[2*e+1]=9,e++,o[9]++;for(;e<=279;)Fi[2*e+1]=7,e++,o[7]++;for(;e<=287;)Fi[2*e+1]=8,e++,o[8]++;for(Ji(Fi,bi+1,o),e=0;e<wi;e++)Pi[2*e+1]=5,Pi[2*e]=Ki(e,5);Di=new qi(Fi,Ri,_i+1,bi,xi),Ni=new qi(Pi,Li,0,wi,xi),Zi=new qi(new Array(0),Ii,0,ki,Ei);}(),so=!0),e.l_desc=new $i(e.dyn_ltree,Di),e.d_desc=new $i(e.dyn_dtree,Ni),e.bl_desc=new $i(e.bl_tree,Zi),e.bi_buf=0,e.bi_valid=0,Xi(e);},_tr_stored_block:ao,_tr_flush_block:function(e,t,r,n){var i,o,s=0;e.level>0?(e.strm.data_type===di&&(e.strm.data_type=function(e){var t,r=4093624447;for(t=0;t<=31;t++,r>>>=1)if(1&r&&0!==e.dyn_ltree[2*t])return ci;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return fi;for(t=32;t<_i;t++)if(0!==e.dyn_ltree[2*t])return fi;return ci}(e)),no(e,e.l_desc),no(e,e.d_desc),s=function(e){var t;for(io(e,e.dyn_ltree,e.l_desc.max_code),io(e,e.dyn_dtree,e.d_desc.max_code),no(e,e.bl_desc),t=ki-1;t>=3&&0===e.bl_tree[2*Bi[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),i=e.opt_len+3+7>>>3,(o=e.static_len+3+7>>>3)<=i&&(i=o)):i=o=r+5,r+4<=i&&-1!==t?ao(e,t,r,n):e.strategy===hi||o===i?(Hi(e,(mi<<1)+(n?1:0),3),ro(e,Fi,Pi)):(Hi(e,(vi<<1)+(n?1:0),3),function(e,t,r,n){var i;for(Hi(e,t-257,5),Hi(e,r-1,5),Hi(e,n-4,4),i=0;i<n;i++)Hi(e,e.bl_tree[2*Bi[i]+1],3);oo(e,e.dyn_ltree,t-1),oo(e,e.dyn_dtree,r-1);}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,s+1),ro(e,e.dyn_ltree,e.dyn_dtree)),Xi(e),n&&Qi(e);},_tr_tally:function(e,t,r){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&r,e.last_lit++,0===t?e.dyn_ltree[2*r]++:(e.matches++,t--,e.dyn_ltree[2*(ji[r]+_i+1)]++,e.dyn_dtree[2*Yi(t)]++),e.last_lit===e.lit_bufsize-1},_tr_align:function(e){Hi(e,mi<<1,3),Gi(e,Ai,Fi),function(e){16===e.bi_valid?(Vi(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=255&e.bi_buf,e.bi_buf>>=8,e.bi_valid-=8);}(e);}};var uo=function(e,t,r,n){for(var i=65535&e|0,o=e>>>16&65535|0,s=0;0!==r;){r-=s=r>2e3?2e3:r;do{o=o+(i=i+t[n++]|0)|0;}while(--s);i%=65521,o%=65521;}return i|o<<16|0};var ho=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e;}return t}();var co,fo=function(e,t,r,n){var i=ho,o=n+r;e^=-1;for(var s=n;s<o;s++)e=e>>>8^i[255&(e^t[s])];return -1^e},po={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"},go=0,mo=1,vo=3,yo=4,_o=5,bo=0,wo=1,ko=-2,So=-3,xo=-5,Co=-1,Eo=1,Ao=2,To=3,zo=4,Oo=0,Ro=2,Lo=8,Io=9,Bo=15,Fo=8,Po=286,Mo=30,jo=19,Uo=2*Po+1,Do=15,No=3,Zo=258,Wo=Zo+No+1,qo=32,$o=42,Yo=69,Vo=73,Ho=91,Go=103,Ko=113,Jo=666,Xo=1,Qo=2,es=3,ts=4,rs=3;function ns(e,t){return e.msg=po[t],t}function is(e){return (e<<1)-(e>4?9:0)}function os(e){for(var t=e.length;--t>=0;)e[t]=0;}function ss(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),0!==r&&(ui.arraySet(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,0===t.pending&&(t.pending_out=0));}function as(e,t){lo._tr_flush_block(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,ss(e.strm);}function ls(e,t){e.pending_buf[e.pending++]=t;}function us(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t;}function hs(e,t){var r,n,i=e.max_chain_length,o=e.strstart,s=e.prev_length,a=e.nice_match,l=e.strstart>e.w_size-Wo?e.strstart-(e.w_size-Wo):0,u=e.window,h=e.w_mask,c=e.prev,f=e.strstart+Zo,d=u[o+s-1],p=u[o+s];e.prev_length>=e.good_match&&(i>>=2),a>e.lookahead&&(a=e.lookahead);do{if(u[(r=t)+s]===p&&u[r+s-1]===d&&u[r]===u[o]&&u[++r]===u[o+1]){o+=2,r++;do{}while(u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&u[++o]===u[++r]&&o<f);if(n=Zo-(f-o),o=f-Zo,n>s){if(e.match_start=t,s=n,n>=a)break;d=u[o+s-1],p=u[o+s];}}}while((t=c[t&h])>l&&0!=--i);return s<=e.lookahead?s:e.lookahead}function cs(e){var t,r,n,i,o,s,a,l,u,h,c=e.w_size;do{if(i=e.window_size-e.lookahead-e.strstart,e.strstart>=c+(c-Wo)){ui.arraySet(e.window,e.window,c,c,0),e.match_start-=c,e.strstart-=c,e.block_start-=c,t=r=e.hash_size;do{n=e.head[--t],e.head[t]=n>=c?n-c:0;}while(--r);t=r=c;do{n=e.prev[--t],e.prev[t]=n>=c?n-c:0;}while(--r);i+=c;}if(0===e.strm.avail_in)break;if(s=e.strm,a=e.window,l=e.strstart+e.lookahead,u=i,h=void 0,(h=s.avail_in)>u&&(h=u),r=0===h?0:(s.avail_in-=h,ui.arraySet(a,s.input,s.next_in,h,l),1===s.state.wrap?s.adler=uo(s.adler,a,h,l):2===s.state.wrap&&(s.adler=fo(s.adler,a,h,l)),s.next_in+=h,s.total_in+=h,h),e.lookahead+=r,e.lookahead+e.insert>=No)for(o=e.strstart-e.insert,e.ins_h=e.window[o],e.ins_h=(e.ins_h<<e.hash_shift^e.window[o+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[o+No-1])&e.hash_mask,e.prev[o&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=o,o++,e.insert--,!(e.lookahead+e.insert<No)););}while(e.lookahead<Wo&&0!==e.strm.avail_in)}function fs(e,t){for(var r,n;;){if(e.lookahead<Wo){if(cs(e),e.lookahead<Wo&&t===go)return Xo;if(0===e.lookahead)break}if(r=0,e.lookahead>=No&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+No-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==r&&e.strstart-r<=e.w_size-Wo&&(e.match_length=hs(e,r)),e.match_length>=No)if(n=lo._tr_tally(e,e.strstart-e.match_start,e.match_length-No),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=No){e.match_length--;do{e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+No-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart;}while(0!=--e.match_length);e.strstart++;}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=lo._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(as(e,!1),0===e.strm.avail_out))return Xo}return e.insert=e.strstart<No-1?e.strstart:No-1,t===yo?(as(e,!0),0===e.strm.avail_out?es:ts):e.last_lit&&(as(e,!1),0===e.strm.avail_out)?Xo:Qo}function ds(e,t){for(var r,n,i;;){if(e.lookahead<Wo){if(cs(e),e.lookahead<Wo&&t===go)return Xo;if(0===e.lookahead)break}if(r=0,e.lookahead>=No&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+No-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=No-1,0!==r&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-Wo&&(e.match_length=hs(e,r),e.match_length<=5&&(e.strategy===Eo||e.match_length===No&&e.strstart-e.match_start>4096)&&(e.match_length=No-1)),e.prev_length>=No&&e.match_length<=e.prev_length){i=e.strstart+e.lookahead-No,n=lo._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-No),e.lookahead-=e.prev_length-1,e.prev_length-=2;do{++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+No-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart);}while(0!=--e.prev_length);if(e.match_available=0,e.match_length=No-1,e.strstart++,n&&(as(e,!1),0===e.strm.avail_out))return Xo}else if(e.match_available){if((n=lo._tr_tally(e,0,e.window[e.strstart-1]))&&as(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return Xo}else e.match_available=1,e.strstart++,e.lookahead--;}return e.match_available&&(n=lo._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<No-1?e.strstart:No-1,t===yo?(as(e,!0),0===e.strm.avail_out?es:ts):e.last_lit&&(as(e,!1),0===e.strm.avail_out)?Xo:Qo}function ps(e,t,r,n,i){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=i;}function gs(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Lo,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new ui.Buf16(2*Uo),this.dyn_dtree=new ui.Buf16(2*(2*Mo+1)),this.bl_tree=new ui.Buf16(2*(2*jo+1)),os(this.dyn_ltree),os(this.dyn_dtree),os(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new ui.Buf16(Do+1),this.heap=new ui.Buf16(2*Po+1),os(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new ui.Buf16(2*Po+1),os(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0;}function ms(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=Ro,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?$o:Ko,e.adler=2===t.wrap?0:1,t.last_flush=go,lo._tr_init(t),bo):ns(e,ko)}function vs(e){var t,r=ms(e);return r===bo&&((t=e.state).window_size=2*t.w_size,os(t.head),t.max_lazy_match=co[t.level].max_lazy,t.good_match=co[t.level].good_length,t.nice_match=co[t.level].nice_length,t.max_chain_length=co[t.level].max_chain,t.strstart=0,t.block_start=0,t.lookahead=0,t.insert=0,t.match_length=t.prev_length=No-1,t.match_available=0,t.ins_h=0),r}function ys(e,t,r,n,i,o){if(!e)return ko;var s=1;if(t===Co&&(t=6),n<0?(s=0,n=-n):n>15&&(s=2,n-=16),i<1||i>Io||r!==Lo||n<8||n>15||t<0||t>9||o<0||o>zo)return ns(e,ko);8===n&&(n=9);var a=new gs;return e.state=a,a.strm=e,a.wrap=s,a.gzhead=null,a.w_bits=n,a.w_size=1<<a.w_bits,a.w_mask=a.w_size-1,a.hash_bits=i+7,a.hash_size=1<<a.hash_bits,a.hash_mask=a.hash_size-1,a.hash_shift=~~((a.hash_bits+No-1)/No),a.window=new ui.Buf8(2*a.w_size),a.head=new ui.Buf16(a.hash_size),a.prev=new ui.Buf16(a.w_size),a.lit_bufsize=1<<i+6,a.pending_buf_size=4*a.lit_bufsize,a.pending_buf=new ui.Buf8(a.pending_buf_size),a.d_buf=1*a.lit_bufsize,a.l_buf=3*a.lit_bufsize,a.level=t,a.strategy=o,a.method=r,vs(e)}co=[new ps(0,0,0,0,function(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(cs(e),0===e.lookahead&&t===go)return Xo;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((0===e.strstart||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,as(e,!1),0===e.strm.avail_out))return Xo;if(e.strstart-e.block_start>=e.w_size-Wo&&(as(e,!1),0===e.strm.avail_out))return Xo}return e.insert=0,t===yo?(as(e,!0),0===e.strm.avail_out?es:ts):(e.strstart>e.block_start&&(as(e,!1),e.strm.avail_out),Xo)}),new ps(4,4,8,4,fs),new ps(4,5,16,8,fs),new ps(4,6,32,32,fs),new ps(4,4,16,16,ds),new ps(8,16,32,32,ds),new ps(8,16,128,128,ds),new ps(8,32,128,256,ds),new ps(32,128,258,1024,ds),new ps(32,258,258,4096,ds)];var _s={deflateInit:function(e,t){return ys(e,t,Lo,Bo,Fo,Oo)},deflateInit2:ys,deflateReset:vs,deflateResetKeep:ms,deflateSetHeader:function(e,t){return e&&e.state?2!==e.state.wrap?ko:(e.state.gzhead=t,bo):ko},deflate:function(e,t){var r,n,i,o;if(!e||!e.state||t>_o||t<0)return e?ns(e,ko):ko;if(n=e.state,!e.output||!e.input&&0!==e.avail_in||n.status===Jo&&t!==yo)return ns(e,0===e.avail_out?xo:ko);if(n.strm=e,r=n.last_flush,n.last_flush=t,n.status===$o)if(2===n.wrap)e.adler=0,ls(n,31),ls(n,139),ls(n,8),n.gzhead?(ls(n,(n.gzhead.text?1:0)+(n.gzhead.hcrc?2:0)+(n.gzhead.extra?4:0)+(n.gzhead.name?8:0)+(n.gzhead.comment?16:0)),ls(n,255&n.gzhead.time),ls(n,n.gzhead.time>>8&255),ls(n,n.gzhead.time>>16&255),ls(n,n.gzhead.time>>24&255),ls(n,9===n.level?2:n.strategy>=Ao||n.level<2?4:0),ls(n,255&n.gzhead.os),n.gzhead.extra&&n.gzhead.extra.length&&(ls(n,255&n.gzhead.extra.length),ls(n,n.gzhead.extra.length>>8&255)),n.gzhead.hcrc&&(e.adler=fo(e.adler,n.pending_buf,n.pending,0)),n.gzindex=0,n.status=Yo):(ls(n,0),ls(n,0),ls(n,0),ls(n,0),ls(n,0),ls(n,9===n.level?2:n.strategy>=Ao||n.level<2?4:0),ls(n,rs),n.status=Ko);else{var s=Lo+(n.w_bits-8<<4)<<8;s|=(n.strategy>=Ao||n.level<2?0:n.level<6?1:6===n.level?2:3)<<6,0!==n.strstart&&(s|=qo),s+=31-s%31,n.status=Ko,us(n,s),0!==n.strstart&&(us(n,e.adler>>>16),us(n,65535&e.adler)),e.adler=1;}if(n.status===Yo)if(n.gzhead.extra){for(i=n.pending;n.gzindex<(65535&n.gzhead.extra.length)&&(n.pending!==n.pending_buf_size||(n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),ss(e),i=n.pending,n.pending!==n.pending_buf_size));)ls(n,255&n.gzhead.extra[n.gzindex]),n.gzindex++;n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),n.gzindex===n.gzhead.extra.length&&(n.gzindex=0,n.status=Vo);}else n.status=Vo;if(n.status===Vo)if(n.gzhead.name){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),ss(e),i=n.pending,n.pending===n.pending_buf_size)){o=1;break}o=n.gzindex<n.gzhead.name.length?255&n.gzhead.name.charCodeAt(n.gzindex++):0,ls(n,o);}while(0!==o);n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),0===o&&(n.gzindex=0,n.status=Ho);}else n.status=Ho;if(n.status===Ho)if(n.gzhead.comment){i=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),ss(e),i=n.pending,n.pending===n.pending_buf_size)){o=1;break}o=n.gzindex<n.gzhead.comment.length?255&n.gzhead.comment.charCodeAt(n.gzindex++):0,ls(n,o);}while(0!==o);n.gzhead.hcrc&&n.pending>i&&(e.adler=fo(e.adler,n.pending_buf,n.pending-i,i)),0===o&&(n.status=Go);}else n.status=Go;if(n.status===Go&&(n.gzhead.hcrc?(n.pending+2>n.pending_buf_size&&ss(e),n.pending+2<=n.pending_buf_size&&(ls(n,255&e.adler),ls(n,e.adler>>8&255),e.adler=0,n.status=Ko)):n.status=Ko),0!==n.pending){if(ss(e),0===e.avail_out)return n.last_flush=-1,bo}else if(0===e.avail_in&&is(t)<=is(r)&&t!==yo)return ns(e,xo);if(n.status===Jo&&0!==e.avail_in)return ns(e,xo);if(0!==e.avail_in||0!==n.lookahead||t!==go&&n.status!==Jo){var a=n.strategy===Ao?function(e,t){for(var r;;){if(0===e.lookahead&&(cs(e),0===e.lookahead)){if(t===go)return Xo;break}if(e.match_length=0,r=lo._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(as(e,!1),0===e.strm.avail_out))return Xo}return e.insert=0,t===yo?(as(e,!0),0===e.strm.avail_out?es:ts):e.last_lit&&(as(e,!1),0===e.strm.avail_out)?Xo:Qo}(n,t):n.strategy===To?function(e,t){for(var r,n,i,o,s=e.window;;){if(e.lookahead<=Zo){if(cs(e),e.lookahead<=Zo&&t===go)return Xo;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=No&&e.strstart>0&&(n=s[i=e.strstart-1])===s[++i]&&n===s[++i]&&n===s[++i]){o=e.strstart+Zo;do{}while(n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&i<o);e.match_length=Zo-(o-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead);}if(e.match_length>=No?(r=lo._tr_tally(e,1,e.match_length-No),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=lo._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(as(e,!1),0===e.strm.avail_out))return Xo}return e.insert=0,t===yo?(as(e,!0),0===e.strm.avail_out?es:ts):e.last_lit&&(as(e,!1),0===e.strm.avail_out)?Xo:Qo}(n,t):co[n.level].func(n,t);if(a!==es&&a!==ts||(n.status=Jo),a===Xo||a===es)return 0===e.avail_out&&(n.last_flush=-1),bo;if(a===Qo&&(t===mo?lo._tr_align(n):t!==_o&&(lo._tr_stored_block(n,0,0,!1),t===vo&&(os(n.head),0===n.lookahead&&(n.strstart=0,n.block_start=0,n.insert=0))),ss(e),0===e.avail_out))return n.last_flush=-1,bo}return t!==yo?bo:n.wrap<=0?wo:(2===n.wrap?(ls(n,255&e.adler),ls(n,e.adler>>8&255),ls(n,e.adler>>16&255),ls(n,e.adler>>24&255),ls(n,255&e.total_in),ls(n,e.total_in>>8&255),ls(n,e.total_in>>16&255),ls(n,e.total_in>>24&255)):(us(n,e.adler>>>16),us(n,65535&e.adler)),ss(e),n.wrap>0&&(n.wrap=-n.wrap),0!==n.pending?bo:wo)},deflateEnd:function(e){var t;return e&&e.state?(t=e.state.status)!==$o&&t!==Yo&&t!==Vo&&t!==Ho&&t!==Go&&t!==Ko&&t!==Jo?ns(e,ko):(e.state=null,t===Ko?ns(e,So):bo):ko},deflateSetDictionary:function(e,t){var r,n,i,o,s,a,l,u,h=t.length;if(!e||!e.state)return ko;if(2===(o=(r=e.state).wrap)||1===o&&r.status!==$o||r.lookahead)return ko;for(1===o&&(e.adler=uo(e.adler,t,h,0)),r.wrap=0,h>=r.w_size&&(0===o&&(os(r.head),r.strstart=0,r.block_start=0,r.insert=0),u=new ui.Buf8(r.w_size),ui.arraySet(u,t,h-r.w_size,r.w_size,0),t=u,h=r.w_size),s=e.avail_in,a=e.next_in,l=e.input,e.avail_in=h,e.next_in=0,e.input=t,cs(r);r.lookahead>=No;){n=r.strstart,i=r.lookahead-(No-1);do{r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+No-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++;}while(--i);r.strstart=n,r.lookahead=No-1,cs(r);}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=No-1,r.match_available=0,e.next_in=a,e.input=l,e.avail_in=s,r.wrap=o,bo},deflateInfo:"pako deflate (from Nodeca project)"},bs=!0,ws=!0;try{String.fromCharCode.apply(null,[0]);}catch(e){bs=!1;}try{String.fromCharCode.apply(null,new Uint8Array(1));}catch(e){ws=!1;}for(var ks=new ui.Buf8(256),Ss=0;Ss<256;Ss++)ks[Ss]=Ss>=252?6:Ss>=248?5:Ss>=240?4:Ss>=224?3:Ss>=192?2:1;ks[254]=ks[254]=1;function xs(e,t){if(t<65537&&(e.subarray&&ws||!e.subarray&&bs))return String.fromCharCode.apply(null,ui.shrinkBuf(e,t));for(var r="",n=0;n<t;n++)r+=String.fromCharCode(e[n]);return r}var Cs={string2buf:function(e){var t,r,n,i,o,s=e.length,a=0;for(i=0;i<s;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<s&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),a+=r<128?1:r<2048?2:r<65536?3:4;for(t=new ui.Buf8(a),o=0,i=0;o<a;i++)55296==(64512&(r=e.charCodeAt(i)))&&i+1<s&&56320==(64512&(n=e.charCodeAt(i+1)))&&(r=65536+(r-55296<<10)+(n-56320),i++),r<128?t[o++]=r:r<2048?(t[o++]=192|r>>>6,t[o++]=128|63&r):r<65536?(t[o++]=224|r>>>12,t[o++]=128|r>>>6&63,t[o++]=128|63&r):(t[o++]=240|r>>>18,t[o++]=128|r>>>12&63,t[o++]=128|r>>>6&63,t[o++]=128|63&r);return t},buf2binstring:function(e){return xs(e,e.length)},binstring2buf:function(e){for(var t=new ui.Buf8(e.length),r=0,n=t.length;r<n;r++)t[r]=e.charCodeAt(r);return t},buf2string:function(e,t){var r,n,i,o,s=t||e.length,a=new Array(2*s);for(n=0,r=0;r<s;)if((i=e[r++])<128)a[n++]=i;else if((o=ks[i])>4)a[n++]=65533,r+=o-1;else{for(i&=2===o?31:3===o?15:7;o>1&&r<s;)i=i<<6|63&e[r++],o--;o>1?a[n++]=65533:i<65536?a[n++]=i:(i-=65536,a[n++]=55296|i>>10&1023,a[n++]=56320|1023&i);}return xs(a,n)},utf8border:function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;r>=0&&128==(192&e[r]);)r--;return r<0?t:0===r?t:r+ks[e[r]]>t?r:t}};var Es=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0;},As=Object.prototype.toString,Ts=0,zs=-1,Os=0,Rs=8;function Ls(e){if(!(this instanceof Ls))return new Ls(e);this.options=ui.assign({level:zs,method:Rs,chunkSize:16384,windowBits:15,memLevel:8,strategy:Os,to:""},e||{});var t=this.options;t.raw&&t.windowBits>0?t.windowBits=-t.windowBits:t.gzip&&t.windowBits>0&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new Es,this.strm.avail_out=0;var r=_s.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(r!==Ts)throw new Error(po[r]);if(t.header&&_s.deflateSetHeader(this.strm,t.header),t.dictionary){var n;if(n="string"==typeof t.dictionary?Cs.string2buf(t.dictionary):"[object ArrayBuffer]"===As.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(r=_s.deflateSetDictionary(this.strm,n))!==Ts)throw new Error(po[r]);this._dict_set=!0;}}function Is(e,t){var r=new Ls(t);if(r.push(e,!0),r.err)throw r.msg||po[r.err];return r.result}Ls.prototype.push=function(e,t){var r,n,i=this.strm,o=this.options.chunkSize;if(this.ended)return !1;n=t===~~t?t:!0===t?4:0,"string"==typeof e?i.input=Cs.string2buf(e):"[object ArrayBuffer]"===As.call(e)?i.input=new Uint8Array(e):i.input=e,i.next_in=0,i.avail_in=i.input.length;do{if(0===i.avail_out&&(i.output=new ui.Buf8(o),i.next_out=0,i.avail_out=o),1!==(r=_s.deflate(i,n))&&r!==Ts)return this.onEnd(r),this.ended=!0,!1;0!==i.avail_out&&(0!==i.avail_in||4!==n&&2!==n)||("string"===this.options.to?this.onData(Cs.buf2binstring(ui.shrinkBuf(i.output,i.next_out))):this.onData(ui.shrinkBuf(i.output,i.next_out)));}while((i.avail_in>0||0===i.avail_out)&&1!==r);return 4===n?(r=_s.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===Ts):2!==n||(this.onEnd(Ts),i.avail_out=0,!0)},Ls.prototype.onData=function(e){this.chunks.push(e);},Ls.prototype.onEnd=function(e){e===Ts&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=ui.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg;};var Bs={Deflate:Ls,deflate:Is,deflateRaw:function(e,t){return (t=t||{}).raw=!0,Is(e,t)},gzip:function(e,t){return (t=t||{}).gzip=!0,Is(e,t)}},Fs=function(e,t){var r,n,i,o,s,a,l,u,h,c,f,d,p,g,m,v,y,_,b,w,k,S,x,C,E;r=e.state,n=e.next_in,C=e.input,i=n+(e.avail_in-5),o=e.next_out,E=e.output,s=o-(t-e.avail_out),a=o+(e.avail_out-257),l=r.dmax,u=r.wsize,h=r.whave,c=r.wnext,f=r.window,d=r.hold,p=r.bits,g=r.lencode,m=r.distcode,v=(1<<r.lenbits)-1,y=(1<<r.distbits)-1;e:do{p<15&&(d+=C[n++]<<p,p+=8,d+=C[n++]<<p,p+=8),_=g[d&v];t:for(;;){if(d>>>=b=_>>>24,p-=b,0===(b=_>>>16&255))E[o++]=65535&_;else{if(!(16&b)){if(0==(64&b)){_=g[(65535&_)+(d&(1<<b)-1)];continue t}if(32&b){r.mode=12;break e}e.msg="invalid literal/length code",r.mode=30;break e}w=65535&_,(b&=15)&&(p<b&&(d+=C[n++]<<p,p+=8),w+=d&(1<<b)-1,d>>>=b,p-=b),p<15&&(d+=C[n++]<<p,p+=8,d+=C[n++]<<p,p+=8),_=m[d&y];r:for(;;){if(d>>>=b=_>>>24,p-=b,!(16&(b=_>>>16&255))){if(0==(64&b)){_=m[(65535&_)+(d&(1<<b)-1)];continue r}e.msg="invalid distance code",r.mode=30;break e}if(k=65535&_,p<(b&=15)&&(d+=C[n++]<<p,(p+=8)<b&&(d+=C[n++]<<p,p+=8)),(k+=d&(1<<b)-1)>l){e.msg="invalid distance too far back",r.mode=30;break e}if(d>>>=b,p-=b,k>(b=o-s)){if((b=k-b)>h&&r.sane){e.msg="invalid distance too far back",r.mode=30;break e}if(S=0,x=f,0===c){if(S+=u-b,b<w){w-=b;do{E[o++]=f[S++];}while(--b);S=o-k,x=E;}}else if(c<b){if(S+=u+c-b,(b-=c)<w){w-=b;do{E[o++]=f[S++];}while(--b);if(S=0,c<w){w-=b=c;do{E[o++]=f[S++];}while(--b);S=o-k,x=E;}}}else if(S+=c-b,b<w){w-=b;do{E[o++]=f[S++];}while(--b);S=o-k,x=E;}for(;w>2;)E[o++]=x[S++],E[o++]=x[S++],E[o++]=x[S++],w-=3;w&&(E[o++]=x[S++],w>1&&(E[o++]=x[S++]));}else{S=o-k;do{E[o++]=E[S++],E[o++]=E[S++],E[o++]=E[S++],w-=3;}while(w>2);w&&(E[o++]=E[S++],w>1&&(E[o++]=E[S++]));}break}}break}}while(n<i&&o<a);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,e.next_in=n,e.next_out=o,e.avail_in=n<i?i-n+5:5-(n-i),e.avail_out=o<a?a-o+257:257-(o-a),r.hold=d,r.bits=p;},Ps=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],Ms=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],js=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],Us=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64],Ds=function(e,t,r,n,i,o,s,a){var l,u,h,c,f,d,p,g,m,v=a.bits,y=0,_=0,b=0,w=0,k=0,S=0,x=0,C=0,E=0,A=0,T=null,z=0,O=new ui.Buf16(16),R=new ui.Buf16(16),L=null,I=0;for(y=0;y<=15;y++)O[y]=0;for(_=0;_<n;_++)O[t[r+_]]++;for(k=v,w=15;w>=1&&0===O[w];w--);if(k>w&&(k=w),0===w)return i[o++]=20971520,i[o++]=20971520,a.bits=1,0;for(b=1;b<w&&0===O[b];b++);for(k<b&&(k=b),C=1,y=1;y<=15;y++)if(C<<=1,(C-=O[y])<0)return -1;if(C>0&&(0===e||1!==w))return -1;for(R[1]=0,y=1;y<15;y++)R[y+1]=R[y]+O[y];for(_=0;_<n;_++)0!==t[r+_]&&(s[R[t[r+_]]++]=_);if(0===e?(T=L=s,d=19):1===e?(T=Ps,z-=257,L=Ms,I-=257,d=256):(T=js,L=Us,d=-1),A=0,_=0,y=b,f=o,S=k,x=0,h=-1,c=(E=1<<k)-1,1===e&&E>852||2===e&&E>592)return 1;for(;;){p=y-x,s[_]<d?(g=0,m=s[_]):s[_]>d?(g=L[I+s[_]],m=T[z+s[_]]):(g=96,m=0),l=1<<y-x,b=u=1<<S;do{i[f+(A>>x)+(u-=l)]=p<<24|g<<16|m|0;}while(0!==u);for(l=1<<y-1;A&l;)l>>=1;if(0!==l?(A&=l-1,A+=l):A=0,_++,0==--O[y]){if(y===w)break;y=t[r+s[_]];}if(y>k&&(A&c)!==h){for(0===x&&(x=k),f+=b,C=1<<(S=y-x);S+x<w&&!((C-=O[S+x])<=0);)S++,C<<=1;if(E+=1<<S,1===e&&E>852||2===e&&E>592)return 1;i[h=A&c]=k<<24|S<<16|f-o|0;}}return 0!==A&&(i[f+A]=y-x<<24|64<<16|0),a.bits=k,0},Ns=0,Zs=1,Ws=2,qs=4,$s=5,Ys=6,Vs=0,Hs=1,Gs=2,Ks=-2,Js=-3,Xs=-4,Qs=-5,ea=8,ta=1,ra=2,na=3,ia=4,oa=5,sa=6,aa=7,la=8,ua=9,ha=10,ca=11,fa=12,da=13,pa=14,ga=15,ma=16,va=17,ya=18,_a=19,ba=20,wa=21,ka=22,Sa=23,xa=24,Ca=25,Ea=26,Aa=27,Ta=28,za=29,Oa=30,Ra=31,La=32,Ia=852,Ba=592,Fa=15;function Pa(e){return (e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function Ma(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new ui.Buf16(320),this.work=new ui.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0;}function ja(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=ta,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new ui.Buf32(Ia),t.distcode=t.distdyn=new ui.Buf32(Ba),t.sane=1,t.back=-1,Vs):Ks}function Ua(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,ja(e)):Ks}function Da(e,t){var r,n;return e&&e.state?(n=e.state,t<0?(r=0,t=-t):(r=1+(t>>4),t<48&&(t&=15)),t&&(t<8||t>15)?Ks:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=r,n.wbits=t,Ua(e))):Ks}function Na(e,t){var r,n;return e?(n=new Ma,e.state=n,n.window=null,(r=Da(e,t))!==Vs&&(e.state=null),r):Ks}var Za,Wa,qa=!0;function $a(e){if(qa){var t;for(Za=new ui.Buf32(512),Wa=new ui.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(Ds(Zs,e.lens,0,288,Za,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;Ds(Ws,e.lens,0,32,Wa,0,e.work,{bits:5}),qa=!1;}e.lencode=Za,e.lenbits=9,e.distcode=Wa,e.distbits=5;}function Ya(e,t,r,n){var i,o=e.state;return null===o.window&&(o.wsize=1<<o.wbits,o.wnext=0,o.whave=0,o.window=new ui.Buf8(o.wsize)),n>=o.wsize?(ui.arraySet(o.window,t,r-o.wsize,o.wsize,0),o.wnext=0,o.whave=o.wsize):((i=o.wsize-o.wnext)>n&&(i=n),ui.arraySet(o.window,t,r-n,i,o.wnext),(n-=i)?(ui.arraySet(o.window,t,r-n,n,0),o.wnext=n,o.whave=o.wsize):(o.wnext+=i,o.wnext===o.wsize&&(o.wnext=0),o.whave<o.wsize&&(o.whave+=i))),0}var Va={inflateReset:Ua,inflateReset2:Da,inflateResetKeep:ja,inflateInit:function(e){return Na(e,Fa)},inflateInit2:Na,inflate:function(e,t){var r,n,i,o,s,a,l,u,h,c,f,d,p,g,m,v,y,_,b,w,k,S,x,C,E=0,A=new ui.Buf8(4),T=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return Ks;(r=e.state).mode===fa&&(r.mode=da),s=e.next_out,i=e.output,l=e.avail_out,o=e.next_in,n=e.input,a=e.avail_in,u=r.hold,h=r.bits,c=a,f=l,S=Vs;e:for(;;)switch(r.mode){case ta:if(0===r.wrap){r.mode=da;break}for(;h<16;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(2&r.wrap&&35615===u){r.check=0,A[0]=255&u,A[1]=u>>>8&255,r.check=fo(r.check,A,2,0),u=0,h=0,r.mode=ra;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&u)<<8)+(u>>8))%31){e.msg="incorrect header check",r.mode=Oa;break}if((15&u)!==ea){e.msg="unknown compression method",r.mode=Oa;break}if(h-=4,k=8+(15&(u>>>=4)),0===r.wbits)r.wbits=k;else if(k>r.wbits){e.msg="invalid window size",r.mode=Oa;break}r.dmax=1<<k,e.adler=r.check=1,r.mode=512&u?ha:fa,u=0,h=0;break;case ra:for(;h<16;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(r.flags=u,(255&r.flags)!==ea){e.msg="unknown compression method",r.mode=Oa;break}if(57344&r.flags){e.msg="unknown header flags set",r.mode=Oa;break}r.head&&(r.head.text=u>>8&1),512&r.flags&&(A[0]=255&u,A[1]=u>>>8&255,r.check=fo(r.check,A,2,0)),u=0,h=0,r.mode=na;case na:for(;h<32;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.head&&(r.head.time=u),512&r.flags&&(A[0]=255&u,A[1]=u>>>8&255,A[2]=u>>>16&255,A[3]=u>>>24&255,r.check=fo(r.check,A,4,0)),u=0,h=0,r.mode=ia;case ia:for(;h<16;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.head&&(r.head.xflags=255&u,r.head.os=u>>8),512&r.flags&&(A[0]=255&u,A[1]=u>>>8&255,r.check=fo(r.check,A,2,0)),u=0,h=0,r.mode=oa;case oa:if(1024&r.flags){for(;h<16;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.length=u,r.head&&(r.head.extra_len=u),512&r.flags&&(A[0]=255&u,A[1]=u>>>8&255,r.check=fo(r.check,A,2,0)),u=0,h=0;}else r.head&&(r.head.extra=null);r.mode=sa;case sa:if(1024&r.flags&&((d=r.length)>a&&(d=a),d&&(r.head&&(k=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),ui.arraySet(r.head.extra,n,o,d,k)),512&r.flags&&(r.check=fo(r.check,n,d,o)),a-=d,o+=d,r.length-=d),r.length))break e;r.length=0,r.mode=aa;case aa:if(2048&r.flags){if(0===a)break e;d=0;do{k=n[o+d++],r.head&&k&&r.length<65536&&(r.head.name+=String.fromCharCode(k));}while(k&&d<a);if(512&r.flags&&(r.check=fo(r.check,n,d,o)),a-=d,o+=d,k)break e}else r.head&&(r.head.name=null);r.length=0,r.mode=la;case la:if(4096&r.flags){if(0===a)break e;d=0;do{k=n[o+d++],r.head&&k&&r.length<65536&&(r.head.comment+=String.fromCharCode(k));}while(k&&d<a);if(512&r.flags&&(r.check=fo(r.check,n,d,o)),a-=d,o+=d,k)break e}else r.head&&(r.head.comment=null);r.mode=ua;case ua:if(512&r.flags){for(;h<16;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(u!==(65535&r.check)){e.msg="header crc mismatch",r.mode=Oa;break}u=0,h=0;}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),e.adler=r.check=0,r.mode=fa;break;case ha:for(;h<32;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}e.adler=r.check=Pa(u),u=0,h=0,r.mode=ca;case ca:if(0===r.havedict)return e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=a,r.hold=u,r.bits=h,Gs;e.adler=r.check=1,r.mode=fa;case fa:if(t===$s||t===Ys)break e;case da:if(r.last){u>>>=7&h,h-=7&h,r.mode=Aa;break}for(;h<3;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}switch(r.last=1&u,h-=1,3&(u>>>=1)){case 0:r.mode=pa;break;case 1:if($a(r),r.mode=ba,t===Ys){u>>>=2,h-=2;break e}break;case 2:r.mode=va;break;case 3:e.msg="invalid block type",r.mode=Oa;}u>>>=2,h-=2;break;case pa:for(u>>>=7&h,h-=7&h;h<32;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if((65535&u)!=(u>>>16^65535)){e.msg="invalid stored block lengths",r.mode=Oa;break}if(r.length=65535&u,u=0,h=0,r.mode=ga,t===Ys)break e;case ga:r.mode=ma;case ma:if(d=r.length){if(d>a&&(d=a),d>l&&(d=l),0===d)break e;ui.arraySet(i,n,o,d,s),a-=d,o+=d,l-=d,s+=d,r.length-=d;break}r.mode=fa;break;case va:for(;h<14;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(r.nlen=257+(31&u),u>>>=5,h-=5,r.ndist=1+(31&u),u>>>=5,h-=5,r.ncode=4+(15&u),u>>>=4,h-=4,r.nlen>286||r.ndist>30){e.msg="too many length or distance symbols",r.mode=Oa;break}r.have=0,r.mode=ya;case ya:for(;r.have<r.ncode;){for(;h<3;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.lens[T[r.have++]]=7&u,u>>>=3,h-=3;}for(;r.have<19;)r.lens[T[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,x={bits:r.lenbits},S=Ds(Ns,r.lens,0,19,r.lencode,0,r.work,x),r.lenbits=x.bits,S){e.msg="invalid code lengths set",r.mode=Oa;break}r.have=0,r.mode=_a;case _a:for(;r.have<r.nlen+r.ndist;){for(;v=(E=r.lencode[u&(1<<r.lenbits)-1])>>>16&255,y=65535&E,!((m=E>>>24)<=h);){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(y<16)u>>>=m,h-=m,r.lens[r.have++]=y;else{if(16===y){for(C=m+2;h<C;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(u>>>=m,h-=m,0===r.have){e.msg="invalid bit length repeat",r.mode=Oa;break}k=r.lens[r.have-1],d=3+(3&u),u>>>=2,h-=2;}else if(17===y){for(C=m+3;h<C;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}h-=m,k=0,d=3+(7&(u>>>=m)),u>>>=3,h-=3;}else{for(C=m+7;h<C;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}h-=m,k=0,d=11+(127&(u>>>=m)),u>>>=7,h-=7;}if(r.have+d>r.nlen+r.ndist){e.msg="invalid bit length repeat",r.mode=Oa;break}for(;d--;)r.lens[r.have++]=k;}}if(r.mode===Oa)break;if(0===r.lens[256]){e.msg="invalid code -- missing end-of-block",r.mode=Oa;break}if(r.lenbits=9,x={bits:r.lenbits},S=Ds(Zs,r.lens,0,r.nlen,r.lencode,0,r.work,x),r.lenbits=x.bits,S){e.msg="invalid literal/lengths set",r.mode=Oa;break}if(r.distbits=6,r.distcode=r.distdyn,x={bits:r.distbits},S=Ds(Ws,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,x),r.distbits=x.bits,S){e.msg="invalid distances set",r.mode=Oa;break}if(r.mode=ba,t===Ys)break e;case ba:r.mode=wa;case wa:if(a>=6&&l>=258){e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=a,r.hold=u,r.bits=h,Fs(e,f),s=e.next_out,i=e.output,l=e.avail_out,o=e.next_in,n=e.input,a=e.avail_in,u=r.hold,h=r.bits,r.mode===fa&&(r.back=-1);break}for(r.back=0;v=(E=r.lencode[u&(1<<r.lenbits)-1])>>>16&255,y=65535&E,!((m=E>>>24)<=h);){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(v&&0==(240&v)){for(_=m,b=v,w=y;v=(E=r.lencode[w+((u&(1<<_+b)-1)>>_)])>>>16&255,y=65535&E,!(_+(m=E>>>24)<=h);){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}u>>>=_,h-=_,r.back+=_;}if(u>>>=m,h-=m,r.back+=m,r.length=y,0===v){r.mode=Ea;break}if(32&v){r.back=-1,r.mode=fa;break}if(64&v){e.msg="invalid literal/length code",r.mode=Oa;break}r.extra=15&v,r.mode=ka;case ka:if(r.extra){for(C=r.extra;h<C;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.length+=u&(1<<r.extra)-1,u>>>=r.extra,h-=r.extra,r.back+=r.extra;}r.was=r.length,r.mode=Sa;case Sa:for(;v=(E=r.distcode[u&(1<<r.distbits)-1])>>>16&255,y=65535&E,!((m=E>>>24)<=h);){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(0==(240&v)){for(_=m,b=v,w=y;v=(E=r.distcode[w+((u&(1<<_+b)-1)>>_)])>>>16&255,y=65535&E,!(_+(m=E>>>24)<=h);){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}u>>>=_,h-=_,r.back+=_;}if(u>>>=m,h-=m,r.back+=m,64&v){e.msg="invalid distance code",r.mode=Oa;break}r.offset=y,r.extra=15&v,r.mode=xa;case xa:if(r.extra){for(C=r.extra;h<C;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}r.offset+=u&(1<<r.extra)-1,u>>>=r.extra,h-=r.extra,r.back+=r.extra;}if(r.offset>r.dmax){e.msg="invalid distance too far back",r.mode=Oa;break}r.mode=Ca;case Ca:if(0===l)break e;if(d=f-l,r.offset>d){if((d=r.offset-d)>r.whave&&r.sane){e.msg="invalid distance too far back",r.mode=Oa;break}d>r.wnext?(d-=r.wnext,p=r.wsize-d):p=r.wnext-d,d>r.length&&(d=r.length),g=r.window;}else g=i,p=s-r.offset,d=r.length;d>l&&(d=l),l-=d,r.length-=d;do{i[s++]=g[p++];}while(--d);0===r.length&&(r.mode=wa);break;case Ea:if(0===l)break e;i[s++]=r.length,l--,r.mode=wa;break;case Aa:if(r.wrap){for(;h<32;){if(0===a)break e;a--,u|=n[o++]<<h,h+=8;}if(f-=l,e.total_out+=f,r.total+=f,f&&(e.adler=r.check=r.flags?fo(r.check,i,f,s-f):uo(r.check,i,f,s-f)),f=l,(r.flags?u:Pa(u))!==r.check){e.msg="incorrect data check",r.mode=Oa;break}u=0,h=0;}r.mode=Ta;case Ta:if(r.wrap&&r.flags){for(;h<32;){if(0===a)break e;a--,u+=n[o++]<<h,h+=8;}if(u!==(4294967295&r.total)){e.msg="incorrect length check",r.mode=Oa;break}u=0,h=0;}r.mode=za;case za:S=Hs;break e;case Oa:S=Js;break e;case Ra:return Xs;case La:default:return Ks}return e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=a,r.hold=u,r.bits=h,(r.wsize||f!==e.avail_out&&r.mode<Oa&&(r.mode<Aa||t!==qs))&&Ya(e,e.output,e.next_out,f-e.avail_out),c-=e.avail_in,f-=e.avail_out,e.total_in+=c,e.total_out+=f,r.total+=f,r.wrap&&f&&(e.adler=r.check=r.flags?fo(r.check,i,f,e.next_out-f):uo(r.check,i,f,e.next_out-f)),e.data_type=r.bits+(r.last?64:0)+(r.mode===fa?128:0)+(r.mode===ba||r.mode===ga?256:0),(0===c&&0===f||t===qs)&&S===Vs&&(S=Qs),S},inflateEnd:function(e){if(!e||!e.state)return Ks;var t=e.state;return t.window&&(t.window=null),e.state=null,Vs},inflateGetHeader:function(e,t){var r;return e&&e.state?0==(2&(r=e.state).wrap)?Ks:(r.head=t,t.done=!1,Vs):Ks},inflateSetDictionary:function(e,t){var r,n=t.length;return e&&e.state?0!==(r=e.state).wrap&&r.mode!==ca?Ks:r.mode===ca&&uo(1,t,n,0)!==r.check?Js:Ya(e,t,n,n)?(r.mode=Ra,Xs):(r.havedict=1,Vs):Ks},inflateInfo:"pako inflate (from Nodeca project)"},Ha={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8};var Ga=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1;},Ka=Object.prototype.toString;function Ja(e){if(!(this instanceof Ja))return new Ja(e);this.options=ui.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&t.windowBits>=0&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(t.windowBits>=0&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),t.windowBits>15&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new Es,this.strm.avail_out=0;var r=Va.inflateInit2(this.strm,t.windowBits);if(r!==Ha.Z_OK)throw new Error(po[r]);this.header=new Ga,Va.inflateGetHeader(this.strm,this.header);}function Xa(e,t){var r=new Ja(t);if(r.push(e,!0),r.err)throw r.msg||po[r.err];return r.result}Ja.prototype.push=function(e,t){var r,n,i,o,s,a,l=this.strm,u=this.options.chunkSize,h=this.options.dictionary,c=!1;if(this.ended)return !1;n=t===~~t?t:!0===t?Ha.Z_FINISH:Ha.Z_NO_FLUSH,"string"==typeof e?l.input=Cs.binstring2buf(e):"[object ArrayBuffer]"===Ka.call(e)?l.input=new Uint8Array(e):l.input=e,l.next_in=0,l.avail_in=l.input.length;do{if(0===l.avail_out&&(l.output=new ui.Buf8(u),l.next_out=0,l.avail_out=u),(r=Va.inflate(l,Ha.Z_NO_FLUSH))===Ha.Z_NEED_DICT&&h&&(a="string"==typeof h?Cs.string2buf(h):"[object ArrayBuffer]"===Ka.call(h)?new Uint8Array(h):h,r=Va.inflateSetDictionary(this.strm,a)),r===Ha.Z_BUF_ERROR&&!0===c&&(r=Ha.Z_OK,c=!1),r!==Ha.Z_STREAM_END&&r!==Ha.Z_OK)return this.onEnd(r),this.ended=!0,!1;l.next_out&&(0!==l.avail_out&&r!==Ha.Z_STREAM_END&&(0!==l.avail_in||n!==Ha.Z_FINISH&&n!==Ha.Z_SYNC_FLUSH)||("string"===this.options.to?(i=Cs.utf8border(l.output,l.next_out),o=l.next_out-i,s=Cs.buf2string(l.output,i),l.next_out=o,l.avail_out=u-o,o&&ui.arraySet(l.output,l.output,i,o,0),this.onData(s)):this.onData(ui.shrinkBuf(l.output,l.next_out)))),0===l.avail_in&&0===l.avail_out&&(c=!0);}while((l.avail_in>0||0===l.avail_out)&&r!==Ha.Z_STREAM_END);return r===Ha.Z_STREAM_END&&(n=Ha.Z_FINISH),n===Ha.Z_FINISH?(r=Va.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===Ha.Z_OK):n!==Ha.Z_SYNC_FLUSH||(this.onEnd(Ha.Z_OK),l.avail_out=0,!0)},Ja.prototype.onData=function(e){this.chunks.push(e);},Ja.prototype.onEnd=function(e){e===Ha.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=ui.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg;};var Qa={Inflate:Ja,inflate:Xa,inflateRaw:function(e,t){return (t=t||{}).raw=!0,Xa(e,t)},ungzip:Xa},el={};(0,ui.assign)(el,Bs,Qa,Ha);var tl=el,rl="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array?"uint8array":"array";function nl(e,t){Pn.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={};}Bn.inherits(nl,Pn),nl.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(Bn.transformTo(rl,e.data),!1);},nl.prototype.flush=function(){Pn.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0);},nl.prototype.cleanUp=function(){Pn.prototype.cleanUp.call(this),this._pako=null;},nl.prototype._createPako=function(){this._pako=new tl[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta});};};var il={STORE:{magic:"\0\0",compressWorker:function(e){return new Pn("STORE compression")},uncompressWorker:function(){return new Pn("STORE decompression")}},DEFLATE:{magic:"\b\0",compressWorker:function(e){return new nl("Deflate",e)},uncompressWorker:function(){return new nl("Inflate",{})}}},ol="PK",sl="PK",al="PK",ll="PK",ul="PK",hl="PK\b",cl=function(e,t){var r,n="";for(r=0;r<t;r++)n+=String.fromCharCode(255&e),e>>>=8;return n},fl=function(e,t,r,n,i,o){var s,a,l=e.file,u=e.compression,h=o!==Mn.utf8encode,c=Bn.transformTo("string",o(l.name)),f=Bn.transformTo("string",Mn.utf8encode(l.name)),d=l.comment,p=Bn.transformTo("string",o(d)),g=Bn.transformTo("string",Mn.utf8encode(d)),m=f.length!==l.name.length,v=g.length!==d.length,y="",_="",b="",w=l.dir,k=l.date,S={crc32:0,compressedSize:0,uncompressedSize:0};t&&!r||(S.crc32=e.crc32,S.compressedSize=e.compressedSize,S.uncompressedSize=e.uncompressedSize);var x=0;t&&(x|=8),h||!m&&!v||(x|=2048);var C,E,A,T=0,z=0;w&&(T|=16),"UNIX"===i?(z=798,T|=(C=l.unixPermissions,E=w,A=C,C||(A=E?16893:33204),(65535&A)<<16)):(z=20,T|=63&(l.dosPermissions||0)),s=k.getUTCHours(),s<<=6,s|=k.getUTCMinutes(),s<<=5,s|=k.getUTCSeconds()/2,a=k.getUTCFullYear()-1980,a<<=4,a|=k.getUTCMonth()+1,a<<=5,a|=k.getUTCDate(),m&&(_=cl(1,1)+cl(Qn(c),4)+f,y+="up"+cl(_.length,2)+_),v&&(b=cl(1,1)+cl(Qn(p),4)+g,y+="uc"+cl(b.length,2)+b);var O="";return O+="\n\0",O+=cl(x,2),O+=u.magic,O+=cl(s,2),O+=cl(a,2),O+=cl(S.crc32,4),O+=cl(S.compressedSize,4),O+=cl(S.uncompressedSize,4),O+=cl(c.length,2),O+=cl(y.length,2),{fileRecord:ol+O+c+y,dirRecord:sl+cl(z,2)+O+cl(p.length,2)+"\0\0\0\0"+cl(T,4)+cl(n,4)+c+y+p}},dl=function(e){return hl+cl(e.crc32,4)+cl(e.compressedSize,4)+cl(e.uncompressedSize,4)};function pl(e,t,r,n){Pn.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[];}Bn.inherits(pl,Pn),pl.prototype.push=function(e){var t=e.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,Pn.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:r?(t+100*(r-n-1))/r:100}}));},pl.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var r=fl(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}});}else this.accumulate=!0;},pl.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,r=fl(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),t)this.push({data:dl(e),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null;},pl.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var r=this.bytesWritten-e,n=function(e,t,r,n,i){var o=Bn.transformTo("string",i(n));return al+"\0\0\0\0"+cl(e,2)+cl(e,2)+cl(t,4)+cl(r,4)+cl(o.length,2)+o}(this.dirRecords.length,r,e,this.zipComment,this.encodeFileName);this.push({data:n,meta:{percent:100}});},pl.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume();},pl.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",function(e){t.processChunk(e);}),e.on("end",function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end();}),e.on("error",function(e){t.error(e);}),this},pl.prototype.resume=function(){return !!Pn.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},pl.prototype.error=function(e){var t=this._sources;if(!Pn.prototype.error.call(this,e))return !1;for(var r=0;r<t.length;r++)try{t[r].error(e);}catch(e){}return !0},pl.prototype.lock=function(){Pn.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock();};var gl=pl,ml=function(e,t,r){var n=new gl(t.streamFiles,r,t.platform,t.encodeFileName),i=0;try{e.forEach(function(e,r){i++;var o=function(e,t){var r=e||t,n=il[r];if(!n)throw new Error(r+" is not a valid compression method !");return n}(r.options.compression,t.compression),s=r.options.compressionOptions||t.compressionOptions||{},a=r.dir,l=r.date;r._compressWorker(o,s).withStreamInfo("file",{name:e,dir:a,date:l,comment:r.comment||"",unixPermissions:r.unixPermissions,dosPermissions:r.dosPermissions}).pipe(n);}),n.entriesCount=i;}catch(e){n.error(e);}return n};function vl(e,t){Pn.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t);}Bn.inherits(vl,Pn),vl.prototype._bindStream=function(e){var t=this;this._stream=e,e.pause(),e.on("data",function(e){t.push({data:e,meta:{percent:0}});}).on("error",function(e){t.isPaused?this.generatedError=e:t.error(e);}).on("end",function(){t.isPaused?t._upstreamEnded=!0:t.end();});},vl.prototype.pause=function(){return !!Pn.prototype.pause.call(this)&&(this._stream.pause(),!0)},vl.prototype.resume=function(){return !!Pn.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)};var yl=vl,_l=function(e,t,r){var n,i=Bn.getTypeOf(t),o=Bn.extend(r||{},Vn);o.date=o.date||new Date,null!==o.compression&&(o.compression=o.compression.toUpperCase()),"string"==typeof o.unixPermissions&&(o.unixPermissions=parseInt(o.unixPermissions,8)),o.unixPermissions&&16384&o.unixPermissions&&(o.dir=!0),o.dosPermissions&&16&o.dosPermissions&&(o.dir=!0),o.dir&&(e=wl(e)),o.createFolders&&(n=bl(e))&&kl.call(this,n,!0);var s="string"===i&&!1===o.binary&&!1===o.base64;r&&void 0!==r.binary||(o.binary=!s),(t instanceof ni&&0===t.uncompressedSize||o.dir||!t||0===t.length)&&(o.base64=!1,o.binary=!0,t="",o.compression="STORE",i="string");var a=null;a=t instanceof ni||t instanceof Pn?t:Ar&&Rr(t)?new yl(e,t):Bn.prepareContent(e,t,o.binary,o.optimizedBinaryString,o.base64);var l=new li(e,a,o);this.files[e]=l;},bl=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return t>0?e.substring(0,t):""},wl=function(e){return "/"!==e.slice(-1)&&(e+="/"),e},kl=function(e,t){return t=void 0!==t?t:Vn.createFolders,e=wl(e),this.files[e]||_l.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function Sl(e){return "[object RegExp]"===Object.prototype.toString.call(e)}var xl={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,r,n;for(t in this.files)this.files.hasOwnProperty(t)&&(n=this.files[t],(r=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(r,n));},filter:function(e){var t=[];return this.forEach(function(r,n){e(r,n)&&t.push(n);}),t},file:function(e,t,r){if(1===arguments.length){if(Sl(e)){var n=e;return this.filter(function(e,t){return !t.dir&&n.test(e)})}var i=this.files[this.root+e];return i&&!i.dir?i:null}return e=this.root+e,_l.call(this,e,t,r),this},folder:function(e){if(!e)return this;if(Sl(e))return this.filter(function(t,r){return r.dir&&e.test(t)});var t=this.root+e,r=kl.call(this,t),n=this.clone();return n.root=r.name,n},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var r=this.filter(function(t,r){return r.name.slice(0,e.length)===e}),n=0;n<r.length;n++)delete this.files[r[n].name];return this},generate:function(e){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,r={};try{if((r=Bn.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:Mn.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");Bn.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";t=ml(this,r,n);}catch(e){(t=new Pn("error")).error(e);}return new Yn(t,r.type||"string",r.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return (e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};function Cl(e){this.data=e,this.length=e.length,this.index=0,this.zero=0;}Cl.prototype={checkOffset:function(e){this.checkIndex(this.index+e);},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e;},skip:function(e){this.setIndex(this.index+e);},byteAt:function(e){},readInt:function(e){var t,r=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)r=(r<<8)+this.byteAt(t);return this.index+=e,r},readString:function(e){return Bn.transformTo("string",this.readData(e))},readData:function(e){},lastIndexOfSignature:function(e){},readAndCheckSignature:function(e){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}};var El=Cl;function Al(e){El.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t];}Bn.inherits(Al,El),Al.prototype.byteAt=function(e){return this.data[this.zero+e]},Al.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),o=this.length-4;o>=0;--o)if(this.data[o]===t&&this.data[o+1]===r&&this.data[o+2]===n&&this.data[o+3]===i)return o-this.zero;return -1},Al.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),o=this.readData(4);return t===o[0]&&r===o[1]&&n===o[2]&&i===o[3]},Al.prototype.readData=function(e){if(this.checkOffset(e),0===e)return [];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t};var Tl=Al;function zl(e){El.call(this,e);}Bn.inherits(zl,El),zl.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},zl.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},zl.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},zl.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t};var Ol=zl;function Rl(e){Tl.call(this,e);}Bn.inherits(Rl,Tl),Rl.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t};var Ll=Rl;function Il(e){Ll.call(this,e);}Bn.inherits(Il,Ll),Il.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t};var Bl=Il,Fl=function(e){var t=Bn.getTypeOf(e);return Bn.checkSupport(t),"string"!==t||xr.uint8array?"nodebuffer"===t?new Bl(e):xr.uint8array?new Ll(Bn.transformTo("uint8array",e)):new Tl(Bn.transformTo("array",e)):new Ol(e)};function Pl(e,t){this.options=e,this.loadOptions=t;}Pl.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,r;if(e.skip(22),this.fileNameLength=e.readInt(2),r=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in il)if(il.hasOwnProperty(t)&&il[t].magic===e)return il[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+Bn.pretty(this.compressionMethod)+" unknown (inner file : "+Bn.transformTo("string",this.fileName)+")");this.decompressed=new ni(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize));},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength);},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0===e&&(this.dosPermissions=63&this.externalFileAttributes),3===e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0);},parseZIP64ExtraField:function(e){if(this.extraFields[1]){var t=Fl(this.extraFields[1].value);this.uncompressedSize===Bn.MAX_VALUE_32BITS&&(this.uncompressedSize=t.readInt(8)),this.compressedSize===Bn.MAX_VALUE_32BITS&&(this.compressedSize=t.readInt(8)),this.localHeaderOffset===Bn.MAX_VALUE_32BITS&&(this.localHeaderOffset=t.readInt(8)),this.diskNumberStart===Bn.MAX_VALUE_32BITS&&(this.diskNumberStart=t.readInt(4));}},readExtraFields:function(e){var t,r,n,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index<i;)t=e.readInt(2),r=e.readInt(2),n=e.readData(r),this.extraFields[t]={id:t,length:r,value:n};},handleUTF8:function(){var e=xr.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=Mn.utf8decode(this.fileName),this.fileCommentStr=Mn.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var r=Bn.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r);}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else{var i=Bn.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(i);}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=Fl(e.value);return 1!==t.readInt(1)?null:Qn(this.fileName)!==t.readInt(4)?null:Mn.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=Fl(e.value);return 1!==t.readInt(1)?null:Qn(this.fileComment)!==t.readInt(4)?null:Mn.utf8decode(t.readData(e.length-5))}return null}};var Ml=Pl;function jl(e){this.files=[],this.loadOptions=e;}jl.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+Bn.pretty(t)+", expected "+Bn.pretty(e)+")")}},isSignature:function(e,t){var r=this.reader.index;this.reader.setIndex(e);var n=this.reader.readString(4)===t;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=xr.uint8array?"uint8array":"array",r=Bn.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(r);},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,r,n=this.zip64EndOfCentralSize-44;0<n;)e=this.reader.readInt(2),t=this.reader.readInt(4),r=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:r};},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),this.disksCount>1)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(ol),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes();},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(sl);)(e=new Ml({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(al);if(e<0)throw!this.isSignature(0,ol)?new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html"):new Error("Corrupted zip: can't find end of central directory");this.reader.setIndex(e);var t=e;if(this.checkSignature(al),this.readBlockEndOfCentral(),this.diskNumber===Bn.MAX_VALUE_16BITS||this.diskWithCentralDirStart===Bn.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===Bn.MAX_VALUE_16BITS||this.centralDirRecords===Bn.MAX_VALUE_16BITS||this.centralDirSize===Bn.MAX_VALUE_32BITS||this.centralDirOffset===Bn.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(ll))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(ll),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,ul)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(ul),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(ul),this.readBlockZip64EndOfCentral();}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=t-r;if(n>0)this.isSignature(t,sl)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(e){this.reader=Fl(e);},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles();}};var Ul=jl;function Dl(e){return new In.Promise(function(t,r){var n=e.decompressed.getContentWorker().pipe(new ti);n.on("error",function(e){r(e);}).on("end",function(){n.streamInfo.crc32!==e.decompressed.crc32?r(new Error("Corrupted zip : CRC32 mismatch")):t();}).resume();})}function Nl(){if(!(this instanceof Nl))return new Nl;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files={},this.comment=null,this.root="",this.clone=function(){var e=new Nl;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e};}Nl.prototype=xl,Nl.prototype.loadAsync=function(e,t){var r=this;return t=Bn.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:Mn.utf8decode}),Ar&&Rr(e)?In.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):Bn.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then(function(e){var r=new Ul(t);return r.load(e),r}).then(function(e){var r=[In.Promise.resolve(e)],n=e.files;if(t.checkCRC32)for(var i=0;i<n.length;i++)r.push(Dl(n[i]));return In.Promise.all(r)}).then(function(e){for(var n=e.shift(),i=n.files,o=0;o<i.length;o++){var s=i[o];r.file(s.fileNameStr,s.decompressed,{binary:!0,optimizedBinaryString:!0,date:s.date,dir:s.dir,comment:s.fileCommentStr.length?s.fileCommentStr:null,unixPermissions:s.unixPermissions,dosPermissions:s.dosPermissions,createFolders:t.createFolders});}return n.zipComment.length&&(r.comment=n.zipComment),r})},Nl.support=xr,Nl.defaults=Vn,Nl.version="3.1.5",Nl.loadAsync=function(e,t){return (new Nl).loadAsync(e,t)},Nl.external=In;var Zl=Nl;function Wl(e){return null==e}var ql={isNothing:Wl,isObject:function(e){return "object"==typeof e&&null!==e},toArray:function(e){return Array.isArray(e)?e:Wl(e)?[]:[e]},repeat:function(e,t){var r,n="";for(r=0;r<t;r+=1)n+=e;return n},isNegativeZero:function(e){return 0===e&&Number.NEGATIVE_INFINITY===1/e},extend:function(e,t){var r,n,i,o;if(t)for(r=0,n=(o=Object.keys(t)).length;r<n;r+=1)e[i=o[r]]=t[i];return e}};function $l(e,t){Error.call(this),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack||"",this.name="YAMLException",this.reason=e,this.mark=t,this.message=(this.reason||"(unknown reason)")+(this.mark?" "+this.mark.toString():"");}$l.prototype=Object.create(Error.prototype),$l.prototype.constructor=$l,$l.prototype.toString=function(e){var t=this.name+": ";return t+=this.reason||"(unknown reason)",!e&&this.mark&&(t+=" "+this.mark.toString()),t};var Yl=$l;function Vl(e,t,r,n,i){this.name=e,this.buffer=t,this.position=r,this.line=n,this.column=i;}Vl.prototype.getSnippet=function(e,t){var r,n,i,o,s;if(!this.buffer)return null;for(e=e||4,t=t||75,r="",n=this.position;n>0&&-1==="\0\r\n\u2028\u2029".indexOf(this.buffer.charAt(n-1));)if(n-=1,this.position-n>t/2-1){r=" ... ",n+=5;break}for(i="",o=this.position;o<this.buffer.length&&-1==="\0\r\n\u2028\u2029".indexOf(this.buffer.charAt(o));)if((o+=1)-this.position>t/2-1){i=" ... ",o-=5;break}return s=this.buffer.slice(n,o),ql.repeat(" ",e)+r+s+i+"\n"+ql.repeat(" ",e+this.position-n+r.length)+"^"},Vl.prototype.toString=function(e){var t,r="";return this.name&&(r+='in "'+this.name+'" '),r+="at line "+(this.line+1)+", column "+(this.column+1),e||(t=this.getSnippet())&&(r+=":\n"+t),r};var Hl=Vl,Gl=["kind","resolve","construct","instanceOf","predicate","represent","defaultStyle","styleAliases"],Kl=["scalar","sequence","mapping"];var Jl=function(e,t){var r,n;if(t=t||{},Object.keys(t).forEach(function(t){if(-1===Gl.indexOf(t))throw new Yl('Unknown option "'+t+'" is met in definition of "'+e+'" YAML type.')}),this.tag=e,this.kind=t.kind||null,this.resolve=t.resolve||function(){return !0},this.construct=t.construct||function(e){return e},this.instanceOf=t.instanceOf||null,this.predicate=t.predicate||null,this.represent=t.represent||null,this.defaultStyle=t.defaultStyle||null,this.styleAliases=(r=t.styleAliases||null,n={},null!==r&&Object.keys(r).forEach(function(e){r[e].forEach(function(t){n[String(t)]=e;});}),n),-1===Kl.indexOf(this.kind))throw new Yl('Unknown kind "'+this.kind+'" is specified for "'+e+'" YAML type.')};function Xl(e,t,r){var n=[];return e.include.forEach(function(e){r=Xl(e,t,r);}),e[t].forEach(function(e){r.forEach(function(t,r){t.tag===e.tag&&n.push(r);}),r.push(e);}),r.filter(function(e,t){return -1===n.indexOf(t)})}function Ql(e){this.include=e.include||[],this.implicit=e.implicit||[],this.explicit=e.explicit||[],this.implicit.forEach(function(e){if(e.loadKind&&"scalar"!==e.loadKind)throw new Yl("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.")}),this.compiledImplicit=Xl(this,"implicit",[]),this.compiledExplicit=Xl(this,"explicit",[]),this.compiledTypeMap=function(){var e,t,r={};function n(e){r[e.tag]=e;}for(e=0,t=arguments.length;e<t;e+=1)arguments[e].forEach(n);return r}(this.compiledImplicit,this.compiledExplicit);}Ql.DEFAULT=null,Ql.create=function(){var e,t;switch(arguments.length){case 1:e=Ql.DEFAULT,t=arguments[0];break;case 2:e=arguments[0],t=arguments[1];break;default:throw new Yl("Wrong number of arguments for Schema.create function")}if(e=ql.toArray(e),t=ql.toArray(t),!e.every(function(e){return e instanceof Ql}))throw new Yl("Specified list of super schemas (or a single Schema object) contains a non-Schema object.");if(!t.every(function(e){return e instanceof Jl}))throw new Yl("Specified list of YAML types (or a single Type object) contains a non-Type object.");return new Ql({include:e,explicit:t})};var eu=Ql,tu=new eu({explicit:[new Jl("tag:yaml.org,2002:str",{kind:"scalar",construct:function(e){return null!==e?e:""}}),new Jl("tag:yaml.org,2002:seq",{kind:"sequence",construct:function(e){return null!==e?e:[]}}),new Jl("tag:yaml.org,2002:map",{kind:"mapping",construct:function(e){return null!==e?e:{}}})]});var ru=new Jl("tag:yaml.org,2002:null",{kind:"scalar",resolve:function(e){if(null===e)return !0;var t=e.length;return 1===t&&"~"===e||4===t&&("null"===e||"Null"===e||"NULL"===e)},construct:function(){return null},predicate:function(e){return null===e},represent:{canonical:function(){return "~"},lowercase:function(){return "null"},uppercase:function(){return "NULL"},camelcase:function(){return "Null"}},defaultStyle:"lowercase"});var nu=new Jl("tag:yaml.org,2002:bool",{kind:"scalar",resolve:function(e){if(null===e)return !1;var t=e.length;return 4===t&&("true"===e||"True"===e||"TRUE"===e)||5===t&&("false"===e||"False"===e||"FALSE"===e)},construct:function(e){return "true"===e||"True"===e||"TRUE"===e},predicate:function(e){return "[object Boolean]"===Object.prototype.toString.call(e)},represent:{lowercase:function(e){return e?"true":"false"},uppercase:function(e){return e?"TRUE":"FALSE"},camelcase:function(e){return e?"True":"False"}},defaultStyle:"lowercase"});function iu(e){return 48<=e&&e<=55}function ou(e){return 48<=e&&e<=57}var su=new Jl("tag:yaml.org,2002:int",{kind:"scalar",resolve:function(e){if(null===e)return !1;var t,r,n=e.length,i=0,o=!1;if(!n)return !1;if("-"!==(t=e[i])&&"+"!==t||(t=e[++i]),"0"===t){if(i+1===n)return !0;if("b"===(t=e[++i])){for(i++;i<n;i++)if("_"!==(t=e[i])){if("0"!==t&&"1"!==t)return !1;o=!0;}return o}if("x"===t){for(i++;i<n;i++)if("_"!==(t=e[i])){if(!(48<=(r=e.charCodeAt(i))&&r<=57||65<=r&&r<=70||97<=r&&r<=102))return !1;o=!0;}return o}for(;i<n;i++)if("_"!==(t=e[i])){if(!iu(e.charCodeAt(i)))return !1;o=!0;}return o}for(;i<n;i++)if("_"!==(t=e[i])){if(":"===t)break;if(!ou(e.charCodeAt(i)))return !1;o=!0;}return !!o&&(":"!==t||/^(:[0-5]?[0-9])+$/.test(e.slice(i)))},construct:function(e){var t,r,n=e,i=1,o=[];return -1!==n.indexOf("_")&&(n=n.replace(/_/g,"")),"-"!==(t=n[0])&&"+"!==t||("-"===t&&(i=-1),t=(n=n.slice(1))[0]),"0"===n?0:"0"===t?"b"===n[1]?i*parseInt(n.slice(2),2):"x"===n[1]?i*parseInt(n,16):i*parseInt(n,8):-1!==n.indexOf(":")?(n.split(":").forEach(function(e){o.unshift(parseInt(e,10));}),n=0,r=1,o.forEach(function(e){n+=e*r,r*=60;}),i*n):i*parseInt(n,10)},predicate:function(e){return "[object Number]"===Object.prototype.toString.call(e)&&e%1==0&&!ql.isNegativeZero(e)},represent:{binary:function(e){return "0b"+e.toString(2)},octal:function(e){return "0"+e.toString(8)},decimal:function(e){return e.toString(10)},hexadecimal:function(e){return "0x"+e.toString(16).toUpperCase()}},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}}),au=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)\\.[0-9_]*(?:[eE][-+][0-9]+)?|\\.[0-9_]+(?:[eE][-+][0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");var lu=/^[-+]?[0-9]+e/;var uu=new eu({include:[tu],implicit:[ru,nu,su,new Jl("tag:yaml.org,2002:float",{kind:"scalar",resolve:function(e){return null!==e&&!!au.test(e)},construct:function(e){var t,r,n,i;return r="-"===(t=e.replace(/_/g,"").toLowerCase())[0]?-1:1,i=[],"+-".indexOf(t[0])>=0&&(t=t.slice(1)),".inf"===t?1===r?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===t?NaN:t.indexOf(":")>=0?(t.split(":").forEach(function(e){i.unshift(parseFloat(e,10));}),t=0,n=1,i.forEach(function(e){t+=e*n,n*=60;}),r*t):r*parseFloat(t,10)},predicate:function(e){return "[object Number]"===Object.prototype.toString.call(e)&&(e%1!=0||ql.isNegativeZero(e))},represent:function(e,t){var r;if(isNaN(e))switch(t){case"lowercase":return ".nan";case"uppercase":return ".NAN";case"camelcase":return ".NaN"}else if(Number.POSITIVE_INFINITY===e)switch(t){case"lowercase":return ".inf";case"uppercase":return ".INF";case"camelcase":return ".Inf"}else if(Number.NEGATIVE_INFINITY===e)switch(t){case"lowercase":return "-.inf";case"uppercase":return "-.INF";case"camelcase":return "-.Inf"}else if(ql.isNegativeZero(e))return "-0.0";return r=e.toString(10),lu.test(r)?r.replace("e",".e"):r},defaultStyle:"lowercase"})]}),hu=new eu({include:[uu]}),cu=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?)?$");var fu=new Jl("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:function(e){return null!==e&&null!==cu.exec(e)},construct:function(e){var t,r,n,i,o,s,a,l,u=0,h=null;if(null===(t=cu.exec(e)))throw new Error("Date resolve error");if(r=+t[1],n=+t[2]-1,i=+t[3],!t[4])return new Date(Date.UTC(r,n,i));if(o=+t[4],s=+t[5],a=+t[6],t[7]){for(u=t[7].slice(0,3);u.length<3;)u+="0";u=+u;}return t[9]&&(h=6e4*(60*+t[10]+ +(t[11]||0)),"-"===t[9]&&(h=-h)),l=new Date(Date.UTC(r,n,i,o,s,a,u)),h&&l.setTime(l.getTime()-h),l},instanceOf:Date,represent:function(e){return e.toISOString()}});var du=new Jl("tag:yaml.org,2002:merge",{kind:"scalar",resolve:function(e){return "<<"===e||null===e}}),pu={}.Buffer,gu="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";var mu=new Jl("tag:yaml.org,2002:binary",{kind:"scalar",resolve:function(e){if(null===e)return !1;var t,r,n=0,i=e.length,o=gu;for(r=0;r<i;r++)if(!((t=o.indexOf(e.charAt(r)))>64)){if(t<0)return !1;n+=6;}return n%8==0},construct:function(e){var t,r,n=e.replace(/[\r\n=]/g,""),i=n.length,o=gu,s=0,a=[];for(t=0;t<i;t++)t%4==0&&t&&(a.push(s>>16&255),a.push(s>>8&255),a.push(255&s)),s=s<<6|o.indexOf(n.charAt(t));return 0==(r=i%4*6)?(a.push(s>>16&255),a.push(s>>8&255),a.push(255&s)):18===r?(a.push(s>>10&255),a.push(s>>2&255)):12===r&&a.push(s>>4&255),a},predicate:function(e){return pu&&pu.isBuffer(e)},represent:function(e){var t,r,n="",i=0,o=e.length,s=gu;for(t=0;t<o;t++)t%3==0&&t&&(n+=s[i>>18&63],n+=s[i>>12&63],n+=s[i>>6&63],n+=s[63&i]),i=(i<<8)+e[t];return 0==(r=o%3)?(n+=s[i>>18&63],n+=s[i>>12&63],n+=s[i>>6&63],n+=s[63&i]):2===r?(n+=s[i>>10&63],n+=s[i>>4&63],n+=s[i<<2&63],n+=s[64]):1===r&&(n+=s[i>>2&63],n+=s[i<<4&63],n+=s[64],n+=s[64]),n}}),vu=Object.prototype.hasOwnProperty,yu=Object.prototype.toString;var _u=new Jl("tag:yaml.org,2002:omap",{kind:"sequence",resolve:function(e){if(null===e)return !0;var t,r,n,i,o,s=[],a=e;for(t=0,r=a.length;t<r;t+=1){if(n=a[t],o=!1,"[object Object]"!==yu.call(n))return !1;for(i in n)if(vu.call(n,i)){if(o)return !1;o=!0;}if(!o)return !1;if(-1!==s.indexOf(i))return !1;s.push(i);}return !0},construct:function(e){return null!==e?e:[]}}),bu=Object.prototype.toString;var wu=new Jl("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:function(e){if(null===e)return !0;var t,r,n,i,o,s=e;for(o=new Array(s.length),t=0,r=s.length;t<r;t+=1){if(n=s[t],"[object Object]"!==bu.call(n))return !1;if(1!==(i=Object.keys(n)).length)return !1;o[t]=[i[0],n[i[0]]];}return !0},construct:function(e){if(null===e)return [];var t,r,n,i,o,s=e;for(o=new Array(s.length),t=0,r=s.length;t<r;t+=1)n=s[t],i=Object.keys(n),o[t]=[i[0],n[i[0]]];return o}}),ku=Object.prototype.hasOwnProperty;var Su=new eu({include:[hu],implicit:[fu,du],explicit:[mu,_u,wu,new Jl("tag:yaml.org,2002:set",{kind:"mapping",resolve:function(e){if(null===e)return !0;var t,r=e;for(t in r)if(ku.call(r,t)&&null!==r[t])return !1;return !0},construct:function(e){return null!==e?e:{}}})]});var xu=new Jl("tag:yaml.org,2002:js/undefined",{kind:"scalar",resolve:function(){return !0},construct:function(){},predicate:function(e){return void 0===e},represent:function(){return ""}});var Cu,Eu=new Jl("tag:yaml.org,2002:js/regexp",{kind:"scalar",resolve:function(e){if(null===e)return !1;if(0===e.length)return !1;var t=e,r=/\/([gim]*)$/.exec(e),n="";if("/"===t[0]){if(r&&(n=r[1]),n.length>3)return !1;if("/"!==t[t.length-n.length-1])return !1}return !0},construct:function(e){var t=e,r=/\/([gim]*)$/.exec(e),n="";return "/"===t[0]&&(r&&(n=r[1]),t=t.slice(1,t.length-n.length-1)),new RegExp(t,n)},predicate:function(e){return "[object RegExp]"===Object.prototype.toString.call(e)},represent:function(e){var t="/"+e.source+"/";return e.global&&(t+="g"),e.multiline&&(t+="m"),e.ignoreCase&&(t+="i"),t}});try{var Au=e.commonjsRequire;Cu=Au("esprima");}catch(e){"undefined"!=typeof window&&(Cu=window.esprima);}var Tu=new Jl("tag:yaml.org,2002:js/function",{kind:"scalar",resolve:function(e){if(null===e)return !1;try{var t="("+e+")",r=Cu.parse(t,{range:!0});return "Program"===r.type&&1===r.body.length&&"ExpressionStatement"===r.body[0].type&&"FunctionExpression"===r.body[0].expression.type}catch(e){return !1}},construct:function(e){var t,r="("+e+")",n=Cu.parse(r,{range:!0}),i=[];if("Program"!==n.type||1!==n.body.length||"ExpressionStatement"!==n.body[0].type||"FunctionExpression"!==n.body[0].expression.type)throw new Error("Failed to resolve function");return n.body[0].expression.params.forEach(function(e){i.push(e.name);}),t=n.body[0].expression.body.range,new Function(i,r.slice(t[0]+1,t[1]-1))},predicate:function(e){return "[object Function]"===Object.prototype.toString.call(e)},represent:function(e){return e.toString()}}),zu=eu.DEFAULT=new eu({include:[Su],explicit:[xu,Eu,Tu]}),Ou=Object.prototype.hasOwnProperty,Ru=1,Lu=2,Iu=3,Bu=4,Fu=1,Pu=2,Mu=3,ju=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/,Uu=/[\x85\u2028\u2029]/,Du=/[,\[\]\{\}]/,Nu=/^(?:!|!!|![a-z\-]+!)$/i,Zu=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function Wu(e){return 10===e||13===e}function qu(e){return 9===e||32===e}function $u(e){return 9===e||32===e||10===e||13===e}function Yu(e){return 44===e||91===e||93===e||123===e||125===e}function Vu(e){var t;return 48<=e&&e<=57?e-48:97<=(t=32|e)&&t<=102?t-97+10:-1}function Hu(e){return 48===e?"\0":97===e?"":98===e?"\b":116===e?"\t":9===e?"\t":110===e?"\n":118===e?"\v":102===e?"\f":114===e?"\r":101===e?"":32===e?" ":34===e?'"':47===e?"/":92===e?"\\":78===e?"":95===e?" ":76===e?"\u2028":80===e?"\u2029":""}function Gu(e){return e<=65535?String.fromCharCode(e):String.fromCharCode(55296+(e-65536>>10),56320+(e-65536&1023))}for(var Ku=new Array(256),Ju=new Array(256),Xu=0;Xu<256;Xu++)Ku[Xu]=Hu(Xu)?1:0,Ju[Xu]=Hu(Xu);function Qu(e,t){this.input=e,this.filename=t.filename||null,this.schema=t.schema||zu,this.onWarning=t.onWarning||null,this.legacy=t.legacy||!1,this.json=t.json||!1,this.listener=t.listener||null,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=e.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.documents=[];}function eh(e,t){return new Yl(t,new Hl(e.filename,e.input,e.position,e.line,e.position-e.lineStart))}function th(e,t){throw eh(e,t)}function rh(e,t){e.onWarning&&e.onWarning.call(null,eh(e,t));}var nh={YAML:function(e,t,r){var n,i,o;null!==e.version&&th(e,"duplication of %YAML directive"),1!==r.length&&th(e,"YAML directive accepts exactly one argument"),null===(n=/^([0-9]+)\.([0-9]+)$/.exec(r[0]))&&th(e,"ill-formed argument of the YAML directive"),i=parseInt(n[1],10),o=parseInt(n[2],10),1!==i&&th(e,"unacceptable YAML version of the document"),e.version=r[0],e.checkLineBreaks=o<2,1!==o&&2!==o&&rh(e,"unsupported YAML version of the document");},TAG:function(e,t,r){var n,i;2!==r.length&&th(e,"TAG directive accepts exactly two arguments"),n=r[0],i=r[1],Nu.test(n)||th(e,"ill-formed tag handle (first argument) of the TAG directive"),Ou.call(e.tagMap,n)&&th(e,'there is a previously declared suffix for "'+n+'" tag handle'),Zu.test(i)||th(e,"ill-formed tag prefix (second argument) of the TAG directive"),e.tagMap[n]=i;}};function ih(e,t,r,n){var i,o,s,a;if(t<r){if(a=e.input.slice(t,r),n)for(i=0,o=a.length;i<o;i+=1)9===(s=a.charCodeAt(i))||32<=s&&s<=1114111||th(e,"expected valid JSON character");else ju.test(a)&&th(e,"the stream contains non-printable characters");e.result+=a;}}function oh(e,t,r,n){var i,o,s,a;for(ql.isObject(r)||th(e,"cannot merge mappings; the provided source object is unacceptable"),s=0,a=(i=Object.keys(r)).length;s<a;s+=1)o=i[s],Ou.call(t,o)||(t[o]=r[o],n[o]=!0);}function sh(e,t,r,n,i,o){var s,a;if(i=String(i),null===t&&(t={}),"tag:yaml.org,2002:merge"===n)if(Array.isArray(o))for(s=0,a=o.length;s<a;s+=1)oh(e,t,o[s],r);else oh(e,t,o,r);else e.json||Ou.call(r,i)||!Ou.call(t,i)||th(e,"duplicated mapping key"),t[i]=o,delete r[i];return t}function ah(e){var t;10===(t=e.input.charCodeAt(e.position))?e.position++:13===t?(e.position++,10===e.input.charCodeAt(e.position)&&e.position++):th(e,"a line break is expected"),e.line+=1,e.lineStart=e.position;}function lh(e,t,r){for(var n=0,i=e.input.charCodeAt(e.position);0!==i;){for(;qu(i);)i=e.input.charCodeAt(++e.position);if(t&&35===i)do{i=e.input.charCodeAt(++e.position);}while(10!==i&&13!==i&&0!==i);if(!Wu(i))break;for(ah(e),i=e.input.charCodeAt(e.position),n++,e.lineIndent=0;32===i;)e.lineIndent++,i=e.input.charCodeAt(++e.position);}return -1!==r&&0!==n&&e.lineIndent<r&&rh(e,"deficient indentation"),n}function uh(e){var t,r=e.position;return !(45!==(t=e.input.charCodeAt(r))&&46!==t||t!==e.input.charCodeAt(r+1)||t!==e.input.charCodeAt(r+2)||(r+=3,0!==(t=e.input.charCodeAt(r))&&!$u(t)))}function hh(e,t){1===t?e.result+=" ":t>1&&(e.result+=ql.repeat("\n",t-1));}function ch(e,t){var r,n,i=e.tag,o=e.anchor,s=[],a=!1;for(null!==e.anchor&&(e.anchorMap[e.anchor]=s),n=e.input.charCodeAt(e.position);0!==n&&45===n&&$u(e.input.charCodeAt(e.position+1));)if(a=!0,e.position++,lh(e,!0,-1)&&e.lineIndent<=t)s.push(null),n=e.input.charCodeAt(e.position);else if(r=e.line,ph(e,t,Iu,!1,!0),s.push(e.result),lh(e,!0,-1),n=e.input.charCodeAt(e.position),(e.line===r||e.lineIndent>t)&&0!==n)th(e,"bad indentation of a sequence entry");else if(e.lineIndent<t)break;return !!a&&(e.tag=i,e.anchor=o,e.kind="sequence",e.result=s,!0)}function fh(e){var t,r,n,i,o=!1,s=!1;if(33!==(i=e.input.charCodeAt(e.position)))return !1;if(null!==e.tag&&th(e,"duplication of a tag property"),60===(i=e.input.charCodeAt(++e.position))?(o=!0,i=e.input.charCodeAt(++e.position)):33===i?(s=!0,r="!!",i=e.input.charCodeAt(++e.position)):r="!",t=e.position,o){do{i=e.input.charCodeAt(++e.position);}while(0!==i&&62!==i);e.position<e.length?(n=e.input.slice(t,e.position),i=e.input.charCodeAt(++e.position)):th(e,"unexpected end of the stream within a verbatim tag");}else{for(;0!==i&&!$u(i);)33===i&&(s?th(e,"tag suffix cannot contain exclamation marks"):(r=e.input.slice(t-1,e.position+1),Nu.test(r)||th(e,"named tag handle cannot contain such characters"),s=!0,t=e.position+1)),i=e.input.charCodeAt(++e.position);n=e.input.slice(t,e.position),Du.test(n)&&th(e,"tag suffix cannot contain flow indicator characters");}return n&&!Zu.test(n)&&th(e,"tag name cannot contain such characters: "+n),o?e.tag=n:Ou.call(e.tagMap,r)?e.tag=e.tagMap[r]+n:"!"===r?e.tag="!"+n:"!!"===r?e.tag="tag:yaml.org,2002:"+n:th(e,'undeclared tag handle "'+r+'"'),!0}function dh(e){var t,r;if(38!==(r=e.input.charCodeAt(e.position)))return !1;for(null!==e.anchor&&th(e,"duplication of an anchor property"),r=e.input.charCodeAt(++e.position),t=e.position;0!==r&&!$u(r)&&!Yu(r);)r=e.input.charCodeAt(++e.position);return e.position===t&&th(e,"name of an anchor node must contain at least one character"),e.anchor=e.input.slice(t,e.position),!0}function ph(e,t,r,n,i){var o,s,a,l,u,h,c,f,d=1,p=!1,g=!1;if(null!==e.listener&&e.listener("open",e),e.tag=null,e.anchor=null,e.kind=null,e.result=null,o=s=a=Bu===r||Iu===r,n&&lh(e,!0,-1)&&(p=!0,e.lineIndent>t?d=1:e.lineIndent===t?d=0:e.lineIndent<t&&(d=-1)),1===d)for(;fh(e)||dh(e);)lh(e,!0,-1)?(p=!0,a=o,e.lineIndent>t?d=1:e.lineIndent===t?d=0:e.lineIndent<t&&(d=-1)):a=!1;if(a&&(a=p||i),1!==d&&Bu!==r||(c=Ru===r||Lu===r?t:t+1,f=e.position-e.lineStart,1===d?a&&(ch(e,f)||function(e,t,r){var n,i,o,s,a=e.tag,l=e.anchor,u={},h={},c=null,f=null,d=null,p=!1,g=!1;for(null!==e.anchor&&(e.anchorMap[e.anchor]=u),s=e.input.charCodeAt(e.position);0!==s;){if(n=e.input.charCodeAt(e.position+1),o=e.line,63!==s&&58!==s||!$u(n)){if(!ph(e,r,Lu,!1,!0))break;if(e.line===o){for(s=e.input.charCodeAt(e.position);qu(s);)s=e.input.charCodeAt(++e.position);if(58===s)$u(s=e.input.charCodeAt(++e.position))||th(e,"a whitespace character is expected after the key-value separator within a block mapping"),p&&(sh(e,u,h,c,f,null),c=f=d=null),g=!0,p=!1,i=!1,c=e.tag,f=e.result;else{if(!g)return e.tag=a,e.anchor=l,!0;th(e,"can not read an implicit mapping pair; a colon is missed");}}else{if(!g)return e.tag=a,e.anchor=l,!0;th(e,"can not read a block mapping entry; a multiline key may not be an implicit key");}}else 63===s?(p&&(sh(e,u,h,c,f,null),c=f=d=null),g=!0,p=!0,i=!0):p?(p=!1,i=!0):th(e,"incomplete explicit mapping pair; a key node is missed"),e.position+=1,s=n;if((e.line===o||e.lineIndent>t)&&(ph(e,t,Bu,!0,i)&&(p?f=e.result:d=e.result),p||(sh(e,u,h,c,f,d),c=f=d=null),lh(e,!0,-1),s=e.input.charCodeAt(e.position)),e.lineIndent>t&&0!==s)th(e,"bad indentation of a mapping entry");else if(e.lineIndent<t)break}return p&&sh(e,u,h,c,f,null),g&&(e.tag=a,e.anchor=l,e.kind="mapping",e.result=u),g}(e,f,c))||function(e,t){var r,n,i,o,s,a,l,u,h,c,f=!0,d=e.tag,p=e.anchor,g={};if(91===(c=e.input.charCodeAt(e.position)))i=93,a=!1,n=[];else{if(123!==c)return !1;i=125,a=!0,n={};}for(null!==e.anchor&&(e.anchorMap[e.anchor]=n),c=e.input.charCodeAt(++e.position);0!==c;){if(lh(e,!0,t),(c=e.input.charCodeAt(e.position))===i)return e.position++,e.tag=d,e.anchor=p,e.kind=a?"mapping":"sequence",e.result=n,!0;f||th(e,"missed comma between flow collection entries"),h=null,o=s=!1,63===c&&$u(e.input.charCodeAt(e.position+1))&&(o=s=!0,e.position++,lh(e,!0,t)),r=e.line,ph(e,t,Ru,!1,!0),u=e.tag,l=e.result,lh(e,!0,t),c=e.input.charCodeAt(e.position),!s&&e.line!==r||58!==c||(o=!0,c=e.input.charCodeAt(++e.position),lh(e,!0,t),ph(e,t,Ru,!1,!0),h=e.result),a?sh(e,n,g,u,l,h):o?n.push(sh(e,null,g,u,l,h)):n.push(l),lh(e,!0,t),44===(c=e.input.charCodeAt(e.position))?(f=!0,c=e.input.charCodeAt(++e.position)):f=!1;}th(e,"unexpected end of the stream within a flow collection");}(e,c)?g=!0:(s&&function(e,t){var r,n,i,o,s,a=Fu,l=!1,u=t,h=0,c=!1;if(124===(o=e.input.charCodeAt(e.position)))n=!1;else{if(62!==o)return !1;n=!0;}for(e.kind="scalar",e.result="";0!==o;)if(43===(o=e.input.charCodeAt(++e.position))||45===o)Fu===a?a=43===o?Mu:Pu:th(e,"repeat of a chomping mode identifier");else{if(!((i=48<=(s=o)&&s<=57?s-48:-1)>=0))break;0===i?th(e,"bad explicit indentation width of a block scalar; it cannot be less than one"):l?th(e,"repeat of an indentation width identifier"):(u=t+i-1,l=!0);}if(qu(o)){do{o=e.input.charCodeAt(++e.position);}while(qu(o));if(35===o)do{o=e.input.charCodeAt(++e.position);}while(!Wu(o)&&0!==o)}for(;0!==o;){for(ah(e),e.lineIndent=0,o=e.input.charCodeAt(e.position);(!l||e.lineIndent<u)&&32===o;)e.lineIndent++,o=e.input.charCodeAt(++e.position);if(!l&&e.lineIndent>u&&(u=e.lineIndent),Wu(o))h++;else{if(e.lineIndent<u){a===Mu?e.result+=ql.repeat("\n",h):a===Fu&&l&&(e.result+="\n");break}for(n?qu(o)?(c=!0,e.result+=ql.repeat("\n",h+1)):c?(c=!1,e.result+=ql.repeat("\n",h+1)):0===h?l&&(e.result+=" "):e.result+=ql.repeat("\n",h):e.result+=l?ql.repeat("\n",h+1):ql.repeat("\n",h),l=!0,h=0,r=e.position;!Wu(o)&&0!==o;)o=e.input.charCodeAt(++e.position);ih(e,r,e.position,!1);}}return !0}(e,c)||function(e,t){var r,n,i;if(39!==(r=e.input.charCodeAt(e.position)))return !1;for(e.kind="scalar",e.result="",e.position++,n=i=e.position;0!==(r=e.input.charCodeAt(e.position));)if(39===r){if(ih(e,n,e.position,!0),39!==(r=e.input.charCodeAt(++e.position)))return !0;n=i=e.position,e.position++;}else Wu(r)?(ih(e,n,i,!0),hh(e,lh(e,!1,t)),n=i=e.position):e.position===e.lineStart&&uh(e)?th(e,"unexpected end of the document within a single quoted scalar"):(e.position++,i=e.position);th(e,"unexpected end of the stream within a single quoted scalar");}(e,c)||function(e,t){var r,n,i,o,s,a,l;if(34!==(a=e.input.charCodeAt(e.position)))return !1;for(e.kind="scalar",e.result="",e.position++,r=n=e.position;0!==(a=e.input.charCodeAt(e.position));){if(34===a)return ih(e,r,e.position,!0),e.position++,!0;if(92===a){if(ih(e,r,e.position,!0),Wu(a=e.input.charCodeAt(++e.position)))lh(e,!1,t);else if(a<256&&Ku[a])e.result+=Ju[a],e.position++;else if((s=120===(l=a)?2:117===l?4:85===l?8:0)>0){for(i=s,o=0;i>0;i--)(s=Vu(a=e.input.charCodeAt(++e.position)))>=0?o=(o<<4)+s:th(e,"expected hexadecimal character");e.result+=Gu(o),e.position++;}else th(e,"unknown escape sequence");r=n=e.position;}else Wu(a)?(ih(e,r,n,!0),hh(e,lh(e,!1,t)),r=n=e.position):e.position===e.lineStart&&uh(e)?th(e,"unexpected end of the document within a double quoted scalar"):(e.position++,n=e.position);}th(e,"unexpected end of the stream within a double quoted scalar");}(e,c)?g=!0:!function(e){var t,r,n;if(42!==(n=e.input.charCodeAt(e.position)))return !1;for(n=e.input.charCodeAt(++e.position),t=e.position;0!==n&&!$u(n)&&!Yu(n);)n=e.input.charCodeAt(++e.position);return e.position===t&&th(e,"name of an alias node must contain at least one character"),r=e.input.slice(t,e.position),e.anchorMap.hasOwnProperty(r)||th(e,'unidentified alias "'+r+'"'),e.result=e.anchorMap[r],lh(e,!0,-1),!0}(e)?function(e,t,r){var n,i,o,s,a,l,u,h,c=e.kind,f=e.result;if($u(h=e.input.charCodeAt(e.position))||Yu(h)||35===h||38===h||42===h||33===h||124===h||62===h||39===h||34===h||37===h||64===h||96===h)return !1;if((63===h||45===h)&&($u(n=e.input.charCodeAt(e.position+1))||r&&Yu(n)))return !1;for(e.kind="scalar",e.result="",i=o=e.position,s=!1;0!==h;){if(58===h){if($u(n=e.input.charCodeAt(e.position+1))||r&&Yu(n))break}else if(35===h){if($u(e.input.charCodeAt(e.position-1)))break}else{if(e.position===e.lineStart&&uh(e)||r&&Yu(h))break;if(Wu(h)){if(a=e.line,l=e.lineStart,u=e.lineIndent,lh(e,!1,-1),e.lineIndent>=t){s=!0,h=e.input.charCodeAt(e.position);continue}e.position=o,e.line=a,e.lineStart=l,e.lineIndent=u;break}}s&&(ih(e,i,o,!1),hh(e,e.line-a),i=o=e.position,s=!1),qu(h)||(o=e.position+1),h=e.input.charCodeAt(++e.position);}return ih(e,i,o,!1),!!e.result||(e.kind=c,e.result=f,!1)}(e,c,Ru===r)&&(g=!0,null===e.tag&&(e.tag="?")):(g=!0,null===e.tag&&null===e.anchor||th(e,"alias node should not have any properties")),null!==e.anchor&&(e.anchorMap[e.anchor]=e.result)):0===d&&(g=a&&ch(e,f))),null!==e.tag&&"!"!==e.tag)if("?"===e.tag){for(l=0,u=e.implicitTypes.length;l<u;l+=1)if((h=e.implicitTypes[l]).resolve(e.result)){e.result=h.construct(e.result),e.tag=h.tag,null!==e.anchor&&(e.anchorMap[e.anchor]=e.result);break}}else Ou.call(e.typeMap,e.tag)?(h=e.typeMap[e.tag],null!==e.result&&h.kind!==e.kind&&th(e,"unacceptable node kind for !<"+e.tag+'> tag; it should be "'+h.kind+'", not "'+e.kind+'"'),h.resolve(e.result)?(e.result=h.construct(e.result),null!==e.anchor&&(e.anchorMap[e.anchor]=e.result)):th(e,"cannot resolve a node with !<"+e.tag+"> explicit tag")):th(e,"unknown tag !<"+e.tag+">");return null!==e.listener&&e.listener("close",e),null!==e.tag||null!==e.anchor||g}function gh(e){var t,r,n,i,o=e.position,s=!1;for(e.version=null,e.checkLineBreaks=e.legacy,e.tagMap={},e.anchorMap={};0!==(i=e.input.charCodeAt(e.position))&&(lh(e,!0,-1),i=e.input.charCodeAt(e.position),!(e.lineIndent>0||37!==i));){for(s=!0,i=e.input.charCodeAt(++e.position),t=e.position;0!==i&&!$u(i);)i=e.input.charCodeAt(++e.position);for(n=[],(r=e.input.slice(t,e.position)).length<1&&th(e,"directive name must not be less than one character in length");0!==i;){for(;qu(i);)i=e.input.charCodeAt(++e.position);if(35===i){do{i=e.input.charCodeAt(++e.position);}while(0!==i&&!Wu(i));break}if(Wu(i))break;for(t=e.position;0!==i&&!$u(i);)i=e.input.charCodeAt(++e.position);n.push(e.input.slice(t,e.position));}0!==i&&ah(e),Ou.call(nh,r)?nh[r](e,r,n):rh(e,'unknown document directive "'+r+'"');}lh(e,!0,-1),0===e.lineIndent&&45===e.input.charCodeAt(e.position)&&45===e.input.charCodeAt(e.position+1)&&45===e.input.charCodeAt(e.position+2)?(e.position+=3,lh(e,!0,-1)):s&&th(e,"directives end mark is expected"),ph(e,e.lineIndent-1,Bu,!1,!0),lh(e,!0,-1),e.checkLineBreaks&&Uu.test(e.input.slice(o,e.position))&&rh(e,"non-ASCII line breaks are interpreted as content"),e.documents.push(e.result),e.position===e.lineStart&&uh(e)?46===e.input.charCodeAt(e.position)&&(e.position+=3,lh(e,!0,-1)):e.position<e.length-1&&th(e,"end of the stream or a document separator is expected");}function mh(e,t){t=t||{},0!==(e=String(e)).length&&(10!==e.charCodeAt(e.length-1)&&13!==e.charCodeAt(e.length-1)&&(e+="\n"),65279===e.charCodeAt(0)&&(e=e.slice(1)));var r=new Qu(e,t);for(r.input+="\0";32===r.input.charCodeAt(r.position);)r.lineIndent+=1,r.position+=1;for(;r.position<r.length-1;)gh(r);return r.documents}function vh(e,t,r){var n,i,o=mh(e,r);for(n=0,i=o.length;n<i;n+=1)t(o[n]);}function yh(e,t){var r=mh(e,t);if(0!==r.length){if(1===r.length)return r[0];throw new Yl("expected a single document in the stream, but found more")}}var _h={loadAll:vh,load:yh,safeLoadAll:function(e,t,r){vh(e,t,ql.extend({schema:Su},r));},safeLoad:function(e,t){return yh(e,ql.extend({schema:Su},t))}};function bh(e){return function(){throw new Error("Function "+e+" is deprecated and cannot be used.")}}var wh,kh={Type:Jl,Schema:eu,FAILSAFE_SCHEMA:tu,JSON_SCHEMA:uu,CORE_SCHEMA:hu,DEFAULT_SAFE_SCHEMA:Su,DEFAULT_FULL_SCHEMA:zu,load:_h.load,loadAll:_h.loadAll,safeLoad:_h.safeLoad,safeLoadAll:_h.safeLoadAll,YAMLException:Yl,MINIMAL_SCHEMA:tu,SAFE_SCHEMA:Su,DEFAULT_SCHEMA:zu,scan:bh("scan"),parse:bh("parse"),compose:bh("compose"),addConstructor:bh("addConstructor")},Sh=function(){function t(t,r,n){void 0===n&&(n=null),this.url=t,!r||e.isRelativeURL(r)&&!e.isRelativeURL(this.url)?this.path=e.pathForURL(this.url):this.path=r,this.path_for_parent=r||this.path,this.parent=n,this.container=null,this.parent&&(this.parent.container?this.container=this.parent.container:this.parent.isContainer()&&(this.container=this.parent));}var r=t.prototype;return r.load=function(){return Eh(this.url)},r.resourceFor=function(e){return {url:this.urlFor(e),path:this.pathFor(e),type:this.typeFor(e)}},r.urlFor=function(t){return Ch(t)?t:e.isRelativeURL(t)&&this.container?this.parent.urlFor(this.path_for_parent+t):e.addBaseURL(t,this.path)},r.pathFor=function(t){return e.pathForURL(t)},r.typeFor=function(t){return e.extensionForURL(t)},r.isContainer=function(){return !1},t}(),xh=function(t){function r(e,r,n){var i;return (i=t.call(this,e,r,n)||this).zip=null,i.files={},i.root=null,i.path="",i}e._inheritsLoose(r,t);var n=r.prototype;return n.isContainer=function(){return !0},n.load=function(){return new Promise(function(t,r){var n;return this.zip=new Zl,"string"==typeof this.url?Promise.resolve(e.Utils.io(this.url,6e4,"arraybuffer")).then(function(e){try{return n=e.body,Promise.resolve(this.zip.loadAsync(n)).then(function(e){try{return Promise.resolve(this.parseZipFiles()).then(function(e){try{return t(this.loadRoot())}catch(e){return r(e)}}.bind(this),r)}catch(e){return r(e)}}.bind(this),r)}catch(e){return r(e)}}.bind(this),r):t(this)}.bind(this))},n.urlFor=function(r){return Ch(r)?r:e.isRelativeURL(r)?this.urlForZipFile(e.flattenRelativeURL(r)):t.prototype.urlFor.call(this,r)},n.typeFor=function(r){return e.isRelativeURL(r)?this.typeForZipFile(r):t.prototype.typeFor.call(this,r)},n.loadRoot=function(){return this.findRoot(),Eh(this.urlForZipFile(this.root))},n.findRoot=function(){var t=this,r=Object.keys(this.files).filter(function(e){return 0===t.files[e].depth}).filter(function(t){return "yaml"===e.extensionForURL(t)});if(1===r.length&&(this.root=r[0]),!this.root){var n="Could not find root scene for bundle '"+this.url+"': ";throw n+="The zip archive's root level must contain a single scene file with the '.yaml' extension. ",r.length>0?n+="Found multiple YAML files at the root level: "+r.map(function(e){return "'"+e+"'"}).join(", ")+".":n+="Found NO YAML files at the root level.",Error(n)}},n.parseZipFiles=function(){return new Promise(function(t,r){var n,i,o,s,a,l;return n=[],i=[],this.zip.forEach(function(e,t){t.dir||(n.push(e),i.push(t.async("arraybuffer")));}),Promise.resolve(Promise.all(i)).then(function(i){try{for(o=i,s=0;s<o.length;s++)a=n[s],l=a.split("/").length-1,this.files[a]={data:o[s],type:e.extensionForURL(a),depth:l};return t()}catch(e){return r(e)}}.bind(this),r)}.bind(this))},n.urlForZipFile=function(t){if(this.files[t])return this.files[t].url||(this.files[t].url=e.createObjectURL(new Blob([this.files[t].data]))),this.files[t].url},n.typeForZipFile=function(e){return this.files[e]&&this.files[e].type},r}(Sh);function Ch(e){return !(!e||"global."!==e.slice(0,7))}function Eh(t){return new Promise(function(r,n){"string"==typeof t?e.Utils.io(t).then(function(e){var t=e.body;try{r(function(e){var t;try{t=kh.safeLoad(e,{json:!0});}catch(e){throw e}return t}(t));}catch(e){n(e);}},n):(t=Object.assign({},t),r(t));})}var Ah=wh={loadScene:function(t,r){return new Promise(function(n,i){var o,s,a,l,u,h,c,f,d;return o=this,a=(s=void 0===r?{}:r).path,l=s.type,u=[],Promise.resolve(this.loadSceneRecursive({url:t,path:a,type:l},null,u)).then(function(t){try{return h=t,c=this.finalize(h),f=c.config,d=c.bundle,f?(u.length>0&&u.forEach(function(t){var r="Failed to import scene: "+t.url;e.log("error",r,t),o.trigger("error",{type:"scene_import",message:r,error:t,url:t.url});}),n({config:f,bundle:d})):i(u[0])}catch(e){return i(e)}}.bind(this),i)}.bind(this))},loadSceneRecursive:function(t,r,n){return new Promise(function(i,o){var s,a,l,u,h,c,f,d,p;if(s=this,a=t.url,l=t.path,u=t.type,void 0===n&&(n=[]),!a)return i({});h=function(t,r,n,i){return void 0===i&&(i=null),null!=i&&"zip"===i||"string"==typeof t&&!e.isLocalURL(t)&&"zip"===e.extensionForURL(t)?new xh(t,r,n):new Sh(t,r,n)}(a,l,r,u);var g=function(e){try{return e.url=a,n.push(e),i({})}catch(e){return o(e)}};try{return Promise.resolve(h.load()).then(function(t){try{return null==(c=t).import?(this.normalize(c,h),i({config:c,bundle:h})):(Array.isArray(c.import)||(c.import=[c.import]),f=[],c.import.forEach(function(t){"object"==typeof t&&(t=e.createObjectURL(new Blob([JSON.stringify(t)]))),f.push(h.resourceFor(t));}),delete c.import,d=f.map(function(e){return s.loadSceneRecursive(e,h,n)}),Promise.resolve(Promise.all(d)).then(function(t){try{return p=t.map(function(e){return s.normalize(e.config,e.bundle)}).map(function(e){return e.config}),c=e.mergeObjects.apply(void 0,p.concat([c])),this.normalize(c,h),i({config:c,bundle:h})}catch(e){return g(e)}}.bind(this),g))}catch(e){return g(e)}}.bind(this),g)}catch(e){g(e);}}.bind(this))},normalize:function(e,t){return this.normalizeDataSources(e,t),this.normalizeFonts(e,t),this.normalizeTextures(e,t),this.hoistTextures(e,t),{config:e,bundle:t}},normalizeDataSources:function(e,t){for(var r in e.sources=e.sources||{},e.sources)this.normalizeDataSource(e.sources[r],t);return e},normalizeDataSource:function(e,t){if(e.url=t.urlFor(e.url),Array.isArray(e.composite)&&e.composite.forEach(function(e){return e.url=t.urlFor(e.url)}),e.scripts)for(var r in Array.isArray(e.scripts)&&(e.scripts=e.scripts.reduce(function(e,t){return e[t]=t,e},{})),e.scripts)e.scripts[r]=t.urlFor(e.scripts[r]);return e},normalizeFonts:function(e,t){for(var r in e.fonts=e.fonts||{},e.fonts)if(Array.isArray(e.fonts[r]))e.fonts[r].forEach(function(e){e.url=e.url&&t.urlFor(e.url);});else{var n=e.fonts[r];n.url=n.url&&t.urlFor(n.url);}return e},normalizeTextures:function(e,t){if(e.textures=e.textures||{},e.textures)for(var r in e.textures){var n=e.textures[r];n.url&&(n.url=t.urlFor(n.url));}},hoistTextures:function(t,r){var n=this;if(t.styles){var i=function(e){var i=t.styles[e],o=i.texture;"string"!=typeof o||t.textures[o]||(i.texture=n.hoistTexture(o,t,r)),i.material&&["emission","ambient","diffuse","specular","normal"].forEach(function(e){var o=null!=i.material[e]&&i.material[e].texture;"string"!=typeof o||t.textures[o]||(i.material[e].texture=n.hoistTexture(o,t,r));});};for(var o in t.styles)i(o);}if(this.hoistStyleShaderUniformTextures(t,r,{include_globals:!1}),t.layers)for(var s=[t.layers];s.length>0;){var a=s.pop();if("object"==typeof a&&!Array.isArray(a))for(var l in a)if("draw"===l){var u=a[l];for(var h in u){if(u[h].texture){var c=u[h].texture;"string"!=typeof c||t.textures[c]||(u[h].texture=this.hoistTexture(c,t,r));}if(u[h].outline&&u[h].outline.texture){var f=u[h].outline.texture;"string"!=typeof f||t.textures[f]||(u[h].outline.texture=this.hoistTexture(f,t,r));}}}else{if(e.isReserved(l))continue;s.push(a[l]);}}},hoistStyleShaderUniformTextures:function(t,r,n){var i=this,o=n.include_globals;if(t.styles)for(var s in t.styles){var a=t.styles[s];a.shaders&&a.shaders.uniforms&&e.GLSL.parseUniforms(a.shaders.uniforms).forEach(function(e){var n=e.type,s=e.value,a=e.key,l=e.uniforms;"sampler2D"!==n||"string"!=typeof s||t.textures[s]||!o&&Ch(s)||(l[a]=i.hoistTexture(s,t,r));});}},hoistTexture:function(e,t,r){var n=Ch(e),i=n?e:r.urlFor(e),o=n?"texture-"+i:i;return t.textures[o]={url:i},o},applyGlobalProperties:function(t){if(!t.global||0===Object.keys(t.global).length)return t;var r=function e(t,r,n){void 0===r&&(r=null);void 0===n&&(n={});r=r?r+".":"global.";for(var i in t){var o=r+i,s=t[i];n[o]=s,"object"!=typeof s||Array.isArray(s)||e(s,o,n);}return n}(t.global);return function t(n,i,o){var s;if(null!=i&&"object"==typeof i&&i._global_prop&&i._global_prop[o]?s=i._global_prop[o]:"string"==typeof n&&"global."===n.slice(0,7)&&(s=n),s){null==i._global_prop&&Object.defineProperty(i,"_global_prop",{value:{}}),i._global_prop[o]=s;for(var a,l=r[s];"string"==typeof l&&"global."===l.slice(0,7);){if((a=a||[s]).indexOf(l)>-1){e.log({level:"warn",once:!0},"Global properties: cyclical reference detected",a),l=null;break}a.push(l),l=r[l];}Object.defineProperty(i,o,{enumerable:!0,get:function(){return l},set:function(e){delete i._global_prop[o],delete i[o],i[o]=e;}});}else if(Array.isArray(n))for(var u=0;u<n.length;u++)t(n[u],n,u);else if("object"==typeof n)for(var h in n)t(n[h],n,h);return n}(t)},finalize:function(e){var t=e.config,r=e.bundle;return t?(t.global=t.global||{},t.scene=t.scene||{},t.cameras=t.cameras||{},t.lights=t.lights||{},t.styles=t.styles||{},t.layers=t.layers||{},t.camera&&(t.cameras.default=t.camera),0===Object.keys(t.cameras).length&&(t.cameras.default={}),(0===Object.keys(t.lights).length||Object.keys(t.lights).every(function(e){return !1===t.lights[e].visible}))&&(t.lights.default_light={type:"directional"}),{config:t,bundle:r}):{}}};e.subscribeMixin(wh);var Th=function(){function t(){this.tiles={},this.max_proxy_descendant_depth=6,this.max_proxy_ancestor_depth=7,this.children_cache={};}var r=t.prototype;return r.addTile=function(t){for(this.tiles[t.key]=this.tiles[t.key]||{descendants:0},this.tiles[t.key].tile=t;t.style_z>=0;){if(!(t=e.TileID.parent(t)))return;this.tiles[t.key]||(this.tiles[t.key]={descendants:0}),this.tiles[t.key].descendants++;}},r.removeTile=function(t){for(this.tiles[t.key]&&(delete this.tiles[t.key].tile,0===this.tiles[t.key].descendants&&delete this.tiles[t.key]);t.style_z>=0;){if(!(t=e.TileID.parent(t)))return;this.tiles[t.key]&&this.tiles[t.key].descendants>0&&(this.tiles[t.key].descendants--,0!==this.tiles[t.key].descendants||this.tiles[t.key].tile||delete this.tiles[t.key]);}},r.getAncestor=function(t){for(var r=0;r<this.max_proxy_ancestor_depth;){if(!(t=e.TileID.parent(t)))return;if(this.tiles[t.key]&&this.tiles[t.key].tile&&this.tiles[t.key].tile.loaded)return this.tiles[t.key].tile;r++;}},r.getDescendants=function(t,r){var n=this;void 0===r&&(r=0);var i=[];if(r<this.max_proxy_descendant_depth){var o=e.TileID.children(t,this.children_cache);if(!o)return;o.forEach(function(e){n.tiles[e.key]&&(n.tiles[e.key].tile&&n.tiles[e.key].tile.loaded?i.push(n.tiles[e.key].tile):n.tiles[e.key].descendants>0&&i.push.apply(i,n.getDescendants(e,r+1)));});}return i},t}(),zh={},Oh={};function Rh(t,r,n){return new Promise(function(i,o){var s,a,l,u,h;return void 0===n&&(n=!1),Oh=zh,zh={},s=function(t,r){var n={},i={};for(var o in t.forEach(function(t){var o=e.Geo.unitsPerMeter(t.coords.z),s=Math.pow(2,r-t.style_z),a=o*s,l=e.Geo.metersPerPixel(r),u=Object.assign({},t.meshes,t.pending_label_meshes);for(var h in u)u[h].forEach(function(r){if(r.labels)for(var s in r.labels)if(!t.isProxy()||Oh[s]){var u=r.labels[s].container.label,h=r.labels[s].container.linked,c=r.labels[s].ranges,f=n[s]={};if(f.discard=Lh.bind(f),f.build_id=t.build_id,Object.assign(f,u),f.layout=Object.assign({},u.layout),f.layout.repeat_scale=.75,f.layout.repeat_distance=f.layout.repeat_distance||0,f.layout.repeat_distance/=a,f.position=[f.position[0]/o+t.min.x,f.position[1]/o+t.min.y],f.unit_scale=l,"point"===f.type)e.LabelPoint.prototype.updateBBoxes.call(f);else if("straight"===f.type)e.LabelLineStraight.prototype.updateBBoxes.call(f,f.position,f.size,f.angle,f.angle,f.offset);else if(u.obbs){var d=u.obbs.map(function(r){var n=r.x,i=r.y,s=r.a,l=r.w,u=r.h;return n=n/o+t.min.x,i=i/o+t.min.y,l/=a,u/=a,new e.OBB(n,i,s,l,u)});f.obbs=d,f.aabbs=d.map(function(e){return e.getExtent()});}i[s]={label:f,linked:h,ranges:c,mesh:r};}});}),i){var s=i[o];s.linked&&(s.linked=i[s.linked]);}return i=Object.keys(i).map(function(e){return i[e]})}(t,r),e.Collision.startTile("main",{apply_repeat_groups:!0,return_hidden:!0}),e.Collision.addStyle("main","main"),a=Math.max.apply(Math,[0].concat(Object.values(t).flatMap(function(e){return Object.values(e.meshes)}).map(function(e){return e[0].labels&&Object.keys(e[0].labels).length}).filter(function(e){return e}))),(l=Math.floor(a/e.Geo.tile_size))>0?e.Collision.initGrid({anchor:{x:Math.min.apply(Math,t.map(function(e){return e.min.x})),y:Math.min.apply(Math,t.map(function(e){return e.min.y}))},span:t[0].span.x/l}):e.Collision.initGrid(),Promise.resolve(e.Collision.collide(s,"main","main")).then(function(e){try{return h=[],(u=e).forEach(function(e){var t=0;!0!==e.show||n&&e.label.breach&&!Oh[e.label.id]||(t=1),t&&(zh[e.label.id]=!0);var r=!0;e.ranges.forEach(function(n){if(r){var i=e.mesh;if(i.valid){for(var o=i.vertex_layout.offset.a_shape,s=i.vertex_layout.stride,a=0;a<n[1];a++){if(i.vertex_data[n[0]+a*s+o+6]===t)return void(r=!1);i.vertex_data[n[0]+a*s+o+6]=t;}-1===h.indexOf(i)&&h.push(i);}}});}),h.forEach(function(e){return e.upload()}),t.forEach(function(e){return e.swapPendingLabels()}),i({labels:u,containers:s})}catch(e){return o(e)}},o)})}function Lh(t,r){if(void 0===r&&(r=null),this.obb)return e.Label.prototype.occluded.call(this,t,r);if(this.obbs)for(var n=0;n<this.obbs.length;n++){var i={aabb:this.aabbs[n],obb:this.obbs[n]};if(e.Label.prototype.occluded.call(i,t,r))return !0}return !1}var Ih=function(){function t(t){var r=t.scene;this.scene=r,this.tiles={},this.pyramid=new Th,this.visible_coords={},this.queued_coords=[],this.building_tiles=null,this.renderable_tiles=[],this.collision={tile_keys:null,mesh_set:null,zoom:null,zoom_steps:3},this.main_thread_target=["TileManager",this.scene.id].join("_"),e.WorkerBroker.addTarget(this.main_thread_target,this);}var r=t.prototype;return r.destroy=function(){this.forEachTile(function(e){return e.destroy()}),this.tiles={},this.pyramid=null,this.visible_coords={},this.queued_coords=[],this.scene=null,e.WorkerBroker.removeTarget(this.main_thread_target);},r.keepTile=function(e){this.tiles[e.key]=e,this.pyramid.addTile(e);},r.hasTile=function(e){return void 0!==this.tiles[e]},r.forgetTile=function(e){if(this.hasTile(e)){var t=this.tiles[e];this.pyramid.removeTile(t);}delete this.tiles[e],this.tileBuildStop(e);},r.removeTile=function(t){e.log("trace","tile unload for "+t);var r=this.tiles[t];null!=r&&r.destroy(),this.forgetTile(r.key),this.scene.requestRedraw();},r.forEachTile=function(e){for(var t in this.tiles)e(this.tiles[t]);},r.removeTiles=function(e){var t=[];for(var r in this.tiles){e(this.tiles[r])&&t.push(r);}for(var n=0;n<t.length;n++){var i=t[n];this.removeTile(i);}},r.updateTilesForView=function(){this.visible_coords={};for(var e=this.view.findVisibleTileCoordinates(),t=0;t<e.length;t++){var r=e[t];this.queueCoordinate(r),this.visible_coords[r.key]=r;}this.updateTileStates();},r.updateTileStates=function(){var e=this;return this.forEachTile(function(t){e.updateVisibility(t);}),this.loadQueuedCoordinates(),this.updateProxyTiles(),this.view.pruneTilesForView(),this.updateRenderableTiles(),this.style_manager.updateActiveStyles(this.renderable_tiles),this.style_manager.updateActiveBlendOrders(this.renderable_tiles),this.updateLabels()},r.updateLabels=function(){var t=this;if(this.scene.building&&!this.scene.building.initial)return Promise.resolve({});var r=this.renderable_tiles.filter(function(e){return e.valid}).filter(function(e){return e.built});return 0===r.length?Promise.resolve({}):(r.sort(function(e,t){return e.build_id<t.build_id?-1:e.build_id>t.build_id?1:0}),this.collision.zoom===Bh(this.view.zoom,this.collision.zoom_steps)&&this.collision.tile_keys===JSON.stringify(r.map(function(e){return e.key}))&&this.collision.mesh_set===Fh(r)?Promise.resolve({}):(this.collision.task||(this.collision.zoom=Bh(this.view.zoom,this.collision.zoom_steps),this.collision.tile_keys=JSON.stringify(r.map(function(e){return e.key})),this.collision.mesh_set=Fh(r),this.collision.task={type:"tileManagerUpdateLabels",run:function(n){return new Promise(function(i,o){var s;return Promise.resolve(Rh(r,t.collision.zoom,t.isLoadingVisibleTiles())).then(function(r){try{return s=r,t.scene.requestRedraw(),t.collision.task=null,e.Task.finish(n,s),t.updateTileStates(),i()}catch(e){return o(e)}},o)})},immediate:!0},e.Task.add(this.collision.task)),this.collision.task.promise))},r.updateProxyTiles=function(){var e=this;if(0!==this.view.zoom_direction){this.forEachTile(function(e){return e.setProxyFor(null)});var t=!1;this.forEachTile(function(r){if(1===e.view.zoom_direction){if(r.visible&&!r.labeled){var n=e.pyramid.getAncestor(r);n&&(n.setProxyFor(r),t=!0);}}else if(-1===e.view.zoom_direction&&r.visible&&!r.labeled)for(var i=e.pyramid.getDescendants(r),o=0;o<i.length;o++)i[o].setProxyFor(r),t=!0;}),t||(this.view.zoom_direction=0);}},r.updateVisibility=function(t){if(t.visible=!1,t.style_z===this.view.tile_zoom)if(this.visible_coords[t.coords.key])t.visible=!0;else for(var r in this.visible_coords)if(e.TileID.isDescendant(t.coords,this.visible_coords[r])){t.visible=!0;break}},r.pruneToVisibleTiles=function(){this.removeTiles(function(e){return !e.visible});},r.getRenderableTiles=function(){return this.renderable_tiles},r.updateRenderableTiles=function(){for(var e in this.renderable_tiles=[],this.tiles){var t=this.tiles[e];t.visible&&t.loaded&&this.renderable_tiles.push(t);}return this.renderable_tiles},r.isLoadingVisibleTiles=function(){var e=this;return Object.keys(this.tiles).some(function(t){return e.tiles[t].visible&&!e.tiles[t].built})},r.allVisibleTilesLabeled=function(){return this.renderable_tiles.every(function(e){return e.labeled})},r.queueCoordinate=function(e){this.queued_coords[this.queued_coords.length]=e;},r.loadQueuedCoordinates=function(){var t=this;0!==this.queued_coords.length&&(this.queued_coords.sort(function(r,n){var i=t.view.center.meters,o=e.Geo.metersPerTile(r.z)/2,s=e.Geo.metersForTile(r);s.x+=o,s.y-=o;var a=e.Geo.metersForTile(n);a.x+=o,a.y-=o;var l=Math.abs(i.x-s.x)+Math.abs(i.y-s.y),u=Math.abs(i.x-a.x)+Math.abs(i.y-a.y);return r.center_dist=l,n.center_dist=u,u>l?-1:u===l?0:1}),this.queued_coords.forEach(function(e){return t.loadCoordinate(e)}),this.queued_coords=[]);},r.loadCoordinate=function(t){if(t.z===this.view.center.tile.z)for(var r in this.scene.sources){var n=this.scene.sources[r];if(n.builds_geometry_tiles&&n.includesTile(t,this.view.tile_zoom)){var i=e.TileID.normalizedKey(t,n,this.view.tile_zoom);if(i&&!this.hasTile(i)){e.log("trace","load tile "+i+", distance from view center: "+t.center_dist);var o=new e.Tile({source:n,coords:t,workers:this.scene.workers,style_z:this.view.baseZoom(t.z),view:this.view});this.keepTile(o),this.buildTile(o);}}}},r.buildTile=function(e,t){this.tileBuildStart(e.key),this.updateVisibility(e),e.build(this.scene.generation,t);},r.buildTileStylesCompleted=function(t){var r=t.tile,n=t.progress;if(null==this.tiles[r.key])e.log("trace","discarded tile "+r.key+" in TileManager.buildTileStylesCompleted because previously removed"),e.Tile.abortBuild(r),this.updateTileStates();else if(r.generation!==this.scene.generation)e.log("trace","discarded tile "+r.key+" in TileManager.buildTileStylesCompleted because built with scene config gen "+r.generation+", current "+this.scene.generation),e.Tile.abortBuild(r),this.updateTileStates();else{if(this.tiles[r.key]){if(r.id<this.tiles[r.key].id)return e.log("trace","discarded tile "+r.key+" for id "+r.id+" in TileManager.buildTileStylesCompleted because built for discarded tile id"),void e.Tile.abortBuild(r);r=this.tiles[r.key].merge(r);}n.done&&(r.built=!0),r.buildMeshes(this.scene.styles,n),this.updateTileStates(),this.scene.requestRedraw();}n.done&&this.tileBuildStop(r.key);},r.buildTileError=function(t){e.log("error","Error building tile "+t.key+":",t.error),this.forgetTile(t.key),e.Tile.abortBuild(t);},r.tileBuildStart=function(t){this.building_tiles=this.building_tiles||{},this.building_tiles[t]=!0,e.log("trace","tileBuildStart for "+t+": "+Object.keys(this.building_tiles).length);},r.tileBuildStop=function(t){this.building_tiles&&(e.log("trace","tileBuildStop for "+t+": "+Object.keys(this.building_tiles).length),delete this.building_tiles[t],this.checkBuildQueue());},r.checkBuildQueue=function(){this.building_tiles&&0!==Object.keys(this.building_tiles).length||(this.building_tiles=null,this.scene.tileManagerBuildDone());},r.getDebugProp=function(e,t){var r=[];for(var n in this.tiles)null==this.tiles[n].debug[e]||"function"==typeof t&&!0!==t(this.tiles[n])||r.push(this.tiles[n].debug[e]);return r},r.getDebugSum=function(e,t){var r=0;for(var n in this.tiles)null==this.tiles[n].debug[e]||"function"==typeof t&&!0!==t(this.tiles[n])||(r+=this.tiles[n].debug[e]);return r},r.getDebugAverage=function(e,t){return this.getDebugSum(e,t)/Object.keys(this.tiles).length},e._createClass(t,[{key:"view",get:function(){return this.scene.view}},{key:"style_manager",get:function(){return this.scene.style_manager}}]),t}();function Bh(e,t,r){return void 0===r&&(r=2),(Math.floor(e*t)/t).toFixed(r)}function Fh(e){return JSON.stringify(Object.entries(e).map(function(e){var t=e[1];return Object.entries(t.meshes).map(function(e){return e[1].map(function(e){return e.created_at})})}))}var Ph=function(){function e(e,t){t(e),this.value=e,this.setup=t;}return e.prototype.set=function(e){JSON.stringify(this.value)!==JSON.stringify(e)&&(this.setup(e),this.value=e);},e}(),Mh=function(e){this.defaults={},this.defaults.culling=!0,this.defaults.culling_face=e.BACK,this.defaults.blending=!1,this.defaults.blending_src=e.ONE_MINUS_SRC_ALPHA,this.defaults.blending_dst=e.ONE_MINUS_SRC_ALPHA,this.defaults.blending_src_alpha=e.ONE,this.defaults.blending_dst_alpha=e.ONE_MINUS_SRC_ALPHA,this.defaults.depth_write=!0,this.defaults.depth_test=!0,e.depthFunc(e.LESS),this.culling=new Ph({cull:this.defaults.culling,face:this.defaults.culling_face},function(t){t.cull?(e.enable(e.CULL_FACE),e.cullFace(t.face)):e.disable(e.CULL_FACE);}),this.blending=new Ph({blend:this.defaults.blending,src:this.defaults.blending_src,dst:this.defaults.blending_dst,src_alpha:this.defaults.blending_src_alpha,dst_alpha:this.defaults.blending_dst_alpha},function(t){t.blend?(e.enable(e.BLEND),t.src_alpha&&t.dst_alpha?e.blendFuncSeparate(t.src,t.dst,t.src_alpha,t.dst_alpha):e.blendFunc(t.src,t.dst)):e.disable(e.BLEND);}),this.depth_write=new Ph({depth_write:this.defaults.depth_write},function(t){e.depthMask(t.depth_write);}),this.depth_test=new Ph({depth_test:this.defaults.depth_test},function(t){t.depth_test?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST);});};e.require$$0$4("Uint8",1,function(e){return function(t,r,n){return e(this,t,r,n)}},!0);var jh=function(){function t(){this.canvas=null,this.gl=null,this.screenshot_canvas=null,this.screenshot_context=null,this.queue_screenshot=null,this.video_capture=null;}var r=t.prototype;return r.setCanvas=function(e,t){this.canvas=e,this.gl=t;},r.screenshot=function(e){var t=this,r=(void 0===e?{}:e).background;return null!=this.queue_screenshot?this.queue_screenshot.promise:(this.queue_screenshot={background:r},this.queue_screenshot.promise=new Promise(function(e,r){t.queue_screenshot.resolve=e,t.queue_screenshot.reject=r;}),this.queue_screenshot.promise)},r.completeScreenshot=function(){if(null!=this.queue_screenshot){var t=this.canvas.width,r=this.canvas.height,n=new Uint8Array(t*r*4);this.gl.readPixels(0,0,t,r,this.gl.RGBA,this.gl.UNSIGNED_BYTE,n);var i=this.queue_screenshot.background;i=i&&"transparent"!==i?e.StyleParser.parseColor(i).slice(0,3).map(function(e){return 255*e}):null;for(var o=new Uint8ClampedArray(t*r*4),s=0;s<r;s++)for(var a=0;a<t;a++){var l=4*((r-s-1)*t+a),u=4*(s*t+a),h=n[l+3];o[u+0]=255*n[l+0]/h,o[u+1]=255*n[l+1]/h,o[u+2]=255*n[l+2]/h,o[u+3]=h,i&&(h/=255,o[u+0]=o[u+0]*h+i[0]*(1-h),o[u+1]=o[u+1]*h+i[1]*(1-h),o[u+2]=o[u+2]*h+i[2]*(1-h),o[u+3]=255);}this.screenshot_canvas=this.screenshot_canvas||document.createElement("canvas");var c=this.screenshot_canvas;c.width=t,c.height=r,this.screenshot_context=this.screenshot_context||c.getContext("2d");var f=this.screenshot_context,d=new ImageData(o,t,r);f.putImageData(d,0,0);for(var p=c.toDataURL("image/png"),g=atob(p.slice(22)),m=new Uint8Array(g.length),v=0;v<g.length;++v)m[v]=g.charCodeAt(v);var y=new Blob([m],{type:"image/png"});this.queue_screenshot.resolve({url:p,blob:y,type:"png"}),this.queue_screenshot=null;}},r.startVideoCapture=function(){var t=this;if("function"!=typeof window.MediaRecorder||!this.canvas||"function"!=typeof this.canvas.captureStream)return e.log("warn","Video capture (Canvas.captureStream and/or MediaRecorder APIs) not supported by browser"),!1;if(this.video_capture)return e.log("warn","Video capture already in progress, call Scene.stopVideoCapture() first"),!1;try{var r=this.video_capture={};r.chunks=[],r.stream=this.canvas.captureStream(),r.options={mimeType:"video/webm"},r.media_recorder=new MediaRecorder(r.stream,r.options),r.media_recorder.ondataavailable=function(n){if(n.data.size>0&&r.chunks.push(n.data),r.resolve){var i=new Blob(r.chunks,{type:r.options.mimeType}),o=e.createObjectURL(i);if(r.stream)(r.stream.getTracks()||[]).forEach(function(e){e.stop(),r.stream.removeTrack(e);});r.stream=null,r.media_recorder=null,t.video_capture=null,r.resolve({url:o,blob:i,type:"webm"});}},r.media_recorder.start();}catch(t){return this.video_capture=null,e.log("error","Scene video capture failed",t),!1}return !0},r.stopVideoCapture=function(){var t=this;return this.video_capture?(this.video_capture.promise=new Promise(function(e,r){t.video_capture.resolve=e,t.video_capture.reject=r;}),this.video_capture.media_recorder.stop(),this.video_capture.promise):(e.log("warn","No scene video capture in progress, call Scene.startVideoCapture() first"),Promise.resolve({}))},t}();var Uh,Dh=function(){function t(r,n){var i;n=n||{},e.subscribeMixin(this),this.id=t.id++,this.initialized=!1,this.initializing=null,this.sources={},this.view=new e.View(this,n),this.tile_manager=new Ih({scene:this}),this.num_workers=n.numWorkers||2,!0===n.disableVertexArrayObjects&&(e.VertexArrayObject.disabled=!0),e.Utils.use_high_density_display=void 0===n.highDensityDisplay||n.highDensityDisplay,e.Utils.updateDevicePixelRatio(),this.config=null,this.config_source=r,this.config_bundle=null,this.last_valid_config_source=null,this.styles=null,this.style_manager=new e.StyleManager,this.building=null,this.dirty=!0,n.preUpdate&&this.subscribe({pre_update:n.preUpdate}),n.postUpdate&&this.subscribe({post_update:n.postUpdate}),this.render_loop=!n.disableRenderLoop,this.render_loop_active=!1,this.render_loop_stop=!1,this.render_count=0,this.last_render_count=0,this.render_count_changed=!1,this.frame=0,this.last_main_render=-1,this.last_selection_render=-1,this.media_capture=new jh,this.selection=null,this.selection_feature_count=0,this.fetching_selection_map=null,this.prev_textures=null,this.introspection=!0===n.introspection,this.times={},this.resetTime(),this.container=n.container,this.canvas=null,this.contextOptions=n.webGLContextOptions,this.lights=null,this.background=null,this.createListeners(),this.updating=0,this.generation=t.generation,this.last_complete_generation=t.generation,(i=this).debug={profile:function(t){console.profile("main thread: "+t),e.WorkerBroker.postMessage(i.workers,"self.profile",t);},profileEnd:function(t){console.profileEnd("main thread: "+t),e.WorkerBroker.postMessage(i.workers,"self.profileEnd",t);},timeRebuild:function(t,r){void 0===t&&(t=1),void 0===r&&(r={});var n=[];!function o(){var s=+new Date;i.rebuild(r).then(function(){if(n.push(+new Date-s),n.length<t)o();else{var r=~~(n.reduce(function(e,t){return e+t})/n.length);e.log("info","Profiled rebuild "+t+" times: "+r+" avg ("+Math.min.apply(Math,n)+" min, "+Math.max.apply(Math,n)+" max)");}});}();},geometryCountByStyle:function(){var e={};return i.tile_manager.getRenderableTiles().forEach(function(t){var r=function(r){e[r]=e[r]||0,t.meshes[r].forEach(function(t){e[r]+=t.geometry_count;});};for(var n in t.meshes)r(n);}),e},geometryCountByBaseStyle:function(){var e=i.debug.geometryCountByStyle(),t={};for(var r in e){var n=i.styles[r].baseStyle();t[n]=t[n]||0,t[n]+=e[r];}return t},geometryCountTotal:function(){var e=i.debug.geometryCountByStyle();return Object.keys(e).reduce(function(t,r){return e[r]+t},0)},geometrySizeByStyle:function(){var e={};return i.tile_manager.getRenderableTiles().forEach(function(t){var r=function(r){e[r]=e[r]||0,t.meshes[r].forEach(function(t){e[r]+=t.buffer_size;});};for(var n in t.meshes)r(n);}),e},geometrySizeByBaseStyle:function(){var e=i.debug.geometrySizeByStyle(),t={};for(var r in e){var n=i.styles[r].baseStyle();t[n]=t[n]||0,t[n]+=e[r];}return t},geometrySizeTotal:function(){var e=i.debug.geometrySizeByStyle();return Object.keys(e).reduce(function(t,r){return e[r]+t},0)},textureSizeTotal:function(){return Object.values(e.Texture.textures).map(function(e){return e.byteSize()}).reduce(function(e,t){return e+t})},layerStats:function(){return e.debugSettings.layer_stats?e.debugSumLayerStats(i.tile_manager.getRenderableTiles()):(e.log("warn","Enable the 'layer_stats' debug setting to collect layer stats"),{})},renderableTilesCount:function(){return i.tile_manager.getRenderableTiles().length}},this.log_level=n.logLevel||"warn",e.log.setLevel(this.log_level),e.log.reset();}t.create=function(e,r){return void 0===r&&(r={}),new t(e,r)};var r=t.prototype;return r.load=function(t,r){var n=this;return void 0===t&&(t=null),void 0===r&&(r={}),this.initializing?this.initializing:(e.log.reset(),this.updating++,this.initialized=!1,this.view_complete=!1,this.times.frame=null,this.times.build=null,(r="string"==typeof r?{base_path:r}:r).blocking=void 0===r.blocking||r.blocking,!1!==this.render_loop&&this.setupRenderLoop(),this.createCanvas(),this.prev_textures=this.config&&Object.keys(this.config.textures),this.initializing=this.loadScene(t,r).then(function(){return n.createWorkers()}).then(function(){n.destroyFeatureSelection(),e.WorkerBroker.postMessage(n.workers,"self.clearFunctionStringCache");var t="object"==typeof n.config_source||n.hasSubscribersFor("load"),i=n.updateConfig({serialize_funcs:t,normalize:!1,loading:!0,fade_in:!0});if(!0===r.blocking)return i}).then(function(){n.freePreviousTextures(),n.updating--,n.initializing=null,n.initialized=!0,n.last_valid_config_source=n.config_source,n.last_valid_options={base_path:r.base_path,file_type:r.file_type},n.requestRedraw();}).catch(function(t){var r,i;if(n.initializing=null,n.updating=0,"YAMLException"===t.name?(r="yaml",i="Error parsing scene YAML"):i="Error initializing scene",n.trigger("error",{type:r,message:i,error:t,url:n.config_source}),i="Scene.load() failed to load "+JSON.stringify(n.config_source)+": "+t.message,n.last_valid_config_source)return e.log("warn",i,t),e.log("info","Scene.load() reverting to last valid configuration"),n.load(n.last_valid_config_source,n.last_valid_base_path);throw e.log("error",i,t),t}),this.initializing)},r.destroy=function(){if(this.initialized=!1,this.render_loop_stop=!0,this.destroyListeners(),this.destroyFeatureSelection(),this.canvas&&this.canvas.parentNode&&(this.canvas.parentNode.removeChild(this.canvas),this.canvas=null),this.container=null,this.gl){e.Texture.destroy(this.gl),this.style_manager.destroy(this.gl),this.styles={},e.ShaderProgram.reset();var t=this.gl.getExtension("WEBGL_lose_context");t&&t.loseContext(),this.gl=null;}this.sources={},this.destroyWorkers(),this.tile_manager.destroy(),this.tile_manager=null,e.log.reset();},r.createCanvas=function(){if(!this.canvas){this.container=this.container||document.body,this.canvas=document.createElement("canvas"),this.canvas.style.position="absolute",this.canvas.style.top=0,this.canvas.style.left=0,this.container.style.backgroundColor="transparent",this.container.appendChild(this.canvas);try{this.gl=U.getContext(this.canvas,Object.assign({alpha:!0,premultipliedAlpha:!0,stencil:!0,device_pixel_ratio:e.Utils.device_pixel_ratio,powerPreference:"high-performance"},this.contextOptions));}catch(e){throw new Error("Couldn't create WebGL context. Your browser may not support WebGL, or it's turned off? Visit http://webglreport.com/ for more info.")}this.resizeMap(this.container.clientWidth,this.container.clientHeight),e.VertexArrayObject.init(this.gl),this.render_states=new Mh(this.gl),this.media_capture.setCanvas(this.canvas,this.gl);}},r.updateExternalScripts=function(){var e=[].concat(this.external_scripts||[]),t=[];if(this.config.scene.scripts)for(var r in this.config.scene.scripts)-1===t.indexOf(this.config.scene.scripts[r])&&t.push(this.config.scene.scripts[r]);for(var n in this.config.sources){var i=this.config.sources[n];if(i.scripts)for(var o in i.scripts)-1===t.indexOf(i.scripts[o])&&t.push(i.scripts[o]);}return this.external_scripts=t,!(this.external_scripts.length===e.length&&this.external_scripts.every(function(t,r){return t===e[r]}))},r.createWorkers=function(){return this.updateExternalScripts()&&this.destroyWorkers(),this.workers?Promise.resolve():this.makeWorkers()},r.makeWorkers=function(){var t=this,r=!!this.gl.getExtension("OES_element_index_uint"),n=[];this.workers=[];for(var i=function(i){var o=new Worker(Tangram.workerURL);t.workers[i]=o,e.WorkerBroker.addWorker(o),e.log("debug","Scene.makeWorkers: initializing worker "+i);var s=i;n.push(e.WorkerBroker.postMessage(o,"self.init",t.id,i,t.num_workers,t.log_level,e.Utils.device_pixel_ratio,r,t.external_scripts).then(function(t){return e.log("debug","Scene.makeWorkers: initialized worker "+t),t},function(t){return e.log("error","Scene.makeWorkers: failed to initialize worker "+s+":",t),Promise.reject(t)}));},o=0;o<this.num_workers;o++)i(o);return this.next_worker=0,Promise.all(n).then(function(){e.log.setWorkers(t.workers);})},r.destroyWorkers=function(){this.selection=null,Array.isArray(this.workers)&&(e.log.setWorkers(null),this.workers.forEach(function(e){e.terminate();}),this.workers=null);},r.ready=function(){return !(!this.view.ready()||0===Object.keys(this.sources).length)},r.updateDevicePixelRatio=function(){var t=this;e.Utils.updateDevicePixelRatio()&&e.WorkerBroker.postMessage(this.workers,"self.updateDevicePixelRatio",e.Utils.device_pixel_ratio).then(function(){return t.rebuild()}).then(function(){return t.resizeMap(t.view.size.css.width,t.view.size.css.height)});},r.resizeMap=function(t,r){0===t&&0===r||(this.dirty=!0,this.view.setViewportSize(t,r),this.gl&&U.resize(this.gl,t,r,e.Utils.device_pixel_ratio));},r.requestRedraw=function(){this.dirty=!0;},r.immediateRedraw=function(){this.dirty=!0,this.update();},r.renderLoop=function(){this.render_loop_active=!0,this.update(),e.Task.setState({user_moving_view:this.view.user_input_active}),e.Task.processAll(),this.render_loop_stop?(this.render_loop_stop=!1,this.render_loop_active=!1):window.requestAnimationFrame(this.renderLoop.bind(this));},r.setupRenderLoop=function(){var e=this;this.render_loop_active||setTimeout(function(){e.renderLoop();},0);},r.update=function(){var t=this.dirty,r=!!this.selection&&this.selection.hasPendingRequests(),n=!(!1===t&&!1===r||!1===this.initialized||this.updating>0||!1===this.ready());return this.trigger("pre_update",n),this.view.update(),!!n&&(this.dirty=!1,this.updateDevicePixelRatio(),this.render({main:t,selection:r}),this.updateViewComplete(),this.media_capture.completeScreenshot(),this.trigger("post_update",n),(!0===this.animated||this.view.isAnimating())&&(this.dirty=!0),this.frame++,e.log("trace","Scene.render()"),!0)},r.render=function(t){var r=this,n=t.main,i=t.selection,o=this.gl;if(this.updateBackground(),Object.keys(this.lights).forEach(function(e){return r.lights[e].update()}),this.render_count_changed=!1,n&&(this.render_count=this.renderPass(),this.last_main_render=this.frame,this.render_count!==this.last_render_count&&(this.render_count_changed=!0,this.logFirstFrame(),this.getFeatureSelectionMapSize().then(function(t){r.selection_feature_count=t,e.log("info","Scene: rendered "+r.render_count+" primitives ("+t+" features in selection map)");})),this.last_render_count=this.render_count),i){if(this.view.panning||this.view.user_input_active)return void this.selection.clearPendingRequests();!this.selection.locked&&this.last_selection_render<this.last_main_render&&(this.selection.bind(),this.renderPass("selection_program",{allow_blend:!1}),o.bindFramebuffer(o.FRAMEBUFFER,null),o.viewport(0,0,this.canvas.width,this.canvas.height),o.clearColor.apply(o,this.background.computed_color),this.last_selection_render=this.frame),this.selection.read();}return !0},r.renderPass=function(t,r){var n=this;void 0===t&&(t="program");var i=(void 0===r?{}:r).allow_blend;i=null==i||i,this.clearFrame();var o,s=0,a=this.style_manager.getActiveBlendOrders(),l=Array.isArray(a),u=0;for(a=l?a:a[Symbol.iterator]();;){var h;if(l){if(u>=a.length)break;h=a[u++];}else{if((u=a.next()).done)break;h=u.value;}for(var c=h,f=c.blend_order,d=c.styles,p=function(r){var a=n.styles[d[r]];if(null==a)return "continue";if(a.blend!==o){var l=Object.assign({},e.Style.render_states[a.blend],{blend:i&&a.blend});n.setRenderState(l);}var u=i&&a.blend;if("translucent"===u)n.gl.colorMask(!1,!1,!1,!1),n.renderStyle(a.name,t,f),n.gl.colorMask(!0,!0,!0,!0),n.gl.depthFunc(n.gl.EQUAL),n.gl.enable(n.gl.STENCIL_TEST),n.gl.clearStencil(0),n.gl.clear(n.gl.STENCIL_BUFFER_BIT),n.gl.stencilFunc(n.gl.EQUAL,n.gl.ZERO,255),n.gl.stencilOp(n.gl.KEEP,n.gl.KEEP,n.gl.INCR),s+=n.renderStyle(a.name,t,f),n.gl.disable(n.gl.STENCIL_TEST),n.gl.depthFunc(n.gl.LESS);else if("opaque"!==u&&!0===a.stencil_proxy_tiles){var h=n.tile_manager.getRenderableTiles().filter(function(e){return e.meshes[a.name]}).map(function(e){return e.proxy_level}).reduce(function(e,t){return e.indexOf(t)>-1||e.push(t),e},[]).sort();if(h.length>1){n.gl.enable(n.gl.STENCIL_TEST),n.gl.clearStencil(0),n.gl.clear(n.gl.STENCIL_BUFFER_BIT),n.gl.stencilOp(n.gl.KEEP,n.gl.KEEP,n.gl.REPLACE);for(var c=0;c<h.length;c++)n.gl.stencilFunc(n.gl.GEQUAL,h.length-c,255),s+=n.renderStyle(a.name,t,f,h[c]);n.gl.disable(n.gl.STENCIL_TEST);}else s+=n.renderStyle(a.name,t,f);}else s+=n.renderStyle(a.name,t,f);o=a.blend;},g=0;g<d.length;g++)p(g);}return s},r.renderStyle=function(e,t,r,n){var i=this;void 0===n&&(n=null);for(var o,s=this.styles[e],a=!0,l=0,u=this.tile_manager.getRenderableTiles().filter(function(e){return "number"!=typeof n||e.proxy_level===n}).map(function(t){if(t.meshes[e])return [t,t.meshes[e].filter(function(e){return e.variant.blend_order===r})]}).filter(function(e){return e}),h=Math.max.apply(Math,u.map(function(e){var t=e[1];return Math.max.apply(Math,t.map(function(e){return e.variant.mesh_order}))})),c=function(r){var n=function(){if(c){if(f>=h.length)return "break";d=h[f++];}else{if((f=h.next()).done)return "break";d=f.value;}var n=d,u=n[0],p=n[1],g=!0;if(!u.shouldProxyForStyle(e))return "continue";var m=p.filter(function(e){return e.variant.mesh_order===r});return 0===m.length?"continue":!0!==a||(a=!1,o=i.setupStyle(s,t))?void m.forEach(function(e){!0===g&&(g=!1,i.view.setupTile(u,o)),s.render(e)&&i.requestRedraw(),l+=e.geometry_count;}):{v:{v:0}}};var h=u,c=Array.isArray(h),f=0;e:for(h=c?h:h[Symbol.iterator]();;){var d,p=n();switch(p){case"break":break e;case"continue":continue;default:if("object"==typeof p)return p.v}}},f=0;f<h+1;f++){var d=c(f);if("object"==typeof d)return d.v}return l},r.setupStyle=function(e,t){var r;try{if(!(r=e.getProgram(t)))return}catch(t){return void this.trigger("warning",{type:"styles",message:"Error compiling style "+e.name,style:e,shader_errors:e.program&&e.program.shader_errors})}for(var n in r.use(),e.setup(),r.uniform("1f","u_time",this.animated?(+new Date-this.start_time)/1e3:0),this.view.setupProgram(r),this.lights)this.lights[n].setupProgram(r);return r},r.clearFrame=function(){this.initialized&&(this.render_states.depth_write.set({depth_write:!0}),this.gl.clear(this.gl.COLOR_BUFFER_BIT|this.gl.DEPTH_BUFFER_BIT|this.gl.STENCIL_BUFFER_BIT));},r.setRenderState=function(e){var t=void 0===e?{}:e,r=t.depth_test,n=t.depth_write,i=t.cull_face,o=t.blend;if(this.initialized){var s=this.render_states;r=!1!==r&&s.defaults.depth_test,n=!1!==n&&s.defaults.depth_write,i=!1!==i&&s.defaults.culling,o=null!=o?o:s.defaults.blending;var a=this.gl;s.depth_test.set({depth_test:r}),s.depth_write.set({depth_write:n}),s.culling.set({cull:i,face:s.defaults.culling_face}),o?"opaque"===o?s.blending.set({blend:!1}):"overlay"===o||"inlay"===o||"translucent"===o?s.blending.set({blend:!0,src:a.SRC_ALPHA,dst:a.ONE_MINUS_SRC_ALPHA,src_alpha:a.ONE,dst_alpha:a.ONE_MINUS_SRC_ALPHA}):"add"===o?s.blending.set({blend:!0,src:a.ONE,dst:a.ONE}):"multiply"===o&&s.blending.set({blend:!0,src:a.ZERO,dst:a.SRC_COLOR}):s.blending.set({blend:!1});}},r.getFeatureAt=function(t,r){var n=(void 0===r?{}:r).radius;if(!this.initialized)return e.log("debug","Scene.getFeatureAt() called before scene was initialized"),Promise.resolve();if(0===this.selection_feature_count)return Promise.resolve();this.selection||this.resetFeatureSelection();var i={x:t.x/this.view.size.css.width,y:t.y/this.view.size.css.height};return n=n>0?{x:n/this.view.size.css.width,y:n/this.view.size.css.height}:null,this.selection.getFeatureAt(i,{radius:n}).then(function(e){return Object.assign(e,{pixel:t})}).catch(function(e){return Promise.resolve({error:e})})},r.queryFeatures=function(t){return new Promise(function(r,n){var i,o,s,a,l,u,h,c,f,d,p,g,m,v,y,_,b;return o=(i=void 0===t?{}:t).filter,s=i.unique,a=void 0===s||s,l=i.group_by,u=void 0===l?null:l,c=void 0===(h=i.visible)?null:h,f=i.geometry,d=void 0!==f&&f,this.initialized?(o=e.Utils.serializeWithFunctions(o),p=!0===(a="string"==typeof a?[a]:a)||Array.isArray(a)&&a.indexOf("$id")>-1,g=a&&function(t){var r=Array.isArray(a)?e.sliceObject(t.properties,a):t.properties,n=p?t.id:null;return d?JSON.stringify({geometry:t.geometry,properties:r,id:n}):JSON.stringify({properties:r,id:n})},u=("string"==typeof u||Array.isArray(u))&&u,m=u&&function(t){return Array.isArray(u)?JSON.stringify(e.sliceObject(t,u)):t[u]},v=this.tile_manager.getRenderableTiles().map(function(e){return e.key}),Promise.resolve(e.WorkerBroker.postMessage(this.workers,"self.queryFeatures",{filter:o,visible:c,geometry:d,tile_keys:v})).then(function(e){try{return y=[],_={},b={},e.forEach(function(e){return e.forEach(function(e){if(g){var t=g(e);if(_[t])return;_[t]=!0;}if(m){var r=m(e.properties);b[r]=b[r]||[],b[r].push(e);}else y.push(e);})}),r(m?b:y)}catch(e){return n(e)}},n)):r([])}.bind(this))},r.rebuild=function(r){var n=this,i=void 0===r?{}:r,o=i.initial,s=void 0!==o&&o,a=i.new_generation,l=void 0===a||a,u=i.sources,h=void 0===u?null:u,c=i.serialize_funcs,f=i.profile,d=void 0!==f&&f,p=i.fade_in,g=void 0!==p&&p;return new Promise(function(r,i){if(n.building){n.building.queued&&n.building.queued.reject&&(e.log("debug","Scene.rebuild: request superceded by a newer call"),n.building.queued.resolve(!1));var o={initial:s,new_generation:l,sources:h,serialize_funcs:c,profile:d,fade_in:g};return n.building.queued={resolve:r,reject:i,options:o},void e.log("trace","Scene.rebuild(): queuing request")}if(n.building={resolve:r,reject:i,initial:s},d&&n.debug.profile("Scene.rebuild"),l)for(var a in n.generation=++t.generation,n.styles)n.styles[a].setGeneration(n.generation);n.syncConfigToWorker({serialize_funcs:c}),n.resetWorkerFeatureSelection(h),n.resetTime(),n.tile_manager.pruneToVisibleTiles(),n.tile_manager.forEachTile(function(e){(!h||h.indexOf(e.source.name)>-1)&&n.tile_manager.buildTile(e,{fade_in:g});}),n.tile_manager.updateTilesForView(),n.tile_manager.checkBuildQueue();}).then(function(){d&&n.debug.profileEnd("Scene.rebuild");})},r.tileManagerBuildDone=function(){if(e.TextCanvas.pruneTextCache(),this.building){e.log("info","Scene: build geometry finished"),this.building.resolve&&(this.logFirstBuild(),this.building.resolve(!0));var t=this.building.queued;this.building=null,t?(e.log("debug","Scene: starting queued rebuild() request"),this.rebuild(t.options).then(t.resolve,t.reject)):this.tile_manager.updateLabels();}},r.loadScene=function(t,r){var n=this;void 0===t&&(t=null);var i=void 0===r?{}:r,o=i.base_path,s=i.file_type;return this.config_source=t||this.config_source,"string"==typeof this.config_source?this.base_path=e.pathForURL(o||this.config_source):this.base_path=e.pathForURL(o),this.config_path=this.base_path,Ah.loadScene(this.config_source,{path:this.base_path,type:s}).then(function(e){var t=e.config,r=e.bundle;return n.config=t,n.config_bundle=r,n.config})},r.setDataSource=function(t,r){if(t&&r&&r.type&&(r.url||r.data)){var n=null==this.config.sources[t],i=this.config.sources[t]=Object.assign({},r);return i.data&&"object"==typeof i.data&&(i.url=e.createObjectURL(new Blob([JSON.stringify(i.data)])),delete i.data),n?this.updateConfig({rebuild:{sources:[t]}}):this.rebuild({sources:[t]})}e.log("error","No name provided or not a valid config:",t,r);},r.createDataSources=function(t){var r=this;void 0===t&&(t=!1);var n=[],i=Object.keys(this.sources),o=0;for(var s in this.config.sources){var a=this.config.sources[s],l=this.sources[s];try{var u=Object.assign({},a,{name:s,id:o++});if(this.sources[s]=e.DataSource.create(u,this.sources),!this.sources[s])throw{}}catch(t){delete this.sources[s];var h="Could not create data source: "+t.message;e.log("warn","Scene: "+h,a),this.trigger("warning",{type:"sources",source:a,message:h});}(t||e.DataSource.tileLayoutChanged(this.sources[s],l))&&n.push(s);}for(var c in i.forEach(function(e){r.config.sources[e]||(delete r.sources[e],n.push(e));}),n.length>0&&this.tile_manager.removeTiles(function(e){return n.indexOf(e.source.name)>-1}),this.config.layers){var f=this.config.layers[c];!1!==f.enabled&&f.data&&this.sources[f.data.source]&&(this.sources[f.data.source].builds_geometry_tiles=!0);}},r.loadTextures=function(){var t=this;return e.Texture.createFromObject(this.gl,this.config.textures).then(function(){return e.Texture.createDefault(t.gl)})},r.freePreviousTextures=function(){var t=this;this.prev_textures&&(this.prev_textures.forEach(function(r){!t.config.textures[r]&&e.Texture.textures[r]&&e.Texture.textures[r].destroy();}),this.prev_textures=null);},r.updateStyles=function(){if(!this.initialized&&!this.initializing)throw new Error("Scene.updateStyles() called before scene was initialized");for(var e in this.styles=this.style_manager.build(this.config.styles),this.style_manager.initStyles(this),this.styles)this.styles[e].setGL(this.gl);this.dirty=!0;},r.getActiveCamera=function(){return this.view.getActiveCamera()},r.setActiveCamera=function(e){return this.view.setActiveCamera(e)},r.createLights=function(){for(var t in this.lights={},this.config.lights)if(this.config.lights[t]&&"object"==typeof this.config.lights[t]){var r=this.config.lights[t];r.name=t.replace("-","_"),r.visible=!1!==r.visible,r.visible&&(this.lights[r.name]=e.Light.create(this.view,r));}e.Light.inject(this.lights);},r.setBackground=function(){var t=this.config.scene.background;this.background={},t&&t.color&&(this.background.color=e.StyleParser.createColorPropertyCache(t.color)),this.background.color||(this.background.color=e.StyleParser.createColorPropertyCache([0,0,0,0]));},r.updateBackground=function(){var t,r=this.background.computed_color,n=this.background.computed_color=e.StyleParser.evalCachedColorProperty(this.background.color,{zoom:this.view.tile_zoom});r&&!n.some(function(e,t){return r[t]!==e})||(1===n[3]?this.canvas.style.backgroundColor="rgba("+n.map(function(e){return Math.floor(255*e)}).join(", ")+")":this.canvas.style.backgroundColor="transparent",(t=this.gl).clearColor.apply(t,n));},r.setIntrospection=function(e){var t=this;return e!==this.introspection?(this.introspection=null!=e&&e,this.updating++,this.updateConfig({normalize:!1}).then(function(){return t.updating--})):Promise.resolve()},r.updateConfig=function(r){var n=this,i=void 0===r?{}:r,o=i.loading,s=void 0!==o&&o,a=i.rebuild,l=void 0===a||a,u=i.serialize_funcs,h=i.normalize,c=void 0===h||h,f=i.fade_in,d=void 0!==f&&f;this.generation=++t.generation,this.updating++,this.config=Ah.applyGlobalProperties(this.config),c?Ah.normalize(this.config,this.config_bundle):(Ah.hoistStyleShaderUniformTextures(this.config,this.config_bundle,{include_globals:!0}),Ah.normalizeTextures(this.config,this.config_bundle)),this.trigger(s?"load":"update",{config:this.config}),this.style_manager.init(),this.view.reset(),this.createLights(),this.createDataSources(s),this.loadTextures(),this.setBackground(),e.FontManager.loadFonts(this.config.fonts),this.updateStyles();var p=l?this.rebuild(Object.assign({initial:s,new_generation:!1,serialize_funcs:u,fade_in:d},"object"==typeof l&&l)):this.syncConfigToWorker({serialize_funcs:u});return this.updating--,this.view.updateBounds(),this.requestRedraw(),p.then(function(){n.last_render_count=0,n.requestRedraw();})},r.syncConfigToWorker=function(t){var r=(void 0===t?{}:t).serialize_funcs,n=void 0===r||r?e.Utils.serializeWithFunctions(this.config):JSON.stringify(this.config);return e.WorkerBroker.postMessage(this.workers,"self.updateConfig",{config:n,generation:this.generation,introspection:this.introspection},e.debugSettings)},r.createListeners=function(){var t=this;this.listeners={},this.listeners.view={move:function(){return t.trigger("move")}},this.view.subscribe(this.listeners.view),this.listeners.texture={update:function(){return t.dirty=!0},warning:function(e){return t.trigger("warning",Object.assign({type:"textures"},e))}},e.Texture.subscribe(this.listeners.texture),this.listeners.scene_loader={error:function(e){return t.trigger("error",Object.assign({type:"scene"},e))}},Ah.subscribe(this.listeners.scene_loader);},r.destroyListeners=function(){this.unsubscribeAll(),this.view.unsubscribe(this.listeners.view),e.Texture.unsubscribe(this.listeners.texture),Ah.unsubscribe(this.listeners.scene_loader),this.listeners=null;},r.destroyFeatureSelection=function(){this.selection&&(this.selection.destroy(),this.selection=null);},r.resetFeatureSelection=function(){var t=this;this.selection=new e.FeatureSelection(this.gl,this.workers,function(){return t.building}),this.last_render_count=0;},r.resetWorkerFeatureSelection=function(t){void 0===t&&(t=null),this.workers&&e.WorkerBroker.postMessage(this.workers,"self.resetFeatureSelection",t);},r.getFeatureSelectionMapSize=function(){var t=this;return null==this.fetching_selection_map&&(this.fetching_selection_map=e.WorkerBroker.postMessage(this.workers,"self.getFeatureSelectionMapSize").then(function(e){return t.fetching_selection_map=null,e.reduce(function(e,t){return e+t})})),this.fetching_selection_map},r.resetTime=function(){this.start_time=+new Date;},r.updateViewComplete=function(){!this.render_count_changed&&this.generation===this.last_complete_generation||this.building||this.tile_manager.isLoadingVisibleTiles()||!this.tile_manager.allVisibleTilesLabeled()||(this.tile_manager.updateLabels(),this.last_complete_generation=this.generation,this.trigger("view_complete",{first:!0!==this.view_complete}),this.view_complete=!0);},r.resetViewComplete=function(){this.last_complete_generation=null;},r.screenshot=function(e){var t=(void 0===e?{}:e).background,r=void 0===t?"white":t;return this.requestRedraw(),this.media_capture.screenshot({background:r})},r.startVideoCapture=function(){return this.requestRedraw(),this.media_capture.startVideoCapture()},r.stopVideoCapture=function(){return this.media_capture.stopVideoCapture()},r.logFirstFrame=function(){0!==this.last_render_count||this.times.first_frame||(this.times.first_frame=+new Date-this.start_time,e.log("debug","Scene: initial frame time: "+this.times.first_frame));},r.logFirstBuild=function(){null==this.times.first_build&&(this.times.first_build=+new Date-this.start_time,e.log("debug","Scene: initial build time: "+this.times.first_build));},e._createClass(t,[{key:"animated",get:function(){var e=this;return !1!==this.config.scene.animated&&this.style_manager.getActiveStyles().some(function(t){return e.styles[t].animated})}}]),t}();Dh.id=0,Dh.generation=0;var Nh={map:{},scrollWheelZoom:{},doubleClickZoom:{}};return {leafletLayer:function(t){return function(t){if(void 0!==Uh)return new Uh(t);if(e.Thread.is_main){var r,n=t.leaflet||window.L,i=n.GridLayer?n.GridLayer:n.TileLayer,o=i===n.GridLayer?"1.x":"0.7.x",s={};return i===n.TileLayer&&(s._addTile=function(){},s._removeTile=function(){},s._reset=function(){i.prototype._reset.apply(this,arguments),this.scene&&this.scene.container&&this.scene.canvas&&this.scene.container.appendChild(this.scene.canvas);}),Object.assign(s,{initialize:function(e){e.showDebug=!!e.showDebug,n.setOptions(this,e),this.updateTangramDebugSettings(),this.createScene(),this.hooks={},this._updating_tangram=!1;},createScene:function(){this.scene=Dh.create(this.options.scene,{numWorkers:this.options.numWorkers,preUpdate:this.options.preUpdate,postUpdate:this.options.postUpdate,continuousZoom:"1.x"===Uh.leafletVersion,wrapView:!0!==this.options.noWrap,highDensityDisplay:this.options.highDensityDisplay,logLevel:this.options.logLevel,introspection:this.options.introspection,webGLContextOptions:this.options.webGLContextOptions,disableRenderLoop:this.options.disableRenderLoop});},onAdd:function(t){var r=this;this.scene||this.createScene(),i.prototype.onAdd.apply(this,arguments),this.hooks.resize=function(){r._updating_tangram=!0,r.updateSize(),r._updating_tangram=!1;},t.on("resize",this.hooks.resize),this.hooks.move=function(){if(!r._updating_tangram){r._updating_tangram=!0,r.scene.view.setPanning(!0);var n=t.getCenter();n.zoom=Math.max(Math.min(t.getZoom(),t.getMaxZoom()||e.Geo.default_view_max_zoom),t.getMinZoom()),r.scene.view.setView(n),r._mapLayerCount>1&&r.scene.immediateRedraw(),r._updating_tangram=!1;}},t.on("move",this.hooks.move),this.hooks.moveend=function(){r.scene.view.setPanning(!1),r.scene.requestRedraw();},t.on("moveend",this.hooks.moveend),this.hooks.drag=function(){r.scene.view.markUserInput();},t.on("drag",this.hooks.drag),this._map_pane_observer=new MutationObserver(function(e){e.forEach(function(){return r.reverseTransform()});}),this._map_pane_observer.observe(t.getPanes().mapPane,{attributes:!0}),this.modifyScrollWheelBehavior(t),this.modifyZoomBehavior(t),this.trackMapLayerCounts(t),this.setupSelectionEventHandlers(t),this.setSelectionEvents(this.options.events,{radius:this.options.selectionRadius}),this.scene.container=this.getContainer(),this.updateSize(),this.updateView(),this.resizeOnFirstVisible(),this.scene.subscribe({move:this.onTangramViewUpdate.bind(this)}),this.scene.load(this.options.scene,{base_path:this.options.sceneBasePath,file_type:this.options.sceneFileType,blocking:!1}).then(function(){r._updating_tangram=!0,r.updateSize(),r.updateView(),r.reverseTransform(),r._updating_tangram=!1,r.fire("init");}).catch(function(e){r.fire("error",e);});},onRemove:function(e){i.prototype.onRemove.apply(this,arguments),e.off("layeradd layerremove overlayadd overlayremove",this._updateMapLayerCount),e.off("resize",this.hooks.resize),e.off("move",this.hooks.move),e.off("moveend",this.hooks.moveend),e.off("drag",this.hooks.drag),e.off("click",this.hooks.click),e.off("mousemove",this.hooks.mousemove),e.off("mouseout",this.hooks.mouseout),document.removeEventListener("visibilitychange",this.hooks.visibilitychange),this.hooks={},this._map_pane_observer.disconnect(),this.scene&&(this.scene.destroy(),this.scene=null);},createTile:function(e){var t=e.x+"/"+e.y+"/"+e.z,r=document.createElement("div");if(r.setAttribute("data-tile-key",t),r.style.width="256px",r.style.height="256px",this.options.showDebug){var n=document.createElement("div");n.textContent=t,n.style.position="absolute",n.style.left=0,n.style.top=0,n.style.color="white",n.style.fontSize="16px",n.style.textOutline="1px #000000",n.style.padding="8px",r.appendChild(n),r.style.borderStyle="solid",r.style.borderColor="white",r.style.borderWidth="1px";}return r},modifyScrollWheelBehavior:function(e){if(this.scene.view.continuous_zoom&&e.scrollWheelZoom&&!1!==this.options.modifyScrollWheel){e.options.zoomSnap=0;var t=e.scrollWheelZoom.enabled();e.scrollWheelZoom.disable(),n.Browser.chrome||n.Browser.safari?e.scrollWheelZoom._onWheelScroll=function(e){var t=n.DomEvent.getWheelDelta(e);this._delta+=t,this._lastMousePos=this._map.mouseEventToContainerPoint(e),this._performZoom(),n.DomEvent.stop(e);}:e.options.wheelDebounceTime=20;var i=(s=function(e){e._moveEnd(!0),e.fire("viewreset");},a=2*e.options.wheelDebounceTime,function(){var e=this,t=arguments;clearTimeout(l),l=setTimeout(function(){l=null,s.apply(e,t);},a);});Nh.scrollWheelZoom._performZoom||(Nh.scrollWheelZoom._performZoom=e.scrollWheelZoom._performZoom);var o=this;e.scrollWheelZoom._performZoom=function(){if(this._map===o._map){var e=this._map,t=e.getZoom();e._stop();var n=this._delta/(4*this._map.options.wheelPxPerZoomLevel);this._delta=0,t+n>=this._map.getMaxZoom()?n=this._map.getMaxZoom()-t:t+n<=this._map.getMinZoom()&&(n=this._map.getMinZoom()-t),n&&("center"===e.options.scrollWheelZoom?r(o,e.getCenter(),t+n):r(o,this._lastMousePos,t+n),i(e));}else Nh.scrollWheelZoom._performZoom.call(this);},t&&e.scrollWheelZoom.enable();}var s,a,l;},modifyZoomBehavior:function(e){if(this.scene.view.continuous_zoom&&!1!==this.options.modifyZoomBehavior){var t=this,i=function(t,i,o){e._stop();var s=e._zoom;i=n.latLng(i),o=void 0===o?s:o,o=Math.min(o,e.getMaxZoom());var a=Date.now(),l=75;return e._moveStart(!0),function u(){var h=(Date.now()-a)/l;h<=1?(e._flyToFrame=n.Util.requestAnimFrame(u,e),r(t,i,s+(o-s)*h)):r(t,i,o)._moveEnd(!0);}.call(e),e};if(e.doubleClickZoom){var o=e.doubleClickZoom.enabled();e.doubleClickZoom.disable(),Nh.doubleClickZoom._onDoubleClick||(Nh.doubleClickZoom._onDoubleClick=e.doubleClickZoom._onDoubleClick),e.doubleClickZoom._onDoubleClick=function(e){if(this._map===t._map){var r=this._map,n=r.getZoom(),o=r.options.zoomDelta,s=e.originalEvent.shiftKey?n-o:n+o;"center"===r.options.doubleClickZoom?i(t,r.getCenter(),s):i(t,r.containerPointToLatLng(e.containerPoint),s);}else Nh.doubleClickZoom._onDoubleClick.call(this,e);},o&&e.doubleClickZoom.enable();}e._zoomAnimated&&(Nh.map._animateZoom||(Nh.map._animateZoom=e._animateZoom),e._animateZoom=function(e,r,o,s){this===t._map?(o&&(this._animatingZoom=!0,this._animateToCenter=e,this._animateToZoom=r,i(t,e,r)),setTimeout(n.Util.bind(this._onZoomTransitionEnd,this),250)):Nh.map._animateZoom.call(this,e,r,o,s);});}},updateView:function(){var t=this._map.getCenter();t.zoom=Math.max(Math.min(this._map.getZoom(),this._map.getMaxZoom()||e.Geo.default_view_max_zoom),this._map.getMinZoom()),this.scene.view.setView(t);},updateSize:function(){var e=this._map.getSize();this.scene.resizeMap(e.x,e.y);},resizeOnFirstVisible:function(){var e=this,t=!0;this.hooks.visibilitychange=function(){t&&(t=!1,e.updateSize());},document.addEventListener("visibilitychange",this.hooks.visibilitychange);},onTangramViewUpdate:function(){if(this._map&&!this._updating_tangram){var e=this._map.getCenter(),t=this.scene.view.center;e.lng===t.lng&&e.lat===t.lat&&this._map.getZoom()===this.scene.view.zoom||(this._updating_tangram=!0,this._map.setView([this.scene.view.center.lat,this.scene.view.center.lng],this.scene.view.zoom,{animate:!1}),this._updating_tangram=!1);}},render:function(){this.scene&&this.scene.update();},reverseTransform:function(){if(this._map&&this.scene&&this.scene.container){var e=this._map.containerPointToLayerPoint([0,0]);n.DomUtil.setPosition(this.scene.container,e);}},setupSelectionEventHandlers:function(e){var t=this;this._selection_events={},this._selection_radius=null,this.hooks.click=function(e){"function"==typeof t._selection_events.click&&t.scene.getFeatureAt(e.containerPoint,{radius:t._selection_radius}).then(function(r){var n=Object.assign({},r,{leaflet_event:e});t._selection_events.click(n);});},e.on("click",this.hooks.click),this.hooks.mousemove=function(e){"function"==typeof t._selection_events.hover&&t.scene.getFeatureAt(e.containerPoint,{radius:t._selection_radius}).then(function(r){var n=Object.assign({},r,{leaflet_event:e});t._selection_events.hover(n);});},e.on("mousemove",this.hooks.mousemove),this.hooks.mouseout=function(e){"function"==typeof t._selection_events.hover&&t._selection_events.hover({changed:!0,leaflet_event:e});},e.on("mouseout",this.hooks.mouseout);},setSelectionEvents:function(e,t){var r=void 0===t?{}:t,n=r.radius;this._selection_events=Object.assign(this._selection_events,e),this._selection_radius=void 0!==n?n:this._selection_radius;},trackMapLayerCounts:function(e){var t=this;this._updateMapLayerCount=function(){var r=e.getPanes().mapPane.childNodes;t._mapLayerCount=0;for(var n=0;n<r.length;n++)t._mapLayerCount+=r[n].childNodes.length;},e.on("layeradd layerremove overlayadd overlayremove",this._updateMapLayerCount),this._updateMapLayerCount();},updateTangramDebugSettings:function(){e.mergeDebugSettings(this.options.debug||{});}}),r=function(e,t,r){var i=e._map,o=e.scene,s=i.getZoomScale(r),a=i.getSize().divideBy(2),l=t instanceof n.Point?t:i.latLngToContainerPoint(t),u=l.subtract(a).multiplyBy(1-1/s),h=i.containerPointToLatLng(a.add(u));return o&&o.view.markUserInput(),i._move(h,r,{flyTo:!0})},"function"!=typeof(Uh=i.extend(s)).remove&&(Uh.prototype.remove=function(){this._map&&this._map.removeLayer(this),this.fire("remove");}),Uh.layerBaseClass=i,Uh.leafletVersion=o,new Uh(t)}}(t)},debug:{log:e.log,yaml:kh,Utils:e.Utils,Geo:e.Geo,Vector:e.Vector,DataSource:e.DataSource,GLSL:e.GLSL,ShaderProgram:e.ShaderProgram,VertexData:e.VertexData,Texture:e.Texture,Material:e.Material,Light:e.Light,Scene:Dh,WorkerBroker:e.WorkerBroker,Task:e.Task,StyleManager:e.StyleManager,StyleParser:e.StyleParser,TileID:e.TileID,Collision:e.Collision,FeatureSelection:e.FeatureSelection,TextCanvas:e.TextCanvas,debugSettings:e.debugSettings},version:e.version}});

// Loads each of the chunks produced by the first Rollup pass.

// This allows the rollup ESM build to work within a <script type="module"> tag
// Script modules can't expose exports
try {
	Tangram.debug.ESM = false; // mark build as ES module
	Tangram.debug.SHA = 'e76e4fd4278c18dccb19ec07d7550bbb76bdd8f7';
	if (false === true && typeof window === 'object') {
	    window.Tangram = Tangram;
	}
} catch(e) {}

return Tangram;

}));
