## ----setup--------------------------------------------------------------------
library(fireproof)


## -----------------------------------------------------------------------------
basic <- guard_basic(
  validate = function(username, password) {
    username == "thomasp85" && password == "noonewillguessthis"
  }
)


## -----------------------------------------------------------------------------
key <- guard_key(
  key_name = "my-key",
  validate = Sys.getenv("FIREPROOF_SECRET")
)


## -----------------------------------------------------------------------------
google <- guard_google(
  redirect_url = "https://my-app.com/auth",
  client_id = "MY_APP",
  client_secret = Sys.getenv("MY_APP_SECRET")
)


## -----------------------------------------------------------------------------
fp <- Fireproof$new()

fp$add_guard(basic, name = "basic_auth")
fp$add_guard(key, name = "key_auth")
fp$add_guard(google, name = "google_auth")

fp


## -----------------------------------------------------------------------------
app <- fiery::Fire$new()

fs <- firesale::FireSale$new(storr::driver_environment())
app$attach(fs)

# The app is now ready to use the fireproof plugin
app$attach(fp)


## -----------------------------------------------------------------------------
fp$add_auth(
  method = "all", 
  path = "/*",
  flow = basic_auth # Assuming you are using the basic guard we defined above
)


## -----------------------------------------------------------------------------
fp$add_auth(
  method = "get",
  path = "/public/*",
  flow = NULL
)


## -----------------------------------------------------------------------------
fp$add_auth(
  method = "get",
  path = "/basic_or_key",
  flow = basic_auth || key_auth
)


## -----------------------------------------------------------------------------
fp$add_auth(
  method = "get",
  path = "/sensitive/*",
  flow = google_auth || (basic_auth && key_auth)
)


## -----------------------------------------------------------------------------
basic <- guard_basic(
  validate = function(username, password) {
    if (username == "thomasp85" && password == "noonewillguessthis") {
      c("read", "write")
    } else {
      FALSE
    }
  }
)
# Replace old guard
fp$add_guard(basic, name = "basic_auth")


## -----------------------------------------------------------------------------
fp$add_auth(
  method = "post",
  path = "/settings",
  flow = basic_auth,
  scope = "write"
)


## -----------------------------------------------------------------------------
basic <- guard_basic(
  validate = function(username, password) {
    if (username == "thomasp85" && password == "noonewillguessthis") {
      c("read", "write")
    } else {
      FALSE
    }
  },
  user_info = function(user) {
    # You'd probably have a database lookup here
    new_user_info(
      id = user,
      name_given = "Thomas",
      name_family = "Pedersen",
      favourite_color = "pink"
    )
  }
)
# Replace old guard
fp$add_guard(basic, name = "basic_auth")


## -----------------------------------------------------------------------------
route <- routr::Route$new()
route$add_handler(
  method = "get", 
  path = "/hello",
  handler = function(request, response, arg_list, ...) {
    user_info <- arg_list$datastore$session$fireproof$basic_auth
    response$body <- paste0("Hi ", user_info$name$given)
    response$status <- 200L
    response$type <- "text/plain"
    TRUE
  }
)


## -----------------------------------------------------------------------------
route$add_handler(
  method = "post", 
  path = "/logout",
  handler = function(request, response, arg_list, ...) {
    arg_list$datastore$session$fireproof$basic_auth <- NULL
    response$status_with_text(200L)
    TRUE
  }
)

