/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import lombok.NonNull;

public class Uniform
implements ContinuousDistribution {
    private final double min;
    private final double max;

    public Uniform(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getDensity(double x) throws DStatException {
        if (this.min >= this.max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        return 1.0 / (this.max - this.min);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uniform distribution with Lower bound = ");
        sb.append(this.min);
        sb.append(" and Upper bound = ");
        sb.append(this.max);
        return sb.toString();
    }

    public double getExpectation() {
        return (this.max - this.min) / 2.0;
    }

    public double getLeftBound() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        if (this.min >= this.max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        if (x < this.min || x > this.max) {
            throw new DStatException("The argument must lie between Min and Max", "Uniform");
        }
        double res = (x - this.min) / (this.max - this.min);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        if (p < 0.0 || p > 1.0) {
            throw new DStatException("x mus respect 0.0 <= x <= 1.0", "Uniform");
        }
        if (this.min >= this.max) {
            throw new DStatException("Min must be strictly smaller than Max", "Uniform");
        }
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        return p * (this.max - this.min) + this.min;
    }

    public double getRightBound() {
        return this.max;
    }

    public double getVariance() {
        return ((this.max - this.min + 1.0) * (this.max - this.min) - 1.0) / 12.0;
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.Finite;
    }

    public boolean isSymmetrical() {
        return true;
    }

    public double random(@NonNull RandomNumberGenerator rng) throws DStatException {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return this.min + rng.nextDouble() * (this.max - this.min);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("U(");
        sb.append(this.min);
        sb.append(',');
        sb.append(this.max);
        sb.append(')');
        return sb.toString();
    }
}

