/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.reebgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import usf.saav.topology.TopoGraph;
import usf.saav.topology.reebgraph.ReebGraphVertex;

public class ReebGraph
extends TopoGraph<ReebGraphVertex> {
    private static final long serialVersionUID = 2799501955753168490L;

    public ReebGraph() {
    }

    public ReebGraph(Collection<ReebGraphVertex> collection) {
        this.addAll(collection);
        this.resetInternalIDs();
        this.resetInternalValues();
    }

    public void resetInternalIDs() {
        int n = 0;
        for (TopoGraph.Vertex vertex : this) {
            ((ReebGraphVertex)vertex).setID(n++);
        }
    }

    public void resetInternalValues() {
        ArrayList<ReebGraphVertex> arrayList = this.getNodesSortedByValue();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).setValue(i);
        }
    }

    public ArrayList<ReebGraphVertex> getNodesSortedByValue() {
        ArrayList<ReebGraphVertex> arrayList = new ArrayList<ReebGraphVertex>();
        for (TopoGraph.Vertex vertex : this) {
            arrayList.add((ReebGraphVertex)vertex);
        }
        arrayList.sort(new Comparator<ReebGraphVertex>(this){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.value() < reebGraphVertex2.value()) {
                    return -1;
                }
                if (reebGraphVertex.value() > reebGraphVertex2.value()) {
                    return 1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    public String toDot() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            ReebGraphVertex reebGraphVertex = (ReebGraphVertex)this.get(i);
            stringBuffer.append("\t" + reebGraphVertex.getID() + "[label=\"" + reebGraphVertex.toString() + "\"];\n");
            for (TopoGraph.Vertex vertex : reebGraphVertex.neighbors()) {
                for (int j = 0; j < this.size(); ++j) {
                    ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)this.get(j);
                    if (reebGraphVertex2 != vertex || !(reebGraphVertex2.value() < reebGraphVertex.value())) continue;
                    stringBuffer2.append("\t" + reebGraphVertex.getID() + " -> " + reebGraphVertex2.getID() + "\n");
                }
            }
        }
        return "Digraph{\n" + String.valueOf(stringBuffer) + String.valueOf(stringBuffer2) + "}";
    }
}

