## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#  #% Define Macro Variables
#  #%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#  #%let sponsor_name <- Acme
#  #%let study_name <- ABC
#  #%let prog_name <- l_dm
#  #%let base_dir <- c:/packages/macro/tests/testthat/examples
#  #%let output_dir <- &base_dir./output
#  #%let data_dir <- &base_dir./data
#  #%let data_file <- dm.rda
#  #%let titles <- c("Listing 1.0", "SDTM Demographics")
#  #%let footnotes <- c("Program: &prog_name..R")
#  
#  #%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#  #% Pull in listing template code
#  #%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#  #%include '&base_dir./templates/lst01.R'

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #####################################################################
#  # Program Name: &prog_name.
#  # Study: &study_name.
#  #####################################################################
#  
#  library(reporter)
#  
#  # Output path
#  out_pth <- "&output_dir./&prog_name."
#  
#  # Get listing data
#  load("&data_dir./&data_file.")
#  
#  # Create table object
#  tbl <- create_table(dm) |>
#    define(USUBJID, id_var = TRUE)
#  
#  # Create report object
#  rpt <- create_report(out_pth, font = "Courier", output_type = "RTF") |>
#    page_header("Sponsor: &sponsor_name.", "Study: &study_name.") |>
#    titles(`&titles.`) |>
#    add_content(tbl, align = "left") |>
#    footnotes(`&footnotes.`) |>
#    page_footer(Sys.time(), "CONFIDENTIAL", "Page [pg] of [tpg]")
#  
#  # Write report to file
#  write_report(rpt)
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  msource("./macro/Example1.R", "./macro/code/l_dm1.R")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #####################################################################
#  # Program Name: l_dm
#  # Study: ABC
#  #####################################################################
#  
#  library(reporter)
#  
#  # Output path
#  out_pth <- "c:/packages/macro/tests/testthat/examples/output/l_dm"
#  
#  # Get listing data
#  load("c:/packages/macro/tests/testthat/examples/data/dm.rda")
#  
#  # Create table object
#  tbl <- create_table(dm) |>
#    define(USUBJID, id_var = TRUE)
#  
#  # Create report object
#  rpt <- create_report(out_pth, font = "Courier", output_type = "RTF") |>
#    page_header("Sponsor: Acme", "Study: ABC") |>
#    titles(c("Listing 1.0", "SDTM Demographics")) |>
#    add_content(tbl, align = "left") |>
#    footnotes(c("Program: l_dm.R")) |>
#    page_footer(Sys.time(), "CONFIDENTIAL", "Page [pg] of [tpg]")
#  
#  # Write report to file
#  write_report(rpt)
#  

