/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.util.collection.WeakHashSet;

public final class Fraction
extends Number
implements Comparable<Fraction>,
Serializable {
    private static final long serialVersionUID = -4501644254763471216L;
    private static final WeakHashSet<Fraction> POOL = new WeakHashSet<Fraction>(Fraction.class);
    public final int numerator;
    public final int denominator;
    private static final char[][] UNICODES = new char[][]{{'\u0000', '\u0000', '\u2189'}, {'\u00bd', '\u2153', '\u00bc', '\u2155', '\u2159', '\u2150', '\u215b', '\u2151', '\u2152'}, {'\u2154', '\u0000', '\u2156'}, {'\u00be', '\u2157', '\u0000', '\u0000', '\u215c'}, {'\u2158'}, {'\u215a', '\u0000', '\u215d'}, new char[0], {'\u215e'}};

    public Fraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public Fraction unique() {
        return POOL.unique(this);
    }

    public Fraction simplify() {
        return this.simplify(this.numerator, this.denominator);
    }

    private Fraction simplify(long l, long l2) {
        if (l == Long.MIN_VALUE || l2 == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        if (l == 0L) {
            l2 = Long.signum(l2);
        } else if (l2 == 0L) {
            l = Long.signum(l);
        } else if (l2 % l == 0L) {
            if ((l2 /= l) < 0L) {
                l2 = -l2;
                l = -1L;
            } else {
                l = 1L;
            }
        } else {
            long l3;
            long l4 = Math.abs(l);
            long l5 = l4 % (l3 = Math.abs(l2));
            if (l5 == 0L) {
                l /= l2;
                l2 = 1L;
            } else {
                while ((l5 = (l4 = l3) % (l3 = l5)) != 0L) {
                }
                l /= l3;
                if ((l2 /= l3) < 0L) {
                    l = -l;
                    l2 = -l2;
                }
            }
        }
        return l == (long)this.numerator && l2 == (long)this.denominator ? this : new Fraction(JDK8.toIntExact(l), JDK8.toIntExact(l2));
    }

    public Fraction negate() {
        return this.numerator == 0 ? this : new Fraction(-this.numerator, this.denominator);
    }

    public Fraction add(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return this.simplify(JDK8.addExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction subtract(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return this.simplify(JDK8.subtractExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction multiply(Fraction fraction) {
        return this.simplify((long)this.numerator * (long)fraction.numerator, (long)this.denominator * (long)fraction.denominator);
    }

    public Fraction divide(Fraction fraction) {
        return this.simplify((long)this.numerator * (long)fraction.denominator, (long)this.denominator * (long)fraction.numerator);
    }

    public int round() {
        int n;
        if (this.denominator == Integer.MIN_VALUE) {
            if (this.numerator < -1073741824) {
                return 1;
            }
            if (this.numerator > 0x40000000) {
                return -1;
            }
            return 0;
        }
        int n2 = this.numerator / this.denominator;
        int n3 = this.numerator % this.denominator;
        if (n3 != 0 && ((n3 = Math.abs(n3 << 1)) > (n = Math.abs(this.denominator)) || n3 == n && (n2 & 1) != 0)) {
            n2 = (this.numerator ^ this.denominator) >= 0 ? ++n2 : --n2;
        }
        return n2;
    }

    public int floor() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) < 0 && this.numerator % this.denominator != 0) {
            --n;
        }
        return n;
    }

    public int ceil() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) >= 0 && this.numerator % this.denominator != 0) {
            ++n;
        }
        return n;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public short shortValue() {
        int n = this.intValue();
        if ((n & 0xFFFF0000) == 0) {
            return (short)n;
        }
        throw new ArithmeticException();
    }

    @Override
    public byte byteValue() {
        int n = this.intValue();
        if ((n & 0xFFFFFF00) == 0) {
            return (byte)n;
        }
        throw new ArithmeticException();
    }

    @Override
    public int compareTo(Fraction fraction) {
        return Long.signum((long)this.numerator * (long)fraction.denominator - (long)fraction.numerator * (long)this.denominator);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fraction) {
            Fraction fraction = (Fraction)object;
            return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
        }
        return false;
    }

    public int hashCode() {
        return this.numerator + 31 * this.denominator ^ 0xA9A52E90;
    }

    public String toString() {
        switch (this.denominator) {
            case 0: {
                if (this.numerator == 0) break;
                return this.numerator >= 0 ? "\u221e" : "\u2212\u221e";
            }
            case 1: {
                return String.valueOf(this.numerator);
            }
            default: {
                char c;
                char[] cArray;
                int n;
                if (this.numerator < 0 || this.numerator >= UNICODES.length || (n = this.denominator - this.numerator - 1) < 0 || n >= (cArray = UNICODES[this.numerator]).length || (c = cArray[n]) == '\u0000') break;
                return String.valueOf(c);
            }
        }
        return "" + this.numerator + '\u2044' + this.denominator;
    }
}

