# Generated by default/object.tt
package Paws::Appflow::SourceFieldProperties;
  use Moose;
  has IsQueryable => (is => 'ro', isa => 'Bool', request_name => 'isQueryable', traits => ['NameInRequest']);
  has IsRetrievable => (is => 'ro', isa => 'Bool', request_name => 'isRetrievable', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::SourceFieldProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::SourceFieldProperties object:

  $service_obj->Method(Att1 => { IsQueryable => $value, ..., IsRetrievable => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::SourceFieldProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->IsQueryable

=head1 DESCRIPTION

The properties that can be applied to a field when the connector is
being used as a source.

=head1 ATTRIBUTES


=head2 IsQueryable => Bool

Indicates if the field can be queried.


=head2 IsRetrievable => Bool

Indicates whether the field can be returned in a search result.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

