package Venus::True;

use 5.018;

use strict;
use warnings;

# IMPORTS

use Scalar::Util ();

# STATE

state $true = Scalar::Util::dualvar(1, "1");

# OVERLOADS

use overload (
  '!' => sub{!$true},
  'bool' => sub{$true},
  fallback => 1,
);

# METHODS

sub new {
  return bless({});
}

sub value {
  return $true;
}

1;



=head1 NAME

Venus::True - True Class

=cut

=head1 ABSTRACT

True Class for Perl 5

=cut

=head1 SYNOPSIS

  package main;

  use Venus::True;

  my $true = Venus::True->new;

  # $true->value;

=cut

=head1 DESCRIPTION

This package provides the global C<true> value used in L<Venus::Boolean> and
the L<Venus/true> function.

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 new

  new() (Venus::True)

The new method constructs an instance of the package.

I<Since C<4.15>>

=over 4

=item new example 1

  package main;

  use Venus::True;

  my $new = Venus::True->new;

  # bless(..., "Venus::True")

=back

=cut

=head2 value

  value() (boolean)

The value method returns value representing the global C<true> value.

I<Since C<1.23>>

=over 4

=item value example 1

  # given: synopsis;

  my $value = $true->value;

  # 1

=back

=cut

=head1 AUTHORS

Awncorp, C<awncorp@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2022, Awncorp, C<awncorp@cpan.org>.

This program is free software, you can redistribute it and/or modify it under
the terms of the Apache license version 2.0.

=cut