package Mojolicious::Plugin::Crud;
use Mojo::Base 'Mojolicious::Plugin';

use Lingua::EN::Inflect qw/PL/;
use Mojo::Util qw( camelize );

#------------------------------------------------------------------------------
#   Crud 版本信息
#------------------------------------------------------------------------------
our $VERSION = '0.0.4';

#------------------------------------------------------------------------------
#   Crud 插件注册方法
#------------------------------------------------------------------------------
sub register {
  my ( $self, $app ) = @_;

  #------------------------------------------------------
  # 注册 routes 快捷指令，接收定制属性
  #------------------------------------------------------
  $app->routes->add_shortcut(
    api_routes => sub {
      my $r      = shift;
      my $params = { @_ ? ( ref $_[0] ? %{ $_[0] } : @_ ) : () };

      #------------------------------------------------------
      # 提取参数
      #------------------------------------------------------
      my $name       = $params->{name} or die "Parameter 'name' missing";
      my $readonly   = $params->{readonly} || 0;
      my $controller = $params->{controller} || $name;

      #------------------------------------------------------
      # 转换为 controller 格式
      #------------------------------------------------------
      $controller = camelize($controller);

      #------------------------------------------------------
      # 生成复数类型路由，并转换为小写 URI
      #------------------------------------------------------
      my $route_part = $params->{route} || PL( $name, 10 );
      $route_part = lc($route_part);

      $app->log->info( "Creating restful routes for resource '$name' (controller: " . camelize($controller) . ")" );

      #------------------------------------------------------
      # 生成路由后丢给控制器
      #------------------------------------------------------
      my $resource = $r->route("/$route_part")->to( "controller" => $controller );

      #------------------------------------------------------
      # 接收 GET 请求，对应前端数据查询请求
      #------------------------------------------------------
      $resource->get->to('#get')->name("get_$route_part");
      $app->log->debug( " GET " . $r->to_string . "/$route_part  (api_get)" );

      #------------------------------------------------------
      # 接收 POST 请求，对应前端新增数据请求
      #------------------------------------------------------
      if ( !$readonly ) {
        $resource->post->to('#create')->name("create_$name");
        $app->log->debug( " POST " . $r->to_string . "/$route_part  (api_create)" );
      }

      #------------------------------------------------------
      # 处理 "/$name/:id" 样式路由，GET DELETE PUT
      #------------------------------------------------------
      $resource = $r->under(
        "/$route_part/:${name}id" => sub {
          my ($c) = @_;
          $c->app->log->debug(
            sprintf( "Feeding ID into stash: \$c->stash('fm.ids')->{'%s'} = %s", $name, $c->param("${name}id") ) );
          $c->stash( 'fm.ids' => {} ) unless $c->stash('fm.ids');
          $c->stash('fm.ids')->{$name} = $c->param("${name}id");
          return 1;
        }
      )->to( controller => $controller, idname => "${name}id" );

      #------------------------------------------------------
      # 接收 GET 请求，处理单 id 数据查询
      #------------------------------------------------------
      $resource->get->to("#show")->name("show_$name");
      $app->log->debug( " GET " . $r->to_string . "/$route_part/:${name}id  (api_show)" );

      if ( !$readonly ) {

        #------------------------------------------------------
        # 接收 DELETE 请求，对应前端删除数据请求
        #------------------------------------------------------
        $resource->delete->to('#delete')->name("delete_$name");
        $app->log->debug( " DELETE " . $r->to_string . "/$route_part/:${name}id  (api_delete)" );

        #------------------------------------------------------
        # 接收 PUT 请求，对应前端更新数据请求
        #------------------------------------------------------
        $resource->put->to('#update')->name("update_$name");
        $app->log->debug( " PUT " . $r->to_string . "/$route_part/:${name}id  (api_update)" );
      }

      #------------------------------------------------------
      # 返回 "/$name/:id" 样式路由
      #------------------------------------------------------
      return $resource;
    }
  );
}

1;
