/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinMuiltdimStructure
implements Join {
    StructureDS parentStructure;
    ArrayStructure parentData;
    int dimLength;

    public JoinMuiltdimStructure(StructureDS parentStructure, int dimLength) {
        this.parentStructure = parentStructure;
        this.dimLength = dimLength;
        try {
            this.parentData = (ArrayStructure)parentStructure.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public StructureData getJoinData(Cursor cursor) {
        int recnum = cursor.recnum[0] / this.dimLength;
        return this.parentData.getStructureData(recnum);
    }

    @Override
    public VariableDS findVariable(String axisName) {
        return (VariableDS)this.parentStructure.findVariable(axisName);
    }

    @Override
    public Variable getExtraVariable() {
        return null;
    }

    public String toString() {
        return "JoinMuiltdimStructure{parentStructure=" + this.parentStructure + ", dimLength='" + this.dimLength + '}';
    }
}

