# Generated by default/object.tt
package Paws::S3Control::S3SetObjectRetentionOperation;
  use Moose;
  has BypassGovernanceRetention => (is => 'ro', isa => 'Bool');
  has Retention => (is => 'ro', isa => 'Paws::S3Control::S3Retention', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::S3SetObjectRetentionOperation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::S3SetObjectRetentionOperation object:

  $service_obj->Method(Att1 => { BypassGovernanceRetention => $value, ..., Retention => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::S3SetObjectRetentionOperation object:

  $result = $service_obj->Method(...);
  $result->Att1->BypassGovernanceRetention

=head1 DESCRIPTION

Contains the configuration parameters for the Object Lock retention
action for an S3 Batch Operations job. Batch Operations passes every
object to the underlying C<PutObjectRetention> API. For more
information, see Using S3 Object Lock retention with S3 Batch
Operations
(https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
in the I<Amazon S3 User Guide>.

=head1 ATTRIBUTES


=head2 BypassGovernanceRetention => Bool

Indicates if the action should be applied to objects in the Batch
Operations job even if they have Object Lock C< GOVERNANCE> type in
place.


=head2 B<REQUIRED> Retention => L<Paws::S3Control::S3Retention>

Contains the Object Lock retention mode to be applied to all objects in
the Batch Operations job. For more information, see Using S3 Object
Lock retention with S3 Batch Operations
(https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
in the I<Amazon S3 User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

