# Generated by default/object.tt
package Paws::LexModelsV2::IntentConfirmationSetting;
  use Moose;
  has DeclinationResponse => (is => 'ro', isa => 'Paws::LexModelsV2::ResponseSpecification', request_name => 'declinationResponse', traits => ['NameInRequest'], required => 1);
  has PromptSpecification => (is => 'ro', isa => 'Paws::LexModelsV2::PromptSpecification', request_name => 'promptSpecification', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::IntentConfirmationSetting

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::IntentConfirmationSetting object:

  $service_obj->Method(Att1 => { DeclinationResponse => $value, ..., PromptSpecification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::IntentConfirmationSetting object:

  $result = $service_obj->Method(...);
  $result->Att1->DeclinationResponse

=head1 DESCRIPTION

Provides a prompt for making sure that the user is ready for the intent
to be fulfilled.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DeclinationResponse => L<Paws::LexModelsV2::ResponseSpecification>

When the user answers "no" to the question defined in
C<promptSpecification>, Amazon Lex responds with this response to
acknowledge that the intent was canceled.


=head2 B<REQUIRED> PromptSpecification => L<Paws::LexModelsV2::PromptSpecification>

Prompts the user to confirm the intent. This question should have a yes
or no answer.

Amazon Lex uses this prompt to ensure that the user acknowledges that
the intent is ready for fulfillment. For example, with the
C<OrderPizza> intent, you might want to confirm that the order is
correct before placing it. For other intents, such as intents that
simply respond to user questions, you might not need to ask the user
for confirmation before providing the information.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

