# Generated by default/object.tt
package Paws::NetworkFirewall::SubnetMapping;
  use Moose;
  has SubnetId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::SubnetMapping

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::SubnetMapping object:

  $service_obj->Method(Att1 => { SubnetId => $value, ..., SubnetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::SubnetMapping object:

  $result = $service_obj->Method(...);
  $result->Att1->SubnetId

=head1 DESCRIPTION

The ID for a subnet that you want to associate with the firewall. This
is used with CreateFirewall and AssociateSubnets. AWS Network Firewall
creates an instance of the associated firewall in each subnet that you
specify, to filter traffic in the subnet's Availability Zone.

=head1 ATTRIBUTES


=head2 B<REQUIRED> SubnetId => Str

The unique identifier for the subnet.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

