#!/usr/bin/env perl

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../lib";

use SMS::API::VoIP::MS;

die "Usage: $0 <login> <api_key> <did> <from_date> [to_date]\n"
    if !@ARGV || @ARGV < 4;

my ( $username, $key, $did, $from, $to ) = @ARGV;

my $obj = SMS::API::VoIP::MS->new(
    username => $username,
    api_key  => $key,
    did      => $did,
);

my @msgs = $obj->get_mms(
    from => $from,
    
    $to ? ( to => $to ) : (),
);

use Data::Dumper;
warn Dumper @msgs;
