#!/usr/bin/perl

# Unit testing for PPI, generated by Test::Inline

use strict;
use File::Spec::Functions ':ALL';
BEGIN {
	$|  = 1;
	$^W = 1;
	$PPI::XS_DISABLE = 1;
	$PPI::XS_DISABLE = 1; # Prevent warning
}
use PPI;

# Execute the tests
use Test::More tests => 9;

# =begin testing 9
{
my $doc1 = new_ok( 'PPI::Document' => [ \'1.2.3.4'  ] );
my $doc2 = new_ok( 'PPI::Document' => [ \'v1.2.3.4' ] );
isa_ok( $doc1->child(0), 'PPI::Statement' );
isa_ok( $doc2->child(0), 'PPI::Statement' );
isa_ok( $doc1->child(0)->child(0), 'PPI::Token::Number::Version' );
isa_ok( $doc2->child(0)->child(0), 'PPI::Token::Number::Version' );

my $literal1 = $doc1->child(0)->child(0)->literal;
my $literal2 = $doc2->child(0)->child(0)->literal;
is( length($literal1), 4, 'The literal length of doc1 is 4' );
is( length($literal2), 4, 'The literal length of doc1 is 4' );
is( $literal1, $literal2, 'Literals match for 1.2.3.4 vs v1.2.3.4' );
}


1;
