# Contributing

This is open-source software and as such may be contributed to either
directly or indirectly. Thank you for contributing. Please use the
methods outlined here to contribute in order to make the process as
smooth as possible for everyone involved.

## Ideas or Information

Perhaps the most common way to contribute is with ideas or information.
You might have a suggestion for a new feature or a cleaner interface.
You might have spotted a bug in the functionality or an error (even if
just a typo) in the documentation. You might know of a related project
with which there could be collaboration. These and many more should be
raised in the first instance on the [CPAN
RT](https://rt.cpan.org/NoAuth/Bugs.html?Dist=WebService-AbuseIPDB).

### General comments

Visit [RT](https://rt.cpan.org/NoAuth/Bugs.html?Dist=WebService-AbuseIPDB)
and have a look through the existing issues (both open and resolved) to
make sure that there is not already a ticket dealing with the point you
were going to make.

Submit your comment or suggestion with as much specificity and detail
as you can and please try to accompany any suggestions with a rationale.

Please make your point in English. Tickets raised in other languages
will most likely be subject to automated translation and thus some loss
of integrity.

### Bugs

Bug reports should also be submitted via
[RT](https://rt.cpan.org/NoAuth/Bugs.html?Dist=WebService-AbuseIPDB)
as above. A bug report is more likely to receive extensive and timely
attention if it includes the following:

- The version(s) of the dist/module exhibiting the problem
- The version(s) of perl being used
- The Operating System name and version being used
- Any pertinent details of the environment
- Full, exact detail of any input
- Full, exact detail of any output
- Full, exact detail of any warnings, errors or diagnostic messages
- In what way the operation deviates from your expectations

If you are a programmer, it would also be very beneficial to have the
following:

- A test script demonstrating the bug
- A patch to fix it
- A merge request (see the section on contributing code below)

Submitters of high quality bug reports will be acknowledged in future
releases.

## Code

If you are reading this section then thank you very much for even
considering contributing code to this project. Here are some guidelines
to ensure a harmonious community of contributors.

- Please get in touch, ideally via
  [RT](https://rt.cpan.org/NoAuth/Bugs.html?Dist=WebService-AbuseIPDB) as
  above, to outline what it is
  that you plan to contribute in advance. This avoids duplication of
  effort and will help to decide what can and should become part of this
  dist and what might benefit from being developed separately.
- If it is agreed for you to contribute then the easiest way is to clone
  the [public repository](https://gitlab.com/openstrike/abuseipdb-client)
  and then submit a merge request. Please base your work against the
  current release branch, not the master, eg. if the most recent, stable
  release is 0.03 then there should be a branch numbered 0.04 for work
  in progress.
- If you do not use git or gitlab then you may submit a patch via RT
  instead.
- Please accompany your code with tests (we like full coverage where
  practical) and documentation. A merge request or patch with no tests
  and no docs is unlikely to be accepted, sorry.
- Please conform to the existing coding styles - use the .perltidyrc if
  in any doubt. (if the .perltidyrc is missing, please raise a ticket!)

## Exposure/Kudos

This is a small project and would benefit from wider exposure. If you
like the project (aims, style, concept, etc.) do please consider one or
more of these methods of bringing it to the attention of a wider
audience.

- **Votes.** There are a number of ways you can boost the project with a
  single click:

	* ++ at MetaCPAN
	* Star at GitLab

- **Social media.** It's the highlight/bane of the modern web (delete as
  appropriate). Just a short
  message to say you use this dist is a great start. There are places to
  post longer pieces (critiques, examples, comparisons, use cases, reviews)
  such as
  [blogs.perl.org](https://blogs.perl.org/), [PerlMonks
  Reviews](https://www.perlmonks.org/?node_id=31673;reviewtype=module),
  [Dev](https://dev.to/), etc.
- **Blogs, vlogs and podcasts.** If you have your own blog (with audio,
  video or (gasp!) just the written word) why not tell your audience
  about this dist you've been using?
- **Talks.** Consider a short talk at your local [Perl
  Mongers](https://www.pm.org/) group, your workplace or at a
  workshop/conference.
- **Code.** Release your own code which uses this project as open
  source.

## Lucre

Whisper it quietly: free as in beer rarely pays the bills. While we are
not in this to get rich quick, a little recompense would go a long way.
If you would like to contribute in a monetary form then please consider
donating in one of these ways.

- Donate to
  [TPF](https://www.perlfoundation.org/donate.html),
  [EFF](https://www.eff.org/pages/other-ways-give-and-donor-support),
  [OSI](https://opensource.org/civicrm/contribute/transact?reset=1&id=2),
  [FSF](https://www.fsf.org/donate/) or any other relevant TLA which
  appeals to you. Paying it forward like this is great for the community
  at large.
- Sponsor development. If there is a major feature you would like but
  which we do not consider meritorious enough to pursue gratis, consider
  sponsorship.
- Send us some swag! Contact details are at
  [https://www.openstrike.co.uk/aboutus.html](https://www.openstrike.co.uk/aboutus.html)
