% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.t.R
\name{stat.t}
\alias{stat.t}
\title{T-test on data frame}
\usage{
stat.t(
  ant,
  formula,
  alternative = "two.sided",
  na.action = na.omit,
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  progress = TRUE
)
}
\arguments{
\item{ant}{an output of ANT function \code{\link{perm.net.nl}} without any random factor declared, or output of ANT 'met' categories functions in which output of ANT functions \code{\link{perm.ds.focal}}, \code{\link{perm.ds.grp}} or \code{\link{perm.net.lk}} where single matrix have been used.}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs a factor with two levels giving the corresponding groups.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}

\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test).}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{progress}{a boolean indicating the visualization of the permutation process.}
}
\value{
a data frame with 2 columns: the t statistic, the met.degree of freedom, the confidence interval for var1 and 2, and the estimates for var1 and var2
}
\description{
Performs correlations T-test through observed and permuted data to calculate the p-value on the posterior distribution
}
\details{
t-test on permuted data allows to extract the posterior distribution of the value of interest. The posterior distribution allows to calculate the p-value. For more details about t-tests, see R documentation.
}
\examples{
t=met.strength(sim.m,sim.df,1) # Computing network metric
t=perm.net.nl(t,labels='age',rf=NULL,nperm=10,progress=FALSE) # Node label permutations
r.t=stat.t(t,formula = strength ~ sex,progress=FALSE) # Permuted t-test
}
\seealso{
\code{\link[stats]{t.test}}
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
